//! # Cards
//!
//! This module contains types to do with cards.

use serde::{Deserialize, Serialize};

/// A card is a simple type containing a question and an answer.
///
/// Scores and the like will be stored by an [`App`](crate::App)
#[derive(Debug, Clone, Serialize, Deserialize, Hash, Eq, PartialEq)]
pub struct Card {
    /// The question of the [`Card`]
    pub question: String,
    /// The answer to the question of the [`Card`]
    pub answer: String,
}
