use std::path::PathBuf;

use clap::Parser;

#[derive(Parser, Debug, Clone)]
pub struct Opts {
    /// The input file - in json
    pub input: PathBuf,
    /// If enabled all card scores will be reset
    #[clap(long, short)]
    pub reset: bool,
    /// Prevents the game from writing to a save
    #[clap(long, short)]
    pub nowrite: bool,
    /// How many cards to be testing on at once
    #[clap(long, short)]
    pub testing: Option<usize>,
}
