use std::borrow::Cow;

use chrono::{DateTime, Utc};
use serde::{Deserialize, Serialize};

use crate::app::App;
use crate::card::Card;

/// A scores struct which serde can deal with to
#[derive(Debug, Clone, Serialize, Deserialize)]
pub struct Scores<'a> {
    pub scores: Vec<(Cow<'a, Card>, usize)>,
    pub dues: Vec<(Cow<'a, Card>, DateTime<Utc>)>,
}

impl<'a> From<&'a App> for Scores<'a> {
    fn from(app: &'a App) -> Self {
        Self {
            scores: {
                let mut scores = Vec::new();

                // Loops through all the scores and references
                // the card (if it exists) into the hashmap.
                for (card, score) in app.scores() {
                    if let Some(card) = app.cards().get(*card) {
                        scores.push((Cow::Borrowed(card), *score));
                    }
                }

                scores
            },
            dues: {
                let mut dues = Vec::new();

                // Loops through all the dues and references
                // the card (if it exists) into the hashmap.
                for (card, due) in app.dues() {
                    if let Some(card) = app.cards().get(*card) {
                        dues.push((Cow::Borrowed(card), *due));
                    }
                }

                dues
            },
        }
    }
}
