use proc_macro::TokenStream;
use quote::quote;
use syn::{ItemFn, ItemStruct};

#[proc_macro_attribute]
pub fn component(attr: TokenStream, item: TokenStream) -> TokenStream {
    let builtin = attr.to_string() == "builtin";

    let component: ItemStruct = syn::parse(item.clone()).unwrap();
    let name = &component.ident;

    let mut expanded: TokenStream = if builtin {
        quote! {
            impl crate::components::Component for #name {

            }
        }
    } else {
        quote! {
            impl flak_ecs::components::Component for #name {

            }
        }
    }
    .into();
    expanded.extend(item);
    expanded
}

#[proc_macro_attribute]
pub fn system(_attr: TokenStream, item: TokenStream) -> TokenStream {
    let name = {
        let ItemFn { sig, .. } = syn::parse(item.clone()).unwrap();
        sig.ident
    };

    let mut expanded: TokenStream = quote! {

        use flak_ecs::systems::inventory;
        inventory::submit! {
            flak_ecs::systems::System::new(#name)
        }

    }
    .into();
    expanded.extend(item);
    expanded
}
