extern crate flag_algebra;

use flag_algebra::*;
use flags::Graph;
use operator::Basis;
use sdp::Problem;


type V = QFlag<f64, Graph>;
    
#[allow(dead_code, unused_variables)]
pub fn main() {
    init_default_log();
    
    // Work on the graphs of size 3.
    let b = Basis::new(4);

    // Define useful flags.
    //let k5: V = flag(&Graph::clique(5)).expand(b);
    let k4: V = flag(&Graph::clique(4)).expand(b);
    let triangle: V = flag(&Graph::new(3, &[(0, 1), (1, 2), (2, 0)])).expand(b);
    let edge: V = flag(&Graph::new(2, &[(0, 1)])).expand(b);

    let delta = 0.4;
    // Definition of the optimization problem.
    let pb = Problem::<f64, _> {
        // Constraints
        ineqs: vec![
            total_sum_is_one(b),
            flags_are_nonnegative(b),
            edge.equal(delta),
        ],
        // Use all relevant Cauchy-Schwarz inequalities.
        cs: b.all_cs(),
        // Minimize minus density of edges expressed in the basis of flags of
        // size 3.
        obj: -triangle + k4,
    }.no_scale();

    // Write the correspondind SDP program in "turan.sdpa".
    // This program can then be solved by CSDP.
    pb.write_sdpa("turan").unwrap();
    println!("{} / {}", delta.powf(1.5)-delta.powf(2.), delta.powf(1.5));

    let mut f = FlagSolver::new(pb, "strong").protect(0);
    f.minimize2();
}
