use assert_cmd::prelude::*;
use predicates::prelude::*;
use std::io::Write;
use std::process::Command;
use tempfile::NamedTempFile;

type Res = Result<(), Box<dyn std::error::Error>>;

#[test]
fn file_doesnt_exist() -> Res {
    let mut cmd = Command::cargo_bin("grrs")?;
    cmd.arg("foobar").arg("foobar");
    cmd.assert()
        .failure()
        .stderr(predicate::str::contains("Could not read"));

    Ok(())
}

#[test]
fn find_content_in_file() -> Res {
    let mut file = NamedTempFile::new()?;
    writeln!(file, "A test\nActual content\nMore content\nAnother test")?;

    let mut cmd = Command::cargo_bin("grrs")?;
    cmd.arg("test").arg(file.path());
    cmd.assert()
        .success()
        .stdout(predicate::str::contains("test\nAnother test"));

    Ok(())
}

#[test]
fn empty_string_cause_error() -> Res {
    let mut file = NamedTempFile::new()?;
    writeln!(file, "A test\nActual content\nMore content\nAnother test")?;

    let mut cmd = Command::cargo_bin("grrs")?;
    cmd.arg("").arg(file.path());
    cmd.assert()
        .failure()
        .stderr(predicate::str::contains("You cannot give an empty pattern"));

    Ok(())
}
