/*
    Script for generating the table content.
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

import math

bits_count = 128
next_power_of_ten = lambda x: 10 ** math.ceil(math.log10(x))
values = [2 ** (i - 1) for i in reversed(range(0, bits_count + 1))]
powers = [next_power_of_ten(value) for value in values]

print('//  lz |                  value                   | next power of ten')
print('//-----+------------------------------------------+------------------')

for lz, (value, power) in enumerate(zip(values, powers)):
    if power >= 2 ** (bits_count - 1):
        print('/* %3d | %39d */ 0 /* overflow */,' % (lz, value))
    else:
        print('/* %3d | %39d */ %d,' % (lz, value, power))
*/

/// Acts as a map for any given `x: i128`:
/// Leading zeros count in `x` -> The closest power of ten
#[rustfmt::skip]
#[cfg(feature = "i128")]
#[allow(clippy::all, non_upper_case_globals)]
pub(crate) static i128: [i128; 129] = [
    //  lz |                  value                   | next power of ten
    //-----+------------------------------------------+------------------
    /*   0 | 170141183460469231731687303715884105728 */ 0 /* overflow */,
    /*   1 |  85070591730234615865843651857942052864 */ 100000000000000000000000000000000000000,
    /*   2 |  42535295865117307932921825928971026432 */ 100000000000000000000000000000000000000,
    /*   3 |  21267647932558653966460912964485513216 */ 100000000000000000000000000000000000000,
    /*   4 |  10633823966279326983230456482242756608 */ 100000000000000000000000000000000000000,
    /*   5 |   5316911983139663491615228241121378304 */ 10000000000000000000000000000000000000,
    /*   6 |   2658455991569831745807614120560689152 */ 10000000000000000000000000000000000000,
    /*   7 |   1329227995784915872903807060280344576 */ 10000000000000000000000000000000000000,
    /*   8 |    664613997892457936451903530140172288 */ 1000000000000000000000000000000000000,
    /*   9 |    332306998946228968225951765070086144 */ 1000000000000000000000000000000000000,
    /*  10 |    166153499473114484112975882535043072 */ 1000000000000000000000000000000000000,
    /*  11 |     83076749736557242056487941267521536 */ 100000000000000000000000000000000000,
    /*  12 |     41538374868278621028243970633760768 */ 100000000000000000000000000000000000,
    /*  13 |     20769187434139310514121985316880384 */ 100000000000000000000000000000000000,
    /*  14 |     10384593717069655257060992658440192 */ 100000000000000000000000000000000000,
    /*  15 |      5192296858534827628530496329220096 */ 10000000000000000000000000000000000,
    /*  16 |      2596148429267413814265248164610048 */ 10000000000000000000000000000000000,
    /*  17 |      1298074214633706907132624082305024 */ 10000000000000000000000000000000000,
    /*  18 |       649037107316853453566312041152512 */ 1000000000000000000000000000000000,
    /*  19 |       324518553658426726783156020576256 */ 1000000000000000000000000000000000,
    /*  20 |       162259276829213363391578010288128 */ 1000000000000000000000000000000000,
    /*  21 |        81129638414606681695789005144064 */ 100000000000000000000000000000000,
    /*  22 |        40564819207303340847894502572032 */ 100000000000000000000000000000000,
    /*  23 |        20282409603651670423947251286016 */ 100000000000000000000000000000000,
    /*  24 |        10141204801825835211973625643008 */ 100000000000000000000000000000000,
    /*  25 |         5070602400912917605986812821504 */ 10000000000000000000000000000000,
    /*  26 |         2535301200456458802993406410752 */ 10000000000000000000000000000000,
    /*  27 |         1267650600228229401496703205376 */ 10000000000000000000000000000000,
    /*  28 |          633825300114114700748351602688 */ 1000000000000000000000000000000,
    /*  29 |          316912650057057350374175801344 */ 1000000000000000000000000000000,
    /*  30 |          158456325028528675187087900672 */ 1000000000000000000000000000000,
    /*  31 |           79228162514264337593543950336 */ 100000000000000000000000000000,
    /*  32 |           39614081257132168796771975168 */ 100000000000000000000000000000,
    /*  33 |           19807040628566084398385987584 */ 100000000000000000000000000000,
    /*  34 |            9903520314283042199192993792 */ 10000000000000000000000000000,
    /*  35 |            4951760157141521099596496896 */ 10000000000000000000000000000,
    /*  36 |            2475880078570760549798248448 */ 10000000000000000000000000000,
    /*  37 |            1237940039285380274899124224 */ 10000000000000000000000000000,
    /*  38 |             618970019642690137449562112 */ 1000000000000000000000000000,
    /*  39 |             309485009821345068724781056 */ 1000000000000000000000000000,
    /*  40 |             154742504910672534362390528 */ 1000000000000000000000000000,
    /*  41 |              77371252455336267181195264 */ 100000000000000000000000000,
    /*  42 |              38685626227668133590597632 */ 100000000000000000000000000,
    /*  43 |              19342813113834066795298816 */ 100000000000000000000000000,
    /*  44 |               9671406556917033397649408 */ 10000000000000000000000000,
    /*  45 |               4835703278458516698824704 */ 10000000000000000000000000,
    /*  46 |               2417851639229258349412352 */ 10000000000000000000000000,
    /*  47 |               1208925819614629174706176 */ 10000000000000000000000000,
    /*  48 |                604462909807314587353088 */ 1000000000000000000000000,
    /*  49 |                302231454903657293676544 */ 1000000000000000000000000,
    /*  50 |                151115727451828646838272 */ 1000000000000000000000000,
    /*  51 |                 75557863725914323419136 */ 100000000000000000000000,
    /*  52 |                 37778931862957161709568 */ 100000000000000000000000,
    /*  53 |                 18889465931478580854784 */ 100000000000000000000000,
    /*  54 |                  9444732965739290427392 */ 10000000000000000000000,
    /*  55 |                  4722366482869645213696 */ 10000000000000000000000,
    /*  56 |                  2361183241434822606848 */ 10000000000000000000000,
    /*  57 |                  1180591620717411303424 */ 10000000000000000000000,
    /*  58 |                   590295810358705651712 */ 1000000000000000000000,
    /*  59 |                   295147905179352825856 */ 1000000000000000000000,
    /*  60 |                   147573952589676412928 */ 1000000000000000000000,
    /*  61 |                    73786976294838206464 */ 100000000000000000000,
    /*  62 |                    36893488147419103232 */ 100000000000000000000,
    /*  63 |                    18446744073709551616 */ 100000000000000000000,
    /*  64 |                     9223372036854775808 */ 10000000000000000000,
    /*  65 |                     4611686018427387904 */ 10000000000000000000,
    /*  66 |                     2305843009213693952 */ 10000000000000000000,
    /*  67 |                     1152921504606846976 */ 10000000000000000000,
    /*  68 |                      576460752303423488 */ 1000000000000000000,
    /*  69 |                      288230376151711744 */ 1000000000000000000,
    /*  70 |                      144115188075855872 */ 1000000000000000000,
    /*  71 |                       72057594037927936 */ 100000000000000000,
    /*  72 |                       36028797018963968 */ 100000000000000000,
    /*  73 |                       18014398509481984 */ 100000000000000000,
    /*  74 |                        9007199254740992 */ 10000000000000000,
    /*  75 |                        4503599627370496 */ 10000000000000000,
    /*  76 |                        2251799813685248 */ 10000000000000000,
    /*  77 |                        1125899906842624 */ 10000000000000000,
    /*  78 |                         562949953421312 */ 1000000000000000,
    /*  79 |                         281474976710656 */ 1000000000000000,
    /*  80 |                         140737488355328 */ 1000000000000000,
    /*  81 |                          70368744177664 */ 100000000000000,
    /*  82 |                          35184372088832 */ 100000000000000,
    /*  83 |                          17592186044416 */ 100000000000000,
    /*  84 |                           8796093022208 */ 10000000000000,
    /*  85 |                           4398046511104 */ 10000000000000,
    /*  86 |                           2199023255552 */ 10000000000000,
    /*  87 |                           1099511627776 */ 10000000000000,
    /*  88 |                            549755813888 */ 1000000000000,
    /*  89 |                            274877906944 */ 1000000000000,
    /*  90 |                            137438953472 */ 1000000000000,
    /*  91 |                             68719476736 */ 100000000000,
    /*  92 |                             34359738368 */ 100000000000,
    /*  93 |                             17179869184 */ 100000000000,
    /*  94 |                              8589934592 */ 10000000000,
    /*  95 |                              4294967296 */ 10000000000,
    /*  96 |                              2147483648 */ 10000000000,
    /*  97 |                              1073741824 */ 10000000000,
    /*  98 |                               536870912 */ 1000000000,
    /*  99 |                               268435456 */ 1000000000,
    /* 100 |                               134217728 */ 1000000000,
    /* 101 |                                67108864 */ 100000000,
    /* 102 |                                33554432 */ 100000000,
    /* 103 |                                16777216 */ 100000000,
    /* 104 |                                 8388608 */ 10000000,
    /* 105 |                                 4194304 */ 10000000,
    /* 106 |                                 2097152 */ 10000000,
    /* 107 |                                 1048576 */ 10000000,
    /* 108 |                                  524288 */ 1000000,
    /* 109 |                                  262144 */ 1000000,
    /* 110 |                                  131072 */ 1000000,
    /* 111 |                                   65536 */ 100000,
    /* 112 |                                   32768 */ 100000,
    /* 113 |                                   16384 */ 100000,
    /* 114 |                                    8192 */ 10000,
    /* 115 |                                    4096 */ 10000,
    /* 116 |                                    2048 */ 10000,
    /* 117 |                                    1024 */ 10000,
    /* 118 |                                     512 */ 1000,
    /* 119 |                                     256 */ 1000,
    /* 120 |                                     128 */ 1000,
    /* 121 |                                      64 */ 100,
    /* 122 |                                      32 */ 100,
    /* 123 |                                      16 */ 100,
    /* 124 |                                       8 */ 10,
    /* 125 |                                       4 */ 10,
    /* 126 |                                       2 */ 10,
    /* 127 |                                       1 */ 1,
    /* 128 |                                       0 */ 1,
];

/// Acts as a map for any given `x: i64`:
/// Leading zeros count in `x` -> The closest power of ten
#[rustfmt::skip]
#[allow(clippy::all, non_upper_case_globals)]
pub(crate) static i64: [i64; 65] = [
    //  lz |                  value                   | next power of ten
    //-----+------------------------------------------+------------------
    /*   0 |                     9223372036854775808 */ 0 /* overflow */,
    /*   1 |                     4611686018427387904 */ 0 /* overflow */,
    /*   2 |                     2305843009213693952 */ 0 /* overflow */,
    /*   3 |                     1152921504606846976 */ 0 /* overflow */,
    /*   4 |                      576460752303423488 */ 1000000000000000000,
    /*   5 |                      288230376151711744 */ 1000000000000000000,
    /*   6 |                      144115188075855872 */ 1000000000000000000,
    /*   7 |                       72057594037927936 */ 100000000000000000,
    /*   8 |                       36028797018963968 */ 100000000000000000,
    /*   9 |                       18014398509481984 */ 100000000000000000,
    /*  10 |                        9007199254740992 */ 10000000000000000,
    /*  11 |                        4503599627370496 */ 10000000000000000,
    /*  12 |                        2251799813685248 */ 10000000000000000,
    /*  13 |                        1125899906842624 */ 10000000000000000,
    /*  14 |                         562949953421312 */ 1000000000000000,
    /*  15 |                         281474976710656 */ 1000000000000000,
    /*  16 |                         140737488355328 */ 1000000000000000,
    /*  17 |                          70368744177664 */ 100000000000000,
    /*  18 |                          35184372088832 */ 100000000000000,
    /*  19 |                          17592186044416 */ 100000000000000,
    /*  20 |                           8796093022208 */ 10000000000000,
    /*  21 |                           4398046511104 */ 10000000000000,
    /*  22 |                           2199023255552 */ 10000000000000,
    /*  23 |                           1099511627776 */ 10000000000000,
    /*  24 |                            549755813888 */ 1000000000000,
    /*  25 |                            274877906944 */ 1000000000000,
    /*  26 |                            137438953472 */ 1000000000000,
    /*  27 |                             68719476736 */ 100000000000,
    /*  28 |                             34359738368 */ 100000000000,
    /*  29 |                             17179869184 */ 100000000000,
    /*  30 |                              8589934592 */ 10000000000,
    /*  31 |                              4294967296 */ 10000000000,
    /*  32 |                              2147483648 */ 10000000000,
    /*  33 |                              1073741824 */ 10000000000,
    /*  34 |                               536870912 */ 1000000000,
    /*  35 |                               268435456 */ 1000000000,
    /*  36 |                               134217728 */ 1000000000,
    /*  37 |                                67108864 */ 100000000,
    /*  38 |                                33554432 */ 100000000,
    /*  39 |                                16777216 */ 100000000,
    /*  40 |                                 8388608 */ 10000000,
    /*  41 |                                 4194304 */ 10000000,
    /*  42 |                                 2097152 */ 10000000,
    /*  43 |                                 1048576 */ 10000000,
    /*  44 |                                  524288 */ 1000000,
    /*  45 |                                  262144 */ 1000000,
    /*  46 |                                  131072 */ 1000000,
    /*  47 |                                   65536 */ 100000,
    /*  48 |                                   32768 */ 100000,
    /*  49 |                                   16384 */ 100000,
    /*  50 |                                    8192 */ 10000,
    /*  51 |                                    4096 */ 10000,
    /*  52 |                                    2048 */ 10000,
    /*  53 |                                    1024 */ 10000,
    /*  54 |                                     512 */ 1000,
    /*  55 |                                     256 */ 1000,
    /*  56 |                                     128 */ 1000,
    /*  57 |                                      64 */ 100,
    /*  58 |                                      32 */ 100,
    /*  59 |                                      16 */ 100,
    /*  60 |                                       8 */ 10,
    /*  61 |                                       4 */ 10,
    /*  62 |                                       2 */ 10,
    /*  63 |                                       1 */ 1,
    /*  64 |                                       0 */ 1,
];

/// Acts as a map for any given `x: i32`:
/// Leading zeros count in `x` -> The closest power of ten
#[rustfmt::skip]
#[allow(clippy::all, non_upper_case_globals)]
pub(crate) static i32: [i32; 33] = [
    //  lz |                  value                   | next power of ten
    //-----+------------------------------------------+------------------
    /*   0 |                              2147483648 */ 0 /* overflow */,
    /*   1 |                              1073741824 */ 0 /* overflow */,
    /*   2 |                               536870912 */ 1000000000,
    /*   3 |                               268435456 */ 1000000000,
    /*   4 |                               134217728 */ 1000000000,
    /*   5 |                                67108864 */ 100000000,
    /*   6 |                                33554432 */ 100000000,
    /*   7 |                                16777216 */ 100000000,
    /*   8 |                                 8388608 */ 10000000,
    /*   9 |                                 4194304 */ 10000000,
    /*  10 |                                 2097152 */ 10000000,
    /*  11 |                                 1048576 */ 10000000,
    /*  12 |                                  524288 */ 1000000,
    /*  13 |                                  262144 */ 1000000,
    /*  14 |                                  131072 */ 1000000,
    /*  15 |                                   65536 */ 100000,
    /*  16 |                                   32768 */ 100000,
    /*  17 |                                   16384 */ 100000,
    /*  18 |                                    8192 */ 10000,
    /*  19 |                                    4096 */ 10000,
    /*  20 |                                    2048 */ 10000,
    /*  21 |                                    1024 */ 10000,
    /*  22 |                                     512 */ 1000,
    /*  23 |                                     256 */ 1000,
    /*  24 |                                     128 */ 1000,
    /*  25 |                                      64 */ 100,
    /*  26 |                                      32 */ 100,
    /*  27 |                                      16 */ 100,
    /*  28 |                                       8 */ 10,
    /*  29 |                                       4 */ 10,
    /*  30 |                                       2 */ 10,
    /*  31 |                                       1 */ 1,
    /*  32 |                                       0 */ 1,
];

/// Acts as a map for any given `x: i16`:
/// Leading zeros count in `x` -> The closest power of ten
#[rustfmt::skip]
#[allow(clippy::all, non_upper_case_globals)]
pub(crate) static i16: [i16; 17] = [
    //  lz |                  value                   | next power of ten
    //-----+------------------------------------------+------------------
    /*   0 |                                   32768 */ 0 /* overflow */,
    /*   1 |                                   16384 */ 0 /* overflow */,
    /*   2 |                                    8192 */ 10000,
    /*   3 |                                    4096 */ 10000,
    /*   4 |                                    2048 */ 10000,
    /*   5 |                                    1024 */ 10000,
    /*   6 |                                     512 */ 1000,
    /*   7 |                                     256 */ 1000,
    /*   8 |                                     128 */ 1000,
    /*   9 |                                      64 */ 100,
    /*  10 |                                      32 */ 100,
    /*  11 |                                      16 */ 100,
    /*  12 |                                       8 */ 10,
    /*  13 |                                       4 */ 10,
    /*  14 |                                       2 */ 10,
    /*  15 |                                       1 */ 1,
    /*  16 |                                       0 */ 1,
];
