use serde::Serialize;
use std::fmt::Formatter;
use crate::RepositoryError;

#[derive(Debug, Serialize)]
pub struct CommonError {
    pub message: String,
    pub code: u32,
}

impl From<RepositoryError> for CommonError {
    fn from(error: RepositoryError) -> Self {
        Self {
            message: error.message,
            code: 1
        }
    }
}

impl std::fmt::Display for CommonError {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "Error: {}, Code: {}", self.message, self.code)
    }
}

pub type ServiceResult<T> = Result<T, CommonError>;
