#[derive(Debug)]
pub struct RepositoryError {
    pub message: String
}

impl From<String> for RepositoryError {
    fn from(string: String) -> Self {
        Self {
            message: string,
        }
    }
}

impl From<&str> for RepositoryError {
    fn from(str: &str) -> Self {
        Self {
            message: str.to_string(),
        }
    }
}

pub type RepositoryResult<T> = Result<T, RepositoryError>;
