use crate::async_pool::AsyncPoolError;
use crate::RepositoryError;

#[derive(Debug)]
pub struct DieselRepositoryError(RepositoryError);

impl DieselRepositoryError {
    pub fn into_inner(self) -> RepositoryError { self.0 }
}

impl From<r2d2::Error> for DieselRepositoryError {
    fn from(error: r2d2::Error) -> Self {
        Self(RepositoryError {
            message: error.to_string(),
        })
    }
}

impl From<diesel::result::Error> for DieselRepositoryError {
    fn from(error: diesel::result::Error) -> Self {
        Self(RepositoryError {
            message: error.to_string(),
        })
    }
}

impl<T: std::fmt::Debug> From<AsyncPoolError<T>> for DieselRepositoryError {
    fn from(error: AsyncPoolError<T>) -> Self {
        Self(RepositoryError {
            message: error.to_string()
        })
    }
}
