use std::fmt::{Formatter};
use crate::CommonError;

#[derive(Debug)]
pub struct ApiError(CommonError);

impl From<CommonError> for ApiError {
    fn from(error: CommonError) -> Self {
        Self(error)
    }
}

impl From<email_address::Error> for ApiError {
    fn from(_: email_address::Error) -> Self {
        Self(
            CommonError {
                message: "Wrong Email".to_string(),
                code: 400,
            }
        )
    }
}

impl std::fmt::Display for ApiError {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.0)
    }
}

impl actix_web::ResponseError for ApiError {
    fn error_response(&self) -> actix_http::Response {
        actix_web::HttpResponse::BadRequest().json(&self.0)
    }
}

pub type ApiResult<T> = Result<T, ApiError>;
