use chrono::{DateTime, Utc};
use diesel::backend::Backend;
use diesel::Queryable;

pub struct DateTimeUtcWrapper(DateTime<Utc>);

impl Into<DateTime<Utc>> for DateTimeUtcWrapper {
    fn into(self) -> DateTime<Utc> {
        self.0
    }
}

impl<DB, ST> Queryable<ST, DB> for DateTimeUtcWrapper
    where
        DB: Backend,
        DateTime<Utc>: Queryable<ST, DB>,
{
    type Row = <DateTime<Utc> as Queryable<ST, DB>>::Row;

    fn build(row: Self::Row) -> Self {
        Self(<DateTime<Utc> as Queryable<ST, DB>>::build(row).with_timezone(&Utc))
    }
}