use diesel::r2d2::ConnectionManager;
use r2d2::PooledConnection;

pub type Pool<T> = diesel::r2d2::Pool<ConnectionManager<T>>;
pub type PostgresPool = Pool<diesel::pg::PgConnection>;

pub type DBConnectionPool = PostgresPool;
pub type DBConnection = PooledConnection<ConnectionManager<diesel::pg::PgConnection>>;

pub fn create_database_pool() -> Result<DBConnectionPool, String> {
    let database_url = std::env::var("DATABASE_URL")
        .map_err(|e| e.to_string())?;
    let manager =
        ConnectionManager::<diesel::pg::PgConnection>::new(database_url);
    Ok(
        Pool::builder()
            .build(manager)
            .map_err(|e| e.to_string())?
    )
}
