use std::fmt;
use std::sync::Arc;

use actix_threadpool;
use fistinc_errors::{DieselRepositoryError, RepositoryResult};

use crate::database_pool::{DBConnection, DBConnectionPool};

pub async fn run<F, I, E>(pool: Arc<DBConnectionPool>, f: F) -> RepositoryResult<I>
    where
        F: FnOnce(DBConnection) -> Result<I, E> + Send + 'static,
        I: Send + 'static,
        E: Send + fmt::Debug + 'static,
{
    let conn = pool.get()
        .map_err(
            |e|
                DieselRepositoryError::from(e)
                    .into_inner()
        )?; //todo move connection initialization to f

    actix_threadpool::run(
        move || {
            f(conn)
        }).await
        .map_err(
            |e|
                DieselRepositoryError::from(e).into_inner()
        )
}
