use diesel::r2d2::ConnectionManager;
use r2d2::PooledConnection;

pub type Pool<T> = diesel::r2d2::Pool<ConnectionManager<T>>;
pub type PostgresPool = Pool<diesel::pg::PgConnection>;

pub type DBConnectionPool = PostgresPool;
pub type DBConnection = PooledConnection<ConnectionManager<diesel::pg::PgConnection>>;

pub fn create_database_pool() -> DBConnectionPool {
    let database_url = std::env::var("DATABASE_URL")
        .expect("DATABASE_URL not set");
    let manager =
        ConnectionManager::<diesel::pg::PgConnection>::new(database_url);
    Pool::builder()
        .build(manager)
        .expect("Failed to create pool")
}
