/////////////////////////////////////////////////////////////////////////////
// The contents of this file are subject to the Interbase Public
// License Version 1.0 (the "License"); you may not use this file
// except in compliance with the License. You may obtain a copy
// of the License at https://www.firebirdsql.org/en/interbase-public-license/
//
// Software distributed under the License is distributed on an
// "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
// or implied. See the License for the specific language governing
// rights and limitations under the License.

// generated by ../misc/errmsgs.c

use maplit::hashmap;

pub fn error_message_by_id(id: u32) -> &'static str {
    let map = hashmap! {
         335544321=> r#"arithmetic exception, numeric overflow, or string truncation\n"#,
         335544322=> r#"invalid database key\n"#,
         335544323=> r#"file @1 is not a valid database\n"#,
         335544324=> r#"invalid database handle (no active connection)\n"#,
         335544325=> r#"bad parameters on attach or create database\n"#,
         335544326=> r#"unrecognized database parameter block\n"#,
         335544327=> r#"invalid request handle\n"#,
         335544328=> r#"invalid BLOB handle\n"#,
         335544329=> r#"invalid BLOB ID\n"#,
         335544330=> r#"invalid parameter in transaction parameter block\n"#,
         335544331=> r#"invalid format for transaction parameter block\n"#,
         335544332=> r#"invalid transaction handle (expecting explicit transaction start)\n"#,
         335544333=> r#"internal Firebird consistency check (@1)\n"#,
         335544334=> r#"conversion error from string "@1"\n"#,
         335544335=> r#"database file appears corrupt (@1)\n"#,
         335544336=> r#"deadlock\n"#,
         335544337=> r#"attempt to start more than @1 transactions\n"#,
         335544338=> r#"no match for first value expression\n"#,
         335544339=> r#"information type inappropriate for object specified\n"#,
         335544340=> r#"no information of this type available for object specified\n"#,
         335544341=> r#"unknown information item\n"#,
         335544342=> r#"action cancelled by trigger (@1) to preserve data integrity\n"#,
         335544343=> r#"invalid request BLR at offset @1\n"#,
         335544344=> r#"I/O error during "@1" operation for file "@2"\n"#,
         335544345=> r#"lock conflict on no wait transaction\n"#,
         335544346=> r#"corrupt system table\n"#,
         335544347=> r#"validation error for column @1, value "@2"\n"#,
         335544348=> r#"no current record for fetch operation\n"#,
         335544349=> r#"attempt to store duplicate value (visible to active transactions) in unique index "@1"\n"#,
         335544350=> r#"program attempted to exit without finishing database\n"#,
         335544351=> r#"unsuccessful metadata update\n"#,
         335544352=> r#"no permission for @1 access to @2 @3\n"#,
         335544353=> r#"transaction is not in limbo\n"#,
         335544354=> r#"invalid database key\n"#,
         335544355=> r#"BLOB was not closed\n"#,
         335544356=> r#"metadata is obsolete\n"#,
         335544357=> r#"cannot disconnect database with open transactions (@1 active)\n"#,
         335544358=> r#"message length error (encountered @1, expected @2)\n"#,
         335544359=> r#"attempted update of read-only column @1\n"#,
         335544360=> r#"attempted update of read-only table\n"#,
         335544361=> r#"attempted update during read-only transaction\n"#,
         335544362=> r#"cannot update read-only view @1\n"#,
         335544363=> r#"no transaction for request\n"#,
         335544364=> r#"request synchronization error\n"#,
         335544365=> r#"request referenced an unavailable database\n"#,
         335544366=> r#"segment buffer length shorter than expected\n"#,
         335544367=> r#"attempted retrieval of more segments than exist\n"#,
         335544368=> r#"attempted invalid operation on a BLOB\n"#,
         335544369=> r#"attempted read of a new, open BLOB\n"#,
         335544370=> r#"attempted action on BLOB outside transaction\n"#,
         335544371=> r#"attempted write to read-only BLOB\n"#,
         335544372=> r#"attempted reference to BLOB in unavailable database\n"#,
         335544373=> r#"operating system directive @1 failed\n"#,
         335544374=> r#"attempt to fetch past the last record in a record stream\n"#,
         335544375=> r#"unavailable database\n"#,
         335544376=> r#"table @1 was omitted from the transaction reserving list\n"#,
         335544377=> r#"request includes a DSRI extension not supported in this implementation\n"#,
         335544378=> r#"feature is not supported\n"#,
         335544379=> r#"unsupported on-disk structure for file @1; found @2.@3, support @4.@5\n"#,
         335544380=> r#"wrong number of arguments on call\n"#,
         335544381=> r#"Implementation limit exceeded\n"#,
         335544382=> r#"@1\n"#,
         335544383=> r#"unrecoverable conflict with limbo transaction @1\n"#,
         335544384=> r#"internal error\n"#,
         335544385=> r#"internal error\n"#,
         335544386=> r#"too many requests\n"#,
         335544387=> r#"internal error\n"#,
         335544388=> r#"block size exceeds implementation restriction\n"#,
         335544389=> r#"buffer exhausted\n"#,
         335544390=> r#"BLR syntax error: expected @1 at offset @2, encountered @3\n"#,
         335544391=> r#"buffer in use\n"#,
         335544392=> r#"internal error\n"#,
         335544393=> r#"request in use\n"#,
         335544394=> r#"incompatible version of on-disk structure\n"#,
         335544395=> r#"table @1 is not defined\n"#,
         335544396=> r#"column @1 is not defined in table @2\n"#,
         335544397=> r#"internal error\n"#,
         335544398=> r#"internal error\n"#,
         335544399=> r#"internal error\n"#,
         335544400=> r#"internal error\n"#,
         335544401=> r#"internal error\n"#,
         335544402=> r#"internal error\n"#,
         335544403=> r#"page @1 is of wrong type (expected @2, found @3)\n"#,
         335544404=> r#"database corrupted\n"#,
         335544405=> r#"checksum error on database page @1\n"#,
         335544406=> r#"index is broken\n"#,
         335544407=> r#"database handle not zero\n"#,
         335544408=> r#"transaction handle not zero\n"#,
         335544409=> r#"transaction--request mismatch (synchronization error)\n"#,
         335544410=> r#"bad handle count\n"#,
         335544411=> r#"wrong version of transaction parameter block\n"#,
         335544412=> r#"unsupported BLR version (expected @1, encountered @2)\n"#,
         335544413=> r#"wrong version of database parameter block\n"#,
         335544414=> r#"BLOB and array data types are not supported for @1 operation\n"#,
         335544415=> r#"database corrupted\n"#,
         335544416=> r#"internal error\n"#,
         335544417=> r#"internal error\n"#,
         335544418=> r#"transaction in limbo\n"#,
         335544419=> r#"transaction not in limbo\n"#,
         335544420=> r#"transaction outstanding\n"#,
         335544421=> r#"connection rejected by remote interface\n"#,
         335544422=> r#"internal error\n"#,
         335544423=> r#"internal error\n"#,
         335544424=> r#"no lock manager available\n"#,
         335544425=> r#"context already in use (BLR error)\n"#,
         335544426=> r#"context not defined (BLR error)\n"#,
         335544427=> r#"data operation not supported\n"#,
         335544428=> r#"undefined message number\n"#,
         335544429=> r#"undefined parameter number\n"#,
         335544430=> r#"unable to allocate memory from operating system\n"#,
         335544431=> r#"blocking signal has been received\n"#,
         335544432=> r#"lock manager error\n"#,
         335544433=> r#"communication error with journal "@1"\n"#,
         335544434=> r#"key size exceeds implementation restriction for index "@1"\n"#,
         335544435=> r#"null segment of UNIQUE KEY\n"#,
         335544436=> r#"SQL error code = @1\n"#,
         335544437=> r#"wrong DYN version\n"#,
         335544438=> r#"function @1 is not defined\n"#,
         335544439=> r#"function @1 could not be matched\n"#,
         335544440=> r#"\n"#,
         335544441=> r#"database detach completed with errors\n"#,
         335544442=> r#"database system cannot read argument @1\n"#,
         335544443=> r#"database system cannot write argument @1\n"#,
         335544444=> r#"operation not supported\n"#,
         335544445=> r#"@1 extension error\n"#,
         335544446=> r#"not updatable\n"#,
         335544447=> r#"no rollback performed\n"#,
         335544448=> r#"\n"#,
         335544449=> r#"\n"#,
         335544450=> r#"@1\n"#,
         335544451=> r#"update conflicts with concurrent update\n"#,
         335544452=> r#"product @1 is not licensed\n"#,
         335544453=> r#"object @1 is in use\n"#,
         335544454=> r#"filter not found to convert type @1 to type @2\n"#,
         335544455=> r#"cannot attach active shadow file\n"#,
         335544456=> r#"invalid slice description language at offset @1\n"#,
         335544457=> r#"subscript out of bounds\n"#,
         335544458=> r#"column not array or invalid dimensions (expected @1, encountered @2)\n"#,
         335544459=> r#"record from transaction @1 is stuck in limbo\n"#,
         335544460=> r#"a file in manual shadow @1 is unavailable\n"#,
         335544461=> r#"secondary server attachments cannot validate databases\n"#,
         335544462=> r#"secondary server attachments cannot start journaling\n"#,
         335544463=> r#"generator @1 is not defined\n"#,
         335544464=> r#"secondary server attachments cannot start logging\n"#,
         335544465=> r#"invalid BLOB type for operation\n"#,
         335544466=> r#"violation of FOREIGN KEY constraint "@1" on table "@2"\n"#,
         335544467=> r#"minor version too high found @1 expected @2\n"#,
         335544468=> r#"transaction @1 is @2\n"#,
         335544469=> r#"transaction marked invalid and cannot be committed\n"#,
         335544470=> r#"cache buffer for page @1 invalid\n"#,
         335544471=> r#"there is no index in table @1 with id @2\n"#,
         335544472=> r#"Your user name and password are not defined. Ask your database administrator to set up a Firebird login.\n"#,
         335544473=> r#"invalid bookmark handle\n"#,
         335544474=> r#"invalid lock level @1\n"#,
         335544475=> r#"lock on table @1 conflicts with existing lock\n"#,
         335544476=> r#"requested record lock conflicts with existing lock\n"#,
         335544477=> r#"maximum indexes per table (@1) exceeded\n"#,
         335544478=> r#"enable journal for database before starting online dump\n"#,
         335544479=> r#"online dump failure. Retry dump\n"#,
         335544480=> r#"an online dump is already in progress\n"#,
         335544481=> r#"no more disk/tape space.  Cannot continue online dump\n"#,
         335544482=> r#"journaling allowed only if database has Write-ahead Log\n"#,
         335544483=> r#"maximum number of online dump files that can be specified is 16\n"#,
         335544484=> r#"error in opening Write-ahead Log file during recovery\n"#,
         335544485=> r#"invalid statement handle\n"#,
         335544486=> r#"Write-ahead log subsystem failure\n"#,
         335544487=> r#"WAL Writer error\n"#,
         335544488=> r#"Log file header of @1 too small\n"#,
         335544489=> r#"Invalid version of log file @1\n"#,
         335544490=> r#"Log file @1 not latest in the chain but open flag still set\n"#,
         335544491=> r#"Log file @1 not closed properly; database recovery may be required\n"#,
         335544492=> r#"Database name in the log file @1 is different\n"#,
         335544493=> r#"Unexpected end of log file @1 at offset @2\n"#,
         335544494=> r#"Incomplete log record at offset @1 in log file @2\n"#,
         335544495=> r#"Log record header too small at offset @1 in log file @2\n"#,
         335544496=> r#"Log block too small at offset @1 in log file @2\n"#,
         335544497=> r#"Illegal attempt to attach to an uninitialized WAL segment for @1\n"#,
         335544498=> r#"Invalid WAL parameter block option @1\n"#,
         335544499=> r#"Cannot roll over to the next log file @1\n"#,
         335544500=> r#"database does not use Write-ahead Log\n"#,
         335544501=> r#"cannot drop log file when journaling is enabled\n"#,
         335544502=> r#"reference to invalid stream number\n"#,
         335544503=> r#"WAL subsystem encountered error\n"#,
         335544504=> r#"WAL subsystem corrupted\n"#,
         335544505=> r#"must specify archive file when enabling long term journal for databases with round-robin log files\n"#,
         335544506=> r#"database @1 shutdown in progress\n"#,
         335544507=> r#"refresh range number @1 already in use\n"#,
         335544508=> r#"refresh range number @1 not found\n"#,
         335544509=> r#"CHARACTER SET @1 is not defined\n"#,
         335544510=> r#"lock time-out on wait transaction\n"#,
         335544511=> r#"procedure @1 is not defined\n"#,
         335544512=> r#"Input parameter mismatch for procedure @1\n"#,
         335544513=> r#"Database @1: WAL subsystem bug for pid @2@3\n"#,
         335544514=> r#"Could not expand the WAL segment for database @1\n"#,
         335544515=> r#"status code @1 unknown\n"#,
         335544516=> r#"exception @1 not defined\n"#,
         335544517=> r#"exception @1\n"#,
         335544518=> r#"restart shared cache manager\n"#,
         335544519=> r#"invalid lock handle\n"#,
         335544520=> r#"long-term journaling already enabled\n"#,
         335544521=> r#"Unable to roll over please see Firebird log.\n"#,
         335544522=> r#"WAL I/O error.  Please see Firebird log.\n"#,
         335544523=> r#"WAL writer - Journal server communication error.  Please see Firebird log.\n"#,
         335544524=> r#"WAL buffers cannot be increased.  Please see Firebird log.\n"#,
         335544525=> r#"WAL setup error.  Please see Firebird log.\n"#,
         335544526=> r#"obsolete\n"#,
         335544527=> r#"Cannot start WAL writer for the database @1\n"#,
         335544528=> r#"database @1 shutdown\n"#,
         335544529=> r#"cannot modify an existing user privilege\n"#,
         335544530=> r#"Cannot delete PRIMARY KEY being used in FOREIGN KEY definition.\n"#,
         335544531=> r#"Column used in a PRIMARY constraint must be NOT NULL.\n"#,
         335544532=> r#"Name of Referential Constraint not defined in constraints table.\n"#,
         335544533=> r#"Non-existent PRIMARY or UNIQUE KEY specified for FOREIGN KEY.\n"#,
         335544534=> r#"Cannot update constraints (RDB$REF_CONSTRAINTS).\n"#,
         335544535=> r#"Cannot update constraints (RDB$CHECK_CONSTRAINTS).\n"#,
         335544536=> r#"Cannot delete CHECK constraint entry (RDB$CHECK_CONSTRAINTS)\n"#,
         335544537=> r#"Cannot delete index segment used by an Integrity Constraint\n"#,
         335544538=> r#"Cannot update index segment used by an Integrity Constraint\n"#,
         335544539=> r#"Cannot delete index used by an Integrity Constraint\n"#,
         335544540=> r#"Cannot modify index used by an Integrity Constraint\n"#,
         335544541=> r#"Cannot delete trigger used by a CHECK Constraint\n"#,
         335544542=> r#"Cannot update trigger used by a CHECK Constraint\n"#,
         335544543=> r#"Cannot delete column being used in an Integrity Constraint.\n"#,
         335544544=> r#"Cannot rename column being used in an Integrity Constraint.\n"#,
         335544545=> r#"Cannot update constraints (RDB$RELATION_CONSTRAINTS).\n"#,
         335544546=> r#"Cannot define constraints on views\n"#,
         335544547=> r#"internal Firebird consistency check (invalid RDB$CONSTRAINT_TYPE)\n"#,
         335544548=> r#"Attempt to define a second PRIMARY KEY for the same table\n"#,
         335544549=> r#"cannot modify or erase a system trigger\n"#,
         335544550=> r#"only the owner of a table may reassign ownership\n"#,
         335544551=> r#"could not find object for GRANT\n"#,
         335544552=> r#"could not find column for GRANT\n"#,
         335544553=> r#"user does not have GRANT privileges for operation\n"#,
         335544554=> r#"object has non-SQL security class defined\n"#,
         335544555=> r#"column has non-SQL security class defined\n"#,
         335544556=> r#"Write-ahead Log without shared cache configuration not allowed\n"#,
         335544557=> r#"database shutdown unsuccessful\n"#,
         335544558=> r#"Operation violates CHECK constraint @1 on view or table @2\n"#,
         335544559=> r#"invalid service handle\n"#,
         335544560=> r#"database @1 shutdown in @2 seconds\n"#,
         335544561=> r#"wrong version of service parameter block\n"#,
         335544562=> r#"unrecognized service parameter block\n"#,
         335544563=> r#"service @1 is not defined\n"#,
         335544564=> r#"long-term journaling not enabled\n"#,
         335544565=> r#"Cannot transliterate character between character sets\n"#,
         335544566=> r#"WAL defined; Cache Manager must be started first\n"#,
         335544567=> r#"Overflow log specification required for round-robin log\n"#,
         335544568=> r#"Implementation of text subtype @1 not located.\n"#,
         335544569=> r#"Dynamic SQL Error\n"#,
         335544570=> r#"Invalid command\n"#,
         335544571=> r#"Data type for constant unknown\n"#,
         335544572=> r#"Invalid cursor reference\n"#,
         335544573=> r#"Data type unknown\n"#,
         335544574=> r#"Invalid cursor declaration\n"#,
         335544575=> r#"Cursor @1 is not updatable\n"#,
         335544576=> r#"Attempt to reopen an open cursor\n"#,
         335544577=> r#"Attempt to reclose a closed cursor\n"#,
         335544578=> r#"Column unknown\n"#,
         335544579=> r#"Internal error\n"#,
         335544580=> r#"Table unknown\n"#,
         335544581=> r#"Procedure unknown\n"#,
         335544582=> r#"Request unknown\n"#,
         335544583=> r#"SQLDA error\n"#,
         335544584=> r#"Count of read-write columns does not equal count of values\n"#,
         335544585=> r#"Invalid statement handle\n"#,
         335544586=> r#"Function unknown\n"#,
         335544587=> r#"Column is not a BLOB\n"#,
         335544588=> r#"COLLATION @1 for CHARACTER SET @2 is not defined\n"#,
         335544589=> r#"COLLATION @1 is not valid for specified CHARACTER SET\n"#,
         335544590=> r#"Option specified more than once\n"#,
         335544591=> r#"Unknown transaction option\n"#,
         335544592=> r#"Invalid array reference\n"#,
         335544593=> r#"Array declared with too many dimensions\n"#,
         335544594=> r#"Illegal array dimension range\n"#,
         335544595=> r#"Trigger unknown\n"#,
         335544596=> r#"Subselect illegal in this context\n"#,
         335544597=> r#"Cannot prepare a CREATE DATABASE/SCHEMA statement\n"#,
         335544598=> r#"must specify column name for view select expression\n"#,
         335544599=> r#"number of columns does not match select list\n"#,
         335544600=> r#"Only simple column names permitted for VIEW WITH CHECK OPTION\n"#,
         335544601=> r#"No WHERE clause for VIEW WITH CHECK OPTION\n"#,
         335544602=> r#"Only one table allowed for VIEW WITH CHECK OPTION\n"#,
         335544603=> r#"DISTINCT, GROUP or HAVING not permitted for VIEW WITH CHECK OPTION\n"#,
         335544604=> r#"FOREIGN KEY column count does not match PRIMARY KEY\n"#,
         335544605=> r#"No subqueries permitted for VIEW WITH CHECK OPTION\n"#,
         335544606=> r#"expression evaluation not supported\n"#,
         335544607=> r#"gen.c: node not supported\n"#,
         335544608=> r#"Unexpected end of command\n"#,
         335544609=> r#"INDEX @1\n"#,
         335544610=> r#"EXCEPTION @1\n"#,
         335544611=> r#"COLUMN @1\n"#,
         335544612=> r#"Token unknown\n"#,
         335544613=> r#"union not supported\n"#,
         335544614=> r#"Unsupported DSQL construct\n"#,
         335544615=> r#"column used with aggregate\n"#,
         335544616=> r#"invalid column reference\n"#,
         335544617=> r#"invalid ORDER BY clause\n"#,
         335544618=> r#"Return mode by value not allowed for this data type\n"#,
         335544619=> r#"External functions cannot have more than 10 parameters\n"#,
         335544620=> r#"alias @1 conflicts with an alias in the same statement\n"#,
         335544621=> r#"alias @1 conflicts with a procedure in the same statement\n"#,
         335544622=> r#"alias @1 conflicts with a table in the same statement\n"#,
         335544623=> r#"Illegal use of keyword VALUE\n"#,
         335544624=> r#"segment count of 0 defined for index @1\n"#,
         335544625=> r#"A node name is not permitted in a secondary, shadow, cache or log file name\n"#,
         335544626=> r#"TABLE @1\n"#,
         335544627=> r#"PROCEDURE @1\n"#,
         335544628=> r#"cannot create index @1\n"#,
         335544629=> r#"Write-ahead Log with shadowing configuration not allowed\n"#,
         335544630=> r#"there are @1 dependencies\n"#,
         335544631=> r#"too many keys defined for index @1\n"#,
         335544632=> r#"Preceding file did not specify length, so @1 must include starting page number\n"#,
         335544633=> r#"Shadow number must be a positive integer\n"#,
         335544634=> r#"Token unknown - line @1, column @2\n"#,
         335544635=> r#"there is no alias or table named @1 at this scope level\n"#,
         335544636=> r#"there is no index @1 for table @2\n"#,
         335544637=> r#"table @1 is not referenced in plan\n"#,
         335544638=> r#"table @1 is referenced more than once in plan; use aliases to distinguish\n"#,
         335544639=> r#"table @1 is referenced in the plan but not the from list\n"#,
         335544640=> r#"Invalid use of CHARACTER SET or COLLATE\n"#,
         335544641=> r#"Specified domain or source column @1 does not exist\n"#,
         335544642=> r#"index @1 cannot be used in the specified plan\n"#,
         335544643=> r#"the table @1 is referenced twice; use aliases to differentiate\n"#,
         335544644=> r#"attempt to fetch before the first record in a record stream\n"#,
         335544645=> r#"the current position is on a crack\n"#,
         335544646=> r#"database or file exists\n"#,
         335544647=> r#"invalid comparison operator for find operation\n"#,
         335544648=> r#"Connection lost to pipe server\n"#,
         335544649=> r#"bad checksum\n"#,
         335544650=> r#"wrong page type\n"#,
         335544651=> r#"Cannot insert because the file is readonly or is on a read only medium.\n"#,
         335544652=> r#"multiple rows in singleton select\n"#,
         335544653=> r#"cannot attach to password database\n"#,
         335544654=> r#"cannot start transaction for password database\n"#,
         335544655=> r#"invalid direction for find operation\n"#,
         335544656=> r#"variable @1 conflicts with parameter in same procedure\n"#,
         335544657=> r#"Array/BLOB/DATE data types not allowed in arithmetic\n"#,
         335544658=> r#"@1 is not a valid base table of the specified view\n"#,
         335544659=> r#"table @1 is referenced twice in view; use an alias to distinguish\n"#,
         335544660=> r#"view @1 has more than one base table; use aliases to distinguish\n"#,
         335544661=> r#"cannot add index, index root page is full.\n"#,
         335544662=> r#"BLOB SUB_TYPE @1 is not defined\n"#,
         335544663=> r#"Too many concurrent executions of the same request\n"#,
         335544664=> r#"duplicate specification of @1 - not supported\n"#,
         335544665=> r#"violation of PRIMARY or UNIQUE KEY constraint "@1" on table "@2"\n"#,
         335544666=> r#"server version too old to support all CREATE DATABASE options\n"#,
         335544667=> r#"drop database completed with errors\n"#,
         335544668=> r#"procedure @1 does not return any values\n"#,
         335544669=> r#"count of column list and variable list do not match\n"#,
         335544670=> r#"attempt to index BLOB column in index @1\n"#,
         335544671=> r#"attempt to index array column in index @1\n"#,
         335544672=> r#"too few key columns found for index @1 (incorrect column name?)\n"#,
         335544673=> r#"cannot delete\n"#,
         335544674=> r#"last column in a table cannot be deleted\n"#,
         335544675=> r#"sort error\n"#,
         335544676=> r#"sort error: not enough memory\n"#,
         335544677=> r#"too many versions\n"#,
         335544678=> r#"invalid key position\n"#,
         335544679=> r#"segments not allowed in expression index @1\n"#,
         335544680=> r#"sort error: corruption in data structure\n"#,
         335544681=> r#"new record size of @1 bytes is too big\n"#,
         335544682=> r#"Inappropriate self-reference of column\n"#,
         335544683=> r#"request depth exceeded. (Recursive definition?)\n"#,
         335544684=> r#"cannot access column @1 in view @2\n"#,
         335544685=> r#"dbkey not available for multi-table views\n"#,
         335544686=> r#"journal file wrong format\n"#,
         335544687=> r#"intermediate journal file full\n"#,
         335544688=> r#"The prepare statement identifies a prepare statement with an open cursor\n"#,
         335544689=> r#"Firebird error\n"#,
         335544690=> r#"Cache redefined\n"#,
         335544691=> r#"Insufficient memory to allocate page buffer cache\n"#,
         335544692=> r#"Log redefined\n"#,
         335544693=> r#"Log size too small\n"#,
         335544694=> r#"Log partition size too small\n"#,
         335544695=> r#"Partitions not supported in series of log file specification\n"#,
         335544696=> r#"Total length of a partitioned log must be specified\n"#,
         335544697=> r#"Precision must be from 1 to 18\n"#,
         335544698=> r#"Scale must be between zero and precision\n"#,
         335544699=> r#"Short integer expected\n"#,
         335544700=> r#"Long integer expected\n"#,
         335544701=> r#"Unsigned short integer expected\n"#,
         335544702=> r#"Invalid ESCAPE sequence\n"#,
         335544703=> r#"service @1 does not have an associated executable\n"#,
         335544704=> r#"Failed to locate host machine.\n"#,
         335544705=> r#"Undefined service @1/@2.\n"#,
         335544706=> r#"The specified name was not found in the hosts file or Domain Name Services.\n"#,
         335544707=> r#"user does not have GRANT privileges on base table/view for operation\n"#,
         335544708=> r#"Ambiguous column reference.\n"#,
         335544709=> r#"Invalid aggregate reference\n"#,
         335544710=> r#"navigational stream @1 references a view with more than one base table\n"#,
         335544711=> r#"Attempt to execute an unprepared dynamic SQL statement.\n"#,
         335544712=> r#"Positive value expected\n"#,
         335544713=> r#"Incorrect values within SQLDA structure\n"#,
         335544714=> r#"invalid blob id\n"#,
         335544715=> r#"Operation not supported for EXTERNAL FILE table @1\n"#,
         335544716=> r#"Service is currently busy: @1\n"#,
         335544717=> r#"stack size insufficent to execute current request\n"#,
         335544718=> r#"Invalid key for find operation\n"#,
         335544719=> r#"Error initializing the network software.\n"#,
         335544720=> r#"Unable to load required library @1.\n"#,
         335544721=> r#"Unable to complete network request to host "@1".\n"#,
         335544722=> r#"Failed to establish a connection.\n"#,
         335544723=> r#"Error while listening for an incoming connection.\n"#,
         335544724=> r#"Failed to establish a secondary connection for event processing.\n"#,
         335544725=> r#"Error while listening for an incoming event connection request.\n"#,
         335544726=> r#"Error reading data from the connection.\n"#,
         335544727=> r#"Error writing data to the connection.\n"#,
         335544728=> r#"Cannot deactivate index used by an integrity constraint\n"#,
         335544729=> r#"Cannot deactivate index used by a PRIMARY/UNIQUE constraint\n"#,
         335544730=> r#"Client/Server Express not supported in this release\n"#,
         335544731=> r#"\n"#,
         335544732=> r#"Access to databases on file servers is not supported.\n"#,
         335544733=> r#"Error while trying to create file\n"#,
         335544734=> r#"Error while trying to open file\n"#,
         335544735=> r#"Error while trying to close file\n"#,
         335544736=> r#"Error while trying to read from file\n"#,
         335544737=> r#"Error while trying to write to file\n"#,
         335544738=> r#"Error while trying to delete file\n"#,
         335544739=> r#"Error while trying to access file\n"#,
         335544740=> r#"A fatal exception occurred during the execution of a user defined function.\n"#,
         335544741=> r#"connection lost to database\n"#,
         335544742=> r#"User cannot write to RDB$USER_PRIVILEGES\n"#,
         335544743=> r#"token size exceeds limit\n"#,
         335544744=> r#"Maximum user count exceeded.  Contact your database administrator.\n"#,
         335544745=> r#"Your login @1 is same as one of the SQL role name. Ask your database administrator to set up a valid Firebird login.\n"#,
         335544746=> r#""REFERENCES table" without "(column)" requires PRIMARY KEY on referenced table\n"#,
         335544747=> r#"The username entered is too long.  Maximum length is 31 bytes.\n"#,
         335544748=> r#"The password specified is too long.  Maximum length is 8 bytes.\n"#,
         335544749=> r#"A username is required for this operation.\n"#,
         335544750=> r#"A password is required for this operation\n"#,
         335544751=> r#"The network protocol specified is invalid\n"#,
         335544752=> r#"A duplicate user name was found in the security database\n"#,
         335544753=> r#"The user name specified was not found in the security database\n"#,
         335544754=> r#"An error occurred while attempting to add the user.\n"#,
         335544755=> r#"An error occurred while attempting to modify the user record.\n"#,
         335544756=> r#"An error occurred while attempting to delete the user record.\n"#,
         335544757=> r#"An error occurred while updating the security database.\n"#,
         335544758=> r#"sort record size of @1 bytes is too big\n"#,
         335544759=> r#"can not define a not null column with NULL as default value\n"#,
         335544760=> r#"invalid clause --- '@1'\n"#,
         335544761=> r#"too many open handles to database\n"#,
         335544762=> r#"size of optimizer block exceeded\n"#,
         335544763=> r#"a string constant is delimited by double quotes\n"#,
         335544764=> r#"DATE must be changed to TIMESTAMP\n"#,
         335544765=> r#"attempted update on read-only database\n"#,
         335544766=> r#"SQL dialect @1 is not supported in this database\n"#,
         335544767=> r#"A fatal exception occurred during the execution of a blob filter.\n"#,
         335544768=> r#"Access violation.  The code attempted to access a virtual address without privilege to do so.\n"#,
         335544769=> r#"Datatype misalignment.  The attempted to read or write a value that was not stored on a memory boundary.\n"#,
         335544770=> r#"Array bounds exceeded.  The code attempted to access an array element that is out of bounds.\n"#,
         335544771=> r#"Float denormal operand.  One of the floating-point operands is too small to represent a standard float value.\n"#,
         335544772=> r#"Floating-point divide by zero.  The code attempted to divide a floating-point value by zero.\n"#,
         335544773=> r#"Floating-point inexact result.  The result of a floating-point operation cannot be represented as a decimal fraction.\n"#,
         335544774=> r#"Floating-point invalid operand.  An indeterminant error occurred during a floating-point operation.\n"#,
         335544775=> r#"Floating-point overflow.  The exponent of a floating-point operation is greater than the magnitude allowed.\n"#,
         335544776=> r#"Floating-point stack check.  The stack overflowed or underflowed as the result of a floating-point operation.\n"#,
         335544777=> r#"Floating-point underflow.  The exponent of a floating-point operation is less than the magnitude allowed.\n"#,
         335544778=> r#"Integer divide by zero.  The code attempted to divide an integer value by an integer divisor of zero.\n"#,
         335544779=> r#"Integer overflow.  The result of an integer operation caused the most significant bit of the result to carry.\n"#,
         335544780=> r#"An exception occurred that does not have a description.  Exception number @1.\n"#,
         335544781=> r#"Stack overflow.  The resource requirements of the runtime stack have exceeded the memory available to it.\n"#,
         335544782=> r#"Segmentation Fault. The code attempted to access memory without privileges.\n"#,
         335544783=> r#"Illegal Instruction. The Code attempted to perform an illegal operation.\n"#,
         335544784=> r#"Bus Error. The Code caused a system bus error.\n"#,
         335544785=> r#"Floating Point Error. The Code caused an Arithmetic Exception or a floating point exception.\n"#,
         335544786=> r#"Cannot delete rows from external files.\n"#,
         335544787=> r#"Cannot update rows in external files.\n"#,
         335544788=> r#"Unable to perform operation\n"#,
         335544789=> r#"Specified EXTRACT part does not exist in input datatype\n"#,
         335544790=> r#"Service @1 requires SYSDBA permissions.  Reattach to the Service Manager using the SYSDBA account.\n"#,
         335544791=> r#"The file @1 is currently in use by another process.  Try again later.\n"#,
         335544792=> r#"Cannot attach to services manager\n"#,
         335544793=> r#"Metadata update statement is not allowed by the current database SQL dialect @1\n"#,
         335544794=> r#"operation was cancelled\n"#,
         335544795=> r#"unexpected item in service parameter block, expected @1\n"#,
         335544796=> r#"Client SQL dialect @1 does not support reference to @2 datatype\n"#,
         335544797=> r#"user name and password are required while attaching to the services manager\n"#,
         335544798=> r#"You created an indirect dependency on uncommitted metadata. You must roll back the current transaction.\n"#,
         335544799=> r#"The service name was not specified.\n"#,
         335544800=> r#"Too many Contexts of Relation/Procedure/Views. Maximum allowed is 256\n"#,
         335544801=> r#"data type not supported for arithmetic\n"#,
         335544802=> r#"Database dialect being changed from 3 to 1\n"#,
         335544803=> r#"Database dialect not changed.\n"#,
         335544804=> r#"Unable to create database @1\n"#,
         335544805=> r#"Database dialect @1 is not a valid dialect.\n"#,
         335544806=> r#"Valid database dialects are @1.\n"#,
         335544807=> r#"SQL warning code = @1\n"#,
         335544808=> r#"DATE data type is now called TIMESTAMP\n"#,
         335544809=> r#"Function @1 is in @2, which is not in a permitted directory for external functions.\n"#,
         335544810=> r#"value exceeds the range for valid dates\n"#,
         335544811=> r#"passed client dialect @1 is not a valid dialect.\n"#,
         335544812=> r#"Valid client dialects are @1.\n"#,
         335544813=> r#"Unsupported field type specified in BETWEEN predicate.\n"#,
         335544814=> r#"Services functionality will be supported in a later version  of the product\n"#,
         335544815=> r#"GENERATOR @1\n"#,
         335544816=> r#"Function @1\n"#,
         335544817=> r#"Invalid parameter to FETCH or FIRST. Only integers >= 0 are allowed.\n"#,
         335544818=> r#"Invalid parameter to OFFSET or SKIP. Only integers >= 0 are allowed.\n"#,
         335544819=> r#"File exceeded maximum size of 2GB.  Add another database file or use a 64 bit I/O version of Firebird.\n"#,
         335544820=> r#"Unable to find savepoint with name @1 in transaction context\n"#,
         335544821=> r#"Invalid column position used in the @1 clause\n"#,
         335544822=> r#"Cannot use an aggregate or window function in a WHERE clause, use HAVING (for aggregate only) instead\n"#,
         335544823=> r#"Cannot use an aggregate or window function in a GROUP BY clause\n"#,
         335544824=> r#"Invalid expression in the @1 (not contained in either an aggregate function or the GROUP BY clause)\n"#,
         335544825=> r#"Invalid expression in the @1 (neither an aggregate function nor a part of the GROUP BY clause)\n"#,
         335544826=> r#"Nested aggregate and window functions are not allowed\n"#,
         335544827=> r#"Invalid argument in EXECUTE STATEMENT - cannot convert to string\n"#,
         335544828=> r#"Wrong request type in EXECUTE STATEMENT '@1'\n"#,
         335544829=> r#"Variable type (position @1) in EXECUTE STATEMENT '@2' INTO does not match returned column type\n"#,
         335544830=> r#"Too many recursion levels of EXECUTE STATEMENT\n"#,
         335544831=> r#"Use of @1 at location @2 is not allowed by server configuration\n"#,
         335544832=> r#"Cannot change difference file name while database is in backup mode\n"#,
         335544833=> r#"Physical backup is not allowed while Write-Ahead Log is in use\n"#,
         335544834=> r#"Cursor is not open\n"#,
         335544835=> r#"Target shutdown mode is invalid for database "@1"\n"#,
         335544836=> r#"Concatenation overflow. Resulting string cannot exceed 32765 bytes in length.\n"#,
         335544837=> r#"Invalid offset parameter @1 to SUBSTRING. Only positive integers are allowed.\n"#,
         335544838=> r#"Foreign key reference target does not exist\n"#,
         335544839=> r#"Foreign key references are present for the record\n"#,
         335544840=> r#"cannot update\n"#,
         335544841=> r#"Cursor is already open\n"#,
         335544842=> r#"@1\n"#,
         335544843=> r#"Context variable @1 is not found in namespace @2\n"#,
         335544844=> r#"Invalid namespace name @1 passed to @2\n"#,
         335544845=> r#"Too many context variables\n"#,
         335544846=> r#"Invalid argument passed to @1\n"#,
         335544847=> r#"BLR syntax error. Identifier @1... is too long\n"#,
         335544848=> r#"exception @1\n"#,
         335544849=> r#"Malformed string\n"#,
         335544850=> r#"Output parameter mismatch for procedure @1\n"#,
         335544851=> r#"Unexpected end of command - line @1, column @2\n"#,
         335544852=> r#"partner index segment no @1 has incompatible data type\n"#,
         335544853=> r#"Invalid length parameter @1 to SUBSTRING. Negative integers are not allowed.\n"#,
         335544854=> r#"CHARACTER SET @1 is not installed\n"#,
         335544855=> r#"COLLATION @1 for CHARACTER SET @2 is not installed\n"#,
         335544856=> r#"connection shutdown\n"#,
         335544857=> r#"Maximum BLOB size exceeded\n"#,
         335544858=> r#"Can't have relation with only computed fields or constraints\n"#,
         335544859=> r#"Time precision exceeds allowed range (0-@1)\n"#,
         335544860=> r#"Unsupported conversion to target type BLOB (subtype @1)\n"#,
         335544861=> r#"Unsupported conversion to target type ARRAY\n"#,
         335544862=> r#"Stream does not support record locking\n"#,
         335544863=> r#"Cannot create foreign key constraint @1. Partner index does not exist or is inactive.\n"#,
         335544864=> r#"Transactions count exceeded. Perform backup and restore to make database operable again\n"#,
         335544865=> r#"Column has been unexpectedly deleted\n"#,
         335544866=> r#"@1 cannot depend on @2\n"#,
         335544867=> r#"Blob sub_types bigger than 1 (text) are for internal use only\n"#,
         335544868=> r#"Procedure @1 is not selectable (it does not contain a SUSPEND statement)\n"#,
         335544869=> r#"Datatype @1 is not supported for sorting operation\n"#,
         335544870=> r#"COLLATION @1\n"#,
         335544871=> r#"DOMAIN @1\n"#,
         335544872=> r#"domain @1 is not defined\n"#,
         335544873=> r#"Array data type can use up to @1 dimensions\n"#,
         335544874=> r#"A multi database transaction cannot span more than @1 databases\n"#,
         335544875=> r#"Bad debug info format\n"#,
         335544876=> r#"Error while parsing procedure @1's BLR\n"#,
         335544877=> r#"index key too big\n"#,
         335544878=> r#"concurrent transaction number is @1\n"#,
         335544879=> r#"validation error for variable @1, value "@2"\n"#,
         335544880=> r#"validation error for @1, value "@2"\n"#,
         335544881=> r#"Difference file name should be set explicitly for database on raw device\n"#,
         335544882=> r#"Login name too long (@1 characters, maximum allowed @2)\n"#,
         335544883=> r#"column @1 is not defined in procedure @2\n"#,
         335544884=> r#"Invalid SIMILAR TO pattern\n"#,
         335544885=> r#"Invalid TEB format\n"#,
         335544886=> r#"Found more than one transaction isolation in TPB\n"#,
         335544887=> r#"Table reservation lock type @1 requires table name before in TPB\n"#,
         335544888=> r#"Found more than one @1 specification in TPB\n"#,
         335544889=> r#"Option @1 requires READ COMMITTED isolation in TPB\n"#,
         335544890=> r#"Option @1 is not valid if @2 was used previously in TPB\n"#,
         335544891=> r#"Table name length missing after table reservation @1 in TPB\n"#,
         335544892=> r#"Table name length @1 is too long after table reservation @2 in TPB\n"#,
         335544893=> r#"Table name length @1 without table name after table reservation @2 in TPB\n"#,
         335544894=> r#"Table name length @1 goes beyond the remaining TPB size after table reservation @2\n"#,
         335544895=> r#"Table name length is zero after table reservation @1 in TPB\n"#,
         335544896=> r#"Table or view @1 not defined in system tables after table reservation @2 in TPB\n"#,
         335544897=> r#"Base table or view @1 for view @2 not defined in system tables after table reservation @3 in TPB\n"#,
         335544898=> r#"Option length missing after option @1 in TPB\n"#,
         335544899=> r#"Option length @1 without value after option @2 in TPB\n"#,
         335544900=> r#"Option length @1 goes beyond the remaining TPB size after option @2\n"#,
         335544901=> r#"Option length is zero after table reservation @1 in TPB\n"#,
         335544902=> r#"Option length @1 exceeds the range for option @2 in TPB\n"#,
         335544903=> r#"Option value @1 is invalid for the option @2 in TPB\n"#,
         335544904=> r#"Preserving previous table reservation @1 for table @2, stronger than new @3 in TPB\n"#,
         335544905=> r#"Table reservation @1 for table @2 already specified and is stronger than new @3 in TPB\n"#,
         335544906=> r#"Table reservation reached maximum recursion of @1 when expanding views in TPB\n"#,
         335544907=> r#"Table reservation in TPB cannot be applied to @1 because it's a virtual table\n"#,
         335544908=> r#"Table reservation in TPB cannot be applied to @1 because it's a system table\n"#,
         335544909=> r#"Table reservation @1 or @2 in TPB cannot be applied to @3 because it's a temporary table\n"#,
         335544910=> r#"Cannot set the transaction in read only mode after a table reservation isc_tpb_lock_write in TPB\n"#,
         335544911=> r#"Cannot take a table reservation isc_tpb_lock_write in TPB because the transaction is in read only mode\n"#,
         335544912=> r#"value exceeds the range for a valid time\n"#,
         335544913=> r#"value exceeds the range for valid timestamps\n"#,
         335544914=> r#"string right truncation\n"#,
         335544915=> r#"blob truncation when converting to a string: length limit exceeded\n"#,
         335544916=> r#"numeric value is out of range\n"#,
         335544917=> r#"Firebird shutdown is still in progress after the specified timeout\n"#,
         335544918=> r#"Attachment handle is busy\n"#,
         335544919=> r#"Bad written UDF detected: pointer returned in FREE_IT function was not allocated by ib_util_malloc\n"#,
         335544920=> r#"External Data Source provider '@1' not found\n"#,
         335544921=> r#"Execute statement error at @1 :@2Data source : @3\n"#,
         335544922=> r#"Execute statement preprocess SQL error\n"#,
         335544923=> r#"Statement expected\n"#,
         335544924=> r#"Parameter name expected\n"#,
         335544925=> r#"Unclosed comment found near '@1'\n"#,
         335544926=> r#"Execute statement error at @1 :@2Statement : @3Data source : @4\n"#,
         335544927=> r#"Input parameters mismatch\n"#,
         335544928=> r#"Output parameters mismatch\n"#,
         335544929=> r#"Input parameter '@1' have no value set\n"#,
         335544930=> r#"BLR stream length @1 exceeds implementation limit @2\n"#,
         335544931=> r#"Monitoring table space exhausted\n"#,
         335544932=> r#"module name or entrypoint could not be found\n"#,
         335544933=> r#"nothing to cancel\n"#,
         335544934=> r#"ib_util library has not been loaded to deallocate memory returned by FREE_IT function\n"#,
         335544935=> r#"Cannot have circular dependencies with computed fields\n"#,
         335544936=> r#"Security database error\n"#,
         335544937=> r#"Invalid data type in DATE/TIME/TIMESTAMP addition or subtraction in add_datettime()\n"#,
         335544938=> r#"Only a TIME value can be added to a DATE value\n"#,
         335544939=> r#"Only a DATE value can be added to a TIME value\n"#,
         335544940=> r#"TIMESTAMP values can be subtracted only from another TIMESTAMP value\n"#,
         335544941=> r#"Only one operand can be of type TIMESTAMP\n"#,
         335544942=> r#"Only HOUR, MINUTE, SECOND and MILLISECOND can be extracted from TIME values\n"#,
         335544943=> r#"HOUR, MINUTE, SECOND and MILLISECOND cannot be extracted from DATE values\n"#,
         335544944=> r#"Invalid argument for EXTRACT() not being of DATE/TIME/TIMESTAMP type\n"#,
         335544945=> r#"Arguments for @1 must be integral types or NUMERIC/DECIMAL without scale\n"#,
         335544946=> r#"First argument for @1 must be integral type or floating point type\n"#,
         335544947=> r#"Human readable UUID argument for @1 must be of string type\n"#,
         335544948=> r#"Human readable UUID argument for @2 must be of exact length @1\n"#,
         335544949=> r#"Human readable UUID argument for @3 must have "-" at position @2 instead of "@1"\n"#,
         335544950=> r#"Human readable UUID argument for @3 must have hex digit at position @2 instead of "@1"\n"#,
         335544951=> r#"Only HOUR, MINUTE, SECOND and MILLISECOND can be added to TIME values in @1\n"#,
         335544952=> r#"Invalid data type in addition of part to DATE/TIME/TIMESTAMP in @1\n"#,
         335544953=> r#"Invalid part @1 to be added to a DATE/TIME/TIMESTAMP value in @2\n"#,
         335544954=> r#"Expected DATE/TIME/TIMESTAMP type in evlDateAdd() result\n"#,
         335544955=> r#"Expected DATE/TIME/TIMESTAMP type as first and second argument to @1\n"#,
         335544956=> r#"The result of TIME-<value> in @1 cannot be expressed in YEAR, MONTH, DAY or WEEK\n"#,
         335544957=> r#"The result of TIME-TIMESTAMP or TIMESTAMP-TIME in @1 cannot be expressed in HOUR, MINUTE, SECOND or MILLISECOND\n"#,
         335544958=> r#"The result of DATE-TIME or TIME-DATE in @1 cannot be expressed in HOUR, MINUTE, SECOND and MILLISECOND\n"#,
         335544959=> r#"Invalid part @1 to express the difference between two DATE/TIME/TIMESTAMP values in @2\n"#,
         335544960=> r#"Argument for @1 must be positive\n"#,
         335544961=> r#"Base for @1 must be positive\n"#,
         335544962=> r#"Argument #@1 for @2 must be zero or positive\n"#,
         335544963=> r#"Argument #@1 for @2 must be positive\n"#,
         335544964=> r#"Base for @1 cannot be zero if exponent is negative\n"#,
         335544965=> r#"Base for @1 cannot be negative if exponent is not an integral value\n"#,
         335544966=> r#"The numeric scale must be between -128 and 127 in @1\n"#,
         335544967=> r#"Argument for @1 must be zero or positive\n"#,
         335544968=> r#"Binary UUID argument for @1 must be of string type\n"#,
         335544969=> r#"Binary UUID argument for @2 must use @1 bytes\n"#,
         335544970=> r#"Missing required item @1 in service parameter block\n"#,
         335544971=> r#"@1 server is shutdown\n"#,
         335544972=> r#"Invalid connection string\n"#,
         335544973=> r#"Unrecognized events block\n"#,
         335544974=> r#"Could not start first worker thread - shutdown server\n"#,
         335544975=> r#"Timeout occurred while waiting for a secondary connection for event processing\n"#,
         335544976=> r#"Argument for @1 must be different than zero\n"#,
         335544977=> r#"Argument for @1 must be in the range [-1, 1]\n"#,
         335544978=> r#"Argument for @1 must be greater or equal than one\n"#,
         335544979=> r#"Argument for @1 must be in the range ]-1, 1[\n"#,
         335544980=> r#"Incorrect parameters provided to internal function @1\n"#,
         335544981=> r#"Floating point overflow in built-in function @1\n"#,
         335544982=> r#"Floating point overflow in result from UDF @1\n"#,
         335544983=> r#"Invalid floating point value returned by UDF @1\n"#,
         335544984=> r#"Database is probably already opened by another engine instance in another Windows session\n"#,
         335544985=> r#"No free space found in temporary directories\n"#,
         335544986=> r#"Explicit transaction control is not allowed\n"#,
         335544987=> r#"Use of TRUSTED switches in spb_command_line is prohibited\n"#,
         335544988=> r#"PACKAGE @1\n"#,
         335544989=> r#"Cannot make field @1 of table @2 NOT NULL because there are NULLs present\n"#,
         335544990=> r#"Feature @1 is not supported anymore\n"#,
         335544991=> r#"VIEW @1\n"#,
         335544992=> r#"Can not access lock files directory @1\n"#,
         335544993=> r#"Fetch option @1 is invalid for a non-scrollable cursor\n"#,
         335544994=> r#"Error while parsing function @1's BLR\n"#,
         335544995=> r#"Cannot execute function @1 of the unimplemented package @2\n"#,
         335544996=> r#"Cannot execute procedure @1 of the unimplemented package @2\n"#,
         335544997=> r#"External function @1 not returned by the external engine plugin @2\n"#,
         335544998=> r#"External procedure @1 not returned by the external engine plugin @2\n"#,
         335544999=> r#"External trigger @1 not returned by the external engine plugin @2\n"#,
         335545000=> r#"Incompatible plugin version @1 for external engine @2\n"#,
         335545001=> r#"External engine @1 not found\n"#,
         335545002=> r#"Attachment is in use\n"#,
         335545003=> r#"Transaction is in use\n"#,
         335545004=> r#"Error loading plugin @1\n"#,
         335545005=> r#"Loadable module @1 not found\n"#,
         335545006=> r#"Standard plugin entrypoint does not exist in module @1\n"#,
         335545007=> r#"Module @1 exists but can not be loaded\n"#,
         335545008=> r#"Module @1 does not contain plugin @2 type @3\n"#,
         335545009=> r#"Invalid usage of context namespace DDL_TRIGGER\n"#,
         335545010=> r#"Value is NULL but isNull parameter was not informed\n"#,
         335545011=> r#"Type @1 is incompatible with BLOB\n"#,
         335545012=> r#"Invalid date\n"#,
         335545013=> r#"Invalid time\n"#,
         335545014=> r#"Invalid timestamp\n"#,
         335545015=> r#"Invalid index @1 in function @2\n"#,
         335545016=> r#"@1\n"#,
         335545017=> r#"Asynchronous call is already running for this attachment\n"#,
         335545018=> r#"Function @1 is private to package @2\n"#,
         335545019=> r#"Procedure @1 is private to package @2\n"#,
         335545020=> r#"Request can't access new records in relation @1 and should be recompiled\n"#,
         335545021=> r#"invalid events id (handle)\n"#,
         335545022=> r#"Cannot copy statement @1\n"#,
         335545023=> r#"Invalid usage of boolean expression\n"#,
         335545024=> r#"Arguments for @1 cannot both be zero\n"#,
         335545025=> r#"missing service ID in spb\n"#,
         335545026=> r#"External BLR message mismatch: invalid null descriptor at field @1\n"#,
         335545027=> r#"External BLR message mismatch: length = @1, expected @2\n"#,
         335545028=> r#"Subscript @1 out of bounds [@2, @3]\n"#,
         335545029=> r#"Install incomplete. To complete security database initialization please CREATE USER. For details read doc/README.security_database.txt.\n"#,
         335545030=> r#"@1 operation is not allowed for system table @2\n"#,
         335545031=> r#"Libtommath error code @1 in function @2\n"#,
         335545032=> r#"unsupported BLR version (expected between @1 and @2, encountered @3)\n"#,
         335545033=> r#"expected length @1, actual @2\n"#,
         335545034=> r#"Wrong info requested in isc_svc_query() for anonymous service\n"#,
         335545035=> r#"No isc_info_svc_stdin in user request, but service thread requested stdin data\n"#,
         335545036=> r#"Start request for anonymous service is impossible\n"#,
         335545037=> r#"All services except for getting server log require switches\n"#,
         335545038=> r#"Size of stdin data is more than was requested from client\n"#,
         335545039=> r#"Crypt plugin @1 failed to load\n"#,
         335545040=> r#"Length of crypt plugin name should not exceed @1 bytes\n"#,
         335545041=> r#"Crypt failed - already crypting database\n"#,
         335545042=> r#"Crypt failed - database is already in requested state\n"#,
         335545043=> r#"Missing crypt plugin, but page appears encrypted\n"#,
         335545044=> r#"No providers loaded\n"#,
         335545045=> r#"NULL data with non-zero SPB length\n"#,
         335545046=> r#"Maximum (@1) number of arguments exceeded for function @2\n"#,
         335545047=> r#"External BLR message mismatch: names count = @1, blr count = @2\n"#,
         335545048=> r#"External BLR message mismatch: name @1 not found\n"#,
         335545049=> r#"Invalid resultset interface\n"#,
         335545050=> r#"Message length passed from user application does not match set of columns\n"#,
         335545051=> r#"Resultset is missing output format information\n"#,
         335545052=> r#"Message metadata not ready - item @1 is not finished\n"#,
         335545053=> r#"Missing configuration file: @1\n"#,
         335545054=> r#"@1: illegal line <@2>\n"#,
         335545055=> r#"Invalid include operator in @1 for <@2>\n"#,
         335545056=> r#"Include depth too big\n"#,
         335545057=> r#"File to include not found\n"#,
         335545058=> r#"Only the owner can change the ownership\n"#,
         335545059=> r#"undefined variable number\n"#,
         335545060=> r#"Missing security context for @1\n"#,
         335545061=> r#"Missing segment @1 in multisegment connect block parameter\n"#,
         335545062=> r#"Different logins in connect and attach packets - client library error\n"#,
         335545063=> r#"Exceeded exchange limit during authentication handshake\n"#,
         335545064=> r#"Incompatible wire encryption levels requested on client and server\n"#,
         335545065=> r#"Client attempted to attach unencrypted but wire encryption is required\n"#,
         335545066=> r#"Client attempted to start wire encryption using unknown key @1\n"#,
         335545067=> r#"Client attempted to start wire encryption using unsupported plugin @1\n"#,
         335545068=> r#"Error getting security database name from configuration file\n"#,
         335545069=> r#"Client authentication plugin is missing required data from server\n"#,
         335545070=> r#"Client authentication plugin expected @2 bytes of @3 from server, got @1\n"#,
         335545071=> r#"Attempt to get information about an unprepared dynamic SQL statement.\n"#,
         335545072=> r#"Problematic key value is @1\n"#,
         335545073=> r#"Cannot select virtual table @1 for update WITH LOCK\n"#,
         335545074=> r#"Cannot select system table @1 for update WITH LOCK\n"#,
         335545075=> r#"Cannot select temporary table @1 for update WITH LOCK\n"#,
         335545076=> r#"System @1 @2 cannot be modified\n"#,
         335545077=> r#"Server misconfigured - contact administrator please\n"#,
         335545078=> r#"Deprecated backward compatibility ALTER ROLE ... SET/DROP AUTO ADMIN mapping may be used only for RDB$ADMIN role\n"#,
         335545079=> r#"Mapping @1 already exists\n"#,
         335545080=> r#"Mapping @1 does not exist\n"#,
         335545081=> r#"@1 failed when loading mapping cache\n"#,
         335545082=> r#"Invalid name <*> in authentication block\n"#,
         335545083=> r#"Multiple maps found for @1\n"#,
         335545084=> r#"Undefined mapping result - more than one different results found\n"#,
         335545085=> r#"Incompatible mode of attachment to damaged database\n"#,
         335545086=> r#"Attempt to set in database number of buffers which is out of acceptable range [@1:@2]\n"#,
         335545087=> r#"Attempt to temporarily set number of buffers less than @1\n"#,
         335545088=> r#"Global mapping is not available when database @1 is not present\n"#,
         335545089=> r#"Global mapping is not available when table RDB$MAP is not present in database @1\n"#,
         335545090=> r#"Your attachment has no trusted role\n"#,
         335545091=> r#"Role @1 is invalid or unavailable\n"#,
         335545092=> r#"Cursor @1 is not positioned in a valid record\n"#,
         335545093=> r#"Duplicated user attribute @1\n"#,
         335545094=> r#"There is no privilege for this operation\n"#,
         335545095=> r#"Using GRANT OPTION on @1 not allowed\n"#,
         335545096=> r#"read conflicts with concurrent update\n"#,
         335545097=> r#"@1 failed when working with CREATE DATABASE grants\n"#,
         335545098=> r#"CREATE DATABASE grants check is not possible when database @1 is not present\n"#,
         335545099=> r#"CREATE DATABASE grants check is not possible when table RDB$DB_CREATORS is not present in database @1\n"#,
         335545100=> r#"Interface @3 version too old: expected @1, found @2\n"#,
         335545101=> r#"Input parameter mismatch for function @1\n"#,
         335545102=> r#"Error during savepoint backout - transaction invalidated\n"#,
         335545103=> r#"Domain used in the PRIMARY KEY constraint of table @1 must be NOT NULL\n"#,
         335545104=> r#"CHARACTER SET @1 cannot be used as a attachment character set\n"#,
         335545105=> r#"Some database(s) were shutdown when trying to read mapping data\n"#,
         335545106=> r#"Error occurred during login, please check server firebird.log for details\n"#,
         335545107=> r#"Database already opened with engine instance, incompatible with current\n"#,
         335545108=> r#"Invalid crypt key @1\n"#,
         335545109=> r#"Page requires encryption but crypt plugin is missing\n"#,
         335545110=> r#"Maximum index depth (@1 levels) is reached\n"#,
         335545111=> r#"System privilege @1 does not exist\n"#,
         335545112=> r#"System privilege @1 is missing\n"#,
         335545113=> r#"Invalid or missing checksum of encrypted database\n"#,
         335545114=> r#"You must have SYSDBA rights at this server\n"#,
         335545115=> r#"Cannot open cursor for non-SELECT statement\n"#,
         335545116=> r#"If <window frame bound 1> specifies @1, then <window frame bound 2> shall not specify @2\n"#,
         335545117=> r#"RANGE based window with <expr> {PRECEDING | FOLLOWING} cannot have ORDER BY with more than one value\n"#,
         335545118=> r#"RANGE based window must have an ORDER BY key of numerical, date, time or timestamp types\n"#,
         335545119=> r#"Window RANGE/ROWS PRECEDING/FOLLOWING value must be of a numerical type\n"#,
         335545120=> r#"Invalid PRECEDING or FOLLOWING offset in window function: cannot be negative\n"#,
         335545121=> r#"Window @1 not found\n"#,
         335545122=> r#"Cannot use PARTITION BY clause while overriding the window @1\n"#,
         335545123=> r#"Cannot use ORDER BY clause while overriding the window @1 which already has an ORDER BY clause\n"#,
         335545124=> r#"Cannot override the window @1 because it has a frame clause. Tip: it can be used without parenthesis in OVER\n"#,
         335545125=> r#"Duplicate window definition for @1\n"#,
         335545126=> r#"SQL statement is too long. Maximum size is @1 bytes.\n"#,
         335545127=> r#"Config level timeout expired.\n"#,
         335545128=> r#"Attachment level timeout expired.\n"#,
         335545129=> r#"Statement level timeout expired.\n"#,
         335545130=> r#"Killed by database administrator.\n"#,
         335545131=> r#"Idle timeout expired.\n"#,
         335545132=> r#"Database is shutdown.\n"#,
         335545133=> r#"Engine is shutdown.\n"#,
         335545134=> r#"OVERRIDING clause can be used only when an identity column is present in the INSERT's field list for table/view @1\n"#,
         335545135=> r#"OVERRIDING SYSTEM VALUE can be used only for identity column defined as 'GENERATED ALWAYS' in INSERT for table/view @1\n"#,
         335545136=> r#"OVERRIDING USER VALUE can be used only for identity column defined as 'GENERATED BY DEFAULT' in INSERT for table/view @1\n"#,
         335545137=> r#"OVERRIDING SYSTEM VALUE should be used to override the value of an identity column defined as 'GENERATED ALWAYS' in table/view @1\n"#,
         335545138=> r#"DecFloat precision must be 16 or 34\n"#,
         335545139=> r#"Decimal float divide by zero.  The code attempted to divide a DECFLOAT value by zero.\n"#,
         335545140=> r#"Decimal float inexact result.  The result of an operation cannot be represented as a decimal fraction.\n"#,
         335545141=> r#"Decimal float invalid operation.  An indeterminant error occurred during an operation.\n"#,
         335545142=> r#"Decimal float overflow.  The exponent of a result is greater than the magnitude allowed.\n"#,
         335545143=> r#"Decimal float underflow.  The exponent of a result is less than the magnitude allowed.\n"#,
         335545144=> r#"Sub-function @1 has not been defined\n"#,
         335545145=> r#"Sub-procedure @1 has not been defined\n"#,
         335545146=> r#"Sub-function @1 has a signature mismatch with its forward declaration\n"#,
         335545147=> r#"Sub-procedure @1 has a signature mismatch with its forward declaration\n"#,
         335545148=> r#"Default values for parameters are not allowed in definition of the previously declared sub-function @1\n"#,
         335545149=> r#"Default values for parameters are not allowed in definition of the previously declared sub-procedure @1\n"#,
         335545150=> r#"Sub-function @1 was declared but not implemented\n"#,
         335545151=> r#"Sub-procedure @1 was declared but not implemented\n"#,
         335545152=> r#"Invalid HASH algorithm @1\n"#,
         335545153=> r#"Expression evaluation error for index "@1" on table "@2"\n"#,
         335545154=> r#"Invalid decfloat trap state @1\n"#,
         335545155=> r#"Invalid decfloat rounding mode @1\n"#,
         335545156=> r#"Invalid part @1 to calculate the @1 of a DATE/TIMESTAMP\n"#,
         335545157=> r#"Expected DATE/TIMESTAMP value in @1\n"#,
         335545158=> r#"Precision must be from @1 to @2\n"#,
         335545159=> r#"invalid batch handle\n"#,
         335545160=> r#"Bad international character in tag @1\n"#,
         335545161=> r#"Null data in parameters block with non-zero length\n"#,
         335545162=> r#"Items working with running service and getting generic server information should not be mixed in single info block\n"#,
         335545163=> r#"Unknown information item, code @1\n"#,
         335545164=> r#"Wrong version of blob parameters block @1, should be @2\n"#,
         335545165=> r#"User management plugin is missing or failed to load\n"#,
         335545166=> r#"Missing entrypoint @1 in ICU library\n"#,
         335545167=> r#"Could not find acceptable ICU library\n"#,
         335545168=> r#"Name @1 not found in system MetadataBuilder\n"#,
         335545169=> r#"Parse to tokens error\n"#,
         335545170=> r#"Error opening international conversion descriptor from @1 to @2\n"#,
         335545171=> r#"Message @1 is out of range, only @2 messages in batch\n"#,
         335545172=> r#"Detailed error info for message @1 is missing in batch\n"#,
         335545173=> r#"Compression stream init error @1\n"#,
         335545174=> r#"Decompression stream init error @1\n"#,
         335545175=> r#"Segment size (@1) should not exceed 65535 (64K - 1) when using segmented blob\n"#,
         335545176=> r#"Invalid blob policy in the batch for @1() call\n"#,
         335545177=> r#"Can't change default BPB after adding any data to batch\n"#,
         335545178=> r#"Unexpected info buffer structure querying for default blob alignment\n"#,
         335545179=> r#"Duplicated segment @1 in multisegment connect block parameter\n"#,
         335545180=> r#"Plugin not supported by network protocol\n"#,
         335545181=> r#"Error parsing message format\n"#,
         335545182=> r#"Wrong version of batch parameters block @1, should be @2\n"#,
         335545183=> r#"Message size (@1) in batch exceeds internal buffer size (@2)\n"#,
         335545184=> r#"Batch already opened for this statement\n"#,
         335545185=> r#"Invalid type of statement used in batch\n"#,
         335545186=> r#"Statement used in batch must have parameters\n"#,
         335545187=> r#"There are no blobs in associated with batch statement\n"#,
         335545188=> r#"appendBlobData() is used to append data to last blob but no such blob was added to the batch\n"#,
         335545189=> r#"Portions of data, passed as blob stream, should have size multiple to the alignment required for blobs\n"#,
         335545190=> r#"Repeated blob id @1 in registerBlob()\n"#,
         335545191=> r#"Blob buffer format error\n"#,
         335545192=> r#"Unusable (too small) data remained in @1 buffer\n"#,
         335545193=> r#"Blob continuation should not contain BPB\n"#,
         335545194=> r#"Size of BPB (@1) greater than remaining data (@2)\n"#,
         335545195=> r#"Size of segment (@1) greater than current BLOB data (@2)\n"#,
         335545196=> r#"Size of segment (@1) greater than available data (@2)\n"#,
         335545197=> r#"Unknown blob ID @1 in the batch message\n"#,
         335545198=> r#"Internal buffer overflow - batch too big\n"#,
         335545199=> r#"Numeric literal too long\n"#,
         335545200=> r#"Error using events in mapping shared memory: @1\n"#,
         335545201=> r#"Global mapping memory overflow\n"#,
         335545202=> r#"Header page overflow - too many clumplets on it\n"#,
         335545203=> r#"No matching client/server authentication plugins configured for execute statement in embedded datasource\n"#,
         335545204=> r#"Missing database encryption key for your attachment\n"#,
         335545205=> r#"Key holder plugin @1 failed to load\n"#,
         335545206=> r#"Cannot reset user session\n"#,
         335545207=> r#"There are open transactions (@1 active)\n"#,
         335545208=> r#"Session was reset with warning(s)\n"#,
         335545209=> r#"Transaction is rolled back due to session reset, all changes are lost\n"#,
         335545210=> r#"Plugin @1:\n"#,
         335545211=> r#"PARAMETER @1\n"#,
         335545212=> r#"Starting page number for file @1 must be @2 or greater\n"#,
         335545213=> r#"Invalid time zone offset: @1 - must use format +/-hours:minutes and be between -14:00 and +14:00\n"#,
         335545214=> r#"Invalid time zone region: @1\n"#,
         335545215=> r#"Invalid time zone ID: @1\n"#,
         335545216=> r#"Wrong base64 text length @1, should be multiple of 4\n"#,
         335545217=> r#"Invalid first parameter datatype - need string or blob\n"#,
         335545218=> r#"Error registering @1 - probably bad tomcrypt library\n"#,
         335545219=> r#"Unknown crypt algorithm @1 in USING clause\n"#,
         335545220=> r#"Should specify mode parameter for symmetric cipher\n"#,
         335545221=> r#"Unknown symmetric crypt mode specified\n"#,
         335545222=> r#"Mode parameter makes no sense for chosen cipher\n"#,
         335545223=> r#"Should specify initialization vector (IV) for chosen cipher and/or mode\n"#,
         335545224=> r#"Initialization vector (IV) makes no sense for chosen cipher and/or mode\n"#,
         335545225=> r#"Invalid counter endianess @1\n"#,
         335545226=> r#"Counter endianess parameter is not used in mode @1\n"#,
         335545227=> r#"Too big counter value @1, maximum @2 can be used\n"#,
         335545228=> r#"Counter length/value parameter is not used with @1 @2\n"#,
         335545229=> r#"Invalid initialization vector (IV) length @1, need @2\n"#,
         335545230=> r#"TomCrypt library error: @1\n"#,
         335545231=> r#"Starting PRNG yarrow\n"#,
         335545232=> r#"Setting up PRNG yarrow\n"#,
         335545233=> r#"Initializing @1 mode\n"#,
         335545234=> r#"Encrypting in @1 mode\n"#,
         335545235=> r#"Decrypting in @1 mode\n"#,
         335545236=> r#"Initializing cipher @1\n"#,
         335545237=> r#"Encrypting using cipher @1\n"#,
         335545238=> r#"Decrypting using cipher @1\n"#,
         335545239=> r#"Setting initialization vector (IV) for @1\n"#,
         335545240=> r#"Invalid initialization vector (IV) length @1, need  8 or 12\n"#,
         335545241=> r#"Encoding @1\n"#,
         335545242=> r#"Decoding @1\n"#,
         335545243=> r#"Importing RSA key\n"#,
         335545244=> r#"Invalid OAEP packet\n"#,
         335545245=> r#"Unknown hash algorithm @1\n"#,
         335545246=> r#"Making RSA key\n"#,
         335545247=> r#"Exporting @1 RSA key\n"#,
         335545248=> r#"RSA-signing data\n"#,
         335545249=> r#"Verifying RSA-signed data\n"#,
         335545250=> r#"Invalid key length @1, need 16 or 32\n"#,
         335545251=> r#"invalid replicator handle\n"#,
         335545252=> r#"Transaction's base snapshot number does not exist\n"#,
         335545253=> r#"Input parameter '@1' is not used in SQL query text\n"#,
         335545254=> r#"Effective user is @1\n"#,
         335545255=> r#"Invalid time zone bind mode @1\n"#,
         335545256=> r#"Invalid decfloat bind mode @1\n"#,
         335545257=> r#"Invalid hex text length @1, should be multiple of 2\n"#,
         335545258=> r#"Invalid hex digit @1 at position @2\n"#,
         335545259=> r#"Error processing isc_dpb_set_bind clumplet "@1"\n"#,
         335545260=> r#"The following statement failed: @1\n"#,
         335545261=> r#"Can not convert @1 to @2\n"#,
         335545262=> r#"cannot update old BLOB\n"#,
         335545263=> r#"cannot read from new BLOB\n"#,
         335545264=> r#"No permission for CREATE @1 operation\n"#,
         335545265=> r#"SUSPEND could not be used without RETURNS clause in PROCEDURE or EXECUTE BLOCK\n"#,
         335545266=> r#"String truncated warning due to the following reason\n"#,
         335545267=> r#"Monitoring data does not fit into the field\n"#,
         335545268=> r#"Engine data does not fit into return value of system function\n"#,
         335545269=> r#"Multiple source records cannot match the same target during MERGE\n"#,
         335545270=> r#"RDB$PAGES written by non-system transaction, DB appears to be damaged\n"#,
         335545271=> r#"Replication error\n"#,
         335545272=> r#"Reset of user session failed. Connection is shut down.\n"#,
         335545273=> r#"File size is less than expected\n"#,
         335545274=> r#"Invalid key length @1, need >@2\n"#,
         335545275=> r#"Invalid information arguments\n"#,
         335740929=> r#"data base file name (@1) already given\n"#,
         335740930=> r#"invalid switch @1\n"#,
         335740932=> r#"incompatible switch combination\n"#,
         335740933=> r#"replay log pathname required\n"#,
         335740934=> r#"number of page buffers for cache required\n"#,
         335740935=> r#"numeric value required\n"#,
         335740936=> r#"positive numeric value required\n"#,
         335740937=> r#"number of transactions per sweep required\n"#,
         335740940=> r#""full" or "reserve" required\n"#,
         335740941=> r#"user name required\n"#,
         335740942=> r#"password required\n"#,
         335740943=> r#"subsystem name\n"#,
         335740944=> r#""wal" required\n"#,
         335740945=> r#"number of seconds required\n"#,
         335740946=> r#"numeric value between 0 and 32767 inclusive required\n"#,
         335740947=> r#"must specify type of shutdown\n"#,
         335740948=> r#"please retry, specifying an option\n"#,
         335740951=> r#"please retry, giving a database name\n"#,
         335740991=> r#"internal block exceeds maximum size\n"#,
         335740992=> r#"corrupt pool\n"#,
         335740993=> r#"virtual memory exhausted\n"#,
         335740994=> r#"bad pool id\n"#,
         335740995=> r#"Transaction state @1 not in valid range.\n"#,
         335741012=> r#"unexpected end of input\n"#,
         335741018=> r#"failed to reconnect to a transaction in database @1\n"#,
         335741036=> r#"Transaction description item unknown\n"#,
         335741038=> r#""read_only" or "read_write" required\n"#,
         335741042=> r#"positive or zero numeric value required\n"#,
         336003074=> r#"Cannot SELECT RDB$DB_KEY from a stored procedure.\n"#,
         336003075=> r#"Precision 10 to 18 changed from DOUBLE PRECISION in SQL dialect 1 to 64-bit scaled integer in SQL dialect 3\n"#,
         336003076=> r#"Use of @1 expression that returns different results in dialect 1 and dialect 3\n"#,
         336003077=> r#"Database SQL dialect @1 does not support reference to @2 datatype\n"#,
         336003079=> r#"DB dialect @1 and client dialect @2 conflict with respect to numeric precision @3.\n"#,
         336003080=> r#"WARNING: Numeric literal @1 is interpreted as a floating-point\n"#,
         336003081=> r#"value in SQL dialect 1, but as an exact numeric value in SQL dialect 3.\n"#,
         336003082=> r#"WARNING: NUMERIC and DECIMAL fields with precision 10 or greater are stored\n"#,
         336003083=> r#"as approximate floating-point values in SQL dialect 1, but as 64-bit\n"#,
         336003084=> r#"integers in SQL dialect 3.\n"#,
         336003085=> r#"Ambiguous field name between @1 and @2\n"#,
         336003086=> r#"External function should have return position between 1 and @1\n"#,
         336003087=> r#"Label @1 @2 in the current scope\n"#,
         336003088=> r#"Datatypes @1are not comparable in expression @2\n"#,
         336003089=> r#"Empty cursor name is not allowed\n"#,
         336003090=> r#"Statement already has a cursor @1 assigned\n"#,
         336003091=> r#"Cursor @1 is not found in the current context\n"#,
         336003092=> r#"Cursor @1 already exists in the current context\n"#,
         336003093=> r#"Relation @1 is ambiguous in cursor @2\n"#,
         336003094=> r#"Relation @1 is not found in cursor @2\n"#,
         336003095=> r#"Cursor is not open\n"#,
         336003096=> r#"Data type @1 is not supported for EXTERNAL TABLES. Relation '@2', field '@3'\n"#,
         336003097=> r#"Feature not supported on ODS version older than @1.@2\n"#,
         336003098=> r#"Primary key required on table @1\n"#,
         336003099=> r#"UPDATE OR INSERT field list does not match primary key of table @1\n"#,
         336003100=> r#"UPDATE OR INSERT field list does not match MATCHING clause\n"#,
         336003101=> r#"UPDATE OR INSERT without MATCHING could not be used with views based on more than one table\n"#,
         336003102=> r#"Incompatible trigger type\n"#,
         336003103=> r#"Database trigger type can't be changed\n"#,
         336003104=> r#"To be used with RDB$RECORD_VERSION, @1 must be a table or a view of single table\n"#,
         336003105=> r#"SQLDA version expected between @1 and @2, found @3\n"#,
         336003106=> r#"at SQLVAR index @1\n"#,
         336003107=> r#"empty pointer to NULL indicator variable\n"#,
         336003108=> r#"empty pointer to data\n"#,
         336003109=> r#"No SQLDA for input values provided\n"#,
         336003110=> r#"No SQLDA for output values provided\n"#,
         336003111=> r#"Wrong number of parameters (expected @1, got @2)\n"#,
         336003112=> r#"Invalid DROP SQL SECURITY clause\n"#,
         336003113=> r#"UPDATE OR INSERT value for field @1, part of the implicit or explicit MATCHING clause, cannot be DEFAULT\n"#,
         336068645=> r#"BLOB Filter @1 not found\n"#,
         336068649=> r#"Function @1 not found\n"#,
         336068656=> r#"Index not found\n"#,
         336068662=> r#"View @1 not found\n"#,
         336068697=> r#"Domain not found\n"#,
         336068717=> r#"Triggers created automatically cannot be modified\n"#,
         336068740=> r#"Table @1 already exists\n"#,
         336068748=> r#"Procedure @1 not found\n"#,
         336068752=> r#"Exception not found\n"#,
         336068754=> r#"Parameter @1 in procedure @2 not found\n"#,
         336068755=> r#"Trigger @1 not found\n"#,
         336068759=> r#"Character set @1 not found\n"#,
         336068760=> r#"Collation @1 not found\n"#,
         336068763=> r#"Role @1 not found\n"#,
         336068767=> r#"Name longer than database column size\n"#,
         336068784=> r#"column @1 does not exist in table/view @2\n"#,
         336068796=> r#"SQL role @1 does not exist\n"#,
         336068797=> r#"user @1 has no grant admin option on SQL role @2\n"#,
         336068798=> r#"user @1 is not a member of SQL role @2\n"#,
         336068799=> r#"@1 is not the owner of SQL role @2\n"#,
         336068800=> r#"@1 is a SQL role and not a user\n"#,
         336068801=> r#"user name @1 could not be used for SQL role\n"#,
         336068802=> r#"SQL role @1 already exists\n"#,
         336068803=> r#"keyword @1 can not be used as a SQL role name\n"#,
         336068804=> r#"SQL roles are not supported in on older versions of the database.  A backup and restore of the database is required.\n"#,
         336068812=> r#"Cannot rename domain @1 to @2.  A domain with that name already exists.\n"#,
         336068813=> r#"Cannot rename column @1 to @2.  A column with that name already exists in table @3.\n"#,
         336068814=> r#"Column @1 from table @2 is referenced in @3\n"#,
         336068815=> r#"Cannot change datatype for column @1.  Changing datatype is not supported for BLOB or ARRAY columns.\n"#,
         336068816=> r#"New size specified for column @1 must be at least @2 characters.\n"#,
         336068817=> r#"Cannot change datatype for @1.  Conversion from base type @2 to @3 is not supported.\n"#,
         336068818=> r#"Cannot change datatype for column @1 from a character type to a non-character type.\n"#,
         336068820=> r#"Zero length identifiers are not allowed\n"#,
         336068822=> r#"Sequence @1 not found\n"#,
         336068829=> r#"Maximum number of collations per character set exceeded\n"#,
         336068830=> r#"Invalid collation attributes\n"#,
         336068840=> r#"@1 cannot reference @2\n"#,
         336068843=> r#"Collation @1 is used in table @2 (field name @3) and cannot be dropped\n"#,
         336068844=> r#"Collation @1 is used in domain @2 and cannot be dropped\n"#,
         336068845=> r#"Cannot delete system collation\n"#,
         336068846=> r#"Cannot delete default collation of CHARACTER SET @1\n"#,
         336068849=> r#"Table @1 not found\n"#,
         336068851=> r#"Collation @1 is used in procedure @2 (parameter name @3) and cannot be dropped\n"#,
         336068852=> r#"New scale specified for column @1 must be at most @2.\n"#,
         336068853=> r#"New precision specified for column @1 must be at least @2.\n"#,
         336068855=> r#"Warning: @1 on @2 is not granted to @3.\n"#,
         336068856=> r#"Feature '@1' is not supported in ODS @2.@3\n"#,
         336068857=> r#"Cannot add or remove COMPUTED from column @1\n"#,
         336068858=> r#"Password should not be empty string\n"#,
         336068859=> r#"Index @1 already exists\n"#,
         336068864=> r#"Package @1 not found\n"#,
         336068865=> r#"Schema @1 not found\n"#,
         336068866=> r#"Cannot ALTER or DROP system procedure @1\n"#,
         336068867=> r#"Cannot ALTER or DROP system trigger @1\n"#,
         336068868=> r#"Cannot ALTER or DROP system function @1\n"#,
         336068869=> r#"Invalid DDL statement for procedure @1\n"#,
         336068870=> r#"Invalid DDL statement for trigger @1\n"#,
         336068871=> r#"Function @1 has not been defined on the package body @2\n"#,
         336068872=> r#"Procedure @1 has not been defined on the package body @2\n"#,
         336068873=> r#"Function @1 has a signature mismatch on package body @2\n"#,
         336068874=> r#"Procedure @1 has a signature mismatch on package body @2\n"#,
         336068875=> r#"Default values for parameters are not allowed in the definition of a previously declared packaged procedure @1.@2\n"#,
         336068877=> r#"Package body @1 already exists\n"#,
         336068878=> r#"Invalid DDL statement for function @1\n"#,
         336068879=> r#"Cannot alter new style function @1 with ALTER EXTERNAL FUNCTION. Use ALTER FUNCTION instead.\n"#,
         336068886=> r#"Parameter @1 in function @2 not found\n"#,
         336068887=> r#"Parameter @1 of routine @2 not found\n"#,
         336068888=> r#"Parameter @1 of routine @2 is ambiguous (found in both procedures and functions). Use a specifier keyword.\n"#,
         336068889=> r#"Collation @1 is used in function @2 (parameter name @3) and cannot be dropped\n"#,
         336068890=> r#"Domain @1 is used in function @2 (parameter name @3) and cannot be dropped\n"#,
         336068891=> r#"ALTER USER requires at least one clause to be specified\n"#,
         336068894=> r#"Duplicate @1 @2\n"#,
         336068895=> r#"System @1 @2 cannot be modified\n"#,
         336068896=> r#"INCREMENT BY 0 is an illegal option for sequence @1\n"#,
         336068897=> r#"Can't use @1 in FOREIGN KEY constraint\n"#,
         336068898=> r#"Default values for parameters are not allowed in the definition of a previously declared packaged function @1.@2\n"#,
         336068900=> r#"role @1 can not be granted to role @2\n"#,
         336068904=> r#"INCREMENT BY 0 is an illegal option for identity column @1 of table @2\n"#,
         336068907=> r#"no @1 privilege with grant option on DDL @2\n"#,
         336068908=> r#"no @1 privilege with grant option on object @2\n"#,
         336068909=> r#"Function @1 does not exist\n"#,
         336068910=> r#"Procedure @1 does not exist\n"#,
         336068911=> r#"Package @1 does not exist\n"#,
         336068912=> r#"Trigger @1 does not exist\n"#,
         336068913=> r#"View @1 does not exist\n"#,
         336068914=> r#"Table @1 does not exist\n"#,
         336068915=> r#"Exception @1 does not exist\n"#,
         336068916=> r#"Generator/Sequence @1 does not exist\n"#,
         336068917=> r#"Field @1 of table @2 does not exist\n"#,
         336330753=> r#"found unknown switch\n"#,
         336330754=> r#"page size parameter missing\n"#,
         336330755=> r#"Page size specified (@1) greater than limit (32768 bytes)\n"#,
         336330756=> r#"redirect location for output is not specified\n"#,
         336330757=> r#"conflicting switches for backup/restore\n"#,
         336330758=> r#"device type @1 not known\n"#,
         336330759=> r#"protection is not there yet\n"#,
         336330760=> r#"page size is allowed only on restore or create\n"#,
         336330761=> r#"multiple sources or destinations specified\n"#,
         336330762=> r#"requires both input and output filenames\n"#,
         336330763=> r#"input and output have the same name.  Disallowed.\n"#,
         336330764=> r#"expected page size, encountered "@1"\n"#,
         336330765=> r#"REPLACE specified, but the first file @1 is a database\n"#,
         336330766=> r#"database @1 already exists.  To replace it, use the -REP switch\n"#,
         336330767=> r#"device type not specified\n"#,
         336330772=> r#"gds_$blob_info failed\n"#,
         336330773=> r#"do not understand BLOB INFO item @1\n"#,
         336330774=> r#"gds_$get_segment failed\n"#,
         336330775=> r#"gds_$close_blob failed\n"#,
         336330776=> r#"gds_$open_blob failed\n"#,
         336330777=> r#"Failed in put_blr_gen_id\n"#,
         336330778=> r#"data type @1 not understood\n"#,
         336330779=> r#"gds_$compile_request failed\n"#,
         336330780=> r#"gds_$start_request failed\n"#,
         336330781=> r#"gds_$receive failed\n"#,
         336330782=> r#"gds_$release_request failed\n"#,
         336330783=> r#"gds_$database_info failed\n"#,
         336330784=> r#"Expected database description record\n"#,
         336330785=> r#"failed to create database @1\n"#,
         336330786=> r#"RESTORE: decompression length error\n"#,
         336330787=> r#"cannot find table @1\n"#,
         336330788=> r#"Cannot find column for BLOB\n"#,
         336330789=> r#"gds_$create_blob failed\n"#,
         336330790=> r#"gds_$put_segment failed\n"#,
         336330791=> r#"expected record length\n"#,
         336330792=> r#"wrong length record, expected @1 encountered @2\n"#,
         336330793=> r#"expected data attribute\n"#,
         336330794=> r#"Failed in store_blr_gen_id\n"#,
         336330795=> r#"do not recognize record type @1\n"#,
         336330796=> r#"Expected backup version 1..10.  Found @1\n"#,
         336330797=> r#"expected backup description record\n"#,
         336330798=> r#"string truncated\n"#,
         336330799=> r#"warning -- record could not be restored\n"#,
         336330800=> r#"gds_$send failed\n"#,
         336330801=> r#"no table name for data\n"#,
         336330802=> r#"unexpected end of file on backup file\n"#,
         336330803=> r#"database format @1 is too old to restore to\n"#,
         336330804=> r#"array dimension for column @1 is invalid\n"#,
         336330807=> r#"Expected XDR record length\n"#,
         336330817=> r#"cannot open backup file @1\n"#,
         336330818=> r#"cannot open status and error output file @1\n"#,
         336330934=> r#"blocking factor parameter missing\n"#,
         336330935=> r#"expected blocking factor, encountered "@1"\n"#,
         336330936=> r#"a blocking factor may not be used in conjunction with device CT\n"#,
         336330940=> r#"user name parameter missing\n"#,
         336330941=> r#"password parameter missing\n"#,
         336330952=> r#" missing parameter for the number of bytes to be skipped\n"#,
         336330953=> r#"expected number of bytes to be skipped, encountered "@1"\n"#,
         336330965=> r#"character set\n"#,
         336330967=> r#"collation\n"#,
         336330972=> r#"Unexpected I/O error while reading from backup file\n"#,
         336330973=> r#"Unexpected I/O error while writing to backup file\n"#,
         336330985=> r#"could not drop database @1 (no privilege or database might be in use)\n"#,
         336330990=> r#"System memory exhausted\n"#,
         336331002=> r#"SQL role\n"#,
         336331005=> r#"SQL role parameter missing\n"#,
         336331010=> r#"page buffers parameter missing\n"#,
         336331011=> r#"expected page buffers, encountered "@1"\n"#,
         336331012=> r#"page buffers is allowed only on restore or create\n"#,
         336331014=> r#"size specification either missing or incorrect for file @1\n"#,
         336331015=> r#"file @1 out of sequence\n"#,
         336331016=> r#"can't join -- one of the files missing\n"#,
         336331017=> r#" standard input is not supported when using join operation\n"#,
         336331018=> r#"standard output is not supported when using split operation or in verbose mode\n"#,
         336331019=> r#"backup file @1 might be corrupt\n"#,
         336331020=> r#"database file specification missing\n"#,
         336331021=> r#"can't write a header record to file @1\n"#,
         336331022=> r#"free disk space exhausted\n"#,
         336331023=> r#"file size given (@1) is less than minimum allowed (@2)\n"#,
         336331025=> r#"service name parameter missing\n"#,
         336331026=> r#"Cannot restore over current database, must be SYSDBA or owner of the existing database.\n"#,
         336331031=> r#""read_only" or "read_write" required\n"#,
         336331033=> r#"just data ignore all constraints etc.\n"#,
         336331034=> r#"restoring data only ignoring foreign key, unique, not null & other constraints\n"#,
         336331078=> r#"verbose interval value parameter missing\n"#,
         336331079=> r#"verbose interval value cannot be smaller than @1\n"#,
         336331081=> r#"verify (verbose) and verbint options are mutually exclusive\n"#,
         336331082=> r#"option -@1 is allowed only on restore or create\n"#,
         336331083=> r#"option -@1 is allowed only on backup\n"#,
         336331084=> r#"options -@1 and -@2 are mutually exclusive\n"#,
         336331085=> r#"parameter for option -@1 was already specified with value "@2"\n"#,
         336331086=> r#"option -@1 was already specified\n"#,
         336331091=> r#"dependency depth greater than @1 for view @2\n"#,
         336331092=> r#"value greater than @1 when calculating length of rdb$db_key for view @2\n"#,
         336331093=> r#"Invalid metadata detected. Use -FIX_FSS_METADATA option.\n"#,
         336331094=> r#"Invalid data detected. Use -FIX_FSS_DATA option.\n"#,
         336331096=> r#"Expected backup version @2..@3.  Found @1\n"#,
         336331100=> r#"database format @1 is too old to backup\n"#,
         336397205=> r#"ODS versions before ODS@1 are not supported\n"#,
         336397206=> r#"Table @1 does not exist\n"#,
         336397207=> r#"View @1 does not exist\n"#,
         336397208=> r#"At line @1, column @2\n"#,
         336397209=> r#"At unknown line and column\n"#,
         336397210=> r#"Column @1 cannot be repeated in @2 statement\n"#,
         336397211=> r#"Too many values (more than @1) in member list to match against\n"#,
         336397212=> r#"Array and BLOB data types not allowed in computed field\n"#,
         336397213=> r#"Implicit domain name @1 not allowed in user created domain\n"#,
         336397214=> r#"scalar operator used on field @1 which is not an array\n"#,
         336397215=> r#"cannot sort on more than 255 items\n"#,
         336397216=> r#"cannot group on more than 255 items\n"#,
         336397217=> r#"Cannot include the same field (@1.@2) twice in the ORDER BY clause with conflicting sorting options\n"#,
         336397218=> r#"column list from derived table @1 has more columns than the number of items in its SELECT statement\n"#,
         336397219=> r#"column list from derived table @1 has less columns than the number of items in its SELECT statement\n"#,
         336397220=> r#"no column name specified for column number @1 in derived table @2\n"#,
         336397221=> r#"column @1 was specified multiple times for derived table @2\n"#,
         336397222=> r#"Internal dsql error: alias type expected by pass1_expand_select_node\n"#,
         336397223=> r#"Internal dsql error: alias type expected by pass1_field\n"#,
         336397224=> r#"Internal dsql error: column position out of range in pass1_union_auto_cast\n"#,
         336397225=> r#"Recursive CTE member (@1) can refer itself only in FROM clause\n"#,
         336397226=> r#"CTE '@1' has cyclic dependencies\n"#,
         336397227=> r#"Recursive member of CTE can't be member of an outer join\n"#,
         336397228=> r#"Recursive member of CTE can't reference itself more than once\n"#,
         336397229=> r#"Recursive CTE (@1) must be an UNION\n"#,
         336397230=> r#"CTE '@1' defined non-recursive member after recursive\n"#,
         336397231=> r#"Recursive member of CTE '@1' has @2 clause\n"#,
         336397232=> r#"Recursive members of CTE (@1) must be linked with another members via UNION ALL\n"#,
         336397233=> r#"Non-recursive member is missing in CTE '@1'\n"#,
         336397234=> r#"WITH clause can't be nested\n"#,
         336397235=> r#"column @1 appears more than once in USING clause\n"#,
         336397236=> r#"feature is not supported in dialect @1\n"#,
         336397237=> r#"CTE "@1" is not used in query\n"#,
         336397238=> r#"column @1 appears more than once in ALTER VIEW\n"#,
         336397239=> r#"@1 is not supported inside IN AUTONOMOUS TRANSACTION block\n"#,
         336397240=> r#"Unknown node type @1 in dsql/GEN_expr\n"#,
         336397241=> r#"Argument for @1 in dialect 1 must be string or numeric\n"#,
         336397242=> r#"Argument for @1 in dialect 3 must be numeric\n"#,
         336397243=> r#"Strings cannot be added to or subtracted from DATE or TIME types\n"#,
         336397244=> r#"Invalid data type for subtraction involving DATE, TIME or TIMESTAMP types\n"#,
         336397245=> r#"Adding two DATE values or two TIME values is not allowed\n"#,
         336397246=> r#"DATE value cannot be subtracted from the provided data type\n"#,
         336397247=> r#"Strings cannot be added or subtracted in dialect 3\n"#,
         336397248=> r#"Invalid data type for addition or subtraction in dialect 3\n"#,
         336397249=> r#"Invalid data type for multiplication in dialect 1\n"#,
         336397250=> r#"Strings cannot be multiplied in dialect 3\n"#,
         336397251=> r#"Invalid data type for multiplication in dialect 3\n"#,
         336397252=> r#"Division in dialect 1 must be between numeric data types\n"#,
         336397253=> r#"Strings cannot be divided in dialect 3\n"#,
         336397254=> r#"Invalid data type for division in dialect 3\n"#,
         336397255=> r#"Strings cannot be negated (applied the minus operator) in dialect 3\n"#,
         336397256=> r#"Invalid data type for negation (minus operator)\n"#,
         336397257=> r#"Cannot have more than 255 items in DISTINCT / UNION DISTINCT list\n"#,
         336397258=> r#"ALTER CHARACTER SET @1 failed\n"#,
         336397259=> r#"COMMENT ON @1 failed\n"#,
         336397260=> r#"CREATE FUNCTION @1 failed\n"#,
         336397261=> r#"ALTER FUNCTION @1 failed\n"#,
         336397262=> r#"CREATE OR ALTER FUNCTION @1 failed\n"#,
         336397263=> r#"DROP FUNCTION @1 failed\n"#,
         336397264=> r#"RECREATE FUNCTION @1 failed\n"#,
         336397265=> r#"CREATE PROCEDURE @1 failed\n"#,
         336397266=> r#"ALTER PROCEDURE @1 failed\n"#,
         336397267=> r#"CREATE OR ALTER PROCEDURE @1 failed\n"#,
         336397268=> r#"DROP PROCEDURE @1 failed\n"#,
         336397269=> r#"RECREATE PROCEDURE @1 failed\n"#,
         336397270=> r#"CREATE TRIGGER @1 failed\n"#,
         336397271=> r#"ALTER TRIGGER @1 failed\n"#,
         336397272=> r#"CREATE OR ALTER TRIGGER @1 failed\n"#,
         336397273=> r#"DROP TRIGGER @1 failed\n"#,
         336397274=> r#"RECREATE TRIGGER @1 failed\n"#,
         336397275=> r#"CREATE COLLATION @1 failed\n"#,
         336397276=> r#"DROP COLLATION @1 failed\n"#,
         336397277=> r#"CREATE DOMAIN @1 failed\n"#,
         336397278=> r#"ALTER DOMAIN @1 failed\n"#,
         336397279=> r#"DROP DOMAIN @1 failed\n"#,
         336397280=> r#"CREATE EXCEPTION @1 failed\n"#,
         336397281=> r#"ALTER EXCEPTION @1 failed\n"#,
         336397282=> r#"CREATE OR ALTER EXCEPTION @1 failed\n"#,
         336397283=> r#"RECREATE EXCEPTION @1 failed\n"#,
         336397284=> r#"DROP EXCEPTION @1 failed\n"#,
         336397285=> r#"CREATE SEQUENCE @1 failed\n"#,
         336397286=> r#"CREATE TABLE @1 failed\n"#,
         336397287=> r#"ALTER TABLE @1 failed\n"#,
         336397288=> r#"DROP TABLE @1 failed\n"#,
         336397289=> r#"RECREATE TABLE @1 failed\n"#,
         336397290=> r#"CREATE PACKAGE @1 failed\n"#,
         336397291=> r#"ALTER PACKAGE @1 failed\n"#,
         336397292=> r#"CREATE OR ALTER PACKAGE @1 failed\n"#,
         336397293=> r#"DROP PACKAGE @1 failed\n"#,
         336397294=> r#"RECREATE PACKAGE @1 failed\n"#,
         336397295=> r#"CREATE PACKAGE BODY @1 failed\n"#,
         336397296=> r#"DROP PACKAGE BODY @1 failed\n"#,
         336397297=> r#"RECREATE PACKAGE BODY @1 failed\n"#,
         336397298=> r#"CREATE VIEW @1 failed\n"#,
         336397299=> r#"ALTER VIEW @1 failed\n"#,
         336397300=> r#"CREATE OR ALTER VIEW @1 failed\n"#,
         336397301=> r#"RECREATE VIEW @1 failed\n"#,
         336397302=> r#"DROP VIEW @1 failed\n"#,
         336397303=> r#"DROP SEQUENCE @1 failed\n"#,
         336397304=> r#"RECREATE SEQUENCE @1 failed\n"#,
         336397305=> r#"DROP INDEX @1 failed\n"#,
         336397306=> r#"DROP FILTER @1 failed\n"#,
         336397307=> r#"DROP SHADOW @1 failed\n"#,
         336397308=> r#"DROP ROLE @1 failed\n"#,
         336397309=> r#"DROP USER @1 failed\n"#,
         336397310=> r#"CREATE ROLE @1 failed\n"#,
         336397311=> r#"ALTER ROLE @1 failed\n"#,
         336397312=> r#"ALTER INDEX @1 failed\n"#,
         336397313=> r#"ALTER DATABASE failed\n"#,
         336397314=> r#"CREATE SHADOW @1 failed\n"#,
         336397315=> r#"DECLARE FILTER @1 failed\n"#,
         336397316=> r#"CREATE INDEX @1 failed\n"#,
         336397317=> r#"CREATE USER @1 failed\n"#,
         336397318=> r#"ALTER USER @1 failed\n"#,
         336397319=> r#"GRANT failed\n"#,
         336397320=> r#"REVOKE failed\n"#,
         336397321=> r#"Recursive member of CTE cannot use aggregate or window function\n"#,
         336397322=> r#"@2 MAPPING @1 failed\n"#,
         336397323=> r#"ALTER SEQUENCE @1 failed\n"#,
         336397324=> r#"CREATE GENERATOR @1 failed\n"#,
         336397325=> r#"SET GENERATOR @1 failed\n"#,
         336397326=> r#"WITH LOCK can be used only with a single physical table\n"#,
         336397327=> r#"FIRST/SKIP cannot be used with OFFSET/FETCH or ROWS\n"#,
         336397328=> r#"WITH LOCK cannot be used with aggregates\n"#,
         336397329=> r#"WITH LOCK cannot be used with @1\n"#,
         336397330=> r#"Number of arguments (@1) exceeds the maximum (@2) number of EXCEPTION USING arguments\n"#,
         336397331=> r#"String literal with @1 bytes exceeds the maximum length of @2 bytes\n"#,
         336397332=> r#"String literal with @1 characters exceeds the maximum length of @2 characters for the @3 character set\n"#,
         336397333=> r#"Too many BEGIN...END nesting. Maximum level is @1\n"#,
         336397334=> r#"RECREATE USER @1 failed\n"#,
         336723983=> r#"unable to open database\n"#,
         336723984=> r#"error in switch specifications\n"#,
         336723985=> r#"no operation specified\n"#,
         336723986=> r#"no user name specified\n"#,
         336723987=> r#"add record error\n"#,
         336723988=> r#"modify record error\n"#,
         336723989=> r#"find/modify record error\n"#,
         336723990=> r#"record not found for user: @1\n"#,
         336723991=> r#"delete record error\n"#,
         336723992=> r#"find/delete record error\n"#,
         336723996=> r#"find/display record error\n"#,
         336723997=> r#"invalid parameter, no switch defined\n"#,
         336723998=> r#"operation already specified\n"#,
         336723999=> r#"password already specified\n"#,
         336724000=> r#"uid already specified\n"#,
         336724001=> r#"gid already specified\n"#,
         336724002=> r#"project already specified\n"#,
         336724003=> r#"organization already specified\n"#,
         336724004=> r#"first name already specified\n"#,
         336724005=> r#"middle name already specified\n"#,
         336724006=> r#"last name already specified\n"#,
         336724008=> r#"invalid switch specified\n"#,
         336724009=> r#"ambiguous switch specified\n"#,
         336724010=> r#"no operation specified for parameters\n"#,
         336724011=> r#"no parameters allowed for this operation\n"#,
         336724012=> r#"incompatible switches specified\n"#,
         336724044=> r#"Invalid user name (maximum 31 bytes allowed)\n"#,
         336724045=> r#"Warning - maximum 8 significant bytes of password used\n"#,
         336724046=> r#"database already specified\n"#,
         336724047=> r#"database administrator name already specified\n"#,
         336724048=> r#"database administrator password already specified\n"#,
         336724049=> r#"SQL role name already specified\n"#,
         336920577=> r#"found unknown switch\n"#,
         336920578=> r#"please retry, giving a database name\n"#,
         336920579=> r#"Wrong ODS version, expected @1, encountered @2\n"#,
         336920580=> r#"Unexpected end of database file.\n"#,
         336920605=> r#"Can't open database file @1\n"#,
         336920606=> r#"Can't read a database page\n"#,
         336920607=> r#"System memory exhausted\n"#,
         336986113=> r#"Wrong value for access mode\n"#,
         336986114=> r#"Wrong value for write mode\n"#,
         336986115=> r#"Wrong value for reserve space\n"#,
         336986116=> r#"Unknown tag (@1) in info_svr_db_info block after isc_svc_query()\n"#,
         336986117=> r#"Unknown tag (@1) in isc_svc_query() results\n"#,
         336986118=> r#"Unknown switch "@1"\n"#,
         336986159=> r#"Wrong value for shutdown mode\n"#,
         336986160=> r#"could not open file @1\n"#,
         336986161=> r#"could not read file @1\n"#,
         336986162=> r#"empty file @1\n"#,
         336986164=> r#"Invalid or missing parameter for switch @1\n"#,
         336986170=> r#"Unknown tag (@1) in isc_info_svc_limbo_trans block after isc_svc_query()\n"#,
         336986171=> r#"Unknown tag (@1) in isc_spb_tra_state block after isc_svc_query()\n"#,
         336986172=> r#"Unknown tag (@1) in isc_spb_tra_advise block after isc_svc_query()\n"#,
         336986173=> r#"Wrong value for replica mode\n"#,
         337051649=> r#"Switches trusted_user and trusted_role are not supported from command line\n"#,
         337117213=> r#"Missing parameter for switch @1\n"#,
         337117214=> r#"Only one of -LOCK, -UNLOCK, -FIXUP, -BACKUP or -RESTORE should be specified\n"#,
         337117215=> r#"Unrecognized parameter @1\n"#,
         337117216=> r#"Unknown switch @1\n"#,
         337117217=> r#"Fetch password can't be used in service mode\n"#,
         337117218=> r#"Error working with password file "@1"\n"#,
         337117219=> r#"Switch -SIZE can be used only with -LOCK\n"#,
         337117220=> r#"None of -LOCK, -UNLOCK, -FIXUP, -BACKUP or -RESTORE specified\n"#,
         337117223=> r#"IO error reading file: @1\n"#,
         337117224=> r#"IO error writing file: @1\n"#,
         337117225=> r#"IO error seeking file: @1\n"#,
         337117226=> r#"Error opening database file: @1\n"#,
         337117227=> r#"Error in posix_fadvise(@1) for database @2\n"#,
         337117228=> r#"Error creating database file: @1\n"#,
         337117229=> r#"Error opening backup file: @1\n"#,
         337117230=> r#"Error creating backup file: @1\n"#,
         337117231=> r#"Unexpected end of database file @1\n"#,
         337117232=> r#"Database @1 is not in state (@2) to be safely fixed up\n"#,
         337117233=> r#"Database error\n"#,
         337117234=> r#"Username or password is too long\n"#,
         337117235=> r#"Cannot find record for database "@1" backup level @2 in the backup history\n"#,
         337117236=> r#"Internal error. History query returned null SCN or GUID\n"#,
         337117237=> r#"Unexpected end of file when reading header of database file "@1" (stage @2)\n"#,
         337117238=> r#"Internal error. Database file is not locked. Flags are @1\n"#,
         337117239=> r#"Internal error. Cannot get backup guid clumplet\n"#,
         337117240=> r#"Internal error. Database page @1 had been changed during backup (page SCN=@2, backup SCN=@3)\n"#,
         337117241=> r#"Database file size is not a multiple of page size\n"#,
         337117242=> r#"Level 0 backup is not restored\n"#,
         337117243=> r#"Unexpected end of file when reading header of backup file: @1\n"#,
         337117244=> r#"Invalid incremental backup file: @1\n"#,
         337117245=> r#"Unsupported version @1 of incremental backup file: @2\n"#,
         337117246=> r#"Invalid level @1 of incremental backup file: @2, expected @3\n"#,
         337117247=> r#"Wrong order of backup files or invalid incremental backup file detected, file: @1\n"#,
         337117248=> r#"Unexpected end of backup file: @1\n"#,
         337117249=> r#"Error creating database file: @1 via copying from: @2\n"#,
         337117250=> r#"Unexpected end of file when reading header of restored database file (stage @1)\n"#,
         337117251=> r#"Cannot get backup guid clumplet from L0 backup\n"#,
         337117255=> r#"Wrong parameter @1 for switch -D, need ON or OFF\n"#,
         337117257=> r#"Terminated due to user request\n"#,
         337117259=> r#"Too complex decompress command (> @1 arguments)\n"#,
         337117261=> r#"Cannot find record for database "@1" backup GUID @2 in the backup history\n"#,
         337117265=> r#"Switch -SEQ(UENCE) can be used only with -FIXUP or -RESTORE\n"#,
         337182750=> r#"conflicting actions "@1" and "@2" found\n"#,
         337182751=> r#"action switch not found\n"#,
         337182752=> r#"switch "@1" must be set only once\n"#,
         337182753=> r#"value for switch "@1" is missing\n"#,
         337182754=> r#"invalid value ("@1") for switch "@2"\n"#,
         337182755=> r#"unknown switch "@1" encountered\n"#,
         337182756=> r#"switch "@1" can be used by service only\n"#,
         337182757=> r#"switch "@1" can be used by interactive user only\n"#,
         337182758=> r#"mandatory parameter "@1" for switch "@2" is missing\n"#,
         337182759=> r#"parameter "@1" is incompatible with action "@2"\n"#,
         337182760=> r#"mandatory switch "@1" is missing\n"#,
    };
    map[&id]
}
