use std::process;
use std::{env, str};

fn main() -> Result<(), fingers::Error> {
    let args: Vec<String> = env::args().collect();
    if args.len() < 2 {
        println!("Usage: finger [request]@host or finger://host/request");
        process::exit(1);
    }
    if args[1].starts_with("finger://") {
        println!("{}", fingers::from_url(&args[1])?.send()?);
    }
    let user: &str;
    let host: &str;
    let params: Vec<&str> = args[1].split("@").collect();
    if params.len() == 1 {
        host = params[0];
        user = "";
    } else {
        user = params[0];
        host = params[1];
    }
    println!("{}", fingers::finger(user, host).send()?);
    Ok(())
}
