pub mod file_tool {
  use std::fs;
  
  use std::path::PathBuf;
  pub type MyResult = Result<Vec<PathBuf>, std::io::Error>;

  pub struct BigFile {
    pub url: String,
    pub size: u64,
  }
  impl BigFile {
    pub fn find_big_file(self) -> MyResult {
      let mut path = PathBuf::new();
      path.push(&self.url);
      let mut v: Vec<PathBuf> = vec![];
      Self::read_all_file(path, &mut v)?;
      let filelist = v
        .into_iter()
        .filter(|file| file.metadata().unwrap().len() > self.size)
        .collect::<Vec<_>>();
      Ok(filelist)
    }
    fn read_all_file(dir: PathBuf, v: &mut Vec<PathBuf>) -> Result<(), std::io::Error> {
      let filelist = fs::read_dir(dir)?;
      for file in filelist {
        let file = file?;
        let metadata = &file.metadata()?;
        if metadata.is_dir() {
          let path = file.path();
          Self::read_all_file(path, v)?;
        } else {
          v.push(file.path())
        }
      }
      Ok(())
    }
  }
}
