mod tool;
use std::fs;
use crate::tool::file_tool::BigFile;

use std::env;

fn main() -> Result<(), std::io::Error> {
    let args: Vec<String> = env::args().collect();
    let tool_obj = BigFile {
        url: args[1].clone(),
        size: args[2].parse::<u64>().unwrap()
    };
    let big_file = tool_obj.find_big_file()?;
    for file in big_file {
        fs::remove_file(file)?;
    }
    Ok(())
}
