#![allow(unused)]

use file_systems::*;
use file_systems::bitmap::DATA_ADDR;
use file_systems::block::{BLOCK_SIZE, MAX_BLOCKS};
use file_systems::{bitmap::BITMAP_ADDR, block::DISK_SIZE};
use bitmap::Bitmap;
use block::Block;
use std::thread::sleep;
use std::time::Duration;
#[cfg(feature = "std")]
    use std::{
        time::Instant
    };

pub fn main() -> FsResult<()> {

    
    let (total, used, free) = Bitmap::stats();
    #[cfg(all(feature = "std", feature = "debug"))]
    println!("Disk Stats: Total: {}, Used: {}, Free: {}.", total, used, free);
    #[cfg(all(feature = "std", feature = "debug"))]
    println!("Disk Stats: Total: {}B, Used: {}B, Free: {}B.", total * BLOCK_SIZE, used * BLOCK_SIZE, free * BLOCK_SIZE);
    
    let mut blocks:  Vec<Block> = Vec::new();
    let mut block = Block::alloc().unwrap();
    let block_next = Block::alloc().unwrap();


    block.set_next(block_next);
    #[cfg(all(feature = "std", feature = "debug"))] {
        println!("Next Block Addr: {}", block.next_addr());
        println!("{:?}", block);
        block.collect_into_vec(&mut blocks);
        println!("Blocks In List: {:?}", blocks);
    }

    

    Ok(())
}