//
// $COPYRIGHT$: 794d8002d1b6d954e2302879cb69c215d893c60c
use lazy_static::lazy_static;
use std::collections::HashMap;

lazy_static! {
    pub static ref EXTENSIONS: HashMap<String, String> = [
        (".bsl".to_string(), "1C Enterprise".to_string()),
        (".os".to_string(), "1C Enterprise".to_string()),
        (".4dm".to_string(), "4D".to_string()),
        (".abap".to_string(), "ABAP".to_string()),
        (".asddls".to_string(), "ABAP CDS".to_string()),
        (".abnf".to_string(), "ABNF".to_string()),
        (".ash".to_string(), "AGS Script".to_string()),
        (".aidl".to_string(), "AIDL".to_string()),
        (".ampl".to_string(), "AMPL".to_string()),
        (".g4".to_string(), "ANTLR".to_string()),
        (".apib".to_string(), "API Blueprint".to_string()),
        (".apl".to_string(), "APL".to_string()),
        (".dyalog".to_string(), "APL".to_string()),
        (".asl".to_string(), "ASL".to_string()),
        (".dsl".to_string(), "ASL".to_string()),
        (".asn".to_string(), "ASN.1".to_string()),
        (".asn1".to_string(), "ASN.1".to_string()),
        (".asax".to_string(), "ASP.NET".to_string()),
        (".ascx".to_string(), "ASP.NET".to_string()),
        (".ashx".to_string(), "ASP.NET".to_string()),
        (".asmx".to_string(), "ASP.NET".to_string()),
        (".aspx".to_string(), "ASP.NET".to_string()),
        (".axd".to_string(), "ASP.NET".to_string()),
        (".dats".to_string(), "ATS".to_string()),
        (".hats".to_string(), "ATS".to_string()),
        (".sats".to_string(), "ATS".to_string()),
        (".adb".to_string(), "Ada".to_string()),
        (".ada".to_string(), "Ada".to_string()),
        (".ads".to_string(), "Ada".to_string()),
        (".afm".to_string(), "Adobe Font Metrics".to_string()),
        (".agda".to_string(), "Agda".to_string()),
        (".als".to_string(), "Alloy".to_string()),
        (".outjob".to_string(), "Altium Designer".to_string()),
        (".pcbdoc".to_string(), "Altium Designer".to_string()),
        (".prjpcb".to_string(), "Altium Designer".to_string()),
        (".schdoc".to_string(), "Altium Designer".to_string()),
        (".angelscript".to_string(), "AngelScript".to_string()),
        (".apacheconf".to_string(), "ApacheConf".to_string()),
        (".agc".to_string(), "Apollo Guidance Computer".to_string()),
        (".applescript".to_string(), "AppleScript".to_string()),
        (".scpt".to_string(), "AppleScript".to_string()),
        (".arc".to_string(), "Arc".to_string()),
        (".asciidoc".to_string(), "AsciiDoc".to_string()),
        (".adoc".to_string(), "AsciiDoc".to_string()),
        (".aj".to_string(), "AspectJ".to_string()),
        (".a51".to_string(), "Assembly".to_string()),
        (".nasm".to_string(), "Assembly".to_string()),
        (".astro".to_string(), "Astro".to_string()),
        (".aug".to_string(), "Augeas".to_string()),
        (".ahk".to_string(), "AutoHotkey".to_string()),
        (".ahkl".to_string(), "AutoHotkey".to_string()),
        (".au3".to_string(), "AutoIt".to_string()),
        (".avdl".to_string(), "Avro IDL".to_string()),
        (".awk".to_string(), "Awk".to_string()),
        (".auk".to_string(), "Awk".to_string()),
        (".gawk".to_string(), "Awk".to_string()),
        (".mawk".to_string(), "Awk".to_string()),
        (".nawk".to_string(), "Awk".to_string()),
        (".bal".to_string(), "Ballerina".to_string()),
        (".bat".to_string(), "Batchfile".to_string()),
        (".cmd".to_string(), "Batchfile".to_string()),
        (".befunge".to_string(), "Befunge".to_string()),
        (".bib".to_string(), "BibTeX".to_string()),
        (".bibtex".to_string(), "BibTeX".to_string()),
        (".bicep".to_string(), "Bicep".to_string()),
        (".bison".to_string(), "Bison".to_string()),
        (".blade".to_string(), "Blade".to_string()),
        (".blade.php".to_string(), "Blade".to_string()),
        (".decls".to_string(), "BlitzBasic".to_string()),
        (".bmx".to_string(), "BlitzMax".to_string()),
        (".bsv".to_string(), "Bluespec".to_string()),
        (".boo".to_string(), "Boo".to_string()),
        (".bpl".to_string(), "Boogie".to_string()),
        (".brs".to_string(), "Brightscript".to_string()),
        (".c".to_string(), "C".to_string()),
        (".cats".to_string(), "C".to_string()),
        (".idc".to_string(), "C".to_string()),
        (".csx".to_string(), "C#".to_string()),
        (".linq".to_string(), "C#".to_string()),
        (".cpp".to_string(), "C++".to_string()),
        (".c++".to_string(), "C++".to_string()),
        (".cc".to_string(), "C++".to_string()),
        (".cxx".to_string(), "C++".to_string()),
        (".h++".to_string(), "C++".to_string()),
        (".hpp".to_string(), "C++".to_string()),
        (".hxx".to_string(), "C++".to_string()),
        (".inl".to_string(), "C++".to_string()),
        (".ino".to_string(), "C++".to_string()),
        (".ipp".to_string(), "C++".to_string()),
        (".ixx".to_string(), "C++".to_string()),
        (".tcc".to_string(), "C++".to_string()),
        (".tpp".to_string(), "C++".to_string()),
        (".c-objdump".to_string(), "C-ObjDump".to_string()),
        (".chs".to_string(), "C2hs Haskell".to_string()),
        (".cil".to_string(), "CIL".to_string()),
        (".clp".to_string(), "CLIPS".to_string()),
        (".cmake".to_string(), "CMake".to_string()),
        (".cmake.in".to_string(), "CMake".to_string()),
        (".cob".to_string(), "COBOL".to_string()),
        (".cbl".to_string(), "COBOL".to_string()),
        (".ccp".to_string(), "COBOL".to_string()),
        (".cobol".to_string(), "COBOL".to_string()),
        (".cpy".to_string(), "COBOL".to_string()),
        (".dae".to_string(), "COLLADA".to_string()),
        (".cson".to_string(), "CSON".to_string()),
        (".css".to_string(), "CSS".to_string()),
        (".csv".to_string(), "CSV".to_string()),
        (".cabal".to_string(), "Cabal Config".to_string()),
        (".capnp".to_string(), "Cap'n Proto".to_string()),
        (".mss".to_string(), "CartoCSS".to_string()),
        (".ceylon".to_string(), "Ceylon".to_string()),
        (".chpl".to_string(), "Chapel".to_string()),
        (".ck".to_string(), "ChucK".to_string()),
        (".cirru".to_string(), "Cirru".to_string()),
        (".clw".to_string(), "Clarion".to_string()),
        (".asp".to_string(), "Classic ASP".to_string()),
        (".icl".to_string(), "Clean".to_string()),
        (".dcl".to_string(), "Clean".to_string()),
        (".click".to_string(), "Click".to_string()),
        (".clj".to_string(), "Clojure".to_string()),
        (".boot".to_string(), "Clojure".to_string()),
        (".cl2".to_string(), "Clojure".to_string()),
        (".cljc".to_string(), "Clojure".to_string()),
        (".cljs".to_string(), "Clojure".to_string()),
        (".cljs.hl".to_string(), "Clojure".to_string()),
        (".cljscm".to_string(), "Clojure".to_string()),
        (".cljx".to_string(), "Clojure".to_string()),
        (".hic".to_string(), "Clojure".to_string()),
        (".soy".to_string(), "Closure Templates".to_string()),
        (".conllu".to_string(), "CoNLL-U".to_string()),
        (".conll".to_string(), "CoNLL-U".to_string()),
        (".ql".to_string(), "CodeQL".to_string()),
        (".qll".to_string(), "CodeQL".to_string()),
        (".coffee".to_string(), "CoffeeScript".to_string()),
        ("._coffee".to_string(), "CoffeeScript".to_string()),
        (".cjsx".to_string(), "CoffeeScript".to_string()),
        (".iced".to_string(), "CoffeeScript".to_string()),
        (".cfm".to_string(), "ColdFusion".to_string()),
        (".cfml".to_string(), "ColdFusion".to_string()),
        (".cfc".to_string(), "ColdFusion CFC".to_string()),
        (".asd".to_string(), "Common Lisp".to_string()),
        (".ny".to_string(), "Common Lisp".to_string()),
        (".podsl".to_string(), "Common Lisp".to_string()),
        (".sexp".to_string(), "Common Lisp".to_string()),
        (".cwl".to_string(), "Common Workflow Language".to_string()),
        (".cps".to_string(), "Component Pascal".to_string()),
        (".coq".to_string(), "Coq".to_string()),
        (".cppobjdump".to_string(), "Cpp-ObjDump".to_string()),
        (".c++-objdump".to_string(), "Cpp-ObjDump".to_string()),
        (".c++objdump".to_string(), "Cpp-ObjDump".to_string()),
        (".cpp-objdump".to_string(), "Cpp-ObjDump".to_string()),
        (".cxx-objdump".to_string(), "Cpp-ObjDump".to_string()),
        (".creole".to_string(), "Creole".to_string()),
        (".cr".to_string(), "Crystal".to_string()),
        (".orc".to_string(), "Csound".to_string()),
        (".udo".to_string(), "Csound".to_string()),
        (".csd".to_string(), "Csound Document".to_string()),
        (".sco".to_string(), "Csound Score".to_string()),
        (".cu".to_string(), "Cuda".to_string()),
        (".cuh".to_string(), "Cuda".to_string()),
        (".cy".to_string(), "Cycript".to_string()),
        (".pyx".to_string(), "Cython".to_string()),
        (".pxd".to_string(), "Cython".to_string()),
        (".pxi".to_string(), "Cython".to_string()),
        (".di".to_string(), "D".to_string()),
        (".d-objdump".to_string(), "D-ObjDump".to_string()),
        (".com".to_string(), "DIGITAL Command Language".to_string()),
        (".dm".to_string(), "DM".to_string()),
        (".zone".to_string(), "DNS Zone".to_string()),
        (".arpa".to_string(), "DNS Zone".to_string()),
        (".dfy".to_string(), "Dafny".to_string()),
        (".darcspatch".to_string(), "Darcs Patch".to_string()),
        (".dpatch".to_string(), "Darcs Patch".to_string()),
        (".dart".to_string(), "Dart".to_string()),
        (".dwl".to_string(), "DataWeave".to_string()),
        (".dhall".to_string(), "Dhall".to_string()),
        (".diff".to_string(), "Diff".to_string()),
        (".patch".to_string(), "Diff".to_string()),
        (".dockerfile".to_string(), "Dockerfile".to_string()),
        (".djs".to_string(), "Dogescript".to_string()),
        (".dylan".to_string(), "Dylan".to_string()),
        (".dyl".to_string(), "Dylan".to_string()),
        (".intr".to_string(), "Dylan".to_string()),
        (".lid".to_string(), "Dylan".to_string()),
        (".e".to_string(), "E".to_string()),
        (".eml".to_string(), "E-mail".to_string()),
        (".mbox".to_string(), "E-mail".to_string()),
        (".ebnf".to_string(), "EBNF".to_string()),
        (".eclxml".to_string(), "ECL".to_string()),
        (".ejs".to_string(), "EJS".to_string()),
        (".ect".to_string(), "EJS".to_string()),
        (".ejs.t".to_string(), "EJS".to_string()),
        (".jst".to_string(), "EJS".to_string()),
        (".eq".to_string(), "EQ".to_string()),
        (".eb".to_string(), "Easybuild".to_string()),
        (".epj".to_string(), "Ecere Projects".to_string()),
        (".edc".to_string(), "Edje Data Collection".to_string()),
        (".e".to_string(), "Eiffel".to_string()),
        (".ex".to_string(), "Elixir".to_string()),
        (".exs".to_string(), "Elixir".to_string()),
        (".elm".to_string(), "Elm".to_string()),
        (".el".to_string(), "Emacs Lisp".to_string()),
        (".emacs".to_string(), "Emacs Lisp".to_string()),
        (".emacs.desktop".to_string(), "Emacs Lisp".to_string()),
        (".em".to_string(), "EmberScript".to_string()),
        (".emberscript".to_string(), "EmberScript".to_string()),
        (".erl".to_string(), "Erlang".to_string()),
        (".app.src".to_string(), "Erlang".to_string()),
        (".escript".to_string(), "Erlang".to_string()),
        (".hrl".to_string(), "Erlang".to_string()),
        (".xrl".to_string(), "Erlang".to_string()),
        (".yrl".to_string(), "Erlang".to_string()),
        (".fsi".to_string(), "F#".to_string()),
        (".fsx".to_string(), "F#".to_string()),
        (".fst".to_string(), "F*".to_string()),
        (".flf".to_string(), "FIGlet Font".to_string()),
        (".flux".to_string(), "FLUX".to_string()),
        (".factor".to_string(), "Factor".to_string()),
        (".fy".to_string(), "Fancy".to_string()),
        (".fancypack".to_string(), "Fancy".to_string()),
        (".fan".to_string(), "Fantom".to_string()),
        (".fnl".to_string(), "Fennel".to_string()),
        (".eam.fs".to_string(), "Formatted".to_string()),
        (".fth".to_string(), "Forth".to_string()),
        (".4th".to_string(), "Forth".to_string()),
        (".forth".to_string(), "Forth".to_string()),
        (".frt".to_string(), "Forth".to_string()),
        (".f77".to_string(), "Fortran".to_string()),
        (".fpp".to_string(), "Fortran".to_string()),
        (".f90".to_string(), "Fortran Free Form".to_string()),
        (".f03".to_string(), "Fortran Free Form".to_string()),
        (".f08".to_string(), "Fortran Free Form".to_string()),
        (".f95".to_string(), "Fortran Free Form".to_string()),
        (".bi".to_string(), "FreeBasic".to_string()),
        (".fut".to_string(), "Futhark".to_string()),
        (".cnc".to_string(), "G-code".to_string()),
        (".gco".to_string(), "G-code".to_string()),
        (".gcode".to_string(), "G-code".to_string()),
        (".gaml".to_string(), "GAML".to_string()),
        (".gms".to_string(), "GAMS".to_string()),
        (".gap".to_string(), "GAP".to_string()),
        (".gi".to_string(), "GAP".to_string()),
        (".gdb".to_string(), "GDB".to_string()),
        (".gdbinit".to_string(), "GDB".to_string()),
        (".ged".to_string(), "GEDCOM".to_string()),
        (".glsl".to_string(), "GLSL".to_string()),
        (".fp".to_string(), "GLSL".to_string()),
        (".frg".to_string(), "GLSL".to_string()),
        (".fsh".to_string(), "GLSL".to_string()),
        (".fshader".to_string(), "GLSL".to_string()),
        (".geo".to_string(), "GLSL".to_string()),
        (".geom".to_string(), "GLSL".to_string()),
        (".glslf".to_string(), "GLSL".to_string()),
        (".glslv".to_string(), "GLSL".to_string()),
        (".gshader".to_string(), "GLSL".to_string()),
        (".rchit".to_string(), "GLSL".to_string()),
        (".rmiss".to_string(), "GLSL".to_string()),
        (".tesc".to_string(), "GLSL".to_string()),
        (".tese".to_string(), "GLSL".to_string()),
        (".vert".to_string(), "GLSL".to_string()),
        (".vrx".to_string(), "GLSL".to_string()),
        (".vsh".to_string(), "GLSL".to_string()),
        (".vshader".to_string(), "GLSL".to_string()),
        (".gn".to_string(), "GN".to_string()),
        (".gni".to_string(), "GN".to_string()),
        (".kid".to_string(), "Genshi".to_string()),
        (".ebuild".to_string(), "Gentoo Ebuild".to_string()),
        (".eclass".to_string(), "Gentoo Eclass".to_string()),
        (".gbr".to_string(), "Gerber Image".to_string()),
        (".cmp".to_string(), "Gerber Image".to_string()),
        (".gbl".to_string(), "Gerber Image".to_string()),
        (".gbo".to_string(), "Gerber Image".to_string()),
        (".gbp".to_string(), "Gerber Image".to_string()),
        (".gbs".to_string(), "Gerber Image".to_string()),
        (".gko".to_string(), "Gerber Image".to_string()),
        (".gpb".to_string(), "Gerber Image".to_string()),
        (".gpt".to_string(), "Gerber Image".to_string()),
        (".gtl".to_string(), "Gerber Image".to_string()),
        (".gto".to_string(), "Gerber Image".to_string()),
        (".gtp".to_string(), "Gerber Image".to_string()),
        (".gts".to_string(), "Gerber Image".to_string()),
        (".po".to_string(), "Gettext Catalog".to_string()),
        (".pot".to_string(), "Gettext Catalog".to_string()),
        (".feature".to_string(), "Gherkin".to_string()),
        (".story".to_string(), "Gherkin".to_string()),
        (".gitconfig".to_string(), "Git Config".to_string()),
        (".glf".to_string(), "Glyph".to_string()),
        (
            ".bdf".to_string(),
            "Glyph Bitmap Distribution Format".to_string()
        ),
        (".gpr".to_string(), "GNAT Project Manager".to_string()),
        (".gp".to_string(), "Gnuplot".to_string()),
        (".gnu".to_string(), "Gnuplot".to_string()),
        (".gnuplot".to_string(), "Gnuplot".to_string()),
        (".plot".to_string(), "Gnuplot".to_string()),
        (".plt".to_string(), "Gnuplot".to_string()),
        (".go".to_string(), "Go".to_string()),
        (".golo".to_string(), "Golo".to_string()),
        (".gsx".to_string(), "Gosu".to_string()),
        (".vark".to_string(), "Gosu".to_string()),
        (".grace".to_string(), "Grace".to_string()),
        (".gradle".to_string(), "Gradle".to_string()),
        (".gf".to_string(), "Grammatical Framework".to_string()),
        (".graphql".to_string(), "GraphQL".to_string()),
        (".gql".to_string(), "GraphQL".to_string()),
        (".graphqls".to_string(), "GraphQL".to_string()),
        (".dot".to_string(), "Graphviz (DOT)".to_string()),
        (".gv".to_string(), "Graphviz (DOT)".to_string()),
        (".groovy".to_string(), "Groovy".to_string()),
        (".grt".to_string(), "Groovy".to_string()),
        (".gtpl".to_string(), "Groovy".to_string()),
        (".gvy".to_string(), "Groovy".to_string()),
        (".gsp".to_string(), "Groovy Server Pages".to_string()),
        (".hcl".to_string(), "HCL".to_string()),
        (".nomad".to_string(), "HCL".to_string()),
        (".tf".to_string(), "HCL".to_string()),
        (".tfvars".to_string(), "HCL".to_string()),
        (".hlsl".to_string(), "HLSL".to_string()),
        (".cginc".to_string(), "HLSL".to_string()),
        (".fxh".to_string(), "HLSL".to_string()),
        (".hlsli".to_string(), "HLSL".to_string()),
        (".html".to_string(), "HTML".to_string()),
        (".hta".to_string(), "HTML".to_string()),
        (".htm".to_string(), "HTML".to_string()),
        (".html.hl".to_string(), "HTML".to_string()),
        (".xht".to_string(), "HTML".to_string()),
        (".xhtml".to_string(), "HTML".to_string()),
        (".ecr".to_string(), "HTML+ECR".to_string()),
        (".eex".to_string(), "HTML+EEX".to_string()),
        (".html.heex".to_string(), "HTML+EEX".to_string()),
        (".html.leex".to_string(), "HTML+EEX".to_string()),
        (".erb".to_string(), "HTML+ERB".to_string()),
        (".erb.deface".to_string(), "HTML+ERB".to_string()),
        (".rhtml".to_string(), "HTML+ERB".to_string()),
        (".phtml".to_string(), "HTML+PHP".to_string()),
        (".cshtml".to_string(), "HTML+Razor".to_string()),
        (".razor".to_string(), "HTML+Razor".to_string()),
        (".http".to_string(), "HTTP".to_string()),
        (".hxml".to_string(), "HXML".to_string()),
        (".hack".to_string(), "Hack".to_string()),
        (".hhi".to_string(), "Hack".to_string()),
        (".haml".to_string(), "Haml".to_string()),
        (".haml.deface".to_string(), "Haml".to_string()),
        (".handlebars".to_string(), "Handlebars".to_string()),
        (".hbs".to_string(), "Handlebars".to_string()),
        (".hb".to_string(), "Harbour".to_string()),
        (".hs".to_string(), "Haskell".to_string()),
        (".hs-boot".to_string(), "Haskell".to_string()),
        (".hsc".to_string(), "Haskell".to_string()),
        (".hx".to_string(), "Haxe".to_string()),
        (".hxsl".to_string(), "Haxe".to_string()),
        (".hql".to_string(), "HiveQL".to_string()),
        (".hc".to_string(), "HolyC".to_string()),
        (".hy".to_string(), "Hy".to_string()),
        (".dlm".to_string(), "IDL".to_string()),
        (".ipf".to_string(), "IGOR Pro".to_string()),
        (".ini".to_string(), "INI".to_string()),
        (".dof".to_string(), "INI".to_string()),
        (".lektorproject".to_string(), "INI".to_string()),
        (".prefs".to_string(), "INI".to_string()),
        (".irclog".to_string(), "IRC log".to_string()),
        (".weechatlog".to_string(), "IRC log".to_string()),
        (".idr".to_string(), "Idris".to_string()),
        (".lidr".to_string(), "Idris".to_string()),
        (".gitignore".to_string(), "Ignore List".to_string()),
        (".ijm".to_string(), "ImageJ Macro".to_string()),
        (".ni".to_string(), "Inform 7".to_string()),
        (".i7x".to_string(), "Inform 7".to_string()),
        (".iss".to_string(), "Inno Setup".to_string()),
        (".isl".to_string(), "Inno Setup".to_string()),
        (".io".to_string(), "Io".to_string()),
        (".ik".to_string(), "Ioke".to_string()),
        (".thy".to_string(), "Isabelle".to_string()),
        (".ijs".to_string(), "J".to_string()),
        (".flex".to_string(), "JFlex".to_string()),
        (".jflex".to_string(), "JFlex".to_string()),
        (".json".to_string(), "JSON".to_string()),
        (".avsc".to_string(), "JSON".to_string()),
        (".geojson".to_string(), "JSON".to_string()),
        (".gltf".to_string(), "JSON".to_string()),
        (".har".to_string(), "JSON".to_string()),
        (".json-tmlanguage".to_string(), "JSON".to_string()),
        (".jsonl".to_string(), "JSON".to_string()),
        (".mcmeta".to_string(), "JSON".to_string()),
        (".tfstate".to_string(), "JSON".to_string()),
        (".tfstate.backup".to_string(), "JSON".to_string()),
        (".topojson".to_string(), "JSON".to_string()),
        (".webapp".to_string(), "JSON".to_string()),
        (".webmanifest".to_string(), "JSON".to_string()),
        (".yyp".to_string(), "JSON".to_string()),
        (".jsonc".to_string(), "JSON with Comments".to_string()),
        (
            ".sublime-build".to_string(),
            "JSON with Comments".to_string()
        ),
        (
            ".sublime-commands".to_string(),
            "JSON with Comments".to_string()
        ),
        (
            ".sublime-completions".to_string(),
            "JSON with Comments".to_string()
        ),
        (
            ".sublime-keymap".to_string(),
            "JSON with Comments".to_string()
        ),
        (
            ".sublime-macro".to_string(),
            "JSON with Comments".to_string()
        ),
        (
            ".sublime-menu".to_string(),
            "JSON with Comments".to_string()
        ),
        (
            ".sublime-mousemap".to_string(),
            "JSON with Comments".to_string()
        ),
        (
            ".sublime-project".to_string(),
            "JSON with Comments".to_string()
        ),
        (
            ".sublime-settings".to_string(),
            "JSON with Comments".to_string()
        ),
        (
            ".sublime-theme".to_string(),
            "JSON with Comments".to_string()
        ),
        (
            ".sublime-workspace".to_string(),
            "JSON with Comments".to_string()
        ),
        (
            ".sublime_metrics".to_string(),
            "JSON with Comments".to_string()
        ),
        (
            ".sublime_session".to_string(),
            "JSON with Comments".to_string()
        ),
        (".json5".to_string(), "JSON5".to_string()),
        (".jsonld".to_string(), "JSONLD".to_string()),
        (".java".to_string(), "Java".to_string()),
        (".jav".to_string(), "Java".to_string()),
        (".jsp".to_string(), "Java Server Pages".to_string()),
        (".js".to_string(), "JavaScript".to_string()),
        ("._js".to_string(), "JavaScript".to_string()),
        (".bones".to_string(), "JavaScript".to_string()),
        (".cjs".to_string(), "JavaScript".to_string()),
        (".es6".to_string(), "JavaScript".to_string()),
        (".jake".to_string(), "JavaScript".to_string()),
        (".javascript".to_string(), "JavaScript".to_string()),
        (".jsb".to_string(), "JavaScript".to_string()),
        (".jscad".to_string(), "JavaScript".to_string()),
        (".jsfl".to_string(), "JavaScript".to_string()),
        (".jsm".to_string(), "JavaScript".to_string()),
        (".jss".to_string(), "JavaScript".to_string()),
        (".jsx".to_string(), "JavaScript".to_string()),
        (".mjs".to_string(), "JavaScript".to_string()),
        (".njs".to_string(), "JavaScript".to_string()),
        (".pac".to_string(), "JavaScript".to_string()),
        (".sjs".to_string(), "JavaScript".to_string()),
        (".ssjs".to_string(), "JavaScript".to_string()),
        (".xsjs".to_string(), "JavaScript".to_string()),
        (".xsjslib".to_string(), "JavaScript".to_string()),
        (".js.erb".to_string(), "JavaScript+ERB".to_string()),
        (".snap".to_string(), "Jest Snapshot".to_string()),
        (".jinja".to_string(), "Jinja".to_string()),
        (".j2".to_string(), "Jinja".to_string()),
        (".jinja2".to_string(), "Jinja".to_string()),
        (".jison".to_string(), "Jison".to_string()),
        (".jisonlex".to_string(), "Jison Lex".to_string()),
        (".ol".to_string(), "Jolie".to_string()),
        (".iol".to_string(), "Jolie".to_string()),
        (".jsonnet".to_string(), "Jsonnet".to_string()),
        (".libsonnet".to_string(), "Jsonnet".to_string()),
        (".jl".to_string(), "Julia".to_string()),
        (".ipynb".to_string(), "Jupyter Notebook".to_string()),
        (".krl".to_string(), "KRL".to_string()),
        (".ksy".to_string(), "Kaitai Struct".to_string()),
        (".kak".to_string(), "KakouneScript".to_string()),
        (".kicad_pcb".to_string(), "KiCad Layout".to_string()),
        (".kicad_mod".to_string(), "KiCad Layout".to_string()),
        (".kicad_wks".to_string(), "KiCad Layout".to_string()),
        (".kit".to_string(), "Kit".to_string()),
        (".kt".to_string(), "Kotlin".to_string()),
        (".ktm".to_string(), "Kotlin".to_string()),
        (".kts".to_string(), "Kotlin".to_string()),
        (".lfe".to_string(), "LFE".to_string()),
        (".ll".to_string(), "LLVM".to_string()),
        (".lol".to_string(), "LOLCODE".to_string()),
        (".lsl".to_string(), "LSL".to_string()),
        (".lslp".to_string(), "LSL".to_string()),
        (".lvproj".to_string(), "LabVIEW".to_string()),
        (".lvlib".to_string(), "LabVIEW".to_string()),
        (".lark".to_string(), "Lark".to_string()),
        (".lasso".to_string(), "Lasso".to_string()),
        (".las".to_string(), "Lasso".to_string()),
        (".lasso8".to_string(), "Lasso".to_string()),
        (".lasso9".to_string(), "Lasso".to_string()),
        (".latte".to_string(), "Latte".to_string()),
        (".lean".to_string(), "Lean".to_string()),
        (".hlean".to_string(), "Lean".to_string()),
        (".less".to_string(), "Less".to_string()),
        (".lex".to_string(), "Lex".to_string()),
        (".ly".to_string(), "LilyPond".to_string()),
        (".ily".to_string(), "LilyPond".to_string()),
        (".ld".to_string(), "Linker Script".to_string()),
        (".lds".to_string(), "Linker Script".to_string()),
        (".liquid".to_string(), "Liquid".to_string()),
        (".lagda".to_string(), "Literate Agda".to_string()),
        (
            ".litcoffee".to_string(),
            "Literate CoffeeScript".to_string()
        ),
        (
            ".coffee.md".to_string(),
            "Literate CoffeeScript".to_string()
        ),
        (".lhs".to_string(), "Literate Haskell".to_string()),
        ("._ls".to_string(), "LiveScript".to_string()),
        (".xm".to_string(), "Logos".to_string()),
        (".xi".to_string(), "Logos".to_string()),
        (".lgt".to_string(), "Logtalk".to_string()),
        (".logtalk".to_string(), "Logtalk".to_string()),
        (".lookml".to_string(), "LookML".to_string()),
        (".model.lkml".to_string(), "LookML".to_string()),
        (".view.lkml".to_string(), "LookML".to_string()),
        (".lua".to_string(), "Lua".to_string()),
        (".nse".to_string(), "Lua".to_string()),
        (".p8".to_string(), "Lua".to_string()),
        (".pd_lua".to_string(), "Lua".to_string()),
        (".rbxs".to_string(), "Lua".to_string()),
        (".rockspec".to_string(), "Lua".to_string()),
        (".wlua".to_string(), "Lua".to_string()),
        (".mumps".to_string(), "M".to_string()),
        (".matlab".to_string(), "MATLAB".to_string()),
        (".mcr".to_string(), "MAXScript".to_string()),
        (".mlir".to_string(), "MLIR".to_string()),
        (".mq4".to_string(), "MQL4".to_string()),
        (".mq5".to_string(), "MQL5".to_string()),
        (".mqh".to_string(), "MQL5".to_string()),
        (".mtml".to_string(), "MTML".to_string()),
        (".muf".to_string(), "MUF".to_string()),
        (".m2".to_string(), "Macaulay2".to_string()),
        (".mak".to_string(), "Makefile".to_string()),
        (".make".to_string(), "Makefile".to_string()),
        (".makefile".to_string(), "Makefile".to_string()),
        (".mk".to_string(), "Makefile".to_string()),
        (".mkfile".to_string(), "Makefile".to_string()),
        (".mako".to_string(), "Mako".to_string()),
        (".mao".to_string(), "Mako".to_string()),
        (".markdown".to_string(), "Markdown".to_string()),
        (".mdown".to_string(), "Markdown".to_string()),
        (".mdwn".to_string(), "Markdown".to_string()),
        (".mdx".to_string(), "Markdown".to_string()),
        (".mkd".to_string(), "Markdown".to_string()),
        (".mkdn".to_string(), "Markdown".to_string()),
        (".mkdown".to_string(), "Markdown".to_string()),
        (".ronn".to_string(), "Markdown".to_string()),
        (".workbook".to_string(), "Markdown".to_string()),
        (".marko".to_string(), "Marko".to_string()),
        (".mathematica".to_string(), "Mathematica".to_string()),
        (".cdf".to_string(), "Mathematica".to_string()),
        (".ma".to_string(), "Mathematica".to_string()),
        (".mt".to_string(), "Mathematica".to_string()),
        (".nbp".to_string(), "Mathematica".to_string()),
        (".wl".to_string(), "Mathematica".to_string()),
        (".wlt".to_string(), "Mathematica".to_string()),
        (".maxpat".to_string(), "Max".to_string()),
        (".maxhelp".to_string(), "Max".to_string()),
        (".maxproj".to_string(), "Max".to_string()),
        (".mxt".to_string(), "Max".to_string()),
        (".pat".to_string(), "Max".to_string()),
        (".metal".to_string(), "Metal".to_string()),
        (
            ".sln".to_string(),
            "Microsoft Visual Studio Solution".to_string()
        ),
        (".minid".to_string(), "MiniD".to_string()),
        (".druby".to_string(), "Mirah".to_string()),
        (".duby".to_string(), "Mirah".to_string()),
        (".mirah".to_string(), "Mirah".to_string()),
        (".i3".to_string(), "Modula-3".to_string()),
        (".ig".to_string(), "Modula-3".to_string()),
        (".m3".to_string(), "Modula-3".to_string()),
        (".mg".to_string(), "Modula-3".to_string()),
        (".mms".to_string(), "Module Management System".to_string()),
        (".mmk".to_string(), "Module Management System".to_string()),
        (".monkey".to_string(), "Monkey".to_string()),
        (".monkey2".to_string(), "Monkey".to_string()),
        (".moon".to_string(), "MoonScript".to_string()),
        (".x68".to_string(), "Motorola 68K Assembly".to_string()),
        (".muse".to_string(), "Muse".to_string()),
        (".mustache".to_string(), "Mustache".to_string()),
        (".myt".to_string(), "Myghty".to_string()),
        (".nasl".to_string(), "NASL".to_string()),
        (".neon".to_string(), "NEON".to_string()),
        (".nsi".to_string(), "NSIS".to_string()),
        (".nsh".to_string(), "NSIS".to_string()),
        (".nss".to_string(), "NWScript".to_string()),
        (".ne".to_string(), "Nearley".to_string()),
        (".nearley".to_string(), "Nearley".to_string()),
        (".axs".to_string(), "NetLinx".to_string()),
        (".axi".to_string(), "NetLinx".to_string()),
        (".axs.erb".to_string(), "NetLinx+ERB".to_string()),
        (".axi.erb".to_string(), "NetLinx+ERB".to_string()),
        (".nlogo".to_string(), "NetLogo".to_string()),
        (".nf".to_string(), "Nextflow".to_string()),
        (".nginx".to_string(), "Nginx".to_string()),
        (".nginxconf".to_string(), "Nginx".to_string()),
        (".nim".to_string(), "Nim".to_string()),
        (".nim.cfg".to_string(), "Nim".to_string()),
        (".nimble".to_string(), "Nim".to_string()),
        (".nimrod".to_string(), "Nim".to_string()),
        (".nims".to_string(), "Nim".to_string()),
        (".ninja".to_string(), "Ninja".to_string()),
        (".nit".to_string(), "Nit".to_string()),
        (".nix".to_string(), "Nix".to_string()),
        (".nu".to_string(), "Nu".to_string()),
        (".numpy".to_string(), "NumPy".to_string()),
        (".numpyw".to_string(), "NumPy".to_string()),
        (".numsc".to_string(), "NumPy".to_string()),
        (".njk".to_string(), "Nunjucks".to_string()),
        (".eliom".to_string(), "OCaml".to_string()),
        (".eliomi".to_string(), "OCaml".to_string()),
        (".ml4".to_string(), "OCaml".to_string()),
        (".mli".to_string(), "OCaml".to_string()),
        (".mll".to_string(), "OCaml".to_string()),
        (".mly".to_string(), "OCaml".to_string()),
        (".objdump".to_string(), "ObjDump".to_string()),
        (".sj".to_string(), "Objective-J".to_string()),
        (".omgrofl".to_string(), "Omgrofl".to_string()),
        (".opa".to_string(), "Opa".to_string()),
        (".opal".to_string(), "Opal".to_string()),
        (".rego".to_string(), "Open Policy Agent".to_string()),
        (".opencl".to_string(), "OpenCL".to_string()),
        (".qasm".to_string(), "OpenQASM".to_string()),
        (".scad".to_string(), "OpenSCAD".to_string()),
        (".glyphs".to_string(), "OpenStep Property List".to_string()),
        (".fea".to_string(), "OpenType Feature File".to_string()),
        (".org".to_string(), "Org".to_string()),
        (".ox".to_string(), "Ox".to_string()),
        (".oxh".to_string(), "Ox".to_string()),
        (".oxo".to_string(), "Ox".to_string()),
        (".oxygene".to_string(), "Oxygene".to_string()),
        (".oz".to_string(), "Oz".to_string()),
        (".p4".to_string(), "P4".to_string()),
        (".pegjs".to_string(), "PEG.js".to_string()),
        (".aw".to_string(), "PHP".to_string()),
        (".ctp".to_string(), "PHP".to_string()),
        (".php3".to_string(), "PHP".to_string()),
        (".php4".to_string(), "PHP".to_string()),
        (".php5".to_string(), "PHP".to_string()),
        (".phps".to_string(), "PHP".to_string()),
        (".phpt".to_string(), "PHP".to_string()),
        (".pls".to_string(), "PLSQL".to_string()),
        (".bdy".to_string(), "PLSQL".to_string()),
        (".fnc".to_string(), "PLSQL".to_string()),
        (".pck".to_string(), "PLSQL".to_string()),
        (".pkb".to_string(), "PLSQL".to_string()),
        (".pks".to_string(), "PLSQL".to_string()),
        (".plb".to_string(), "PLSQL".to_string()),
        (".plsql".to_string(), "PLSQL".to_string()),
        (".spc".to_string(), "PLSQL".to_string()),
        (".tpb".to_string(), "PLSQL".to_string()),
        (".tps".to_string(), "PLSQL".to_string()),
        (".trg".to_string(), "PLSQL".to_string()),
        (".vw".to_string(), "PLSQL".to_string()),
        (".pgsql".to_string(), "PLpgSQL".to_string()),
        (".pov".to_string(), "POV-Ray SDL".to_string()),
        (".pan".to_string(), "Pan".to_string()),
        (".psc".to_string(), "Papyrus".to_string()),
        (".parrot".to_string(), "Parrot".to_string()),
        (".pasm".to_string(), "Parrot Assembly".to_string()),
        (
            ".pir".to_string(),
            "Parrot Internal Representation".to_string()
        ),
        (".pas".to_string(), "Pascal".to_string()),
        (".dfm".to_string(), "Pascal".to_string()),
        (".dpr".to_string(), "Pascal".to_string()),
        (".lpr".to_string(), "Pascal".to_string()),
        (".pascal".to_string(), "Pascal".to_string()),
        (".pwn".to_string(), "Pawn".to_string()),
        (".sma".to_string(), "Pawn".to_string()),
        (".pep".to_string(), "Pep8".to_string()),
        (".perl".to_string(), "Perl".to_string()),
        (".ph".to_string(), "Perl".to_string()),
        (".plx".to_string(), "Perl".to_string()),
        (".psgi".to_string(), "Perl".to_string()),
        (".pic".to_string(), "Pic".to_string()),
        (".chem".to_string(), "Pic".to_string()),
        (".pkl".to_string(), "Pickle".to_string()),
        (".pig".to_string(), "PigLatin".to_string()),
        (".pike".to_string(), "Pike".to_string()),
        (".pmod".to_string(), "Pike".to_string()),
        (".puml".to_string(), "PlantUML".to_string()),
        (".iuml".to_string(), "PlantUML".to_string()),
        (".plantuml".to_string(), "PlantUML".to_string()),
        (".pod6".to_string(), "Pod 6".to_string()),
        (".pogo".to_string(), "PogoScript".to_string()),
        (".pony".to_string(), "Pony".to_string()),
        (".pcss".to_string(), "PostCSS".to_string()),
        (".postcss".to_string(), "PostCSS".to_string()),
        (".ps".to_string(), "PostScript".to_string()),
        (".eps".to_string(), "PostScript".to_string()),
        (".epsi".to_string(), "PostScript".to_string()),
        (".pfa".to_string(), "PostScript".to_string()),
        (".pbt".to_string(), "PowerBuilder".to_string()),
        (".sra".to_string(), "PowerBuilder".to_string()),
        (".sru".to_string(), "PowerBuilder".to_string()),
        (".srw".to_string(), "PowerBuilder".to_string()),
        (".ps1".to_string(), "PowerShell".to_string()),
        (".psd1".to_string(), "PowerShell".to_string()),
        (".psm1".to_string(), "PowerShell".to_string()),
        (".prisma".to_string(), "Prisma".to_string()),
        (".pde".to_string(), "Processing".to_string()),
        (".prolog".to_string(), "Prolog".to_string()),
        (".yap".to_string(), "Prolog".to_string()),
        (".pml".to_string(), "Promela".to_string()),
        (".spin".to_string(), "Propeller Spin".to_string()),
        (".proto".to_string(), "Protocol Buffer".to_string()),
        (".pub".to_string(), "Public Key".to_string()),
        (".jade".to_string(), "Pug".to_string()),
        (".pug".to_string(), "Pug".to_string()),
        (".pd".to_string(), "Pure Data".to_string()),
        (".pb".to_string(), "PureBasic".to_string()),
        (".pbi".to_string(), "PureBasic".to_string()),
        (".purs".to_string(), "PureScript".to_string()),
        (".py".to_string(), "Python".to_string()),
        (".gyp".to_string(), "Python".to_string()),
        (".gypi".to_string(), "Python".to_string()),
        (".lmi".to_string(), "Python".to_string()),
        (".py3".to_string(), "Python".to_string()),
        (".pyde".to_string(), "Python".to_string()),
        (".pyi".to_string(), "Python".to_string()),
        (".pyp".to_string(), "Python".to_string()),
        (".pyt".to_string(), "Python".to_string()),
        (".pyw".to_string(), "Python".to_string()),
        (".smk".to_string(), "Python".to_string()),
        (".tac".to_string(), "Python".to_string()),
        (".wsgi".to_string(), "Python".to_string()),
        (".xpy".to_string(), "Python".to_string()),
        (".pytb".to_string(), "Python traceback".to_string()),
        (".qml".to_string(), "QML".to_string()),
        (".qbs".to_string(), "QML".to_string()),
        (".pri".to_string(), "QMake".to_string()),
        (".rd".to_string(), "R".to_string()),
        (".rsx".to_string(), "R".to_string()),
        (".raml".to_string(), "RAML".to_string()),
        (".rdoc".to_string(), "RDoc".to_string()),
        (".rbbas".to_string(), "REALbasic".to_string()),
        (".rbfrm".to_string(), "REALbasic".to_string()),
        (".rbmnu".to_string(), "REALbasic".to_string()),
        (".rbres".to_string(), "REALbasic".to_string()),
        (".rbtbar".to_string(), "REALbasic".to_string()),
        (".rbuistate".to_string(), "REALbasic".to_string()),
        (".rexx".to_string(), "REXX".to_string()),
        (".pprx".to_string(), "REXX".to_string()),
        (".rex".to_string(), "REXX".to_string()),
        (".rmd".to_string(), "RMarkdown".to_string()),
        (".rnh".to_string(), "RUNOFF".to_string()),
        (".rkt".to_string(), "Racket".to_string()),
        (".rktd".to_string(), "Racket".to_string()),
        (".rktl".to_string(), "Racket".to_string()),
        (".scrbl".to_string(), "Racket".to_string()),
        (".rl".to_string(), "Ragel".to_string()),
        (".6pl".to_string(), "Raku".to_string()),
        (".6pm".to_string(), "Raku".to_string()),
        (".nqp".to_string(), "Raku".to_string()),
        (".p6".to_string(), "Raku".to_string()),
        (".p6l".to_string(), "Raku".to_string()),
        (".p6m".to_string(), "Raku".to_string()),
        (".pl6".to_string(), "Raku".to_string()),
        (".pm6".to_string(), "Raku".to_string()),
        (".raku".to_string(), "Raku".to_string()),
        (".rakumod".to_string(), "Raku".to_string()),
        (".rsc".to_string(), "Rascal".to_string()),
        (".raw".to_string(), "Raw token data".to_string()),
        (".rei".to_string(), "Reason".to_string()),
        (".reb".to_string(), "Rebol".to_string()),
        (".r2".to_string(), "Rebol".to_string()),
        (".r3".to_string(), "Rebol".to_string()),
        (".rebol".to_string(), "Rebol".to_string()),
        (".red".to_string(), "Red".to_string()),
        (".reds".to_string(), "Red".to_string()),
        (".cw".to_string(), "Redcode".to_string()),
        (".regexp".to_string(), "Regular Expression".to_string()),
        (".regex".to_string(), "Regular Expression".to_string()),
        (".rsh".to_string(), "RenderScript".to_string()),
        (".rtf".to_string(), "Rich Text Format".to_string()),
        (".ring".to_string(), "Ring".to_string()),
        (".riot".to_string(), "Riot".to_string()),
        (".robot".to_string(), "RobotFramework".to_string()),
        (".roff".to_string(), "Roff".to_string()),
        (".me".to_string(), "Roff".to_string()),
        (".nr".to_string(), "Roff".to_string()),
        (".tmac".to_string(), "Roff".to_string()),
        (".rg".to_string(), "Rouge".to_string()),
        (".rb".to_string(), "Ruby".to_string()),
        (".builder".to_string(), "Ruby".to_string()),
        (".eye".to_string(), "Ruby".to_string()),
        (".gemspec".to_string(), "Ruby".to_string()),
        (".god".to_string(), "Ruby".to_string()),
        (".jbuilder".to_string(), "Ruby".to_string()),
        (".mspec".to_string(), "Ruby".to_string()),
        (".podspec".to_string(), "Ruby".to_string()),
        (".prawn".to_string(), "Ruby".to_string()),
        (".rabl".to_string(), "Ruby".to_string()),
        (".rake".to_string(), "Ruby".to_string()),
        (".rbi".to_string(), "Ruby".to_string()),
        (".rbuild".to_string(), "Ruby".to_string()),
        (".rbw".to_string(), "Ruby".to_string()),
        (".rbx".to_string(), "Ruby".to_string()),
        (".ru".to_string(), "Ruby".to_string()),
        (".ruby".to_string(), "Ruby".to_string()),
        (".thor".to_string(), "Ruby".to_string()),
        (".watchr".to_string(), "Ruby".to_string()),
        (".rs.in".to_string(), "Rust".to_string()),
        (".sas".to_string(), "SAS".to_string()),
        (".scss".to_string(), "SCSS".to_string()),
        (".te".to_string(), "SELinux Policy".to_string()),
        (".smt2".to_string(), "SMT".to_string()),
        (".smt".to_string(), "SMT".to_string()),
        (".sparql".to_string(), "SPARQL".to_string()),
        (".rq".to_string(), "SPARQL".to_string()),
        (".sqf".to_string(), "SQF".to_string()),
        (".hqf".to_string(), "SQF".to_string()),
        (".cql".to_string(), "SQL".to_string()),
        (".mysql".to_string(), "SQL".to_string()),
        (".tab".to_string(), "SQL".to_string()),
        (".udf".to_string(), "SQL".to_string()),
        (".viw".to_string(), "SQL".to_string()),
        (".db2".to_string(), "SQLPL".to_string()),
        (".ston".to_string(), "STON".to_string()),
        (".svg".to_string(), "SVG".to_string()),
        (".sage".to_string(), "Sage".to_string()),
        (".sagews".to_string(), "Sage".to_string()),
        (".sass".to_string(), "Sass".to_string()),
        (".scala".to_string(), "Scala".to_string()),
        (".kojo".to_string(), "Scala".to_string()),
        (".sbt".to_string(), "Scala".to_string()),
        (".scaml".to_string(), "Scaml".to_string()),
        (".scm".to_string(), "Scheme".to_string()),
        (".sld".to_string(), "Scheme".to_string()),
        (".sps".to_string(), "Scheme".to_string()),
        (".ss".to_string(), "Scheme".to_string()),
        (".sci".to_string(), "Scilab".to_string()),
        (".sce".to_string(), "Scilab".to_string()),
        (".self".to_string(), "Self".to_string()),
        (".sh".to_string(), "Shell".to_string()),
        (".bash".to_string(), "Shell".to_string()),
        (".bats".to_string(), "Shell".to_string()),
        (".command".to_string(), "Shell".to_string()),
        (".env".to_string(), "Shell".to_string()),
        (".ksh".to_string(), "Shell".to_string()),
        (".sh.in".to_string(), "Shell".to_string()),
        (".tmux".to_string(), "Shell".to_string()),
        (".tool".to_string(), "Shell".to_string()),
        (".zsh".to_string(), "Shell".to_string()),
        (".sh-session".to_string(), "ShellSession".to_string()),
        (".shen".to_string(), "Shen".to_string()),
        (".sieve".to_string(), "Sieve".to_string()),
        (".sl".to_string(), "Slash".to_string()),
        (".slim".to_string(), "Slim".to_string()),
        (".cocci".to_string(), "SmPL".to_string()),
        (".smali".to_string(), "Smali".to_string()),
        (".tpl".to_string(), "Smarty".to_string()),
        (".sp".to_string(), "SourcePawn".to_string()),
        (".sfd".to_string(), "Spline Font Database".to_string()),
        (".nut".to_string(), "Squirrel".to_string()),
        (".stan".to_string(), "Stan".to_string()),
        (".fun".to_string(), "Standard ML".to_string()),
        (".sig".to_string(), "Standard ML".to_string()),
        (".sml".to_string(), "Standard ML".to_string()),
        (".bzl".to_string(), "Starlark".to_string()),
        (".do".to_string(), "Stata".to_string()),
        (".ado".to_string(), "Stata".to_string()),
        (".doh".to_string(), "Stata".to_string()),
        (".ihlp".to_string(), "Stata".to_string()),
        (".mata".to_string(), "Stata".to_string()),
        (".matah".to_string(), "Stata".to_string()),
        (".sthlp".to_string(), "Stata".to_string()),
        (".styl".to_string(), "Stylus".to_string()),
        (".sss".to_string(), "SugarSS".to_string()),
        (".svelte".to_string(), "Svelte".to_string()),
        (".swift".to_string(), "Swift".to_string()),
        (".service".to_string(), "Systemd".to_string()),
        (".sv".to_string(), "SystemVerilog".to_string()),
        (".svh".to_string(), "SystemVerilog".to_string()),
        (".vh".to_string(), "SystemVerilog".to_string()),
        (".8xp".to_string(), "TI Program".to_string()),
        (".8xk".to_string(), "TI Program".to_string()),
        (".8xk.txt".to_string(), "TI Program".to_string()),
        (".8xp.txt".to_string(), "TI Program".to_string()),
        (".tla".to_string(), "TLA".to_string()),
        (".toml".to_string(), "TOML".to_string()),
        (".tsv".to_string(), "TSV".to_string()),
        (".txl".to_string(), "TXL".to_string()),
        (".tcl".to_string(), "Tcl".to_string()),
        (".adp".to_string(), "Tcl".to_string()),
        (".tcl.in".to_string(), "Tcl".to_string()),
        (".tm".to_string(), "Tcl".to_string()),
        (".tcsh".to_string(), "Tcsh".to_string()),
        (".csh".to_string(), "Tcsh".to_string()),
        (".tex".to_string(), "TeX".to_string()),
        (".aux".to_string(), "TeX".to_string()),
        (".bbx".to_string(), "TeX".to_string()),
        (".cbx".to_string(), "TeX".to_string()),
        (".dtx".to_string(), "TeX".to_string()),
        (".ins".to_string(), "TeX".to_string()),
        (".lbx".to_string(), "TeX".to_string()),
        (".ltx".to_string(), "TeX".to_string()),
        (".mkii".to_string(), "TeX".to_string()),
        (".mkiv".to_string(), "TeX".to_string()),
        (".mkvi".to_string(), "TeX".to_string()),
        (".sty".to_string(), "TeX".to_string()),
        (".tea".to_string(), "Tea".to_string()),
        (".texinfo".to_string(), "Texinfo".to_string()),
        (".texi".to_string(), "Texinfo".to_string()),
        (".txi".to_string(), "Texinfo".to_string()),
        (".no".to_string(), "Text".to_string()),
        (".textile".to_string(), "Textile".to_string()),
        (".thrift".to_string(), "Thrift".to_string()),
        (".tu".to_string(), "Turing".to_string()),
        (".ttl".to_string(), "Turtle".to_string()),
        (".twig".to_string(), "Twig".to_string()),
        (".tl".to_string(), "Type Language".to_string()),
        (".upc".to_string(), "Unified Parallel C".to_string()),
        (".anim".to_string(), "Unity3D Asset".to_string()),
        (".asset".to_string(), "Unity3D Asset".to_string()),
        (".mat".to_string(), "Unity3D Asset".to_string()),
        (".meta".to_string(), "Unity3D Asset".to_string()),
        (".prefab".to_string(), "Unity3D Asset".to_string()),
        (".unity".to_string(), "Unity3D Asset".to_string()),
        (".uno".to_string(), "Uno".to_string()),
        (".uc".to_string(), "UnrealScript".to_string()),
        (".ur".to_string(), "UrWeb".to_string()),
        (".urs".to_string(), "UrWeb".to_string()),
        (".frm".to_string(), "VBA".to_string()),
        (".frx".to_string(), "VBA".to_string()),
        (".vbs".to_string(), "VBScript".to_string()),
        (".vcl".to_string(), "VCL".to_string()),
        (".vhdl".to_string(), "VHDL".to_string()),
        (".vhd".to_string(), "VHDL".to_string()),
        (".vhf".to_string(), "VHDL".to_string()),
        (".vhi".to_string(), "VHDL".to_string()),
        (".vho".to_string(), "VHDL".to_string()),
        (".vhs".to_string(), "VHDL".to_string()),
        (".vht".to_string(), "VHDL".to_string()),
        (".vhw".to_string(), "VHDL".to_string()),
        (".vala".to_string(), "Vala".to_string()),
        (".vapi".to_string(), "Vala".to_string()),
        (".vdf".to_string(), "Valve Data Format".to_string()),
        (".veo".to_string(), "Verilog".to_string()),
        (".vim".to_string(), "Vim Script".to_string()),
        (".vimrc".to_string(), "Vim Script".to_string()),
        (".vmb".to_string(), "Vim Script".to_string()),
        (".snip".to_string(), "Vim Snippet".to_string()),
        (".snippet".to_string(), "Vim Snippet".to_string()),
        (".snippets".to_string(), "Vim Snippet".to_string()),
        (".vb".to_string(), "Visual Basic .NET".to_string()),
        (".vbhtml".to_string(), "Visual Basic .NET".to_string()),
        (".volt".to_string(), "Volt".to_string()),
        (".vue".to_string(), "Vue".to_string()),
        (".mtl".to_string(), "Wavefront Material".to_string()),
        (".obj".to_string(), "Wavefront Object".to_string()),
        (".owl".to_string(), "Web Ontology Language".to_string()),
        (".wast".to_string(), "WebAssembly".to_string()),
        (".wat".to_string(), "WebAssembly".to_string()),
        (".webidl".to_string(), "WebIDL".to_string()),
        (".vtt".to_string(), "WebVTT".to_string()),
        (".mediawiki".to_string(), "Wikitext".to_string()),
        (".wiki".to_string(), "Wikitext".to_string()),
        (".wikitext".to_string(), "Wikitext".to_string()),
        (".reg".to_string(), "Windows Registry Entries".to_string()),
        (".wlk".to_string(), "Wollok".to_string()),
        (".xbm".to_string(), "X BitMap".to_string()),
        (".xpm".to_string(), "X PixMap".to_string()),
        (".x10".to_string(), "X10".to_string()),
        (".xc".to_string(), "XC".to_string()),
        (".xml".to_string(), "XML".to_string()),
        (".adml".to_string(), "XML".to_string()),
        (".admx".to_string(), "XML".to_string()),
        (".ant".to_string(), "XML".to_string()),
        (".axml".to_string(), "XML".to_string()),
        (".builds".to_string(), "XML".to_string()),
        (".ccproj".to_string(), "XML".to_string()),
        (".ccxml".to_string(), "XML".to_string()),
        (".clixml".to_string(), "XML".to_string()),
        (".cproject".to_string(), "XML".to_string()),
        (".cscfg".to_string(), "XML".to_string()),
        (".csdef".to_string(), "XML".to_string()),
        (".csproj".to_string(), "XML".to_string()),
        (".ct".to_string(), "XML".to_string()),
        (".depproj".to_string(), "XML".to_string()),
        (".dita".to_string(), "XML".to_string()),
        (".ditamap".to_string(), "XML".to_string()),
        (".ditaval".to_string(), "XML".to_string()),
        (".dll.config".to_string(), "XML".to_string()),
        (".dotsettings".to_string(), "XML".to_string()),
        (".filters".to_string(), "XML".to_string()),
        (".fsproj".to_string(), "XML".to_string()),
        (".fxml".to_string(), "XML".to_string()),
        (".glade".to_string(), "XML".to_string()),
        (".gmx".to_string(), "XML".to_string()),
        (".grxml".to_string(), "XML".to_string()),
        (".hzp".to_string(), "XML".to_string()),
        (".iml".to_string(), "XML".to_string()),
        (".ivy".to_string(), "XML".to_string()),
        (".jelly".to_string(), "XML".to_string()),
        (".jsproj".to_string(), "XML".to_string()),
        (".kml".to_string(), "XML".to_string()),
        (".launch".to_string(), "XML".to_string()),
        (".mdpolicy".to_string(), "XML".to_string()),
        (".mjml".to_string(), "XML".to_string()),
        (".mxml".to_string(), "XML".to_string()),
        (".natvis".to_string(), "XML".to_string()),
        (".ndproj".to_string(), "XML".to_string()),
        (".nproj".to_string(), "XML".to_string()),
        (".nuspec".to_string(), "XML".to_string()),
        (".odd".to_string(), "XML".to_string()),
        (".osm".to_string(), "XML".to_string()),
        (".pkgproj".to_string(), "XML".to_string()),
        (".proj".to_string(), "XML".to_string()),
        (".props".to_string(), "XML".to_string()),
        (".ps1xml".to_string(), "XML".to_string()),
        (".psc1".to_string(), "XML".to_string()),
        (".pt".to_string(), "XML".to_string()),
        (".rdf".to_string(), "XML".to_string()),
        (".resx".to_string(), "XML".to_string()),
        (".rss".to_string(), "XML".to_string()),
        (".scxml".to_string(), "XML".to_string()),
        (".sfproj".to_string(), "XML".to_string()),
        (".shproj".to_string(), "XML".to_string()),
        (".srdf".to_string(), "XML".to_string()),
        (".storyboard".to_string(), "XML".to_string()),
        (".sublime-snippet".to_string(), "XML".to_string()),
        (".targets".to_string(), "XML".to_string()),
        (".tml".to_string(), "XML".to_string()),
        (".ui".to_string(), "XML".to_string()),
        (".urdf".to_string(), "XML".to_string()),
        (".ux".to_string(), "XML".to_string()),
        (".vbproj".to_string(), "XML".to_string()),
        (".vcxproj".to_string(), "XML".to_string()),
        (".vsixmanifest".to_string(), "XML".to_string()),
        (".vssettings".to_string(), "XML".to_string()),
        (".vstemplate".to_string(), "XML".to_string()),
        (".vxml".to_string(), "XML".to_string()),
        (".wixproj".to_string(), "XML".to_string()),
        (".wsdl".to_string(), "XML".to_string()),
        (".wsf".to_string(), "XML".to_string()),
        (".wxi".to_string(), "XML".to_string()),
        (".wxl".to_string(), "XML".to_string()),
        (".wxs".to_string(), "XML".to_string()),
        (".x3d".to_string(), "XML".to_string()),
        (".xacro".to_string(), "XML".to_string()),
        (".xaml".to_string(), "XML".to_string()),
        (".xib".to_string(), "XML".to_string()),
        (".xlf".to_string(), "XML".to_string()),
        (".xliff".to_string(), "XML".to_string()),
        (".xmi".to_string(), "XML".to_string()),
        (".xml.dist".to_string(), "XML".to_string()),
        (".xmp".to_string(), "XML".to_string()),
        (".xproj".to_string(), "XML".to_string()),
        (".xsd".to_string(), "XML".to_string()),
        (".xspec".to_string(), "XML".to_string()),
        (".xul".to_string(), "XML".to_string()),
        (".zcml".to_string(), "XML".to_string()),
        (".sttheme".to_string(), "XML Property List".to_string()),
        (".tmcommand".to_string(), "XML Property List".to_string()),
        (".tmlanguage".to_string(), "XML Property List".to_string()),
        (
            ".tmpreferences".to_string(),
            "XML Property List".to_string()
        ),
        (".tmsnippet".to_string(), "XML Property List".to_string()),
        (".tmtheme".to_string(), "XML Property List".to_string()),
        (".xsp-config".to_string(), "XPages".to_string()),
        (".xsp.metadata".to_string(), "XPages".to_string()),
        (".xpl".to_string(), "XProc".to_string()),
        (".xproc".to_string(), "XProc".to_string()),
        (".xquery".to_string(), "XQuery".to_string()),
        (".xq".to_string(), "XQuery".to_string()),
        (".xql".to_string(), "XQuery".to_string()),
        (".xqm".to_string(), "XQuery".to_string()),
        (".xqy".to_string(), "XQuery".to_string()),
        (".xs".to_string(), "XS".to_string()),
        (".xslt".to_string(), "XSLT".to_string()),
        (".xsl".to_string(), "XSLT".to_string()),
        (".xojo_code".to_string(), "Xojo".to_string()),
        (".xojo_menu".to_string(), "Xojo".to_string()),
        (".xojo_report".to_string(), "Xojo".to_string()),
        (".xojo_script".to_string(), "Xojo".to_string()),
        (".xojo_toolbar".to_string(), "Xojo".to_string()),
        (".xojo_window".to_string(), "Xojo".to_string()),
        (".xsh".to_string(), "Xonsh".to_string()),
        (".xtend".to_string(), "Xtend".to_string()),
        (".yml".to_string(), "YAML".to_string()),
        (".mir".to_string(), "YAML".to_string()),
        (".reek".to_string(), "YAML".to_string()),
        (".rviz".to_string(), "YAML".to_string()),
        (".sublime-syntax".to_string(), "YAML".to_string()),
        (".syntax".to_string(), "YAML".to_string()),
        (".yaml".to_string(), "YAML".to_string()),
        (".yaml-tmlanguage".to_string(), "YAML".to_string()),
        (".yaml.sed".to_string(), "YAML".to_string()),
        (".yml.mysql".to_string(), "YAML".to_string()),
        (".yang".to_string(), "YANG".to_string()),
        (".yar".to_string(), "YARA".to_string()),
        (".yara".to_string(), "YARA".to_string()),
        (".yasnippet".to_string(), "YASnippet".to_string()),
        (".y".to_string(), "Yacc".to_string()),
        (".yacc".to_string(), "Yacc".to_string()),
        (".zap".to_string(), "ZAP".to_string()),
        (".xzap".to_string(), "ZAP".to_string()),
        (".zil".to_string(), "ZIL".to_string()),
        (".mud".to_string(), "ZIL".to_string()),
        (".zeek".to_string(), "Zeek".to_string()),
        (".bro".to_string(), "Zeek".to_string()),
        (".zs".to_string(), "ZenScript".to_string()),
        (".zep".to_string(), "Zephir".to_string()),
        (".zig".to_string(), "Zig".to_string()),
        (".zimpl".to_string(), "Zimpl".to_string()),
        (".zmpl".to_string(), "Zimpl".to_string()),
        (".zpl".to_string(), "Zimpl".to_string()),
        (".desktop".to_string(), "desktop".to_string()),
        (".desktop.in".to_string(), "desktop".to_string()),
        (".dircolors".to_string(), "dircolors".to_string()),
        (".ec".to_string(), "eC".to_string()),
        (".eh".to_string(), "eC".to_string()),
        (".edn".to_string(), "edn".to_string()),
        (".fish".to_string(), "fish".to_string()),
        (".mrc".to_string(), "mIRC Script".to_string()),
        (".mcfunction".to_string(), "mcfunction".to_string()),
        (".mu".to_string(), "mupad".to_string()),
        (".nanorc".to_string(), "nanorc".to_string()),
        (".nc".to_string(), "nesC".to_string()),
        (".ooc".to_string(), "ooc".to_string()),
        (".rst".to_string(), "reStructuredText".to_string()),
        (".rest".to_string(), "reStructuredText".to_string()),
        (".rest.txt".to_string(), "reStructuredText".to_string()),
        (".rst.txt".to_string(), "reStructuredText".to_string()),
        (".sed".to_string(), "sed".to_string()),
        (".wdl".to_string(), "wdl".to_string()),
        (".wisp".to_string(), "wisp".to_string()),
        (".prg".to_string(), "xBase".to_string()),
        (".prw".to_string(), "xBase".to_string()),
    ]
    .iter()
    .cloned()
    .collect();
}
