//
// $COPYRIGHT$: 794d8002d1b6d954e2302879cb69c215d893c60c
use lazy_static::lazy_static;
use std::collections::HashMap;

lazy_static! {
    pub static ref MODELINE_ALIASES: HashMap<String, String> = [
        ("1c enterprise".to_string(), "1C Enterprise".to_string()),
        ("4d".to_string(), "4D".to_string()),
        ("abap".to_string(), "ABAP".to_string()),
        ("abap cds".to_string(), "ABAP CDS".to_string()),
        ("abnf".to_string(), "ABNF".to_string()),
        ("ags script".to_string(), "AGS Script".to_string()),
        ("ags".to_string(), "AGS Script".to_string()),
        ("aidl".to_string(), "AIDL".to_string()),
        ("al".to_string(), "AL".to_string()),
        ("ampl".to_string(), "AMPL".to_string()),
        ("antlr".to_string(), "ANTLR".to_string()),
        ("api blueprint".to_string(), "API Blueprint".to_string()),
        ("apl".to_string(), "APL".to_string()),
        ("asl".to_string(), "ASL".to_string()),
        ("asn.1".to_string(), "ASN.1".to_string()),
        ("asp.net".to_string(), "ASP.NET".to_string()),
        ("aspx".to_string(), "ASP.NET".to_string()),
        ("aspx-vb".to_string(), "ASP.NET".to_string()),
        ("ats".to_string(), "ATS".to_string()),
        ("ats2".to_string(), "ATS".to_string()),
        ("actionscript".to_string(), "ActionScript".to_string()),
        ("actionscript 3".to_string(), "ActionScript".to_string()),
        ("actionscript3".to_string(), "ActionScript".to_string()),
        ("as3".to_string(), "ActionScript".to_string()),
        ("ada".to_string(), "Ada".to_string()),
        ("ada95".to_string(), "Ada".to_string()),
        ("ada2005".to_string(), "Ada".to_string()),
        (
            "adobe font metrics".to_string(),
            "Adobe Font Metrics".to_string()
        ),
        ("acfm".to_string(), "Adobe Font Metrics".to_string()),
        (
            "adobe composite font metrics".to_string(),
            "Adobe Font Metrics".to_string()
        ),
        (
            "adobe multiple font metrics".to_string(),
            "Adobe Font Metrics".to_string()
        ),
        ("amfm".to_string(), "Adobe Font Metrics".to_string()),
        ("agda".to_string(), "Agda".to_string()),
        ("alloy".to_string(), "Alloy".to_string()),
        ("alpine abuild".to_string(), "Alpine Abuild".to_string()),
        ("abuild".to_string(), "Alpine Abuild".to_string()),
        ("apkbuild".to_string(), "Alpine Abuild".to_string()),
        ("altium designer".to_string(), "Altium Designer".to_string()),
        ("altium".to_string(), "Altium Designer".to_string()),
        ("angelscript".to_string(), "AngelScript".to_string()),
        (
            "ant build system".to_string(),
            "Ant Build System".to_string()
        ),
        ("apacheconf".to_string(), "ApacheConf".to_string()),
        ("aconf".to_string(), "ApacheConf".to_string()),
        ("apache".to_string(), "ApacheConf".to_string()),
        ("apex".to_string(), "Apex".to_string()),
        (
            "apollo guidance computer".to_string(),
            "Apollo Guidance Computer".to_string()
        ),
        ("applescript".to_string(), "AppleScript".to_string()),
        ("osascript".to_string(), "AppleScript".to_string()),
        ("arc".to_string(), "Arc".to_string()),
        ("asciidoc".to_string(), "AsciiDoc".to_string()),
        ("aspectj".to_string(), "AspectJ".to_string()),
        ("assembly".to_string(), "Assembly".to_string()),
        ("asm".to_string(), "Assembly".to_string()),
        ("nasm".to_string(), "Assembly".to_string()),
        ("astro".to_string(), "Astro".to_string()),
        ("asymptote".to_string(), "Asymptote".to_string()),
        ("augeas".to_string(), "Augeas".to_string()),
        ("autohotkey".to_string(), "AutoHotkey".to_string()),
        ("ahk".to_string(), "AutoHotkey".to_string()),
        ("autoit".to_string(), "AutoIt".to_string()),
        ("au3".to_string(), "AutoIt".to_string()),
        ("AutoIt3".to_string(), "AutoIt".to_string()),
        ("AutoItScript".to_string(), "AutoIt".to_string()),
        ("avro idl".to_string(), "Avro IDL".to_string()),
        ("awk".to_string(), "Awk".to_string()),
        ("basic".to_string(), "BASIC".to_string()),
        ("ballerina".to_string(), "Ballerina".to_string()),
        ("batchfile".to_string(), "Batchfile".to_string()),
        ("bat".to_string(), "Batchfile".to_string()),
        ("batch".to_string(), "Batchfile".to_string()),
        ("dosbatch".to_string(), "Batchfile".to_string()),
        ("winbatch".to_string(), "Batchfile".to_string()),
        ("beef".to_string(), "Beef".to_string()),
        ("befunge".to_string(), "Befunge".to_string()),
        ("bibtex".to_string(), "BibTeX".to_string()),
        ("bicep".to_string(), "Bicep".to_string()),
        ("bison".to_string(), "Bison".to_string()),
        ("bitbake".to_string(), "BitBake".to_string()),
        ("blade".to_string(), "Blade".to_string()),
        ("blitzbasic".to_string(), "BlitzBasic".to_string()),
        ("b3d".to_string(), "BlitzBasic".to_string()),
        ("blitz3d".to_string(), "BlitzBasic".to_string()),
        ("blitzplus".to_string(), "BlitzBasic".to_string()),
        ("bplus".to_string(), "BlitzBasic".to_string()),
        ("blitzmax".to_string(), "BlitzMax".to_string()),
        ("bmax".to_string(), "BlitzMax".to_string()),
        ("bluespec".to_string(), "Bluespec".to_string()),
        ("boo".to_string(), "Boo".to_string()),
        ("boogie".to_string(), "Boogie".to_string()),
        ("brainfuck".to_string(), "Brainfuck".to_string()),
        ("brightscript".to_string(), "Brightscript".to_string()),
        ("browserslist".to_string(), "Browserslist".to_string()),
        ("c".to_string(), "C".to_string()),
        ("c#".to_string(), "C#".to_string()),
        ("csharp".to_string(), "C#".to_string()),
        ("cake".to_string(), "C#".to_string()),
        ("cakescript".to_string(), "C#".to_string()),
        ("c++".to_string(), "C++".to_string()),
        ("cpp".to_string(), "C++".to_string()),
        ("c-objdump".to_string(), "C-ObjDump".to_string()),
        ("c2hs haskell".to_string(), "C2hs Haskell".to_string()),
        ("c2hs".to_string(), "C2hs Haskell".to_string()),
        ("cil".to_string(), "CIL".to_string()),
        ("clips".to_string(), "CLIPS".to_string()),
        ("cmake".to_string(), "CMake".to_string()),
        ("cobol".to_string(), "COBOL".to_string()),
        ("codeowners".to_string(), "CODEOWNERS".to_string()),
        ("collada".to_string(), "COLLADA".to_string()),
        ("cson".to_string(), "CSON".to_string()),
        ("css".to_string(), "CSS".to_string()),
        ("csv".to_string(), "CSV".to_string()),
        ("cue".to_string(), "CUE".to_string()),
        ("cweb".to_string(), "CWeb".to_string()),
        ("cabal config".to_string(), "Cabal Config".to_string()),
        ("Cabal".to_string(), "Cabal Config".to_string()),
        ("cap'n proto".to_string(), "Cap'n Proto".to_string()),
        ("cartocss".to_string(), "CartoCSS".to_string()),
        ("Carto".to_string(), "CartoCSS".to_string()),
        ("ceylon".to_string(), "Ceylon".to_string()),
        ("chapel".to_string(), "Chapel".to_string()),
        ("chpl".to_string(), "Chapel".to_string()),
        ("charity".to_string(), "Charity".to_string()),
        ("chuck".to_string(), "ChucK".to_string()),
        ("cirru".to_string(), "Cirru".to_string()),
        ("clarion".to_string(), "Clarion".to_string()),
        ("classic asp".to_string(), "Classic ASP".to_string()),
        ("asp".to_string(), "Classic ASP".to_string()),
        ("clean".to_string(), "Clean".to_string()),
        ("click".to_string(), "Click".to_string()),
        ("clojure".to_string(), "Clojure".to_string()),
        (
            "closure templates".to_string(),
            "Closure Templates".to_string()
        ),
        ("soy".to_string(), "Closure Templates".to_string()),
        (
            "cloud firestore security rules".to_string(),
            "Cloud Firestore Security Rules".to_string()
        ),
        ("conll-u".to_string(), "CoNLL-U".to_string()),
        ("CoNLL".to_string(), "CoNLL-U".to_string()),
        ("CoNLL-X".to_string(), "CoNLL-U".to_string()),
        ("codeql".to_string(), "CodeQL".to_string()),
        ("ql".to_string(), "CodeQL".to_string()),
        ("coffeescript".to_string(), "CoffeeScript".to_string()),
        ("coffee".to_string(), "CoffeeScript".to_string()),
        ("coffee-script".to_string(), "CoffeeScript".to_string()),
        ("coldfusion".to_string(), "ColdFusion".to_string()),
        ("cfm".to_string(), "ColdFusion".to_string()),
        ("cfml".to_string(), "ColdFusion".to_string()),
        ("coldfusion html".to_string(), "ColdFusion".to_string()),
        ("coldfusion cfc".to_string(), "ColdFusion CFC".to_string()),
        ("cfc".to_string(), "ColdFusion CFC".to_string()),
        ("common lisp".to_string(), "Common Lisp".to_string()),
        ("lisp".to_string(), "Common Lisp".to_string()),
        (
            "common workflow language".to_string(),
            "Common Workflow Language".to_string()
        ),
        ("cwl".to_string(), "Common Workflow Language".to_string()),
        (
            "component pascal".to_string(),
            "Component Pascal".to_string()
        ),
        ("cool".to_string(), "Cool".to_string()),
        ("coq".to_string(), "Coq".to_string()),
        ("cpp-objdump".to_string(), "Cpp-ObjDump".to_string()),
        ("c++-objdump".to_string(), "Cpp-ObjDump".to_string()),
        ("creole".to_string(), "Creole".to_string()),
        ("crystal".to_string(), "Crystal".to_string()),
        ("csound".to_string(), "Csound".to_string()),
        ("csound-orc".to_string(), "Csound".to_string()),
        ("csound document".to_string(), "Csound Document".to_string()),
        ("csound-csd".to_string(), "Csound Document".to_string()),
        ("csound score".to_string(), "Csound Score".to_string()),
        ("csound-sco".to_string(), "Csound Score".to_string()),
        ("cuda".to_string(), "Cuda".to_string()),
        ("cue sheet".to_string(), "Cue Sheet".to_string()),
        ("cycript".to_string(), "Cycript".to_string()),
        ("cython".to_string(), "Cython".to_string()),
        ("pyrex".to_string(), "Cython".to_string()),
        ("d".to_string(), "D".to_string()),
        ("Dlang".to_string(), "D".to_string()),
        ("d-objdump".to_string(), "D-ObjDump".to_string()),
        (
            "digital command language".to_string(),
            "DIGITAL Command Language".to_string()
        ),
        ("dcl".to_string(), "DIGITAL Command Language".to_string()),
        ("dm".to_string(), "DM".to_string()),
        ("byond".to_string(), "DM".to_string()),
        ("dns zone".to_string(), "DNS Zone".to_string()),
        ("dtrace".to_string(), "DTrace".to_string()),
        ("dtrace-script".to_string(), "DTrace".to_string()),
        ("dafny".to_string(), "Dafny".to_string()),
        ("darcs patch".to_string(), "Darcs Patch".to_string()),
        ("dpatch".to_string(), "Darcs Patch".to_string()),
        ("dart".to_string(), "Dart".to_string()),
        ("dataweave".to_string(), "DataWeave".to_string()),
        ("dhall".to_string(), "Dhall".to_string()),
        ("diff".to_string(), "Diff".to_string()),
        ("udiff".to_string(), "Diff".to_string()),
        ("directx 3d file".to_string(), "DirectX 3D File".to_string()),
        ("dockerfile".to_string(), "Dockerfile".to_string()),
        ("Containerfile".to_string(), "Dockerfile".to_string()),
        ("dogescript".to_string(), "Dogescript".to_string()),
        ("dylan".to_string(), "Dylan".to_string()),
        ("e".to_string(), "E".to_string()),
        ("e-mail".to_string(), "E-mail".to_string()),
        ("email".to_string(), "E-mail".to_string()),
        ("eml".to_string(), "E-mail".to_string()),
        ("mail".to_string(), "E-mail".to_string()),
        ("mbox".to_string(), "E-mail".to_string()),
        ("ebnf".to_string(), "EBNF".to_string()),
        ("ecl".to_string(), "ECL".to_string()),
        ("eclipse".to_string(), "ECLiPSe".to_string()),
        ("ejs".to_string(), "EJS".to_string()),
        ("eq".to_string(), "EQ".to_string()),
        ("eagle".to_string(), "Eagle".to_string()),
        ("earthly".to_string(), "Earthly".to_string()),
        ("easybuild".to_string(), "Easybuild".to_string()),
        ("ecere projects".to_string(), "Ecere Projects".to_string()),
        ("editorconfig".to_string(), "EditorConfig".to_string()),
        ("editor-config".to_string(), "EditorConfig".to_string()),
        (
            "edje data collection".to_string(),
            "Edje Data Collection".to_string()
        ),
        ("eiffel".to_string(), "Eiffel".to_string()),
        ("elixir".to_string(), "Elixir".to_string()),
        ("elm".to_string(), "Elm".to_string()),
        ("emacs lisp".to_string(), "Emacs Lisp".to_string()),
        ("elisp".to_string(), "Emacs Lisp".to_string()),
        ("emacs".to_string(), "Emacs Lisp".to_string()),
        ("emberscript".to_string(), "EmberScript".to_string()),
        ("erlang".to_string(), "Erlang".to_string()),
        ("f#".to_string(), "F#".to_string()),
        ("fsharp".to_string(), "F#".to_string()),
        ("f*".to_string(), "F*".to_string()),
        ("fstar".to_string(), "F*".to_string()),
        ("figlet font".to_string(), "FIGlet Font".to_string()),
        ("FIGfont".to_string(), "FIGlet Font".to_string()),
        ("flux".to_string(), "FLUX".to_string()),
        ("factor".to_string(), "Factor".to_string()),
        ("fancy".to_string(), "Fancy".to_string()),
        ("fantom".to_string(), "Fantom".to_string()),
        ("faust".to_string(), "Faust".to_string()),
        ("fennel".to_string(), "Fennel".to_string()),
        ("filebench wml".to_string(), "Filebench WML".to_string()),
        ("filterscript".to_string(), "Filterscript".to_string()),
        ("fluent".to_string(), "Fluent".to_string()),
        ("formatted".to_string(), "Formatted".to_string()),
        ("forth".to_string(), "Forth".to_string()),
        ("fortran".to_string(), "Fortran".to_string()),
        (
            "fortran free form".to_string(),
            "Fortran Free Form".to_string()
        ),
        ("freebasic".to_string(), "FreeBasic".to_string()),
        ("fb".to_string(), "FreeBasic".to_string()),
        ("freemarker".to_string(), "FreeMarker".to_string()),
        ("ftl".to_string(), "FreeMarker".to_string()),
        ("frege".to_string(), "Frege".to_string()),
        ("futhark".to_string(), "Futhark".to_string()),
        ("g-code".to_string(), "G-code".to_string()),
        ("gaml".to_string(), "GAML".to_string()),
        ("gams".to_string(), "GAMS".to_string()),
        ("gap".to_string(), "GAP".to_string()),
        (
            "gcc machine description".to_string(),
            "GCC Machine Description".to_string()
        ),
        ("gdb".to_string(), "GDB".to_string()),
        ("gdscript".to_string(), "GDScript".to_string()),
        ("gedcom".to_string(), "GEDCOM".to_string()),
        ("glsl".to_string(), "GLSL".to_string()),
        ("gn".to_string(), "GN".to_string()),
        (
            "game maker language".to_string(),
            "Game Maker Language".to_string()
        ),
        ("gemfile.lock".to_string(), "Gemfile.lock".to_string()),
        ("genie".to_string(), "Genie".to_string()),
        ("genshi".to_string(), "Genshi".to_string()),
        ("xml+genshi".to_string(), "Genshi".to_string()),
        ("xml+kid".to_string(), "Genshi".to_string()),
        ("gentoo ebuild".to_string(), "Gentoo Ebuild".to_string()),
        ("gentoo eclass".to_string(), "Gentoo Eclass".to_string()),
        ("gerber image".to_string(), "Gerber Image".to_string()),
        ("rs-274x".to_string(), "Gerber Image".to_string()),
        ("gettext catalog".to_string(), "Gettext Catalog".to_string()),
        ("pot".to_string(), "Gettext Catalog".to_string()),
        ("gherkin".to_string(), "Gherkin".to_string()),
        ("cucumber".to_string(), "Gherkin".to_string()),
        ("git attributes".to_string(), "Git Attributes".to_string()),
        ("gitattributes".to_string(), "Git Attributes".to_string()),
        ("git config".to_string(), "Git Config".to_string()),
        ("gitconfig".to_string(), "Git Config".to_string()),
        ("gitmodules".to_string(), "Git Config".to_string()),
        ("glyph".to_string(), "Glyph".to_string()),
        (
            "glyph bitmap distribution format".to_string(),
            "Glyph Bitmap Distribution Format".to_string()
        ),
        (
            "gnat project manager".to_string(),
            "GNAT Project Manager".to_string()
        ),
        ("gnuplot".to_string(), "Gnuplot".to_string()),
        ("go".to_string(), "Go".to_string()),
        ("golang".to_string(), "Go".to_string()),
        ("go checksums".to_string(), "Go Checksums".to_string()),
        ("go.sum".to_string(), "Go Checksums".to_string()),
        ("go sum".to_string(), "Go Checksums".to_string()),
        ("go module".to_string(), "Go Module".to_string()),
        ("go.mod".to_string(), "Go Module".to_string()),
        ("go mod".to_string(), "Go Module".to_string()),
        ("golo".to_string(), "Golo".to_string()),
        ("gosu".to_string(), "Gosu".to_string()),
        ("grace".to_string(), "Grace".to_string()),
        ("gradle".to_string(), "Gradle".to_string()),
        (
            "grammatical framework".to_string(),
            "Grammatical Framework".to_string()
        ),
        ("gf".to_string(), "Grammatical Framework".to_string()),
        (
            "graph modeling language".to_string(),
            "Graph Modeling Language".to_string()
        ),
        ("graphql".to_string(), "GraphQL".to_string()),
        ("graphviz (dot)".to_string(), "Graphviz (DOT)".to_string()),
        ("groovy".to_string(), "Groovy".to_string()),
        (
            "groovy server pages".to_string(),
            "Groovy Server Pages".to_string()
        ),
        ("gsp".to_string(), "Groovy Server Pages".to_string()),
        (
            "java server page".to_string(),
            "Groovy Server Pages".to_string()
        ),
        ("haproxy".to_string(), "HAProxy".to_string()),
        ("hcl".to_string(), "HCL".to_string()),
        (
            "HashiCorp Configuration Language".to_string(),
            "HCL".to_string()
        ),
        ("terraform".to_string(), "HCL".to_string()),
        ("hlsl".to_string(), "HLSL".to_string()),
        ("html".to_string(), "HTML".to_string()),
        ("xhtml".to_string(), "HTML".to_string()),
        ("html+ecr".to_string(), "HTML+ECR".to_string()),
        ("ecr".to_string(), "HTML+ECR".to_string()),
        ("html+eex".to_string(), "HTML+EEX".to_string()),
        ("eex".to_string(), "HTML+EEX".to_string()),
        ("heex".to_string(), "HTML+EEX".to_string()),
        ("leex".to_string(), "HTML+EEX".to_string()),
        ("html+erb".to_string(), "HTML+ERB".to_string()),
        ("erb".to_string(), "HTML+ERB".to_string()),
        ("rhtml".to_string(), "HTML+ERB".to_string()),
        ("html+ruby".to_string(), "HTML+ERB".to_string()),
        ("html+php".to_string(), "HTML+PHP".to_string()),
        ("html+razor".to_string(), "HTML+Razor".to_string()),
        ("razor".to_string(), "HTML+Razor".to_string()),
        ("http".to_string(), "HTTP".to_string()),
        ("hxml".to_string(), "HXML".to_string()),
        ("hack".to_string(), "Hack".to_string()),
        ("haml".to_string(), "Haml".to_string()),
        ("handlebars".to_string(), "Handlebars".to_string()),
        ("hbs".to_string(), "Handlebars".to_string()),
        ("htmlbars".to_string(), "Handlebars".to_string()),
        ("harbour".to_string(), "Harbour".to_string()),
        ("haskell".to_string(), "Haskell".to_string()),
        ("haxe".to_string(), "Haxe".to_string()),
        ("hiveql".to_string(), "HiveQL".to_string()),
        ("holyc".to_string(), "HolyC".to_string()),
        ("hy".to_string(), "Hy".to_string()),
        ("hylang".to_string(), "Hy".to_string()),
        ("hyphy".to_string(), "HyPhy".to_string()),
        ("idl".to_string(), "IDL".to_string()),
        ("igor pro".to_string(), "IGOR Pro".to_string()),
        ("igor".to_string(), "IGOR Pro".to_string()),
        ("igorpro".to_string(), "IGOR Pro".to_string()),
        ("ini".to_string(), "INI".to_string()),
        ("dosini".to_string(), "INI".to_string()),
        ("irc log".to_string(), "IRC log".to_string()),
        ("irc".to_string(), "IRC log".to_string()),
        ("irc logs".to_string(), "IRC log".to_string()),
        ("idris".to_string(), "Idris".to_string()),
        ("ignore list".to_string(), "Ignore List".to_string()),
        ("ignore".to_string(), "Ignore List".to_string()),
        ("gitignore".to_string(), "Ignore List".to_string()),
        ("git-ignore".to_string(), "Ignore List".to_string()),
        ("imagej macro".to_string(), "ImageJ Macro".to_string()),
        ("ijm".to_string(), "ImageJ Macro".to_string()),
        ("inform 7".to_string(), "Inform 7".to_string()),
        ("i7".to_string(), "Inform 7".to_string()),
        ("inform7".to_string(), "Inform 7".to_string()),
        ("inno setup".to_string(), "Inno Setup".to_string()),
        ("io".to_string(), "Io".to_string()),
        ("ioke".to_string(), "Ioke".to_string()),
        ("isabelle".to_string(), "Isabelle".to_string()),
        ("isabelle root".to_string(), "Isabelle ROOT".to_string()),
        ("j".to_string(), "J".to_string()),
        ("jar manifest".to_string(), "JAR Manifest".to_string()),
        ("jflex".to_string(), "JFlex".to_string()),
        ("json".to_string(), "JSON".to_string()),
        (
            "json with comments".to_string(),
            "JSON with Comments".to_string()
        ),
        ("jsonc".to_string(), "JSON with Comments".to_string()),
        ("json5".to_string(), "JSON5".to_string()),
        ("jsonld".to_string(), "JSONLD".to_string()),
        ("jsoniq".to_string(), "JSONiq".to_string()),
        ("jasmin".to_string(), "Jasmin".to_string()),
        ("java".to_string(), "Java".to_string()),
        ("java properties".to_string(), "Java Properties".to_string()),
        (
            "java server pages".to_string(),
            "Java Server Pages".to_string()
        ),
        ("jsp".to_string(), "Java Server Pages".to_string()),
        ("javascript".to_string(), "JavaScript".to_string()),
        ("js".to_string(), "JavaScript".to_string()),
        ("node".to_string(), "JavaScript".to_string()),
        ("javascript+erb".to_string(), "JavaScript+ERB".to_string()),
        ("jest snapshot".to_string(), "Jest Snapshot".to_string()),
        ("jinja".to_string(), "Jinja".to_string()),
        ("django".to_string(), "Jinja".to_string()),
        ("html+django".to_string(), "Jinja".to_string()),
        ("html+jinja".to_string(), "Jinja".to_string()),
        ("htmldjango".to_string(), "Jinja".to_string()),
        ("jison".to_string(), "Jison".to_string()),
        ("jison lex".to_string(), "Jison Lex".to_string()),
        ("jolie".to_string(), "Jolie".to_string()),
        ("jsonnet".to_string(), "Jsonnet".to_string()),
        ("julia".to_string(), "Julia".to_string()),
        (
            "jupyter notebook".to_string(),
            "Jupyter Notebook".to_string()
        ),
        (
            "IPython Notebook".to_string(),
            "Jupyter Notebook".to_string()
        ),
        ("krl".to_string(), "KRL".to_string()),
        ("kaitai struct".to_string(), "Kaitai Struct".to_string()),
        ("ksy".to_string(), "Kaitai Struct".to_string()),
        ("kakounescript".to_string(), "KakouneScript".to_string()),
        ("kak".to_string(), "KakouneScript".to_string()),
        ("kakscript".to_string(), "KakouneScript".to_string()),
        ("kicad layout".to_string(), "KiCad Layout".to_string()),
        ("pcbnew".to_string(), "KiCad Layout".to_string()),
        (
            "kicad legacy layout".to_string(),
            "KiCad Legacy Layout".to_string()
        ),
        ("kicad schematic".to_string(), "KiCad Schematic".to_string()),
        (
            "eeschema schematic".to_string(),
            "KiCad Schematic".to_string()
        ),
        ("kit".to_string(), "Kit".to_string()),
        ("kotlin".to_string(), "Kotlin".to_string()),
        ("kusto".to_string(), "Kusto".to_string()),
        ("lfe".to_string(), "LFE".to_string()),
        ("llvm".to_string(), "LLVM".to_string()),
        ("lolcode".to_string(), "LOLCODE".to_string()),
        ("lsl".to_string(), "LSL".to_string()),
        ("ltspice symbol".to_string(), "LTspice Symbol".to_string()),
        ("labview".to_string(), "LabVIEW".to_string()),
        ("lark".to_string(), "Lark".to_string()),
        ("lasso".to_string(), "Lasso".to_string()),
        ("lassoscript".to_string(), "Lasso".to_string()),
        ("latte".to_string(), "Latte".to_string()),
        ("lean".to_string(), "Lean".to_string()),
        ("less".to_string(), "Less".to_string()),
        ("lex".to_string(), "Lex".to_string()),
        ("flex".to_string(), "Lex".to_string()),
        ("lilypond".to_string(), "LilyPond".to_string()),
        ("limbo".to_string(), "Limbo".to_string()),
        ("linker script".to_string(), "Linker Script".to_string()),
        (
            "linux kernel module".to_string(),
            "Linux Kernel Module".to_string()
        ),
        ("liquid".to_string(), "Liquid".to_string()),
        ("literate agda".to_string(), "Literate Agda".to_string()),
        (
            "literate coffeescript".to_string(),
            "Literate CoffeeScript".to_string()
        ),
        ("litcoffee".to_string(), "Literate CoffeeScript".to_string()),
        (
            "literate haskell".to_string(),
            "Literate Haskell".to_string()
        ),
        ("lhaskell".to_string(), "Literate Haskell".to_string()),
        ("lhs".to_string(), "Literate Haskell".to_string()),
        ("livescript".to_string(), "LiveScript".to_string()),
        ("live-script".to_string(), "LiveScript".to_string()),
        ("ls".to_string(), "LiveScript".to_string()),
        ("logos".to_string(), "Logos".to_string()),
        ("logtalk".to_string(), "Logtalk".to_string()),
        ("lookml".to_string(), "LookML".to_string()),
        ("loomscript".to_string(), "LoomScript".to_string()),
        ("lua".to_string(), "Lua".to_string()),
        ("m".to_string(), "M".to_string()),
        ("mumps".to_string(), "M".to_string()),
        ("m4".to_string(), "M4".to_string()),
        ("m4sugar".to_string(), "M4Sugar".to_string()),
        ("autoconf".to_string(), "M4Sugar".to_string()),
        ("matlab".to_string(), "MATLAB".to_string()),
        ("octave".to_string(), "MATLAB".to_string()),
        ("maxscript".to_string(), "MAXScript".to_string()),
        ("mlir".to_string(), "MLIR".to_string()),
        ("mql4".to_string(), "MQL4".to_string()),
        ("mql5".to_string(), "MQL5".to_string()),
        ("mtml".to_string(), "MTML".to_string()),
        ("muf".to_string(), "MUF".to_string()),
        ("macaulay2".to_string(), "Macaulay2".to_string()),
        ("m2".to_string(), "Macaulay2".to_string()),
        ("makefile".to_string(), "Makefile".to_string()),
        ("bsdmake".to_string(), "Makefile".to_string()),
        ("make".to_string(), "Makefile".to_string()),
        ("mf".to_string(), "Makefile".to_string()),
        ("mako".to_string(), "Mako".to_string()),
        ("markdown".to_string(), "Markdown".to_string()),
        ("pandoc".to_string(), "Markdown".to_string()),
        ("marko".to_string(), "Marko".to_string()),
        ("markojs".to_string(), "Marko".to_string()),
        ("mask".to_string(), "Mask".to_string()),
        ("mathematica".to_string(), "Mathematica".to_string()),
        ("mma".to_string(), "Mathematica".to_string()),
        ("wolfram".to_string(), "Mathematica".to_string()),
        ("wolfram language".to_string(), "Mathematica".to_string()),
        ("wolfram lang".to_string(), "Mathematica".to_string()),
        ("wl".to_string(), "Mathematica".to_string()),
        ("maven pom".to_string(), "Maven POM".to_string()),
        ("max".to_string(), "Max".to_string()),
        ("max/msp".to_string(), "Max".to_string()),
        ("maxmsp".to_string(), "Max".to_string()),
        ("mercury".to_string(), "Mercury".to_string()),
        ("meson".to_string(), "Meson".to_string()),
        ("metal".to_string(), "Metal".to_string()),
        (
            "microsoft developer studio project".to_string(),
            "Microsoft Developer Studio Project".to_string()
        ),
        (
            "microsoft visual studio solution".to_string(),
            "Microsoft Visual Studio Solution".to_string()
        ),
        ("minid".to_string(), "MiniD".to_string()),
        ("mirah".to_string(), "Mirah".to_string()),
        ("modelica".to_string(), "Modelica".to_string()),
        ("modula-2".to_string(), "Modula-2".to_string()),
        ("modula-3".to_string(), "Modula-3".to_string()),
        (
            "module management system".to_string(),
            "Module Management System".to_string()
        ),
        ("monkey".to_string(), "Monkey".to_string()),
        ("moocode".to_string(), "Moocode".to_string()),
        ("moonscript".to_string(), "MoonScript".to_string()),
        ("motoko".to_string(), "Motoko".to_string()),
        (
            "motorola 68k assembly".to_string(),
            "Motorola 68K Assembly".to_string()
        ),
        ("m68k".to_string(), "Motorola 68K Assembly".to_string()),
        ("muse".to_string(), "Muse".to_string()),
        ("amusewiki".to_string(), "Muse".to_string()),
        ("emacs muse".to_string(), "Muse".to_string()),
        ("mustache".to_string(), "Mustache".to_string()),
        ("myghty".to_string(), "Myghty".to_string()),
        ("nasl".to_string(), "NASL".to_string()),
        ("ncl".to_string(), "NCL".to_string()),
        ("neon".to_string(), "NEON".to_string()),
        ("nette object notation".to_string(), "NEON".to_string()),
        ("ne-on".to_string(), "NEON".to_string()),
        ("nl".to_string(), "NL".to_string()),
        ("npm config".to_string(), "NPM Config".to_string()),
        ("npmrc".to_string(), "NPM Config".to_string()),
        ("nsis".to_string(), "NSIS".to_string()),
        ("nwscript".to_string(), "NWScript".to_string()),
        ("nearley".to_string(), "Nearley".to_string()),
        ("nemerle".to_string(), "Nemerle".to_string()),
        ("netlinx".to_string(), "NetLinx".to_string()),
        ("netlinx+erb".to_string(), "NetLinx+ERB".to_string()),
        ("netlogo".to_string(), "NetLogo".to_string()),
        ("newlisp".to_string(), "NewLisp".to_string()),
        ("nextflow".to_string(), "Nextflow".to_string()),
        ("nginx".to_string(), "Nginx".to_string()),
        ("nginx configuration file".to_string(), "Nginx".to_string()),
        ("nim".to_string(), "Nim".to_string()),
        ("ninja".to_string(), "Ninja".to_string()),
        ("nit".to_string(), "Nit".to_string()),
        ("nix".to_string(), "Nix".to_string()),
        ("nixos".to_string(), "Nix".to_string()),
        ("nu".to_string(), "Nu".to_string()),
        ("nush".to_string(), "Nu".to_string()),
        ("numpy".to_string(), "NumPy".to_string()),
        ("nunjucks".to_string(), "Nunjucks".to_string()),
        ("njk".to_string(), "Nunjucks".to_string()),
        ("ocaml".to_string(), "OCaml".to_string()),
        ("objdump".to_string(), "ObjDump".to_string()),
        (
            "object data instance notation".to_string(),
            "Object Data Instance Notation".to_string()
        ),
        ("objectscript".to_string(), "ObjectScript".to_string()),
        ("objective-c".to_string(), "Objective-C".to_string()),
        ("obj-c".to_string(), "Objective-C".to_string()),
        ("objc".to_string(), "Objective-C".to_string()),
        ("objectivec".to_string(), "Objective-C".to_string()),
        ("objective-c++".to_string(), "Objective-C++".to_string()),
        ("obj-c++".to_string(), "Objective-C++".to_string()),
        ("objc++".to_string(), "Objective-C++".to_string()),
        ("objectivec++".to_string(), "Objective-C++".to_string()),
        ("objective-j".to_string(), "Objective-J".to_string()),
        ("obj-j".to_string(), "Objective-J".to_string()),
        ("objectivej".to_string(), "Objective-J".to_string()),
        ("objj".to_string(), "Objective-J".to_string()),
        ("odin".to_string(), "Odin".to_string()),
        ("odinlang".to_string(), "Odin".to_string()),
        ("odin-lang".to_string(), "Odin".to_string()),
        ("omgrofl".to_string(), "Omgrofl".to_string()),
        ("opa".to_string(), "Opa".to_string()),
        ("opal".to_string(), "Opal".to_string()),
        (
            "open policy agent".to_string(),
            "Open Policy Agent".to_string()
        ),
        ("opencl".to_string(), "OpenCL".to_string()),
        ("openedge abl".to_string(), "OpenEdge ABL".to_string()),
        ("progress".to_string(), "OpenEdge ABL".to_string()),
        ("openedge".to_string(), "OpenEdge ABL".to_string()),
        ("abl".to_string(), "OpenEdge ABL".to_string()),
        ("openqasm".to_string(), "OpenQASM".to_string()),
        (
            "openrc runscript".to_string(),
            "OpenRC runscript".to_string()
        ),
        ("openrc".to_string(), "OpenRC runscript".to_string()),
        ("openscad".to_string(), "OpenSCAD".to_string()),
        (
            "openstep property list".to_string(),
            "OpenStep Property List".to_string()
        ),
        (
            "opentype feature file".to_string(),
            "OpenType Feature File".to_string()
        ),
        ("AFDKO".to_string(), "OpenType Feature File".to_string()),
        ("org".to_string(), "Org".to_string()),
        ("ox".to_string(), "Ox".to_string()),
        ("oxygene".to_string(), "Oxygene".to_string()),
        ("oz".to_string(), "Oz".to_string()),
        ("p4".to_string(), "P4".to_string()),
        ("peg.js".to_string(), "PEG.js".to_string()),
        ("php".to_string(), "PHP".to_string()),
        ("inc".to_string(), "PHP".to_string()),
        ("plsql".to_string(), "PLSQL".to_string()),
        ("plpgsql".to_string(), "PLpgSQL".to_string()),
        ("pov-ray sdl".to_string(), "POV-Ray SDL".to_string()),
        ("pov-ray".to_string(), "POV-Ray SDL".to_string()),
        ("povray".to_string(), "POV-Ray SDL".to_string()),
        ("pan".to_string(), "Pan".to_string()),
        ("papyrus".to_string(), "Papyrus".to_string()),
        ("parrot".to_string(), "Parrot".to_string()),
        ("parrot assembly".to_string(), "Parrot Assembly".to_string()),
        ("pasm".to_string(), "Parrot Assembly".to_string()),
        (
            "parrot internal representation".to_string(),
            "Parrot Internal Representation".to_string()
        ),
        (
            "pir".to_string(),
            "Parrot Internal Representation".to_string()
        ),
        ("pascal".to_string(), "Pascal".to_string()),
        ("delphi".to_string(), "Pascal".to_string()),
        ("objectpascal".to_string(), "Pascal".to_string()),
        ("pawn".to_string(), "Pawn".to_string()),
        ("pep8".to_string(), "Pep8".to_string()),
        ("perl".to_string(), "Perl".to_string()),
        ("cperl".to_string(), "Perl".to_string()),
        ("pic".to_string(), "Pic".to_string()),
        ("pickle".to_string(), "Pickle".to_string()),
        ("picolisp".to_string(), "PicoLisp".to_string()),
        ("piglatin".to_string(), "PigLatin".to_string()),
        ("pike".to_string(), "Pike".to_string()),
        ("plantuml".to_string(), "PlantUML".to_string()),
        ("pod".to_string(), "Pod".to_string()),
        ("pod 6".to_string(), "Pod 6".to_string()),
        ("pogoscript".to_string(), "PogoScript".to_string()),
        ("pony".to_string(), "Pony".to_string()),
        ("postcss".to_string(), "PostCSS".to_string()),
        ("postscript".to_string(), "PostScript".to_string()),
        ("postscr".to_string(), "PostScript".to_string()),
        ("powerbuilder".to_string(), "PowerBuilder".to_string()),
        ("powershell".to_string(), "PowerShell".to_string()),
        ("posh".to_string(), "PowerShell".to_string()),
        ("pwsh".to_string(), "PowerShell".to_string()),
        ("prisma".to_string(), "Prisma".to_string()),
        ("processing".to_string(), "Processing".to_string()),
        ("proguard".to_string(), "Proguard".to_string()),
        ("prolog".to_string(), "Prolog".to_string()),
        ("promela".to_string(), "Promela".to_string()),
        ("propeller spin".to_string(), "Propeller Spin".to_string()),
        ("protocol buffer".to_string(), "Protocol Buffer".to_string()),
        ("protobuf".to_string(), "Protocol Buffer".to_string()),
        (
            "Protocol Buffers".to_string(),
            "Protocol Buffer".to_string()
        ),
        ("public key".to_string(), "Public Key".to_string()),
        ("pug".to_string(), "Pug".to_string()),
        ("puppet".to_string(), "Puppet".to_string()),
        ("pure data".to_string(), "Pure Data".to_string()),
        ("purebasic".to_string(), "PureBasic".to_string()),
        ("purescript".to_string(), "PureScript".to_string()),
        ("python".to_string(), "Python".to_string()),
        ("python3".to_string(), "Python".to_string()),
        ("rusthon".to_string(), "Python".to_string()),
        ("python console".to_string(), "Python console".to_string()),
        ("pycon".to_string(), "Python console".to_string()),
        (
            "python traceback".to_string(),
            "Python traceback".to_string()
        ),
        ("q#".to_string(), "Q#".to_string()),
        ("qsharp".to_string(), "Q#".to_string()),
        ("qml".to_string(), "QML".to_string()),
        ("qmake".to_string(), "QMake".to_string()),
        ("qt script".to_string(), "Qt Script".to_string()),
        ("quake".to_string(), "Quake".to_string()),
        ("r".to_string(), "R".to_string()),
        ("R".to_string(), "R".to_string()),
        ("Rscript".to_string(), "R".to_string()),
        ("splus".to_string(), "R".to_string()),
        ("raml".to_string(), "RAML".to_string()),
        ("rdoc".to_string(), "RDoc".to_string()),
        ("realbasic".to_string(), "REALbasic".to_string()),
        ("rexx".to_string(), "REXX".to_string()),
        ("arexx".to_string(), "REXX".to_string()),
        ("rmarkdown".to_string(), "RMarkdown".to_string()),
        ("rpc".to_string(), "RPC".to_string()),
        ("rpcgen".to_string(), "RPC".to_string()),
        ("oncrpc".to_string(), "RPC".to_string()),
        ("xdr".to_string(), "RPC".to_string()),
        ("rpm spec".to_string(), "RPM Spec".to_string()),
        ("specfile".to_string(), "RPM Spec".to_string()),
        ("runoff".to_string(), "RUNOFF".to_string()),
        ("racket".to_string(), "Racket".to_string()),
        ("ragel".to_string(), "Ragel".to_string()),
        ("ragel-rb".to_string(), "Ragel".to_string()),
        ("ragel-ruby".to_string(), "Ragel".to_string()),
        ("raku".to_string(), "Raku".to_string()),
        ("perl6".to_string(), "Raku".to_string()),
        ("perl-6".to_string(), "Raku".to_string()),
        ("rascal".to_string(), "Rascal".to_string()),
        ("raw token data".to_string(), "Raw token data".to_string()),
        ("raw".to_string(), "Raw token data".to_string()),
        ("rescript".to_string(), "ReScript".to_string()),
        ("readline config".to_string(), "Readline Config".to_string()),
        ("inputrc".to_string(), "Readline Config".to_string()),
        ("readline".to_string(), "Readline Config".to_string()),
        ("reason".to_string(), "Reason".to_string()),
        ("rebol".to_string(), "Rebol".to_string()),
        ("record jar".to_string(), "Record Jar".to_string()),
        ("red".to_string(), "Red".to_string()),
        ("red/system".to_string(), "Red".to_string()),
        ("redcode".to_string(), "Redcode".to_string()),
        ("redirect rules".to_string(), "Redirect Rules".to_string()),
        ("redirects".to_string(), "Redirect Rules".to_string()),
        (
            "regular expression".to_string(),
            "Regular Expression".to_string()
        ),
        ("regexp".to_string(), "Regular Expression".to_string()),
        ("regex".to_string(), "Regular Expression".to_string()),
        ("ren'py".to_string(), "Ren'Py".to_string()),
        ("renpy".to_string(), "Ren'Py".to_string()),
        ("renderscript".to_string(), "RenderScript".to_string()),
        (
            "rich text format".to_string(),
            "Rich Text Format".to_string()
        ),
        ("ring".to_string(), "Ring".to_string()),
        ("riot".to_string(), "Riot".to_string()),
        ("robotframework".to_string(), "RobotFramework".to_string()),
        ("roff".to_string(), "Roff".to_string()),
        ("groff".to_string(), "Roff".to_string()),
        ("man".to_string(), "Roff".to_string()),
        ("manpage".to_string(), "Roff".to_string()),
        ("man page".to_string(), "Roff".to_string()),
        ("man-page".to_string(), "Roff".to_string()),
        ("mdoc".to_string(), "Roff".to_string()),
        ("nroff".to_string(), "Roff".to_string()),
        ("troff".to_string(), "Roff".to_string()),
        ("roff manpage".to_string(), "Roff Manpage".to_string()),
        ("rouge".to_string(), "Rouge".to_string()),
        ("ruby".to_string(), "Ruby".to_string()),
        ("jruby".to_string(), "Ruby".to_string()),
        ("macruby".to_string(), "Ruby".to_string()),
        ("rake".to_string(), "Ruby".to_string()),
        ("rb".to_string(), "Ruby".to_string()),
        ("rbx".to_string(), "Ruby".to_string()),
        ("rust".to_string(), "Rust".to_string()),
        ("rs".to_string(), "Rust".to_string()),
        ("sas".to_string(), "SAS".to_string()),
        ("scss".to_string(), "SCSS".to_string()),
        ("selinux policy".to_string(), "SELinux Policy".to_string()),
        (
            "SELinux Kernel Policy Language".to_string(),
            "SELinux Policy".to_string()
        ),
        ("sepolicy".to_string(), "SELinux Policy".to_string()),
        ("smt".to_string(), "SMT".to_string()),
        ("sparql".to_string(), "SPARQL".to_string()),
        ("sqf".to_string(), "SQF".to_string()),
        ("sql".to_string(), "SQL".to_string()),
        ("sqlpl".to_string(), "SQLPL".to_string()),
        (
            "srecode template".to_string(),
            "SRecode Template".to_string()
        ),
        ("ssh config".to_string(), "SSH Config".to_string()),
        ("ston".to_string(), "STON".to_string()),
        ("svg".to_string(), "SVG".to_string()),
        ("swig".to_string(), "SWIG".to_string()),
        ("sage".to_string(), "Sage".to_string()),
        ("saltstack".to_string(), "SaltStack".to_string()),
        ("saltstate".to_string(), "SaltStack".to_string()),
        ("salt".to_string(), "SaltStack".to_string()),
        ("sass".to_string(), "Sass".to_string()),
        ("scala".to_string(), "Scala".to_string()),
        ("scaml".to_string(), "Scaml".to_string()),
        ("scheme".to_string(), "Scheme".to_string()),
        ("scilab".to_string(), "Scilab".to_string()),
        ("self".to_string(), "Self".to_string()),
        ("shaderlab".to_string(), "ShaderLab".to_string()),
        ("shell".to_string(), "Shell".to_string()),
        ("sh".to_string(), "Shell".to_string()),
        ("shell-script".to_string(), "Shell".to_string()),
        ("bash".to_string(), "Shell".to_string()),
        ("zsh".to_string(), "Shell".to_string()),
        (
            "shellcheck config".to_string(),
            "ShellCheck Config".to_string()
        ),
        ("shellcheckrc".to_string(), "ShellCheck Config".to_string()),
        ("shellsession".to_string(), "ShellSession".to_string()),
        ("bash session".to_string(), "ShellSession".to_string()),
        ("console".to_string(), "ShellSession".to_string()),
        ("shen".to_string(), "Shen".to_string()),
        ("sieve".to_string(), "Sieve".to_string()),
        ("singularity".to_string(), "Singularity".to_string()),
        ("slash".to_string(), "Slash".to_string()),
        ("slice".to_string(), "Slice".to_string()),
        ("slim".to_string(), "Slim".to_string()),
        ("smpl".to_string(), "SmPL".to_string()),
        ("coccinelle".to_string(), "SmPL".to_string()),
        ("smali".to_string(), "Smali".to_string()),
        ("smalltalk".to_string(), "Smalltalk".to_string()),
        ("squeak".to_string(), "Smalltalk".to_string()),
        ("smarty".to_string(), "Smarty".to_string()),
        ("solidity".to_string(), "Solidity".to_string()),
        ("soong".to_string(), "Soong".to_string()),
        ("sourcepawn".to_string(), "SourcePawn".to_string()),
        ("sourcemod".to_string(), "SourcePawn".to_string()),
        (
            "spline font database".to_string(),
            "Spline Font Database".to_string()
        ),
        ("squirrel".to_string(), "Squirrel".to_string()),
        ("stan".to_string(), "Stan".to_string()),
        ("standard ml".to_string(), "Standard ML".to_string()),
        ("sml".to_string(), "Standard ML".to_string()),
        ("starlark".to_string(), "Starlark".to_string()),
        ("bazel".to_string(), "Starlark".to_string()),
        ("bzl".to_string(), "Starlark".to_string()),
        ("stata".to_string(), "Stata".to_string()),
        ("stringtemplate".to_string(), "StringTemplate".to_string()),
        ("stylus".to_string(), "Stylus".to_string()),
        ("subrip text".to_string(), "SubRip Text".to_string()),
        ("sugarss".to_string(), "SugarSS".to_string()),
        ("supercollider".to_string(), "SuperCollider".to_string()),
        ("svelte".to_string(), "Svelte".to_string()),
        ("swift".to_string(), "Swift".to_string()),
        ("systemd".to_string(), "Systemd".to_string()),
        ("systemverilog".to_string(), "SystemVerilog".to_string()),
        ("ti program".to_string(), "TI Program".to_string()),
        ("tla".to_string(), "TLA".to_string()),
        ("toml".to_string(), "TOML".to_string()),
        ("tsql".to_string(), "TSQL".to_string()),
        ("tsv".to_string(), "TSV".to_string()),
        ("tsx".to_string(), "TSX".to_string()),
        ("txl".to_string(), "TXL".to_string()),
        ("tcl".to_string(), "Tcl".to_string()),
        ("tcsh".to_string(), "Tcsh".to_string()),
        ("tex".to_string(), "TeX".to_string()),
        ("latex".to_string(), "TeX".to_string()),
        ("tea".to_string(), "Tea".to_string()),
        ("terra".to_string(), "Terra".to_string()),
        ("texinfo".to_string(), "Texinfo".to_string()),
        ("text".to_string(), "Text".to_string()),
        ("fundamental".to_string(), "Text".to_string()),
        ("plain text".to_string(), "Text".to_string()),
        (
            "textmate properties".to_string(),
            "TextMate Properties".to_string()
        ),
        (
            "tm-properties".to_string(),
            "TextMate Properties".to_string()
        ),
        ("textile".to_string(), "Textile".to_string()),
        ("thrift".to_string(), "Thrift".to_string()),
        ("turing".to_string(), "Turing".to_string()),
        ("turtle".to_string(), "Turtle".to_string()),
        ("twig".to_string(), "Twig".to_string()),
        ("type language".to_string(), "Type Language".to_string()),
        ("tl".to_string(), "Type Language".to_string()),
        ("typescript".to_string(), "TypeScript".to_string()),
        ("ts".to_string(), "TypeScript".to_string()),
        (
            "unified parallel c".to_string(),
            "Unified Parallel C".to_string()
        ),
        ("unity3d asset".to_string(), "Unity3D Asset".to_string()),
        ("unix assembly".to_string(), "Unix Assembly".to_string()),
        ("uno".to_string(), "Uno".to_string()),
        ("unrealscript".to_string(), "UnrealScript".to_string()),
        ("urweb".to_string(), "UrWeb".to_string()),
        ("Ur/Web".to_string(), "UrWeb".to_string()),
        ("Ur".to_string(), "UrWeb".to_string()),
        ("v".to_string(), "V".to_string()),
        ("vlang".to_string(), "V".to_string()),
        ("vba".to_string(), "VBA".to_string()),
        ("vb6".to_string(), "VBA".to_string()),
        ("visual basic 6".to_string(), "VBA".to_string()),
        (
            "visual basic for applications".to_string(),
            "VBA".to_string()
        ),
        ("vbscript".to_string(), "VBScript".to_string()),
        ("vcl".to_string(), "VCL".to_string()),
        ("vhdl".to_string(), "VHDL".to_string()),
        ("vala".to_string(), "Vala".to_string()),
        (
            "valve data format".to_string(),
            "Valve Data Format".to_string()
        ),
        ("keyvalues".to_string(), "Valve Data Format".to_string()),
        ("vdf".to_string(), "Valve Data Format".to_string()),
        ("verilog".to_string(), "Verilog".to_string()),
        ("vim help file".to_string(), "Vim Help File".to_string()),
        ("help".to_string(), "Vim Help File".to_string()),
        ("vimhelp".to_string(), "Vim Help File".to_string()),
        ("vim script".to_string(), "Vim Script".to_string()),
        ("vim".to_string(), "Vim Script".to_string()),
        ("viml".to_string(), "Vim Script".to_string()),
        ("nvim".to_string(), "Vim Script".to_string()),
        ("vim snippet".to_string(), "Vim Snippet".to_string()),
        ("SnipMate".to_string(), "Vim Snippet".to_string()),
        ("UltiSnip".to_string(), "Vim Snippet".to_string()),
        ("UltiSnips".to_string(), "Vim Snippet".to_string()),
        ("NeoSnippet".to_string(), "Vim Snippet".to_string()),
        (
            "visual basic .net".to_string(),
            "Visual Basic .NET".to_string()
        ),
        ("visual basic".to_string(), "Visual Basic .NET".to_string()),
        ("vbnet".to_string(), "Visual Basic .NET".to_string()),
        ("vb .net".to_string(), "Visual Basic .NET".to_string()),
        ("vb.net".to_string(), "Visual Basic .NET".to_string()),
        ("volt".to_string(), "Volt".to_string()),
        ("vue".to_string(), "Vue".to_string()),
        (
            "wavefront material".to_string(),
            "Wavefront Material".to_string()
        ),
        (
            "wavefront object".to_string(),
            "Wavefront Object".to_string()
        ),
        (
            "web ontology language".to_string(),
            "Web Ontology Language".to_string()
        ),
        ("webassembly".to_string(), "WebAssembly".to_string()),
        ("wast".to_string(), "WebAssembly".to_string()),
        ("wasm".to_string(), "WebAssembly".to_string()),
        ("webidl".to_string(), "WebIDL".to_string()),
        ("webvtt".to_string(), "WebVTT".to_string()),
        ("wget config".to_string(), "Wget Config".to_string()),
        ("wgetrc".to_string(), "Wget Config".to_string()),
        ("wikitext".to_string(), "Wikitext".to_string()),
        ("mediawiki".to_string(), "Wikitext".to_string()),
        ("wiki".to_string(), "Wikitext".to_string()),
        (
            "windows registry entries".to_string(),
            "Windows Registry Entries".to_string()
        ),
        ("wollok".to_string(), "Wollok".to_string()),
        (
            "world of warcraft addon data".to_string(),
            "World of Warcraft Addon Data".to_string()
        ),
        ("x bitmap".to_string(), "X BitMap".to_string()),
        ("xbm".to_string(), "X BitMap".to_string()),
        (
            "x font directory index".to_string(),
            "X Font Directory Index".to_string()
        ),
        ("x pixmap".to_string(), "X PixMap".to_string()),
        ("xpm".to_string(), "X PixMap".to_string()),
        ("x10".to_string(), "X10".to_string()),
        ("xten".to_string(), "X10".to_string()),
        ("xc".to_string(), "XC".to_string()),
        ("xcompose".to_string(), "XCompose".to_string()),
        ("xml".to_string(), "XML".to_string()),
        ("rss".to_string(), "XML".to_string()),
        ("xsd".to_string(), "XML".to_string()),
        ("wsdl".to_string(), "XML".to_string()),
        (
            "xml property list".to_string(),
            "XML Property List".to_string()
        ),
        ("xpages".to_string(), "XPages".to_string()),
        ("xproc".to_string(), "XProc".to_string()),
        ("xquery".to_string(), "XQuery".to_string()),
        ("xs".to_string(), "XS".to_string()),
        ("xslt".to_string(), "XSLT".to_string()),
        ("xsl".to_string(), "XSLT".to_string()),
        ("xojo".to_string(), "Xojo".to_string()),
        ("xonsh".to_string(), "Xonsh".to_string()),
        ("xtend".to_string(), "Xtend".to_string()),
        ("yaml".to_string(), "YAML".to_string()),
        ("yml".to_string(), "YAML".to_string()),
        ("yang".to_string(), "YANG".to_string()),
        ("yara".to_string(), "YARA".to_string()),
        ("yasnippet".to_string(), "YASnippet".to_string()),
        ("snippet".to_string(), "YASnippet".to_string()),
        ("yas".to_string(), "YASnippet".to_string()),
        ("yacc".to_string(), "Yacc".to_string()),
        ("zap".to_string(), "ZAP".to_string()),
        ("zil".to_string(), "ZIL".to_string()),
        ("zeek".to_string(), "Zeek".to_string()),
        ("bro".to_string(), "Zeek".to_string()),
        ("zenscript".to_string(), "ZenScript".to_string()),
        ("zephir".to_string(), "Zephir".to_string()),
        ("zig".to_string(), "Zig".to_string()),
        ("zimpl".to_string(), "Zimpl".to_string()),
        ("curl config".to_string(), "cURL Config".to_string()),
        ("curlrc".to_string(), "cURL Config".to_string()),
        ("ec".to_string(), "eC".to_string()),
        ("mirc script".to_string(), "mIRC Script".to_string()),
        ("nesc".to_string(), "nesC".to_string()),
        (
            "restructuredtext".to_string(),
            "reStructuredText".to_string()
        ),
        ("rst".to_string(), "reStructuredText".to_string()),
        ("robots".to_string(), "robots.txt".to_string()),
        ("robots txt".to_string(), "robots.txt".to_string()),
        ("xbase".to_string(), "xBase".to_string()),
        ("advpl".to_string(), "xBase".to_string()),
        ("clipper".to_string(), "xBase".to_string()),
        ("foxpro".to_string(), "xBase".to_string()),
    ]
    .iter()
    .cloned()
    .collect();
}
