//
// Copyright (c) 2018-2020 Bahtiar `kalkin-` Gadimov.
//
// This file is part of file-expert
// (see https://github.com/kalkin/file-expert).
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
//
use lazy_static::lazy_static;
use std::collections::HashMap;

lazy_static! {
    pub static ref INTERPRETERS: HashMap<String, String> = [
        ("apl".to_string(), "APL".to_string()),
        ("aplx".to_string(), "APL".to_string()),
        ("dyalog".to_string(), "APL".to_string()),
        ("osascript".to_string(), "AppleScript".to_string()),
        ("asy".to_string(), "Asymptote".to_string()),
        ("awk".to_string(), "Awk".to_string()),
        ("gawk".to_string(), "Awk".to_string()),
        ("mawk".to_string(), "Awk".to_string()),
        ("nawk".to_string(), "Awk".to_string()),
        ("boogie".to_string(), "Boogie".to_string()),
        ("tcc".to_string(), "C".to_string()),
        ("coffee".to_string(), "CoffeeScript".to_string()),
        ("lisp".to_string(), "Common Lisp".to_string()),
        ("sbcl".to_string(), "Common Lisp".to_string()),
        ("ccl".to_string(), "Common Lisp".to_string()),
        ("clisp".to_string(), "Common Lisp".to_string()),
        ("ecl".to_string(), "Common Lisp".to_string()),
        (
            "cwl-runner".to_string(),
            "Common Workflow Language".to_string()
        ),
        ("crystal".to_string(), "Crystal".to_string()),
        ("dtrace".to_string(), "DTrace".to_string()),
        ("dafny".to_string(), "Dafny".to_string()),
        ("dart".to_string(), "Dart".to_string()),
        ("rune".to_string(), "E".to_string()),
        ("elixir".to_string(), "Elixir".to_string()),
        ("escript".to_string(), "Erlang".to_string()),
        ("gn".to_string(), "GN".to_string()),
        ("gerbv".to_string(), "Gerber Image".to_string()),
        ("gerbview".to_string(), "Gerber Image".to_string()),
        ("gnuplot".to_string(), "Gnuplot".to_string()),
        ("groovy".to_string(), "Groovy".to_string()),
        ("runghc".to_string(), "Haskell".to_string()),
        ("runhaskell".to_string(), "Haskell".to_string()),
        ("runhugs".to_string(), "Haskell".to_string()),
        ("hy".to_string(), "Hy".to_string()),
        ("io".to_string(), "Io".to_string()),
        ("ioke".to_string(), "Ioke".to_string()),
        ("jconsole".to_string(), "J".to_string()),
        ("chakra".to_string(), "JavaScript".to_string()),
        ("d8".to_string(), "JavaScript".to_string()),
        ("gjs".to_string(), "JavaScript".to_string()),
        ("js".to_string(), "JavaScript".to_string()),
        ("node".to_string(), "JavaScript".to_string()),
        ("nodejs".to_string(), "JavaScript".to_string()),
        ("qjs".to_string(), "JavaScript".to_string()),
        ("rhino".to_string(), "JavaScript".to_string()),
        ("v8".to_string(), "JavaScript".to_string()),
        ("v8-shell".to_string(), "JavaScript".to_string()),
        ("jolie".to_string(), "Jolie".to_string()),
        ("julia".to_string(), "Julia".to_string()),
        ("lsl".to_string(), "LSL".to_string()),
        ("lua".to_string(), "Lua".to_string()),
        ("M2".to_string(), "Macaulay2".to_string()),
        ("make".to_string(), "Makefile".to_string()),
        ("mmi".to_string(), "Mercury".to_string()),
        ("moon".to_string(), "MoonScript".to_string()),
        ("newlisp".to_string(), "NewLisp".to_string()),
        ("nextflow".to_string(), "Nextflow".to_string()),
        ("nush".to_string(), "Nu".to_string()),
        ("ocaml".to_string(), "OCaml".to_string()),
        ("ocamlrun".to_string(), "OCaml".to_string()),
        ("ocamlscript".to_string(), "OCaml".to_string()),
        ("openrc-run".to_string(), "OpenRC runscript".to_string()),
        ("php".to_string(), "PHP".to_string()),
        ("instantfpc".to_string(), "Pascal".to_string()),
        ("cperl".to_string(), "Perl".to_string()),
        ("perl".to_string(), "Perl".to_string()),
        ("picolisp".to_string(), "PicoLisp".to_string()),
        ("pil".to_string(), "PicoLisp".to_string()),
        ("pike".to_string(), "Pike".to_string()),
        ("pwsh".to_string(), "PowerShell".to_string()),
        ("swipl".to_string(), "Prolog".to_string()),
        ("yap".to_string(), "Prolog".to_string()),
        ("python".to_string(), "Python".to_string()),
        ("python2".to_string(), "Python".to_string()),
        ("python2.4".to_string(), "Python".to_string()),
        ("python2.5".to_string(), "Python".to_string()),
        ("python2.6".to_string(), "Python".to_string()),
        ("python2.7".to_string(), "Python".to_string()),
        ("python3".to_string(), "Python".to_string()),
        ("qmake".to_string(), "QMake".to_string()),
        ("Rscript".to_string(), "R".to_string()),
        ("regina".to_string(), "REXX".to_string()),
        ("rexx".to_string(), "REXX".to_string()),
        ("racket".to_string(), "Racket".to_string()),
        ("perl6".to_string(), "Raku".to_string()),
        ("raku".to_string(), "Raku".to_string()),
        ("rakudo".to_string(), "Raku".to_string()),
        ("ruby".to_string(), "Ruby".to_string()),
        ("macruby".to_string(), "Ruby".to_string()),
        ("rake".to_string(), "Ruby".to_string()),
        ("jruby".to_string(), "Ruby".to_string()),
        ("rbx".to_string(), "Ruby".to_string()),
        ("boolector".to_string(), "SMT".to_string()),
        ("cvc4".to_string(), "SMT".to_string()),
        ("mathsat5".to_string(), "SMT".to_string()),
        ("opensmt".to_string(), "SMT".to_string()),
        ("smtinterpol".to_string(), "SMT".to_string()),
        ("smt-rat".to_string(), "SMT".to_string()),
        ("stp".to_string(), "SMT".to_string()),
        ("verit".to_string(), "SMT".to_string()),
        ("yices2".to_string(), "SMT".to_string()),
        ("z3".to_string(), "SMT".to_string()),
        ("scala".to_string(), "Scala".to_string()),
        ("scheme".to_string(), "Scheme".to_string()),
        ("guile".to_string(), "Scheme".to_string()),
        ("bigloo".to_string(), "Scheme".to_string()),
        ("chicken".to_string(), "Scheme".to_string()),
        ("csi".to_string(), "Scheme".to_string()),
        ("gosh".to_string(), "Scheme".to_string()),
        ("r6rs".to_string(), "Scheme".to_string()),
        ("ash".to_string(), "Shell".to_string()),
        ("bash".to_string(), "Shell".to_string()),
        ("dash".to_string(), "Shell".to_string()),
        ("ksh".to_string(), "Shell".to_string()),
        ("mksh".to_string(), "Shell".to_string()),
        ("pdksh".to_string(), "Shell".to_string()),
        ("rc".to_string(), "Shell".to_string()),
        ("sh".to_string(), "Shell".to_string()),
        ("zsh".to_string(), "Shell".to_string()),
        ("sclang".to_string(), "SuperCollider".to_string()),
        ("scsynth".to_string(), "SuperCollider".to_string()),
        ("tclsh".to_string(), "Tcl".to_string()),
        ("wish".to_string(), "Tcl".to_string()),
        ("tcsh".to_string(), "Tcsh".to_string()),
        ("csh".to_string(), "Tcsh".to_string()),
        ("makeinfo".to_string(), "Texinfo".to_string()),
        ("deno".to_string(), "TypeScript".to_string()),
        ("ts-node".to_string(), "TypeScript".to_string()),
        ("fish".to_string(), "fish".to_string()),
        ("gsed".to_string(), "sed".to_string()),
        ("minised".to_string(), "sed".to_string()),
        ("sed".to_string(), "sed".to_string()),
        ("ssed".to_string(), "sed".to_string()),
    ]
    .iter()
    .cloned()
    .collect();
}
