/* automatically generated by rust-bindgen 0.58.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const __WORDSIZE: u32 = 64;
pub const __DARWIN_ONLY_64_BIT_INO_T: u32 = 0;
pub const __DARWIN_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const __DARWIN_ONLY_VERS_1050: u32 = 0;
pub const __DARWIN_UNIX03: u32 = 1;
pub const __DARWIN_64_BIT_INO_T: u32 = 1;
pub const __DARWIN_VERS_1050: u32 = 1;
pub const __DARWIN_NON_CANCELABLE: u32 = 0;
pub const __DARWIN_SUF_64_BIT_INO_T: &'static [u8; 9usize] = b"$INODE64\0";
pub const __DARWIN_SUF_1050: &'static [u8; 6usize] = b"$1050\0";
pub const __DARWIN_SUF_EXTSN: &'static [u8; 14usize] = b"$DARWIN_EXTSN\0";
pub const __DARWIN_C_ANSI: u32 = 4096;
pub const __DARWIN_C_FULL: u32 = 900000;
pub const __DARWIN_C_LEVEL: u32 = 900000;
pub const __STDC_WANT_LIB_EXT1__: u32 = 1;
pub const __DARWIN_NO_LONG_LONG: u32 = 0;
pub const _DARWIN_FEATURE_64_BIT_INODE: u32 = 1;
pub const _DARWIN_FEATURE_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const _DARWIN_FEATURE_UNIX_CONFORMANCE: u32 = 3;
pub const __PTHREAD_SIZE__: u32 = 8176;
pub const __PTHREAD_ATTR_SIZE__: u32 = 56;
pub const __PTHREAD_MUTEXATTR_SIZE__: u32 = 8;
pub const __PTHREAD_MUTEX_SIZE__: u32 = 56;
pub const __PTHREAD_CONDATTR_SIZE__: u32 = 8;
pub const __PTHREAD_COND_SIZE__: u32 = 40;
pub const __PTHREAD_ONCE_SIZE__: u32 = 8;
pub const __PTHREAD_RWLOCK_SIZE__: u32 = 192;
pub const __PTHREAD_RWLOCKATTR_SIZE__: u32 = 16;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const INT64_MAX: u64 = 9223372036854775807;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT64_MIN: i64 = -9223372036854775808;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const UINT64_MAX: i32 = -1;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST64_MIN: i64 = -9223372036854775808;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const INT_LEAST64_MAX: u64 = 9223372036854775807;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const UINT_LEAST64_MAX: i32 = -1;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i32 = -32768;
pub const INT_FAST32_MIN: i32 = -2147483648;
pub const INT_FAST64_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u32 = 32767;
pub const INT_FAST32_MAX: u32 = 2147483647;
pub const INT_FAST64_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: u32 = 65535;
pub const UINT_FAST32_MAX: u32 = 4294967295;
pub const UINT_FAST64_MAX: i32 = -1;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const UINTPTR_MAX: i32 = -1;
pub const SIZE_MAX: i32 = -1;
pub const RSIZE_MAX: i32 = -1;
pub const WINT_MIN: i32 = -2147483648;
pub const WINT_MAX: u32 = 2147483647;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const __DARWIN_WCHAR_MIN: i32 = -2147483648;
pub const _FORTIFY_SOURCE: u32 = 2;
pub const __API_TO_BE_DEPRECATED: u32 = 100000;
pub const __MAC_10_0: u32 = 1000;
pub const __MAC_10_1: u32 = 1010;
pub const __MAC_10_2: u32 = 1020;
pub const __MAC_10_3: u32 = 1030;
pub const __MAC_10_4: u32 = 1040;
pub const __MAC_10_5: u32 = 1050;
pub const __MAC_10_6: u32 = 1060;
pub const __MAC_10_7: u32 = 1070;
pub const __MAC_10_8: u32 = 1080;
pub const __MAC_10_9: u32 = 1090;
pub const __MAC_10_10: u32 = 101000;
pub const __MAC_10_10_2: u32 = 101002;
pub const __MAC_10_10_3: u32 = 101003;
pub const __MAC_10_11: u32 = 101100;
pub const __MAC_10_11_2: u32 = 101102;
pub const __MAC_10_11_3: u32 = 101103;
pub const __MAC_10_11_4: u32 = 101104;
pub const __MAC_10_12: u32 = 101200;
pub const __MAC_10_12_1: u32 = 101201;
pub const __MAC_10_12_2: u32 = 101202;
pub const __MAC_10_12_4: u32 = 101204;
pub const __MAC_10_13: u32 = 101300;
pub const __MAC_10_13_1: u32 = 101301;
pub const __MAC_10_13_2: u32 = 101302;
pub const __MAC_10_13_4: u32 = 101304;
pub const __MAC_10_14: u32 = 101400;
pub const __MAC_10_14_1: u32 = 101401;
pub const __MAC_10_14_4: u32 = 101404;
pub const __MAC_10_14_6: u32 = 101406;
pub const __MAC_10_15: u32 = 101500;
pub const __MAC_10_15_1: u32 = 101501;
pub const __MAC_10_15_4: u32 = 101504;
pub const __MAC_10_16: u32 = 101600;
pub const __MAC_11_0: u32 = 110000;
pub const __MAC_11_1: u32 = 110100;
pub const __MAC_11_3: u32 = 110300;
pub const __IPHONE_2_0: u32 = 20000;
pub const __IPHONE_2_1: u32 = 20100;
pub const __IPHONE_2_2: u32 = 20200;
pub const __IPHONE_3_0: u32 = 30000;
pub const __IPHONE_3_1: u32 = 30100;
pub const __IPHONE_3_2: u32 = 30200;
pub const __IPHONE_4_0: u32 = 40000;
pub const __IPHONE_4_1: u32 = 40100;
pub const __IPHONE_4_2: u32 = 40200;
pub const __IPHONE_4_3: u32 = 40300;
pub const __IPHONE_5_0: u32 = 50000;
pub const __IPHONE_5_1: u32 = 50100;
pub const __IPHONE_6_0: u32 = 60000;
pub const __IPHONE_6_1: u32 = 60100;
pub const __IPHONE_7_0: u32 = 70000;
pub const __IPHONE_7_1: u32 = 70100;
pub const __IPHONE_8_0: u32 = 80000;
pub const __IPHONE_8_1: u32 = 80100;
pub const __IPHONE_8_2: u32 = 80200;
pub const __IPHONE_8_3: u32 = 80300;
pub const __IPHONE_8_4: u32 = 80400;
pub const __IPHONE_9_0: u32 = 90000;
pub const __IPHONE_9_1: u32 = 90100;
pub const __IPHONE_9_2: u32 = 90200;
pub const __IPHONE_9_3: u32 = 90300;
pub const __IPHONE_10_0: u32 = 100000;
pub const __IPHONE_10_1: u32 = 100100;
pub const __IPHONE_10_2: u32 = 100200;
pub const __IPHONE_10_3: u32 = 100300;
pub const __IPHONE_11_0: u32 = 110000;
pub const __IPHONE_11_1: u32 = 110100;
pub const __IPHONE_11_2: u32 = 110200;
pub const __IPHONE_11_3: u32 = 110300;
pub const __IPHONE_11_4: u32 = 110400;
pub const __IPHONE_12_0: u32 = 120000;
pub const __IPHONE_12_1: u32 = 120100;
pub const __IPHONE_12_2: u32 = 120200;
pub const __IPHONE_12_3: u32 = 120300;
pub const __IPHONE_12_4: u32 = 120400;
pub const __IPHONE_13_0: u32 = 130000;
pub const __IPHONE_13_1: u32 = 130100;
pub const __IPHONE_13_2: u32 = 130200;
pub const __IPHONE_13_3: u32 = 130300;
pub const __IPHONE_13_4: u32 = 130400;
pub const __IPHONE_13_5: u32 = 130500;
pub const __IPHONE_13_6: u32 = 130600;
pub const __IPHONE_13_7: u32 = 130700;
pub const __IPHONE_14_0: u32 = 140000;
pub const __IPHONE_14_1: u32 = 140100;
pub const __IPHONE_14_2: u32 = 140200;
pub const __IPHONE_14_3: u32 = 140300;
pub const __IPHONE_14_5: u32 = 140500;
pub const __TVOS_9_0: u32 = 90000;
pub const __TVOS_9_1: u32 = 90100;
pub const __TVOS_9_2: u32 = 90200;
pub const __TVOS_10_0: u32 = 100000;
pub const __TVOS_10_0_1: u32 = 100001;
pub const __TVOS_10_1: u32 = 100100;
pub const __TVOS_10_2: u32 = 100200;
pub const __TVOS_11_0: u32 = 110000;
pub const __TVOS_11_1: u32 = 110100;
pub const __TVOS_11_2: u32 = 110200;
pub const __TVOS_11_3: u32 = 110300;
pub const __TVOS_11_4: u32 = 110400;
pub const __TVOS_12_0: u32 = 120000;
pub const __TVOS_12_1: u32 = 120100;
pub const __TVOS_12_2: u32 = 120200;
pub const __TVOS_12_3: u32 = 120300;
pub const __TVOS_12_4: u32 = 120400;
pub const __TVOS_13_0: u32 = 130000;
pub const __TVOS_13_2: u32 = 130200;
pub const __TVOS_13_3: u32 = 130300;
pub const __TVOS_13_4: u32 = 130400;
pub const __TVOS_14_0: u32 = 140000;
pub const __TVOS_14_1: u32 = 140100;
pub const __TVOS_14_2: u32 = 140200;
pub const __TVOS_14_3: u32 = 140300;
pub const __TVOS_14_5: u32 = 140500;
pub const __WATCHOS_1_0: u32 = 10000;
pub const __WATCHOS_2_0: u32 = 20000;
pub const __WATCHOS_2_1: u32 = 20100;
pub const __WATCHOS_2_2: u32 = 20200;
pub const __WATCHOS_3_0: u32 = 30000;
pub const __WATCHOS_3_1: u32 = 30100;
pub const __WATCHOS_3_1_1: u32 = 30101;
pub const __WATCHOS_3_2: u32 = 30200;
pub const __WATCHOS_4_0: u32 = 40000;
pub const __WATCHOS_4_1: u32 = 40100;
pub const __WATCHOS_4_2: u32 = 40200;
pub const __WATCHOS_4_3: u32 = 40300;
pub const __WATCHOS_5_0: u32 = 50000;
pub const __WATCHOS_5_1: u32 = 50100;
pub const __WATCHOS_5_2: u32 = 50200;
pub const __WATCHOS_5_3: u32 = 50300;
pub const __WATCHOS_6_0: u32 = 60000;
pub const __WATCHOS_6_1: u32 = 60100;
pub const __WATCHOS_6_2: u32 = 60200;
pub const __WATCHOS_7_0: u32 = 70000;
pub const __WATCHOS_7_1: u32 = 70100;
pub const __WATCHOS_7_2: u32 = 70200;
pub const __WATCHOS_7_3: u32 = 70300;
pub const __WATCHOS_7_4: u32 = 70400;
pub const MAC_OS_X_VERSION_10_0: u32 = 1000;
pub const MAC_OS_X_VERSION_10_1: u32 = 1010;
pub const MAC_OS_X_VERSION_10_2: u32 = 1020;
pub const MAC_OS_X_VERSION_10_3: u32 = 1030;
pub const MAC_OS_X_VERSION_10_4: u32 = 1040;
pub const MAC_OS_X_VERSION_10_5: u32 = 1050;
pub const MAC_OS_X_VERSION_10_6: u32 = 1060;
pub const MAC_OS_X_VERSION_10_7: u32 = 1070;
pub const MAC_OS_X_VERSION_10_8: u32 = 1080;
pub const MAC_OS_X_VERSION_10_9: u32 = 1090;
pub const MAC_OS_X_VERSION_10_10: u32 = 101000;
pub const MAC_OS_X_VERSION_10_10_2: u32 = 101002;
pub const MAC_OS_X_VERSION_10_10_3: u32 = 101003;
pub const MAC_OS_X_VERSION_10_11: u32 = 101100;
pub const MAC_OS_X_VERSION_10_11_2: u32 = 101102;
pub const MAC_OS_X_VERSION_10_11_3: u32 = 101103;
pub const MAC_OS_X_VERSION_10_11_4: u32 = 101104;
pub const MAC_OS_X_VERSION_10_12: u32 = 101200;
pub const MAC_OS_X_VERSION_10_12_1: u32 = 101201;
pub const MAC_OS_X_VERSION_10_12_2: u32 = 101202;
pub const MAC_OS_X_VERSION_10_12_4: u32 = 101204;
pub const MAC_OS_X_VERSION_10_13: u32 = 101300;
pub const MAC_OS_X_VERSION_10_13_1: u32 = 101301;
pub const MAC_OS_X_VERSION_10_13_2: u32 = 101302;
pub const MAC_OS_X_VERSION_10_13_4: u32 = 101304;
pub const MAC_OS_X_VERSION_10_14: u32 = 101400;
pub const MAC_OS_X_VERSION_10_14_1: u32 = 101401;
pub const MAC_OS_X_VERSION_10_14_4: u32 = 101404;
pub const MAC_OS_X_VERSION_10_14_6: u32 = 101406;
pub const MAC_OS_X_VERSION_10_15: u32 = 101500;
pub const MAC_OS_X_VERSION_10_15_1: u32 = 101501;
pub const MAC_OS_X_VERSION_10_16: u32 = 101600;
pub const MAC_OS_VERSION_11_0: u32 = 110000;
pub const __DRIVERKIT_19_0: u32 = 190000;
pub const __DRIVERKIT_20_0: u32 = 200000;
pub const __MAC_OS_X_VERSION_MAX_ALLOWED: u32 = 110300;
pub const __ENABLE_LEGACY_MAC_AVAILABILITY: u32 = 1;
pub const _USE_FORTIFY_LEVEL: u32 = 2;
pub const __HAS_FIXED_CHK_PROTOTYPES: u32 = 1;
pub const RENAME_SECLUDE: u32 = 1;
pub const RENAME_SWAP: u32 = 2;
pub const RENAME_EXCL: u32 = 4;
pub const __SLBF: u32 = 1;
pub const __SNBF: u32 = 2;
pub const __SRD: u32 = 4;
pub const __SWR: u32 = 8;
pub const __SRW: u32 = 16;
pub const __SEOF: u32 = 32;
pub const __SERR: u32 = 64;
pub const __SMBF: u32 = 128;
pub const __SAPP: u32 = 256;
pub const __SSTR: u32 = 512;
pub const __SOPT: u32 = 1024;
pub const __SNPT: u32 = 2048;
pub const __SOFF: u32 = 4096;
pub const __SMOD: u32 = 8192;
pub const __SALC: u32 = 16384;
pub const __SIGN: u32 = 32768;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 1024;
pub const EOF: i32 = -1;
pub const FOPEN_MAX: u32 = 20;
pub const FILENAME_MAX: u32 = 1024;
pub const P_tmpdir: &'static [u8; 10usize] = b"/var/tmp/\0";
pub const L_tmpnam: u32 = 1024;
pub const TMP_MAX: u32 = 308915776;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const L_ctermid: u32 = 1024;
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const __bool_true_false_are_defined: u32 = 1;
pub const __DARWIN_NSIG: u32 = 32;
pub const NSIG: u32 = 32;
pub const _I386_SIGNAL_H_: u32 = 1;
pub const SIGHUP: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGQUIT: u32 = 3;
pub const SIGILL: u32 = 4;
pub const SIGTRAP: u32 = 5;
pub const SIGABRT: u32 = 6;
pub const SIGIOT: u32 = 6;
pub const SIGEMT: u32 = 7;
pub const SIGFPE: u32 = 8;
pub const SIGKILL: u32 = 9;
pub const SIGBUS: u32 = 10;
pub const SIGSEGV: u32 = 11;
pub const SIGSYS: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGTERM: u32 = 15;
pub const SIGURG: u32 = 16;
pub const SIGSTOP: u32 = 17;
pub const SIGTSTP: u32 = 18;
pub const SIGCONT: u32 = 19;
pub const SIGCHLD: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGIO: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGWINCH: u32 = 28;
pub const SIGINFO: u32 = 29;
pub const SIGUSR1: u32 = 30;
pub const SIGUSR2: u32 = 31;
pub const FP_PREC_24B: u32 = 0;
pub const FP_PREC_53B: u32 = 2;
pub const FP_PREC_64B: u32 = 3;
pub const FP_RND_NEAR: u32 = 0;
pub const FP_RND_DOWN: u32 = 1;
pub const FP_RND_UP: u32 = 2;
pub const FP_CHOP: u32 = 3;
pub const FP_STATE_BYTES: u32 = 512;
pub const _X86_INSTRUCTION_STATE_MAX_INSN_BYTES: u32 = 2380;
pub const _X86_INSTRUCTION_STATE_CACHELINE_SIZE: u32 = 64;
pub const __LASTBRANCH_MAX: u32 = 32;
pub const SIGEV_NONE: u32 = 0;
pub const SIGEV_SIGNAL: u32 = 1;
pub const SIGEV_THREAD: u32 = 3;
pub const ILL_NOOP: u32 = 0;
pub const ILL_ILLOPC: u32 = 1;
pub const ILL_ILLTRP: u32 = 2;
pub const ILL_PRVOPC: u32 = 3;
pub const ILL_ILLOPN: u32 = 4;
pub const ILL_ILLADR: u32 = 5;
pub const ILL_PRVREG: u32 = 6;
pub const ILL_COPROC: u32 = 7;
pub const ILL_BADSTK: u32 = 8;
pub const FPE_NOOP: u32 = 0;
pub const FPE_FLTDIV: u32 = 1;
pub const FPE_FLTOVF: u32 = 2;
pub const FPE_FLTUND: u32 = 3;
pub const FPE_FLTRES: u32 = 4;
pub const FPE_FLTINV: u32 = 5;
pub const FPE_FLTSUB: u32 = 6;
pub const FPE_INTDIV: u32 = 7;
pub const FPE_INTOVF: u32 = 8;
pub const SEGV_NOOP: u32 = 0;
pub const SEGV_MAPERR: u32 = 1;
pub const SEGV_ACCERR: u32 = 2;
pub const BUS_NOOP: u32 = 0;
pub const BUS_ADRALN: u32 = 1;
pub const BUS_ADRERR: u32 = 2;
pub const BUS_OBJERR: u32 = 3;
pub const TRAP_BRKPT: u32 = 1;
pub const TRAP_TRACE: u32 = 2;
pub const CLD_NOOP: u32 = 0;
pub const CLD_EXITED: u32 = 1;
pub const CLD_KILLED: u32 = 2;
pub const CLD_DUMPED: u32 = 3;
pub const CLD_TRAPPED: u32 = 4;
pub const CLD_STOPPED: u32 = 5;
pub const CLD_CONTINUED: u32 = 6;
pub const POLL_IN: u32 = 1;
pub const POLL_OUT: u32 = 2;
pub const POLL_MSG: u32 = 3;
pub const POLL_ERR: u32 = 4;
pub const POLL_PRI: u32 = 5;
pub const POLL_HUP: u32 = 6;
pub const SA_ONSTACK: u32 = 1;
pub const SA_RESTART: u32 = 2;
pub const SA_RESETHAND: u32 = 4;
pub const SA_NOCLDSTOP: u32 = 8;
pub const SA_NODEFER: u32 = 16;
pub const SA_NOCLDWAIT: u32 = 32;
pub const SA_SIGINFO: u32 = 64;
pub const SA_USERTRAMP: u32 = 256;
pub const SA_64REGSET: u32 = 512;
pub const SA_USERSPACE_MASK: u32 = 127;
pub const SIG_BLOCK: u32 = 1;
pub const SIG_UNBLOCK: u32 = 2;
pub const SIG_SETMASK: u32 = 3;
pub const SI_USER: u32 = 65537;
pub const SI_QUEUE: u32 = 65538;
pub const SI_TIMER: u32 = 65539;
pub const SI_ASYNCIO: u32 = 65540;
pub const SI_MESGQ: u32 = 65541;
pub const SS_ONSTACK: u32 = 1;
pub const SS_DISABLE: u32 = 4;
pub const MINSIGSTKSZ: u32 = 32768;
pub const SIGSTKSZ: u32 = 131072;
pub const SV_ONSTACK: u32 = 1;
pub const SV_INTERRUPT: u32 = 2;
pub const SV_RESETHAND: u32 = 4;
pub const SV_NODEFER: u32 = 16;
pub const SV_NOCLDSTOP: u32 = 8;
pub const SV_SIGINFO: u32 = 64;
pub const PRIO_PROCESS: u32 = 0;
pub const PRIO_PGRP: u32 = 1;
pub const PRIO_USER: u32 = 2;
pub const PRIO_DARWIN_THREAD: u32 = 3;
pub const PRIO_DARWIN_PROCESS: u32 = 4;
pub const PRIO_MIN: i32 = -20;
pub const PRIO_MAX: u32 = 20;
pub const PRIO_DARWIN_BG: u32 = 4096;
pub const PRIO_DARWIN_NONUI: u32 = 4097;
pub const RUSAGE_SELF: u32 = 0;
pub const RUSAGE_CHILDREN: i32 = -1;
pub const RUSAGE_INFO_V0: u32 = 0;
pub const RUSAGE_INFO_V1: u32 = 1;
pub const RUSAGE_INFO_V2: u32 = 2;
pub const RUSAGE_INFO_V3: u32 = 3;
pub const RUSAGE_INFO_V4: u32 = 4;
pub const RUSAGE_INFO_V5: u32 = 5;
pub const RUSAGE_INFO_CURRENT: u32 = 5;
pub const RU_PROC_RUNS_RESLIDE: u32 = 1;
pub const RLIMIT_CPU: u32 = 0;
pub const RLIMIT_FSIZE: u32 = 1;
pub const RLIMIT_DATA: u32 = 2;
pub const RLIMIT_STACK: u32 = 3;
pub const RLIMIT_CORE: u32 = 4;
pub const RLIMIT_AS: u32 = 5;
pub const RLIMIT_RSS: u32 = 5;
pub const RLIMIT_MEMLOCK: u32 = 6;
pub const RLIMIT_NPROC: u32 = 7;
pub const RLIMIT_NOFILE: u32 = 8;
pub const RLIM_NLIMITS: u32 = 9;
pub const _RLIMIT_POSIX_FLAG: u32 = 4096;
pub const RLIMIT_WAKEUPS_MONITOR: u32 = 1;
pub const RLIMIT_CPU_USAGE_MONITOR: u32 = 2;
pub const RLIMIT_THREAD_CPULIMITS: u32 = 3;
pub const RLIMIT_FOOTPRINT_INTERVAL: u32 = 4;
pub const WAKEMON_ENABLE: u32 = 1;
pub const WAKEMON_DISABLE: u32 = 2;
pub const WAKEMON_GET_PARAMS: u32 = 4;
pub const WAKEMON_SET_DEFAULTS: u32 = 8;
pub const WAKEMON_MAKE_FATAL: u32 = 16;
pub const CPUMON_MAKE_FATAL: u32 = 4096;
pub const FOOTPRINT_INTERVAL_RESET: u32 = 1;
pub const IOPOL_TYPE_DISK: u32 = 0;
pub const IOPOL_TYPE_VFS_ATIME_UPDATES: u32 = 2;
pub const IOPOL_TYPE_VFS_MATERIALIZE_DATALESS_FILES: u32 = 3;
pub const IOPOL_TYPE_VFS_STATFS_NO_DATA_VOLUME: u32 = 4;
pub const IOPOL_TYPE_VFS_TRIGGER_RESOLVE: u32 = 5;
pub const IOPOL_TYPE_VFS_IGNORE_CONTENT_PROTECTION: u32 = 6;
pub const IOPOL_TYPE_VFS_IGNORE_PERMISSIONS: u32 = 7;
pub const IOPOL_TYPE_VFS_SKIP_MTIME_UPDATE: u32 = 8;
pub const IOPOL_SCOPE_PROCESS: u32 = 0;
pub const IOPOL_SCOPE_THREAD: u32 = 1;
pub const IOPOL_SCOPE_DARWIN_BG: u32 = 2;
pub const IOPOL_DEFAULT: u32 = 0;
pub const IOPOL_IMPORTANT: u32 = 1;
pub const IOPOL_PASSIVE: u32 = 2;
pub const IOPOL_THROTTLE: u32 = 3;
pub const IOPOL_UTILITY: u32 = 4;
pub const IOPOL_STANDARD: u32 = 5;
pub const IOPOL_APPLICATION: u32 = 5;
pub const IOPOL_NORMAL: u32 = 1;
pub const IOPOL_ATIME_UPDATES_DEFAULT: u32 = 0;
pub const IOPOL_ATIME_UPDATES_OFF: u32 = 1;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_DEFAULT: u32 = 0;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_OFF: u32 = 1;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_ON: u32 = 2;
pub const IOPOL_VFS_STATFS_NO_DATA_VOLUME_DEFAULT: u32 = 0;
pub const IOPOL_VFS_STATFS_FORCE_NO_DATA_VOLUME: u32 = 1;
pub const IOPOL_VFS_TRIGGER_RESOLVE_DEFAULT: u32 = 0;
pub const IOPOL_VFS_TRIGGER_RESOLVE_OFF: u32 = 1;
pub const IOPOL_VFS_CONTENT_PROTECTION_DEFAULT: u32 = 0;
pub const IOPOL_VFS_CONTENT_PROTECTION_IGNORE: u32 = 1;
pub const IOPOL_VFS_IGNORE_PERMISSIONS_OFF: u32 = 0;
pub const IOPOL_VFS_IGNORE_PERMISSIONS_ON: u32 = 1;
pub const IOPOL_VFS_SKIP_MTIME_UPDATE_OFF: u32 = 0;
pub const IOPOL_VFS_SKIP_MTIME_UPDATE_ON: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WCOREFLAG: u32 = 128;
pub const _WSTOPPED: u32 = 127;
pub const WEXITED: u32 = 4;
pub const WSTOPPED: u32 = 8;
pub const WCONTINUED: u32 = 16;
pub const WNOWAIT: u32 = 32;
pub const WAIT_ANY: i32 = -1;
pub const WAIT_MYPGRP: u32 = 0;
pub const _QUAD_HIGHWORD: u32 = 1;
pub const _QUAD_LOWWORD: u32 = 0;
pub const __DARWIN_LITTLE_ENDIAN: u32 = 1234;
pub const __DARWIN_BIG_ENDIAN: u32 = 4321;
pub const __DARWIN_PDP_ENDIAN: u32 = 3412;
pub const __DARWIN_BYTE_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const RAND_MAX: u32 = 2147483647;
pub const _PTHREAD_MUTEX_SIG_init: u32 = 850045863;
pub const _PTHREAD_ERRORCHECK_MUTEX_SIG_init: u32 = 850045857;
pub const _PTHREAD_RECURSIVE_MUTEX_SIG_init: u32 = 850045858;
pub const _PTHREAD_FIRSTFIT_MUTEX_SIG_init: u32 = 850045859;
pub const _PTHREAD_COND_SIG_init: u32 = 1018212795;
pub const _PTHREAD_ONCE_SIG_init: u32 = 816954554;
pub const _PTHREAD_RWLOCK_SIG_init: u32 = 766030772;
pub const SCHED_OTHER: u32 = 1;
pub const SCHED_FIFO: u32 = 4;
pub const SCHED_RR: u32 = 2;
pub const __SCHED_PARAM_SIZE__: u32 = 4;
pub const CLOCKS_PER_SEC: u32 = 1000000;
pub const TIME_UTC: u32 = 1;
pub const QOS_MIN_RELATIVE_PRIORITY: i32 = -15;
pub const PTHREAD_CREATE_JOINABLE: u32 = 1;
pub const PTHREAD_CREATE_DETACHED: u32 = 2;
pub const PTHREAD_INHERIT_SCHED: u32 = 1;
pub const PTHREAD_EXPLICIT_SCHED: u32 = 2;
pub const PTHREAD_CANCEL_ENABLE: u32 = 1;
pub const PTHREAD_CANCEL_DISABLE: u32 = 0;
pub const PTHREAD_CANCEL_DEFERRED: u32 = 2;
pub const PTHREAD_CANCEL_ASYNCHRONOUS: u32 = 0;
pub const PTHREAD_SCOPE_SYSTEM: u32 = 1;
pub const PTHREAD_SCOPE_PROCESS: u32 = 2;
pub const PTHREAD_PROCESS_SHARED: u32 = 1;
pub const PTHREAD_PROCESS_PRIVATE: u32 = 2;
pub const PTHREAD_PRIO_NONE: u32 = 0;
pub const PTHREAD_PRIO_INHERIT: u32 = 1;
pub const PTHREAD_PRIO_PROTECT: u32 = 2;
pub const PTHREAD_MUTEX_NORMAL: u32 = 0;
pub const PTHREAD_MUTEX_ERRORCHECK: u32 = 1;
pub const PTHREAD_MUTEX_RECURSIVE: u32 = 2;
pub const PTHREAD_MUTEX_DEFAULT: u32 = 0;
pub const PTHREAD_MUTEX_POLICY_FAIRSHARE_NP: u32 = 1;
pub const PTHREAD_MUTEX_POLICY_FIRSTFIT_NP: u32 = 3;
pub const __DARWIN_CLK_TCK: u32 = 100;
pub const CHAR_BIT: u32 = 8;
pub const MB_LEN_MAX: u32 = 6;
pub const CLK_TCK: u32 = 100;
pub const SCHAR_MAX: u32 = 127;
pub const SCHAR_MIN: i32 = -128;
pub const UCHAR_MAX: u32 = 255;
pub const CHAR_MAX: u32 = 127;
pub const CHAR_MIN: i32 = -128;
pub const USHRT_MAX: u32 = 65535;
pub const SHRT_MAX: u32 = 32767;
pub const SHRT_MIN: i32 = -32768;
pub const UINT_MAX: u32 = 4294967295;
pub const INT_MAX: u32 = 2147483647;
pub const INT_MIN: i32 = -2147483648;
pub const ULONG_MAX: i32 = -1;
pub const LONG_MAX: u64 = 9223372036854775807;
pub const LONG_MIN: i64 = -9223372036854775808;
pub const ULLONG_MAX: i32 = -1;
pub const LLONG_MAX: u64 = 9223372036854775807;
pub const LLONG_MIN: i64 = -9223372036854775808;
pub const LONG_BIT: u32 = 64;
pub const SSIZE_MAX: u64 = 9223372036854775807;
pub const WORD_BIT: u32 = 32;
pub const SIZE_T_MAX: i32 = -1;
pub const UQUAD_MAX: i32 = -1;
pub const QUAD_MAX: u64 = 9223372036854775807;
pub const QUAD_MIN: i64 = -9223372036854775808;
pub const ARG_MAX: u32 = 1048576;
pub const CHILD_MAX: u32 = 266;
pub const GID_MAX: u32 = 2147483647;
pub const LINK_MAX: u32 = 32767;
pub const MAX_CANON: u32 = 1024;
pub const MAX_INPUT: u32 = 1024;
pub const NAME_MAX: u32 = 255;
pub const NGROUPS_MAX: u32 = 16;
pub const UID_MAX: u32 = 2147483647;
pub const OPEN_MAX: u32 = 10240;
pub const PATH_MAX: u32 = 1024;
pub const PIPE_BUF: u32 = 512;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const CHARCLASS_NAME_MAX: u32 = 14;
pub const COLL_WEIGHTS_MAX: u32 = 2;
pub const EQUIV_CLASS_MAX: u32 = 2;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 255;
pub const NZERO: u32 = 20;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_EQUIV_CLASS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_KEYS_MAX: u32 = 512;
pub const PTHREAD_STACK_MIN: u32 = 8192;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_SS_REPL_MAX: u32 = 4;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_TRACE_EVENT_NAME_MAX: u32 = 30;
pub const _POSIX_TRACE_NAME_MAX: u32 = 8;
pub const _POSIX_TRACE_SYS_MAX: u32 = 8;
pub const _POSIX_TRACE_USER_EVENT_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const OFF_MIN: i64 = -9223372036854775808;
pub const OFF_MAX: u64 = 9223372036854775807;
pub const PASS_MAX: u32 = 128;
pub const NL_ARGMAX: u32 = 9;
pub const NL_LANGMAX: u32 = 14;
pub const NL_MSGMAX: u32 = 32767;
pub const NL_NMAX: u32 = 1;
pub const NL_SETMAX: u32 = 255;
pub const NL_TEXTMAX: u32 = 2048;
pub const _XOPEN_IOV_MAX: u32 = 16;
pub const IOV_MAX: u32 = 1024;
pub const _XOPEN_NAME_MAX: u32 = 255;
pub const _XOPEN_PATH_MAX: u32 = 1024;
pub const EPERM: u32 = 1;
pub const ENOENT: u32 = 2;
pub const ESRCH: u32 = 3;
pub const EINTR: u32 = 4;
pub const EIO: u32 = 5;
pub const ENXIO: u32 = 6;
pub const E2BIG: u32 = 7;
pub const ENOEXEC: u32 = 8;
pub const EBADF: u32 = 9;
pub const ECHILD: u32 = 10;
pub const EDEADLK: u32 = 11;
pub const ENOMEM: u32 = 12;
pub const EACCES: u32 = 13;
pub const EFAULT: u32 = 14;
pub const ENOTBLK: u32 = 15;
pub const EBUSY: u32 = 16;
pub const EEXIST: u32 = 17;
pub const EXDEV: u32 = 18;
pub const ENODEV: u32 = 19;
pub const ENOTDIR: u32 = 20;
pub const EISDIR: u32 = 21;
pub const EINVAL: u32 = 22;
pub const ENFILE: u32 = 23;
pub const EMFILE: u32 = 24;
pub const ENOTTY: u32 = 25;
pub const ETXTBSY: u32 = 26;
pub const EFBIG: u32 = 27;
pub const ENOSPC: u32 = 28;
pub const ESPIPE: u32 = 29;
pub const EROFS: u32 = 30;
pub const EMLINK: u32 = 31;
pub const EPIPE: u32 = 32;
pub const EDOM: u32 = 33;
pub const ERANGE: u32 = 34;
pub const EAGAIN: u32 = 35;
pub const EWOULDBLOCK: u32 = 35;
pub const EINPROGRESS: u32 = 36;
pub const EALREADY: u32 = 37;
pub const ENOTSOCK: u32 = 38;
pub const EDESTADDRREQ: u32 = 39;
pub const EMSGSIZE: u32 = 40;
pub const EPROTOTYPE: u32 = 41;
pub const ENOPROTOOPT: u32 = 42;
pub const EPROTONOSUPPORT: u32 = 43;
pub const ESOCKTNOSUPPORT: u32 = 44;
pub const ENOTSUP: u32 = 45;
pub const EPFNOSUPPORT: u32 = 46;
pub const EAFNOSUPPORT: u32 = 47;
pub const EADDRINUSE: u32 = 48;
pub const EADDRNOTAVAIL: u32 = 49;
pub const ENETDOWN: u32 = 50;
pub const ENETUNREACH: u32 = 51;
pub const ENETRESET: u32 = 52;
pub const ECONNABORTED: u32 = 53;
pub const ECONNRESET: u32 = 54;
pub const ENOBUFS: u32 = 55;
pub const EISCONN: u32 = 56;
pub const ENOTCONN: u32 = 57;
pub const ESHUTDOWN: u32 = 58;
pub const ETOOMANYREFS: u32 = 59;
pub const ETIMEDOUT: u32 = 60;
pub const ECONNREFUSED: u32 = 61;
pub const ELOOP: u32 = 62;
pub const ENAMETOOLONG: u32 = 63;
pub const EHOSTDOWN: u32 = 64;
pub const EHOSTUNREACH: u32 = 65;
pub const ENOTEMPTY: u32 = 66;
pub const EPROCLIM: u32 = 67;
pub const EUSERS: u32 = 68;
pub const EDQUOT: u32 = 69;
pub const ESTALE: u32 = 70;
pub const EREMOTE: u32 = 71;
pub const EBADRPC: u32 = 72;
pub const ERPCMISMATCH: u32 = 73;
pub const EPROGUNAVAIL: u32 = 74;
pub const EPROGMISMATCH: u32 = 75;
pub const EPROCUNAVAIL: u32 = 76;
pub const ENOLCK: u32 = 77;
pub const ENOSYS: u32 = 78;
pub const EFTYPE: u32 = 79;
pub const EAUTH: u32 = 80;
pub const ENEEDAUTH: u32 = 81;
pub const EPWROFF: u32 = 82;
pub const EDEVERR: u32 = 83;
pub const EOVERFLOW: u32 = 84;
pub const EBADEXEC: u32 = 85;
pub const EBADARCH: u32 = 86;
pub const ESHLIBVERS: u32 = 87;
pub const EBADMACHO: u32 = 88;
pub const ECANCELED: u32 = 89;
pub const EIDRM: u32 = 90;
pub const ENOMSG: u32 = 91;
pub const EILSEQ: u32 = 92;
pub const ENOATTR: u32 = 93;
pub const EBADMSG: u32 = 94;
pub const EMULTIHOP: u32 = 95;
pub const ENODATA: u32 = 96;
pub const ENOLINK: u32 = 97;
pub const ENOSR: u32 = 98;
pub const ENOSTR: u32 = 99;
pub const EPROTO: u32 = 100;
pub const ETIME: u32 = 101;
pub const EOPNOTSUPP: u32 = 102;
pub const ENOPOLICY: u32 = 103;
pub const ENOTRECOVERABLE: u32 = 104;
pub const EOWNERDEAD: u32 = 105;
pub const EQFULL: u32 = 106;
pub const ELAST: u32 = 106;
pub const __DARWIN_MAXNAMLEN: u32 = 255;
pub const __DARWIN_MAXPATHLEN: u32 = 1024;
pub const MAXNAMLEN: u32 = 255;
pub const DT_UNKNOWN: u32 = 0;
pub const DT_FIFO: u32 = 1;
pub const DT_CHR: u32 = 2;
pub const DT_DIR: u32 = 4;
pub const DT_BLK: u32 = 6;
pub const DT_REG: u32 = 8;
pub const DT_LNK: u32 = 10;
pub const DT_SOCK: u32 = 12;
pub const DT_WHT: u32 = 14;
pub const DIRBLKSIZ: u32 = 1024;
pub const DTF_HIDEW: u32 = 1;
pub const DTF_NODUP: u32 = 2;
pub const DTF_REWIND: u32 = 4;
pub const __DTF_READALL: u32 = 8;
pub const __DTF_SKIPREAD: u32 = 16;
pub const __DTF_ATEND: u32 = 32;
pub const S_IFMT: u32 = 61440;
pub const S_IFIFO: u32 = 4096;
pub const S_IFCHR: u32 = 8192;
pub const S_IFDIR: u32 = 16384;
pub const S_IFBLK: u32 = 24576;
pub const S_IFREG: u32 = 32768;
pub const S_IFLNK: u32 = 40960;
pub const S_IFSOCK: u32 = 49152;
pub const S_IFWHT: u32 = 57344;
pub const S_IRWXU: u32 = 448;
pub const S_IRUSR: u32 = 256;
pub const S_IWUSR: u32 = 128;
pub const S_IXUSR: u32 = 64;
pub const S_IRWXG: u32 = 56;
pub const S_IRGRP: u32 = 32;
pub const S_IWGRP: u32 = 16;
pub const S_IXGRP: u32 = 8;
pub const S_IRWXO: u32 = 7;
pub const S_IROTH: u32 = 4;
pub const S_IWOTH: u32 = 2;
pub const S_IXOTH: u32 = 1;
pub const S_ISUID: u32 = 2048;
pub const S_ISGID: u32 = 1024;
pub const S_ISVTX: u32 = 512;
pub const S_ISTXT: u32 = 512;
pub const S_IREAD: u32 = 256;
pub const S_IWRITE: u32 = 128;
pub const S_IEXEC: u32 = 64;
pub const ACCESSPERMS: u32 = 511;
pub const ALLPERMS: u32 = 4095;
pub const DEFFILEMODE: u32 = 438;
pub const S_BLKSIZE: u32 = 512;
pub const UF_SETTABLE: u32 = 65535;
pub const UF_NODUMP: u32 = 1;
pub const UF_IMMUTABLE: u32 = 2;
pub const UF_APPEND: u32 = 4;
pub const UF_OPAQUE: u32 = 8;
pub const UF_COMPRESSED: u32 = 32;
pub const UF_TRACKED: u32 = 64;
pub const UF_DATAVAULT: u32 = 128;
pub const UF_HIDDEN: u32 = 32768;
pub const SF_SUPPORTED: u32 = 10420224;
pub const SF_SETTABLE: u32 = 1073676288;
pub const SF_SYNTHETIC: u32 = 3221225472;
pub const SF_ARCHIVED: u32 = 65536;
pub const SF_IMMUTABLE: u32 = 131072;
pub const SF_APPEND: u32 = 262144;
pub const SF_RESTRICTED: u32 = 524288;
pub const SF_NOUNLINK: u32 = 1048576;
pub const SF_FIRMLINK: u32 = 8388608;
pub const SF_DATALESS: u32 = 1073741824;
pub const EF_MAY_SHARE_BLOCKS: u32 = 1;
pub const EF_NO_XATTRS: u32 = 2;
pub const EF_IS_SYNC_ROOT: u32 = 4;
pub const EF_IS_PURGEABLE: u32 = 8;
pub const EF_IS_SPARSE: u32 = 16;
pub const EF_IS_SYNTHETIC: u32 = 32;
pub const UTIME_NOW: i32 = -1;
pub const UTIME_OMIT: i32 = -2;
pub const _POSIX_VERSION: u32 = 200112;
pub const _POSIX2_VERSION: u32 = 200112;
pub const F_OK: u32 = 0;
pub const X_OK: u32 = 1;
pub const W_OK: u32 = 2;
pub const R_OK: u32 = 4;
pub const _READ_OK: u32 = 512;
pub const _WRITE_OK: u32 = 1024;
pub const _EXECUTE_OK: u32 = 2048;
pub const _DELETE_OK: u32 = 4096;
pub const _APPEND_OK: u32 = 8192;
pub const _RMFILE_OK: u32 = 16384;
pub const _RATTR_OK: u32 = 32768;
pub const _WATTR_OK: u32 = 65536;
pub const _REXT_OK: u32 = 131072;
pub const _WEXT_OK: u32 = 262144;
pub const _RPERM_OK: u32 = 524288;
pub const _WPERM_OK: u32 = 1048576;
pub const _CHOWN_OK: u32 = 2097152;
pub const _ACCESS_EXTENDED_MASK: u32 = 4193792;
pub const SEEK_HOLE: u32 = 3;
pub const SEEK_DATA: u32 = 4;
pub const L_SET: u32 = 0;
pub const L_INCR: u32 = 1;
pub const L_XTND: u32 = 2;
pub const ACCESSX_MAX_DESCRIPTORS: u32 = 100;
pub const ACCESSX_MAX_TABLESIZE: u32 = 16384;
pub const _PC_LINK_MAX: u32 = 1;
pub const _PC_MAX_CANON: u32 = 2;
pub const _PC_MAX_INPUT: u32 = 3;
pub const _PC_NAME_MAX: u32 = 4;
pub const _PC_PATH_MAX: u32 = 5;
pub const _PC_PIPE_BUF: u32 = 6;
pub const _PC_CHOWN_RESTRICTED: u32 = 7;
pub const _PC_NO_TRUNC: u32 = 8;
pub const _PC_VDISABLE: u32 = 9;
pub const _PC_NAME_CHARS_MAX: u32 = 10;
pub const _PC_CASE_SENSITIVE: u32 = 11;
pub const _PC_CASE_PRESERVING: u32 = 12;
pub const _PC_EXTENDED_SECURITY_NP: u32 = 13;
pub const _PC_AUTH_OPAQUE_NP: u32 = 14;
pub const _PC_2_SYMLINKS: u32 = 15;
pub const _PC_ALLOC_SIZE_MIN: u32 = 16;
pub const _PC_ASYNC_IO: u32 = 17;
pub const _PC_FILESIZEBITS: u32 = 18;
pub const _PC_PRIO_IO: u32 = 19;
pub const _PC_REC_INCR_XFER_SIZE: u32 = 20;
pub const _PC_REC_MAX_XFER_SIZE: u32 = 21;
pub const _PC_REC_MIN_XFER_SIZE: u32 = 22;
pub const _PC_REC_XFER_ALIGN: u32 = 23;
pub const _PC_SYMLINK_MAX: u32 = 24;
pub const _PC_SYNC_IO: u32 = 25;
pub const _PC_XATTR_SIZE_BITS: u32 = 26;
pub const _PC_MIN_HOLE_SIZE: u32 = 27;
pub const _CS_PATH: u32 = 1;
pub const STDIN_FILENO: u32 = 0;
pub const STDOUT_FILENO: u32 = 1;
pub const STDERR_FILENO: u32 = 2;
pub const _XOPEN_VERSION: u32 = 600;
pub const _XOPEN_XCU_VERSION: u32 = 4;
pub const _POSIX_ADVISORY_INFO: i32 = -1;
pub const _POSIX_ASYNCHRONOUS_IO: i32 = -1;
pub const _POSIX_BARRIERS: i32 = -1;
pub const _POSIX_CHOWN_RESTRICTED: u32 = 200112;
pub const _POSIX_CLOCK_SELECTION: i32 = -1;
pub const _POSIX_CPUTIME: i32 = -1;
pub const _POSIX_FSYNC: u32 = 200112;
pub const _POSIX_IPV6: u32 = 200112;
pub const _POSIX_JOB_CONTROL: u32 = 200112;
pub const _POSIX_MAPPED_FILES: u32 = 200112;
pub const _POSIX_MEMLOCK: i32 = -1;
pub const _POSIX_MEMLOCK_RANGE: i32 = -1;
pub const _POSIX_MEMORY_PROTECTION: u32 = 200112;
pub const _POSIX_MESSAGE_PASSING: i32 = -1;
pub const _POSIX_MONOTONIC_CLOCK: i32 = -1;
pub const _POSIX_NO_TRUNC: u32 = 200112;
pub const _POSIX_PRIORITIZED_IO: i32 = -1;
pub const _POSIX_PRIORITY_SCHEDULING: i32 = -1;
pub const _POSIX_RAW_SOCKETS: i32 = -1;
pub const _POSIX_READER_WRITER_LOCKS: u32 = 200112;
pub const _POSIX_REALTIME_SIGNALS: i32 = -1;
pub const _POSIX_REGEXP: u32 = 200112;
pub const _POSIX_SAVED_IDS: u32 = 200112;
pub const _POSIX_SEMAPHORES: i32 = -1;
pub const _POSIX_SHARED_MEMORY_OBJECTS: i32 = -1;
pub const _POSIX_SHELL: u32 = 200112;
pub const _POSIX_SPAWN: i32 = -1;
pub const _POSIX_SPIN_LOCKS: i32 = -1;
pub const _POSIX_SPORADIC_SERVER: i32 = -1;
pub const _POSIX_SYNCHRONIZED_IO: i32 = -1;
pub const _POSIX_THREAD_ATTR_STACKADDR: u32 = 200112;
pub const _POSIX_THREAD_ATTR_STACKSIZE: u32 = 200112;
pub const _POSIX_THREAD_CPUTIME: i32 = -1;
pub const _POSIX_THREAD_PRIO_INHERIT: i32 = -1;
pub const _POSIX_THREAD_PRIO_PROTECT: i32 = -1;
pub const _POSIX_THREAD_PRIORITY_SCHEDULING: i32 = -1;
pub const _POSIX_THREAD_PROCESS_SHARED: u32 = 200112;
pub const _POSIX_THREAD_SAFE_FUNCTIONS: u32 = 200112;
pub const _POSIX_THREAD_SPORADIC_SERVER: i32 = -1;
pub const _POSIX_THREADS: u32 = 200112;
pub const _POSIX_TIMEOUTS: i32 = -1;
pub const _POSIX_TIMERS: i32 = -1;
pub const _POSIX_TRACE: i32 = -1;
pub const _POSIX_TRACE_EVENT_FILTER: i32 = -1;
pub const _POSIX_TRACE_INHERIT: i32 = -1;
pub const _POSIX_TRACE_LOG: i32 = -1;
pub const _POSIX_TYPED_MEMORY_OBJECTS: i32 = -1;
pub const _POSIX2_C_BIND: u32 = 200112;
pub const _POSIX2_C_DEV: u32 = 200112;
pub const _POSIX2_CHAR_TERM: u32 = 200112;
pub const _POSIX2_FORT_DEV: i32 = -1;
pub const _POSIX2_FORT_RUN: u32 = 200112;
pub const _POSIX2_LOCALEDEF: u32 = 200112;
pub const _POSIX2_PBS: i32 = -1;
pub const _POSIX2_PBS_ACCOUNTING: i32 = -1;
pub const _POSIX2_PBS_CHECKPOINT: i32 = -1;
pub const _POSIX2_PBS_LOCATE: i32 = -1;
pub const _POSIX2_PBS_MESSAGE: i32 = -1;
pub const _POSIX2_PBS_TRACK: i32 = -1;
pub const _POSIX2_SW_DEV: u32 = 200112;
pub const _POSIX2_UPE: u32 = 200112;
pub const __ILP32_OFF32: i32 = -1;
pub const __ILP32_OFFBIG: i32 = -1;
pub const __LP64_OFF64: u32 = 1;
pub const __LPBIG_OFFBIG: u32 = 1;
pub const _POSIX_V6_ILP32_OFF32: i32 = -1;
pub const _POSIX_V6_ILP32_OFFBIG: i32 = -1;
pub const _POSIX_V6_LP64_OFF64: u32 = 1;
pub const _POSIX_V6_LPBIG_OFFBIG: u32 = 1;
pub const _POSIX_V7_ILP32_OFF32: i32 = -1;
pub const _POSIX_V7_ILP32_OFFBIG: i32 = -1;
pub const _POSIX_V7_LP64_OFF64: u32 = 1;
pub const _POSIX_V7_LPBIG_OFFBIG: u32 = 1;
pub const _V6_ILP32_OFF32: i32 = -1;
pub const _V6_ILP32_OFFBIG: i32 = -1;
pub const _V6_LP64_OFF64: u32 = 1;
pub const _V6_LPBIG_OFFBIG: u32 = 1;
pub const _XBS5_ILP32_OFF32: i32 = -1;
pub const _XBS5_ILP32_OFFBIG: i32 = -1;
pub const _XBS5_LP64_OFF64: u32 = 1;
pub const _XBS5_LPBIG_OFFBIG: u32 = 1;
pub const _XOPEN_CRYPT: u32 = 1;
pub const _XOPEN_ENH_I18N: u32 = 1;
pub const _XOPEN_LEGACY: i32 = -1;
pub const _XOPEN_REALTIME: i32 = -1;
pub const _XOPEN_REALTIME_THREADS: i32 = -1;
pub const _XOPEN_SHM: u32 = 1;
pub const _XOPEN_STREAMS: i32 = -1;
pub const _XOPEN_UNIX: u32 = 1;
pub const _SC_ARG_MAX: u32 = 1;
pub const _SC_CHILD_MAX: u32 = 2;
pub const _SC_CLK_TCK: u32 = 3;
pub const _SC_NGROUPS_MAX: u32 = 4;
pub const _SC_OPEN_MAX: u32 = 5;
pub const _SC_JOB_CONTROL: u32 = 6;
pub const _SC_SAVED_IDS: u32 = 7;
pub const _SC_VERSION: u32 = 8;
pub const _SC_BC_BASE_MAX: u32 = 9;
pub const _SC_BC_DIM_MAX: u32 = 10;
pub const _SC_BC_SCALE_MAX: u32 = 11;
pub const _SC_BC_STRING_MAX: u32 = 12;
pub const _SC_COLL_WEIGHTS_MAX: u32 = 13;
pub const _SC_EXPR_NEST_MAX: u32 = 14;
pub const _SC_LINE_MAX: u32 = 15;
pub const _SC_RE_DUP_MAX: u32 = 16;
pub const _SC_2_VERSION: u32 = 17;
pub const _SC_2_C_BIND: u32 = 18;
pub const _SC_2_C_DEV: u32 = 19;
pub const _SC_2_CHAR_TERM: u32 = 20;
pub const _SC_2_FORT_DEV: u32 = 21;
pub const _SC_2_FORT_RUN: u32 = 22;
pub const _SC_2_LOCALEDEF: u32 = 23;
pub const _SC_2_SW_DEV: u32 = 24;
pub const _SC_2_UPE: u32 = 25;
pub const _SC_STREAM_MAX: u32 = 26;
pub const _SC_TZNAME_MAX: u32 = 27;
pub const _SC_ASYNCHRONOUS_IO: u32 = 28;
pub const _SC_PAGESIZE: u32 = 29;
pub const _SC_MEMLOCK: u32 = 30;
pub const _SC_MEMLOCK_RANGE: u32 = 31;
pub const _SC_MEMORY_PROTECTION: u32 = 32;
pub const _SC_MESSAGE_PASSING: u32 = 33;
pub const _SC_PRIORITIZED_IO: u32 = 34;
pub const _SC_PRIORITY_SCHEDULING: u32 = 35;
pub const _SC_REALTIME_SIGNALS: u32 = 36;
pub const _SC_SEMAPHORES: u32 = 37;
pub const _SC_FSYNC: u32 = 38;
pub const _SC_SHARED_MEMORY_OBJECTS: u32 = 39;
pub const _SC_SYNCHRONIZED_IO: u32 = 40;
pub const _SC_TIMERS: u32 = 41;
pub const _SC_AIO_LISTIO_MAX: u32 = 42;
pub const _SC_AIO_MAX: u32 = 43;
pub const _SC_AIO_PRIO_DELTA_MAX: u32 = 44;
pub const _SC_DELAYTIMER_MAX: u32 = 45;
pub const _SC_MQ_OPEN_MAX: u32 = 46;
pub const _SC_MAPPED_FILES: u32 = 47;
pub const _SC_RTSIG_MAX: u32 = 48;
pub const _SC_SEM_NSEMS_MAX: u32 = 49;
pub const _SC_SEM_VALUE_MAX: u32 = 50;
pub const _SC_SIGQUEUE_MAX: u32 = 51;
pub const _SC_TIMER_MAX: u32 = 52;
pub const _SC_NPROCESSORS_CONF: u32 = 57;
pub const _SC_NPROCESSORS_ONLN: u32 = 58;
pub const _SC_2_PBS: u32 = 59;
pub const _SC_2_PBS_ACCOUNTING: u32 = 60;
pub const _SC_2_PBS_CHECKPOINT: u32 = 61;
pub const _SC_2_PBS_LOCATE: u32 = 62;
pub const _SC_2_PBS_MESSAGE: u32 = 63;
pub const _SC_2_PBS_TRACK: u32 = 64;
pub const _SC_ADVISORY_INFO: u32 = 65;
pub const _SC_BARRIERS: u32 = 66;
pub const _SC_CLOCK_SELECTION: u32 = 67;
pub const _SC_CPUTIME: u32 = 68;
pub const _SC_FILE_LOCKING: u32 = 69;
pub const _SC_GETGR_R_SIZE_MAX: u32 = 70;
pub const _SC_GETPW_R_SIZE_MAX: u32 = 71;
pub const _SC_HOST_NAME_MAX: u32 = 72;
pub const _SC_LOGIN_NAME_MAX: u32 = 73;
pub const _SC_MONOTONIC_CLOCK: u32 = 74;
pub const _SC_MQ_PRIO_MAX: u32 = 75;
pub const _SC_READER_WRITER_LOCKS: u32 = 76;
pub const _SC_REGEXP: u32 = 77;
pub const _SC_SHELL: u32 = 78;
pub const _SC_SPAWN: u32 = 79;
pub const _SC_SPIN_LOCKS: u32 = 80;
pub const _SC_SPORADIC_SERVER: u32 = 81;
pub const _SC_THREAD_ATTR_STACKADDR: u32 = 82;
pub const _SC_THREAD_ATTR_STACKSIZE: u32 = 83;
pub const _SC_THREAD_CPUTIME: u32 = 84;
pub const _SC_THREAD_DESTRUCTOR_ITERATIONS: u32 = 85;
pub const _SC_THREAD_KEYS_MAX: u32 = 86;
pub const _SC_THREAD_PRIO_INHERIT: u32 = 87;
pub const _SC_THREAD_PRIO_PROTECT: u32 = 88;
pub const _SC_THREAD_PRIORITY_SCHEDULING: u32 = 89;
pub const _SC_THREAD_PROCESS_SHARED: u32 = 90;
pub const _SC_THREAD_SAFE_FUNCTIONS: u32 = 91;
pub const _SC_THREAD_SPORADIC_SERVER: u32 = 92;
pub const _SC_THREAD_STACK_MIN: u32 = 93;
pub const _SC_THREAD_THREADS_MAX: u32 = 94;
pub const _SC_TIMEOUTS: u32 = 95;
pub const _SC_THREADS: u32 = 96;
pub const _SC_TRACE: u32 = 97;
pub const _SC_TRACE_EVENT_FILTER: u32 = 98;
pub const _SC_TRACE_INHERIT: u32 = 99;
pub const _SC_TRACE_LOG: u32 = 100;
pub const _SC_TTY_NAME_MAX: u32 = 101;
pub const _SC_TYPED_MEMORY_OBJECTS: u32 = 102;
pub const _SC_V6_ILP32_OFF32: u32 = 103;
pub const _SC_V6_ILP32_OFFBIG: u32 = 104;
pub const _SC_V6_LP64_OFF64: u32 = 105;
pub const _SC_V6_LPBIG_OFFBIG: u32 = 106;
pub const _SC_IPV6: u32 = 118;
pub const _SC_RAW_SOCKETS: u32 = 119;
pub const _SC_SYMLOOP_MAX: u32 = 120;
pub const _SC_ATEXIT_MAX: u32 = 107;
pub const _SC_IOV_MAX: u32 = 56;
pub const _SC_PAGE_SIZE: u32 = 29;
pub const _SC_XOPEN_CRYPT: u32 = 108;
pub const _SC_XOPEN_ENH_I18N: u32 = 109;
pub const _SC_XOPEN_LEGACY: u32 = 110;
pub const _SC_XOPEN_REALTIME: u32 = 111;
pub const _SC_XOPEN_REALTIME_THREADS: u32 = 112;
pub const _SC_XOPEN_SHM: u32 = 113;
pub const _SC_XOPEN_STREAMS: u32 = 114;
pub const _SC_XOPEN_UNIX: u32 = 115;
pub const _SC_XOPEN_VERSION: u32 = 116;
pub const _SC_XOPEN_XCU_VERSION: u32 = 121;
pub const _SC_XBS5_ILP32_OFF32: u32 = 122;
pub const _SC_XBS5_ILP32_OFFBIG: u32 = 123;
pub const _SC_XBS5_LP64_OFF64: u32 = 124;
pub const _SC_XBS5_LPBIG_OFFBIG: u32 = 125;
pub const _SC_SS_REPL_MAX: u32 = 126;
pub const _SC_TRACE_EVENT_NAME_MAX: u32 = 127;
pub const _SC_TRACE_NAME_MAX: u32 = 128;
pub const _SC_TRACE_SYS_MAX: u32 = 129;
pub const _SC_TRACE_USER_EVENT_MAX: u32 = 130;
pub const _SC_PASS_MAX: u32 = 131;
pub const _SC_PHYS_PAGES: u32 = 200;
pub const _CS_POSIX_V6_ILP32_OFF32_CFLAGS: u32 = 2;
pub const _CS_POSIX_V6_ILP32_OFF32_LDFLAGS: u32 = 3;
pub const _CS_POSIX_V6_ILP32_OFF32_LIBS: u32 = 4;
pub const _CS_POSIX_V6_ILP32_OFFBIG_CFLAGS: u32 = 5;
pub const _CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS: u32 = 6;
pub const _CS_POSIX_V6_ILP32_OFFBIG_LIBS: u32 = 7;
pub const _CS_POSIX_V6_LP64_OFF64_CFLAGS: u32 = 8;
pub const _CS_POSIX_V6_LP64_OFF64_LDFLAGS: u32 = 9;
pub const _CS_POSIX_V6_LP64_OFF64_LIBS: u32 = 10;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS: u32 = 11;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS: u32 = 12;
pub const _CS_POSIX_V6_LPBIG_OFFBIG_LIBS: u32 = 13;
pub const _CS_POSIX_V6_WIDTH_RESTRICTED_ENVS: u32 = 14;
pub const _CS_XBS5_ILP32_OFF32_CFLAGS: u32 = 20;
pub const _CS_XBS5_ILP32_OFF32_LDFLAGS: u32 = 21;
pub const _CS_XBS5_ILP32_OFF32_LIBS: u32 = 22;
pub const _CS_XBS5_ILP32_OFF32_LINTFLAGS: u32 = 23;
pub const _CS_XBS5_ILP32_OFFBIG_CFLAGS: u32 = 24;
pub const _CS_XBS5_ILP32_OFFBIG_LDFLAGS: u32 = 25;
pub const _CS_XBS5_ILP32_OFFBIG_LIBS: u32 = 26;
pub const _CS_XBS5_ILP32_OFFBIG_LINTFLAGS: u32 = 27;
pub const _CS_XBS5_LP64_OFF64_CFLAGS: u32 = 28;
pub const _CS_XBS5_LP64_OFF64_LDFLAGS: u32 = 29;
pub const _CS_XBS5_LP64_OFF64_LIBS: u32 = 30;
pub const _CS_XBS5_LP64_OFF64_LINTFLAGS: u32 = 31;
pub const _CS_XBS5_LPBIG_OFFBIG_CFLAGS: u32 = 32;
pub const _CS_XBS5_LPBIG_OFFBIG_LDFLAGS: u32 = 33;
pub const _CS_XBS5_LPBIG_OFFBIG_LIBS: u32 = 34;
pub const _CS_XBS5_LPBIG_OFFBIG_LINTFLAGS: u32 = 35;
pub const _CS_DARWIN_USER_DIR: u32 = 65536;
pub const _CS_DARWIN_USER_TEMP_DIR: u32 = 65537;
pub const _CS_DARWIN_USER_CACHE_DIR: u32 = 65538;
pub const F_ULOCK: u32 = 0;
pub const F_LOCK: u32 = 1;
pub const F_TLOCK: u32 = 2;
pub const F_TEST: u32 = 3;
pub const __DARWIN_FD_SETSIZE: u32 = 1024;
pub const __DARWIN_NBBY: u32 = 8;
pub const FD_SETSIZE: u32 = 1024;
pub const SYNC_VOLUME_FULLSYNC: u32 = 1;
pub const SYNC_VOLUME_WAIT: u32 = 2;
pub const FIFTYONE_DEGREES_FILE_MAX_PATH: u32 = 4096;
pub const _CACHED_RUNES: u32 = 256;
pub const _CRMASK: i32 = -256;
pub const _RUNE_MAGIC_A: &'static [u8; 9usize] = b"RuneMagA\0";
pub const _CTYPE_A: u32 = 256;
pub const _CTYPE_C: u32 = 512;
pub const _CTYPE_D: u32 = 1024;
pub const _CTYPE_G: u32 = 2048;
pub const _CTYPE_L: u32 = 4096;
pub const _CTYPE_P: u32 = 8192;
pub const _CTYPE_S: u32 = 16384;
pub const _CTYPE_U: u32 = 32768;
pub const _CTYPE_X: u32 = 65536;
pub const _CTYPE_B: u32 = 131072;
pub const _CTYPE_R: u32 = 262144;
pub const _CTYPE_I: u32 = 524288;
pub const _CTYPE_T: u32 = 1048576;
pub const _CTYPE_Q: u32 = 2097152;
pub const _CTYPE_SW0: u32 = 536870912;
pub const _CTYPE_SW1: u32 = 1073741824;
pub const _CTYPE_SW2: u32 = 2147483648;
pub const _CTYPE_SW3: u32 = 3221225472;
pub const _CTYPE_SWM: u32 = 3758096384;
pub const _CTYPE_SWS: u32 = 30;
pub const FIFTYONE_DEGREES_FLOAT_BIAS: u32 = 127;
pub const FIFTYONE_DEGREES_FLOAT_SIZE: u32 = 4;
pub const FIFTYONE_DEGREES_FLOAT_RADIX: u32 = 2;
pub const FIFTYONE_DEGREES_FLOAT_SIGN_SIZE: u32 = 1;
pub const FIFTYONE_DEGREES_FLOAT_EXP_SIZE: u32 = 8;
pub const FIFTYONE_DEGREES_FLOAT_MANT_SIZE: u32 = 23;
pub const FIFTYONE_DEGREES_FLOAT_EXP_MAX: u32 = 255;
pub const FIFTYONE_DEGREES_FLOAT_MANT_MAX: u32 = 8388607;
pub const FIFTYONE_DEGREES_CONFIG_USE_TEMP_FILE_DEFAULT: u32 = 0;
pub const FIFTYONE_DEGREES_CONFIG_USE_TEMP_FILE: u32 = 0;
pub const FIFTYONE_DEGREES_CONFIG_ALL_IN_MEMORY_DEFAULT: u32 = 0;
pub const FIFTYONE_DEGREES_CONFIG_ALL_IN_MEMORY: u32 = 0;
pub const FIFTYONE_DEGREES_IPV4_LENGTH: u32 = 4;
pub const FIFTYONE_DEGREES_IPV6_LENGTH: u32 = 16;
pub const FIFTYONE_DEGREES_PSEUDO_HEADER_SEP: u8 = 31u8;
pub const FILE_MAX_PATH: u32 = 4096;
pub const PSEUDO_HEADER_SEP: u8 = 31u8;
pub const FIFTYONE_DEGREES_CONFIG_DEVICE_DETECTION_UPDATE_DEFAULT: u32 = 1;
pub const FIFTYONE_DEGREES_CONFIG_DEVICE_DETECTION_DEFAULT_UNMATCHED: u32 = 0;
pub const FIFTYONE_DEGREES_CONFIG_DEVICE_DETECTION_UPDATE: u32 = 1;
pub const FP_NAN: u32 = 1;
pub const FP_INFINITE: u32 = 2;
pub const FP_ZERO: u32 = 3;
pub const FP_NORMAL: u32 = 4;
pub const FP_SUBNORMAL: u32 = 5;
pub const FP_SUPERNORMAL: u32 = 6;
pub const FP_ILOGB0: i32 = -2147483648;
pub const FP_ILOGBNAN: i32 = -2147483648;
pub const MATH_ERRNO: u32 = 1;
pub const MATH_ERREXCEPT: u32 = 2;
pub const M_E: f64 = 2.718281828459045;
pub const M_LOG2E: f64 = 1.4426950408889634;
pub const M_LOG10E: f64 = 0.4342944819032518;
pub const M_LN2: f64 = 0.6931471805599453;
pub const M_LN10: f64 = 2.302585092994046;
pub const M_PI: f64 = 3.141592653589793;
pub const M_PI_2: f64 = 1.5707963267948966;
pub const M_PI_4: f64 = 0.7853981633974483;
pub const M_1_PI: f64 = 0.3183098861837907;
pub const M_2_PI: f64 = 0.6366197723675814;
pub const M_2_SQRTPI: f64 = 1.1283791670955126;
pub const M_SQRT2: f64 = 1.4142135623730951;
pub const M_SQRT1_2: f64 = 0.7071067811865476;
pub const FP_SNAN: u32 = 1;
pub const FP_QNAN: u32 = 1;
pub const DOMAIN: u32 = 1;
pub const SING: u32 = 2;
pub const OVERFLOW: u32 = 3;
pub const UNDERFLOW: u32 = 4;
pub const TLOSS: u32 = 5;
pub const PLOSS: u32 = 6;
pub const FIFTYONE_DEGREES_CACHE_CONCURRENCY: u32 = 10;
pub const FIFTYONE_DEGREES_HASH_DIFFERENCE: u32 = 0;
pub const FIFTYONE_DEGREES_HASH_DRIFT: u32 = 0;
pub const FIFTYONE_DEGREES_STRING_CACHE_SIZE: u32 = 10000;
pub const FIFTYONE_DEGREES_STRING_LOADED: u32 = 100;
pub const FIFTYONE_DEGREES_NODE_CACHE_SIZE: u32 = 50000;
pub const FIFTYONE_DEGREES_NODE_LOADED: u32 = 100;
pub const FIFTYONE_DEGREES_PROFILE_CACHE_SIZE: u32 = 10000;
pub const FIFTYONE_DEGREES_PROFILE_LOADED: u32 = 100;
pub const FIFTYONE_DEGREES_VALUE_CACHE_SIZE: u32 = 500;
pub const FIFTYONE_DEGREES_VALUE_LOADED: u32 = 0;
pub const FIFTYONE_DEGREES_PROPERTY_CACHE_SIZE: u32 = 0;
pub const FIFTYONE_DEGREES_PROPERTY_LOADED: u32 = 2147483647;
pub type int_least8_t = i8;
pub type int_least16_t = i16;
pub type int_least32_t = i32;
pub type int_least64_t = i64;
pub type uint_least8_t = u8;
pub type uint_least16_t = u16;
pub type uint_least32_t = u32;
pub type uint_least64_t = u64;
pub type int_fast8_t = i8;
pub type int_fast16_t = i16;
pub type int_fast32_t = i32;
pub type int_fast64_t = i64;
pub type uint_fast8_t = u8;
pub type uint_fast16_t = u16;
pub type uint_fast32_t = u32;
pub type uint_fast64_t = u64;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_longlong;
pub type __uint64_t = ::std::os::raw::c_ulonglong;
pub type __darwin_intptr_t = ::std::os::raw::c_long;
pub type __darwin_natural_t = ::std::os::raw::c_uint;
pub type __darwin_ct_rune_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t {
    pub __mbstate8: [::std::os::raw::c_char; 128usize],
    pub _mbstateL: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout___mbstate_t() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t>(),
        128usize,
        concat!("Size of: ", stringify!(__mbstate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__mbstate_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__mbstate8 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__mbstate8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>()))._mbstateL as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(_mbstateL)
        )
    );
}
pub type __darwin_mbstate_t = __mbstate_t;
pub type __darwin_ptrdiff_t = ::std::os::raw::c_long;
pub type __darwin_size_t = ::std::os::raw::c_ulong;
pub type __darwin_va_list = __builtin_va_list;
pub type __darwin_wchar_t = ::std::os::raw::c_int;
pub type __darwin_rune_t = __darwin_wchar_t;
pub type __darwin_wint_t = ::std::os::raw::c_int;
pub type __darwin_clock_t = ::std::os::raw::c_ulong;
pub type __darwin_socklen_t = __uint32_t;
pub type __darwin_ssize_t = ::std::os::raw::c_long;
pub type __darwin_time_t = ::std::os::raw::c_long;
pub type __darwin_blkcnt_t = __int64_t;
pub type __darwin_blksize_t = __int32_t;
pub type __darwin_dev_t = __int32_t;
pub type __darwin_fsblkcnt_t = ::std::os::raw::c_uint;
pub type __darwin_fsfilcnt_t = ::std::os::raw::c_uint;
pub type __darwin_gid_t = __uint32_t;
pub type __darwin_id_t = __uint32_t;
pub type __darwin_ino64_t = __uint64_t;
pub type __darwin_ino_t = __darwin_ino64_t;
pub type __darwin_mach_port_name_t = __darwin_natural_t;
pub type __darwin_mach_port_t = __darwin_mach_port_name_t;
pub type __darwin_mode_t = __uint16_t;
pub type __darwin_off_t = __int64_t;
pub type __darwin_pid_t = __int32_t;
pub type __darwin_sigset_t = __uint32_t;
pub type __darwin_suseconds_t = __int32_t;
pub type __darwin_uid_t = __uint32_t;
pub type __darwin_useconds_t = __uint32_t;
pub type __darwin_uuid_t = [::std::os::raw::c_uchar; 16usize];
pub type __darwin_uuid_string_t = [::std::os::raw::c_char; 37usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_pthread_handler_rec {
    pub __routine: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub __arg: *mut ::std::os::raw::c_void,
    pub __next: *mut __darwin_pthread_handler_rec,
}
#[test]
fn bindgen_test_layout___darwin_pthread_handler_rec() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_pthread_handler_rec>(),
        24usize,
        concat!("Size of: ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_pthread_handler_rec>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__routine as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__routine)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__arg as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__arg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__next)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _opaque_pthread_attr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_attr_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_attr_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_attr_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _opaque_pthread_cond_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 40usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_cond_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_cond_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_condattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_condattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_condattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_condattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_condattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _opaque_pthread_mutex_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_mutex_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_mutex_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutex_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutexattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_mutexattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_mutexattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutexattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutexattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_once_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_once_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_once_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_once_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_once_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_once_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _opaque_pthread_rwlock_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 192usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_rwlock_t>(),
        200usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_rwlock_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlock_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlockattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_rwlockattr_t>(),
        24usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlockattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlockattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _opaque_pthread_t {
    pub __sig: ::std::os::raw::c_long,
    pub __cleanup_stack: *mut __darwin_pthread_handler_rec,
    pub __opaque: [::std::os::raw::c_char; 8176usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_t>(),
        8192usize,
        concat!("Size of: ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_t>())).__cleanup_stack as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__cleanup_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_t>())).__opaque as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__opaque)
        )
    );
}
pub type __darwin_pthread_attr_t = _opaque_pthread_attr_t;
pub type __darwin_pthread_cond_t = _opaque_pthread_cond_t;
pub type __darwin_pthread_condattr_t = _opaque_pthread_condattr_t;
pub type __darwin_pthread_key_t = ::std::os::raw::c_ulong;
pub type __darwin_pthread_mutex_t = _opaque_pthread_mutex_t;
pub type __darwin_pthread_mutexattr_t = _opaque_pthread_mutexattr_t;
pub type __darwin_pthread_once_t = _opaque_pthread_once_t;
pub type __darwin_pthread_rwlock_t = _opaque_pthread_rwlock_t;
pub type __darwin_pthread_rwlockattr_t = _opaque_pthread_rwlockattr_t;
pub type __darwin_pthread_t = *mut _opaque_pthread_t;
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_int64_t = ::std::os::raw::c_ulonglong;
pub type register_t = i64;
pub type user_addr_t = u_int64_t;
pub type user_size_t = u_int64_t;
pub type user_ssize_t = i64;
pub type user_long_t = i64;
pub type user_ulong_t = u_int64_t;
pub type user_time_t = i64;
pub type user_off_t = i64;
pub type syscall_arg_t = u_int64_t;
pub type intmax_t = ::std::os::raw::c_long;
pub type uintmax_t = ::std::os::raw::c_ulong;
pub type __darwin_nl_item = ::std::os::raw::c_int;
pub type __darwin_wctrans_t = ::std::os::raw::c_int;
pub type __darwin_wctype_t = __uint32_t;
pub type size_t = __darwin_size_t;
extern "C" {
    pub fn memchr(
        __s: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memcmp(
        __s1: *const ::std::os::raw::c_void,
        __s2: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memcpy(
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memmove(
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __len: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset(
        __b: *mut ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __len: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strcat(
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcoll(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcspn(
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strerror(__errnum: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlen(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strncat(
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncmp(
        __s1: *const ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strpbrk(
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strrchr(
        __s: *const ::std::os::raw::c_char,
        __c: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strspn(
        __s: *const ::std::os::raw::c_char,
        __charset: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strstr(
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strtok(
        __str: *mut ::std::os::raw::c_char,
        __sep: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strxfrm(
        __s1: *mut ::std::os::raw::c_char,
        __s2: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtok_r(
        __str: *mut ::std::os::raw::c_char,
        __sep: *const ::std::os::raw::c_char,
        __lasts: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strerror_r(
        __errnum: ::std::os::raw::c_int,
        __strerrbuf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strdup(__s1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn memccpy(
        __dst: *mut ::std::os::raw::c_void,
        __src: *const ::std::os::raw::c_void,
        __c: ::std::os::raw::c_int,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn stpcpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn stpncpy(
        __dst: *mut ::std::os::raw::c_char,
        __src: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strndup(
        __s1: *const ::std::os::raw::c_char,
        __n: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strnlen(__s1: *const ::std::os::raw::c_char, __n: size_t) -> size_t;
}
extern "C" {
    pub fn strsignal(__sig: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
pub type rsize_t = __darwin_size_t;
pub type errno_t = ::std::os::raw::c_int;
extern "C" {
    pub fn memset_s(
        __s: *mut ::std::os::raw::c_void,
        __smax: rsize_t,
        __c: ::std::os::raw::c_int,
        __n: rsize_t,
    ) -> errno_t;
}
pub type ssize_t = __darwin_ssize_t;
extern "C" {
    pub fn memmem(
        __big: *const ::std::os::raw::c_void,
        __big_len: size_t,
        __little: *const ::std::os::raw::c_void,
        __little_len: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset_pattern4(
        __b: *mut ::std::os::raw::c_void,
        __pattern4: *const ::std::os::raw::c_void,
        __len: size_t,
    );
}
extern "C" {
    pub fn memset_pattern8(
        __b: *mut ::std::os::raw::c_void,
        __pattern8: *const ::std::os::raw::c_void,
        __len: size_t,
    );
}
extern "C" {
    pub fn memset_pattern16(
        __b: *mut ::std::os::raw::c_void,
        __pattern16: *const ::std::os::raw::c_void,
        __len: size_t,
    );
}
extern "C" {
    pub fn strcasestr(
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strnstr(
        __big: *const ::std::os::raw::c_char,
        __little: *const ::std::os::raw::c_char,
        __len: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strlcat(
        __dst: *mut ::std::os::raw::c_char,
        __source: *const ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strlcpy(
        __dst: *mut ::std::os::raw::c_char,
        __source: *const ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strmode(__mode: ::std::os::raw::c_int, __bp: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn strsep(
        __stringp: *mut *mut ::std::os::raw::c_char,
        __delim: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn swab(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ssize_t,
    );
}
extern "C" {
    pub fn timingsafe_bcmp(
        __b1: *const ::std::os::raw::c_void,
        __b2: *const ::std::os::raw::c_void,
        __len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strsignal_r(
        __sig: ::std::os::raw::c_int,
        __strsignalbuf: *mut ::std::os::raw::c_char,
        __buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcmp(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bcopy(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
        arg3: size_t,
    );
}
extern "C" {
    pub fn bzero(arg1: *mut ::std::os::raw::c_void, arg2: ::std::os::raw::c_ulong);
}
extern "C" {
    pub fn index(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn rindex(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ffs(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcasecmp(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strncasecmp(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsl(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsll(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fls(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn flsl(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn flsll(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_int;
}
pub type va_list = __darwin_va_list;
extern "C" {
    pub fn renameat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn renamex_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn renameatx_np(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
        arg5: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
pub type fpos_t = __darwin_off_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sbuf {
    pub _base: *mut ::std::os::raw::c_uchar,
    pub _size: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___sbuf() {
    assert_eq!(
        ::std::mem::size_of::<__sbuf>(),
        16usize,
        concat!("Size of: ", stringify!(__sbuf))
    );
    assert_eq!(
        ::std::mem::align_of::<__sbuf>(),
        8usize,
        concat!("Alignment of ", stringify!(__sbuf))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sbuf>()))._base as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sbuf),
            "::",
            stringify!(_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sbuf>()))._size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sbuf),
            "::",
            stringify!(_size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sFILEX {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sFILE {
    pub _p: *mut ::std::os::raw::c_uchar,
    pub _r: ::std::os::raw::c_int,
    pub _w: ::std::os::raw::c_int,
    pub _flags: ::std::os::raw::c_short,
    pub _file: ::std::os::raw::c_short,
    pub _bf: __sbuf,
    pub _lbfsize: ::std::os::raw::c_int,
    pub _cookie: *mut ::std::os::raw::c_void,
    pub _close: ::std::option::Option<
        unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    pub _read: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *mut ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub _seek: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: fpos_t,
            arg3: ::std::os::raw::c_int,
        ) -> fpos_t,
    >,
    pub _write: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub _ub: __sbuf,
    pub _extra: *mut __sFILEX,
    pub _ur: ::std::os::raw::c_int,
    pub _ubuf: [::std::os::raw::c_uchar; 3usize],
    pub _nbuf: [::std::os::raw::c_uchar; 1usize],
    pub _lb: __sbuf,
    pub _blksize: ::std::os::raw::c_int,
    pub _offset: fpos_t,
}
#[test]
fn bindgen_test_layout___sFILE() {
    assert_eq!(
        ::std::mem::size_of::<__sFILE>(),
        152usize,
        concat!("Size of: ", stringify!(__sFILE))
    );
    assert_eq!(
        ::std::mem::align_of::<__sFILE>(),
        8usize,
        concat!("Alignment of ", stringify!(__sFILE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._p as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._r as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_r)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._w as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_w)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._file as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._bf as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_bf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._lbfsize as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_lbfsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._cookie as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_cookie)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._close as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_close)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._read as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_read)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._seek as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_seek)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._write as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_write)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._ub as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_ub)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._extra as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_extra)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._ur as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_ur)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._ubuf as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_ubuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._nbuf as *const _ as usize },
        119usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_nbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._lb as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_lb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._blksize as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_blksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sFILE>()))._offset as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(__sFILE),
            "::",
            stringify!(_offset)
        )
    );
}
pub type FILE = __sFILE;
extern "C" {
    pub static mut __stdinp: *mut FILE;
}
extern "C" {
    pub static mut __stdoutp: *mut FILE;
}
extern "C" {
    pub static mut __stderrp: *mut FILE;
}
extern "C" {
    pub fn clearerr(arg1: *mut FILE);
}
extern "C" {
    pub fn fclose(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn feof(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetpos(arg1: *mut FILE, arg2: *mut fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgets(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *mut FILE,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fopen(
        __filename: *const ::std::os::raw::c_char,
        __mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fprintf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputs(arg1: *const ::std::os::raw::c_char, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fread(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __nitems: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn freopen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut FILE,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fscanf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fseek(
        arg1: *mut FILE,
        arg2: ::std::os::raw::c_long,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetpos(arg1: *mut FILE, arg2: *const fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftell(arg1: *mut FILE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn fwrite(
        __ptr: *const ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __nitems: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn getc(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gets(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn perror(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn printf(arg1: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn puts(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn remove(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rename(
        __old: *const ::std::os::raw::c_char,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rewind(arg1: *mut FILE);
}
extern "C" {
    pub fn scanf(arg1: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuf(arg1: *mut FILE, arg2: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn setvbuf(
        arg1: *mut FILE,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sscanf(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tmpfile() -> *mut FILE;
}
extern "C" {
    pub fn tmpnam(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ungetc(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfprintf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vprintf(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fdopen(arg1: ::std::os::raw::c_int, arg2: *const ::std::os::raw::c_char) -> *mut FILE;
}
extern "C" {
    pub fn fileno(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pclose(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn popen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn __srget(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __svfscanf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __swbuf(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn flockfile(arg1: *mut FILE);
}
extern "C" {
    pub fn ftrylockfile(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn funlockfile(arg1: *mut FILE);
}
extern "C" {
    pub fn getc_unlocked(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar_unlocked() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc_unlocked(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar_unlocked(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getw(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putw(arg1: ::std::os::raw::c_int, arg2: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tempnam(
        __dir: *const ::std::os::raw::c_char,
        __prefix: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub type off_t = __darwin_off_t;
extern "C" {
    pub fn fseeko(
        __stream: *mut FILE,
        __offset: off_t,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftello(__stream: *mut FILE) -> off_t;
}
extern "C" {
    pub fn snprintf(
        __str: *mut ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfscanf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vscanf(
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsnprintf(
        __str: *mut ::std::os::raw::c_char,
        __size: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsscanf(
        __str: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        arg1: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dprintf(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vdprintf(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdelim(
        __linep: *mut *mut ::std::os::raw::c_char,
        __linecapp: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> ssize_t;
}
extern "C" {
    pub fn getline(
        __linep: *mut *mut ::std::os::raw::c_char,
        __linecapp: *mut size_t,
        __stream: *mut FILE,
    ) -> ssize_t;
}
extern "C" {
    pub fn fmemopen(
        __buf: *mut ::std::os::raw::c_void,
        __size: size_t,
        __mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn open_memstream(
        __bufp: *mut *mut ::std::os::raw::c_char,
        __sizep: *mut size_t,
    ) -> *mut FILE;
}
extern "C" {
    pub static sys_nerr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut sys_errlist: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub fn asprintf(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid_r(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fgetln(arg1: *mut FILE, arg2: *mut size_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fmtcheck(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn fpurge(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuffer(
        arg1: *mut FILE,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn setlinebuf(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vasprintf(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn zopen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> *mut FILE;
}
extern "C" {
    pub fn funopen(
        arg1: *const ::std::os::raw::c_void,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int,
        >,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int,
        >,
        arg4: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: fpos_t,
                arg3: ::std::os::raw::c_int,
            ) -> fpos_t,
        >,
        arg5: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
        >,
    ) -> *mut FILE;
}
extern "C" {
    pub fn __sprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: size_t,
        arg4: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __snprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: ::std::os::raw::c_int,
        arg4: size_t,
        arg5: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __vsprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: size_t,
        arg4: *const ::std::os::raw::c_char,
        arg5: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __vsnprintf_chk(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: ::std::os::raw::c_int,
        arg4: size_t,
        arg5: *const ::std::os::raw::c_char,
        arg6: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
#[doc = "< All okay"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_SUCCESS:
    e_fiftyone_degrees_status_code = 0;
#[doc = "< Lack of memory"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_INSUFFICIENT_MEMORY:
    e_fiftyone_degrees_status_code = 1;
#[doc = "< Data structure not readable"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_CORRUPT_DATA:
    e_fiftyone_degrees_status_code = 2;
#[doc = "< Data not the required"]
#[doc = "version"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_INCORRECT_VERSION:
    e_fiftyone_degrees_status_code = 3;
#[doc = "< The data file couldn't be"]
#[doc = "found"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_FILE_NOT_FOUND:
    e_fiftyone_degrees_status_code = 4;
#[doc = "< The data file was busy"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_FILE_BUSY:
    e_fiftyone_degrees_status_code = 5;
#[doc = "< Unknown file error"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_FILE_FAILURE:
    e_fiftyone_degrees_status_code = 6;
#[doc = "< Should never be returned to the"]
#[doc = "caller"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_NOT_SET:
    e_fiftyone_degrees_status_code = 7;
#[doc = "< Working pointer"]
#[doc = "exceeded the amount of"]
#[doc = "memory containing the data"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_POINTER_OUT_OF_BOUNDS:
    e_fiftyone_degrees_status_code = 8;
#[doc = "< A key pointer was not set"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_NULL_POINTER:
    e_fiftyone_degrees_status_code = 9;
#[doc = "< Too many files are open"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_TOO_MANY_OPEN_FILES:
    e_fiftyone_degrees_status_code = 10;
#[doc = "< None of the required"]
#[doc = "properties could be found"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_REQ_PROP_NOT_PRESENT:
    e_fiftyone_degrees_status_code = 11;
#[doc = "< The profile id represents an"]
#[doc = "empty profile"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_PROFILE_EMPTY:
    e_fiftyone_degrees_status_code = 12;
#[doc = "< There was an error getting"]
#[doc = "an item from a collection"]
#[doc = "due to too many concurrent"]
#[doc = "operations"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_COLLECTION_FAILURE:
    e_fiftyone_degrees_status_code = 13;
#[doc = "< The data file could not be"]
#[doc = "copied"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_FILE_COPY_ERROR:
    e_fiftyone_degrees_status_code = 14;
#[doc = "< The file or directory"]
#[doc = "already exists, so could not be"]
#[doc = "created"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_FILE_EXISTS_ERROR:
    e_fiftyone_degrees_status_code = 15;
#[doc = "< The data file could not be"]
#[doc = "created"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_FILE_WRITE_ERROR:
    e_fiftyone_degrees_status_code = 16;
#[doc = "< File permission denied"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_FILE_PERMISSION_DENIED:
    e_fiftyone_degrees_status_code = 17;
#[doc = "< The file path is longer"]
#[doc = "than the available memory"]
#[doc = "available to store it"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_FILE_PATH_TOO_LONG:
    e_fiftyone_degrees_status_code = 18;
#[doc = "< There was an error encoding"]
#[doc = "characters of a string"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_ENCODING_ERROR:
    e_fiftyone_degrees_status_code = 19;
#[doc = "< The configuration"]
#[doc = "provided to create a"]
#[doc = "collection could not be"]
#[doc = "used to create a valid"]
#[doc = "collection"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_INVALID_COLLECTION_CONFIG:
    e_fiftyone_degrees_status_code = 20;
#[doc = "< An invalid config was provided"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_INVALID_CONFIG:
    e_fiftyone_degrees_status_code = 21;
#[doc = "< There were not enough"]
#[doc = "handles available to"]
#[doc = "retrieve data from the"]
#[doc = "source"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_INSUFFICIENT_HANDLES:
    e_fiftyone_degrees_status_code = 22;
#[doc = "< Index out of"]
#[doc = "range"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_COLLECTION_INDEX_OUT_OF_RANGE:
    e_fiftyone_degrees_status_code = 23;
#[doc = "< Offset out of"]
#[doc = "range"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_COLLECTION_OFFSET_OUT_OF_RANGE:
    e_fiftyone_degrees_status_code = 24;
#[doc = "< Seek failure"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_COLLECTION_FILE_SEEK_FAIL:
    e_fiftyone_degrees_status_code = 25;
#[doc = "< Read failure"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_COLLECTION_FILE_READ_FAIL:
    e_fiftyone_degrees_status_code = 26;
#[doc = "< IP address"]
#[doc = "format is incorrect"]
pub const e_fiftyone_degrees_status_code_FIFTYONE_DEGREES_STATUS_INCORRECT_IP_ADDRESS_FORMAT:
    e_fiftyone_degrees_status_code = 27;
#[doc = " Status returned from the initialisation of a resource."]
pub type e_fiftyone_degrees_status_code = ::std::os::raw::c_uint;
#[doc = " Status returned from the initialisation of a resource."]
pub use self::e_fiftyone_degrees_status_code as fiftyoneDegreesStatusCode;
extern "C" {
    #[doc = " Returns an English error message for the status code allocating memory"]
    #[doc = " needed to store the message. The caller must free the memory when they have"]
    #[doc = " finished consuming the error message."]
    #[doc = " @param status code to get the message for"]
    #[doc = " @param fileName the source file used for initialisation, or NULL if not"]
    #[doc = " applicable to the status code"]
    #[doc = " @return pointer to the newly allocated message string"]
    pub fn fiftyoneDegreesStatusGetMessage(
        status: fiftyoneDegreesStatusCode,
        fileName: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
#[doc = " Structure used to represent a 51Degrees exception and passed into methods"]
#[doc = " that might generate exceptions. The #FIFTYONE_DEGREES_EXCEPTION_SET macro"]
#[doc = " should be used to set the status code."]
#[doc = " @param exception pointer to an exception data structure to be used if an"]
#[doc = " exception occurs. See exceptions.h."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_exception_t {
    #[doc = "< File generating the exception"]
    pub file: *const ::std::os::raw::c_char,
    #[doc = "< Function generating the exception"]
    pub func: *const ::std::os::raw::c_char,
    #[doc = "< Line number generating the exception"]
    pub line: ::std::os::raw::c_int,
    #[doc = "< Status code to assign"]
    pub status: fiftyoneDegreesStatusCode,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_exception_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_exception_t>(),
        24usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_exception_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_exception_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_exception_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_exception_t>())).file as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_exception_t),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_exception_t>())).func as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_exception_t),
            "::",
            stringify!(func)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_exception_t>())).line as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_exception_t),
            "::",
            stringify!(line)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_exception_t>())).status as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_exception_t),
            "::",
            stringify!(status)
        )
    );
}
#[doc = " Structure used to represent a 51Degrees exception and passed into methods"]
#[doc = " that might generate exceptions. The #FIFTYONE_DEGREES_EXCEPTION_SET macro"]
#[doc = " should be used to set the status code."]
#[doc = " @param exception pointer to an exception data structure to be used if an"]
#[doc = " exception occurs. See exceptions.h."]
pub type fiftyoneDegreesException = fiftyone_degrees_exception_t;
extern "C" {
    #[doc = " Returns an English error message for the exception. The caller must free the"]
    #[doc = " memory when they have finished consuming the error message."]
    #[doc = " @param exception to get a string message from"]
    #[doc = " @return pointer to the newly allocated message string"]
    pub fn fiftyoneDegreesExceptionGetMessage(
        exception: *mut fiftyoneDegreesException,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " If the exception is set then will print a message to stderr and exit the"]
    #[doc = " process."]
    #[doc = " @param exception to check and exit if set"]
    pub fn fiftyoneDegreesExceptionCheckAndExit(exception: *mut fiftyoneDegreesException);
}
pub type wchar_t = ::std::os::raw::c_int;
pub type max_align_t = u128;
#[doc = " Alias for unsigned char"]
pub type byte = ::std::os::raw::c_uchar;
#[doc = " Data structure used for reusing memory which may have been allocated in a"]
#[doc = " previous operation."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_data_t {
    #[doc = "< Pointer to immutable data"]
    pub ptr: *mut byte,
    #[doc = "< Number of bytes allocated at the pointer. Used"]
    #[doc = "within the collection and is not intended for"]
    #[doc = "consumers to reference."]
    pub allocated: u32,
    #[doc = "< Number of valid bytes currently referenced by pointer"]
    pub used: u32,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_data_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_data_t>(),
        16usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_data_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_data_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_data_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_data_t>())).ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_data_t),
            "::",
            stringify!(ptr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_data_t>())).allocated as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_data_t),
            "::",
            stringify!(allocated)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_data_t>())).used as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_data_t),
            "::",
            stringify!(used)
        )
    );
}
#[doc = " Data structure used for reusing memory which may have been allocated in a"]
#[doc = " previous operation."]
pub type fiftyoneDegreesData = fiftyone_degrees_data_t;
extern "C" {
    #[doc = " Resets the data structure ready for a new operation. **MUST** be called"]
    #[doc = " before using an instance of #fiftyoneDegreesData."]
    #[doc = " @param data to be reset"]
    pub fn fiftyoneDegreesDataReset(data: *mut fiftyoneDegreesData);
}
extern "C" {
    #[doc = " Ensures the data structure contains sufficient bytes. If insufficient bytes"]
    #[doc = " are available then the current memory is freed and a new block of memory is"]
    #[doc = " allocated."]
    #[doc = " @param data pointer to the data structure to be checked for sufficient bytes"]
    #[doc = " @param bytesNeeded the number of bytes the data needs to be able to store"]
    #[doc = " @return a pointer to the memory held within data"]
    pub fn fiftyoneDegreesDataMalloc(
        data: *mut fiftyoneDegreesData,
        bytesNeeded: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
pub const idtype_t_P_ALL: idtype_t = 0;
pub const idtype_t_P_PID: idtype_t = 1;
pub const idtype_t_P_PGID: idtype_t = 2;
pub type idtype_t = ::std::os::raw::c_uint;
pub type pid_t = __darwin_pid_t;
pub type id_t = __darwin_id_t;
pub type sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_thread_state {
    pub __eax: ::std::os::raw::c_uint,
    pub __ebx: ::std::os::raw::c_uint,
    pub __ecx: ::std::os::raw::c_uint,
    pub __edx: ::std::os::raw::c_uint,
    pub __edi: ::std::os::raw::c_uint,
    pub __esi: ::std::os::raw::c_uint,
    pub __ebp: ::std::os::raw::c_uint,
    pub __esp: ::std::os::raw::c_uint,
    pub __ss: ::std::os::raw::c_uint,
    pub __eflags: ::std::os::raw::c_uint,
    pub __eip: ::std::os::raw::c_uint,
    pub __cs: ::std::os::raw::c_uint,
    pub __ds: ::std::os::raw::c_uint,
    pub __es: ::std::os::raw::c_uint,
    pub __fs: ::std::os::raw::c_uint,
    pub __gs: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___darwin_i386_thread_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_thread_state>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_i386_thread_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_thread_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_thread_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eax as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ebx as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ebx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ecx as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ecx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__edx as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__edx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__edi as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__edi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__esi as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__esi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ebp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ebp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__esp as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__esp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ss as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eflags as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eflags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eip as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__cs as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__cs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ds as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ds)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__es as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__fs as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__fs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__gs as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__gs)
        )
    );
}
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_fp_control {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout___darwin_fp_control() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_fp_control>(),
        2usize,
        concat!("Size of: ", stringify!(__darwin_fp_control))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_fp_control>(),
        2usize,
        concat!("Alignment of ", stringify!(__darwin_fp_control))
    );
}
impl __darwin_fp_control {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __pc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___pc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn __rc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___rc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __pc: ::std::os::raw::c_ushort,
        __rc: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(8usize, 2u8, {
            let __pc: u16 = unsafe { ::std::mem::transmute(__pc) };
            __pc as u64
        });
        __bindgen_bitfield_unit.set(10usize, 2u8, {
            let __rc: u16 = unsafe { ::std::mem::transmute(__rc) };
            __rc as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_control_t = __darwin_fp_control;
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_fp_status {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout___darwin_fp_status() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_fp_status>(),
        2usize,
        concat!("Size of: ", stringify!(__darwin_fp_status))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_fp_status>(),
        2usize,
        concat!("Alignment of ", stringify!(__darwin_fp_status))
    );
}
impl __darwin_fp_status {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __stkflt(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___stkflt(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __errsumm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___errsumm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c0(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c0(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c1(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c1(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c2(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c2(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __tos(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 3u8) as u16) }
    }
    #[inline]
    pub fn set___tos(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn __c3(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c3(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __busy(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___busy(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __stkflt: ::std::os::raw::c_ushort,
        __errsumm: ::std::os::raw::c_ushort,
        __c0: ::std::os::raw::c_ushort,
        __c1: ::std::os::raw::c_ushort,
        __c2: ::std::os::raw::c_ushort,
        __tos: ::std::os::raw::c_ushort,
        __c3: ::std::os::raw::c_ushort,
        __busy: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let __stkflt: u16 = unsafe { ::std::mem::transmute(__stkflt) };
            __stkflt as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let __errsumm: u16 = unsafe { ::std::mem::transmute(__errsumm) };
            __errsumm as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let __c0: u16 = unsafe { ::std::mem::transmute(__c0) };
            __c0 as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let __c1: u16 = unsafe { ::std::mem::transmute(__c1) };
            __c1 as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let __c2: u16 = unsafe { ::std::mem::transmute(__c2) };
            __c2 as u64
        });
        __bindgen_bitfield_unit.set(11usize, 3u8, {
            let __tos: u16 = unsafe { ::std::mem::transmute(__tos) };
            __tos as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let __c3: u16 = unsafe { ::std::mem::transmute(__c3) };
            __c3 as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let __busy: u16 = unsafe { ::std::mem::transmute(__busy) };
            __busy as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_status_t = __darwin_fp_status;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mmst_reg {
    pub __mmst_reg: [::std::os::raw::c_char; 10usize],
    pub __mmst_rsrv: [::std::os::raw::c_char; 6usize],
}
#[test]
fn bindgen_test_layout___darwin_mmst_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mmst_reg>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_mmst_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mmst_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_mmst_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mmst_reg>())).__mmst_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mmst_reg),
            "::",
            stringify!(__mmst_reg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mmst_reg>())).__mmst_rsrv as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mmst_reg),
            "::",
            stringify!(__mmst_rsrv)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_xmm_reg {
    pub __xmm_reg: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout___darwin_xmm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_xmm_reg>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_xmm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_xmm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_xmm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_xmm_reg>())).__xmm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_xmm_reg),
            "::",
            stringify!(__xmm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ymm_reg {
    pub __ymm_reg: [::std::os::raw::c_char; 32usize],
}
#[test]
fn bindgen_test_layout___darwin_ymm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_ymm_reg>(),
        32usize,
        concat!("Size of: ", stringify!(__darwin_ymm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_ymm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_ymm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ymm_reg>())).__ymm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ymm_reg),
            "::",
            stringify!(__ymm_reg)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_zmm_reg {
    pub __zmm_reg: [::std::os::raw::c_char; 64usize],
}
#[test]
fn bindgen_test_layout___darwin_zmm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_zmm_reg>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_zmm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_zmm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_zmm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_zmm_reg>())).__zmm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_zmm_reg),
            "::",
            stringify!(__zmm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_opmask_reg {
    pub __opmask_reg: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout___darwin_opmask_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_opmask_reg>(),
        8usize,
        concat!("Size of: ", stringify!(__darwin_opmask_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_opmask_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_opmask_reg))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_opmask_reg>())).__opmask_reg as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_opmask_reg),
            "::",
            stringify!(__opmask_reg)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_i386_float_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_i386_float_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_float_state>(),
        524usize,
        concat!("Size of: ", stringify!(__darwin_i386_float_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_float_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_float_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_i386_avx_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_i386_avx_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_avx_state>(),
        716usize,
        concat!("Size of: ", stringify!(__darwin_i386_avx_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_avx_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_avx_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_mxcsrmask as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_reserved1 as *const _ as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__avx_reserved1 as *const _ as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_i386_avx512_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
}
#[test]
fn bindgen_test_layout___darwin_i386_avx512_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_avx512_state>(),
        1036usize,
        concat!("Size of: ", stringify!(__darwin_i386_avx512_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_avx512_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_avx512_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k0 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k1 as *const _ as usize
        },
        724usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k2 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k3 as *const _ as usize
        },
        740usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k4 as *const _ as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k5 as *const _ as usize
        },
        756usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k6 as *const _ as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k7 as *const _ as usize
        },
        772usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh0 as *const _ as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh1 as *const _ as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh2 as *const _ as usize
        },
        844usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh3 as *const _ as usize
        },
        876usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh4 as *const _ as usize
        },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh5 as *const _ as usize
        },
        940usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh6 as *const _ as usize
        },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh7 as *const _ as usize
        },
        1004usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_exception_state {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint32_t,
}
#[test]
fn bindgen_test_layout___darwin_i386_exception_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_exception_state>(),
        12usize,
        concat!("Size of: ", stringify!(__darwin_i386_exception_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_exception_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_exception_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__trapno as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__trapno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__cpu as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__cpu)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__err as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__err)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__faultvaddr as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__faultvaddr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_debug_state32 {
    pub __dr0: ::std::os::raw::c_uint,
    pub __dr1: ::std::os::raw::c_uint,
    pub __dr2: ::std::os::raw::c_uint,
    pub __dr3: ::std::os::raw::c_uint,
    pub __dr4: ::std::os::raw::c_uint,
    pub __dr5: ::std::os::raw::c_uint,
    pub __dr6: ::std::os::raw::c_uint,
    pub __dr7: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___darwin_x86_debug_state32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_debug_state32>(),
        32usize,
        concat!("Size of: ", stringify!(__darwin_x86_debug_state32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_debug_state32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_debug_state32))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr0 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr1 as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr2 as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr3 as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr4 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr5 as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr6 as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr7 as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr7)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __x86_instruction_state {
    pub __insn_stream_valid_bytes: ::std::os::raw::c_int,
    pub __insn_offset: ::std::os::raw::c_int,
    pub __out_of_synch: ::std::os::raw::c_int,
    pub __insn_bytes: [__uint8_t; 2380usize],
    pub __insn_cacheline: [__uint8_t; 64usize],
}
#[test]
fn bindgen_test_layout___x86_instruction_state() {
    assert_eq!(
        ::std::mem::size_of::<__x86_instruction_state>(),
        2456usize,
        concat!("Size of: ", stringify!(__x86_instruction_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__x86_instruction_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__x86_instruction_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__x86_instruction_state>())).__insn_stream_valid_bytes
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__insn_stream_valid_bytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__x86_instruction_state>())).__insn_offset as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__insn_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__x86_instruction_state>())).__out_of_synch as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__out_of_synch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__x86_instruction_state>())).__insn_bytes as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__insn_bytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__x86_instruction_state>())).__insn_cacheline as *const _
                as usize
        },
        2392usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__insn_cacheline)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __last_branch_record {
    pub __from_ip: __uint64_t,
    pub __to_ip: __uint64_t,
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub __bindgen_padding_0: u32,
}
#[test]
fn bindgen_test_layout___last_branch_record() {
    assert_eq!(
        ::std::mem::size_of::<__last_branch_record>(),
        24usize,
        concat!("Size of: ", stringify!(__last_branch_record))
    );
    assert_eq!(
        ::std::mem::align_of::<__last_branch_record>(),
        8usize,
        concat!("Alignment of ", stringify!(__last_branch_record))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__last_branch_record>())).__from_ip as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__last_branch_record),
            "::",
            stringify!(__from_ip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__last_branch_record>())).__to_ip as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__last_branch_record),
            "::",
            stringify!(__to_ip)
        )
    );
}
impl __last_branch_record {
    #[inline]
    pub fn __mispredict(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___mispredict(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __tsx_abort(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___tsx_abort(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __in_tsx(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___in_tsx(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __cycle_count(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set___cycle_count(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn __reserved(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 13u8) as u32) }
    }
    #[inline]
    pub fn set___reserved(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 13u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __mispredict: __uint32_t,
        __tsx_abort: __uint32_t,
        __in_tsx: __uint32_t,
        __cycle_count: __uint32_t,
        __reserved: __uint32_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __mispredict: u32 = unsafe { ::std::mem::transmute(__mispredict) };
            __mispredict as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __tsx_abort: u32 = unsafe { ::std::mem::transmute(__tsx_abort) };
            __tsx_abort as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __in_tsx: u32 = unsafe { ::std::mem::transmute(__in_tsx) };
            __in_tsx as u64
        });
        __bindgen_bitfield_unit.set(3usize, 16u8, {
            let __cycle_count: u32 = unsafe { ::std::mem::transmute(__cycle_count) };
            __cycle_count as u64
        });
        __bindgen_bitfield_unit.set(19usize, 13u8, {
            let __reserved: u32 = unsafe { ::std::mem::transmute(__reserved) };
            __reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __last_branch_state {
    pub __lbr_count: ::std::os::raw::c_int,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub __lbrs: [__last_branch_record; 32usize],
}
#[test]
fn bindgen_test_layout___last_branch_state() {
    assert_eq!(
        ::std::mem::size_of::<__last_branch_state>(),
        776usize,
        concat!("Size of: ", stringify!(__last_branch_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__last_branch_state>(),
        8usize,
        concat!("Alignment of ", stringify!(__last_branch_state))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__last_branch_state>())).__lbr_count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__last_branch_state),
            "::",
            stringify!(__lbr_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__last_branch_state>())).__lbrs as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__last_branch_state),
            "::",
            stringify!(__lbrs)
        )
    );
}
impl __last_branch_state {
    #[inline]
    pub fn __lbr_supported_tsx(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___lbr_supported_tsx(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __lbr_supported_cycle_count(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___lbr_supported_cycle_count(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __reserved(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set___reserved(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __lbr_supported_tsx: __uint32_t,
        __lbr_supported_cycle_count: __uint32_t,
        __reserved: __uint32_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __lbr_supported_tsx: u32 = unsafe { ::std::mem::transmute(__lbr_supported_tsx) };
            __lbr_supported_tsx as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __lbr_supported_cycle_count: u32 =
                unsafe { ::std::mem::transmute(__lbr_supported_cycle_count) };
            __lbr_supported_cycle_count as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let __reserved: u32 = unsafe { ::std::mem::transmute(__reserved) };
            __reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __x86_pagein_state {
    pub __pagein_error: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___x86_pagein_state() {
    assert_eq!(
        ::std::mem::size_of::<__x86_pagein_state>(),
        4usize,
        concat!("Size of: ", stringify!(__x86_pagein_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__x86_pagein_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__x86_pagein_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__x86_pagein_state>())).__pagein_error as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_pagein_state),
            "::",
            stringify!(__pagein_error)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_state64 {
    pub __rax: __uint64_t,
    pub __rbx: __uint64_t,
    pub __rcx: __uint64_t,
    pub __rdx: __uint64_t,
    pub __rdi: __uint64_t,
    pub __rsi: __uint64_t,
    pub __rbp: __uint64_t,
    pub __rsp: __uint64_t,
    pub __r8: __uint64_t,
    pub __r9: __uint64_t,
    pub __r10: __uint64_t,
    pub __r11: __uint64_t,
    pub __r12: __uint64_t,
    pub __r13: __uint64_t,
    pub __r14: __uint64_t,
    pub __r15: __uint64_t,
    pub __rip: __uint64_t,
    pub __rflags: __uint64_t,
    pub __cs: __uint64_t,
    pub __fs: __uint64_t,
    pub __gs: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_thread_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_thread_state64>(),
        168usize,
        concat!("Size of: ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_thread_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rax as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rbx as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rcx as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rcx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rdx as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rdi as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rsi as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rbp as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rsp as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r8 as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r9 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r10 as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r11 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r12 as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r13 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r14 as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r15 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rip as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rflags as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rflags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__cs as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__fs as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__fs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__gs as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__gs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_full_state64 {
    pub __ss64: __darwin_x86_thread_state64,
    pub __ds: __uint64_t,
    pub __es: __uint64_t,
    pub __ss: __uint64_t,
    pub __gsbase: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_thread_full_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_thread_full_state64>(),
        200usize,
        concat!("Size of: ", stringify!(__darwin_x86_thread_full_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_thread_full_state64>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__darwin_x86_thread_full_state64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ss64 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ss64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ds as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__es as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ss as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__gsbase as *const _
                as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__gsbase)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_x86_float_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_x86_float_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_float_state64>(),
        524usize,
        concat!("Size of: ", stringify!(__darwin_x86_float_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_float_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_float_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_x86_avx_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_x86_avx_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_avx_state64>(),
        844usize,
        concat!("Size of: ", stringify!(__darwin_x86_avx_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_avx_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_avx_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh8 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh9 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh10 as *const _ as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh11 as *const _ as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh12 as *const _ as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh13 as *const _ as usize
        },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh14 as *const _ as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh15 as *const _ as usize
        },
        828usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh15)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_x86_avx512_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
    pub __fpu_zmmh8: __darwin_ymm_reg,
    pub __fpu_zmmh9: __darwin_ymm_reg,
    pub __fpu_zmmh10: __darwin_ymm_reg,
    pub __fpu_zmmh11: __darwin_ymm_reg,
    pub __fpu_zmmh12: __darwin_ymm_reg,
    pub __fpu_zmmh13: __darwin_ymm_reg,
    pub __fpu_zmmh14: __darwin_ymm_reg,
    pub __fpu_zmmh15: __darwin_ymm_reg,
    pub __fpu_zmm16: __darwin_zmm_reg,
    pub __fpu_zmm17: __darwin_zmm_reg,
    pub __fpu_zmm18: __darwin_zmm_reg,
    pub __fpu_zmm19: __darwin_zmm_reg,
    pub __fpu_zmm20: __darwin_zmm_reg,
    pub __fpu_zmm21: __darwin_zmm_reg,
    pub __fpu_zmm22: __darwin_zmm_reg,
    pub __fpu_zmm23: __darwin_zmm_reg,
    pub __fpu_zmm24: __darwin_zmm_reg,
    pub __fpu_zmm25: __darwin_zmm_reg,
    pub __fpu_zmm26: __darwin_zmm_reg,
    pub __fpu_zmm27: __darwin_zmm_reg,
    pub __fpu_zmm28: __darwin_zmm_reg,
    pub __fpu_zmm29: __darwin_zmm_reg,
    pub __fpu_zmm30: __darwin_zmm_reg,
    pub __fpu_zmm31: __darwin_zmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_x86_avx512_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_avx512_state64>(),
        2444usize,
        concat!("Size of: ", stringify!(__darwin_x86_avx512_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_avx512_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_avx512_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh8 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh9 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh10 as *const _
                as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh11 as *const _
                as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh12 as *const _
                as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh13 as *const _
                as usize
        },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh14 as *const _
                as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh15 as *const _
                as usize
        },
        828usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k0 as *const _ as usize
        },
        844usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k1 as *const _ as usize
        },
        852usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k2 as *const _ as usize
        },
        860usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k3 as *const _ as usize
        },
        868usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k4 as *const _ as usize
        },
        876usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k5 as *const _ as usize
        },
        884usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k6 as *const _ as usize
        },
        892usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k7 as *const _ as usize
        },
        900usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh0 as *const _ as usize
        },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh1 as *const _ as usize
        },
        940usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh2 as *const _ as usize
        },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh3 as *const _ as usize
        },
        1004usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh4 as *const _ as usize
        },
        1036usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh5 as *const _ as usize
        },
        1068usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh6 as *const _ as usize
        },
        1100usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh7 as *const _ as usize
        },
        1132usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh8 as *const _ as usize
        },
        1164usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh9 as *const _ as usize
        },
        1196usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh10 as *const _
                as usize
        },
        1228usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh11 as *const _
                as usize
        },
        1260usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh12 as *const _
                as usize
        },
        1292usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh13 as *const _
                as usize
        },
        1324usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh14 as *const _
                as usize
        },
        1356usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh15 as *const _
                as usize
        },
        1388usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm16 as *const _ as usize
        },
        1420usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm17 as *const _ as usize
        },
        1484usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm17)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm18 as *const _ as usize
        },
        1548usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm18)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm19 as *const _ as usize
        },
        1612usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm19)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm20 as *const _ as usize
        },
        1676usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm20)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm21 as *const _ as usize
        },
        1740usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm21)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm22 as *const _ as usize
        },
        1804usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm22)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm23 as *const _ as usize
        },
        1868usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm23)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm24 as *const _ as usize
        },
        1932usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm24)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm25 as *const _ as usize
        },
        1996usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm25)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm26 as *const _ as usize
        },
        2060usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm26)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm27 as *const _ as usize
        },
        2124usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm27)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm28 as *const _ as usize
        },
        2188usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm28)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm29 as *const _ as usize
        },
        2252usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm29)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm30 as *const _ as usize
        },
        2316usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm30)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm31 as *const _ as usize
        },
        2380usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm31)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_exception_state64 {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_exception_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_exception_state64>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_x86_exception_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_exception_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_exception_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__trapno as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__trapno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__cpu as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__cpu)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__err as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__err)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__faultvaddr as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__faultvaddr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_debug_state64 {
    pub __dr0: __uint64_t,
    pub __dr1: __uint64_t,
    pub __dr2: __uint64_t,
    pub __dr3: __uint64_t,
    pub __dr4: __uint64_t,
    pub __dr5: __uint64_t,
    pub __dr6: __uint64_t,
    pub __dr7: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_debug_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_debug_state64>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_x86_debug_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_debug_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_debug_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr0 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr1 as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr2 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr3 as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr4 as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr5 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr6 as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr7 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_cpmu_state64 {
    pub __ctrs: [__uint64_t; 16usize],
}
#[test]
fn bindgen_test_layout___darwin_x86_cpmu_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_cpmu_state64>(),
        128usize,
        concat!("Size of: ", stringify!(__darwin_x86_cpmu_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_cpmu_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_cpmu_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_cpmu_state64>())).__ctrs as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_cpmu_state64),
            "::",
            stringify!(__ctrs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_float_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext32>(),
        600usize,
        concat!("Size of: ", stringify!(__darwin_mcontext32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext32))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__ss as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__fs as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx32>(),
        792usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx32))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__ss as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__fs as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx512_32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx512_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_32>(),
        1112usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx512_32))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__ss as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__fs as *const _ as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_float_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext64>(),
        712usize,
        concat!("Size of: ", stringify!(__darwin_mcontext64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__fs as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_float_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext64_full>(),
        744usize,
        concat!("Size of: ", stringify!(__darwin_mcontext64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext64_full>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext64_full))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__fs as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx64>(),
        1032usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__fs as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx64_full>(),
        1064usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx64_full>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx64_full))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__fs as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx512_64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_64>(),
        2632usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx512_64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__fs as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __darwin_mcontext_avx512_64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_64_full>(),
        2664usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_64_full>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__darwin_mcontext_avx512_64_full)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__fs as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__fs)
        )
    );
}
pub type mcontext_t = *mut __darwin_mcontext64;
pub type pthread_attr_t = __darwin_pthread_attr_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_sigaltstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_size: __darwin_size_t,
    pub ss_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_sigaltstack() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_sigaltstack>(),
        24usize,
        concat!("Size of: ", stringify!(__darwin_sigaltstack))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_sigaltstack>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_sigaltstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_flags)
        )
    );
}
pub type stack_t = __darwin_sigaltstack;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ucontext {
    pub uc_onstack: ::std::os::raw::c_int,
    pub uc_sigmask: __darwin_sigset_t,
    pub uc_stack: __darwin_sigaltstack,
    pub uc_link: *mut __darwin_ucontext,
    pub uc_mcsize: __darwin_size_t,
    pub uc_mcontext: *mut __darwin_mcontext64,
}
#[test]
fn bindgen_test_layout___darwin_ucontext() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_ucontext>(),
        56usize,
        concat!("Size of: ", stringify!(__darwin_ucontext))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_ucontext>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_ucontext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_onstack as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_onstack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_sigmask as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_sigmask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_stack as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_link as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_link)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_mcsize as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_mcsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_mcontext as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_mcontext)
        )
    );
}
pub type ucontext_t = __darwin_ucontext;
pub type sigset_t = __darwin_sigset_t;
pub type uid_t = __darwin_uid_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_sigval() {
    assert_eq!(
        ::std::mem::size_of::<sigval>(),
        8usize,
        concat!("Size of: ", stringify!(sigval))
    );
    assert_eq!(
        ::std::mem::align_of::<sigval>(),
        8usize,
        concat!("Alignment of ", stringify!(sigval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_int as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_int)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_ptr)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_notify: ::std::os::raw::c_int,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_value: sigval,
    pub sigev_notify_function: ::std::option::Option<unsafe extern "C" fn(arg1: sigval)>,
    pub sigev_notify_attributes: *mut pthread_attr_t,
}
#[test]
fn bindgen_test_layout_sigevent() {
    assert_eq!(
        ::std::mem::size_of::<sigevent>(),
        32usize,
        concat!("Size of: ", stringify!(sigevent))
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent>(),
        8usize,
        concat!("Alignment of ", stringify!(sigevent))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_signo as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify_function as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_function)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigevent>())).sigev_notify_attributes as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_attributes)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __siginfo {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub si_pid: pid_t,
    pub si_uid: uid_t,
    pub si_status: ::std::os::raw::c_int,
    pub si_addr: *mut ::std::os::raw::c_void,
    pub si_value: sigval,
    pub si_band: ::std::os::raw::c_long,
    pub __pad: [::std::os::raw::c_ulong; 7usize],
}
#[test]
fn bindgen_test_layout___siginfo() {
    assert_eq!(
        ::std::mem::size_of::<__siginfo>(),
        104usize,
        concat!("Size of: ", stringify!(__siginfo))
    );
    assert_eq!(
        ::std::mem::align_of::<__siginfo>(),
        8usize,
        concat!("Alignment of ", stringify!(__siginfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_signo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_errno as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_errno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_code as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_pid as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_pid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_uid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_status as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_addr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_value as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_band as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_band)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).__pad as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(__pad)
        )
    );
}
pub type siginfo_t = __siginfo;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __sigaction_u {
    pub __sa_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub __sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut __siginfo,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
}
#[test]
fn bindgen_test_layout___sigaction_u() {
    assert_eq!(
        ::std::mem::size_of::<__sigaction_u>(),
        8usize,
        concat!("Size of: ", stringify!(__sigaction_u))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigaction_u>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigaction_u))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction_u>())).__sa_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction_u),
            "::",
            stringify!(__sa_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction_u>())).__sa_sigaction as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction_u),
            "::",
            stringify!(__sa_sigaction)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_tramp: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_int,
            arg4: *mut siginfo_t,
            arg5: *mut ::std::os::raw::c_void,
        ),
    >,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___sigaction() {
    assert_eq!(
        ::std::mem::size_of::<__sigaction>(),
        24usize,
        concat!("Size of: ", stringify!(__sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigaction))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).__sigaction_u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(__sigaction_u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_tramp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_tramp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_mask as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_flags as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigaction() {
    assert_eq!(
        ::std::mem::size_of::<sigaction>(),
        16usize,
        concat!("Size of: ", stringify!(sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(sigaction))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).__sigaction_u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(__sigaction_u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
}
pub type sig_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigvec {
    pub sv_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub sv_mask: ::std::os::raw::c_int,
    pub sv_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigvec() {
    assert_eq!(
        ::std::mem::size_of::<sigvec>(),
        16usize,
        concat!("Size of: ", stringify!(sigvec))
    );
    assert_eq!(
        ::std::mem::align_of::<sigvec>(),
        8usize,
        concat!("Alignment of ", stringify!(sigvec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigstack {
    pub ss_sp: *mut ::std::os::raw::c_char,
    pub ss_onstack: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigstack() {
    assert_eq!(
        ::std::mem::size_of::<sigstack>(),
        16usize,
        concat!("Size of: ", stringify!(sigstack))
    );
    assert_eq!(
        ::std::mem::align_of::<sigstack>(),
        8usize,
        concat!("Alignment of ", stringify!(sigstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_onstack as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_onstack)
        )
    );
}
extern "C" {
    pub fn signal(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __darwin_time_t,
    pub tv_usec: __darwin_suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
pub type rlim_t = __uint64_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage {
    pub ru_utime: timeval,
    pub ru_stime: timeval,
    pub ru_maxrss: ::std::os::raw::c_long,
    pub ru_ixrss: ::std::os::raw::c_long,
    pub ru_idrss: ::std::os::raw::c_long,
    pub ru_isrss: ::std::os::raw::c_long,
    pub ru_minflt: ::std::os::raw::c_long,
    pub ru_majflt: ::std::os::raw::c_long,
    pub ru_nswap: ::std::os::raw::c_long,
    pub ru_inblock: ::std::os::raw::c_long,
    pub ru_oublock: ::std::os::raw::c_long,
    pub ru_msgsnd: ::std::os::raw::c_long,
    pub ru_msgrcv: ::std::os::raw::c_long,
    pub ru_nsignals: ::std::os::raw::c_long,
    pub ru_nvcsw: ::std::os::raw::c_long,
    pub ru_nivcsw: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_rusage() {
    assert_eq!(
        ::std::mem::size_of::<rusage>(),
        144usize,
        concat!("Size of: ", stringify!(rusage))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_utime as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_utime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_stime as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_stime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_maxrss as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_maxrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_ixrss as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_ixrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_idrss as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_idrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_isrss as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_isrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_minflt as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_minflt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_majflt as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_majflt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nswap as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nswap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_inblock as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_inblock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_oublock as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_oublock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_msgsnd as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_msgsnd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_msgrcv as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_msgrcv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nsignals as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nsignals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nvcsw as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nvcsw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nivcsw as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nivcsw)
        )
    );
}
pub type rusage_info_t = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v0 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v0() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v0>(),
        96usize,
        concat!("Size of: ", stringify!(rusage_info_v0))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v0>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v0))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v1 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v1() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v1>(),
        144usize,
        concat!("Size of: ", stringify!(rusage_info_v1))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v1>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v2 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v2() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v2>(),
        160usize,
        concat!("Size of: ", stringify!(rusage_info_v2))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v2>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v3 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v3() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v3>(),
        232usize,
        concat!("Size of: ", stringify!(rusage_info_v3))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v3>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v3))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_default as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_default)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_maintenance as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_maintenance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_background as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_utility as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_utility)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_legacy as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_legacy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_user_initiated as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_user_initiated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_user_interactive as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_user_interactive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_billed_system_time as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_billed_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_serviced_system_time as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_serviced_system_time)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v4 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
    pub ri_logical_writes: u64,
    pub ri_lifetime_max_phys_footprint: u64,
    pub ri_instructions: u64,
    pub ri_cycles: u64,
    pub ri_billed_energy: u64,
    pub ri_serviced_energy: u64,
    pub ri_interval_max_phys_footprint: u64,
    pub ri_runnable_time: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v4() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v4>(),
        296usize,
        concat!("Size of: ", stringify!(rusage_info_v4))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v4>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v4))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_default as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_default)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_maintenance as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_maintenance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_background as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_utility as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_utility)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_legacy as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_legacy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_user_initiated as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_user_initiated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_user_interactive as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_user_interactive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_billed_system_time as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_billed_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_serviced_system_time as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_serviced_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_logical_writes as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_logical_writes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_lifetime_max_phys_footprint as *const _
                as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_lifetime_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_instructions as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_instructions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_cycles as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cycles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_billed_energy as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_billed_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_serviced_energy as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_serviced_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_interval_max_phys_footprint as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_interval_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_runnable_time as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_runnable_time)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_info_v5 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
    pub ri_logical_writes: u64,
    pub ri_lifetime_max_phys_footprint: u64,
    pub ri_instructions: u64,
    pub ri_cycles: u64,
    pub ri_billed_energy: u64,
    pub ri_serviced_energy: u64,
    pub ri_interval_max_phys_footprint: u64,
    pub ri_runnable_time: u64,
    pub ri_flags: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v5() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v5>(),
        304usize,
        concat!("Size of: ", stringify!(rusage_info_v5))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v5>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v5))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_default as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_default)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_maintenance as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_maintenance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_background as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_utility as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_utility)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_legacy as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_legacy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_user_initiated as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_user_initiated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_user_interactive as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_user_interactive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_billed_system_time as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_billed_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_serviced_system_time as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_serviced_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_logical_writes as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_logical_writes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_lifetime_max_phys_footprint as *const _
                as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_lifetime_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_instructions as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_instructions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_cycles as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cycles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_billed_energy as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_billed_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_serviced_energy as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_serviced_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_interval_max_phys_footprint as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_interval_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_runnable_time as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_runnable_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_flags as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_flags)
        )
    );
}
pub type rusage_info_current = rusage_info_v5;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rlimit {
    pub rlim_cur: rlim_t,
    pub rlim_max: rlim_t,
}
#[test]
fn bindgen_test_layout_rlimit() {
    assert_eq!(
        ::std::mem::size_of::<rlimit>(),
        16usize,
        concat!("Size of: ", stringify!(rlimit))
    );
    assert_eq!(
        ::std::mem::align_of::<rlimit>(),
        8usize,
        concat!("Alignment of ", stringify!(rlimit))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rlimit>())).rlim_cur as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rlimit),
            "::",
            stringify!(rlim_cur)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rlimit>())).rlim_max as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rlimit),
            "::",
            stringify!(rlim_max)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc_rlimit_control_wakeupmon {
    pub wm_flags: u32,
    pub wm_rate: i32,
}
#[test]
fn bindgen_test_layout_proc_rlimit_control_wakeupmon() {
    assert_eq!(
        ::std::mem::size_of::<proc_rlimit_control_wakeupmon>(),
        8usize,
        concat!("Size of: ", stringify!(proc_rlimit_control_wakeupmon))
    );
    assert_eq!(
        ::std::mem::align_of::<proc_rlimit_control_wakeupmon>(),
        4usize,
        concat!("Alignment of ", stringify!(proc_rlimit_control_wakeupmon))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<proc_rlimit_control_wakeupmon>())).wm_flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(proc_rlimit_control_wakeupmon),
            "::",
            stringify!(wm_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<proc_rlimit_control_wakeupmon>())).wm_rate as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(proc_rlimit_control_wakeupmon),
            "::",
            stringify!(wm_rate)
        )
    );
}
extern "C" {
    pub fn getpriority(arg1: ::std::os::raw::c_int, arg2: id_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getiopolicy_np(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getrlimit(arg1: ::std::os::raw::c_int, arg2: *mut rlimit) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getrusage(arg1: ::std::os::raw::c_int, arg2: *mut rusage) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setpriority(
        arg1: ::std::os::raw::c_int,
        arg2: id_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setiopolicy_np(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setrlimit(arg1: ::std::os::raw::c_int, arg2: *const rlimit) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union wait {
    pub w_status: ::std::os::raw::c_int,
    pub w_T: wait__bindgen_ty_1,
    pub w_S: wait__bindgen_ty_2,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_1))
    );
}
impl wait__bindgen_ty_1 {
    #[inline]
    pub fn w_Termsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_w_Termsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Coredump(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_w_Coredump(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Retcode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Retcode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Filler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_w_Filler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        w_Termsig: ::std::os::raw::c_uint,
        w_Coredump: ::std::os::raw::c_uint,
        w_Retcode: ::std::os::raw::c_uint,
        w_Filler: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 7u8, {
            let w_Termsig: u32 = unsafe { ::std::mem::transmute(w_Termsig) };
            w_Termsig as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let w_Coredump: u32 = unsafe { ::std::mem::transmute(w_Coredump) };
            w_Coredump as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let w_Retcode: u32 = unsafe { ::std::mem::transmute(w_Retcode) };
            w_Retcode as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let w_Filler: u32 = unsafe { ::std::mem::transmute(w_Filler) };
            w_Filler as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct wait__bindgen_ty_2 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_2))
    );
}
impl wait__bindgen_ty_2 {
    #[inline]
    pub fn w_Stopval(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Stopval(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Stopsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Stopsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Filler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_w_Filler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        w_Stopval: ::std::os::raw::c_uint,
        w_Stopsig: ::std::os::raw::c_uint,
        w_Filler: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let w_Stopval: u32 = unsafe { ::std::mem::transmute(w_Stopval) };
            w_Stopval as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let w_Stopsig: u32 = unsafe { ::std::mem::transmute(w_Stopsig) };
            w_Stopsig as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let w_Filler: u32 = unsafe { ::std::mem::transmute(w_Filler) };
            w_Filler as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_wait() {
    assert_eq!(
        ::std::mem::size_of::<wait>(),
        4usize,
        concat!("Size of: ", stringify!(wait))
    );
    assert_eq!(
        ::std::mem::align_of::<wait>(),
        4usize,
        concat!("Alignment of ", stringify!(wait))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_status as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(w_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_T as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(wait), "::", stringify!(w_T))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_S as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(wait), "::", stringify!(w_S))
    );
}
extern "C" {
    pub fn wait(arg1: *mut ::std::os::raw::c_int) -> pid_t;
}
extern "C" {
    pub fn waitpid(
        arg1: pid_t,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> pid_t;
}
extern "C" {
    pub fn waitid(
        arg1: idtype_t,
        arg2: id_t,
        arg3: *mut siginfo_t,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wait3(
        arg1: *mut ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: *mut rusage,
    ) -> pid_t;
}
extern "C" {
    pub fn wait4(
        arg1: pid_t,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut rusage,
    ) -> pid_t;
}
extern "C" {
    pub fn alloca(arg1: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
pub type ct_rune_t = __darwin_ct_rune_t;
pub type rune_t = __darwin_rune_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_div_t() {
    assert_eq!(
        ::std::mem::size_of::<div_t>(),
        8usize,
        concat!("Size of: ", stringify!(div_t))
    );
    assert_eq!(
        ::std::mem::align_of::<div_t>(),
        4usize,
        concat!("Alignment of ", stringify!(div_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).rem as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_ldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<ldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(ldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_lldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<lldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(lldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub static mut __mb_cur_max: ::std::os::raw::c_int;
}
extern "C" {
    pub fn malloc(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn calloc(
        __count: ::std::os::raw::c_ulong,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn free(arg1: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn realloc(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn valloc(arg1: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn aligned_alloc(__alignment: size_t, __size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn posix_memalign(
        __memptr: *mut *mut ::std::os::raw::c_void,
        __alignment: size_t,
        __size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn abort();
}
extern "C" {
    pub fn abs(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atexit(arg1: ::std::option::Option<unsafe extern "C" fn()>) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atof(arg1: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn atoi(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atol(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn atoll(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn bsearch(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn div(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> div_t;
}
extern "C" {
    pub fn exit(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn getenv(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn labs(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn ldiv(arg1: ::std::os::raw::c_long, arg2: ::std::os::raw::c_long) -> ldiv_t;
}
extern "C" {
    pub fn llabs(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn lldiv(arg1: ::std::os::raw::c_longlong, arg2: ::std::os::raw::c_longlong) -> lldiv_t;
}
extern "C" {
    pub fn mblen(__s: *const ::std::os::raw::c_char, __n: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbstowcs(
        arg1: *mut wchar_t,
        arg2: *const ::std::os::raw::c_char,
        arg3: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn mbtowc(
        arg1: *mut wchar_t,
        arg2: *const ::std::os::raw::c_char,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qsort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn rand() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand(arg1: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn strtod(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> f64;
}
extern "C" {
    pub fn strtof(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> f32;
}
extern "C" {
    pub fn strtol(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn strtold(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> u128;
}
extern "C" {
    pub fn strtoll(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtoul(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtoull(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn system(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcstombs(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const wchar_t,
        arg3: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn wctomb(arg1: *mut ::std::os::raw::c_char, arg2: wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _Exit(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn a64l(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn drand48() -> f64;
}
extern "C" {
    pub fn ecvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn erand48(arg1: *mut ::std::os::raw::c_ushort) -> f64;
}
extern "C" {
    pub fn fcvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gcvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getsubopt(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const *mut ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn grantpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn initstate(
        arg1: ::std::os::raw::c_uint,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn jrand48(arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn l64a(arg1: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn lcong48(arg1: *mut ::std::os::raw::c_ushort);
}
extern "C" {
    pub fn lrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn mktemp(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkstemp(arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn nrand48(arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn posix_openpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ptsname(arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ptsname_r(
        fildes: ::std::os::raw::c_int,
        buffer: *mut ::std::os::raw::c_char,
        buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putenv(arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn random() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rand_r(arg1: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_realpath$DARWIN_EXTSN"]
    pub fn realpath(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn seed48(arg1: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort;
}
extern "C" {
    pub fn setenv(
        __name: *const ::std::os::raw::c_char,
        __value: *const ::std::os::raw::c_char,
        __overwrite: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setkey(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn setstate(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn srand48(arg1: ::std::os::raw::c_long);
}
extern "C" {
    pub fn srandom(arg1: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn unlockpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unsetenv(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
pub type dev_t = __darwin_dev_t;
pub type mode_t = __darwin_mode_t;
extern "C" {
    pub fn arc4random() -> u32;
}
extern "C" {
    pub fn arc4random_addrandom(arg1: *mut ::std::os::raw::c_uchar, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn arc4random_buf(__buf: *mut ::std::os::raw::c_void, __nbytes: size_t);
}
extern "C" {
    pub fn arc4random_stir();
}
extern "C" {
    pub fn arc4random_uniform(__upper_bound: u32) -> u32;
}
extern "C" {
    pub fn atexit_b(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bsearch_b(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn cgetcap(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn cgetclose() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetent(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetfirst(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetmatch(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetnext(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetnum(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetset(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetstr(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetustr(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_daemon$1050"]
    pub fn daemon(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn devname(arg1: dev_t, arg2: mode_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn devname_r(
        arg1: dev_t,
        arg2: mode_t,
        buf: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getbsize(
        arg1: *mut ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_long,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getloadavg(arg1: *mut f64, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getprogname() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn setprogname(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn heapsort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn heapsort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mergesort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mergesort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn psort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn psort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn psort_r(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        arg1: *mut ::std::os::raw::c_void,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
                arg3: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn qsort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn qsort_r(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        arg1: *mut ::std::os::raw::c_void,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
                arg3: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn radixsort(
        __base: *mut *const ::std::os::raw::c_uchar,
        __nel: ::std::os::raw::c_int,
        __table: *const ::std::os::raw::c_uchar,
        __endbyte: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rpmatch(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sradixsort(
        __base: *mut *const ::std::os::raw::c_uchar,
        __nel: ::std::os::raw::c_int,
        __table: *const ::std::os::raw::c_uchar,
        __endbyte: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sranddev();
}
extern "C" {
    pub fn srandomdev();
}
extern "C" {
    pub fn reallocf(
        __ptr: *mut ::std::os::raw::c_void,
        __size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strtonum(
        __numstr: *const ::std::os::raw::c_char,
        __minval: ::std::os::raw::c_longlong,
        __maxval: ::std::os::raw::c_longlong,
        __errstrp: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtoq(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtouq(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub static mut suboptarg: *mut ::std::os::raw::c_char;
}
#[doc = " @cond FORWARD_DECLARATIONS"]
pub type fiftyoneDegreesTreeNode = fiftyone_degrees_tree_node_t;
#[doc = " Tree root structure defining the beginning of the tree."]
pub type fiftyoneDegreesTreeRoot = fiftyone_degrees_tree_root_t;
#[doc = " Node structure defining a single node in the tree."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_tree_node_t {
    #[doc = "< Numeric key associated with the data value"]
    pub key: i64,
    #[doc = "< The current root node of the tree"]
    pub root: *mut fiftyoneDegreesTreeRoot,
    #[doc = "< Parent node or NULL if root"]
    pub parent: *mut fiftyoneDegreesTreeNode,
    #[doc = "< Left node or NULL if none"]
    pub left: *mut fiftyoneDegreesTreeNode,
    #[doc = "< Right node or NULL if none"]
    pub right: *mut fiftyoneDegreesTreeNode,
    #[doc = "< The colour of the node in the red black tree"]
    pub colour: ::std::os::raw::c_uchar,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_tree_node_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_tree_node_t>(),
        48usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_tree_node_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_tree_node_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_tree_node_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_tree_node_t>())).key as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_tree_node_t),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_tree_node_t>())).root as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_tree_node_t),
            "::",
            stringify!(root)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_tree_node_t>())).parent as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_tree_node_t),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_tree_node_t>())).left as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_tree_node_t),
            "::",
            stringify!(left)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_tree_node_t>())).right as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_tree_node_t),
            "::",
            stringify!(right)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_tree_node_t>())).colour as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_tree_node_t),
            "::",
            stringify!(colour)
        )
    );
}
#[doc = " Tree root structure defining the beginning of the tree."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_tree_root_t {
    #[doc = "< The current root node of the tree"]
    pub root: fiftyoneDegreesTreeNode,
    #[doc = "< Empty tree node"]
    pub empty: fiftyoneDegreesTreeNode,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_tree_root_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_tree_root_t>(),
        96usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_tree_root_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_tree_root_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_tree_root_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_tree_root_t>())).root as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_tree_root_t),
            "::",
            stringify!(root)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_tree_root_t>())).empty as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_tree_root_t),
            "::",
            stringify!(empty)
        )
    );
}
#[doc = " Callback method called while iterating over a tree."]
#[doc = " @param state pointer to any data needed by the method"]
#[doc = " @param node at the current point in the tree"]
pub type fiftyoneDegreesTreeIterateMethod = ::std::option::Option<
    unsafe extern "C" fn(state: *mut ::std::os::raw::c_void, node: *mut fiftyoneDegreesTreeNode),
>;
extern "C" {
    pub static mut fiftyoneDegreesTreeEmpty: *mut fiftyoneDegreesTreeNode;
}
extern "C" {
    #[doc = " Used by assert statements to validate the number of entries in the cache for"]
    #[doc = " debugging should any changes be made to the logic. Should not be compiled in"]
    #[doc = " release builds."]
    #[doc = " @param root pointer to the node being counted."]
    #[doc = " @return the number of children plus 1 for this current node."]
    pub fn fiftyoneDegreesTreeCount(root: *mut fiftyoneDegreesTreeRoot) -> u32;
}
extern "C" {
    #[doc = " Removes the node from the tree so that it can be used again to store"]
    #[doc = " another result. The node will come from the last item in the cache's"]
    #[doc = " linked list."]
    #[doc = " @param node pointer to be deleted."]
    pub fn fiftyoneDegreesTreeDelete(node: *mut fiftyoneDegreesTreeNode);
}
extern "C" {
    #[doc = " Inserts the node into the red black tree."]
    #[doc = " @param node pointer to the node being inserted."]
    pub fn fiftyoneDegreesTreeInsert(node: *mut fiftyoneDegreesTreeNode);
}
extern "C" {
    #[doc = " Returns the node that matches the key code provided."]
    #[doc = " @param root of the tree to search in"]
    #[doc = " @param key to get the item for"]
    #[doc = " @return the corresponding node if it exists in the tree, otherwise NULL."]
    pub fn fiftyoneDegreesTreeFind(
        root: *mut fiftyoneDegreesTreeRoot,
        key: i64,
    ) -> *mut fiftyoneDegreesTreeNode;
}
extern "C" {
    #[doc = " Initialises a newly allocated node."]
    #[doc = " @param node to initialise"]
    #[doc = " @param root of the tree to which the node belongs"]
    pub fn fiftyoneDegreesTreeNodeInit(
        node: *mut fiftyoneDegreesTreeNode,
        root: *mut fiftyoneDegreesTreeRoot,
    );
}
extern "C" {
    #[doc = " Removes a node from the tree it belongs to."]
    #[doc = " @param node to remove"]
    pub fn fiftyoneDegreesTreeNodeRemove(node: *mut fiftyoneDegreesTreeNode);
}
extern "C" {
    #[doc = " Initialises a newly allocated tree root to a clean state."]
    #[doc = " @param root to initialise"]
    pub fn fiftyoneDegreesTreeRootInit(root: *mut fiftyoneDegreesTreeRoot);
}
extern "C" {
    #[doc = " Iterates over all the nodes in the tree starting at the root provided,"]
    #[doc = " calling the callback method with each node in the tree."]
    #[doc = " @param root of the tree to iterate"]
    #[doc = " @param state pointer to pass to the callback method"]
    #[doc = " @param callback method to call with each node"]
    pub fn fiftyoneDegreesTreeIterateNodes(
        root: *mut fiftyoneDegreesTreeRoot,
        state: *mut ::std::os::raw::c_void,
        callback: fiftyoneDegreesTreeIterateMethod,
    );
}
extern "C" {
    #[doc = " Determines if the methods that should be thread safe have been compiled so"]
    #[doc = " they are thread safe. In single threaded operation compiling without"]
    #[doc = " threading using the `FIFTYONE_DEGREES_NO_THREADING` directive results in"]
    #[doc = " performance improvements."]
    #[doc = " @return true if the library is thread safe, otherwise false."]
    pub fn fiftyoneDegreesThreadingGetIsThreadSafe() -> bool;
}
pub type FIFTYONE_DEGREES_THREAD_ROUTINE = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sched_param {
    pub sched_priority: ::std::os::raw::c_int,
    pub __opaque: [::std::os::raw::c_char; 4usize],
}
#[test]
fn bindgen_test_layout_sched_param() {
    assert_eq!(
        ::std::mem::size_of::<sched_param>(),
        8usize,
        concat!("Size of: ", stringify!(sched_param))
    );
    assert_eq!(
        ::std::mem::align_of::<sched_param>(),
        4usize,
        concat!("Alignment of ", stringify!(sched_param))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sched_param>())).sched_priority as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sched_param),
            "::",
            stringify!(sched_priority)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sched_param>())).__opaque as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sched_param),
            "::",
            stringify!(__opaque)
        )
    );
}
extern "C" {
    pub fn sched_yield() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_get_priority_min(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sched_get_priority_max(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
pub type clock_t = __darwin_clock_t;
pub type time_t = __darwin_time_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __darwin_time_t,
    pub tv_nsec: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_timespec() {
    assert_eq!(
        ::std::mem::size_of::<timespec>(),
        16usize,
        concat!("Size of: ", stringify!(timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(timespec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_nsec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_tm() {
    assert_eq!(
        ::std::mem::size_of::<tm>(),
        56usize,
        concat!("Size of: ", stringify!(tm))
    );
    assert_eq!(
        ::std::mem::align_of::<tm>(),
        8usize,
        concat!("Alignment of ", stringify!(tm))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_min as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_hour as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_hour)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_mday as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_mon as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_mon)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_year as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_year)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_wday as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_wday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_yday as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_yday)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_isdst as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_isdst)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_gmtoff as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_gmtoff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tm>())).tm_zone as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(tm),
            "::",
            stringify!(tm_zone)
        )
    );
}
extern "C" {
    pub static mut tzname: [*mut ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static mut getdate_err: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut timezone: ::std::os::raw::c_long;
}
extern "C" {
    pub static mut daylight: ::std::os::raw::c_int;
}
extern "C" {
    pub fn asctime(arg1: *const tm) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn clock() -> clock_t;
}
extern "C" {
    pub fn ctime(arg1: *const time_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn difftime(arg1: time_t, arg2: time_t) -> f64;
}
extern "C" {
    pub fn getdate(arg1: *const ::std::os::raw::c_char) -> *mut tm;
}
extern "C" {
    pub fn gmtime(arg1: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn localtime(arg1: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn mktime(arg1: *mut tm) -> time_t;
}
extern "C" {
    pub fn strftime(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const tm,
    ) -> size_t;
}
extern "C" {
    pub fn strptime(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut tm,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn time(arg1: *mut time_t) -> time_t;
}
extern "C" {
    pub fn tzset();
}
extern "C" {
    pub fn asctime_r(
        arg1: *const tm,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ctime_r(
        arg1: *const time_t,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gmtime_r(arg1: *const time_t, arg2: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn localtime_r(arg1: *const time_t, arg2: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn posix2time(arg1: time_t) -> time_t;
}
extern "C" {
    pub fn tzsetwall();
}
extern "C" {
    pub fn time2posix(arg1: time_t) -> time_t;
}
extern "C" {
    pub fn timelocal(arg1: *mut tm) -> time_t;
}
extern "C" {
    pub fn timegm(arg1: *mut tm) -> time_t;
}
extern "C" {
    pub fn nanosleep(__rqtp: *const timespec, __rmtp: *mut timespec) -> ::std::os::raw::c_int;
}
pub const clockid_t__CLOCK_REALTIME: clockid_t = 0;
pub const clockid_t__CLOCK_MONOTONIC: clockid_t = 6;
pub const clockid_t__CLOCK_MONOTONIC_RAW: clockid_t = 4;
pub const clockid_t__CLOCK_MONOTONIC_RAW_APPROX: clockid_t = 5;
pub const clockid_t__CLOCK_UPTIME_RAW: clockid_t = 8;
pub const clockid_t__CLOCK_UPTIME_RAW_APPROX: clockid_t = 9;
pub const clockid_t__CLOCK_PROCESS_CPUTIME_ID: clockid_t = 12;
pub const clockid_t__CLOCK_THREAD_CPUTIME_ID: clockid_t = 16;
pub type clockid_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn clock_getres(__clock_id: clockid_t, __res: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_gettime(__clock_id: clockid_t, __tp: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_gettime_nsec_np(__clock_id: clockid_t) -> __uint64_t;
}
extern "C" {
    pub fn clock_settime(__clock_id: clockid_t, __tp: *const timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timespec_get(ts: *mut timespec, base: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
pub type pthread_cond_t = __darwin_pthread_cond_t;
pub type pthread_condattr_t = __darwin_pthread_condattr_t;
pub type pthread_key_t = __darwin_pthread_key_t;
pub type pthread_mutex_t = __darwin_pthread_mutex_t;
pub type pthread_mutexattr_t = __darwin_pthread_mutexattr_t;
pub type pthread_once_t = __darwin_pthread_once_t;
pub type pthread_rwlock_t = __darwin_pthread_rwlock_t;
pub type pthread_rwlockattr_t = __darwin_pthread_rwlockattr_t;
pub type pthread_t = __darwin_pthread_t;
pub const QOS_CLASS_USER_INTERACTIVE: ::std::os::raw::c_uint = 33;
pub const QOS_CLASS_USER_INITIATED: ::std::os::raw::c_uint = 25;
pub const QOS_CLASS_DEFAULT: ::std::os::raw::c_uint = 21;
pub const QOS_CLASS_UTILITY: ::std::os::raw::c_uint = 17;
pub const QOS_CLASS_BACKGROUND: ::std::os::raw::c_uint = 9;
pub const QOS_CLASS_UNSPECIFIED: ::std::os::raw::c_uint = 0;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
pub type qos_class_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn qos_class_self() -> qos_class_t;
}
extern "C" {
    pub fn qos_class_main() -> qos_class_t;
}
extern "C" {
    pub fn pthread_attr_set_qos_class_np(
        __attr: *mut pthread_attr_t,
        __qos_class: qos_class_t,
        __relative_priority: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_get_qos_class_np(
        __attr: *mut pthread_attr_t,
        __qos_class: *mut qos_class_t,
        __relative_priority: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_set_qos_class_self_np(
        __qos_class: qos_class_t,
        __relative_priority: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_get_qos_class_np(
        __pthread: pthread_t,
        __qos_class: *mut qos_class_t,
        __relative_priority: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pthread_override_s {
    _unused: [u8; 0],
}
pub type pthread_override_t = *mut pthread_override_s;
extern "C" {
    pub fn pthread_override_qos_class_start_np(
        __pthread: pthread_t,
        __qos_class: qos_class_t,
        __relative_priority: ::std::os::raw::c_int,
    ) -> pthread_override_t;
}
extern "C" {
    pub fn pthread_override_qos_class_end_np(
        __override: pthread_override_t,
    ) -> ::std::os::raw::c_int;
}
pub type mach_port_t = __darwin_mach_port_t;
extern "C" {
    pub fn pthread_atfork(
        arg1: ::std::option::Option<unsafe extern "C" fn()>,
        arg2: ::std::option::Option<unsafe extern "C" fn()>,
        arg3: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_destroy(arg1: *mut pthread_attr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getdetachstate(
        arg1: *const pthread_attr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getguardsize(
        arg1: *const pthread_attr_t,
        arg2: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getinheritsched(
        arg1: *const pthread_attr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getschedparam(
        arg1: *const pthread_attr_t,
        arg2: *mut sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getschedpolicy(
        arg1: *const pthread_attr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getscope(
        arg1: *const pthread_attr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getstack(
        arg1: *const pthread_attr_t,
        arg2: *mut *mut ::std::os::raw::c_void,
        arg3: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getstackaddr(
        arg1: *const pthread_attr_t,
        arg2: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_getstacksize(
        arg1: *const pthread_attr_t,
        arg2: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_init(arg1: *mut pthread_attr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setdetachstate(
        arg1: *mut pthread_attr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setguardsize(
        arg1: *mut pthread_attr_t,
        arg2: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setinheritsched(
        arg1: *mut pthread_attr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setschedparam(
        arg1: *mut pthread_attr_t,
        arg2: *const sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setschedpolicy(
        arg1: *mut pthread_attr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setscope(
        arg1: *mut pthread_attr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setstack(
        arg1: *mut pthread_attr_t,
        arg2: *mut ::std::os::raw::c_void,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setstackaddr(
        arg1: *mut pthread_attr_t,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_attr_setstacksize(
        arg1: *mut pthread_attr_t,
        arg2: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cancel(arg1: pthread_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_broadcast(arg1: *mut pthread_cond_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_destroy(arg1: *mut pthread_cond_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_init(
        arg1: *mut pthread_cond_t,
        arg2: *const pthread_condattr_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_signal(arg1: *mut pthread_cond_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_timedwait(
        arg1: *mut pthread_cond_t,
        arg2: *mut pthread_mutex_t,
        arg3: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_wait(
        arg1: *mut pthread_cond_t,
        arg2: *mut pthread_mutex_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_destroy(arg1: *mut pthread_condattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_init(arg1: *mut pthread_condattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_getpshared(
        arg1: *const pthread_condattr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_condattr_setpshared(
        arg1: *mut pthread_condattr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_create(
        arg1: *mut pthread_t,
        arg2: *const pthread_attr_t,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
        >,
        arg4: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_detach(arg1: pthread_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_equal(arg1: pthread_t, arg2: pthread_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_exit(arg1: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn pthread_getconcurrency() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_getschedparam(
        arg1: pthread_t,
        arg2: *mut ::std::os::raw::c_int,
        arg3: *mut sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_getspecific(arg1: pthread_key_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn pthread_join(
        arg1: pthread_t,
        arg2: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_key_create(
        arg1: *mut pthread_key_t,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_key_delete(arg1: pthread_key_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_destroy(arg1: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_getprioceiling(
        arg1: *const pthread_mutex_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_init(
        arg1: *mut pthread_mutex_t,
        arg2: *const pthread_mutexattr_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_lock(arg1: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_setprioceiling(
        arg1: *mut pthread_mutex_t,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_trylock(arg1: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutex_unlock(arg1: *mut pthread_mutex_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_destroy(arg1: *mut pthread_mutexattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_getprioceiling(
        arg1: *const pthread_mutexattr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_getprotocol(
        arg1: *const pthread_mutexattr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_getpshared(
        arg1: *const pthread_mutexattr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_gettype(
        arg1: *const pthread_mutexattr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_getpolicy_np(
        arg1: *const pthread_mutexattr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_init(arg1: *mut pthread_mutexattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_setprioceiling(
        arg1: *mut pthread_mutexattr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_setprotocol(
        arg1: *mut pthread_mutexattr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_setpshared(
        arg1: *mut pthread_mutexattr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_settype(
        arg1: *mut pthread_mutexattr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mutexattr_setpolicy_np(
        arg1: *mut pthread_mutexattr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_once(
        arg1: *mut pthread_once_t,
        arg2: ::std::option::Option<unsafe extern "C" fn()>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_destroy(arg1: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_init(
        arg1: *mut pthread_rwlock_t,
        arg2: *const pthread_rwlockattr_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_rdlock(arg1: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_tryrdlock(arg1: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_trywrlock(arg1: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_wrlock(arg1: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlock_unlock(arg1: *mut pthread_rwlock_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_destroy(arg1: *mut pthread_rwlockattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_getpshared(
        arg1: *const pthread_rwlockattr_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_init(arg1: *mut pthread_rwlockattr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_rwlockattr_setpshared(
        arg1: *mut pthread_rwlockattr_t,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_self() -> pthread_t;
}
extern "C" {
    pub fn pthread_setcancelstate(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setcanceltype(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setconcurrency(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setschedparam(
        arg1: pthread_t,
        arg2: ::std::os::raw::c_int,
        arg3: *const sched_param,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setspecific(
        arg1: pthread_key_t,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_testcancel();
}
extern "C" {
    pub fn pthread_is_threaded_np() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_threadid_np(arg1: pthread_t, arg2: *mut __uint64_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_getname_np(
        arg1: pthread_t,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setname_np(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_main_np() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_mach_thread_np(arg1: pthread_t) -> mach_port_t;
}
extern "C" {
    pub fn pthread_get_stacksize_np(arg1: pthread_t) -> size_t;
}
extern "C" {
    pub fn pthread_get_stackaddr_np(arg1: pthread_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn pthread_cond_signal_thread_np(
        arg1: *mut pthread_cond_t,
        arg2: pthread_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cond_timedwait_relative_np(
        arg1: *mut pthread_cond_t,
        arg2: *mut pthread_mutex_t,
        arg3: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_create_suspended_np(
        arg1: *mut pthread_t,
        arg2: *const pthread_attr_t,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void,
        >,
        arg4: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_kill(arg1: pthread_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_from_mach_thread_np(arg1: mach_port_t) -> pthread_t;
}
extern "C" {
    pub fn pthread_sigmask(
        arg1: ::std::os::raw::c_int,
        arg2: *const sigset_t,
        arg3: *mut sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_yield_np();
}
extern "C" {
    pub fn pthread_jit_write_protect_np(enabled: ::std::os::raw::c_int);
}
extern "C" {
    pub fn pthread_jit_write_protect_supported_np() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_cpu_number_np(cpu_number_out: *mut size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static sys_signame: [*const ::std::os::raw::c_char; 32usize];
}
extern "C" {
    pub static sys_siglist: [*const ::std::os::raw::c_char; 32usize];
}
extern "C" {
    pub fn raise(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bsd_signal(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
extern "C" {
    pub fn kill(arg1: pid_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn killpg(arg1: pid_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaction(
        arg1: ::std::os::raw::c_int,
        arg2: *const sigaction,
        arg3: *mut sigaction,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaddset(arg1: *mut sigset_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaltstack(arg1: *const stack_t, arg2: *mut stack_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigdelset(arg1: *mut sigset_t, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigemptyset(arg1: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigfillset(arg1: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sighold(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigignore(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn siginterrupt(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigismember(arg1: *const sigset_t, arg2: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigpause(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigpending(arg1: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigprocmask(
        arg1: ::std::os::raw::c_int,
        arg2: *const sigset_t,
        arg3: *mut sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigrelse(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigset(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
extern "C" {
    pub fn sigsuspend(arg1: *const sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigwait(
        arg1: *const sigset_t,
        arg2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn psignal(arg1: ::std::os::raw::c_uint, arg2: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn sigblock(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigsetmask(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigvec(
        arg1: ::std::os::raw::c_int,
        arg2: *mut sigvec,
        arg3: *mut sigvec,
    ) -> ::std::os::raw::c_int;
}
pub type fiftyoneDegreesMutex = pthread_mutex_t;
extern "C" {
    #[doc = " Initialises the mutex passed to the method."]
    #[doc = " @param mutex to be initialised."]
    pub fn fiftyoneDegreesMutexCreate(mutex: *mut fiftyoneDegreesMutex);
}
extern "C" {
    #[doc = " Closes the mutex passed to the method."]
    #[doc = " @param mutex to be closed."]
    pub fn fiftyoneDegreesMutexClose(mutex: *mut fiftyoneDegreesMutex);
}
extern "C" {
    #[doc = " Locks the mutex passed to the method."]
    #[doc = " @param mutex to be locked."]
    pub fn fiftyoneDegreesMutexLock(mutex: *mut fiftyoneDegreesMutex);
}
extern "C" {
    #[doc = " Unlocks the mutex passed to the method."]
    #[doc = " @param mutex to be unlocked."]
    pub fn fiftyoneDegreesMutexUnlock(mutex: *mut fiftyoneDegreesMutex);
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct fiftyone_degrees_signal_t {
    #[doc = "< Flag indicating if the thread should wait"]
    pub wait: bool,
    #[doc = "< Condition variable for the signal"]
    pub cond: pthread_cond_t,
    #[doc = "< Mutex for the signal"]
    pub mutex: pthread_mutex_t,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_signal_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_signal_t>(),
        120usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_signal_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_signal_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_signal_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_signal_t>())).wait as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_signal_t),
            "::",
            stringify!(wait)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_signal_t>())).cond as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_signal_t),
            "::",
            stringify!(cond)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_signal_t>())).mutex as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_signal_t),
            "::",
            stringify!(mutex)
        )
    );
}
pub type fiftyoneDegreesSignal = fiftyone_degrees_signal_t;
extern "C" {
    #[doc = " Initialises the signal pointer by setting the condition first followed by"]
    #[doc = " the mutex if the condition was set correctly. Destroyed is set to false to"]
    #[doc = " indicate to the other methods that the signal is still valid. The memory"]
    #[doc = " used by the signal should be part of another structure and will be released"]
    #[doc = " when that structure is released. If there is a problem creating the mutex"]
    #[doc = " the condition is also released."]
    #[doc = " @return new signal"]
    pub fn fiftyoneDegreesSignalCreate() -> *mut fiftyoneDegreesSignal;
}
extern "C" {
    #[doc = " Closes the signal ensuring there is a lock on the signal before destroying"]
    #[doc = " the signal. This means that no other process can be waiting on the signal"]
    #[doc = " before it is destroyed. The destroyed field of the signal structure is set"]
    #[doc = " to true after the condition is destroyed. All methods that could"]
    #[doc = " subsequently try and get a lock on the signal **MUST** check the destroyed"]
    #[doc = " field before trying to get the lock."]
    #[doc = " @param signal to be closed."]
    pub fn fiftyoneDegreesSignalClose(signal: *mut fiftyoneDegreesSignal);
}
extern "C" {
    #[doc = " If the signal has not been destroyed then sends a signal to a waiting"]
    #[doc = " thread that the signal has been set and one can continue. This possible"]
    #[doc = " because the condition will auto reset only enabling a signal thread to"]
    #[doc = " continue even if multi threads are waiting."]
    #[doc = " @param signal to be set."]
    pub fn fiftyoneDegreesSignalSet(signal: *mut fiftyoneDegreesSignal);
}
extern "C" {
    #[doc = " Wait for a signal to be set. Only waits for the signal if the signal has not"]
    #[doc = " been destroyed. Locks the mutex before the signal is waited for. This"]
    #[doc = " ensures only one thread can be waiting on the signal at any one time."]
    #[doc = " @param signal pointer to the signal used to wait on."]
    pub fn fiftyoneDegreesSignalWait(signal: *mut fiftyoneDegreesSignal);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_interlock_dw_type_t {
    pub low: i64,
    pub high: i64,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_interlock_dw_type_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_interlock_dw_type_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_interlock_dw_type_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_interlock_dw_type_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_interlock_dw_type_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_interlock_dw_type_t>())).low as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_interlock_dw_type_t),
            "::",
            stringify!(low)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_interlock_dw_type_t>())).high as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_interlock_dw_type_t),
            "::",
            stringify!(high)
        )
    );
}
pub type fiftyoneDegreesInterlockDoubleWidth = fiftyone_degrees_interlock_dw_type_t;
#[doc = " @cond FORWARD_DECLARATIONS"]
pub type fiftyoneDegreesCacheNode = fiftyone_degrees_cache_node_t;
#[doc = " Cache shard structure used to enable concurrent access to the cache."]
pub type fiftyoneDegreesCacheShard = fiftyone_degrees_cache_shard_t;
#[doc = " Cache structure to store the root of the red black tree and a list of"]
#[doc = " allocated cache nodes. This also contains cache metrics and pointers to"]
#[doc = " methods used when being used as a loading cache."]
pub type fiftyoneDegreesCache = fiftyone_degrees_cache_t;
#[doc = " Cache node structure used for storing data in the cache along with"]
#[doc = " its key."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_cache_node_t {
    #[doc = "< Tree node for this cache node"]
    pub tree: fiftyoneDegreesTreeNode,
    #[doc = "< Data contained in the node"]
    pub data: fiftyoneDegreesData,
    #[doc = "< Shard the node is associated with"]
    pub shard: *mut fiftyoneDegreesCacheShard,
    #[doc = "< Previous node or NULL if first"]
    pub listPrevious: *mut fiftyoneDegreesCacheNode,
    #[doc = "< Next node or NULL if last"]
    pub listNext: *mut fiftyoneDegreesCacheNode,
    #[doc = "< Number of external references to the node data"]
    pub activeCount: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_cache_node_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_cache_node_t>(),
        96usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_cache_node_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_cache_node_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_cache_node_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_cache_node_t>())).tree as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_node_t),
            "::",
            stringify!(tree)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_cache_node_t>())).data as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_node_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_cache_node_t>())).shard as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_node_t),
            "::",
            stringify!(shard)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_cache_node_t>())).listPrevious as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_node_t),
            "::",
            stringify!(listPrevious)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_cache_node_t>())).listNext as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_node_t),
            "::",
            stringify!(listNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_cache_node_t>())).activeCount as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_node_t),
            "::",
            stringify!(activeCount)
        )
    );
}
#[doc = " Cache shard structure used to enable concurrent access to the cache."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct fiftyone_degrees_cache_shard_t {
    #[doc = "< Pointer to the cache to which the node"]
    #[doc = "belongs"]
    pub cache: *mut fiftyoneDegreesCache,
    #[doc = "< Root node of the red black tree"]
    pub root: fiftyoneDegreesTreeRoot,
    #[doc = "< Capacity of the shard"]
    pub capacity: u32,
    #[doc = "< Number of nodes currently used in the shard"]
    pub allocated: u32,
    #[doc = "< Pointer to the array of all nodes"]
    pub nodes: *mut fiftyoneDegreesCacheNode,
    #[doc = "< Pointer to the first node in the"]
    #[doc = "linked list"]
    pub first: *mut fiftyoneDegreesCacheNode,
    #[doc = "< Pointer to the last node in the"]
    #[doc = "linked list"]
    pub last: *mut fiftyoneDegreesCacheNode,
    #[doc = "< Used to ensure exclusive access to the"]
    #[doc = "shard for get and release operations"]
    pub lock: fiftyoneDegreesMutex,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_cache_shard_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_cache_shard_t>(),
        200usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_cache_shard_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_cache_shard_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_cache_shard_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_cache_shard_t>())).cache as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_shard_t),
            "::",
            stringify!(cache)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_cache_shard_t>())).root as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_shard_t),
            "::",
            stringify!(root)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_cache_shard_t>())).capacity as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_shard_t),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_cache_shard_t>())).allocated as *const _
                as usize
        },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_shard_t),
            "::",
            stringify!(allocated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_cache_shard_t>())).nodes as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_shard_t),
            "::",
            stringify!(nodes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_cache_shard_t>())).first as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_shard_t),
            "::",
            stringify!(first)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_cache_shard_t>())).last as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_shard_t),
            "::",
            stringify!(last)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_cache_shard_t>())).lock as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_shard_t),
            "::",
            stringify!(lock)
        )
    );
}
#[doc = " Method used to load data into the cache."]
#[doc = " @param state information used for the load operation."]
#[doc = " @param data structure to be used to store the data loaded."]
#[doc = " @param key for the item in the collection to be loaded."]
#[doc = " @param exception pointer to an exception data structure to be used if an"]
#[doc = " exception occurs. See exceptions.h."]
pub type fiftyoneDegreesCacheLoadMethod = ::std::option::Option<
    unsafe extern "C" fn(
        state: *const ::std::os::raw::c_void,
        data: *mut fiftyoneDegreesData,
        key: *const ::std::os::raw::c_void,
        exception: *mut fiftyoneDegreesException,
    ),
>;
#[doc = " Method used to calculate a hash code from the key."]
#[doc = " @param key the data to be calculate the integer key."]
#[doc = " @return 64 bit representation of the key data."]
pub type fiftyoneDegreesCacheHashCodeMethod =
    ::std::option::Option<unsafe extern "C" fn(key: *const ::std::os::raw::c_void) -> i64>;
#[doc = " Cache structure to store the root of the red black tree and a list of"]
#[doc = " allocated cache nodes. This also contains cache metrics and pointers to"]
#[doc = " methods used when being used as a loading cache."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_cache_t {
    #[doc = "< Array of shards / concurrency"]
    pub shards: *mut fiftyoneDegreesCacheShard,
    #[doc = "< Array of nodes / capacity"]
    pub nodes: *mut fiftyoneDegreesCacheNode,
    #[doc = "< Expected concurrency and number of shards"]
    pub concurrency: u16,
    #[doc = "< Capacity of the cache"]
    pub capacity: i32,
    #[doc = "< The requests served from the cache"]
    pub hits: ::std::os::raw::c_ulong,
    #[doc = "< The requests NOT served from the cache"]
    pub misses: ::std::os::raw::c_ulong,
    #[doc = "< Used by the cache to load an item"]
    #[doc = "into the cache"]
    pub load: fiftyoneDegreesCacheLoadMethod,
    #[doc = "< Used to hash a key pointer"]
    pub hash: fiftyoneDegreesCacheHashCodeMethod,
    #[doc = "< Cache loader specific state"]
    pub loaderState: *const ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_cache_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_cache_t>(),
        64usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_cache_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_cache_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_cache_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_cache_t>())).shards as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_t),
            "::",
            stringify!(shards)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_cache_t>())).nodes as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_t),
            "::",
            stringify!(nodes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_cache_t>())).concurrency as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_t),
            "::",
            stringify!(concurrency)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_cache_t>())).capacity as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_t),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_cache_t>())).hits as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_t),
            "::",
            stringify!(hits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_cache_t>())).misses as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_t),
            "::",
            stringify!(misses)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_cache_t>())).load as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_t),
            "::",
            stringify!(load)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_cache_t>())).hash as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_t),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_cache_t>())).loaderState as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_cache_t),
            "::",
            stringify!(loaderState)
        )
    );
}
extern "C" {
    #[doc = " Creates a new cache.The cache must be destroyed with the"]
    #[doc = " #fiftyoneDegreesCacheFree method."]
    #[doc = " @param capacity maximum number of items that the cache should store"]
    #[doc = " @param concurrency the expected number of parallel operations"]
    #[doc = " @param load pointer to method used to load an entry into the cache"]
    #[doc = " @param hash pointer to a method used to hash the key into a int64_t"]
    #[doc = " @param state pointer to state information to pass to the load method"]
    #[doc = " @return a pointer to the cache created, or NULL if one was not created."]
    pub fn fiftyoneDegreesCacheCreate(
        capacity: u32,
        concurrency: u16,
        load: fiftyoneDegreesCacheLoadMethod,
        hash: fiftyoneDegreesCacheHashCodeMethod,
        state: *const ::std::os::raw::c_void,
    ) -> *mut fiftyoneDegreesCache;
}
extern "C" {
    #[doc = " Frees the cache structure, all allocated nodes and their data."]
    #[doc = " @param cache to be freed"]
    pub fn fiftyoneDegreesCacheFree(cache: *mut fiftyoneDegreesCache);
}
extern "C" {
    #[doc = " Gets an item from the cache. If an item is not in the cache, it is loaded"]
    #[doc = " using the loader the cache was initialized with."]
    #[doc = ""]
    #[doc = " The cache being used as a loading cache must have a load method defined"]
    #[doc = " which returns a pointer to the data relating to the key used. This method"]
    #[doc = " may, or may not, allocate memory or free memory previously allocated to"]
    #[doc = " data in the cache node."]
    #[doc = ""]
    #[doc = " Nodes fetched from the cache are protected from modification until all"]
    #[doc = " references to them are released. This means that the size of the cache must"]
    #[doc = " be carefully chosen to be no smaller than the maximum number of nodes which"]
    #[doc = " may be in use at any one time. Attempting to fetch a node when there are no"]
    #[doc = " free nodes to load the data into will result in a null being returned."]
    #[doc = ""]
    #[doc = " @param cache to get the entry from"]
    #[doc = " @param key for the item to be returned"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return pointer to the requested item or null if too many items have been"]
    #[doc = " fetched and not released or the key is not valid"]
    pub fn fiftyoneDegreesCacheGet(
        cache: *mut fiftyoneDegreesCache,
        key: *const ::std::os::raw::c_void,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesCacheNode;
}
extern "C" {
    #[doc = " Releases the cache node previous obtained via #fiftyoneDegreesCacheGet so"]
    #[doc = " that it can be evicted from the cache if needed."]
    #[doc = " @param node to be released."]
    pub fn fiftyoneDegreesCacheRelease(node: *mut fiftyoneDegreesCacheNode);
}
extern "C" {
    #[doc = " Passed a pointer to a 32 bit / 4 byte data structure and returns the data as"]
    #[doc = " a 64 bit / 8 byte value for use in the cache. Used when cache keys are 32"]
    #[doc = " bit integers."]
    #[doc = " @param key to be used in the cache"]
    #[doc = " @return key represented as a 64 bit integer"]
    pub fn fiftyoneDegreesCacheHash32(key: *const ::std::os::raw::c_void) -> i64;
}
extern "C" {
    #[doc = " Passed a pointer to a 64 bit / 8 byte data structure and returns the data as"]
    #[doc = " a 64 bit / 8 byte value for use in the cache. Used when cache keys are 64"]
    #[doc = " bit integers."]
    #[doc = " @param key to be used in the cache"]
    #[doc = " @return key represented as a 64 bit integer"]
    pub fn fiftyoneDegreesCacheHash64(key: *const ::std::os::raw::c_void) -> i64;
}
extern "C" {
    pub fn __error() -> *mut ::std::os::raw::c_int;
}
pub type ino_t = __darwin_ino_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct dirent {
    pub d_ino: __uint64_t,
    pub d_seekoff: __uint64_t,
    pub d_reclen: __uint16_t,
    pub d_namlen: __uint16_t,
    pub d_type: __uint8_t,
    pub d_name: [::std::os::raw::c_char; 1024usize],
}
#[test]
fn bindgen_test_layout_dirent() {
    assert_eq!(
        ::std::mem::size_of::<dirent>(),
        1048usize,
        concat!("Size of: ", stringify!(dirent))
    );
    assert_eq!(
        ::std::mem::align_of::<dirent>(),
        8usize,
        concat!("Alignment of ", stringify!(dirent))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dirent>())).d_ino as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dirent),
            "::",
            stringify!(d_ino)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dirent>())).d_seekoff as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(dirent),
            "::",
            stringify!(d_seekoff)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dirent>())).d_reclen as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(dirent),
            "::",
            stringify!(d_reclen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dirent>())).d_namlen as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(dirent),
            "::",
            stringify!(d_namlen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dirent>())).d_type as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(dirent),
            "::",
            stringify!(d_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<dirent>())).d_name as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(dirent),
            "::",
            stringify!(d_name)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _telldir {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct DIR {
    pub __dd_fd: ::std::os::raw::c_int,
    pub __dd_loc: ::std::os::raw::c_long,
    pub __dd_size: ::std::os::raw::c_long,
    pub __dd_buf: *mut ::std::os::raw::c_char,
    pub __dd_len: ::std::os::raw::c_int,
    pub __dd_seek: ::std::os::raw::c_long,
    pub __padding: ::std::os::raw::c_long,
    pub __dd_flags: ::std::os::raw::c_int,
    pub __dd_lock: __darwin_pthread_mutex_t,
    pub __dd_td: *mut _telldir,
}
#[test]
fn bindgen_test_layout_DIR() {
    assert_eq!(
        ::std::mem::size_of::<DIR>(),
        136usize,
        concat!("Size of: ", stringify!(DIR))
    );
    assert_eq!(
        ::std::mem::align_of::<DIR>(),
        8usize,
        concat!("Alignment of ", stringify!(DIR))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_fd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_loc as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_loc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_buf as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_len as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_seek as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_seek)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__padding as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__padding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_flags as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_lock as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DIR>())).__dd_td as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(DIR),
            "::",
            stringify!(__dd_td)
        )
    );
}
extern "C" {
    pub fn closedir(arg1: *mut DIR) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_opendir$INODE64"]
    pub fn opendir(arg1: *const ::std::os::raw::c_char) -> *mut DIR;
}
extern "C" {
    #[link_name = "\u{1}_readdir$INODE64"]
    pub fn readdir(arg1: *mut DIR) -> *mut dirent;
}
extern "C" {
    #[link_name = "\u{1}_readdir_r$INODE64"]
    pub fn readdir_r(
        arg1: *mut DIR,
        arg2: *mut dirent,
        arg3: *mut *mut dirent,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_rewinddir$INODE64"]
    pub fn rewinddir(arg1: *mut DIR);
}
extern "C" {
    #[link_name = "\u{1}_seekdir$INODE64"]
    pub fn seekdir(arg1: *mut DIR, arg2: ::std::os::raw::c_long);
}
extern "C" {
    #[link_name = "\u{1}_telldir$INODE64"]
    pub fn telldir(arg1: *mut DIR) -> ::std::os::raw::c_long;
}
extern "C" {
    #[link_name = "\u{1}_fdopendir$INODE64"]
    pub fn fdopendir(arg1: ::std::os::raw::c_int) -> *mut DIR;
}
extern "C" {
    #[link_name = "\u{1}_alphasort$INODE64"]
    pub fn alphasort(arg1: *mut *const dirent, arg2: *mut *const dirent) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dirfd(dirp: *mut DIR) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_scandir$INODE64"]
    pub fn scandir(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut *mut dirent,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(arg1: *const dirent) -> ::std::os::raw::c_int,
        >,
        arg4: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut *const dirent,
                arg2: *mut *const dirent,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_scandir_b$INODE64"]
    pub fn scandir_b(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut *mut dirent,
        arg3: *mut ::std::os::raw::c_void,
        arg4: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_getdirentries_is_not_available_when_64_bit_inodes_are_in_effect"]
    pub fn getdirentries(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}___opendir2$INODE64"]
    pub fn __opendir2(arg1: *const ::std::os::raw::c_char, arg2: ::std::os::raw::c_int)
        -> *mut DIR;
}
pub type blkcnt_t = __darwin_blkcnt_t;
pub type blksize_t = __darwin_blksize_t;
pub type ino64_t = __darwin_ino64_t;
pub type nlink_t = __uint16_t;
pub type gid_t = __darwin_gid_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ostat {
    pub st_dev: __uint16_t,
    pub st_ino: ino_t,
    pub st_mode: mode_t,
    pub st_nlink: nlink_t,
    pub st_uid: __uint16_t,
    pub st_gid: __uint16_t,
    pub st_rdev: __uint16_t,
    pub st_size: __int32_t,
    pub st_atimespec: timespec,
    pub st_mtimespec: timespec,
    pub st_ctimespec: timespec,
    pub st_blksize: __int32_t,
    pub st_blocks: __int32_t,
    pub st_flags: __uint32_t,
    pub st_gen: __uint32_t,
}
#[test]
fn bindgen_test_layout_ostat() {
    assert_eq!(
        ::std::mem::size_of::<ostat>(),
        96usize,
        concat!("Size of: ", stringify!(ostat))
    );
    assert_eq!(
        ::std::mem::align_of::<ostat>(),
        8usize,
        concat!("Alignment of ", stringify!(ostat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_dev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_dev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_ino as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_ino)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_mode as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_nlink as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_nlink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_uid as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_gid as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_gid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_rdev as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_rdev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_size as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_atimespec as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_atimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_mtimespec as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_mtimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_ctimespec as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_ctimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_blksize as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_blksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_blocks as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_blocks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_flags as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ostat>())).st_gen as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(ostat),
            "::",
            stringify!(st_gen)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stat {
    pub st_dev: dev_t,
    pub st_mode: mode_t,
    pub st_nlink: nlink_t,
    pub st_ino: __darwin_ino64_t,
    pub st_uid: uid_t,
    pub st_gid: gid_t,
    pub st_rdev: dev_t,
    pub st_atimespec: timespec,
    pub st_mtimespec: timespec,
    pub st_ctimespec: timespec,
    pub st_birthtimespec: timespec,
    pub st_size: off_t,
    pub st_blocks: blkcnt_t,
    pub st_blksize: blksize_t,
    pub st_flags: __uint32_t,
    pub st_gen: __uint32_t,
    pub st_lspare: __int32_t,
    pub st_qspare: [__int64_t; 2usize],
}
#[test]
fn bindgen_test_layout_stat() {
    assert_eq!(
        ::std::mem::size_of::<stat>(),
        144usize,
        concat!("Size of: ", stringify!(stat))
    );
    assert_eq!(
        ::std::mem::align_of::<stat>(),
        8usize,
        concat!("Alignment of ", stringify!(stat))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_dev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_dev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_mode as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_nlink as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_nlink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_ino as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_ino)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_uid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_gid as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_gid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_rdev as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_rdev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_atimespec as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_atimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_mtimespec as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_mtimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_ctimespec as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_ctimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_birthtimespec as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_birthtimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_size as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_blocks as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_blocks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_blksize as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_blksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_flags as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_gen as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_gen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_lspare as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_lspare)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat>())).st_qspare as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(stat),
            "::",
            stringify!(st_qspare)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stat64 {
    pub st_dev: dev_t,
    pub st_mode: mode_t,
    pub st_nlink: nlink_t,
    pub st_ino: __darwin_ino64_t,
    pub st_uid: uid_t,
    pub st_gid: gid_t,
    pub st_rdev: dev_t,
    pub st_atimespec: timespec,
    pub st_mtimespec: timespec,
    pub st_ctimespec: timespec,
    pub st_birthtimespec: timespec,
    pub st_size: off_t,
    pub st_blocks: blkcnt_t,
    pub st_blksize: blksize_t,
    pub st_flags: __uint32_t,
    pub st_gen: __uint32_t,
    pub st_lspare: __int32_t,
    pub st_qspare: [__int64_t; 2usize],
}
#[test]
fn bindgen_test_layout_stat64() {
    assert_eq!(
        ::std::mem::size_of::<stat64>(),
        144usize,
        concat!("Size of: ", stringify!(stat64))
    );
    assert_eq!(
        ::std::mem::align_of::<stat64>(),
        8usize,
        concat!("Alignment of ", stringify!(stat64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_dev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_dev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_mode as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_nlink as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_nlink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_ino as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_ino)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_uid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_gid as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_gid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_rdev as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_rdev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_atimespec as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_atimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_mtimespec as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_mtimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_ctimespec as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_ctimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_birthtimespec as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_birthtimespec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_size as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_blocks as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_blocks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_blksize as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_blksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_flags as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_gen as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_gen)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_lspare as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_lspare)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stat64>())).st_qspare as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(stat64),
            "::",
            stringify!(st_qspare)
        )
    );
}
extern "C" {
    pub fn chmod(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchmod(arg1: ::std::os::raw::c_int, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_fstat$INODE64"]
    pub fn fstat(arg1: ::std::os::raw::c_int, arg2: *mut stat) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_lstat$INODE64"]
    pub fn lstat(arg1: *const ::std::os::raw::c_char, arg2: *mut stat) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdir(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkfifo(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_stat$INODE64"]
    pub fn stat(arg1: *const ::std::os::raw::c_char, arg2: *mut stat) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mknod(
        arg1: *const ::std::os::raw::c_char,
        arg2: mode_t,
        arg3: dev_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn umask(arg1: mode_t) -> mode_t;
}
extern "C" {
    pub fn fchmodat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: mode_t,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_fstatat$INODE64"]
    pub fn fstatat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut stat,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdirat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: mode_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn futimens(__fd: ::std::os::raw::c_int, __times: *const timespec)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn utimensat(
        __fd: ::std::os::raw::c_int,
        __path: *const ::std::os::raw::c_char,
        __times: *const timespec,
        __flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _filesec {
    _unused: [u8; 0],
}
pub type filesec_t = *mut _filesec;
extern "C" {
    pub fn chflags(arg1: *const ::std::os::raw::c_char, arg2: __uint32_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chmodx_np(arg1: *const ::std::os::raw::c_char, arg2: filesec_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchflags(arg1: ::std::os::raw::c_int, arg2: __uint32_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchmodx_np(arg1: ::std::os::raw::c_int, arg2: filesec_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_fstatx_np$INODE64"]
    pub fn fstatx_np(
        arg1: ::std::os::raw::c_int,
        arg2: *mut stat,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lchflags(arg1: *const ::std::os::raw::c_char, arg2: __uint32_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lchmod(arg1: *const ::std::os::raw::c_char, arg2: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_lstatx_np$INODE64"]
    pub fn lstatx_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut stat,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdirx_np(arg1: *const ::std::os::raw::c_char, arg2: filesec_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkfifox_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_statx_np$INODE64"]
    pub fn statx_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut stat,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn umaskx_np(arg1: filesec_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fstatx64_np(
        arg1: ::std::os::raw::c_int,
        arg2: *mut stat64,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lstatx64_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut stat64,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn statx64_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut stat64,
        arg3: filesec_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fstat64(arg1: ::std::os::raw::c_int, arg2: *mut stat64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lstat64(arg1: *const ::std::os::raw::c_char, arg2: *mut stat64)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn stat64(arg1: *const ::std::os::raw::c_char, arg2: *mut stat64) -> ::std::os::raw::c_int;
}
#[doc = " Used to read data from memory in a similar manner to a file handle."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_memory_reader_t {
    #[doc = "< The first byte in memory"]
    pub startByte: *mut byte,
    #[doc = "< The current byte being read from"]
    pub current: *mut byte,
    #[doc = "< The maximum byte that can be read from"]
    pub lastByte: *mut byte,
    #[doc = "< Length of the file in bytes"]
    pub length: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_memory_reader_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_memory_reader_t>(),
        32usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_memory_reader_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_memory_reader_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_memory_reader_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_memory_reader_t>())).startByte as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_memory_reader_t),
            "::",
            stringify!(startByte)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_memory_reader_t>())).current as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_memory_reader_t),
            "::",
            stringify!(current)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_memory_reader_t>())).lastByte as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_memory_reader_t),
            "::",
            stringify!(lastByte)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_memory_reader_t>())).length as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_memory_reader_t),
            "::",
            stringify!(length)
        )
    );
}
#[doc = " Used to read data from memory in a similar manner to a file handle."]
pub type fiftyoneDegreesMemoryReader = fiftyone_degrees_memory_reader_t;
extern "C" {
    #[doc = " Used to read continuous memory checking for buffer over or under runs."]
    #[doc = " @param reader structure used to check for last byte"]
    #[doc = " @param advanceBy number of bytes to advance current by"]
    #[doc = " @return true if the advance succeeded, otherwise false"]
    pub fn fiftyoneDegreesMemoryAdvance(
        reader: *mut fiftyoneDegreesMemoryReader,
        advanceBy: size_t,
    ) -> bool;
}
extern "C" {
    #[doc = " Allocates memory using the standard malloc method."]
    #[doc = " @param __size number of bytes to allocate"]
    #[doc = " @return pointer to allocated memory or NULL"]
    pub fn fiftyoneDegreesMemoryStandardMalloc(__size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Allocates memory while keeping track of the memory which has been allocated"]
    #[doc = " using this method since calling #fiftyoneDegreesMemoryTrackingReset."]
    #[doc = " @param __size number of bytes to allocate"]
    #[doc = " @return pointer to allocated memory or NULL"]
    pub fn fiftyoneDegreesMemoryTrackingMalloc(__size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Allocated aligned memory using the standard malloc method."]
    #[doc = " @param alignment byte boundary to align the allocation to e.g. 16"]
    #[doc = " @param __size number of bytes to allocate"]
    #[doc = " @return pointer to allocation memory or NULL"]
    pub fn fiftyoneDegreesMemoryStandardMallocAligned(
        alignment: ::std::os::raw::c_int,
        __size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Allocates aligned memory while keeping track of the memory which has been"]
    #[doc = " allocated using this method since calling"]
    #[doc = " #fiftyoneDegreesMemoryTrackingReset."]
    #[doc = " @param alignment byte boundary to align the allocation to e.g. 16"]
    #[doc = " @param __size number of bytes to allocate"]
    #[doc = " @return pointer to allocation memory or NULL"]
    pub fn fiftyoneDegreesMemoryTrackingMallocAligned(
        alignment: ::std::os::raw::c_int,
        __size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Frees memory allocated using the #fiftyoneDegreesMemoryTrackingMalloc method,"]
    #[doc = " noting that it has now been freed and does not contribute to the current"]
    #[doc = " total."]
    #[doc = " @param __ptr data to free"]
    pub fn fiftyoneDegreesMemoryTrackingFree(__ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = " Frees memory allocated using the #fiftyoneDegreesMemoryTrackingMallocAligned"]
    #[doc = "  method, noting that it has now been freed and does not contribute to the"]
    #[doc = " current total."]
    #[doc = " @param __ptr data to free"]
    pub fn fiftyoneDegreesMemoryTrackingFreeAligned(__ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = " Frees memory using the standard free method."]
    #[doc = " @param __ptr data to free"]
    pub fn fiftyoneDegreesMemoryStandardFree(__ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = " Frees memory using the standard aligned free method."]
    #[doc = " @param __ptr data to free"]
    pub fn fiftyoneDegreesMemoryStandardFreeAligned(__ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[doc = " Gets the maximum total number of bytes that have been allocated using the"]
    #[doc = " #fiftyoneDegreesMemoryTrackingMalloc method. NOTE: this is the total at any"]
    #[doc = " point in time since the #fiftyoneDegreesMemoryTrackingReset method was"]
    #[doc = " called, NOT the total allocated in a single allocation."]
    #[doc = " @return maximum total allocation"]
    pub fn fiftyoneDegreesMemoryTrackingGetMax() -> size_t;
}
extern "C" {
    #[doc = " Gets the current number of bytes allocated using the tracking malloc and free"]
    #[doc = " methods."]
    #[doc = " @return total bytes currently allocated"]
    pub fn fiftyoneDegreesMemoryTrackingGetAllocated() -> size_t;
}
extern "C" {
    #[doc = " Resets the memory trackers keeping track of the data allocated using the"]
    #[doc = " #fiftyoneDegreesMemoryTrackingMalloc method. This should always be called"]
    #[doc = " before tracking memory allocations."]
    pub fn fiftyoneDegreesMemoryTrackingReset();
}
extern "C" {
    pub static mut fiftyoneDegreesMalloc:
        ::std::option::Option<unsafe extern "C" fn(__size: size_t) -> *mut ::std::os::raw::c_void>;
}
extern "C" {
    pub static mut fiftyoneDegreesMallocAligned: ::std::option::Option<
        unsafe extern "C" fn(
            alignment: ::std::os::raw::c_int,
            __size: size_t,
        ) -> *mut ::std::os::raw::c_void,
    >;
}
extern "C" {
    pub static mut fiftyoneDegreesFree:
        ::std::option::Option<unsafe extern "C" fn(__ptr: *mut ::std::os::raw::c_void)>;
}
extern "C" {
    pub static mut fiftyoneDegreesFreeAligned:
        ::std::option::Option<unsafe extern "C" fn(__ptr: *mut ::std::os::raw::c_void)>;
}
#[doc = " @cond FORWARD_DECLARATIONS"]
pub type fiftyoneDegreesPoolItem = fiftyone_degrees_pool_item_t;
#[doc = " Pool of resources stored as items in a stack."]
pub type fiftyoneDegreesPool = fiftyone_degrees_pool_t;
#[doc = " Used to create a new resource for use in the pool."]
#[doc = " @param pool to create the resource for"]
#[doc = " @param state pointer to data used by the method"]
#[doc = " @param exception pointer to an exception data structure to be used if an"]
#[doc = " exception occurs. See exceptions.h"]
#[doc = " @return pointer to the new resource"]
pub type fiftyoneDegreesPoolResourceCreate = ::std::option::Option<
    unsafe extern "C" fn(
        pool: *mut fiftyoneDegreesPool,
        state: *mut ::std::os::raw::c_void,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut ::std::os::raw::c_void,
>;
#[doc = " Used to determine the additional size beyond the pointer used for each"]
#[doc = " resource added to the pool."]
#[doc = " @param state pointer to a state containing the resource and any additional"]
#[doc = " data needed for the calculation"]
#[doc = " @return addition size to allocate per resource"]
pub type fiftyoneDegreesPoolResourceSize =
    ::std::option::Option<unsafe extern "C" fn(state: *mut ::std::os::raw::c_void) -> size_t>;
#[doc = " Frees a resource previously created with #fiftyoneDegreesPoolResourceCreate."]
#[doc = " @param pool containing the resource"]
#[doc = " @param resource to free"]
pub type fiftyoneDegreesPoolResourceFree = ::std::option::Option<
    unsafe extern "C" fn(pool: *mut fiftyoneDegreesPool, resource: *mut ::std::os::raw::c_void),
>;
#[doc = " Pool item node in the stack of items."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_pool_item_t {
    #[doc = "< Pointer to the resource in the pool"]
    pub resource: *mut ::std::os::raw::c_void,
    #[doc = "< The next item in the stack"]
    pub next: u16,
    #[doc = "< Reader the handle belongs to"]
    pub pool: *mut fiftyoneDegreesPool,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_pool_item_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_pool_item_t>(),
        24usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_pool_item_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_pool_item_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_pool_item_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_pool_item_t>())).resource as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_pool_item_t),
            "::",
            stringify!(resource)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_pool_item_t>())).next as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_pool_item_t),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_pool_item_t>())).pool as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_pool_item_t),
            "::",
            stringify!(pool)
        )
    );
}
#[doc = " The head of the stack used for pop and push operations."]
#[repr(C)]
#[derive(Copy, Clone)]
pub union fiftyone_degrees_pool_head_t {
    #[doc = "< Number used in the compare exchange operation"]
    pub exchange: ::std::os::raw::c_long,
    #[doc = "< Value index with its ABA value"]
    pub values: fiftyone_degrees_pool_head_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_pool_head_t__bindgen_ty_1 {
    #[doc = "< Index of the item in the linked list"]
    pub index: u16,
    #[doc = "< ABA value used to ensure proper operation"]
    pub aba: u16,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_pool_head_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_pool_head_t__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_pool_head_t__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_pool_head_t__bindgen_ty_1>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_pool_head_t__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_pool_head_t__bindgen_ty_1>())).index as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_pool_head_t__bindgen_ty_1),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_pool_head_t__bindgen_ty_1>())).aba as *const _
                as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_pool_head_t__bindgen_ty_1),
            "::",
            stringify!(aba)
        )
    );
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_pool_head_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_pool_head_t>(),
        8usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_pool_head_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_pool_head_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_pool_head_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_pool_head_t>())).exchange as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_pool_head_t),
            "::",
            stringify!(exchange)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_pool_head_t>())).values as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_pool_head_t),
            "::",
            stringify!(values)
        )
    );
}
#[doc = " The head of the stack used for pop and push operations."]
pub type fiftyoneDegreesPoolHead = fiftyone_degrees_pool_head_t;
#[doc = " Pool of resources stored as items in a stack."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct fiftyone_degrees_pool_t {
    #[doc = "< Pointer to the memory used by the"]
    #[doc = "stack"]
    pub stack: *mut fiftyoneDegreesPoolItem,
    #[doc = "< Head of the stack"]
    pub head: fiftyoneDegreesPoolHead,
    #[doc = "< Number of resource items that stack can hold"]
    pub count: u16,
    #[doc = "< Frees a resource"]
    pub resourceFree: fiftyoneDegreesPoolResourceFree,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_pool_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_pool_t>(),
        32usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_pool_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_pool_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_pool_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_pool_t>())).stack as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_pool_t),
            "::",
            stringify!(stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_pool_t>())).head as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_pool_t),
            "::",
            stringify!(head)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_pool_t>())).count as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_pool_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_pool_t>())).resourceFree as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_pool_t),
            "::",
            stringify!(resourceFree)
        )
    );
}
extern "C" {
    #[doc = " Initialises a pool data structure to support the number of concurrent"]
    #[doc = " requests that can be made to the pool for resources that can be reused."]
    #[doc = " The resourceCreate method is used to create a new resource for use in the"]
    #[doc = " pool which will be freed during when the release method is called on the"]
    #[doc = " pool using the resourceFree method."]
    #[doc = " @param pool data structure to be initialised."]
    #[doc = " @param concurrency the number of resources the pool should contain."]
    #[doc = " @param state passed to the create resource method."]
    #[doc = " @param resourceCreate method used to create the resource to be added to"]
    #[doc = " items in the pool."]
    #[doc = " @param resourceFree method used to free a resource from the pool when the"]
    #[doc = " pool is freed."]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return a pointer to the pool if successful, otherwise NULL."]
    pub fn fiftyoneDegreesPoolInit(
        pool: *mut fiftyoneDegreesPool,
        concurrency: u16,
        state: *mut ::std::os::raw::c_void,
        resourceCreate: fiftyoneDegreesPoolResourceCreate,
        resourceFree: fiftyoneDegreesPoolResourceFree,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesPool;
}
extern "C" {
    #[doc = " Gets the next free item from the pool for exclusive use by the caller. Every"]
    #[doc = " item returned must be released when the caller has finished with it using"]
    #[doc = " the #fiftyoneDegreesPoolItemRelease method."]
    #[doc = " @param pool to return items from."]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the next free item, or NULL if no items are available."]
    pub fn fiftyoneDegreesPoolItemGet(
        pool: *mut fiftyoneDegreesPool,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesPoolItem;
}
extern "C" {
    #[doc = " Releases the item back to the pool it belongs ready to be reused by another"]
    #[doc = " operation."]
    #[doc = " @param item to be released back to the pool"]
    pub fn fiftyoneDegreesPoolItemRelease(item: *mut fiftyoneDegreesPoolItem);
}
extern "C" {
    #[doc = " Releases the items used by the pool freeing the resources used by each"]
    #[doc = " item by calling the resourceFree method provided when the pool was created."]
    #[doc = " @param pool to be freed"]
    pub fn fiftyoneDegreesPoolFree(pool: *mut fiftyoneDegreesPool);
}
extern "C" {
    #[doc = " Resets the pool without releasing any resources."]
    #[doc = " @param pool to be reset"]
    pub fn fiftyoneDegreesPoolReset(pool: *mut fiftyoneDegreesPool);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct accessx_descriptor {
    pub ad_name_offset: ::std::os::raw::c_uint,
    pub ad_flags: ::std::os::raw::c_int,
    pub ad_pad: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout_accessx_descriptor() {
    assert_eq!(
        ::std::mem::size_of::<accessx_descriptor>(),
        16usize,
        concat!("Size of: ", stringify!(accessx_descriptor))
    );
    assert_eq!(
        ::std::mem::align_of::<accessx_descriptor>(),
        4usize,
        concat!("Alignment of ", stringify!(accessx_descriptor))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<accessx_descriptor>())).ad_name_offset as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(accessx_descriptor),
            "::",
            stringify!(ad_name_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<accessx_descriptor>())).ad_flags as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(accessx_descriptor),
            "::",
            stringify!(ad_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<accessx_descriptor>())).ad_pad as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(accessx_descriptor),
            "::",
            stringify!(ad_pad)
        )
    );
}
extern "C" {
    pub fn getattrlistbulk(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: *mut ::std::os::raw::c_void,
        arg4: size_t,
        arg5: u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getattrlistat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_void,
        arg4: *mut ::std::os::raw::c_void,
        arg5: size_t,
        arg6: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setattrlistat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_void,
        arg4: *mut ::std::os::raw::c_void,
        arg5: size_t,
        arg6: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn faccessat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchownat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: uid_t,
        arg4: gid_t,
        arg5: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn linkat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
        arg5: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn readlinkat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_char,
        arg4: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn symlinkat(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unlinkat(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type useconds_t = __darwin_useconds_t;
extern "C" {
    pub fn _exit(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn access(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn alarm(arg1: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn chdir(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn chown(
        arg1: *const ::std::os::raw::c_char,
        arg2: uid_t,
        arg3: gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn close(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dup(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dup2(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execl(
        __path: *const ::std::os::raw::c_char,
        __arg0: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execle(
        __path: *const ::std::os::raw::c_char,
        __arg0: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execlp(
        __file: *const ::std::os::raw::c_char,
        __arg0: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execv(
        __path: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execve(
        __file: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
        __envp: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn execvp(
        __file: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fork() -> pid_t;
}
extern "C" {
    pub fn fpathconf(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn getcwd(arg1: *mut ::std::os::raw::c_char, arg2: size_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getegid() -> gid_t;
}
extern "C" {
    pub fn geteuid() -> uid_t;
}
extern "C" {
    pub fn getgid() -> gid_t;
}
extern "C" {
    pub fn getgroups(arg1: ::std::os::raw::c_int, arg2: *mut gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getlogin() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getpgrp() -> pid_t;
}
extern "C" {
    pub fn getpid() -> pid_t;
}
extern "C" {
    pub fn getppid() -> pid_t;
}
extern "C" {
    pub fn getuid() -> uid_t;
}
extern "C" {
    pub fn isatty(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn link(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lseek(arg1: ::std::os::raw::c_int, arg2: off_t, arg3: ::std::os::raw::c_int) -> off_t;
}
extern "C" {
    pub fn pathconf(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn pause() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pipe(arg1: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn read(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn rmdir(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setgid(arg1: gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setpgid(arg1: pid_t, arg2: pid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setsid() -> pid_t;
}
extern "C" {
    pub fn setuid(arg1: uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sleep(arg1: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn sysconf(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn tcgetpgrp(arg1: ::std::os::raw::c_int) -> pid_t;
}
extern "C" {
    pub fn tcsetpgrp(arg1: ::std::os::raw::c_int, arg2: pid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ttyname(arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ttyname_r(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unlink(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn write(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __nbyte: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn confstr(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn getopt(
        arg1: ::std::os::raw::c_int,
        arg2: *const *mut ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut optarg: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut optind: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut opterr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut optopt: ::std::os::raw::c_int;
}
extern "C" {
    pub fn brk(arg1: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn chroot(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn crypt(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn encrypt(arg1: *mut ::std::os::raw::c_char, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn fchdir(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostid() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn getpgid(arg1: pid_t) -> pid_t;
}
extern "C" {
    pub fn getsid(arg1: pid_t) -> pid_t;
}
extern "C" {
    pub fn getdtablesize() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getpagesize() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getpass(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getwd(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn lchown(
        arg1: *const ::std::os::raw::c_char,
        arg2: uid_t,
        arg3: gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lockf(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: off_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nice(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pread(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_void,
        __nbyte: size_t,
        __offset: off_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn pwrite(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __nbyte: size_t,
        __offset: off_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn sbrk(arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn setpgrp() -> pid_t;
}
extern "C" {
    pub fn setregid(arg1: gid_t, arg2: gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setreuid(arg1: uid_t, arg2: uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sync();
}
extern "C" {
    pub fn truncate(arg1: *const ::std::os::raw::c_char, arg2: off_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ualarm(arg1: useconds_t, arg2: useconds_t) -> useconds_t;
}
extern "C" {
    pub fn usleep(arg1: useconds_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfork() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsync(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftruncate(arg1: ::std::os::raw::c_int, arg2: off_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getlogin_r(arg1: *mut ::std::os::raw::c_char, arg2: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fchown(arg1: ::std::os::raw::c_int, arg2: uid_t, arg3: gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostname(arg1: *mut ::std::os::raw::c_char, arg2: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn readlink(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> ssize_t;
}
extern "C" {
    pub fn setegid(arg1: gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn seteuid(arg1: uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn symlink(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub fds_bits: [__int32_t; 32usize],
}
#[test]
fn bindgen_test_layout_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<fd_set>(),
        4usize,
        concat!("Alignment of ", stringify!(fd_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fd_set>())).fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fd_set),
            "::",
            stringify!(fds_bits)
        )
    );
}
extern "C" {
    pub fn __darwin_check_fd_set_overflow(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type suseconds_t = __darwin_suseconds_t;
extern "C" {
    #[link_name = "\u{1}_pselect$1050"]
    pub fn pselect(
        arg1: ::std::os::raw::c_int,
        arg2: *mut fd_set,
        arg3: *mut fd_set,
        arg4: *mut fd_set,
        arg5: *const timespec,
        arg6: *const sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_select$1050"]
    pub fn select(
        arg1: ::std::os::raw::c_int,
        arg2: *mut fd_set,
        arg3: *mut fd_set,
        arg4: *mut fd_set,
        arg5: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
pub type uuid_t = __darwin_uuid_t;
extern "C" {
    pub fn accessx_np(
        arg1: *const accessx_descriptor,
        arg2: size_t,
        arg3: *mut ::std::os::raw::c_int,
        arg4: uid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acct(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn add_profil(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: ::std::os::raw::c_ulong,
        arg4: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn endusershell();
}
extern "C" {
    pub fn execvP(
        __file: *const ::std::os::raw::c_char,
        __searchpath: *const ::std::os::raw::c_char,
        __argv: *const *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflagstostr(arg1: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getdomainname(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getgrouplist(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gethostuuid(
        arg1: *mut ::std::os::raw::c_uchar,
        arg2: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getmode(arg1: *const ::std::os::raw::c_void, arg2: mode_t) -> mode_t;
}
extern "C" {
    pub fn getpeereid(
        arg1: ::std::os::raw::c_int,
        arg2: *mut uid_t,
        arg3: *mut gid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsgroups_np(
        arg1: *mut ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getusershell() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getwgroups_np(
        arg1: *mut ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn initgroups(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn issetugid() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdtemp(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkpath_np(path: *const ::std::os::raw::c_char, omode: mode_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkpathat_np(
        dfd: ::std::os::raw::c_int,
        path: *const ::std::os::raw::c_char,
        omode: mode_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkstemps(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkostemp(
        path: *mut ::std::os::raw::c_char,
        oflags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkostemps(
        path: *mut ::std::os::raw::c_char,
        slen: ::std::os::raw::c_int,
        oflags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkstemp_dprotected_np(
        path: *mut ::std::os::raw::c_char,
        dpclass: ::std::os::raw::c_int,
        dpflags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkdtempat_np(
        dfd: ::std::os::raw::c_int,
        path: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkstempsat_np(
        dfd: ::std::os::raw::c_int,
        path: *mut ::std::os::raw::c_char,
        slen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mkostempsat_np(
        dfd: ::std::os::raw::c_int,
        path: *mut ::std::os::raw::c_char,
        slen: ::std::os::raw::c_int,
        oflags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn nfssvc(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn profil(
        arg1: *mut ::std::os::raw::c_char,
        arg2: size_t,
        arg3: ::std::os::raw::c_ulong,
        arg4: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_setugid_np(arg1: uid_t, arg2: gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_getugid_np(arg1: *mut uid_t, arg2: *mut gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn reboot(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn revoke(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rcmd(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const ::std::os::raw::c_char,
        arg5: *const ::std::os::raw::c_char,
        arg6: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rcmd_af(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const ::std::os::raw::c_char,
        arg5: *const ::std::os::raw::c_char,
        arg6: *mut ::std::os::raw::c_int,
        arg7: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rresvport(arg1: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rresvport_af(
        arg1: *mut ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn iruserok(
        arg1: ::std::os::raw::c_ulong,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn iruserok_sa(
        arg1: *const ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
        arg5: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ruserok(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setdomainname(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setgroups(arg1: ::std::os::raw::c_int, arg2: *const gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sethostid(arg1: ::std::os::raw::c_long);
}
extern "C" {
    pub fn sethostname(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setlogin(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setmode(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn setrgid(arg1: gid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setruid(arg1: uid_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setsgroups_np(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setusershell();
}
extern "C" {
    pub fn setwgroups_np(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strtofflags(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_ulong,
        arg3: *mut ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn swapon(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ttyslot() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn undelete(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unwhiteout(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn syscall(arg1: ::std::os::raw::c_int, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetattrlist(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: *mut ::std::os::raw::c_void,
        arg4: size_t,
        arg5: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetattrlist(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: *mut ::std::os::raw::c_void,
        arg4: size_t,
        arg5: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getattrlist(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_void,
        arg3: *mut ::std::os::raw::c_void,
        arg4: size_t,
        arg5: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setattrlist(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_void,
        arg3: *mut ::std::os::raw::c_void,
        arg4: size_t,
        arg5: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn exchangedata(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getdirentriesattr(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: *mut ::std::os::raw::c_void,
        arg4: size_t,
        arg5: *mut ::std::os::raw::c_uint,
        arg6: *mut ::std::os::raw::c_uint,
        arg7: *mut ::std::os::raw::c_uint,
        arg8: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fssearchblock {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct searchstate {
    _unused: [u8; 0],
}
extern "C" {
    pub fn searchfs(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut fssearchblock,
        arg3: *mut ::std::os::raw::c_ulong,
        arg4: ::std::os::raw::c_uint,
        arg5: ::std::os::raw::c_uint,
        arg6: *mut searchstate,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsctl(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_ulong,
        arg3: *mut ::std::os::raw::c_void,
        arg4: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ffsctl(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_ulong,
        arg3: *mut ::std::os::raw::c_void,
        arg4: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsync_volume_np(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sync_volume_np(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static mut optreset: ::std::os::raw::c_int;
}
#[doc = " File handle node in the stack of handles."]
#[repr(C)]
#[derive(Copy, Clone)]
pub union fiftyone_degrees_file_handle_t {
    #[doc = "< Open read handle to the source data file."]
    pub file: *mut FILE,
    #[doc = "< The pool item with the resource."]
    pub item: fiftyoneDegreesPoolItem,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_file_handle_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_file_handle_t>(),
        24usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_file_handle_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_file_handle_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_file_handle_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_file_handle_t>())).file as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_file_handle_t),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_file_handle_t>())).item as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_file_handle_t),
            "::",
            stringify!(item)
        )
    );
}
#[doc = " File handle node in the stack of handles."]
pub type fiftyoneDegreesFileHandle = fiftyone_degrees_file_handle_t;
#[doc = " Stack of handles used to read data from a single source file."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct fiftyone_degrees_file_pool_t {
    #[doc = "< The pool of file handles"]
    pub pool: fiftyoneDegreesPool,
    #[doc = "< Length of the file in bytes"]
    pub length: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_file_pool_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_file_pool_t>(),
        40usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_file_pool_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_file_pool_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_file_pool_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_file_pool_t>())).pool as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_file_pool_t),
            "::",
            stringify!(pool)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_file_pool_t>())).length as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_file_pool_t),
            "::",
            stringify!(length)
        )
    );
}
#[doc = " Stack of handles used to read data from a single source file."]
pub type fiftyoneDegreesFilePool = fiftyone_degrees_file_pool_t;
extern "C" {
    #[doc = " Releases the file handles contained in the pool and frees any internal"]
    #[doc = " memory used by the pool. Does not free the memory pointed to by pool."]
    #[doc = " @param pool pointer to the stack of file handles to be release"]
    pub fn fiftyoneDegreesFilePoolRelease(pool: *mut fiftyoneDegreesFilePool);
}
extern "C" {
    #[doc = " Opens the file path provided placing the file handle in the handle"]
    #[doc = " parameter."]
    #[doc = " @param fileName full path to the file to open"]
    #[doc = " @param handle to be associated with the open file"]
    #[doc = " @return the result of the open operation"]
    pub fn fiftyoneDegreesFileOpen(
        fileName: *const ::std::os::raw::c_char,
        handle: *mut *mut FILE,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Writes binary data to the file path provided, closing the file once finished."]
    #[doc = " @param fileName full path to the file to write to"]
    #[doc = " @param data binary data to write"]
    #[doc = " @param length the number of bytes in the data to be written"]
    #[doc = " @return the result of the write operation"]
    pub fn fiftyoneDegreesFileWrite(
        fileName: *const ::std::os::raw::c_char,
        data: *const ::std::os::raw::c_void,
        length: size_t,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Copy a file from one location to another. If there was an error while"]
    #[doc = " creating or copying the file, then the appropriate status code will be"]
    #[doc = " returned. If the status code is anything other than"]
    #[doc = " #FIFTYONE_DEGREES_STATUS_SUCCESS then the new file will not exist."]
    #[doc = " @param source path to the file to copy"]
    #[doc = " @param destination path to the file to create"]
    #[doc = " @return the result of the copy operation"]
    pub fn fiftyoneDegreesFileCopy(
        source: *const ::std::os::raw::c_char,
        destination: *const ::std::os::raw::c_char,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Delete a file from the file system. If there was an error while removing the"]
    #[doc = " file, then the appropriate status code will be returned."]
    #[doc = " @param fileName path to the file to be deleted"]
    #[doc = " @return the result of the delete operation"]
    pub fn fiftyoneDegreesFileDelete(
        fileName: *const ::std::os::raw::c_char,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Creates a directory with the specified path, and returns the result of the"]
    #[doc = " operation. intermediate directories will not be created."]
    #[doc = " @param pathName path to create"]
    #[doc = " @return the result of the operation"]
    pub fn fiftyoneDegreesFileCreateDirectory(
        pathName: *const ::std::os::raw::c_char,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Iterates up the folders from the current working directory until a file"]
    #[doc = " in the sub folder dataFolderName with the name fileName is found which"]
    #[doc = " can be opened. This is assumed to be the data file required by the caller."]
    #[doc = " Enough memory must be allocated to the destination parameter for the full"]
    #[doc = " path to be written. The maximum path length is defined by the macro"]
    #[doc = " `FIFTYONEDEGREES_FILE_MAX_PATH`."]
    #[doc = " @param dataFolderName the name of the sub folder which is expected to"]
    #[doc = " contain the data file"]
    #[doc = " @param fileName the name of the data file"]
    #[doc = " @param destination memory to write the absolute path to if the file was"]
    #[doc = " found"]
    #[doc = " @param size the number of bytes assigned to the destination pointer"]
    #[doc = " @return the result of the operation"]
    pub fn fiftyoneDegreesFileGetPath(
        dataFolderName: *const ::std::os::raw::c_char,
        fileName: *const ::std::os::raw::c_char,
        destination: *mut ::std::os::raw::c_char,
        size: size_t,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Gets the path to a temporary file which is an exact copy of the master file"]
    #[doc = " if one exists. If one is found, true is returned and the path written to the"]
    #[doc = " memory pointed to by the destination parameter. If the file found has the"]
    #[doc = " same name as the master file, then false is returned to avoid the same file"]
    #[doc = " being treated as if it were a copy by external code."]
    #[doc = " If no paths are provided, then the working directory is searched."]
    #[doc = " @param masterFile path to the master file to find a temp version of"]
    #[doc = " @param paths list of paths to search in order of preference"]
    #[doc = " @param count number of paths in the array"]
    #[doc = " @param bytesToCompare number of from the start of the file to compare for"]
    #[doc = " equality with the master file, or -1 to compare the whole file"]
    #[doc = " @param destination memory to write the found file path to"]
    #[doc = " @return true if a copy of the master file was found, and its path written to"]
    #[doc = " destination"]
    pub fn fiftyoneDegreesFileGetExistingTempFile(
        masterFile: *const ::std::os::raw::c_char,
        paths: *mut *const ::std::os::raw::c_char,
        count: ::std::os::raw::c_int,
        bytesToCompare: ::std::os::raw::c_long,
        destination: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    #[doc = " Finds all the temporary files which is an exact copy of the master file"]
    #[doc = " if any exist. If any are found, the method attempts to delete them. The"]
    #[doc = " number of successfully deleted temp files is returned. If any files found"]
    #[doc = " have the same name as the master file, then false is returned to avoid the"]
    #[doc = " same file being treated as if it were a copy by external code."]
    #[doc = " If no paths are provided, then the working directory is searched. Note that"]
    #[doc = " this should not be used on Apple systems, as the checks for whether or not"]
    #[doc = " a file is in use are not implemented (all files will be deleted regardless"]
    #[doc = " of whether they are being used)."]
    #[doc = " @param masterFileName path to the master file to find a temp version of"]
    #[doc = " @param paths list of paths to search in order of preference"]
    #[doc = " @param count number of paths in the array"]
    #[doc = " @param bytesToCompare number of from the start of the file to compare for"]
    #[doc = " equality with the master file, or -1 to compare the whole file"]
    #[doc = " @return the number of matching files which have been successfully deleted"]
    pub fn fiftyoneDegreesFileDeleteUnusedTempFiles(
        masterFileName: *const ::std::os::raw::c_char,
        paths: *mut *const ::std::os::raw::c_char,
        count: ::std::os::raw::c_int,
        bytesToCompare: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Create a temporary file containing a copy of the master file using the first"]
    #[doc = " writable path in the list of paths provided. The path which is written to"]
    #[doc = " (including file name) is written to the destination parameter which must"]
    #[doc = " contain enough memory."]
    #[doc = " If no paths are provided, then the working directory used as the destination."]
    #[doc = " @param masterFile full path to the file containing the master data to copy"]
    #[doc = " @param paths list of paths to use in order of preference"]
    #[doc = " @param count number of paths in the array"]
    #[doc = " @param destination memory to write the new file path to"]
    #[doc = " @return the result of the create operation"]
    pub fn fiftyoneDegreesFileCreateTempFile(
        masterFile: *const ::std::os::raw::c_char,
        paths: *mut *const ::std::os::raw::c_char,
        count: ::std::os::raw::c_int,
        destination: *const ::std::os::raw::c_char,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Initialises the pool with a stack of open read only file handles all"]
    #[doc = " associated with the file name. The concurrency parameter determines the"]
    #[doc = " number of items in the stack."]
    #[doc = " @param filePool to be initialised"]
    #[doc = " @param fileName full path to the file to open"]
    #[doc = " @param concurrency number of items in the stack"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the result of the open operation"]
    pub fn fiftyoneDegreesFilePoolInit(
        filePool: *mut fiftyoneDegreesFilePool,
        fileName: *const ::std::os::raw::c_char,
        concurrency: u16,
        exception: *mut fiftyoneDegreesException,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Retrieves a read only open file handle from the pool. The handle retrieve"]
    #[doc = " must be returned to the pool using #fiftyoneDegreesFileHandleGet and must"]
    #[doc = " not be freed or closed directly."]
    #[doc = " @param filePool to retrieve the file handle from"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return a read only open file handle or NULL if no available handles remain"]
    #[doc = " in the pool"]
    pub fn fiftyoneDegreesFileHandleGet(
        filePool: *mut fiftyoneDegreesFilePool,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesFileHandle;
}
extern "C" {
    #[doc = " Returns a handle previously retrieved via #fiftyoneDegreesFileHandleGet back"]
    #[doc = " to the pool."]
    #[doc = " @param handle to be returned to the pool"]
    pub fn fiftyoneDegreesFileHandleRelease(handle: *mut fiftyoneDegreesFileHandle);
}
extern "C" {
    #[doc = " Returns the size of a file in bytes, or -1 if the file does not exist or"]
    #[doc = " cannot be accessed."]
    #[doc = " @param fileName path to the file"]
    #[doc = " @return size of file in bytes or -1"]
    pub fn fiftyoneDegreesFileGetSize(
        fileName: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    #[doc = " Reads the contents of a file into memory. The correct amount of memory will"]
    #[doc = " be allocated by the method. This memory needs to be freed by the caller"]
    #[doc = " after the data has been finished with."]
    #[doc = " @param fileName path to the source file"]
    #[doc = " @param reader to contain the pointer to the memory and the size"]
    #[doc = " @return status code indicating whether the read was successful"]
    pub fn fiftyoneDegreesFileReadToByteArray(
        fileName: *const ::std::os::raw::c_char,
        reader: *mut fiftyoneDegreesMemoryReader,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Resets the pool without releasing any resources."]
    #[doc = " @param filePool to be reset."]
    pub fn fiftyoneDegreesFilePoolReset(filePool: *mut fiftyoneDegreesFilePool);
}
extern "C" {
    #[doc = " Gets the last, file name, segment of the full file path."]
    #[doc = " @param filePath full path to the file."]
    #[doc = " @return the file name from the file path."]
    pub fn fiftyoneDegreesFileGetFileName(
        filePath: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_collection_header_t {
    #[doc = "< Start position in the data file of the entities"]
    pub startPosition: u32,
    #[doc = "< Length in bytes of all the entities"]
    pub length: u32,
    #[doc = "< Number of entities in the collection"]
    pub count: u32,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_collection_header_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_collection_header_t>(),
        12usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_collection_header_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_collection_header_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_collection_header_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_header_t>())).startPosition
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_header_t),
            "::",
            stringify!(startPosition)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_header_t>())).length as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_header_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_header_t>())).count as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_header_t),
            "::",
            stringify!(count)
        )
    );
}
pub type fiftyoneDegreesCollectionHeader = fiftyone_degrees_collection_header_t;
#[doc = " Collection configuration structure which defines how the collection should"]
#[doc = " be created by the create methods."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_collection_config_t {
    #[doc = "< Number of items to load into memory from the start of"]
    #[doc = "the collection"]
    pub loaded: u32,
    #[doc = "< Number of items the cache should store, 0 for no"]
    #[doc = "cache"]
    pub capacity: u32,
    #[doc = "< Expected number of concurrent requests, 1 or"]
    #[doc = "greater"]
    pub concurrency: u16,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_collection_config_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_collection_config_t>(),
        12usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_collection_config_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_collection_config_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_collection_config_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_config_t>())).loaded as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_config_t),
            "::",
            stringify!(loaded)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_config_t>())).capacity as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_config_t),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_config_t>())).concurrency as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_config_t),
            "::",
            stringify!(concurrency)
        )
    );
}
#[doc = " Collection configuration structure which defines how the collection should"]
#[doc = " be created by the create methods."]
pub type fiftyoneDegreesCollectionConfig = fiftyone_degrees_collection_config_t;
#[doc = " @cond FORWARD_DECLARATIONS"]
pub type fiftyoneDegreesCollection = fiftyone_degrees_collection_t;
#[doc = " Used to store a handle to the underlying item that could be used to release"]
#[doc = " the item when it's finished with. Also contains a reference to the data"]
#[doc = " structure used to handle memory allocation enabling memory to be reused"]
#[doc = " across multiple gets reducing the frequency of memory operations."]
pub type fiftyoneDegreesCollectionItem = fiftyone_degrees_collection_item_t;
#[doc = " Type of collection where the collection is streamed from file."]
pub type fiftyoneDegreesCollectionFile = fiftyone_degrees_collection_file_t;
#[doc = " Used to store a handle to the underlying item that could be used to release"]
#[doc = " the item when it's finished with. Also contains a reference to the data"]
#[doc = " structure used to handle memory allocation enabling memory to be reused"]
#[doc = " across multiple gets reducing the frequency of memory operations."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_collection_item_t {
    #[doc = "< Item data including allocated memory"]
    pub data: fiftyoneDegreesData,
    #[doc = "< A handle that relates to the data. i.e. a cache node"]
    pub handle: *mut ::std::os::raw::c_void,
    #[doc = "< Collection the item came from"]
    #[doc = "which may not have been set."]
    #[doc = "Should not be used by external"]
    #[doc = "code"]
    pub collection: *mut fiftyoneDegreesCollection,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_collection_item_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_collection_item_t>(),
        32usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_collection_item_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_collection_item_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_collection_item_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_item_t>())).data as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_item_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_item_t>())).handle as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_item_t),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_item_t>())).collection as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_item_t),
            "::",
            stringify!(collection)
        )
    );
}
#[doc = " Gets an item from the collection. Returns a pointer to the item, or NULL"]
#[doc = " if the item could not be loaded. The exception parameter is set to the"]
#[doc = " status code to indicate the failure."]
#[doc = " @param collection pointer to the file collection"]
#[doc = " @param offsetOrIndex index or offset to the item in the data structure"]
#[doc = " @param item pointer to the item structure to place the result in"]
#[doc = " @param exception pointer to an exception data structure to be used if an"]
#[doc = " exception occurs. See exceptions.h."]
#[doc = " @return the value in the data->ptr field, or NULL if not successful"]
pub type fiftyoneDegreesCollectionGetMethod = ::std::option::Option<
    unsafe extern "C" fn(
        collection: *mut fiftyoneDegreesCollection,
        indexOrOffset: u32,
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut ::std::os::raw::c_void,
>;
#[doc = " Passed a pointer to the first part of a variable size item and returns"]
#[doc = " the size of the entire item."]
#[doc = " @param initial pointer to the start of the item"]
#[doc = " @return size of the item in bytes"]
pub type fiftyoneDegreesCollectionGetFileVariableSizeMethod =
    ::std::option::Option<unsafe extern "C" fn(initial: *mut ::std::os::raw::c_void) -> u32>;
#[doc = " Reads the item from the underlying data file. Used by the file related"]
#[doc = " collection methods."]
#[doc = " @param collection pointer to the file collection"]
#[doc = " @param offsetOrIndex index or offset to the item in the data structure"]
#[doc = " @param data pointer to the data structure to store the item"]
#[doc = " @param exception pointer to an exception data structure to be used if an"]
#[doc = " exception occurs. See exceptions.h."]
#[doc = " @return the value in the data->ptr field, or NULL if not successful"]
pub type fiftyoneDegreesCollectionFileRead = ::std::option::Option<
    unsafe extern "C" fn(
        collection: *const fiftyoneDegreesCollectionFile,
        offsetOrIndex: u32,
        data: *mut fiftyoneDegreesData,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut ::std::os::raw::c_void,
>;
#[doc = " Compares two items and returns the difference between them for the purposes"]
#[doc = " of a binary search of ordering operation."]
#[doc = " @param state to be used for the comparison"]
#[doc = " @param item the value to compare against the state"]
#[doc = " @param curIndex the index of the current item in the collection"]
#[doc = " @param exception pointer to an exception data structure to be used if an"]
#[doc = " exception occurs. See exceptions.h"]
#[doc = " @return negative if a is lower than b, positive if a is higher than b or 0"]
#[doc = " if equal."]
pub type fiftyoneDegreesCollectionItemComparer = ::std::option::Option<
    unsafe extern "C" fn(
        state: *mut ::std::os::raw::c_void,
        item: *mut fiftyoneDegreesCollectionItem,
        curIndex: ::std::os::raw::c_long,
        exception: *mut fiftyoneDegreesException,
    ) -> ::std::os::raw::c_int,
>;
#[doc = " Releases the item so that the collection can free the memory or take"]
#[doc = " other actions when the caller no longer needs access to the item."]
#[doc = " @param item the item returned from Get to be released"]
pub type fiftyoneDegreesCollectionReleaseMethod =
    ::std::option::Option<unsafe extern "C" fn(item: *mut fiftyoneDegreesCollectionItem)>;
#[doc = " Frees all the memory and handles associated with the collection."]
#[doc = " @param collection the collection to be freed"]
pub type fiftyoneDegreesCollectionFreeMethod =
    ::std::option::Option<unsafe extern "C" fn(collection: *mut fiftyoneDegreesCollection)>;
#[doc = " Method used to iterate over data held in a collection."]
#[doc = " @param state state data for all callbacks"]
#[doc = " @param key the key used with get method of the item being returned"]
#[doc = " @param data data for the specific item"]
#[doc = " @return true if the iteration should continue, otherwise false to stop it"]
pub type fiftyoneDegreesCollectionIterateMethod = ::std::option::Option<
    unsafe extern "C" fn(
        state: *mut ::std::os::raw::c_void,
        key: u32,
        data: *mut ::std::os::raw::c_void,
    ) -> bool,
>;
#[doc = " All the shared methods and fields required by file, memory and cached"]
#[doc = " collections. The state field points to the specific collection data"]
#[doc = " structure and handles."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_collection_t {
    #[doc = "< Gets an entry into the"]
    #[doc = "item provided. The consumer MUST"]
    #[doc = "release the item when it has"]
    #[doc = "finished with the data"]
    pub get: fiftyoneDegreesCollectionGetMethod,
    #[doc = "< Releases the item"]
    #[doc = "handle"]
    pub release: fiftyoneDegreesCollectionReleaseMethod,
    #[doc = "< Frees collection"]
    #[doc = "and all items retrieved"]
    #[doc = "from the collection"]
    #[doc = "will become invalid"]
    pub freeCollection: fiftyoneDegreesCollectionFreeMethod,
    #[doc = "< Pointer to data for memory, cache or file. Either a"]
    #[doc = "#fiftyoneDegreesCollectionMemory,"]
    #[doc = "#fiftyoneDegreesCollectionFile or"]
    #[doc = "#fiftyoneDegreesCollectionCache"]
    pub state: *mut ::std::os::raw::c_void,
    #[doc = "< The next collection implementation or"]
    #[doc = "NULL"]
    pub next: *mut fiftyoneDegreesCollection,
    #[doc = "< The number of items, or 0 if not available"]
    pub count: u32,
    #[doc = "< The size of each entry, or 0 if variable length"]
    pub elementSize: u32,
    #[doc = "< Number of bytes in the source data structure containing"]
    #[doc = "the collection's data"]
    pub size: u32,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_collection_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_collection_t>(),
        56usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_collection_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_collection_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_collection_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_t>())).get as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_t),
            "::",
            stringify!(get)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_t>())).release as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_t),
            "::",
            stringify!(release)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_t>())).freeCollection as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_t),
            "::",
            stringify!(freeCollection)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_t>())).state as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_t),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_t>())).next as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_t),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_t>())).count as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_t>())).elementSize as *const _
                as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_t),
            "::",
            stringify!(elementSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_t>())).size as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_t),
            "::",
            stringify!(size)
        )
    );
}
#[doc = " Type of collection where the collection is held in continuous memory."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_collection_memory_t {
    #[doc = "< The generic collection"]
    pub collection: *mut fiftyoneDegreesCollection,
    #[doc = "< The first byte in memory of the collection"]
    pub firstByte: *mut byte,
    #[doc = "< The last byte in memory of the collection"]
    pub lastByte: *mut byte,
    #[doc = "< Memory to free when freeing the collection, or NULL"]
    #[doc = "if no memory to free"]
    pub memoryToFree: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_collection_memory_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_collection_memory_t>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_collection_memory_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_collection_memory_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_collection_memory_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_memory_t>())).collection as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_memory_t),
            "::",
            stringify!(collection)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_memory_t>())).firstByte as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_memory_t),
            "::",
            stringify!(firstByte)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_memory_t>())).lastByte as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_memory_t),
            "::",
            stringify!(lastByte)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_memory_t>())).memoryToFree
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_memory_t),
            "::",
            stringify!(memoryToFree)
        )
    );
}
#[doc = " Type of collection where the collection is held in continuous memory."]
pub type fiftyoneDegreesCollectionMemory = fiftyone_degrees_collection_memory_t;
#[doc = " Type of collection where the collection is streamed from file."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_collection_file_t {
    #[doc = "< The generic collection"]
    pub collection: *mut fiftyoneDegreesCollection,
    #[doc = "< Reader used to load items into the"]
    #[doc = "cache, or NULL if no cache"]
    pub reader: *mut fiftyoneDegreesFilePool,
    #[doc = "< Offset to the collection in the source data structure"]
    pub offset: ::std::os::raw::c_long,
    #[doc = "< Read method used to read an"]
    #[doc = "item from file at an offset or"]
    #[doc = "index"]
    pub read: fiftyoneDegreesCollectionFileRead,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_collection_file_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_collection_file_t>(),
        32usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_collection_file_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_collection_file_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_collection_file_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_file_t>())).collection as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_file_t),
            "::",
            stringify!(collection)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_file_t>())).reader as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_file_t),
            "::",
            stringify!(reader)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_file_t>())).offset as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_file_t),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_file_t>())).read as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_file_t),
            "::",
            stringify!(read)
        )
    );
}
#[doc = " Type of collection where items are cached as they are used. This is usually"]
#[doc = " used in conjunction with a file cache to speed up operation while"]
#[doc = " maintaining a small memory footprint."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_collection_cache_t {
    #[doc = "< The source collection used to load"]
    #[doc = "items into the cache"]
    pub source: *mut fiftyoneDegreesCollection,
    #[doc = "< Loading cache to use as data source"]
    pub cache: *mut fiftyoneDegreesCache,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_collection_cache_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_collection_cache_t>(),
        16usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_collection_cache_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_collection_cache_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_collection_cache_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_cache_t>())).source as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_cache_t),
            "::",
            stringify!(source)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_collection_cache_t>())).cache as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_collection_cache_t),
            "::",
            stringify!(cache)
        )
    );
}
#[doc = " Type of collection where items are cached as they are used. This is usually"]
#[doc = " used in conjunction with a file cache to speed up operation while"]
#[doc = " maintaining a small memory footprint."]
pub type fiftyoneDegreesCollectionCache = fiftyone_degrees_collection_cache_t;
extern "C" {
    #[doc = " Determines if in memory collection methods have been compiled so they are"]
    #[doc = " fully optimized. This results in the loss of file stream operation."]
    #[doc = " In memory only operation compiling without stream capabilities using the"]
    #[doc = " `FIFTYONE_DEGREES_MEMORY_ONLY` directive results in performance improvements."]
    #[doc = " @return true if the library is compiled for memory only operation, otherwise"]
    #[doc = " false."]
    pub fn fiftyoneDegreesCollectionGetIsMemoryOnly() -> bool;
}
extern "C" {
    #[doc = " Returns a 32 bit integer from collections that provide such values."]
    #[doc = " @param collection the collection of 32 bit integers"]
    #[doc = " @param indexOrOffset the index or offset of the integer required"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the 32 bit integer at the index or offset provided"]
    pub fn fiftyoneDegreesCollectionGetInteger32(
        collection: *mut fiftyoneDegreesCollection,
        indexOrOffset: u32,
        exception: *mut fiftyoneDegreesException,
    ) -> i32;
}
extern "C" {
    #[doc = " Creates a collection from the file handle at the current position in the"]
    #[doc = " file. The first 4 bytes read will be the number if fixed with items in the"]
    #[doc = " collection OR the number of bytes until the end of the collection data."]
    #[doc = " @param file a file handle positioned at the start of the collection"]
    #[doc = " @param reader a pool of file handles to use operationally to retrieve data"]
    #[doc = " from the file after the collection has been created. These are often shared"]
    #[doc = " across different collections accessing the same data file."]
    #[doc = " @param config settings for the implementation of the collection to be used."]
    #[doc = " If FIFTYONE_DEGREES_MEMORY_ONLY is defined, then this is either NULL or it"]
    #[doc = " is ignored"]
    #[doc = " @param header containing collection structure"]
    #[doc = " @param read a pointer to a function to read an item into the collection"]
    #[doc = " @return pointer to the new collection, or NULL if something went wrong"]
    pub fn fiftyoneDegreesCollectionCreateFromFile(
        file: *mut FILE,
        reader: *mut fiftyoneDegreesFilePool,
        config: *const fiftyoneDegreesCollectionConfig,
        header: fiftyoneDegreesCollectionHeader,
        read: fiftyoneDegreesCollectionFileRead,
    ) -> *mut fiftyoneDegreesCollection;
}
extern "C" {
    #[doc = " Creates the collection from a memory reader where the collection maps to"]
    #[doc = " the memory allocated to the reader. The resulting collection does not"]
    #[doc = " free the memory used to store the data. This method is used where the entire"]
    #[doc = " data structure is loaded into continuous memory and provides a high"]
    #[doc = " performance collection in all threading situations."]
    #[doc = " @param reader with access to the allocated memory"]
    #[doc = " @param header containing collection structure"]
    #[doc = " @return pointer to the memory collection, or NULL if the collection could"]
    #[doc = " not be created"]
    pub fn fiftyoneDegreesCollectionCreateFromMemory(
        reader: *mut fiftyoneDegreesMemoryReader,
        header: fiftyoneDegreesCollectionHeader,
    ) -> *mut fiftyoneDegreesCollection;
}
extern "C" {
    #[doc = " Get a handle from the file pool associated with the collection and position"]
    #[doc = " the file handle at the offset provided."]
    #[doc = " @param file pointer to the #fiftyoneDegreesCollectionFile to use for the read"]
    #[doc = " @param offset from the start of the data structure, not the entire file,"]
    #[doc = " where the item should be read from"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return a file handle for further read operations, or NULL if the offset is"]
    #[doc = " invalid, or a handle can not be obtained."]
    pub fn fiftyoneDegreesCollectionReadFilePosition(
        file: *const fiftyoneDegreesCollectionFile,
        offset: u32,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesFileHandle;
}
extern "C" {
    #[doc = " Used with collections where each item is a fixed number of bytes recorded in"]
    #[doc = " elementSize. The method will read that number of bytes into the data item"]
    #[doc = " ensuring sufficient memory is allocated."]
    #[doc = " Contained in the collection to avoid repeating this common method across"]
    #[doc = " different collection consumers."]
    #[doc = " @param file pointer to the #fiftyoneDegreesCollectionFile to use for the"]
    #[doc = " read"]
    #[doc = " @param data structure to populate with a reference to the item"]
    #[doc = " @param index zero based index of the item required in the fixed with data"]
    #[doc = " structure"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return a pointer to the item in the data structure or NULL if can't be"]
    #[doc = " found due to an invalid index"]
    pub fn fiftyoneDegreesCollectionReadFileFixed(
        file: *const fiftyoneDegreesCollectionFile,
        index: u32,
        data: *mut fiftyoneDegreesData,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Reads the 4 bytes at the current reader position and configures the"]
    #[doc = " collection header. The 4 bytes can either represent the number of fixed"]
    #[doc = " width items in the collection OR the number of bytes that follow the 4 bytes"]
    #[doc = " which form the collection. The caller must know the type of structure"]
    #[doc = " expected and set the elementSize and isCount parameters."]
    #[doc = " @param file a file handle positioned at the start of the collection"]
    #[doc = " @param elementSize if known the size in bytes of each item, or 0 for"]
    #[doc = " variable width items"]
    #[doc = " @param isCount the number of items in the collection if known"]
    #[doc = " @return a header set with the details for the collection"]
    pub fn fiftyoneDegreesCollectionHeaderFromFile(
        file: *mut FILE,
        elementSize: u32,
        isCount: bool,
    ) -> fiftyoneDegreesCollectionHeader;
}
extern "C" {
    #[doc = " Reads a variable size item from the file where the initial bytes can be used"]
    #[doc = " to calculate the size of the entire item."]
    #[doc = " @param file pointer to the #fiftyoneDegreesCollectionFile to use for the"]
    #[doc = " read"]
    #[doc = " @param data structure to populate with a reference to the item"]
    #[doc = " @param offset zero based offset to the item within the data structure"]
    #[doc = " @param initial pointer to enough memory to store the initial data"]
    #[doc = " @param initialSize amount of initial data to read"]
    #[doc = " @param getFinalSize method pass the initial pointer to get the final size"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return a pointer to the item in the data structure or NULL if can't be"]
    #[doc = " found due to an invalid index"]
    pub fn fiftyoneDegreesCollectionReadFileVariable(
        file: *const fiftyoneDegreesCollectionFile,
        data: *mut fiftyoneDegreesData,
        offset: u32,
        initial: *mut ::std::os::raw::c_void,
        initialSize: size_t,
        getFinalSize: fiftyoneDegreesCollectionGetFileVariableSizeMethod,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Reads the 4 bytes at the current reader position and configures the"]
    #[doc = " collection header. The 4 bytes can either represent the number of fixed"]
    #[doc = " width items in the collection OR the number of bytes that follow the 4 bytes"]
    #[doc = " which form the collection. The caller must know the type of structure"]
    #[doc = " expected and set the elementSize and isCount parameters."]
    #[doc = " @param reader with access to the allocated memory"]
    #[doc = " @param elementSize if known the size in bytes of each item, or 0 for"]
    #[doc = " variable width items"]
    #[doc = " @param isCount the number of items in the collection if known"]
    #[doc = " @return a header set with the details for the collection"]
    pub fn fiftyoneDegreesCollectionHeaderFromMemory(
        reader: *mut fiftyoneDegreesMemoryReader,
        elementSize: u32,
        isCount: bool,
    ) -> fiftyoneDegreesCollectionHeader;
}
extern "C" {
    #[doc = " Where a collection is fixed width and contains an ordered list of items"]
    #[doc = " this method is used to perform a divide and conquer search. The state"]
    #[doc = " and the comparer are used to compare the current index with the value"]
    #[doc = " being sought. If an item is found in the collection the item parameter"]
    #[doc = " will contain that item when the method completes. The caller will therefore"]
    #[doc = " need to release the item when it's finished with it."]
    #[doc = " @param collection to be searched"]
    #[doc = " @param item memory to be used to store the current value being compared."]
    #[doc = " Will have a lock on the item at the index returned if an item is found."]
    #[doc = " The caller should release the item when finished with it."]
    #[doc = " @param lowerIndex to start the search at"]
    #[doc = " @param upperIndex to end the search at"]
    #[doc = " @param state used with the compare method when comparing items"]
    #[doc = " @param comparer method used to perform the comparison"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the index of the item if found, otherwise -1."]
    pub fn fiftyoneDegreesCollectionBinarySearch(
        collection: *mut fiftyoneDegreesCollection,
        item: *mut fiftyoneDegreesCollectionItem,
        lowerIndex: u32,
        upperIndex: u32,
        state: *mut ::std::os::raw::c_void,
        comparer: fiftyoneDegreesCollectionItemComparer,
        exception: *mut fiftyoneDegreesException,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    #[doc = " Gets the actual number of items in the collection by iterating through to"]
    #[doc = " the base collection. In cases where there are chained collections which"]
    #[doc = " pre-load and/or cache elements, the first collections may not contain the full"]
    #[doc = " collection of elements. Therefore the value of collection->count may not be"]
    #[doc = " correct. This method follows the collection->next pointers to get to the"]
    #[doc = " base collection containing the true count."]
    #[doc = ""]
    #[doc = " It is important to note that this gets the count for a collection of fixed"]
    #[doc = " size elements, and does not apply to collections of variable sized elements."]
    #[doc = " @param collection to get the count for"]
    #[doc = " @return the number of items in the collection"]
    pub fn fiftyoneDegreesCollectionGetCount(collection: *mut fiftyoneDegreesCollection) -> u32;
}
pub type wint_t = __darwin_wint_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RuneEntry {
    pub __min: __darwin_rune_t,
    pub __max: __darwin_rune_t,
    pub __map: __darwin_rune_t,
    pub __types: *mut __uint32_t,
}
#[test]
fn bindgen_test_layout__RuneEntry() {
    assert_eq!(
        ::std::mem::size_of::<_RuneEntry>(),
        24usize,
        concat!("Size of: ", stringify!(_RuneEntry))
    );
    assert_eq!(
        ::std::mem::align_of::<_RuneEntry>(),
        8usize,
        concat!("Alignment of ", stringify!(_RuneEntry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneEntry>())).__min as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneEntry),
            "::",
            stringify!(__min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneEntry>())).__max as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneEntry),
            "::",
            stringify!(__max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneEntry>())).__map as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneEntry),
            "::",
            stringify!(__map)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneEntry>())).__types as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneEntry),
            "::",
            stringify!(__types)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RuneRange {
    pub __nranges: ::std::os::raw::c_int,
    pub __ranges: *mut _RuneEntry,
}
#[test]
fn bindgen_test_layout__RuneRange() {
    assert_eq!(
        ::std::mem::size_of::<_RuneRange>(),
        16usize,
        concat!("Size of: ", stringify!(_RuneRange))
    );
    assert_eq!(
        ::std::mem::align_of::<_RuneRange>(),
        8usize,
        concat!("Alignment of ", stringify!(_RuneRange))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneRange>())).__nranges as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneRange),
            "::",
            stringify!(__nranges)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneRange>())).__ranges as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneRange),
            "::",
            stringify!(__ranges)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RuneCharClass {
    pub __name: [::std::os::raw::c_char; 14usize],
    pub __mask: __uint32_t,
}
#[test]
fn bindgen_test_layout__RuneCharClass() {
    assert_eq!(
        ::std::mem::size_of::<_RuneCharClass>(),
        20usize,
        concat!("Size of: ", stringify!(_RuneCharClass))
    );
    assert_eq!(
        ::std::mem::align_of::<_RuneCharClass>(),
        4usize,
        concat!("Alignment of ", stringify!(_RuneCharClass))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneCharClass>())).__name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneCharClass),
            "::",
            stringify!(__name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneCharClass>())).__mask as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneCharClass),
            "::",
            stringify!(__mask)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _RuneLocale {
    pub __magic: [::std::os::raw::c_char; 8usize],
    pub __encoding: [::std::os::raw::c_char; 32usize],
    pub __sgetrune: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_char,
            arg2: __darwin_size_t,
            arg3: *mut *const ::std::os::raw::c_char,
        ) -> __darwin_rune_t,
    >,
    pub __sputrune: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: __darwin_rune_t,
            arg2: *mut ::std::os::raw::c_char,
            arg3: __darwin_size_t,
            arg4: *mut *mut ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
    >,
    pub __invalid_rune: __darwin_rune_t,
    pub __runetype: [__uint32_t; 256usize],
    pub __maplower: [__darwin_rune_t; 256usize],
    pub __mapupper: [__darwin_rune_t; 256usize],
    pub __runetype_ext: _RuneRange,
    pub __maplower_ext: _RuneRange,
    pub __mapupper_ext: _RuneRange,
    pub __variable: *mut ::std::os::raw::c_void,
    pub __variable_len: ::std::os::raw::c_int,
    pub __ncharclasses: ::std::os::raw::c_int,
    pub __charclasses: *mut _RuneCharClass,
}
#[test]
fn bindgen_test_layout__RuneLocale() {
    assert_eq!(
        ::std::mem::size_of::<_RuneLocale>(),
        3208usize,
        concat!("Size of: ", stringify!(_RuneLocale))
    );
    assert_eq!(
        ::std::mem::align_of::<_RuneLocale>(),
        8usize,
        concat!("Alignment of ", stringify!(_RuneLocale))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__magic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__encoding as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__encoding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__sgetrune as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__sgetrune)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__sputrune as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__sputrune)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__invalid_rune as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__invalid_rune)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__runetype as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__runetype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__maplower as *const _ as usize },
        1084usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__maplower)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__mapupper as *const _ as usize },
        2108usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__mapupper)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__runetype_ext as *const _ as usize },
        3136usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__runetype_ext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__maplower_ext as *const _ as usize },
        3152usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__maplower_ext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__mapupper_ext as *const _ as usize },
        3168usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__mapupper_ext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__variable as *const _ as usize },
        3184usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__variable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__variable_len as *const _ as usize },
        3192usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__variable_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__ncharclasses as *const _ as usize },
        3196usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__ncharclasses)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RuneLocale>())).__charclasses as *const _ as usize },
        3200usize,
        concat!(
            "Offset of field: ",
            stringify!(_RuneLocale),
            "::",
            stringify!(__charclasses)
        )
    );
}
extern "C" {
    pub static mut _DefaultRuneLocale: _RuneLocale;
}
extern "C" {
    pub static mut _CurrentRuneLocale: *mut _RuneLocale;
}
extern "C" {
    pub fn ___runetype(arg1: __darwin_ct_rune_t) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn ___tolower(arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t;
}
extern "C" {
    pub fn ___toupper(arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t;
}
extern "C" {
    pub fn __maskrune(
        arg1: __darwin_ct_rune_t,
        arg2: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __toupper(arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t;
}
extern "C" {
    pub fn __tolower(arg1: __darwin_ct_rune_t) -> __darwin_ct_rune_t;
}
#[doc = " Struture that represents 51Degrees implementation, which encapsulate"]
#[doc = " an array of 4 bytes. This array will be formated accordingly to"]
#[doc = " the IEEE standard"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_float_type {
    pub value: [byte; 4usize],
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_float_type() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_float_type>(),
        4usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_float_type))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_float_type>(),
        1usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_float_type))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_float_type>())).value as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_float_type),
            "::",
            stringify!(value)
        )
    );
}
#[doc = " Struture that represents 51Degrees implementation, which encapsulate"]
#[doc = " an array of 4 bytes. This array will be formated accordingly to"]
#[doc = " the IEEE standard"]
pub type fiftyoneDegreesFloatInternal = fiftyone_degrees_float_type;
#[doc = " Union that breaks down 51Degrees implementation to its components:"]
#[doc = " sign, exponent and mantissa."]
#[repr(C)]
#[derive(Copy, Clone)]
pub union fiftyoneDegreesFloatU {
    pub fValue: fiftyoneDegreesFloatInternal,
    pub parts: fiftyoneDegreesFloatU__bindgen_ty_1,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct fiftyoneDegreesFloatU__bindgen_ty_1 {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_fiftyoneDegreesFloatU__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<fiftyoneDegreesFloatU__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(fiftyoneDegreesFloatU__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyoneDegreesFloatU__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyoneDegreesFloatU__bindgen_ty_1)
        )
    );
}
impl fiftyoneDegreesFloatU__bindgen_ty_1 {
    #[inline]
    pub fn mantissa(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 23u8) as u32) }
    }
    #[inline]
    pub fn set_mantissa(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 23u8, val as u64)
        }
    }
    #[inline]
    pub fn exponent(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_exponent(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn sign(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sign(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mantissa: u32,
        exponent: u32,
        sign: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 23u8, {
            let mantissa: u32 = unsafe { ::std::mem::transmute(mantissa) };
            mantissa as u64
        });
        __bindgen_bitfield_unit.set(23usize, 8u8, {
            let exponent: u32 = unsafe { ::std::mem::transmute(exponent) };
            exponent as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let sign: u32 = unsafe { ::std::mem::transmute(sign) };
            sign as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_fiftyoneDegreesFloatU() {
    assert_eq!(
        ::std::mem::size_of::<fiftyoneDegreesFloatU>(),
        4usize,
        concat!("Size of: ", stringify!(fiftyoneDegreesFloatU))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyoneDegreesFloatU>(),
        4usize,
        concat!("Alignment of ", stringify!(fiftyoneDegreesFloatU))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyoneDegreesFloatU>())).fValue as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegreesFloatU),
            "::",
            stringify!(fValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyoneDegreesFloatU>())).parts as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegreesFloatU),
            "::",
            stringify!(parts)
        )
    );
}
extern "C" {
    #[doc = " Function that converts from a 51Degrees float implementation to a"]
    #[doc = " native float value."]
    #[doc = " @param f input 51Degrees float value"]
    #[doc = " @return a native float value"]
    pub fn fiftyoneDegreesFloatToNative(f: fiftyoneDegreesFloatInternal) -> f32;
}
extern "C" {
    #[doc = " Function that converts from a native float value to 51Degrees float"]
    #[doc = " value."]
    #[doc = " @param f input native float value"]
    #[doc = " @return a 51Degrees float value"]
    pub fn fiftyoneDegreesNativeToFloat(f: f32) -> fiftyoneDegreesFloatInternal;
}
extern "C" {
    #[doc = " Function that compare if two 51Degrees float values are equal"]
    #[doc = " @param f1 first input 51Degrees float value"]
    #[doc = " @param f2 second input 51Degrees float value"]
    #[doc = " @return 0 if the two are equal and 1 if they are not."]
    pub fn fiftyoneDegreesFloatIsEqual(
        f1: fiftyoneDegreesFloatInternal,
        f2: fiftyoneDegreesFloatInternal,
    ) -> ::std::os::raw::c_int;
}
#[doc = " Define 51Degrees float implementation as the internal type"]
#[doc = " IEEE standard is not supported in this case"]
pub type fiftyoneDegreesFloat = fiftyoneDegreesFloatInternal;
#[doc = "< Format is a pair of floats for latitude"]
#[doc = "and longitude values"]
pub const fiftyone_degrees_string_format_FIFTYONE_DEGREES_STRING_COORDINATE:
    fiftyone_degrees_string_format = 1;
#[doc = "< Format is a byte array representation of an"]
#[doc = "IP address"]
pub const fiftyone_degrees_string_format_FIFTYONE_DEGREES_STRING_IP_ADDRESS:
    fiftyone_degrees_string_format = 2;
#[doc = " Enumeration to indicate what format is held in a string item"]
#[doc = " These are the values that can be held at the first byte of"]
#[doc = " the #fiftyoneDegreeString value."]
pub type fiftyone_degrees_string_format = ::std::os::raw::c_uint;
#[doc = " Enumeration to indicate what format is held in a string item"]
#[doc = " These are the values that can be held at the first byte of"]
#[doc = " the #fiftyoneDegreeString value."]
pub use self::fiftyone_degrees_string_format as fiftyoneDegreesStringFormat;
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct fiftyone_degrees_string_t {
    #[doc = "< Size of the string in memory"]
    pub size: i16,
    #[doc = "< The first character of the string"]
    pub value: ::std::os::raw::c_char,
    pub trail: fiftyone_degrees_string_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union fiftyone_degrees_string_t__bindgen_ty_1 {
    #[doc = "< If the string is an IP address, this will be the start byte"]
    pub secondValue: ::std::os::raw::c_char,
    #[doc = "< If the string is a coordinate, this will hold the value"]
    pub coordinate: fiftyone_degrees_string_t__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_string_t__bindgen_ty_1__bindgen_ty_1 {
    pub lat: fiftyoneDegreesFloat,
    pub lon: fiftyoneDegreesFloat,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_string_t__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_string_t__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_string_t__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_string_t__bindgen_ty_1__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_string_t__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_string_t__bindgen_ty_1__bindgen_ty_1>())).lat
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_string_t__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(lat)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_string_t__bindgen_ty_1__bindgen_ty_1>())).lon
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_string_t__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(lon)
        )
    );
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_string_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_string_t__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_string_t__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_string_t__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_string_t__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_string_t__bindgen_ty_1>())).secondValue
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_string_t__bindgen_ty_1),
            "::",
            stringify!(secondValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_string_t__bindgen_ty_1>())).coordinate
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_string_t__bindgen_ty_1),
            "::",
            stringify!(coordinate)
        )
    );
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_string_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_string_t>(),
        11usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_string_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_string_t>(),
        1usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_string_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_string_t>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_string_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_string_t>())).value as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_string_t),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_string_t>())).trail as *const _ as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_string_t),
            "::",
            stringify!(trail)
        )
    );
}
pub type fiftyoneDegreesString = fiftyone_degrees_string_t;
extern "C" {
    #[doc = " Reads a string from the source file at the offset within the string"]
    #[doc = " structure."]
    #[doc = " @param file collection to read from"]
    #[doc = " @param offset of the string in the collection"]
    #[doc = " @param data to store the new string in"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return a pointer to the string collection item or NULL if can't be found"]
    pub fn fiftyoneDegreesStringRead(
        file: *const fiftyoneDegreesCollectionFile,
        offset: u32,
        data: *mut fiftyoneDegreesData,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Gets the string at the required offset from the collection provided."]
    #[doc = " @param strings collection to get the string from"]
    #[doc = " @param offset of the string in the collection"]
    #[doc = " @param item to store the string in"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return a pointer to string of NULL if the offset is not valid"]
    pub fn fiftyoneDegreesStringGet(
        strings: *mut fiftyoneDegreesCollection,
        offset: u32,
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesString;
}
extern "C" {
    #[doc = " Case insensitively compare two strings up to the length requested."]
    #[doc = " @param a string to compare"]
    #[doc = " @param b other string to compare"]
    #[doc = " @param length of the strings to compare"]
    #[doc = " @return 0 if same"]
    pub fn fiftyoneDegreesStringCompareLength(
        a: *const ::std::os::raw::c_char,
        b: *const ::std::os::raw::c_char,
        length: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Case insensitively compare two strings."]
    #[doc = " @param a string to compare"]
    #[doc = " @param b other string to compare"]
    #[doc = " @return 0 if same"]
    pub fn fiftyoneDegreesStringCompare(
        a: *const ::std::os::raw::c_char,
        b: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Case insensitively searching a first occurence of a"]
    #[doc = " substring."]
    #[doc = " @param a string to search"]
    #[doc = " @param b substring to be searched for"]
    #[doc = " @return pointer to the first occurence or NULL if not found"]
    pub fn fiftyoneDegreesStringSubString(
        a: *const ::std::os::raw::c_char,
        b: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
#[doc = " List structure which contains a list of collection items."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_list_t {
    #[doc = "< Array of items"]
    pub items: *mut fiftyoneDegreesCollectionItem,
    #[doc = "< Capacity of the list to store items"]
    pub capacity: u32,
    #[doc = "< Number of items currently in the list"]
    pub count: u32,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_list_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_list_t>(),
        16usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_list_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_list_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_list_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_list_t>())).items as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_list_t),
            "::",
            stringify!(items)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_list_t>())).capacity as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_list_t),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_list_t>())).count as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_list_t),
            "::",
            stringify!(count)
        )
    );
}
#[doc = " List structure which contains a list of collection items."]
pub type fiftyoneDegreesList = fiftyone_degrees_list_t;
extern "C" {
    #[doc = " Initialise the list by allocating space for the items in the list structure."]
    #[doc = " @param list pointer to list structure to initialise"]
    #[doc = " @param capacity number of items expected in the list"]
    #[doc = " @return the initialised list or NULL if memory could not be allocated"]
    pub fn fiftyoneDegreesListInit(
        list: *mut fiftyoneDegreesList,
        capacity: u32,
    ) -> *mut fiftyoneDegreesList;
}
extern "C" {
    #[doc = " Adds a collection item to a list. The reference to the item will be released"]
    #[doc = " when the list is released or freed."]
    #[doc = " @param list to add the item to"]
    #[doc = " @param item to add to the list"]
    pub fn fiftyoneDegreesListAdd(
        list: *mut fiftyoneDegreesList,
        item: *mut fiftyoneDegreesCollectionItem,
    );
}
extern "C" {
    #[doc = " Gets the item at the index provided as a string."]
    #[doc = " @param list to get the item from"]
    #[doc = " @param index of the item in the list"]
    #[doc = " @return the requested list item as a string"]
    pub fn fiftyoneDegreesListGetAsString(
        list: *mut fiftyoneDegreesList,
        index: ::std::os::raw::c_int,
    ) -> *mut fiftyoneDegreesString;
}
extern "C" {
    #[doc = " Frees the memory allocated to the list structure and release all items"]
    #[doc = " stored in it."]
    #[doc = " @param list to free"]
    pub fn fiftyoneDegreesListFree(list: *mut fiftyoneDegreesList);
}
extern "C" {
    #[doc = " Resets a newly allocated list to a clean empty state."]
    #[doc = " @param list to reset"]
    pub fn fiftyoneDegreesListReset(list: *mut fiftyoneDegreesList);
}
extern "C" {
    #[doc = " Releases all the items stored in the list."]
    #[doc = " @param list to release"]
    pub fn fiftyoneDegreesListRelease(list: *mut fiftyoneDegreesList);
}
#[doc = " Key value pair contained in each component. This can point to anything. For"]
#[doc = " example, in the Hash device detection API, the key is the unique id of an"]
#[doc = " HTTP header, and the value is the index of the set of root nodes to use."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyoneDegrees_component_keyvaluepair_t {
    #[doc = "< Integer key"]
    pub key: u32,
    #[doc = "< Integer value"]
    pub value: u32,
}
#[test]
fn bindgen_test_layout_fiftyoneDegrees_component_keyvaluepair_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyoneDegrees_component_keyvaluepair_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(fiftyoneDegrees_component_keyvaluepair_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyoneDegrees_component_keyvaluepair_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyoneDegrees_component_keyvaluepair_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_component_keyvaluepair_t>())).key as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_component_keyvaluepair_t),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_component_keyvaluepair_t>())).value as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_component_keyvaluepair_t),
            "::",
            stringify!(value)
        )
    );
}
#[doc = " Key value pair contained in each component. This can point to anything. For"]
#[doc = " example, in the Hash device detection API, the key is the unique id of an"]
#[doc = " HTTP header, and the value is the index of the set of root nodes to use."]
pub type fiftyoneDegreesComponentKeyValuePair = fiftyoneDegrees_component_keyvaluepair_t;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyoneDegrees_component_t {
    #[doc = "< The unique Id of the component."]
    pub componentId: byte,
    #[doc = "< Offset in the strings data structure to the"]
    #[doc = "name"]
    pub nameOffset: i32,
    #[doc = "< Offset in the profiles data"]
    #[doc = "structure to the default profile"]
    pub defaultProfileOffset: i32,
    #[doc = "< The number of key value pairs at"]
    #[doc = "firstKeyValuePair"]
    pub keyValuesCount: u16,
    #[doc = "< The"]
    #[doc = "first key"]
    #[doc = "value pair"]
    pub firstKeyValuePair: fiftyoneDegreesComponentKeyValuePair,
}
#[test]
fn bindgen_test_layout_fiftyoneDegrees_component_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyoneDegrees_component_t>(),
        19usize,
        concat!("Size of: ", stringify!(fiftyoneDegrees_component_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyoneDegrees_component_t>(),
        1usize,
        concat!("Alignment of ", stringify!(fiftyoneDegrees_component_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_component_t>())).componentId as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_component_t),
            "::",
            stringify!(componentId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_component_t>())).nameOffset as *const _ as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_component_t),
            "::",
            stringify!(nameOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_component_t>())).defaultProfileOffset as *const _
                as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_component_t),
            "::",
            stringify!(defaultProfileOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_component_t>())).keyValuesCount as *const _
                as usize
        },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_component_t),
            "::",
            stringify!(keyValuesCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_component_t>())).firstKeyValuePair as *const _
                as usize
        },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_component_t),
            "::",
            stringify!(firstKeyValuePair)
        )
    );
}
pub type fiftyoneDegreesComponent = fiftyoneDegrees_component_t;
extern "C" {
    #[doc = " Returns the string name of the component using the item provided. The"]
    #[doc = " collection item must be released when the caller is finished with the"]
    #[doc = " string."]
    #[doc = " @param component structure for the name required."]
    #[doc = " @param stringsCollection collection of strings retrieved by offsets."]
    #[doc = " @param item used to store the resulting string in."]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    #[doc = " @return a pointer to a string in the collection item data structure."]
    pub fn fiftyoneDegreesComponentGetName(
        stringsCollection: *mut fiftyoneDegreesCollection,
        component: *mut fiftyoneDegreesComponent,
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesString;
}
extern "C" {
    #[doc = " Get a pointer to the key value pair at the specified index within the"]
    #[doc = " component's key value pairs list."]
    #[doc = " This pointer does not need to be freed by the caller."]
    #[doc = " @param component to get the pair from"]
    #[doc = " @param index of the pair within the component"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    #[doc = " @return pointer to a key value pair"]
    pub fn fiftyoneDegreesComponentGetKeyValuePair(
        component: *mut fiftyoneDegreesComponent,
        index: u16,
        exception: *mut fiftyoneDegreesException,
    ) -> *const fiftyoneDegreesComponentKeyValuePair;
}
extern "C" {
    #[doc = " Initialises the list of components. This holds a reference to the collection"]
    #[doc = " items so that collection get methods do not need to be called repeatedly."]
    #[doc = " @param components collection containing the components to add to the list"]
    #[doc = " @param list to add the components to"]
    #[doc = " @param count number of components in the collection"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    pub fn fiftyoneDegreesComponentInitList(
        components: *mut fiftyoneDegreesCollection,
        list: *mut fiftyoneDegreesList,
        count: u32,
        exception: *mut fiftyoneDegreesException,
    );
}
extern "C" {
    #[doc = " Read a component from the file collection provided and store in the data"]
    #[doc = " pointer. This method is used when creating a collection from file."]
    #[doc = " @param file collection to read from"]
    #[doc = " @param offset of the component in the collection"]
    #[doc = " @param data to store the resulting component in"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    #[doc = " @return pointer to the component allocated within the data structure"]
    pub fn fiftyoneDegreesComponentReadFromFile(
        file: *const fiftyoneDegreesCollectionFile,
        offset: u32,
        data: *mut fiftyoneDegreesData,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Get the default profile id for the component provided."]
    #[doc = " @param profiles collection containing the profiles from the same data set as"]
    #[doc = " the component"]
    #[doc = " @param component to get the default profile id for"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    pub fn fiftyoneDegreesComponentGetDefaultProfileId(
        profiles: *mut fiftyoneDegreesCollection,
        component: *mut fiftyoneDegreesComponent,
        exception: *mut fiftyoneDegreesException,
    ) -> u32;
}
#[doc = " Base configuration structure containing common configuration options, and"]
#[doc = " options that apply to structures and methods in the common library."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_config_base_t {
    #[doc = "< True if the data file should be loaded entirely into"]
    #[doc = "continuous memory."]
    pub allInMemory: bool,
    #[doc = "< True if the HTTP header field names"]
    #[doc = "MIGHT include the prefix HTTP_"]
    pub usesUpperPrefixedHeaders: bool,
    #[doc = "< True if the memory containing the data set should be"]
    #[doc = "freed after it is no longer needed. This only applies to"]
    #[doc = "externally allocated memory, anything allocated"]
    #[doc = "internally is automatically freed."]
    pub freeData: bool,
    #[doc = "< Indicates whether a temporary file should be created"]
    #[doc = "instead of using the original file."]
    pub useTempFile: bool,
    #[doc = "< Indicates that an existing temp file may be used."]
    #[doc = "This should be selected if multiple instances wish"]
    #[doc = "to use the same file to prevent high disk usage."]
    pub reuseTempFile: bool,
    #[doc = "< Array of temp directories which can be used in"]
    #[doc = "order of preference."]
    pub tempDirs: *mut *const ::std::os::raw::c_char,
    #[doc = "< Number of directories in the tempDirs array."]
    pub tempDirCount: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_config_base_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_config_base_t>(),
        24usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_config_base_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_config_base_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_config_base_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_base_t>())).allInMemory as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_base_t),
            "::",
            stringify!(allInMemory)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_base_t>())).usesUpperPrefixedHeaders
                as *const _ as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_base_t),
            "::",
            stringify!(usesUpperPrefixedHeaders)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_base_t>())).freeData as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_base_t),
            "::",
            stringify!(freeData)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_base_t>())).useTempFile as *const _
                as usize
        },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_base_t),
            "::",
            stringify!(useTempFile)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_base_t>())).reuseTempFile as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_base_t),
            "::",
            stringify!(reuseTempFile)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_base_t>())).tempDirs as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_base_t),
            "::",
            stringify!(tempDirs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_base_t>())).tempDirCount as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_base_t),
            "::",
            stringify!(tempDirCount)
        )
    );
}
#[doc = " Base configuration structure containing common configuration options, and"]
#[doc = " options that apply to structures and methods in the common library."]
pub type fiftyoneDegreesConfigBase = fiftyone_degrees_config_base_t;
#[doc = " @cond FORWARD_DECLARATIONS"]
pub type fiftyoneDegreesResourceManager = fiftyone_degrees_resource_manager_t;
#[doc = " Handle for a shared resource. The first data structure counter tracks use"]
#[doc = " of the resource and free resources that are not longer active."]
#[doc = " Counter must be the first member to ensure correct memory aligned for"]
#[doc = " interlocked operations."]
pub type fiftyoneDegreesResourceHandle = fiftyone_degrees_resource_handle_t;
#[doc = " Handle for a shared resource. The first data structure counter tracks use"]
#[doc = " of the resource and free resources that are not longer active."]
#[doc = " Counter must be the first member to ensure correct memory aligned for"]
#[doc = " interlocked operations."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_resource_handle_t {
    #[doc = "< Counter for this"]
    #[doc = "handle."]
    pub counter: fiftyoneDegreesInterlockDoubleWidth,
    #[doc = "< Pointer to the resource being managed."]
    pub resource: *const ::std::os::raw::c_void,
    #[doc = "< Pointer to the manager"]
    #[doc = "the handle relates to."]
    pub manager: *const fiftyoneDegreesResourceManager,
    #[doc = "< Pointer to the method used to free the"]
    #[doc = "resource."]
    pub freeResource:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_resource_handle_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_resource_handle_t>(),
        40usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_resource_handle_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_resource_handle_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_resource_handle_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_resource_handle_t>())).counter as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_resource_handle_t),
            "::",
            stringify!(counter)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_resource_handle_t>())).resource as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_resource_handle_t),
            "::",
            stringify!(resource)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_resource_handle_t>())).manager as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_resource_handle_t),
            "::",
            stringify!(manager)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_resource_handle_t>())).freeResource as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_resource_handle_t),
            "::",
            stringify!(freeResource)
        )
    );
}
#[doc = " Manager structure used to provide access to a shared and changing resource."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_resource_manager_t {
    #[doc = "< Current handle"]
    #[doc = "for resource used"]
    #[doc = "by the manager."]
    pub active: *mut fiftyoneDegreesResourceHandle,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_resource_manager_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_resource_manager_t>(),
        8usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_resource_manager_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_resource_manager_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_resource_manager_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_resource_manager_t>())).active as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_resource_manager_t),
            "::",
            stringify!(active)
        )
    );
}
extern "C" {
    #[doc = " Initialise a preallocated resource manager structure with a resource for it"]
    #[doc = " to manage access to."]
    #[doc = " The resourceHandle parameter must point to the handle within the resource"]
    #[doc = " under management so that the handle can be assigned to the resource before"]
    #[doc = " the resource is placed under management."]
    #[doc = ""]
    #[doc = " @param manager the resource manager to initialise with the resource"]
    #[doc = " @param resource pointer to the resource which the manager should manage"]
    #[doc = " access to"]
    #[doc = " @param resourceHandle points to the location the new handle should be stored"]
    #[doc = " @param freeResource method to use when freeing the resource"]
    pub fn fiftyoneDegreesResourceManagerInit(
        manager: *mut fiftyoneDegreesResourceManager,
        resource: *mut ::std::os::raw::c_void,
        resourceHandle: *mut *mut fiftyoneDegreesResourceHandle,
        freeResource: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void),
        >,
    );
}
extern "C" {
    #[doc = " Frees any data associated with the manager and releases the manager. All"]
    #[doc = " memory is released after this operation."]
    #[doc = ""]
    #[doc = " @param manager the resource manager to be freed"]
    pub fn fiftyoneDegreesResourceManagerFree(manager: *mut fiftyoneDegreesResourceManager);
}
extern "C" {
    #[doc = " Increments the usage counter for the resource and returns a handle that can"]
    #[doc = " be used to reference it. The handle **MUST** be used to decrement the use"]
    #[doc = " count using the #fiftyoneDegreesResourceHandleDecUse method when the"]
    #[doc = " resource is finished with. The resource can be guaranteed not to be freed"]
    #[doc = " until after the decrement method has been called."]
    #[doc = " @param manager the resource manager to initialise with the resource"]
    pub fn fiftyoneDegreesResourceHandleIncUse(
        manager: *mut fiftyoneDegreesResourceManager,
    ) -> *mut fiftyoneDegreesResourceHandle;
}
extern "C" {
    #[doc = " Decrements the usage counter. If the count reaches zero then resource will"]
    #[doc = " become eligible to be freed either when the manager replaces it or when the"]
    #[doc = " manager is freed."]
    #[doc = " @param handle to the resource which should be released by the manager"]
    pub fn fiftyoneDegreesResourceHandleDecUse(handle: *mut fiftyoneDegreesResourceHandle);
}
extern "C" {
    #[doc = " Return the current usage counter."]
    #[doc = " WARNING: This call is not thread-safe and is suitable for using in"]
    #[doc = " testing only."]
    #[doc = " @param handle to the resource which should be released by the manager"]
    #[doc = " @return the current usage counter"]
    pub fn fiftyoneDegreesResourceHandleGetUse(handle: *mut fiftyoneDegreesResourceHandle) -> i32;
}
extern "C" {
    #[doc = " Replaces the resource with the new resource. If the existing resource is"]
    #[doc = " not being used it will be freed. Otherwise it is left to the decrement"]
    #[doc = " function to free the resource when the usage count is zero."]
    #[doc = " @param manager the resource manager to initialise with the resource"]
    #[doc = " @param newResource pointer to the resource which the manager should manage"]
    #[doc = " access to"]
    #[doc = " @param newResourceHandle points to the location the new handle should be"]
    #[doc = " stored"]
    pub fn fiftyoneDegreesResourceReplace(
        manager: *mut fiftyoneDegreesResourceManager,
        newResource: *mut ::std::os::raw::c_void,
        newResourceHandle: *mut *mut fiftyoneDegreesResourceHandle,
    );
}
#[doc = " Index in the properties collection to a property which is required to get"]
#[doc = " evidence for another property."]
pub type fiftyoneDegreesEvidencePropertyIndex = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_array_fiftyoneDegreesEvidencePropertyIndex_t {
    pub count: u32,
    pub capacity: u32,
    pub items: *mut fiftyoneDegreesEvidencePropertyIndex,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_array_fiftyoneDegreesEvidencePropertyIndex_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_array_fiftyoneDegreesEvidencePropertyIndex_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesEvidencePropertyIndex_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_array_fiftyoneDegreesEvidencePropertyIndex_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesEvidencePropertyIndex_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesEvidencePropertyIndex_t>(
            )))
            .count as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesEvidencePropertyIndex_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesEvidencePropertyIndex_t>(
            )))
            .capacity as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesEvidencePropertyIndex_t),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesEvidencePropertyIndex_t>(
            )))
            .items as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesEvidencePropertyIndex_t),
            "::",
            stringify!(items)
        )
    );
}
pub type fiftyoneDegreesEvidencePropertyIndexArray =
    fiftyone_degrees_array_fiftyoneDegreesEvidencePropertyIndex_t;
#[doc = " Array of properties which are required to fetch additional evidence for"]
#[doc = " a specific property."]
pub type fiftyoneDegreesEvidenceProperties = fiftyoneDegreesEvidencePropertyIndexArray;
#[doc = " Used to access the property item quickly without the need to search."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_property_available_t {
    #[doc = "< Index of the property in the collection of all"]
    #[doc = "properties"]
    pub propertyIndex: u32,
    #[doc = "< Name of the property from strings"]
    pub name: fiftyoneDegreesCollectionItem,
    #[doc = "< Evidence"]
    #[doc = "properties which are"]
    #[doc = "required by this"]
    #[doc = "property"]
    pub evidenceProperties: *mut fiftyoneDegreesEvidenceProperties,
    #[doc = "< True if the execution any JavaScript returned as"]
    #[doc = "a value of this property should be delayed. False if"]
    #[doc = "it should be run immediately. This is always"]
    #[doc = "initialized to false, so should be set by the calling"]
    #[doc = "function"]
    pub delayExecution: bool,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_property_available_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_property_available_t>(),
        56usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_property_available_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_property_available_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_property_available_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_property_available_t>())).propertyIndex
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_property_available_t),
            "::",
            stringify!(propertyIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_property_available_t>())).name as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_property_available_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_property_available_t>())).evidenceProperties
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_property_available_t),
            "::",
            stringify!(evidenceProperties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_property_available_t>())).delayExecution
                as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_property_available_t),
            "::",
            stringify!(delayExecution)
        )
    );
}
#[doc = " Used to access the property item quickly without the need to search."]
pub type fiftyoneDegreesPropertyAvailable = fiftyone_degrees_property_available_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_array_fiftyoneDegreesPropertyAvailable_t {
    pub count: u32,
    pub capacity: u32,
    pub items: *mut fiftyoneDegreesPropertyAvailable,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_array_fiftyoneDegreesPropertyAvailable_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_array_fiftyoneDegreesPropertyAvailable_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesPropertyAvailable_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_array_fiftyoneDegreesPropertyAvailable_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesPropertyAvailable_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesPropertyAvailable_t>()))
                .count as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesPropertyAvailable_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesPropertyAvailable_t>()))
                .capacity as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesPropertyAvailable_t),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesPropertyAvailable_t>()))
                .items as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesPropertyAvailable_t),
            "::",
            stringify!(items)
        )
    );
}
pub type fiftyoneDegreesPropertyAvailableArray =
    fiftyone_degrees_array_fiftyoneDegreesPropertyAvailable_t;
#[doc = " Array of properties which are available in a data set."]
pub type fiftyoneDegreesPropertiesAvailable = fiftyoneDegreesPropertyAvailableArray;
#[doc = " Defines a set of properties which are required by a caller. Usually to a"]
#[doc = " data set creation method."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_properties_required_t {
    #[doc = "< Array of required properties or NULL if all"]
    #[doc = "properties are required. See the count property for"]
    #[doc = "the number of items in the array"]
    pub array: *mut *const ::std::os::raw::c_char,
    #[doc = "< Number of properties in array"]
    pub count: ::std::os::raw::c_int,
    #[doc = "< Separated list of required properties or NULL if"]
    #[doc = "all properties are required"]
    pub string: *const ::std::os::raw::c_char,
    #[doc = "< A pointer to an existing"]
    #[doc = "set of property names"]
    #[doc = "from another instance"]
    pub existing: *mut fiftyoneDegreesPropertiesAvailable,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_properties_required_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_properties_required_t>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_properties_required_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_properties_required_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_properties_required_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_properties_required_t>())).array as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_properties_required_t),
            "::",
            stringify!(array)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_properties_required_t>())).count as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_properties_required_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_properties_required_t>())).string as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_properties_required_t),
            "::",
            stringify!(string)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_properties_required_t>())).existing as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_properties_required_t),
            "::",
            stringify!(existing)
        )
    );
}
#[doc = " Defines a set of properties which are required by a caller. Usually to a"]
#[doc = " data set creation method."]
pub type fiftyoneDegreesPropertiesRequired = fiftyone_degrees_properties_required_t;
#[doc = " Returns a string for the property at the index provided or NULL if there"]
#[doc = " is no property available at the index."]
#[doc = " @param state resource used to obtain the string"]
#[doc = " @param index of the property"]
#[doc = " @param item used to obtain a handle to the string"]
#[doc = " @return pointer to the string or NULL if no property available"]
pub type fiftyoneDegreesPropertiesGetMethod = ::std::option::Option<
    unsafe extern "C" fn(
        state: *mut ::std::os::raw::c_void,
        index: u32,
        item: *mut fiftyoneDegreesCollectionItem,
    ) -> *mut fiftyoneDegreesString,
>;
#[doc = " Populates the evidence properties structure with the indexes of the"]
#[doc = " properties required by the property provided, and returns the number"]
#[doc = " of property indexes which were added. If the evidence properties structure"]
#[doc = " is null, then this method returns the count but does not populate the"]
#[doc = " structure."]
#[doc = " @param state pointer to data which the method may need to use"]
#[doc = " @param property pointer to the property to get the evidence properties for"]
#[doc = " @param evidenceProperties pointer to the pre-allocated structure to populate"]
#[doc = " with the evidence property indexes"]
#[doc = " @return the number of property indexes added to the structure. Or the number"]
#[doc = " which would have been added were it not null"]
pub type fiftyoneDegreesEvidencePropertiesGetMethod = ::std::option::Option<
    unsafe extern "C" fn(
        state: *mut ::std::os::raw::c_void,
        property: *mut fiftyoneDegreesPropertyAvailable,
        evidenceProperties: *mut fiftyoneDegreesEvidenceProperties,
    ) -> u32,
>;
extern "C" {
    pub static mut fiftyoneDegreesPropertiesDefault: fiftyoneDegreesPropertiesRequired;
}
extern "C" {
    #[doc = " Creates a properties result instance for use with future property"]
    #[doc = " operations. The resulting required properties will be provided in ascending"]
    #[doc = " order."]
    #[doc = " @param properties required to be available as either a separated list of"]
    #[doc = " property names, an array of property names or an existing properties results"]
    #[doc = " structure from another data set. Valid separators include pipe, comma and"]
    #[doc = " space. The fields are evaluated in order of existing, array and then string."]
    #[doc = " the first field with a value is used."]
    #[doc = " @param state pointer to state used with the get method"]
    #[doc = " @param getPropertyMethod method used to return the property name from a"]
    #[doc = " string collection"]
    #[doc = " @param getEvidencePropertiesMethod method used to populate the evidence"]
    #[doc = " properties for a property"]
    #[doc = " @return instance of a properties result for use with future properties"]
    #[doc = " methods"]
    pub fn fiftyoneDegreesPropertiesCreate(
        properties: *mut fiftyoneDegreesPropertiesRequired,
        state: *mut ::std::os::raw::c_void,
        getPropertyMethod: fiftyoneDegreesPropertiesGetMethod,
        getEvidencePropertiesMethod: fiftyoneDegreesEvidencePropertiesGetMethod,
    ) -> *mut fiftyoneDegreesPropertiesAvailable;
}
extern "C" {
    #[doc = " Gets the index of the property in the source data structure from the name."]
    #[doc = " @param available properties instance"]
    #[doc = " @param propertyName string containing the property name"]
    #[doc = " @return 0 based index of the property in the source or -1 if not available"]
    pub fn fiftyoneDegreesPropertiesGetPropertyIndexFromName(
        available: *mut fiftyoneDegreesPropertiesAvailable,
        propertyName: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Gets the required property index in the list of all required properties from"]
    #[doc = " the name."]
    #[doc = " @param available properties instance"]
    #[doc = " @param propertyName string containing the property name"]
    #[doc = " @return 0 based index of the property in the required properties or -1 if"]
    #[doc = " not available"]
    pub fn fiftyoneDegreesPropertiesGetRequiredPropertyIndexFromName(
        available: *mut fiftyoneDegreesPropertiesAvailable,
        propertyName: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Maps the required property index to the index in the source data structure."]
    #[doc = " @param available properties instance"]
    #[doc = " @param requiredPropertyIndex index of the property in the required"]
    #[doc = " properties structure"]
    #[doc = " @return 0 based index of the property in the source or -1 if not available"]
    pub fn fiftyoneDegreesPropertiesGetPropertyIndexFromRequiredIndex(
        available: *mut fiftyoneDegreesPropertiesAvailable,
        requiredPropertyIndex: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Gets the name as a string from the required property index."]
    #[doc = " @param available properties instance"]
    #[doc = " @param requiredPropertyIndex index of the property in the required"]
    #[doc = " properties structure"]
    #[doc = " @return string representation of the property"]
    pub fn fiftyoneDegreesPropertiesGetNameFromRequiredIndex(
        available: *mut fiftyoneDegreesPropertiesAvailable,
        requiredPropertyIndex: ::std::os::raw::c_int,
    ) -> *mut fiftyoneDegreesString;
}
extern "C" {
    #[doc = " Check if the 'SetHeader' properties are included in the"]
    #[doc = " available required properties."]
    #[doc = " @param available properties instance"]
    #[doc = " @return bool whether 'SetHeader' properties are included"]
    pub fn fiftyoneDegreesPropertiesIsSetHeaderAvailable(
        available: *mut fiftyoneDegreesPropertiesAvailable,
    ) -> bool;
}
extern "C" {
    #[doc = " Frees the memory and resources used by the properties results previously"]
    #[doc = " created using the #fiftyoneDegreesPropertiesCreate method."]
    #[doc = " @param available properties instance to be freed"]
    pub fn fiftyoneDegreesPropertiesFree(available: *mut fiftyoneDegreesPropertiesAvailable);
}
#[doc = "< An IPv4 address"]
pub const e_fiftyone_degrees_evidence_ip_type_FIFTYONE_DEGREES_EVIDENCE_IP_TYPE_IPV4:
    e_fiftyone_degrees_evidence_ip_type = 0;
#[doc = "< An IPv6 address"]
pub const e_fiftyone_degrees_evidence_ip_type_FIFTYONE_DEGREES_EVIDENCE_IP_TYPE_IPV6:
    e_fiftyone_degrees_evidence_ip_type = 1;
#[doc = "< Invalid IP address"]
pub const e_fiftyone_degrees_evidence_ip_type_FIFTYONE_DEGREES_EVIDENCE_IP_TYPE_INVALID:
    e_fiftyone_degrees_evidence_ip_type = 2;
#[doc = " Enum indicating the type of IP address."]
pub type e_fiftyone_degrees_evidence_ip_type = ::std::os::raw::c_uint;
#[doc = " Enum indicating the type of IP address."]
pub use self::e_fiftyone_degrees_evidence_ip_type as fiftyoneDegreesEvidenceIpType;
#[doc = " @cond FORWARD_DECLARATIONS"]
pub type fiftyoneDegreesEvidenceIpAddress = fiftyone_degrees_evidence_ip_address;
#[doc = " IP address structure containing the bytes of a v4 or v6 IP address. This"]
#[doc = " contains a pointer to a next IP address to enable a linked list to be"]
#[doc = " created."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_evidence_ip_address {
    #[doc = "< The type of address (v4 or v6)"]
    pub type_: fiftyoneDegreesEvidenceIpType,
    #[doc = "< The first byte of the address"]
    pub address: *mut byte,
    #[doc = "< When building the address the next byte to update"]
    pub current: *mut byte,
    #[doc = "< Next address in the list or"]
    #[doc = "NULL"]
    pub next: *mut fiftyoneDegreesEvidenceIpAddress,
    #[doc = "< Number of bytes in the original string which are"]
    #[doc = "not abbreviated"]
    pub bytesPresent: byte,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_evidence_ip_address() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_evidence_ip_address>(),
        40usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_evidence_ip_address)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_evidence_ip_address>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_evidence_ip_address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_evidence_ip_address>())).type_ as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_evidence_ip_address),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_evidence_ip_address>())).address as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_evidence_ip_address),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_evidence_ip_address>())).current as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_evidence_ip_address),
            "::",
            stringify!(current)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_evidence_ip_address>())).next as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_evidence_ip_address),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_evidence_ip_address>())).bytesPresent
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_evidence_ip_address),
            "::",
            stringify!(bytesPresent)
        )
    );
}
extern "C" {
    #[doc = " Free a linked list of IP addresses. This can also be a single IP address as"]
    #[doc = " this is equivalent to a linked list with a size of 1."]
    #[doc = " @param free method to free the IP addresses"]
    #[doc = " @param addresses head of the linked list"]
    pub fn fiftyoneDegreesIpFreeAddresses(
        free: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
        addresses: *mut fiftyoneDegreesEvidenceIpAddress,
    );
}
extern "C" {
    #[doc = " Parse a single IP address string."]
    #[doc = " @param malloc method to allocate the IP address"]
    #[doc = " @param start of the string containing the IP address to parse"]
    #[doc = " @param end of the string containing the IP address to parse"]
    #[doc = " @return pointer to the parsed IP address"]
    pub fn fiftyoneDegreesIpParseAddress(
        malloc: ::std::option::Option<
            unsafe extern "C" fn(arg1: size_t) -> *mut ::std::os::raw::c_void,
        >,
        start: *const ::std::os::raw::c_char,
        end: *const ::std::os::raw::c_char,
    ) -> *mut fiftyoneDegreesEvidenceIpAddress;
}
extern "C" {
    #[doc = " Parse a list of IP addresses and return as a linked list."]
    #[doc = " @param malloc method to allocate IP addresses"]
    #[doc = " @param start of the string containing the IP addresses to parse"]
    #[doc = " @return pointer to the head of the linked list"]
    pub fn fiftyoneDegreesIpParseAddresses(
        malloc: ::std::option::Option<
            unsafe extern "C" fn(arg1: size_t) -> *mut ::std::os::raw::c_void,
        >,
        start: *const ::std::os::raw::c_char,
    ) -> *mut fiftyoneDegreesEvidenceIpAddress;
}
extern "C" {
    #[doc = " Compare two IP addresses in its binary form"]
    #[doc = " @param ipAddress1 the first IP address"]
    #[doc = " @param ipAddress2 the second IP address"]
    #[doc = " @param type the type of IP address. This determine"]
    #[doc = " the number of bytes to compare. IPv4 require 4 bytes"]
    #[doc = " and IPv6 require 16 bytes"]
    #[doc = " @return a value indicate the result:"]
    #[doc = " 0 for equals"]
    #[doc = " > 0 for ipAddress1 comes after ipAddress2"]
    #[doc = " < 0 for ipAddress1 comes before ipAddress2"]
    pub fn fiftyoneDegreesCompareIpAddresses(
        ipAddress1: *const ::std::os::raw::c_uchar,
        ipAddress2: *const ::std::os::raw::c_uchar,
        type_: fiftyoneDegreesEvidenceIpType,
    ) -> ::std::os::raw::c_int;
}
#[doc = "< An HTTP header"]
#[doc = "value"]
pub const e_fiftyone_degrees_evidence_prefix_FIFTYONE_DEGREES_EVIDENCE_HTTP_HEADER_STRING:
    e_fiftyone_degrees_evidence_prefix = 1;
#[doc = "< A list of"]
#[doc = "IP addresses"]
#[doc = "as a string to"]
#[doc = "be parsed into"]
#[doc = "a IP addresses"]
#[doc = "collection."]
pub const e_fiftyone_degrees_evidence_prefix_FIFTYONE_DEGREES_EVIDENCE_HTTP_HEADER_IP_ADDRESSES:
    e_fiftyone_degrees_evidence_prefix = 2;
#[doc = "< A server value e.g. client"]
#[doc = "IP"]
pub const e_fiftyone_degrees_evidence_prefix_FIFTYONE_DEGREES_EVIDENCE_SERVER:
    e_fiftyone_degrees_evidence_prefix = 4;
#[doc = "< A query string parameter"]
pub const e_fiftyone_degrees_evidence_prefix_FIFTYONE_DEGREES_EVIDENCE_QUERY:
    e_fiftyone_degrees_evidence_prefix = 8;
#[doc = "< A cookie value"]
pub const e_fiftyone_degrees_evidence_prefix_FIFTYONE_DEGREES_EVIDENCE_COOKIE:
    e_fiftyone_degrees_evidence_prefix = 16;
#[doc = "< The evidence is invalid and"]
#[doc = "should be ignored"]
pub const e_fiftyone_degrees_evidence_prefix_FIFTYONE_DEGREES_EVIDENCE_IGNORE:
    e_fiftyone_degrees_evidence_prefix = 128;
#[doc = " Evidence prefixes used to determine the category a piece of evidence"]
#[doc = " belongs to. This will determine how the value is parsed."]
pub type e_fiftyone_degrees_evidence_prefix = ::std::os::raw::c_uint;
#[doc = " Evidence prefixes used to determine the category a piece of evidence"]
#[doc = " belongs to. This will determine how the value is parsed."]
pub use self::e_fiftyone_degrees_evidence_prefix as fiftyoneDegreesEvidencePrefix;
#[doc = " Map of prefix strings to prefix enum values."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_evidence_prefix_map_t {
    #[doc = "< Name of the prefix"]
    pub prefix: *const ::std::os::raw::c_char,
    #[doc = "< Length of the prefix string"]
    pub prefixLength: size_t,
    #[doc = "< Enum value of prefix name"]
    pub prefixEnum: fiftyoneDegreesEvidencePrefix,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_evidence_prefix_map_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_evidence_prefix_map_t>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_evidence_prefix_map_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_evidence_prefix_map_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_evidence_prefix_map_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_evidence_prefix_map_t>())).prefix as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_evidence_prefix_map_t),
            "::",
            stringify!(prefix)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_evidence_prefix_map_t>())).prefixLength
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_evidence_prefix_map_t),
            "::",
            stringify!(prefixLength)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_evidence_prefix_map_t>())).prefixEnum
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_evidence_prefix_map_t),
            "::",
            stringify!(prefixEnum)
        )
    );
}
#[doc = " Map of prefix strings to prefix enum values."]
pub type fiftyoneDegreesEvidencePrefixMap = fiftyone_degrees_evidence_prefix_map_t;
#[doc = " Evidence key value pair structure which combines the prefix, key and value."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_evidence_key_value_pair_t {
    #[doc = "< e.g. #FIFTYONE_DEGREES_EVIDENCE_HTTP_HEADER_STRING"]
    pub prefix: fiftyoneDegreesEvidencePrefix,
    #[doc = "< e.g. User-Agent or ScreenPixelsWidth"]
    pub field: *const ::std::os::raw::c_char,
    #[doc = "< The original unparsed value"]
    pub originalValue: *const ::std::os::raw::c_void,
    #[doc = "< The parsed value which may not be a string"]
    pub parsedValue: *const ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_evidence_key_value_pair_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_evidence_key_value_pair_t>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_evidence_key_value_pair_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_evidence_key_value_pair_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_evidence_key_value_pair_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_evidence_key_value_pair_t>())).prefix
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_evidence_key_value_pair_t),
            "::",
            stringify!(prefix)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_evidence_key_value_pair_t>())).field as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_evidence_key_value_pair_t),
            "::",
            stringify!(field)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_evidence_key_value_pair_t>())).originalValue
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_evidence_key_value_pair_t),
            "::",
            stringify!(originalValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_evidence_key_value_pair_t>())).parsedValue
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_evidence_key_value_pair_t),
            "::",
            stringify!(parsedValue)
        )
    );
}
#[doc = " Evidence key value pair structure which combines the prefix, key and value."]
pub type fiftyoneDegreesEvidenceKeyValuePair = fiftyone_degrees_evidence_key_value_pair_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_array_fiftyoneDegreesEvidenceKeyValuePair_t {
    pub count: u32,
    pub capacity: u32,
    pub items: *mut fiftyoneDegreesEvidenceKeyValuePair,
    pub pseudoEvidence: *mut fiftyone_degrees_array_fiftyoneDegreesEvidenceKeyValuePair_t,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_array_fiftyoneDegreesEvidenceKeyValuePair_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_array_fiftyoneDegreesEvidenceKeyValuePair_t>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesEvidenceKeyValuePair_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_array_fiftyoneDegreesEvidenceKeyValuePair_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesEvidenceKeyValuePair_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesEvidenceKeyValuePair_t>()))
                .count as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesEvidenceKeyValuePair_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesEvidenceKeyValuePair_t>()))
                .capacity as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesEvidenceKeyValuePair_t),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesEvidenceKeyValuePair_t>()))
                .items as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesEvidenceKeyValuePair_t),
            "::",
            stringify!(items)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesEvidenceKeyValuePair_t>()))
                .pseudoEvidence as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesEvidenceKeyValuePair_t),
            "::",
            stringify!(pseudoEvidence)
        )
    );
}
pub type fiftyoneDegreesEvidenceKeyValuePairArray =
    fiftyone_degrees_array_fiftyoneDegreesEvidenceKeyValuePair_t;
#[doc = " Callback method used to iterate evidence key value pairs."]
#[doc = " @param state pointer provided to the iterator"]
#[doc = " @param pair evidence key value pair with the parsed value set"]
#[doc = " @return true if the iteration should continue otherwise false"]
pub type fiftyoneDegreesEvidenceIterateMethod = ::std::option::Option<
    unsafe extern "C" fn(
        state: *mut ::std::os::raw::c_void,
        pair: *mut fiftyoneDegreesEvidenceKeyValuePair,
    ) -> bool,
>;
extern "C" {
    #[doc = " Creates a new evidence array with the capacity requested."]
    #[doc = " @param capacity maximum number of evidence items"]
    #[doc = " @return pointer to the newly created array"]
    pub fn fiftyoneDegreesEvidenceCreate(
        capacity: u32,
    ) -> *mut fiftyoneDegreesEvidenceKeyValuePairArray;
}
extern "C" {
    #[doc = " Frees the memory used by an evidence array."]
    #[doc = " @param evidence pointer to the array to be freed"]
    pub fn fiftyoneDegreesEvidenceFree(evidence: *mut fiftyoneDegreesEvidenceKeyValuePairArray);
}
extern "C" {
    #[doc = " Adds a new entry to the evidence. The memory associated with the"]
    #[doc = " field and original value parameters must not be freed until after the"]
    #[doc = " evidence collection has been freed. This method will NOT copy the values."]
    #[doc = " @param evidence pointer to the evidence array to add the entry to"]
    #[doc = " @param prefix enum indicating the category the entry belongs to"]
    #[doc = " @param field used as the key for the entry within its prefix"]
    #[doc = " @param originalValue the value to be parsed"]
    pub fn fiftyoneDegreesEvidenceAddString(
        evidence: *mut fiftyoneDegreesEvidenceKeyValuePairArray,
        prefix: fiftyoneDegreesEvidencePrefix,
        field: *const ::std::os::raw::c_char,
        originalValue: *const ::std::os::raw::c_char,
    ) -> *mut fiftyoneDegreesEvidenceKeyValuePair;
}
extern "C" {
    #[doc = " Determines the evidence map prefix from the key."]
    #[doc = " @param key the evidence key including the evidence prefix .i.e. header"]
    #[doc = " @return the prefix enumeration, or NULL if one does not exist"]
    pub fn fiftyoneDegreesEvidenceMapPrefix(
        key: *const ::std::os::raw::c_char,
    ) -> *mut fiftyoneDegreesEvidencePrefixMap;
}
extern "C" {
    #[doc = " Iterates over the evidence calling the callback method for any values that"]
    #[doc = " match the prefixes provided. If there are pseudo evidence, this"]
    #[doc = " will also iterate through them and perform the callback on each."]
    #[doc = ""]
    #[doc = " @param evidence key value pairs including prefixes"]
    #[doc = " @param prefixes one or more prefix flags to return values for"]
    #[doc = " @param state pointer passed to the callback method"]
    #[doc = " @param callback method called when a matching prefix is found"]
    #[doc = " @return the number of matching evidence keys iterated over"]
    pub fn fiftyoneDegreesEvidenceIterate(
        evidence: *mut fiftyoneDegreesEvidenceKeyValuePairArray,
        prefixes: ::std::os::raw::c_int,
        state: *mut ::std::os::raw::c_void,
        callback: fiftyoneDegreesEvidenceIterateMethod,
    ) -> u32;
}
#[doc = " Header structure containing the name and unique id."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_header_t {
    #[doc = "< Collection item containing the"]
    #[doc = "name of the header as a"]
    #[doc = "#fiftyoneDegreesString"]
    pub name: fiftyoneDegreesCollectionItem,
    #[doc = "< Indices for unique headers that form"]
    #[doc = "this pseudo-header. Null if not a pseudo header"]
    pub requestHeaders: *mut u32,
    #[doc = "< Number of request headers. 0 If not a"]
    #[doc = "pseudo header"]
    pub requestHeaderCount: u32,
    #[doc = "< Id which uniquely identifies the header within the"]
    #[doc = "data set."]
    pub uniqueId: u32,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_header_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_header_t>(),
        48usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_header_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_header_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_header_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_header_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_header_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_header_t>())).requestHeaders as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_header_t),
            "::",
            stringify!(requestHeaders)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_header_t>())).requestHeaderCount as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_header_t),
            "::",
            stringify!(requestHeaderCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_header_t>())).uniqueId as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_header_t),
            "::",
            stringify!(uniqueId)
        )
    );
}
#[doc = " Header structure containing the name and unique id."]
pub type fiftyoneDegreesHeader = fiftyone_degrees_header_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_array_fiftyoneDegreesHeader_t {
    pub count: u32,
    pub capacity: u32,
    pub items: *mut fiftyoneDegreesHeader,
    pub expectUpperPrefixedHeaders: bool,
    pub pseudoHeaders: *mut u32,
    pub pseudoHeadersCount: u32,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_array_fiftyoneDegreesHeader_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_array_fiftyoneDegreesHeader_t>(),
        40usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesHeader_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_array_fiftyoneDegreesHeader_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesHeader_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesHeader_t>())).count
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesHeader_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesHeader_t>())).capacity
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesHeader_t),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesHeader_t>())).items
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesHeader_t),
            "::",
            stringify!(items)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesHeader_t>()))
                .expectUpperPrefixedHeaders as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesHeader_t),
            "::",
            stringify!(expectUpperPrefixedHeaders)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesHeader_t>())).pseudoHeaders
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesHeader_t),
            "::",
            stringify!(pseudoHeaders)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesHeader_t>()))
                .pseudoHeadersCount as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesHeader_t),
            "::",
            stringify!(pseudoHeadersCount)
        )
    );
}
pub type fiftyoneDegreesHeaderArray = fiftyone_degrees_array_fiftyoneDegreesHeader_t;
#[doc = " Array of headers used to easily access and track the size of the array."]
pub type fiftyoneDegreesHeaders = fiftyoneDegreesHeaderArray;
#[doc = " Gets the unique id and name of the header at the requested index."]
#[doc = " @param state pointer to data used by the method"]
#[doc = " @param index of the header to get"]
#[doc = " @param nameItem pointer to the collection item to populate with the name of"]
#[doc = " the header"]
#[doc = " @return unique id of the header"]
pub type fiftyoneDegreesHeadersGetMethod = ::std::option::Option<
    unsafe extern "C" fn(
        state: *mut ::std::os::raw::c_void,
        index: u32,
        nameItem: *mut fiftyoneDegreesCollectionItem,
    ) -> ::std::os::raw::c_long,
>;
extern "C" {
    #[doc = " Returns the number of bytes that will be allocated for a headers structure"]
    #[doc = " created using the #fiftyoneDegreesHeadersCreate method."]
    #[doc = " @param count number of headers in the structure"]
    #[doc = " @return number of bytes needed"]
    pub fn fiftyoneDegreesHeadersSize(count: ::std::os::raw::c_int) -> size_t;
}
extern "C" {
    #[doc = " Check if a header is a pseudo header."]
    #[doc = " @param headerName name of the header"]
    #[doc = " @return whether a header is a pseudo header."]
    pub fn fiftyoneDegreesHeadersIsPseudo(headerName: *const ::std::os::raw::c_char) -> bool;
}
extern "C" {
    #[doc = " Creates a new headers instance configured with the unique HTTP names needed"]
    #[doc = " from evidence. If the useUpperPrefixedHeaders flag is true then checks for"]
    #[doc = " the presence of HTTP headers will also include checking for HTTP_ as a"]
    #[doc = " prefix to the header key. If header is a pseudo header, the indices of"]
    #[doc = " actual headers that form this header will be constructed."]
    #[doc = ""]
    #[doc = " @param useUpperPrefixedHeaders true if HTTP_ prefixes should be checked"]
    #[doc = " @param state pointer used by getHeaderMethod to retrieve the header integer"]
    #[doc = " @param get used to return the HTTP header unique integer"]
    #[doc = " @return a new instance of #fiftyoneDegreesHeaders ready to be used to filter"]
    #[doc = " HTTP headers."]
    pub fn fiftyoneDegreesHeadersCreate(
        useUpperPrefixedHeaders: bool,
        state: *mut ::std::os::raw::c_void,
        get: fiftyoneDegreesHeadersGetMethod,
    ) -> *mut fiftyoneDegreesHeaders;
}
extern "C" {
    #[doc = " Provides the integer index of the HTTP header name."]
    #[doc = " @param headers structure created by #fiftyoneDegreesHeadersCreate"]
    #[doc = " @param httpHeaderName of the header whose index is required"]
    #[doc = " @param length number of characters in httpHeaderName"]
    #[doc = " @return the index of the HTTP header name, or -1 if the name does not exist"]
    pub fn fiftyoneDegreesHeaderGetIndex(
        headers: *mut fiftyoneDegreesHeaders,
        httpHeaderName: *const ::std::os::raw::c_char,
        length: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Gets a pointer to the header in the headers structure with a unique id"]
    #[doc = " matching the one provided. If the headers structure does not contain a"]
    #[doc = " header with the unique id, NULL will be returned."]
    #[doc = " This method assumes that the headers in the structure are unique, if they"]
    #[doc = " are not, then the first matching header will be returned."]
    #[doc = " @param headers pointer to the headers structure to search"]
    #[doc = " @param uniqueId id to search for"]
    #[doc = " @return pointer to the matching header, or NULL"]
    pub fn fiftyoneDegreesHeadersGetHeaderFromUniqueId(
        headers: *mut fiftyoneDegreesHeaders,
        uniqueId: u32,
    ) -> *mut fiftyoneDegreesHeader;
}
extern "C" {
    #[doc = " Frees the memory allocated by the #fiftyoneDegreesHeadersCreate method."]
    #[doc = ""]
    #[doc = " @param headers structure created by #fiftyoneDegreesHeadersCreate"]
    pub fn fiftyoneDegreesHeadersFree(headers: *mut fiftyoneDegreesHeaders);
}
extern "C" {
    #[doc = " Determines if the key of an evidence pair is an HTTP header."]
    #[doc = " @param state results instance to check against"]
    #[doc = " @param pair the evidence pair to be checked"]
    #[doc = " @return true if the evidence relates to an HTTP header, otherwise false."]
    pub fn fiftyoneDegreesHeadersIsHttp(
        state: *mut ::std::os::raw::c_void,
        pair: *mut fiftyoneDegreesEvidenceKeyValuePair,
    ) -> bool;
}
#[doc = " Index and pointer to a property which can be overridden."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_override_property_t {
    #[doc = "< Index in the available properties"]
    #[doc = "structure"]
    pub requiredPropertyIndex: u32,
    #[doc = "< Pointer to the property"]
    pub available: *mut fiftyoneDegreesPropertyAvailable,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_override_property_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_override_property_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_override_property_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_override_property_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_override_property_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_override_property_t>())).requiredPropertyIndex
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_override_property_t),
            "::",
            stringify!(requiredPropertyIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_override_property_t>())).available as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_override_property_t),
            "::",
            stringify!(available)
        )
    );
}
#[doc = " Index and pointer to a property which can be overridden."]
pub type fiftyoneDegreesOverrideProperty = fiftyone_degrees_override_property_t;
#[doc = " String value which should override the value for the property indicated by"]
#[doc = " the required property index."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_override_value_t {
    #[doc = "< Index in the available properties"]
    #[doc = "structure"]
    pub requiredPropertyIndex: u32,
    #[doc = "< Overridden value"]
    pub string: fiftyoneDegreesData,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_override_value_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_override_value_t>(),
        24usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_override_value_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_override_value_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_override_value_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_override_value_t>())).requiredPropertyIndex
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_override_value_t),
            "::",
            stringify!(requiredPropertyIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_override_value_t>())).string as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_override_value_t),
            "::",
            stringify!(string)
        )
    );
}
#[doc = " String value which should override the value for the property indicated by"]
#[doc = " the required property index."]
pub type fiftyoneDegreesOverrideValue = fiftyone_degrees_override_value_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_array_fiftyoneDegreesOverrideProperty_t {
    pub count: u32,
    pub capacity: u32,
    pub items: *mut fiftyoneDegreesOverrideProperty,
    pub prefix: bool,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_array_fiftyoneDegreesOverrideProperty_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_array_fiftyoneDegreesOverrideProperty_t>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesOverrideProperty_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_array_fiftyoneDegreesOverrideProperty_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesOverrideProperty_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesOverrideProperty_t>()))
                .count as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesOverrideProperty_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesOverrideProperty_t>()))
                .capacity as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesOverrideProperty_t),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesOverrideProperty_t>()))
                .items as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesOverrideProperty_t),
            "::",
            stringify!(items)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesOverrideProperty_t>()))
                .prefix as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesOverrideProperty_t),
            "::",
            stringify!(prefix)
        )
    );
}
pub type fiftyoneDegreesOverridePropertyArray =
    fiftyone_degrees_array_fiftyoneDegreesOverrideProperty_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_array_fiftyoneDegreesOverrideValue_t {
    pub count: u32,
    pub capacity: u32,
    pub items: *mut fiftyoneDegreesOverrideValue,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_array_fiftyoneDegreesOverrideValue_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_array_fiftyoneDegreesOverrideValue_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesOverrideValue_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_array_fiftyoneDegreesOverrideValue_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesOverrideValue_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesOverrideValue_t>())).count
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesOverrideValue_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesOverrideValue_t>()))
                .capacity as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesOverrideValue_t),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesOverrideValue_t>())).items
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesOverrideValue_t),
            "::",
            stringify!(items)
        )
    );
}
pub type fiftyoneDegreesOverrideValueArray = fiftyone_degrees_array_fiftyoneDegreesOverrideValue_t;
#[doc = " Array of overridable properties. These are properties in a data set which"]
#[doc = " a capable of being overridden."]
pub type fiftyoneDegreesOverridable = fiftyoneDegreesOverridePropertyArray;
#[doc = " Called when a profile Id has been found and should override the one"]
#[doc = " found from another source such as the `User-Agent`."]
#[doc = " @param state pointer to be used by the method"]
#[doc = " @param profileId if to override"]
pub type fiftyoneDegreesOverrideProfileIdMethod =
    ::std::option::Option<unsafe extern "C" fn(state: *mut ::std::os::raw::c_void, profileId: u32)>;
#[doc = " Determines if the required property index is eligible for overriding"]
#[doc = " considering the configuration of the data set."]
#[doc = " @param state pointer to be used by the method"]
#[doc = " @param requiredPropertyIndex index of the property in the available"]
#[doc = " properties structure"]
#[doc = " @return true if the property can be overridden, otherwise false."]
pub type fiftyoneDegreesOverridesFilterMethod = ::std::option::Option<
    unsafe extern "C" fn(state: *mut ::std::os::raw::c_void, requiredPropertyIndex: u32) -> bool,
>;
extern "C" {
    #[doc = " Creates a fresh array of override values with the given capacity."]
    #[doc = " @param capacity the number of values the array can contain"]
    #[doc = " @return a new array of override values"]
    pub fn fiftyoneDegreesOverrideValuesCreate(
        capacity: u32,
    ) -> *mut fiftyoneDegreesOverrideValueArray;
}
extern "C" {
    #[doc = " Returns a list of the evidence keys that are available to support"]
    #[doc = " overriding property values."]
    #[doc = " @param available pointer to the available properties structure"]
    #[doc = " @param prefix true if the `51D_` prefix should be checked for in evidence"]
    #[doc = " @param state pointer to be used by the method"]
    #[doc = " @param filter pointer to a filter method which determines whether or not a"]
    #[doc = " property is eligible to be overridden"]
    #[doc = " @return a new override properties array"]
    pub fn fiftyoneDegreesOverridePropertiesCreate(
        available: *mut fiftyoneDegreesPropertiesAvailable,
        prefix: bool,
        state: *mut ::std::os::raw::c_void,
        filter: fiftyoneDegreesOverridesFilterMethod,
    ) -> *mut fiftyoneDegreesOverridePropertyArray;
}
extern "C" {
    #[doc = " Frees the resources used by the override properties."]
    #[doc = " @param properties pointer to the properties to free"]
    pub fn fiftyoneDegreesOverridePropertiesFree(
        properties: *mut fiftyoneDegreesOverridePropertyArray,
    );
}
extern "C" {
    #[doc = " Extracts override values from evidence."]
    #[doc = " @param properties which can be overridden"]
    #[doc = " @param values array to populate with the override values"]
    #[doc = " @param evidence to extract any overrides from"]
    #[doc = " @return the number of override values which have been extracted"]
    pub fn fiftyoneDegreesOverridesExtractFromEvidence(
        properties: *mut fiftyoneDegreesOverridePropertyArray,
        values: *mut fiftyoneDegreesOverrideValueArray,
        evidence: *mut fiftyoneDegreesEvidenceKeyValuePairArray,
    ) -> u32;
}
extern "C" {
    #[doc = " Gets whether or not the override values contain an override relating to the"]
    #[doc = " property identified by the required property index. Note that the required"]
    #[doc = " property index MUST be valid when calling this method, so should be checked"]
    #[doc = " by the caller."]
    #[doc = " @param values pointer to the values to search in"]
    #[doc = " @param requiredPropertyIndex index in the required properties of the"]
    #[doc = " property to check for values of"]
    #[doc = " @return true if there are override values for the requested property"]
    pub fn fiftyoneDegreesOverrideHasValueForRequiredPropertyIndex(
        values: *mut fiftyoneDegreesOverrideValueArray,
        requiredPropertyIndex: u32,
    ) -> bool;
}
extern "C" {
    #[doc = " Adds values from the overrides data structure into the results."]
    #[doc = " @param values array to add the new values to"]
    #[doc = " @param requiredPropertyIndex of the property which the values relate to"]
    #[doc = " @param list to add the values to"]
    #[doc = " @return the number of values which have been added to the list"]
    pub fn fiftyoneDegreesOverrideValuesAdd(
        values: *mut fiftyoneDegreesOverrideValueArray,
        requiredPropertyIndex: u32,
        list: *mut fiftyoneDegreesList,
    ) -> u32;
}
extern "C" {
    #[doc = " Add an value override to the override values array."]
    #[doc = " @param values the override values array to add the value to"]
    #[doc = " @param requiredPropertyIndex the index in the dataset's required properties"]
    #[doc = " of the property to override the value of"]
    #[doc = " @param value the value string override"]
    #[doc = " @return true if the value was added successfully"]
    pub fn fiftyoneDegreesOverridesAdd(
        values: *mut fiftyoneDegreesOverrideValueArray,
        requiredPropertyIndex: ::std::os::raw::c_int,
        value: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    #[doc = " Returns the first value for the required property index or NULL of no value"]
    #[doc = " exists for the property index."]
    #[doc = " @param values to get the value from"]
    #[doc = " @param requiredPropertyIndex index of the property to get the first value of"]
    #[doc = " @param item to store the result in"]
    #[doc = " @return pointer to the value or NULL if none were found"]
    pub fn fiftyoneDegreesOverrideValuesGetFirst(
        values: *mut fiftyoneDegreesOverrideValueArray,
        requiredPropertyIndex: u32,
        item: *mut fiftyoneDegreesCollectionItem,
    ) -> *mut fiftyoneDegreesString;
}
extern "C" {
    #[doc = " Gets the required property index of a property that **MIGHT** provide logic"]
    #[doc = " such as JavaScript or Regular Expressions that could override the value"]
    #[doc = " of the required property index provided."]
    #[doc = " @param available list of require properties"]
    #[doc = " @param requiredPropertyIndex of the property to test for being overridden"]
    #[doc = " @return the positive index of the overriding required property, or -1 it"]
    #[doc = " can't be overridden."]
    pub fn fiftyoneDegreesOverridesGetOverridingRequiredPropertyIndex(
        available: *mut fiftyoneDegreesPropertiesAvailable,
        requiredPropertyIndex: u32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Frees the memory used for the override values."]
    #[doc = " @param values to be freed"]
    pub fn fiftyoneDegreesOverrideValuesFree(values: *mut fiftyoneDegreesOverrideValueArray);
}
extern "C" {
    #[doc = " Reset override array. All existing item memory will not be freed by reset"]
    #[doc = " with 0s. Remaining values will be reset to default except the allocateds size.."]
    #[doc = " @param values to be reset"]
    pub fn fiftyoneDegreesOverrideValuesReset(values: *mut fiftyoneDegreesOverrideValueArray);
}
extern "C" {
    #[doc = " Extracts the profile overrides from the evidence and overrides them using"]
    #[doc = " the override method supplied."]
    #[doc = " @param evidence to extract the profile ids from"]
    #[doc = " @param state pointer to pass to the override method"]
    #[doc = " @param override method called to override a profile id"]
    pub fn fiftyoneDegreesOverrideProfileIds(
        evidence: *mut fiftyoneDegreesEvidenceKeyValuePairArray,
        state: *mut ::std::os::raw::c_void,
        override_: fiftyoneDegreesOverrideProfileIdMethod,
    );
}
#[doc = " Base data set structure which contains the 'must have's for all data sets."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct fiftyone_degrees_dataset_base_t {
    #[doc = "< Path to the file"]
    #[doc = "used to initialise the"]
    #[doc = "data set. This will"]
    #[doc = "either be the same as"]
    #[doc = "the master file name,"]
    #[doc = "or the path to the"]
    #[doc = "temp file being used."]
    pub fileName: [::std::os::raw::c_char; 4096usize],
    #[doc = "< Path to the"]
    #[doc = "file used to"]
    #[doc = "initialise the"]
    #[doc = "data set."]
    pub masterFileName: [::std::os::raw::c_char; 4096usize],
    #[doc = "< A pointer to the memory where the data within the"]
    #[doc = "data set is held. NULL if the entire data set is not"]
    #[doc = "held in memory, the caller is going to free the"]
    #[doc = "memory or there are a mixture of caches and"]
    #[doc = "partially allocated memory in use."]
    pub memoryToFree: *mut ::std::os::raw::c_void,
    #[doc = "< True if the data file has been read into continuous"]
    #[doc = "memory"]
    pub isInMemory: bool,
    pub isClientHintsEnabled: bool,
    #[doc = "< Linked list of file readers"]
    pub filePool: fiftyoneDegreesFilePool,
    #[doc = "< Pointer to the handle that"]
    #[doc = "tracks this data set instance"]
    pub handle: *mut fiftyoneDegreesResourceHandle,
    #[doc = "< Available properties"]
    pub available: *mut fiftyoneDegreesPropertiesAvailable,
    #[doc = "< Related HTTP headers"]
    pub uniqueHeaders: *mut fiftyoneDegreesHeaders,
    #[doc = "< Array of properties"]
    #[doc = "that can be"]
    #[doc = "overridden"]
    pub overridable: *mut fiftyoneDegreesOverridePropertyArray,
    #[doc = "< Pointer to the config used to create the dataset"]
    pub config: *const ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_dataset_base_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_dataset_base_t>(),
        8288usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_dataset_base_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_dataset_base_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_dataset_base_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_base_t>())).fileName as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_base_t),
            "::",
            stringify!(fileName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_base_t>())).masterFileName as *const _
                as usize
        },
        4096usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_base_t),
            "::",
            stringify!(masterFileName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_base_t>())).memoryToFree as *const _
                as usize
        },
        8192usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_base_t),
            "::",
            stringify!(memoryToFree)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_base_t>())).isInMemory as *const _
                as usize
        },
        8200usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_base_t),
            "::",
            stringify!(isInMemory)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_base_t>())).isClientHintsEnabled
                as *const _ as usize
        },
        8201usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_base_t),
            "::",
            stringify!(isClientHintsEnabled)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_base_t>())).filePool as *const _
                as usize
        },
        8208usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_base_t),
            "::",
            stringify!(filePool)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_base_t>())).handle as *const _ as usize
        },
        8248usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_base_t),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_base_t>())).available as *const _
                as usize
        },
        8256usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_base_t),
            "::",
            stringify!(available)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_base_t>())).uniqueHeaders as *const _
                as usize
        },
        8264usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_base_t),
            "::",
            stringify!(uniqueHeaders)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_base_t>())).overridable as *const _
                as usize
        },
        8272usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_base_t),
            "::",
            stringify!(overridable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_base_t>())).config as *const _ as usize
        },
        8280usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_base_t),
            "::",
            stringify!(config)
        )
    );
}
#[doc = " Base data set structure which contains the 'must have's for all data sets."]
pub type fiftyoneDegreesDataSetBase = fiftyone_degrees_dataset_base_t;
#[doc = " Initialses the data set from data stored in continuous memory."]
#[doc = " @param dataSet pointer to the data set to be initialised"]
#[doc = " @param config configuration for the operation of the data set, or NULL if"]
#[doc = " default configuration is required"]
#[doc = " @param properties the properties that will be consumed from the data set, or"]
#[doc = " NULL if all available properties in the hash data file should be available"]
#[doc = " for consumption"]
#[doc = " @param memory pointer to continuous memory containing the data set"]
#[doc = " @param size the number of bytes that make up the data set"]
#[doc = " @param exception pointer to an exception data structure to be used if an"]
#[doc = " exception occurs. See exceptions.h."]
#[doc = " @return the status associated with the data set intialisation. Any value"]
#[doc = " other than #FIFTYONE_DEGREES_STATUS_SUCCESS means the data set was not"]
#[doc = " initialised correctly"]
pub type fiftyoneDegreesDataSetInitFromMemoryMethod = ::std::option::Option<
    unsafe extern "C" fn(
        dataSet: *mut ::std::os::raw::c_void,
        config: *const ::std::os::raw::c_void,
        properties: *mut fiftyoneDegreesPropertiesRequired,
        memory: *mut ::std::os::raw::c_void,
        size: ::std::os::raw::c_long,
        exception: *mut fiftyoneDegreesException,
    ) -> fiftyoneDegreesStatusCode,
>;
#[doc = " Initialses the data set from data stored on file. This method"]
#[doc = " should clean up the resource properly if the initialisation process fails."]
#[doc = " That means all allocated memory should be freed and pointers to these"]
#[doc = " memorys should be set to NULL. The input dataSet should also be freed."]
#[doc = " @param dataSet pointer to the data set to be initialised"]
#[doc = " @param config configuration for the operation of the data set, or NULL if"]
#[doc = " default configuration is required"]
#[doc = " @param properties the properties that will be consumed from the data set, or"]
#[doc = " NULL if all available properties in the hash data file should be available"]
#[doc = " for consumption"]
#[doc = " @param fileName the full path to a file with read permission that contains"]
#[doc = " the data set"]
#[doc = " @param exception pointer to an exception data structure to be used if an"]
#[doc = " exception occurs. See exceptions.h"]
#[doc = " @return the status associated with the data set intialisation. Any value"]
#[doc = " other than #FIFTYONE_DEGREES_STATUS_SUCCESS means the data set was not"]
#[doc = " initialised correctly"]
pub type fiftyoneDegreesDataSetInitFromFileMethod = ::std::option::Option<
    unsafe extern "C" fn(
        dataSet: *mut ::std::os::raw::c_void,
        config: *const ::std::os::raw::c_void,
        properties: *mut fiftyoneDegreesPropertiesRequired,
        fileName: *const ::std::os::raw::c_char,
        exception: *mut fiftyoneDegreesException,
    ) -> fiftyoneDegreesStatusCode,
>;
extern "C" {
    #[doc = " Initialises the properties in the data set. Usually this means constructing"]
    #[doc = " an array of pointers to the properties which are required for quick access."]
    #[doc = " @param dataSet pointer to a valid data set"]
    #[doc = " @param properties the properties which should be initialised in the data set"]
    #[doc = " @param state pointer to data which is needed by getPropertymethod"]
    #[doc = " @param getPropertyMethod method used to retrieve the name of a property at"]
    #[doc = " a specified index from the data set"]
    #[doc = " @param getEvidencePropertiesMethod method used to populate the list of"]
    #[doc = " evidence required for a property in the data set"]
    #[doc = " @return the status associated with the property initialisation. Any value"]
    #[doc = " other than #FIFTYONE_DEGREES_STATUS_SUCCESS  means the properties were not"]
    #[doc = " initialised correctly"]
    pub fn fiftyoneDegreesDataSetInitProperties(
        dataSet: *mut fiftyoneDegreesDataSetBase,
        properties: *mut fiftyoneDegreesPropertiesRequired,
        state: *mut ::std::os::raw::c_void,
        getPropertyMethod: fiftyoneDegreesPropertiesGetMethod,
        getEvidencePropertiesMethod: fiftyoneDegreesEvidencePropertiesGetMethod,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Initialises the HTTP headers in the data set. Usually this means"]
    #[doc = " constructing an array of pointers to the headers which are required for"]
    #[doc = " quick access."]
    #[doc = " @param dataSet pointer to a valid data set"]
    #[doc = " @param state pointer to data which is needed by getPropertymethod"]
    #[doc = " @param getHeaderMethod method used to retrieve the unique id and name of a"]
    #[doc = " header at a specified index from the data set"]
    #[doc = " @return the status associated with the header initialisation. Any value"]
    #[doc = " other than #FIFTYONE_DEGREES_STATUS_SUCCESS  means the headers were not"]
    #[doc = " initialised correctly"]
    pub fn fiftyoneDegreesDataSetInitHeaders(
        dataSet: *mut fiftyoneDegreesDataSetBase,
        state: *mut ::std::os::raw::c_void,
        getHeaderMethod: fiftyoneDegreesHeadersGetMethod,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Initialses the data set from data stored on file."]
    #[doc = " @param dataSet pointer to the pre allocated data set to be initialised"]
    #[doc = " @param fileName the full path to a file with read permission that contains"]
    #[doc = " the data set"]
    #[doc = " @param bytesToCompare the number of bytes to compare if the reuse temporary"]
    #[doc = " file option is enabled. If a temporary file is found and the first bytes are"]
    #[doc = " equal to the master file, then the file is used, if not then a new temporary"]
    #[doc = " file is created"]
    #[doc = " @return the status associated with the data set intialisation. Any value"]
    #[doc = " other than #FIFTYONE_DEGREES_STATUS_SUCCESS means the data set was not"]
    #[doc = " initialised correctly"]
    pub fn fiftyoneDegreesDataSetInitFromFile(
        dataSet: *mut fiftyoneDegreesDataSetBase,
        fileName: *const ::std::os::raw::c_char,
        bytesToCompare: ::std::os::raw::c_long,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Initialses the data set from data stored in continuous memory."]
    #[doc = " @param dataSet pointer to the pre allocated data set to be initialised"]
    #[doc = " @param reader constructed to read the memory containing the data set"]
    #[doc = " @return the status associated with the data set intialisation. Any value"]
    #[doc = " other than #FIFTYONE_DEGREES_STATUS_SUCCESS means the data set was not"]
    #[doc = " initialised correctly"]
    pub fn fiftyoneDegreesDataSetInitInMemory(
        dataSet: *mut fiftyoneDegreesDataSetBase,
        reader: *mut fiftyoneDegreesMemoryReader,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Resets a newly allocated data set structure ready for initialisation."]
    #[doc = " @param dataSet pointer to the allocated data set"]
    pub fn fiftyoneDegreesDataSetReset(dataSet: *mut fiftyoneDegreesDataSetBase);
}
extern "C" {
    #[doc = " Gets a pointer to the active data set from a resource manager."]
    #[doc = " Note that when this is finished with it must be released with the"]
    #[doc = " corresponding release method."]
    #[doc = " @param manager pointer to the manager which manages the data set resource"]
    #[doc = " @return pointer to the data set resource"]
    pub fn fiftyoneDegreesDataSetGet(
        manager: *mut fiftyoneDegreesResourceManager,
    ) -> *mut fiftyoneDegreesDataSetBase;
}
extern "C" {
    #[doc = " Releases a reference to a data set which has been fetched via the DataSetGet"]
    #[doc = " method."]
    #[doc = " @param dataSet pointer to the data set to release"]
    pub fn fiftyoneDegreesDataSetRelease(dataSet: *mut fiftyoneDegreesDataSetBase);
}
extern "C" {
    #[doc = " Closes the data set by freeing anything which has been initialised at"]
    #[doc = " creation. This does not free the data set structure itself."]
    #[doc = " @param dataSet pointer to the data set to complete"]
    pub fn fiftyoneDegreesDataSetFree(dataSet: *mut fiftyoneDegreesDataSetBase);
}
extern "C" {
    #[doc = " Reload the data set being used by the resource manager using a data file"]
    #[doc = " loaded into contiguous memory. When initialising the data, the configuration"]
    #[doc = " that manager was first created with is used."]
    #[doc = ""]
    #[doc = " If the data passed in is successfully initialised, the current data set is"]
    #[doc = " replaced The old data will remain in memory until the last reference to it"]
    #[doc = " is released."]
    #[doc = " @param manager pointer to the resource manager to reload the data set for"]
    #[doc = " @param source pointer to the memory location where the new data file is"]
    #[doc = " stored"]
    #[doc = " @param length of the data in memory"]
    #[doc = " @param dataSetSize size of the data set structure to allocate for the new"]
    #[doc = " data set"]
    #[doc = " @param initDataSet init method used to initialise the new data set from the"]
    #[doc = " memory pointer provided"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the status associated with the data set reload. Any value other than"]
    #[doc = " #FIFTYONE_DEGREES_STATUS_SUCCESS means the data set was not reloaded"]
    #[doc = " correctly"]
    pub fn fiftyoneDegreesDataSetReloadManagerFromMemory(
        manager: *mut fiftyoneDegreesResourceManager,
        source: *mut ::std::os::raw::c_void,
        length: ::std::os::raw::c_long,
        dataSetSize: size_t,
        initDataSet: fiftyoneDegreesDataSetInitFromMemoryMethod,
        exception: *mut fiftyoneDegreesException,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Reload the data set being used by the resource manager using the data file"]
    #[doc = " location specified. When initialising the data, the configuration that"]
    #[doc = " manager was first created with is used."]
    #[doc = ""]
    #[doc = " If the new data file is successfully initialised, the current data set is"]
    #[doc = " replaced The old data will remain in memory until the last reference to it"]
    #[doc = " is released."]
    #[doc = " @param manager pointer to the resource manager to reload the data set for"]
    #[doc = " @param fileName path to the new data file"]
    #[doc = " @param dataSetSize size of the data set structure to allocate for the new"]
    #[doc = " data set"]
    #[doc = " @param initDataSet init method used to initialise the new data set from the"]
    #[doc = " file provided"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the status associated with the data set reload. Any value other than"]
    #[doc = " #FIFTYONE_DEGREES_STATUS_SUCCESS means the data set was not reloaded"]
    #[doc = " correctly"]
    pub fn fiftyoneDegreesDataSetReloadManagerFromFile(
        manager: *mut fiftyoneDegreesResourceManager,
        fileName: *const ::std::os::raw::c_char,
        dataSetSize: size_t,
        initDataSet: fiftyoneDegreesDataSetInitFromFileMethod,
        exception: *mut fiftyoneDegreesException,
    ) -> fiftyoneDegreesStatusCode;
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_date_t {
    #[doc = "< Year"]
    pub year: i16,
    #[doc = "< Month"]
    pub month: byte,
    #[doc = "< Day of the Month"]
    pub day: byte,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_date_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_date_t>(),
        4usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_date_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_date_t>(),
        1usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_date_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_date_t>())).year as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_date_t),
            "::",
            stringify!(year)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_date_t>())).month as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_date_t),
            "::",
            stringify!(month)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fiftyone_degrees_date_t>())).day as *const _ as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_date_t),
            "::",
            stringify!(day)
        )
    );
}
pub type fiftyoneDegreesDate = fiftyone_degrees_date_t;
#[doc = "< The difference"]
#[doc = "value is higher than"]
#[doc = "the threshold, see"]
#[doc = "the Pattern API"]
pub const e_fiftyone_degrees_results_no_value_reason_FIFTYONE_DEGREES_RESULTS_NO_VALUE_REASON_DIFFERENCE : e_fiftyone_degrees_results_no_value_reason = 0 ;
#[doc = "< No hash"]
#[doc = "nodes were"]
#[doc = "matched, see the"]
#[doc = "Hash API"]
pub const e_fiftyone_degrees_results_no_value_reason_FIFTYONE_DEGREES_RESULTS_NO_VALUE_REASON_NO_MATCHED_NODES : e_fiftyone_degrees_results_no_value_reason = 1 ;
#[doc = "< The requested"]
#[doc = "property does"]
#[doc = "not exist, or is"]
#[doc = "not a required"]
#[doc = "property"]
pub const e_fiftyone_degrees_results_no_value_reason_FIFTYONE_DEGREES_RESULTS_NO_VALUE_REASON_INVALID_PROPERTY : e_fiftyone_degrees_results_no_value_reason = 2 ;
#[doc = "< There"]
#[doc = "is no result"]
#[doc = "which"]
#[doc = "contains a"]
#[doc = "value for"]
#[doc = "the requested"]
#[doc = "property"]
pub const e_fiftyone_degrees_results_no_value_reason_FIFTYONE_DEGREES_RESULTS_NO_VALUE_REASON_NO_RESULT_FOR_PROPERTY : e_fiftyone_degrees_results_no_value_reason = 3 ;
#[doc = "< There are no"]
#[doc = "results to get a value"]
#[doc = "from"]
pub const e_fiftyone_degrees_results_no_value_reason_FIFTYONE_DEGREES_RESULTS_NO_VALUE_REASON_NO_RESULTS : e_fiftyone_degrees_results_no_value_reason = 4 ;
#[doc = "< There are too"]
#[doc = "many values to be"]
#[doc = "expressed as the"]
#[doc = "requested type"]
pub const e_fiftyone_degrees_results_no_value_reason_FIFTYONE_DEGREES_RESULTS_NO_VALUE_REASON_TOO_MANY_VALUES : e_fiftyone_degrees_results_no_value_reason = 5 ;
#[doc = "< The results"]
#[doc = "contain a null"]
#[doc = "profile for the"]
#[doc = "required component"]
pub const e_fiftyone_degrees_results_no_value_reason_FIFTYONE_DEGREES_RESULTS_NO_VALUE_REASON_NULL_PROFILE : e_fiftyone_degrees_results_no_value_reason = 6 ;
#[doc = "< None of the above"]
pub const e_fiftyone_degrees_results_no_value_reason_FIFTYONE_DEGREES_RESULTS_NO_VALUE_REASON_UNKNOWN : e_fiftyone_degrees_results_no_value_reason = 7 ;
#[doc = " Enum containing reasons which cause a value to not be present or valid."]
pub type e_fiftyone_degrees_results_no_value_reason = ::std::os::raw::c_uint;
#[doc = " Enum containing reasons which cause a value to not be present or valid."]
pub use self::e_fiftyone_degrees_results_no_value_reason as fiftyoneDegreesResultsNoValueReason;
#[doc = " Base results structure which any processing results should extend."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_results_base_t {
    #[doc = "< Pointer to the data set associated with the results"]
    pub dataSet: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_results_base_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_results_base_t>(),
        8usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_results_base_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_results_base_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_results_base_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_results_base_t>())).dataSet as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_results_base_t),
            "::",
            stringify!(dataSet)
        )
    );
}
#[doc = " Base results structure which any processing results should extend."]
pub type fiftyoneDegreesResultsBase = fiftyone_degrees_results_base_t;
extern "C" {
    #[doc = " Initialise a set of results by setting the data set they are associated with."]
    #[doc = " @param results pointer to the results to initialise"]
    #[doc = " @param dataSet pointer to the data set which will be using the results"]
    #[doc = " @return pointer to the initialised results"]
    pub fn fiftyoneDegreesResultsInit(
        results: *mut fiftyoneDegreesResultsBase,
        dataSet: *mut ::std::os::raw::c_void,
    ) -> *mut fiftyoneDegreesResultsBase;
}
#[doc = "< String"]
pub const e_fiftyone_degrees_property_value_type_FIFTYONE_DEGREES_PROPERTY_VALUE_TYPE_STRING:
    e_fiftyone_degrees_property_value_type = 0;
#[doc = "< Integer"]
pub const e_fiftyone_degrees_property_value_type_FIFTYONE_DEGREES_PROPERTY_VALUE_TYPE_INTEGER:
    e_fiftyone_degrees_property_value_type = 1;
#[doc = "< Double"]
pub const e_fiftyone_degrees_property_value_type_FIFTYONE_DEGREES_PROPERTY_VALUE_TYPE_DOUBLE:
    e_fiftyone_degrees_property_value_type = 2;
#[doc = "< Boolean"]
pub const e_fiftyone_degrees_property_value_type_FIFTYONE_DEGREES_PROPERTY_VALUE_TYPE_BOOLEAN:
    e_fiftyone_degrees_property_value_type = 3;
#[doc = "< JavaScript string"]
pub const e_fiftyone_degrees_property_value_type_FIFTYONE_DEGREES_PROPERTY_VALUE_TYPE_JAVASCRIPT:
    e_fiftyone_degrees_property_value_type = 4;
#[doc = "< Single precision floating point value"]
pub const e_fiftyone_degrees_property_value_type_FIFTYONE_DEGREES_PROPERTY_VALUE_SINGLE_PRECISION_FLOAT : e_fiftyone_degrees_property_value_type = 5 ;
#[doc = "< Single byte value"]
pub const e_fiftyone_degrees_property_value_type_FIFTYONE_DEGREES_PROPERTY_VALUE_SINGLE_BYTE:
    e_fiftyone_degrees_property_value_type = 6;
#[doc = "< Coordinate"]
pub const e_fiftyone_degrees_property_value_type_FIFTYONE_DEGREES_PROPERTY_VALUE_TYPE_COORDINATE:
    e_fiftyone_degrees_property_value_type = 7;
#[doc = "< Ip Range"]
pub const e_fiftyone_degrees_property_value_type_FIFTYONE_DEGREES_PROPERTY_VALUE_TYPE_IP_ADDRESS:
    e_fiftyone_degrees_property_value_type = 8;
#[doc = " Enum of property types."]
pub type e_fiftyone_degrees_property_value_type = ::std::os::raw::c_uint;
#[doc = " Enum of property types."]
pub use self::e_fiftyone_degrees_property_value_type as fiftyoneDegreesPropertyValueType;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct property_t {
    #[doc = "< Index of the component"]
    pub componentIndex: byte,
    #[doc = "< The order the property should be displayed in"]
    #[doc = "relative to other properties"]
    pub displayOrder: byte,
    #[doc = "< True if the property is mandatory and must be"]
    #[doc = "provided"]
    pub isMandatory: byte,
    #[doc = "< True if the property is a list can return multiple"]
    #[doc = "values"]
    pub isList: byte,
    #[doc = "< True if the values should be shown in GUIs"]
    pub showValues: byte,
    #[doc = "< True if the property is obsolete and will be"]
    #[doc = "removed from future data sets"]
    pub isObsolete: byte,
    #[doc = "< True if the property should be shown in GUIs"]
    pub show: byte,
    #[doc = "< The type of value the property represents"]
    pub valueType: byte,
    #[doc = "< The default value index for the"]
    #[doc = "property"]
    pub defaultValueIndex: u32,
    #[doc = "< The offset in the strings structure to the"]
    #[doc = "property name"]
    pub nameOffset: u32,
    #[doc = "< The offset in the strings structure"]
    #[doc = "to the property description"]
    pub descriptionOffset: u32,
    #[doc = "< The offset in the strings structure to"]
    #[doc = "the property category"]
    pub categoryOffset: u32,
    #[doc = "< The offset in the strings structure to the"]
    #[doc = "property URL"]
    pub urlOffset: u32,
    #[doc = "< Index of the first possible value"]
    pub firstValueIndex: u32,
    #[doc = "< Index of the last possible value"]
    pub lastValueIndex: u32,
    #[doc = "< Number of maps the property is associated with"]
    pub mapCount: u32,
    #[doc = "< The first index in the list of maps the"]
    #[doc = "property is associated with"]
    pub firstMapIndex: u32,
}
#[test]
fn bindgen_test_layout_property_t() {
    assert_eq!(
        ::std::mem::size_of::<property_t>(),
        44usize,
        concat!("Size of: ", stringify!(property_t))
    );
    assert_eq!(
        ::std::mem::align_of::<property_t>(),
        1usize,
        concat!("Alignment of ", stringify!(property_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<property_t>())).componentIndex as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(property_t),
            "::",
            stringify!(componentIndex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<property_t>())).displayOrder as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(property_t),
            "::",
            stringify!(displayOrder)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<property_t>())).isMandatory as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(property_t),
            "::",
            stringify!(isMandatory)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<property_t>())).isList as *const _ as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(property_t),
            "::",
            stringify!(isList)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<property_t>())).showValues as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(property_t),
            "::",
            stringify!(showValues)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<property_t>())).isObsolete as *const _ as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(property_t),
            "::",
            stringify!(isObsolete)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<property_t>())).show as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(property_t),
            "::",
            stringify!(show)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<property_t>())).valueType as *const _ as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(property_t),
            "::",
            stringify!(valueType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<property_t>())).defaultValueIndex as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(property_t),
            "::",
            stringify!(defaultValueIndex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<property_t>())).nameOffset as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(property_t),
            "::",
            stringify!(nameOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<property_t>())).descriptionOffset as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(property_t),
            "::",
            stringify!(descriptionOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<property_t>())).categoryOffset as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(property_t),
            "::",
            stringify!(categoryOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<property_t>())).urlOffset as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(property_t),
            "::",
            stringify!(urlOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<property_t>())).firstValueIndex as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(property_t),
            "::",
            stringify!(firstValueIndex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<property_t>())).lastValueIndex as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(property_t),
            "::",
            stringify!(lastValueIndex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<property_t>())).mapCount as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(property_t),
            "::",
            stringify!(mapCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<property_t>())).firstMapIndex as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(property_t),
            "::",
            stringify!(firstMapIndex)
        )
    );
}
pub type fiftyoneDegreesProperty = property_t;
extern "C" {
    #[doc = " Returns the string name of the property using the item provided. The"]
    #[doc = " collection item must be released when the caller is finished with the"]
    #[doc = " string."]
    #[doc = " @param stringsCollection collection of strings retrieved by offsets."]
    #[doc = " @param property structure for the name required."]
    #[doc = " @param item used to store the resulting string in."]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return a pointer to a string in the collection item data structure."]
    pub fn fiftyoneDegreesPropertyGetName(
        stringsCollection: *mut fiftyoneDegreesCollection,
        property: *mut fiftyoneDegreesProperty,
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesString;
}
extern "C" {
    #[doc = " Returns the string description of the property using the item provided. The"]
    #[doc = " collection item must be released when the caller is finished with the"]
    #[doc = " string."]
    #[doc = " @param stringsCollection collection of strings retrieved by offsets."]
    #[doc = " @param property structure for the description required."]
    #[doc = " @param item used to store the resulting string in."]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return a pointer to a string in the collection item data structure."]
    pub fn fiftyoneDegreesPropertyGetDescription(
        stringsCollection: *mut fiftyoneDegreesCollection,
        property: *mut fiftyoneDegreesProperty,
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesString;
}
extern "C" {
    #[doc = " Returns the string category of the property using the item provided. The"]
    #[doc = " collection item must be released when the caller is finished with the"]
    #[doc = " string."]
    #[doc = " @param stringsCollection collection of strings retrieved by offsets."]
    #[doc = " @param property structure for the category required."]
    #[doc = " @param item used to store the resulting string in."]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return a pointer to a string in the collection item data structure."]
    pub fn fiftyoneDegreesPropertyGetCategory(
        stringsCollection: *mut fiftyoneDegreesCollection,
        property: *mut fiftyoneDegreesProperty,
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesString;
}
extern "C" {
    #[doc = " Returns the string URL of the property using the item provided. The"]
    #[doc = " collection item must be released when the caller is finished with the"]
    #[doc = " string."]
    #[doc = " @param stringsCollection collection of strings retrieved by offsets."]
    #[doc = " @param property structure for the URL required."]
    #[doc = " @param item used to store the resulting string in."]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return a pointer to a string in the collection item data structure."]
    pub fn fiftyoneDegreesPropertyGetUrl(
        stringsCollection: *mut fiftyoneDegreesCollection,
        property: *mut fiftyoneDegreesProperty,
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesString;
}
extern "C" {
    #[doc = " Gets the value type for the property at the index in the collection."]
    #[doc = " @param properties collection to retrieve the property type from"]
    #[doc = " @param index of the property in the collection"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the value type as a byte for the property at the index."]
    pub fn fiftyoneDegreesPropertyGetValueType(
        properties: *mut fiftyoneDegreesCollection,
        index: u32,
        exception: *mut fiftyoneDegreesException,
    ) -> byte;
}
extern "C" {
    #[doc = " Gets the property at the requested index from the properties collection"]
    #[doc = " provided."]
    #[doc = " @param properties to get the property from"]
    #[doc = " @param index of the property to get"]
    #[doc = " @param item to store the property item in"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the property requested or NULL"]
    pub fn fiftyoneDegreesPropertyGet(
        properties: *mut fiftyoneDegreesCollection,
        index: u32,
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesProperty;
}
extern "C" {
    #[doc = " Gets the property with the requested name from the properties collection"]
    #[doc = " provided."]
    #[doc = " @param properties to get the property from"]
    #[doc = " @param strings collection containing the names of the properties"]
    #[doc = " @param requiredPropertyName name of the property to get"]
    #[doc = " @param item to store the property item in"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the property requested or NULL"]
    pub fn fiftyoneDegreesPropertyGetByName(
        properties: *mut fiftyoneDegreesCollection,
        strings: *mut fiftyoneDegreesCollection,
        requiredPropertyName: *const ::std::os::raw::c_char,
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesProperty;
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyoneDegrees_profile_t {
    #[doc = "< The index of the component the profile"]
    #[doc = "relates to"]
    pub componentIndex: byte,
    #[doc = "< Unique id of the profile"]
    pub profileId: u32,
    #[doc = "< The number of values within the profile"]
    pub valueCount: u32,
}
#[test]
fn bindgen_test_layout_fiftyoneDegrees_profile_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyoneDegrees_profile_t>(),
        9usize,
        concat!("Size of: ", stringify!(fiftyoneDegrees_profile_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyoneDegrees_profile_t>(),
        1usize,
        concat!("Alignment of ", stringify!(fiftyoneDegrees_profile_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_profile_t>())).componentIndex as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_profile_t),
            "::",
            stringify!(componentIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_profile_t>())).profileId as *const _ as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_profile_t),
            "::",
            stringify!(profileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_profile_t>())).valueCount as *const _ as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_profile_t),
            "::",
            stringify!(valueCount)
        )
    );
}
pub type fiftyoneDegreesProfile = fiftyoneDegrees_profile_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyoneDegrees_profile_offset_t {
    #[doc = "< The unique Id of the profile"]
    pub profileId: u32,
    #[doc = "< Offset to the profile in the profiles structure"]
    pub offset: u32,
}
#[test]
fn bindgen_test_layout_fiftyoneDegrees_profile_offset_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyoneDegrees_profile_offset_t>(),
        8usize,
        concat!("Size of: ", stringify!(fiftyoneDegrees_profile_offset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyoneDegrees_profile_offset_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyoneDegrees_profile_offset_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_profile_offset_t>())).profileId as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_profile_offset_t),
            "::",
            stringify!(profileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_profile_offset_t>())).offset as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_profile_offset_t),
            "::",
            stringify!(offset)
        )
    );
}
pub type fiftyoneDegreesProfileOffset = fiftyoneDegrees_profile_offset_t;
#[doc = " Definition of a callback function which is passed an item of a type"]
#[doc = " determined by the iteration method."]
#[doc = " @param state pointer to data needed by the method"]
#[doc = " @param item to store each profile in while iterating"]
#[doc = " @return true if the iteration should continue, otherwise false to stop"]
pub type fiftyoneDegreesProfileIterateMethod = ::std::option::Option<
    unsafe extern "C" fn(
        state: *mut ::std::os::raw::c_void,
        item: *mut fiftyoneDegreesCollectionItem,
    ) -> bool,
>;
extern "C" {
    #[doc = " Gets the profile associated with the profileId or NULL if there is no"]
    #[doc = " corresponding profile."]
    #[doc = " @param profileOffsets collection containing the profile offsets"]
    #[doc = " @param profiles collection containing the profiles referenced by the profile"]
    #[doc = " offsets"]
    #[doc = " @param profileId the unique id of the profile to fetch"]
    #[doc = " @param item to set as the handle to the profile returned"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    #[doc = " @return pointer to the profile or NULL"]
    pub fn fiftyoneDegreesProfileGetByProfileId(
        profileOffsets: *mut fiftyoneDegreesCollection,
        profiles: *mut fiftyoneDegreesCollection,
        profileId: u32,
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesProfile;
}
extern "C" {
    #[doc = " Gets a pointer to the profile at the index provided. The index refers to the"]
    #[doc = " index in the profile offsets collection as this contains fixed size entities"]
    #[doc = " which can be quickly looked up. The variable sized profile is then returned"]
    #[doc = " from that."]
    #[doc = " @param profileOffsets collection containing the profile offsets"]
    #[doc = " @param profiles collection containing the profiles referenced by the profile"]
    #[doc = " offsets"]
    #[doc = " @param index of the profile to return"]
    #[doc = " @param item to set as the handle to the profile returned"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    #[doc = " @return pointer to the profile at the index"]
    pub fn fiftyoneDegreesProfileGetByIndex(
        profileOffsets: *mut fiftyoneDegreesCollection,
        profiles: *mut fiftyoneDegreesCollection,
        index: u32,
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesProfile;
}
extern "C" {
    #[doc = " Read a profile from the file collection provided and store in the data"]
    #[doc = " pointer. This method is used when creating a collection from file."]
    #[doc = " @param file collection to read from"]
    #[doc = " @param offset of the profile in the collection"]
    #[doc = " @param data to store the resulting profile in"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    #[doc = " @return pointer to the profile allocated within the data structure"]
    pub fn fiftyoneDegreesProfileReadFromFile(
        file: *const fiftyoneDegreesCollectionFile,
        offset: u32,
        data: *mut fiftyoneDegreesData,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Iterate over all values contained in the profile which relate to the"]
    #[doc = " specified property, calling the callback method for each."]
    #[doc = " @param values collection containing all values"]
    #[doc = " @param profile pointer to the profile to iterate the values of"]
    #[doc = " @param property which the values must relate to"]
    #[doc = " @param state pointer containing data needed for the callback method"]
    #[doc = " @param callback method to be called for each value"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    #[doc = " @return the number of matching values which have been iterated"]
    pub fn fiftyoneDegreesProfileIterateValuesForProperty(
        values: *mut fiftyoneDegreesCollection,
        profile: *mut fiftyoneDegreesProfile,
        property: *mut fiftyoneDegreesProperty,
        state: *mut ::std::os::raw::c_void,
        callback: fiftyoneDegreesProfileIterateMethod,
        exception: *mut fiftyoneDegreesException,
    ) -> u32;
}
extern "C" {
    #[doc = " Iterate all profiles which contain the specified value, calling the callback"]
    #[doc = " method for each."]
    #[doc = " @param strings collection containing the strings referenced properties and"]
    #[doc = " values"]
    #[doc = " @param properties collection containing all properties"]
    #[doc = " @param values collection containing all values"]
    #[doc = " @param profiles collection containing the profiles referenced by the profile"]
    #[doc = " offsets"]
    #[doc = " @param profileOffsets collection containing all profile offsets"]
    #[doc = " @param propertyName name of the property the value relates to"]
    #[doc = " @param valueName name of the value to iterate the profiles for"]
    #[doc = " @param state pointer to data needed by the callback method"]
    #[doc = " @param callback method to be called for each matching profile"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    #[doc = " @return the number matching profiles which have been iterated"]
    pub fn fiftyoneDegreesProfileIterateProfilesForPropertyAndValue(
        strings: *mut fiftyoneDegreesCollection,
        properties: *mut fiftyoneDegreesCollection,
        values: *mut fiftyoneDegreesCollection,
        profiles: *mut fiftyoneDegreesCollection,
        profileOffsets: *mut fiftyoneDegreesCollection,
        propertyName: *const ::std::os::raw::c_char,
        valueName: *const ::std::os::raw::c_char,
        state: *mut ::std::os::raw::c_void,
        callback: fiftyoneDegreesProfileIterateMethod,
        exception: *mut fiftyoneDegreesException,
    ) -> u32;
}
extern "C" {
    #[doc = " Gets the offset in the profiles collection for the profile with the"]
    #[doc = " profileId or NULL if there is no corresponding profile."]
    #[doc = " @param profileOffsets collection containing the profile offsets"]
    #[doc = " @param profileId the unique id of the profile to fetch"]
    #[doc = " @param profileOffset pointer to the integer to set the offset in"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    #[doc = " @return pointer to the profile offset or NULL"]
    pub fn fiftyoneDegreesProfileGetOffsetForProfileId(
        profileOffsets: *mut fiftyoneDegreesCollection,
        profileId: u32,
        profileOffset: *mut u32,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut u32;
}
#[repr(C, packed(2))]
#[derive(Debug, Copy, Clone)]
pub struct fiftyoneDegrees_value_t {
    #[doc = "< Index of the property the value relates to"]
    pub propertyIndex: i16,
    #[doc = "< The offset in the strings structure to the"]
    #[doc = "value name"]
    pub nameOffset: i32,
    #[doc = "< The offset in the strings structure to"]
    #[doc = "the value description"]
    pub descriptionOffset: i32,
    #[doc = "< The offset in the strings structure to the"]
    #[doc = "value URL"]
    pub urlOffset: i32,
}
#[test]
fn bindgen_test_layout_fiftyoneDegrees_value_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyoneDegrees_value_t>(),
        14usize,
        concat!("Size of: ", stringify!(fiftyoneDegrees_value_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyoneDegrees_value_t>(),
        2usize,
        concat!("Alignment of ", stringify!(fiftyoneDegrees_value_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_value_t>())).propertyIndex as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_value_t),
            "::",
            stringify!(propertyIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_value_t>())).nameOffset as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_value_t),
            "::",
            stringify!(nameOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_value_t>())).descriptionOffset as *const _
                as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_value_t),
            "::",
            stringify!(descriptionOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_value_t>())).urlOffset as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_value_t),
            "::",
            stringify!(urlOffset)
        )
    );
}
pub type fiftyoneDegreesValue = fiftyoneDegrees_value_t;
extern "C" {
    #[doc = " Returns the string name of the value using the item provided. The"]
    #[doc = " collection item must be released when the caller is finished with the"]
    #[doc = " string."]
    #[doc = " @param strings collection of strings retrieved by offsets."]
    #[doc = " @param value structure for the name required."]
    #[doc = " @param item used to store the resulting string in."]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return a pointer to a string in the collection item data structure."]
    pub fn fiftyoneDegreesValueGetName(
        strings: *mut fiftyoneDegreesCollection,
        value: *mut fiftyoneDegreesValue,
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesString;
}
extern "C" {
    #[doc = " Returns the string description of the value using the item provided. The"]
    #[doc = " collection item must be released when the caller is finished with the"]
    #[doc = " string."]
    #[doc = " @param strings collection of strings retrieved by offsets."]
    #[doc = " @param value structure for the description required."]
    #[doc = " @param item used to store the resulting string in."]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return a pointer to a string in the collection item data structure."]
    pub fn fiftyoneDegreesValueGetDescription(
        strings: *mut fiftyoneDegreesCollection,
        value: *mut fiftyoneDegreesValue,
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesString;
}
extern "C" {
    #[doc = " Returns the string URL of the value using the item provided. The"]
    #[doc = " collection item must be released when the caller is finished with the"]
    #[doc = " string."]
    #[doc = " @param strings collection of strings retrieved by offsets."]
    #[doc = " @param value structure for the URL required."]
    #[doc = " @param item used to store the resulting string in."]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return a pointer to a string in the collection item data structure."]
    pub fn fiftyoneDegreesValueGetUrl(
        strings: *mut fiftyoneDegreesCollection,
        value: *mut fiftyoneDegreesValue,
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesString;
}
extern "C" {
    #[doc = " Gets the value for the requested index from the collection provided."]
    #[doc = " @param values collection to get the value from"]
    #[doc = " @param valueIndex index of the value to get"]
    #[doc = " @param item to store the value in"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return pointer to the value or NULL"]
    pub fn fiftyoneDegreesValueGet(
        values: *mut fiftyoneDegreesCollection,
        valueIndex: u32,
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesValue;
}
extern "C" {
    #[doc = " Get the value for the requested name from the collection provided."]
    #[doc = " @param values collection to get the value from"]
    #[doc = " @param strings collection containing the value names"]
    #[doc = " @param property that the value relates to"]
    #[doc = " @param valueName name of the value to get"]
    #[doc = " @param item to store the value in"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    #[doc = " @return pointer to the value or NULL if it does not exist"]
    pub fn fiftyoneDegreesValueGetByName(
        values: *mut fiftyoneDegreesCollection,
        strings: *mut fiftyoneDegreesCollection,
        property: *mut fiftyoneDegreesProperty,
        valueName: *const ::std::os::raw::c_char,
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesValue;
}
extern "C" {
    #[doc = " Get index of the value for the requested name from the collection provided."]
    #[doc = " @param values collection to get the value from"]
    #[doc = " @param strings collection containing the value names"]
    #[doc = " @param property that the value relates to"]
    #[doc = " @param valueName name of the value to get"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    #[doc = " @return the 0 based index of the item if found, otherwise -1"]
    pub fn fiftyoneDegreesValueGetIndexByName(
        values: *mut fiftyoneDegreesCollection,
        strings: *mut fiftyoneDegreesCollection,
        property: *mut fiftyoneDegreesProperty,
        valueName: *const ::std::os::raw::c_char,
        exception: *mut fiftyoneDegreesException,
    ) -> ::std::os::raw::c_long;
}
#[doc = " Singular coordinate, representing a location"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_ipi_coordinate_t {
    #[doc = "< Latitude value of the coordinate"]
    pub lat: f32,
    #[doc = "< Longitude value of the coordinate"]
    pub lon: f32,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_ipi_coordinate_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_ipi_coordinate_t>(),
        8usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_ipi_coordinate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_ipi_coordinate_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_ipi_coordinate_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_ipi_coordinate_t>())).lat as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_ipi_coordinate_t),
            "::",
            stringify!(lat)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_ipi_coordinate_t>())).lon as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_ipi_coordinate_t),
            "::",
            stringify!(lon)
        )
    );
}
#[doc = " Singular coordinate, representing a location"]
pub type fiftyoneDegreesCoordinate = fiftyone_degrees_ipi_coordinate_t;
extern "C" {
    #[doc = " Get the 51Degrees Coordinate from the strings collection item."]
    #[doc = " This should be used on the item whose property type is"]
    #[doc = " #FIFTYONE_DEGREES_PROPERTY_VALUE_TYPE_COORDINATE."]
    #[doc = " @param item the collection item pointing to the coordinate item in"]
    #[doc = " strings collection"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    #[doc = " @return the coordinate value"]
    pub fn fiftyoneDegreesIpiGetCoordinate(
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> fiftyoneDegreesCoordinate;
}
extern "C" {
    #[doc = " Iterate through pseudo-headers passed in supplied parameters, construct"]
    #[doc = " their coresponding evidence. The new evidence should be prefixed with"]
    #[doc = " the prefix of the evidence that form it. The pseudo evidence pointed by the"]
    #[doc = " evidence collection, should have pre-allocated the memory to hold the new"]
    #[doc = " constructured evidence. No new evidence should be constructed if evidence"]
    #[doc = " has already been provided in the evidence collection or there is not enough"]
    #[doc = " values to form one."]
    #[doc = ""]
    #[doc = " @param evidence pointer to the evidence that contains the real headers"]
    #[doc = " and will be updated with the pseudo-headers."]
    #[doc = " @param acceptedHeaders the list of headers accepted by the"]
    #[doc = " engine"]
    #[doc = " @param bufferSize the size of the buffer allocated to hold the new evidence"]
    #[doc = " pointed by the orignalValue in each pre-allocated pseudoEvidence item of"]
    #[doc = " the evidence collection."]
    #[doc = " @param orderOfPrecedence of the accepted prefixes"]
    #[doc = " @param precedenceSize the number of accepted prefixes"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    pub fn fiftyoneDegreesPseudoHeadersAddEvidence(
        evidence: *mut fiftyoneDegreesEvidenceKeyValuePairArray,
        acceptedHeaders: *mut fiftyoneDegreesHeaders,
        bufferSize: size_t,
        orderOfPrecedence: *const fiftyoneDegreesEvidencePrefix,
        precedenceSize: size_t,
        exception: *mut fiftyoneDegreesException,
    );
}
extern "C" {
    #[doc = " Iterate through the evidence collection and reset the pseudo-headers"]
    #[doc = " evidence. Mainly set the field and value pointers to NULL."]
    #[doc = ""]
    #[doc = " @param evidence pointer to the evidence colletection"]
    #[doc = " @param bufferSize the size of the buffer allocated to hold the new evidence"]
    #[doc = " pointed by the orignalValue in each pre-allocated pseudoEvidence item of"]
    #[doc = " the evidence collection."]
    pub fn fiftyoneDegreesPseudoHeadersRemoveEvidence(
        evidence: *mut fiftyoneDegreesEvidenceKeyValuePairArray,
        bufferSize: size_t,
    );
}
pub type Item = fiftyoneDegreesCollectionItem;
pub type Exception = fiftyoneDegreesException;
pub type CollectionIterateMethod = fiftyoneDegreesCollectionIterateMethod;
pub type CollectionMemory = fiftyoneDegreesCollectionMemory;
pub type CollectionFile = fiftyoneDegreesCollectionFile;
pub type CollectionFileRead = fiftyoneDegreesCollectionFileRead;
pub type CollectionCache = fiftyoneDegreesCollectionCache;
pub type FileHandle = fiftyoneDegreesFileHandle;
pub type CacheNode = fiftyoneDegreesCacheNode;
pub type FilePool = fiftyoneDegreesFilePool;
pub type CollectionHeader = fiftyoneDegreesCollectionHeader;
pub type Data = fiftyoneDegreesData;
pub type Cache = fiftyoneDegreesCache;
pub type MemoryReader = fiftyoneDegreesMemoryReader;
pub type CacheShard = fiftyoneDegreesCacheShard;
pub use self::fiftyoneDegreesStatusCode as StatusCode;
pub type PropertiesRequired = fiftyoneDegreesPropertiesRequired;
pub type DataSetBase = fiftyoneDegreesDataSetBase;
pub type ResourceManager = fiftyoneDegreesResourceManager;
pub type EvidenceKeyValuePair = fiftyoneDegreesEvidenceKeyValuePair;
pub type EvidencePrefixMap = fiftyoneDegreesEvidencePrefixMap;
pub use self::fiftyoneDegreesEvidencePrefix as EvidencePrefix;
pub type Headers = fiftyoneDegreesHeaders;
pub type ResourceHandle = fiftyoneDegreesResourceHandle;
pub type InterlockDoubleWidth = fiftyoneDegreesInterlockDoubleWidth;
pub type Pool = fiftyoneDegreesPool;
pub type PoolResourceCreate = fiftyoneDegreesPoolResourceCreate;
pub type PoolResourceFree = fiftyoneDegreesPoolResourceFree;
pub type PoolItem = fiftyoneDegreesPoolItem;
pub type PoolHead = fiftyoneDegreesPoolHead;
pub type PoolResourceSize = fiftyoneDegreesPoolResourceSize;
pub type List = fiftyoneDegreesList;
pub use self::fiftyoneDegreesEvidenceIpType as EvidenceIpType;
pub type EvidenceIpAddress = fiftyoneDegreesEvidenceIpAddress;
pub type DataSetInitFromFileMethod = fiftyoneDegreesDataSetInitFromFileMethod;
pub type DataSetInitFromMemoryMethod = fiftyoneDegreesDataSetInitFromMemoryMethod;
pub type PropertiesGetMethod = fiftyoneDegreesPropertiesGetMethod;
pub type HeadersGetMethod = fiftyoneDegreesHeadersGetMethod;
pub type String = fiftyoneDegreesString;
pub use self::fiftyoneDegreesStringFormat as StringFormat;
pub type Property = fiftyoneDegreesProperty;
pub type Component = fiftyoneDegreesComponent;
pub type ComponentKeyValuePair = fiftyoneDegreesComponentKeyValuePair;
pub type Value = fiftyoneDegreesValue;
pub type Profile = fiftyoneDegreesProfile;
pub type OverrideProperty = fiftyoneDegreesOverrideProperty;
pub type OverridePropertyArray = fiftyoneDegreesOverridePropertyArray;
pub type OverrideValue = fiftyoneDegreesOverrideValue;
pub type OverrideValueArray = fiftyoneDegreesOverrideValueArray;
pub type EvidenceKeyValuePairArray = fiftyoneDegreesEvidenceKeyValuePairArray;
pub type PropertyAvailable = fiftyoneDegreesPropertyAvailable;
pub type PropertiesAvailable = fiftyoneDegreesPropertiesAvailable;
pub type EvidencePropertyIndex = fiftyoneDegreesEvidencePropertyIndex;
pub type EvidenceProperties = fiftyoneDegreesEvidenceProperties;
pub type Header = fiftyoneDegreesHeader;
pub type OverridesFilterMethod = fiftyoneDegreesOverridesFilterMethod;
pub type Mutex = fiftyoneDegreesMutex;
pub type Signal = fiftyoneDegreesSignal;
pub type TreeNode = fiftyoneDegreesTreeNode;
pub type TreeRoot = fiftyoneDegreesTreeRoot;
pub type ProfileOffset = fiftyoneDegreesProfileOffset;
pub type ProfileIterateMethod = fiftyoneDegreesProfileIterateMethod;
pub type Float = fiftyoneDegreesFloat;
pub type Coordinate = fiftyoneDegreesCoordinate;
#[doc = " Device detection configuration structure containing device detection"]
#[doc = " specific configuration options, and options that apply to structures and"]
#[doc = " methods in device detection libraries."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_config_device_detecton_t {
    #[doc = "< Base structure members"]
    pub b: fiftyoneDegreesConfigBase,
    #[doc = "< True if the detection should record the"]
    #[doc = "matched characters from the target"]
    #[doc = "User-Agent"]
    pub updateMatchedUserAgent: bool,
    #[doc = "< Number of characters to consider in"]
    #[doc = "the matched User-Agent. Ignored if"]
    #[doc = "updateMatchedUserAgent is false."]
    pub maxMatchedUserAgentLength: size_t,
    #[doc = "< True if there should be at least one matched node"]
    #[doc = "in order for the results to be considered valid. By"]
    #[doc = "default, this is false"]
    pub allowUnmatched: bool,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_config_device_detecton_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_config_device_detecton_t>(),
        48usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_config_device_detecton_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_config_device_detecton_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_config_device_detecton_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_device_detecton_t>())).b as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_device_detecton_t),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_device_detecton_t>()))
                .updateMatchedUserAgent as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_device_detecton_t),
            "::",
            stringify!(updateMatchedUserAgent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_device_detecton_t>()))
                .maxMatchedUserAgentLength as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_device_detecton_t),
            "::",
            stringify!(maxMatchedUserAgentLength)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_device_detecton_t>())).allowUnmatched
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_device_detecton_t),
            "::",
            stringify!(allowUnmatched)
        )
    );
}
#[doc = " Device detection configuration structure containing device detection"]
#[doc = " specific configuration options, and options that apply to structures and"]
#[doc = " methods in device detection libraries."]
pub type fiftyoneDegreesConfigDeviceDetection = fiftyone_degrees_config_device_detecton_t;
#[doc = " Device detection data set structure which contains the 'must have's for all"]
#[doc = " device detection data sets."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct fiftyone_degrees_dataset_device_detection_t {
    #[doc = "< Base structure members"]
    pub b: fiftyoneDegreesDataSetBase,
    #[doc = "< The unique HTTP header for the field"]
    #[doc = "name \"User-Agent\""]
    pub uniqueUserAgentHeaderIndex: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_dataset_device_detection_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_dataset_device_detection_t>(),
        8296usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_dataset_device_detection_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_dataset_device_detection_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_dataset_device_detection_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_device_detection_t>())).b as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_device_detection_t),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_device_detection_t>()))
                .uniqueUserAgentHeaderIndex as *const _ as usize
        },
        8288usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_device_detection_t),
            "::",
            stringify!(uniqueUserAgentHeaderIndex)
        )
    );
}
#[doc = " Device detection data set structure which contains the 'must have's for all"]
#[doc = " device detection data sets."]
pub type fiftyoneDegreesDataSetDeviceDetection = fiftyone_degrees_dataset_device_detection_t;
extern "C" {
    #[doc = " @copydoc fiftyoneDegreesDataSetRelease"]
    pub fn fiftyoneDegreesDataSetDeviceDetectionRelease(
        dataSet: *mut fiftyoneDegreesDataSetDeviceDetection,
    );
}
extern "C" {
    #[doc = " @copydoc fiftyoneDegreesDataSetFree"]
    pub fn fiftyoneDegreesDataSetDeviceDetectionFree(
        dataSet: *mut fiftyoneDegreesDataSetDeviceDetection,
    );
}
extern "C" {
    #[doc = " @copydoc fiftyoneDegreesDataSetGet"]
    pub fn fiftyoneDegreesDataSetDeviceDetectionGet(
        manager: *mut fiftyoneDegreesResourceManager,
    ) -> *mut fiftyoneDegreesDataSetDeviceDetection;
}
extern "C" {
    #[doc = " Initialise the header and properties using the"]
    #[doc = " #fiftyoneDegreesDataSetInitProperties and #fiftyoneDegreesDataSetInitHeaders"]
    #[doc = " methods, set the index of the User-Agent header and initialise the override"]
    #[doc = " properties."]
    #[doc = " @param dataSet pointer to the pre allocated data set to be initialised"]
    #[doc = " @param properties the properties which should be initialised in the data set"]
    #[doc = " @param state pointer to data which is needed by get methods"]
    #[doc = " @param getPropertyMethod method used to retrieve the name of a property at"]
    #[doc = " a specified index from the data set"]
    #[doc = " @param getHeaderMethod method used to retrieve the unique id and name of a"]
    #[doc = " header at a specified index from the data set"]
    #[doc = " @param overridesFilter pointer to a filter method which determines whether"]
    #[doc = " or not a property is eligible to be overridden"]
    #[doc = " @param getEvidencePropertiesMethod method used to populate the list of"]
    #[doc = " evidence required for a property in the data set"]
    #[doc = " @return the status associated with the header initialisation. Any value"]
    #[doc = " other than #FIFTYONE_DEGREES_STATUS_SUCCESS  means the headers were not"]
    #[doc = " initialised correctly"]
    pub fn fiftyoneDegreesDataSetDeviceDetectionInitPropertiesAndHeaders(
        dataSet: *mut fiftyoneDegreesDataSetDeviceDetection,
        properties: *mut fiftyoneDegreesPropertiesRequired,
        state: *mut ::std::os::raw::c_void,
        getPropertyMethod: fiftyoneDegreesPropertiesGetMethod,
        getHeaderMethod: fiftyoneDegreesHeadersGetMethod,
        overridesFilter: fiftyoneDegreesOverridesFilterMethod,
        getEvidencePropertiesMethod: fiftyoneDegreesEvidencePropertiesGetMethod,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " @copydoc fiftyoneDegreesDataSetReset"]
    pub fn fiftyoneDegreesDataSetDeviceDetectionReset(
        dataSet: *mut fiftyoneDegreesDataSetDeviceDetection,
    );
}
#[doc = " Singular User-Agent result returned by a device detection process method."]
#[doc = " This contains data describing the matched User-Agent string."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_result_user_agent_t {
    #[doc = "< Index in the headers collection of the data"]
    #[doc = "set to the HTTP header field"]
    #[doc = "i.e. User-Agent"]
    pub uniqueHttpHeaderIndex: ::std::os::raw::c_int,
    #[doc = "< Pointer to the matched User-Agent if requested"]
    #[doc = "by setting the updateMatchedUserAgent config option"]
    #[doc = "to true, otherwise NULL. The memory allocated to"]
    #[doc = "the pointer is determined by the"]
    #[doc = "maxMatchedUserAgentLength member of the"]
    #[doc = "ConfigDeviceDetection structure. The final"]
    #[doc = "character will always be a null terminator once"]
    #[doc = "initialized by the ResultsUserAgentInit method"]
    pub matchedUserAgent: *mut ::std::os::raw::c_char,
    #[doc = "< Number of characters in the matched"]
    #[doc = "User-Agent"]
    pub matchedUserAgentLength: ::std::os::raw::c_int,
    #[doc = "< Pointer to the string containing the"]
    #[doc = "User-Agent for processing"]
    pub targetUserAgent: *const ::std::os::raw::c_char,
    #[doc = "< Number of characters in the target"]
    #[doc = "User-Agent"]
    pub targetUserAgentLength: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_result_user_agent_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_result_user_agent_t>(),
        40usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_result_user_agent_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_result_user_agent_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_result_user_agent_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_result_user_agent_t>())).uniqueHttpHeaderIndex
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_result_user_agent_t),
            "::",
            stringify!(uniqueHttpHeaderIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_result_user_agent_t>())).matchedUserAgent
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_result_user_agent_t),
            "::",
            stringify!(matchedUserAgent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_result_user_agent_t>())).matchedUserAgentLength
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_result_user_agent_t),
            "::",
            stringify!(matchedUserAgentLength)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_result_user_agent_t>())).targetUserAgent
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_result_user_agent_t),
            "::",
            stringify!(targetUserAgent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_result_user_agent_t>())).targetUserAgentLength
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_result_user_agent_t),
            "::",
            stringify!(targetUserAgentLength)
        )
    );
}
#[doc = " Singular User-Agent result returned by a device detection process method."]
#[doc = " This contains data describing the matched User-Agent string."]
pub type fiftyoneDegreesResultUserAgent = fiftyone_degrees_result_user_agent_t;
#[doc = " Device detection specific results structure which any device detection"]
#[doc = " processing results should extend. This adds an array of value overrides to"]
#[doc = " the base results."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_results_device_detection_t {
    #[doc = "< Base results"]
    pub b: fiftyoneDegreesResultsBase,
    #[doc = "< Any value overrides in"]
    #[doc = "the results"]
    pub overrides: *mut fiftyoneDegreesOverrideValueArray,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_results_device_detection_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_results_device_detection_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_results_device_detection_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_results_device_detection_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_results_device_detection_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_results_device_detection_t>())).b as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_results_device_detection_t),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_results_device_detection_t>())).overrides
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_results_device_detection_t),
            "::",
            stringify!(overrides)
        )
    );
}
#[doc = " Device detection specific results structure which any device detection"]
#[doc = " processing results should extend. This adds an array of value overrides to"]
#[doc = " the base results."]
pub type fiftyoneDegreesResultsDeviceDetection = fiftyone_degrees_results_device_detection_t;
extern "C" {
    #[doc = " Initialise a set of results by setting the data set they are associated with."]
    #[doc = " Also initialise the overrides using the #fiftyoneDegreesOverrideValuesCreate"]
    #[doc = " method."]
    #[doc = " @param results pointer to the results to initialise"]
    #[doc = " @param dataSet pointer to the data set which will be using the results"]
    #[doc = " @param overridesCapacity size of the overrides structure"]
    pub fn fiftyoneDegreesResultsDeviceDetectionInit(
        results: *mut fiftyoneDegreesResultsDeviceDetection,
        dataSet: *mut fiftyoneDegreesDataSetDeviceDetection,
        overridesCapacity: u32,
    );
}
extern "C" {
    #[doc = " Free any extra data within the results. This calls the"]
    #[doc = " #fiftyoneDegreesOverrideValuesFree method to free the overrides within the"]
    #[doc = " results."]
    #[doc = " @param results pointer to the results to free"]
    pub fn fiftyoneDegreesResultsDeviceDetectionFree(
        results: *mut fiftyoneDegreesResultsDeviceDetection,
    );
}
extern "C" {
    #[doc = " Reset the matched and target User-Agents in the result. This means nulling"]
    #[doc = " the target User-Agent, and setting all characters of the matched User-Agent"]
    #[doc = " to '_'."]
    #[doc = " @param config pointer to the configuration to use"]
    #[doc = " @param result pointer to the result to reset"]
    pub fn fiftyoneDegreesResultsUserAgentReset(
        config: *const fiftyoneDegreesConfigDeviceDetection,
        result: *mut fiftyoneDegreesResultUserAgent,
    );
}
extern "C" {
    #[doc = " Initialise a single result using the configuration provided. This allocates"]
    #[doc = " the memory needed, initialises NULL pointers, and sets all characters of the"]
    #[doc = " matched User-Agent to '_'."]
    #[doc = " @param config pointer to the configuration to use"]
    #[doc = " @param result pointer to the result to initialise"]
    pub fn fiftyoneDegreesResultsUserAgentInit(
        config: *const fiftyoneDegreesConfigDeviceDetection,
        result: *mut fiftyoneDegreesResultUserAgent,
    );
}
extern "C" {
    #[doc = " Free the memory allocated in a single result,. This frees the matched"]
    #[doc = " User-Agent."]
    #[doc = " @param result pointer to the result to free"]
    pub fn fiftyoneDegreesResultsUserAgentFree(result: *mut fiftyoneDegreesResultUserAgent);
}
pub type ConfigDeviceDetection = fiftyoneDegreesConfigDeviceDetection;
pub type ResultsDeviceDetection = fiftyoneDegreesResultsDeviceDetection;
pub type DataSetDeviceDetection = fiftyoneDegreesDataSetDeviceDetection;
pub type ResultUserAgent = fiftyoneDegreesResultUserAgent;
pub type float_t = f32;
pub type double_t = f64;
extern "C" {
    pub fn __math_errhandling() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __fpclassifyf(arg1: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __fpclassifyd(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __fpclassifyl(arg1: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn acosf(arg1: f32) -> f32;
}
extern "C" {
    pub fn acos(arg1: f64) -> f64;
}
extern "C" {
    pub fn acosl(arg1: u128) -> u128;
}
extern "C" {
    pub fn asinf(arg1: f32) -> f32;
}
extern "C" {
    pub fn asin(arg1: f64) -> f64;
}
extern "C" {
    pub fn asinl(arg1: u128) -> u128;
}
extern "C" {
    pub fn atanf(arg1: f32) -> f32;
}
extern "C" {
    pub fn atan(arg1: f64) -> f64;
}
extern "C" {
    pub fn atanl(arg1: u128) -> u128;
}
extern "C" {
    pub fn atan2f(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn atan2(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn atan2l(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn cosf(arg1: f32) -> f32;
}
extern "C" {
    pub fn cos(arg1: f64) -> f64;
}
extern "C" {
    pub fn cosl(arg1: u128) -> u128;
}
extern "C" {
    pub fn sinf(arg1: f32) -> f32;
}
extern "C" {
    pub fn sin(arg1: f64) -> f64;
}
extern "C" {
    pub fn sinl(arg1: u128) -> u128;
}
extern "C" {
    pub fn tanf(arg1: f32) -> f32;
}
extern "C" {
    pub fn tan(arg1: f64) -> f64;
}
extern "C" {
    pub fn tanl(arg1: u128) -> u128;
}
extern "C" {
    pub fn acoshf(arg1: f32) -> f32;
}
extern "C" {
    pub fn acosh(arg1: f64) -> f64;
}
extern "C" {
    pub fn acoshl(arg1: u128) -> u128;
}
extern "C" {
    pub fn asinhf(arg1: f32) -> f32;
}
extern "C" {
    pub fn asinh(arg1: f64) -> f64;
}
extern "C" {
    pub fn asinhl(arg1: u128) -> u128;
}
extern "C" {
    pub fn atanhf(arg1: f32) -> f32;
}
extern "C" {
    pub fn atanh(arg1: f64) -> f64;
}
extern "C" {
    pub fn atanhl(arg1: u128) -> u128;
}
extern "C" {
    pub fn coshf(arg1: f32) -> f32;
}
extern "C" {
    pub fn cosh(arg1: f64) -> f64;
}
extern "C" {
    pub fn coshl(arg1: u128) -> u128;
}
extern "C" {
    pub fn sinhf(arg1: f32) -> f32;
}
extern "C" {
    pub fn sinh(arg1: f64) -> f64;
}
extern "C" {
    pub fn sinhl(arg1: u128) -> u128;
}
extern "C" {
    pub fn tanhf(arg1: f32) -> f32;
}
extern "C" {
    pub fn tanh(arg1: f64) -> f64;
}
extern "C" {
    pub fn tanhl(arg1: u128) -> u128;
}
extern "C" {
    pub fn expf(arg1: f32) -> f32;
}
extern "C" {
    pub fn exp(arg1: f64) -> f64;
}
extern "C" {
    pub fn expl(arg1: u128) -> u128;
}
extern "C" {
    pub fn exp2f(arg1: f32) -> f32;
}
extern "C" {
    pub fn exp2(arg1: f64) -> f64;
}
extern "C" {
    pub fn exp2l(arg1: u128) -> u128;
}
extern "C" {
    pub fn expm1f(arg1: f32) -> f32;
}
extern "C" {
    pub fn expm1(arg1: f64) -> f64;
}
extern "C" {
    pub fn expm1l(arg1: u128) -> u128;
}
extern "C" {
    pub fn logf(arg1: f32) -> f32;
}
extern "C" {
    pub fn log(arg1: f64) -> f64;
}
extern "C" {
    pub fn logl(arg1: u128) -> u128;
}
extern "C" {
    pub fn log10f(arg1: f32) -> f32;
}
extern "C" {
    pub fn log10(arg1: f64) -> f64;
}
extern "C" {
    pub fn log10l(arg1: u128) -> u128;
}
extern "C" {
    pub fn log2f(arg1: f32) -> f32;
}
extern "C" {
    pub fn log2(arg1: f64) -> f64;
}
extern "C" {
    pub fn log2l(arg1: u128) -> u128;
}
extern "C" {
    pub fn log1pf(arg1: f32) -> f32;
}
extern "C" {
    pub fn log1p(arg1: f64) -> f64;
}
extern "C" {
    pub fn log1pl(arg1: u128) -> u128;
}
extern "C" {
    pub fn logbf(arg1: f32) -> f32;
}
extern "C" {
    pub fn logb(arg1: f64) -> f64;
}
extern "C" {
    pub fn logbl(arg1: u128) -> u128;
}
extern "C" {
    pub fn modff(arg1: f32, arg2: *mut f32) -> f32;
}
extern "C" {
    pub fn modf(arg1: f64, arg2: *mut f64) -> f64;
}
extern "C" {
    pub fn modfl(arg1: u128, arg2: *mut u128) -> u128;
}
extern "C" {
    pub fn ldexpf(arg1: f32, arg2: ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn ldexp(arg1: f64, arg2: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn ldexpl(arg1: u128, arg2: ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn frexpf(arg1: f32, arg2: *mut ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn frexp(arg1: f64, arg2: *mut ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn frexpl(arg1: u128, arg2: *mut ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn ilogbf(arg1: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ilogb(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ilogbl(arg1: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scalbnf(arg1: f32, arg2: ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn scalbn(arg1: f64, arg2: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn scalbnl(arg1: u128, arg2: ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn scalblnf(arg1: f32, arg2: ::std::os::raw::c_long) -> f32;
}
extern "C" {
    pub fn scalbln(arg1: f64, arg2: ::std::os::raw::c_long) -> f64;
}
extern "C" {
    pub fn scalblnl(arg1: u128, arg2: ::std::os::raw::c_long) -> u128;
}
extern "C" {
    pub fn fabsf(arg1: f32) -> f32;
}
extern "C" {
    pub fn fabs(arg1: f64) -> f64;
}
extern "C" {
    pub fn fabsl(arg1: u128) -> u128;
}
extern "C" {
    pub fn cbrtf(arg1: f32) -> f32;
}
extern "C" {
    pub fn cbrt(arg1: f64) -> f64;
}
extern "C" {
    pub fn cbrtl(arg1: u128) -> u128;
}
extern "C" {
    pub fn hypotf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn hypot(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn hypotl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn powf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn pow(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn powl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn sqrtf(arg1: f32) -> f32;
}
extern "C" {
    pub fn sqrt(arg1: f64) -> f64;
}
extern "C" {
    pub fn sqrtl(arg1: u128) -> u128;
}
extern "C" {
    pub fn erff(arg1: f32) -> f32;
}
extern "C" {
    pub fn erf(arg1: f64) -> f64;
}
extern "C" {
    pub fn erfl(arg1: u128) -> u128;
}
extern "C" {
    pub fn erfcf(arg1: f32) -> f32;
}
extern "C" {
    pub fn erfc(arg1: f64) -> f64;
}
extern "C" {
    pub fn erfcl(arg1: u128) -> u128;
}
extern "C" {
    pub fn lgammaf(arg1: f32) -> f32;
}
extern "C" {
    pub fn lgamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn lgammal(arg1: u128) -> u128;
}
extern "C" {
    pub fn tgammaf(arg1: f32) -> f32;
}
extern "C" {
    pub fn tgamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn tgammal(arg1: u128) -> u128;
}
extern "C" {
    pub fn ceilf(arg1: f32) -> f32;
}
extern "C" {
    pub fn ceil(arg1: f64) -> f64;
}
extern "C" {
    pub fn ceill(arg1: u128) -> u128;
}
extern "C" {
    pub fn floorf(arg1: f32) -> f32;
}
extern "C" {
    pub fn floor(arg1: f64) -> f64;
}
extern "C" {
    pub fn floorl(arg1: u128) -> u128;
}
extern "C" {
    pub fn nearbyintf(arg1: f32) -> f32;
}
extern "C" {
    pub fn nearbyint(arg1: f64) -> f64;
}
extern "C" {
    pub fn nearbyintl(arg1: u128) -> u128;
}
extern "C" {
    pub fn rintf(arg1: f32) -> f32;
}
extern "C" {
    pub fn rint(arg1: f64) -> f64;
}
extern "C" {
    pub fn rintl(arg1: u128) -> u128;
}
extern "C" {
    pub fn lrintf(arg1: f32) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn lrint(arg1: f64) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn lrintl(arg1: u128) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn roundf(arg1: f32) -> f32;
}
extern "C" {
    pub fn round(arg1: f64) -> f64;
}
extern "C" {
    pub fn roundl(arg1: u128) -> u128;
}
extern "C" {
    pub fn lroundf(arg1: f32) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn lround(arg1: f64) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn lroundl(arg1: u128) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llrintf(arg1: f32) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn llrint(arg1: f64) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn llrintl(arg1: u128) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn llroundf(arg1: f32) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn llround(arg1: f64) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn llroundl(arg1: u128) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn truncf(arg1: f32) -> f32;
}
extern "C" {
    pub fn trunc(arg1: f64) -> f64;
}
extern "C" {
    pub fn truncl(arg1: u128) -> u128;
}
extern "C" {
    pub fn fmodf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn fmod(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn fmodl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn remainderf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn remainder(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn remainderl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn remquof(arg1: f32, arg2: f32, arg3: *mut ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn remquo(arg1: f64, arg2: f64, arg3: *mut ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn remquol(arg1: u128, arg2: u128, arg3: *mut ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn copysignf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn copysign(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn copysignl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn nanf(arg1: *const ::std::os::raw::c_char) -> f32;
}
extern "C" {
    pub fn nan(arg1: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn nanl(arg1: *const ::std::os::raw::c_char) -> u128;
}
extern "C" {
    pub fn nextafterf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn nextafter(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn nextafterl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn nexttoward(arg1: f64, arg2: u128) -> f64;
}
extern "C" {
    pub fn nexttowardf(arg1: f32, arg2: u128) -> f32;
}
extern "C" {
    pub fn nexttowardl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn fdimf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn fdim(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn fdiml(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn fmaxf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn fmax(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn fmaxl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn fminf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn fmin(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn fminl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn fmaf(arg1: f32, arg2: f32, arg3: f32) -> f32;
}
extern "C" {
    pub fn fma(arg1: f64, arg2: f64, arg3: f64) -> f64;
}
extern "C" {
    pub fn fmal(arg1: u128, arg2: u128, arg3: u128) -> u128;
}
extern "C" {
    pub fn __inff() -> f32;
}
extern "C" {
    pub fn __inf() -> f64;
}
extern "C" {
    pub fn __infl() -> u128;
}
extern "C" {
    pub fn __nan() -> f32;
}
extern "C" {
    pub fn __exp10f(arg1: f32) -> f32;
}
extern "C" {
    pub fn __exp10(arg1: f64) -> f64;
}
extern "C" {
    pub fn __cospif(arg1: f32) -> f32;
}
extern "C" {
    pub fn __cospi(arg1: f64) -> f64;
}
extern "C" {
    pub fn __sinpif(arg1: f32) -> f32;
}
extern "C" {
    pub fn __sinpi(arg1: f64) -> f64;
}
extern "C" {
    pub fn __tanpif(arg1: f32) -> f32;
}
extern "C" {
    pub fn __tanpi(arg1: f64) -> f64;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __float2 {
    pub __sinval: f32,
    pub __cosval: f32,
}
#[test]
fn bindgen_test_layout___float2() {
    assert_eq!(
        ::std::mem::size_of::<__float2>(),
        8usize,
        concat!("Size of: ", stringify!(__float2))
    );
    assert_eq!(
        ::std::mem::align_of::<__float2>(),
        4usize,
        concat!("Alignment of ", stringify!(__float2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__float2>())).__sinval as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__float2),
            "::",
            stringify!(__sinval)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__float2>())).__cosval as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__float2),
            "::",
            stringify!(__cosval)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __double2 {
    pub __sinval: f64,
    pub __cosval: f64,
}
#[test]
fn bindgen_test_layout___double2() {
    assert_eq!(
        ::std::mem::size_of::<__double2>(),
        16usize,
        concat!("Size of: ", stringify!(__double2))
    );
    assert_eq!(
        ::std::mem::align_of::<__double2>(),
        8usize,
        concat!("Alignment of ", stringify!(__double2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__double2>())).__sinval as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__double2),
            "::",
            stringify!(__sinval)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__double2>())).__cosval as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__double2),
            "::",
            stringify!(__cosval)
        )
    );
}
extern "C" {
    pub fn __sincosf_stret(arg1: f32) -> __float2;
}
extern "C" {
    pub fn __sincos_stret(arg1: f64) -> __double2;
}
extern "C" {
    pub fn __sincospif_stret(arg1: f32) -> __float2;
}
extern "C" {
    pub fn __sincospi_stret(arg1: f64) -> __double2;
}
extern "C" {
    pub fn j0(arg1: f64) -> f64;
}
extern "C" {
    pub fn j1(arg1: f64) -> f64;
}
extern "C" {
    pub fn jn(arg1: ::std::os::raw::c_int, arg2: f64) -> f64;
}
extern "C" {
    pub fn y0(arg1: f64) -> f64;
}
extern "C" {
    pub fn y1(arg1: f64) -> f64;
}
extern "C" {
    pub fn yn(arg1: ::std::os::raw::c_int, arg2: f64) -> f64;
}
extern "C" {
    pub fn scalb(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub static mut signgam: ::std::os::raw::c_int;
}
extern "C" {
    pub fn rinttol(arg1: f64) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn roundtol(arg1: f64) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn drem(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn finite(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn significand(arg1: f64) -> f64;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct exception {
    pub type_: ::std::os::raw::c_int,
    pub name: *mut ::std::os::raw::c_char,
    pub arg1: f64,
    pub arg2: f64,
    pub retval: f64,
}
#[test]
fn bindgen_test_layout_exception() {
    assert_eq!(
        ::std::mem::size_of::<exception>(),
        40usize,
        concat!("Size of: ", stringify!(exception))
    );
    assert_eq!(
        ::std::mem::align_of::<exception>(),
        8usize,
        concat!("Alignment of ", stringify!(exception))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<exception>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(exception),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<exception>())).name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(exception),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<exception>())).arg1 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(exception),
            "::",
            stringify!(arg1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<exception>())).arg2 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(exception),
            "::",
            stringify!(arg2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<exception>())).retval as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(exception),
            "::",
            stringify!(retval)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyoneDegrees_graph_node_hash_t {
    #[doc = "< Hash code to compare."]
    pub hashCode: u32,
    #[doc = "< Offset of the node to use if this hash code is a"]
    #[doc = "match."]
    pub nodeOffset: i32,
}
#[test]
fn bindgen_test_layout_fiftyoneDegrees_graph_node_hash_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyoneDegrees_graph_node_hash_t>(),
        8usize,
        concat!("Size of: ", stringify!(fiftyoneDegrees_graph_node_hash_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyoneDegrees_graph_node_hash_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyoneDegrees_graph_node_hash_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_graph_node_hash_t>())).hashCode as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_graph_node_hash_t),
            "::",
            stringify!(hashCode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_graph_node_hash_t>())).nodeOffset as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_graph_node_hash_t),
            "::",
            stringify!(nodeOffset)
        )
    );
}
pub type fiftyoneDegreesGraphNodeHash = fiftyoneDegrees_graph_node_hash_t;
#[doc = " @cond FORWARD_DECLARATIONS"]
pub type fiftyoneDegreesGraphTraceNode = fiftyoneDegrees_graph_trace_node_t;
#[doc = " Trace node structure used to trace the route taken when evaluating a graph."]
#[doc = " This contains information from a node which was evaluated, and forms part of"]
#[doc = " a linked list which describes the route taken through a graph."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyoneDegrees_graph_trace_node_t {
    #[doc = "< The index in the evidence where the hash was found, or"]
    #[doc = "the last index which was evaluated if no matching hash was"]
    #[doc = "found"]
    pub index: u32,
    #[doc = "< The length of the hashed value being evaluated"]
    pub length: u32,
    #[doc = "< The first index in the hash node"]
    pub firstIndex: u32,
    #[doc = "< The last index in the hash node"]
    pub lastIndex: u32,
    #[doc = "< The matched hash code, or zero if no matching hash"]
    #[doc = "was found"]
    pub hashCode: u32,
    #[doc = "< True if a matching hash was found"]
    pub matched: bool,
    #[doc = "< The name title of the node. This is null for most"]
    #[doc = "nodes, but for root nodes this is usually the name of the"]
    #[doc = "graph"]
    pub rootName: *mut ::std::os::raw::c_char,
    #[doc = "< Pointer to the next node in the"]
    #[doc = "linked list"]
    pub next: *mut fiftyoneDegreesGraphTraceNode,
}
#[test]
fn bindgen_test_layout_fiftyoneDegrees_graph_trace_node_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyoneDegrees_graph_trace_node_t>(),
        40usize,
        concat!("Size of: ", stringify!(fiftyoneDegrees_graph_trace_node_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyoneDegrees_graph_trace_node_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyoneDegrees_graph_trace_node_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_graph_trace_node_t>())).index as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_graph_trace_node_t),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_graph_trace_node_t>())).length as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_graph_trace_node_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_graph_trace_node_t>())).firstIndex as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_graph_trace_node_t),
            "::",
            stringify!(firstIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_graph_trace_node_t>())).lastIndex as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_graph_trace_node_t),
            "::",
            stringify!(lastIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_graph_trace_node_t>())).hashCode as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_graph_trace_node_t),
            "::",
            stringify!(hashCode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_graph_trace_node_t>())).matched as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_graph_trace_node_t),
            "::",
            stringify!(matched)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_graph_trace_node_t>())).rootName as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_graph_trace_node_t),
            "::",
            stringify!(rootName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_graph_trace_node_t>())).next as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_graph_trace_node_t),
            "::",
            stringify!(next)
        )
    );
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyoneDegrees_graph_node_t {
    #[doc = "< Offset of the node to use if there is no"]
    #[doc = "matching hash record."]
    pub unmatchedNodeOffset: i32,
    #[doc = "< Flags available for future implementation."]
    pub flags: byte,
    #[doc = "< First character index to search for a matching"]
    #[doc = "hash code."]
    pub firstIndex: i16,
    #[doc = "< Last character index to search for a matching hash"]
    #[doc = "code."]
    pub lastIndex: i16,
    #[doc = "< Length of the substring to hash."]
    pub length: byte,
    #[doc = "< Number of hash records in the node."]
    pub hashesCount: i32,
    #[doc = "< Modulo to use when the hashes are a hash table."]
    pub modulo: i32,
}
#[test]
fn bindgen_test_layout_fiftyoneDegrees_graph_node_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyoneDegrees_graph_node_t>(),
        18usize,
        concat!("Size of: ", stringify!(fiftyoneDegrees_graph_node_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyoneDegrees_graph_node_t>(),
        1usize,
        concat!("Alignment of ", stringify!(fiftyoneDegrees_graph_node_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_graph_node_t>())).unmatchedNodeOffset as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_graph_node_t),
            "::",
            stringify!(unmatchedNodeOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_graph_node_t>())).flags as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_graph_node_t),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_graph_node_t>())).firstIndex as *const _ as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_graph_node_t),
            "::",
            stringify!(firstIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_graph_node_t>())).lastIndex as *const _ as usize
        },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_graph_node_t),
            "::",
            stringify!(lastIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_graph_node_t>())).length as *const _ as usize
        },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_graph_node_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_graph_node_t>())).hashesCount as *const _
                as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_graph_node_t),
            "::",
            stringify!(hashesCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_graph_node_t>())).modulo as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_graph_node_t),
            "::",
            stringify!(modulo)
        )
    );
}
pub type fiftyoneDegreesGraphNode = fiftyoneDegrees_graph_node_t;
extern "C" {
    #[doc = " Read a graph node from the file collection provided and store in the data"]
    #[doc = " pointer. This method is used when creating a collection from file."]
    #[doc = " @param file collection to read from"]
    #[doc = " @param offset of the graph node in the collection"]
    #[doc = " @param data to store the resulting graph node in"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    #[doc = " @return pointer to the graph node allocated within the data structure"]
    pub fn fiftyoneDegreesGraphNodeReadFromFile(
        file: *const fiftyoneDegreesCollectionFile,
        offset: u32,
        data: *mut fiftyoneDegreesData,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Gets the graph node at the requested offset from the graph node collection"]
    #[doc = " provided."]
    #[doc = " @param collection to get the node from"]
    #[doc = " @param offset of the node to get"]
    #[doc = " @param item to store the node item in"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the node requested or NULL"]
    pub fn fiftyoneDegreesGraphGetNode(
        collection: *mut fiftyoneDegreesCollection,
        offset: u32,
        item: *mut fiftyoneDegreesCollectionItem,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesGraphNode;
}
extern "C" {
    #[doc = " Gets a matching hash record from a node where the hash records are"]
    #[doc = " structured as a hash table."]
    #[doc = " The value that index is set to can never be greater than the number of"]
    #[doc = " hashes. As such there is no need to perform a bounds check on index"]
    #[doc = " before using it with the array of hashes."]
    #[doc = " @param node the node to search"]
    #[doc = " @param hash the hash code to search for"]
    #[doc = " @return fiftyoneDegreesGraphNodeHash* data.ptr to a matching hash record,"]
    #[doc = "                                       or null if none match."]
    pub fn fiftyoneDegreesGraphGetMatchingHashFromListNodeTable(
        node: *mut fiftyoneDegreesGraphNode,
        hash: u32,
    ) -> *mut fiftyoneDegreesGraphNodeHash;
}
extern "C" {
    #[doc = " Gets a matching hash record from a node where the hash records are stored"]
    #[doc = " as an ordered list by performing a binary search."]
    #[doc = " @param node the node to search"]
    #[doc = " @param hash the hash code to search for"]
    #[doc = " @return fiftyoneDegreesGraphNodeHash* data.ptr to a matching hash record,"]
    #[doc = "                                       or null if none match."]
    pub fn fiftyoneDegreesGraphGetMatchingHashFromListNodeSearch(
        node: *mut fiftyoneDegreesGraphNode,
        hash: u32,
    ) -> *mut fiftyoneDegreesGraphNodeHash;
}
extern "C" {
    #[doc = " Gets a matching hash record from a node where the node has multiple hash"]
    #[doc = " records."]
    #[doc = " @param node the node to search"]
    #[doc = " @param hash the hash code to search for"]
    #[doc = " @return fiftyoneDegreesGraphNodeHash* data.ptr to a matching hash record,"]
    #[doc = "                                       or null if none match."]
    pub fn fiftyoneDegreesGraphGetMatchingHashFromListNode(
        node: *mut fiftyoneDegreesGraphNode,
        hash: u32,
    ) -> *mut fiftyoneDegreesGraphNodeHash;
}
extern "C" {
    #[doc = " Gets a matching hash record from a node where the node a single hash"]
    #[doc = " record."]
    #[doc = " @param node the node to search"]
    #[doc = " @param hash the hash code to search for"]
    #[doc = " @return fiftyoneDegreesGraphNodeHash* data.ptr to a matching hash record,"]
    #[doc = "                                       or null if none match."]
    pub fn fiftyoneDegreesGraphGetMatchingHashFromBinaryNode(
        node: *mut fiftyoneDegreesGraphNode,
        hash: u32,
    ) -> *mut fiftyoneDegreesGraphNodeHash;
}
extern "C" {
    #[doc = " Gets a matching hash record from a match where the node a single hash"]
    #[doc = " record."]
    #[doc = " @param node the node to search"]
    #[doc = " @param hash the hash code to search for"]
    #[doc = " @return fiftyoneDegreesGraphNodeHash* data.ptr to a matching hash record,"]
    #[doc = "                                       or null if none match."]
    pub fn fiftyoneDegreesGraphGetMatchingHashFromNode(
        node: *mut fiftyoneDegreesGraphNode,
        hash: u32,
    ) -> *mut fiftyoneDegreesGraphNodeHash;
}
extern "C" {
    #[doc = " Creates a new graph trace node. Importantly, this is not a graph node, but a"]
    #[doc = " graph trace node, used to trace the route taken through a graph. The node"]
    #[doc = " is allocated and initialized."]
    #[doc = " @param fmt the format string to use as the name of the node"]
    #[doc = " @param ... arguments for the format string"]
    #[doc = " @return a newly allocated graph trace node"]
    pub fn fiftyoneDegreesGraphTraceCreate(
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> *mut fiftyoneDegreesGraphTraceNode;
}
extern "C" {
    #[doc = " Frees a graph trace structure. This method frees all nodes in the linked"]
    #[doc = " list, so should be called with the root node."]
    #[doc = " @param route root node for the trace route"]
    pub fn fiftyoneDegreesGraphTraceFree(route: *mut fiftyoneDegreesGraphTraceNode);
}
extern "C" {
    #[doc = " Appends a node to an existing trace route. The new node is added to the tail"]
    #[doc = " of the linked list pointed to by route."]
    #[doc = " @param route the root of the trace route linked list"]
    #[doc = " @param node the new node to append to the trace route"]
    pub fn fiftyoneDegreesGraphTraceAppend(
        route: *mut fiftyoneDegreesGraphTraceNode,
        node: *mut fiftyoneDegreesGraphTraceNode,
    );
}
extern "C" {
    #[doc = " Writes a trace route in a readable format to a destination will the memory"]
    #[doc = " allocated, and returns the number of characters written to the destination."]
    #[doc = " If called with NULL as the destination, and 0 as length, nothing will be"]
    #[doc = " written, but the number of characters which would have been written will"]
    #[doc = " still be returned. When the buffer is not big enough, buffer will be written"]
    #[doc = " up the limit and return the number of characters which would have been"]
    #[doc = " written."]
    #[doc = " @param destination pointer to the memory to write the trace string to"]
    #[doc = " @param length the number of characters that can be written to the"]
    #[doc = " destination memory"]
    #[doc = " @param route the highest node in the route to write the trace for. This can"]
    #[doc = " be the root node, or any other node along the trace"]
    #[doc = " @param source the source string. Usually a User-Agent to get the matched"]
    #[doc = " characters from"]
    #[doc = " @return the number of characters written, or the number of characters which"]
    #[doc = " would have been written if length was long enough. Negative value if"]
    #[doc = " something has gone wrong."]
    pub fn fiftyoneDegreesGraphTraceGet(
        destination: *mut ::std::os::raw::c_char,
        length: size_t,
        route: *mut fiftyoneDegreesGraphTraceNode,
        source: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
pub const e_fiftyone_degrees_hash_match_method_FIFTYONE_DEGREES_HASH_MATCH_METHOD_NONE:
    e_fiftyone_degrees_hash_match_method = 0;
pub const e_fiftyone_degrees_hash_match_method_FIFTYONE_DEGREES_HASH_MATCH_METHOD_PERFORMANCE:
    e_fiftyone_degrees_hash_match_method = 1;
pub const e_fiftyone_degrees_hash_match_method_FIFTYONE_DEGREES_HASH_MATCH_METHOD_COMBINED:
    e_fiftyone_degrees_hash_match_method = 2;
pub const e_fiftyone_degrees_hash_match_method_FIFTYONE_DEGREES_HASH_MATCH_METHOD_PREDICTIVE:
    e_fiftyone_degrees_hash_match_method = 3;
#[doc = "< The length of the enum"]
pub const e_fiftyone_degrees_hash_match_method_FIFTYONE_DEGREES_HASH_MATCH_METHODS_LENGTH:
    e_fiftyone_degrees_hash_match_method = 4;
#[doc = " Enum used to indicate which method was used to find a match for the evidence"]
#[doc = " provided."]
pub type e_fiftyone_degrees_hash_match_method = ::std::os::raw::c_uint;
#[doc = " Enum used to indicate which method was used to find a match for the evidence"]
#[doc = " provided."]
pub use self::e_fiftyone_degrees_hash_match_method as fiftyoneDegreesHashMatchMethod;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyoneDegrees_hash_dataset_header_t {
    #[doc = "< Major version of the data file loaded"]
    pub versionMajor: i32,
    #[doc = "< Minor version of the data file loaded"]
    pub versionMinor: i32,
    #[doc = "< Build version of the data file loaded"]
    pub versionBuild: i32,
    #[doc = "< Revision version of the data file"]
    #[doc = "loaded"]
    pub versionRevision: i32,
    #[doc = "< Unique data file tag"]
    pub tag: [byte; 16usize],
    #[doc = "< Tag identifying the data file export"]
    pub exportTag: [byte; 16usize],
    #[doc = "< Offset of the copyright string in the"]
    #[doc = "strings collection"]
    pub copyrightOffset: i32,
    #[doc = "< Age of the data set format"]
    pub age: i16,
    #[doc = "< Minimum count for a User-Agent to be"]
    #[doc = "included in the data file export"]
    pub minUserAgentCount: i32,
    #[doc = "< Offset of the data file name in the strings"]
    #[doc = "collection"]
    pub nameOffset: i32,
    #[doc = "< Offset of the data file format in the"]
    #[doc = "strings collection"]
    pub formatOffset: i32,
    #[doc = "< Date when the data file was"]
    #[doc = "published"]
    pub published: fiftyoneDegreesDate,
    #[doc = "< Date when the next data file"]
    #[doc = "will be available"]
    pub nextUpdate: fiftyoneDegreesDate,
    #[doc = "< Size and location of"]
    #[doc = "the strings collection"]
    pub strings: fiftyoneDegreesCollectionHeader,
    #[doc = "< Size and location of"]
    #[doc = "the components collection"]
    pub components: fiftyoneDegreesCollectionHeader,
    #[doc = "< Size and location of the"]
    #[doc = "maps collection"]
    pub maps: fiftyoneDegreesCollectionHeader,
    #[doc = "< Size and location of"]
    #[doc = "the properties collection"]
    pub properties: fiftyoneDegreesCollectionHeader,
    #[doc = "< Size and location of the"]
    #[doc = "values collection"]
    pub values: fiftyoneDegreesCollectionHeader,
    #[doc = "< Size and location of"]
    #[doc = "the profiles collection"]
    pub profiles: fiftyoneDegreesCollectionHeader,
    #[doc = "< Root nodes which"]
    #[doc = "point to the start of each"]
    #[doc = "graph used in detection"]
    pub rootNodes: fiftyoneDegreesCollectionHeader,
    #[doc = "< Size and location of the"]
    #[doc = "nodes collection"]
    pub nodes: fiftyoneDegreesCollectionHeader,
    #[doc = "< Size and"]
    #[doc = "location of the"]
    #[doc = "profile offsets"]
    #[doc = "collection"]
    pub profileOffsets: fiftyoneDegreesCollectionHeader,
}
#[test]
fn bindgen_test_layout_fiftyoneDegrees_hash_dataset_header_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyoneDegrees_hash_dataset_header_t>(),
        182usize,
        concat!(
            "Size of: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyoneDegrees_hash_dataset_header_t>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).versionMajor
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(versionMajor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).versionMinor
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(versionMinor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).versionBuild
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(versionBuild)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).versionRevision
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(versionRevision)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).tag as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).exportTag as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(exportTag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).copyrightOffset
                as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(copyrightOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).age as *const _
                as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(age)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).minUserAgentCount
                as *const _ as usize
        },
        54usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(minUserAgentCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).nameOffset as *const _
                as usize
        },
        58usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(nameOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).formatOffset
                as *const _ as usize
        },
        62usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(formatOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).published as *const _
                as usize
        },
        66usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(published)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).nextUpdate as *const _
                as usize
        },
        70usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(nextUpdate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).strings as *const _
                as usize
        },
        74usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(strings)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).components as *const _
                as usize
        },
        86usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(components)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).maps as *const _
                as usize
        },
        98usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(maps)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).properties as *const _
                as usize
        },
        110usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(properties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).values as *const _
                as usize
        },
        122usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(values)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).profiles as *const _
                as usize
        },
        134usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(profiles)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).rootNodes as *const _
                as usize
        },
        146usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(rootNodes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).nodes as *const _
                as usize
        },
        158usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(nodes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegrees_hash_dataset_header_t>())).profileOffsets
                as *const _ as usize
        },
        170usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegrees_hash_dataset_header_t),
            "::",
            stringify!(profileOffsets)
        )
    );
}
pub type fiftyoneDegreesDataSetHashHeader = fiftyoneDegrees_hash_dataset_header_t;
#[doc = " Hash specific configuration structure. This extends the"]
#[doc = " #fiftyoneDegreesConfigDeviceDetection structure by adding collection"]
#[doc = " configurations and options for the allowable drift and difference."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_config_hash_t {
    #[doc = "< Base configuration"]
    pub b: fiftyoneDegreesConfigDeviceDetection,
    #[doc = "< Strings collection config"]
    pub strings: fiftyoneDegreesCollectionConfig,
    #[doc = "< Components collection"]
    #[doc = "config"]
    pub components: fiftyoneDegreesCollectionConfig,
    #[doc = "< Maps collection config"]
    pub maps: fiftyoneDegreesCollectionConfig,
    #[doc = "< Properties collection"]
    #[doc = "config"]
    pub properties: fiftyoneDegreesCollectionConfig,
    #[doc = "< Values collection config"]
    pub values: fiftyoneDegreesCollectionConfig,
    #[doc = "< Profiles collection config"]
    pub profiles: fiftyoneDegreesCollectionConfig,
    #[doc = "< Root nodes collection"]
    #[doc = "config"]
    pub rootNodes: fiftyoneDegreesCollectionConfig,
    #[doc = "< Nodes collection config"]
    pub nodes: fiftyoneDegreesCollectionConfig,
    #[doc = "< Profile offsets"]
    #[doc = "collection config"]
    pub profileOffsets: fiftyoneDegreesCollectionConfig,
    #[doc = "< The maximum difference to allow when matching"]
    #[doc = "hashes. If the difference is exceeded, the result is"]
    #[doc = "considered invalid and values will not be returned. By"]
    #[doc = "default this is 0."]
    pub difference: i32,
    #[doc = "< The maximum drift to allow when matching hashes. If the"]
    #[doc = "drift is exceeded, the result is considered invalid and"]
    #[doc = "values will not be returned. By default this is 0."]
    pub drift: i32,
    #[doc = "< True if the performance optimized graph"]
    #[doc = "should be used for processing."]
    pub usePerformanceGraph: bool,
    #[doc = "< True if the predictive optimized graph should"]
    #[doc = "be used for processing."]
    pub usePredictiveGraph: bool,
    #[doc = "< True if the route through each graph should be traced"]
    #[doc = "during processing. The trace can then be printed to debug"]
    #[doc = "the matching after the fact. Note that this option is only"]
    #[doc = "considered when compiled in debug mode."]
    pub traceRoute: bool,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_config_hash_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_config_hash_t>(),
        168usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_config_hash_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_config_hash_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_config_hash_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_hash_t>())).b as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_hash_t),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_hash_t>())).strings as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_hash_t),
            "::",
            stringify!(strings)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_hash_t>())).components as *const _
                as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_hash_t),
            "::",
            stringify!(components)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_hash_t>())).maps as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_hash_t),
            "::",
            stringify!(maps)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_hash_t>())).properties as *const _
                as usize
        },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_hash_t),
            "::",
            stringify!(properties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_hash_t>())).values as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_hash_t),
            "::",
            stringify!(values)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_hash_t>())).profiles as *const _ as usize
        },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_hash_t),
            "::",
            stringify!(profiles)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_hash_t>())).rootNodes as *const _
                as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_hash_t),
            "::",
            stringify!(rootNodes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_hash_t>())).nodes as *const _ as usize
        },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_hash_t),
            "::",
            stringify!(nodes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_hash_t>())).profileOffsets as *const _
                as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_hash_t),
            "::",
            stringify!(profileOffsets)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_hash_t>())).difference as *const _
                as usize
        },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_hash_t),
            "::",
            stringify!(difference)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_hash_t>())).drift as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_hash_t),
            "::",
            stringify!(drift)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_hash_t>())).usePerformanceGraph
                as *const _ as usize
        },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_hash_t),
            "::",
            stringify!(usePerformanceGraph)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_hash_t>())).usePredictiveGraph
                as *const _ as usize
        },
        165usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_hash_t),
            "::",
            stringify!(usePredictiveGraph)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_config_hash_t>())).traceRoute as *const _
                as usize
        },
        166usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_config_hash_t),
            "::",
            stringify!(traceRoute)
        )
    );
}
#[doc = " Hash specific configuration structure. This extends the"]
#[doc = " #fiftyoneDegreesConfigDeviceDetection structure by adding collection"]
#[doc = " configurations and options for the allowable drift and difference."]
pub type fiftyoneDegreesConfigHash = fiftyone_degrees_config_hash_t;
#[doc = " Data structure containing the root nodes for the combination of an evidence"]
#[doc = " item and a component."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_hash_rootnodes_t {
    #[doc = "< Offset in the nodes collection of the"]
    #[doc = "root node for the performance graph."]
    pub performanceNodeOffset: u32,
    #[doc = "< Offset in the nodes collection of the"]
    #[doc = "root node for the predictive graph."]
    pub predictiveNodeOffset: u32,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_hash_rootnodes_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_hash_rootnodes_t>(),
        8usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_hash_rootnodes_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_hash_rootnodes_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_hash_rootnodes_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_hash_rootnodes_t>())).performanceNodeOffset
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_hash_rootnodes_t),
            "::",
            stringify!(performanceNodeOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_hash_rootnodes_t>())).predictiveNodeOffset
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_hash_rootnodes_t),
            "::",
            stringify!(predictiveNodeOffset)
        )
    );
}
#[doc = " Data structure containing the root nodes for the combination of an evidence"]
#[doc = " item and a component."]
pub type fiftyoneDegreesHashRootNodes = fiftyone_degrees_hash_rootnodes_t;
#[doc = " Data set structure containing all the components used for detections."]
#[doc = " This should predominantly be used through a #fiftyoneDegreesResourceManager"]
#[doc = " pointer to maintain a safe reference. If access the data set is needed then"]
#[doc = " a safe reference can be fetched and released with the"]
#[doc = " #fiftyoneDegreesDataSetHashGet and #fiftyoneDegreesDataSetHashRelease"]
#[doc = " methods. This extends the #fiftyoneDegreesDataSetDeviceDetection"]
#[doc = " structure to add Hash specific collections an create a complete data set."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct fiftyone_degrees_dataset_hash_t {
    #[doc = "< Base data set"]
    pub b: fiftyoneDegreesDataSetDeviceDetection,
    #[doc = "< Dataset header"]
    pub header: fiftyoneDegreesDataSetHashHeader,
    #[doc = "< Copy of the configuration"]
    pub config: fiftyoneDegreesConfigHash,
    #[doc = "< Collection of all strings"]
    pub strings: *mut fiftyoneDegreesCollection,
    #[doc = "< Collection of all components"]
    pub components: *mut fiftyoneDegreesCollection,
    #[doc = "< List of component items from the"]
    #[doc = "components collection"]
    pub componentsList: fiftyoneDegreesList,
    #[doc = "< Array of flags indicating if there are"]
    #[doc = "any properties available for the component with"]
    #[doc = "the matching index in componentsList"]
    pub componentsAvailable: *mut bool,
    #[doc = "< Collection data file maps"]
    pub maps: *mut fiftyoneDegreesCollection,
    #[doc = "< Collection of all properties"]
    pub properties: *mut fiftyoneDegreesCollection,
    #[doc = "< Collection of all values"]
    pub values: *mut fiftyoneDegreesCollection,
    #[doc = "< Collection of all profiles"]
    pub profiles: *mut fiftyoneDegreesCollection,
    #[doc = "< Collection of all root nodes"]
    pub rootNodes: *mut fiftyoneDegreesCollection,
    #[doc = "< Collection of all hash nodes"]
    pub nodes: *mut fiftyoneDegreesCollection,
    #[doc = "< Collection of all offsets"]
    #[doc = "to profiles in the profiles"]
    #[doc = "collection"]
    pub profileOffsets: *mut fiftyoneDegreesCollection,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_dataset_hash_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_dataset_hash_t>(),
        8744usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_dataset_hash_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_dataset_hash_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_dataset_hash_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_hash_t>())).b as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_hash_t),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_hash_t>())).header as *const _ as usize
        },
        8296usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_hash_t),
            "::",
            stringify!(header)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_hash_t>())).config as *const _ as usize
        },
        8480usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_hash_t),
            "::",
            stringify!(config)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_hash_t>())).strings as *const _ as usize
        },
        8648usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_hash_t),
            "::",
            stringify!(strings)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_hash_t>())).components as *const _
                as usize
        },
        8656usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_hash_t),
            "::",
            stringify!(components)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_hash_t>())).componentsList as *const _
                as usize
        },
        8664usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_hash_t),
            "::",
            stringify!(componentsList)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_hash_t>())).componentsAvailable
                as *const _ as usize
        },
        8680usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_hash_t),
            "::",
            stringify!(componentsAvailable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_hash_t>())).maps as *const _ as usize
        },
        8688usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_hash_t),
            "::",
            stringify!(maps)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_hash_t>())).properties as *const _
                as usize
        },
        8696usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_hash_t),
            "::",
            stringify!(properties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_hash_t>())).values as *const _ as usize
        },
        8704usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_hash_t),
            "::",
            stringify!(values)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_hash_t>())).profiles as *const _
                as usize
        },
        8712usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_hash_t),
            "::",
            stringify!(profiles)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_hash_t>())).rootNodes as *const _
                as usize
        },
        8720usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_hash_t),
            "::",
            stringify!(rootNodes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_hash_t>())).nodes as *const _ as usize
        },
        8728usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_hash_t),
            "::",
            stringify!(nodes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_dataset_hash_t>())).profileOffsets as *const _
                as usize
        },
        8736usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_dataset_hash_t),
            "::",
            stringify!(profileOffsets)
        )
    );
}
#[doc = " Data set structure containing all the components used for detections."]
#[doc = " This should predominantly be used through a #fiftyoneDegreesResourceManager"]
#[doc = " pointer to maintain a safe reference. If access the data set is needed then"]
#[doc = " a safe reference can be fetched and released with the"]
#[doc = " #fiftyoneDegreesDataSetHashGet and #fiftyoneDegreesDataSetHashRelease"]
#[doc = " methods. This extends the #fiftyoneDegreesDataSetDeviceDetection"]
#[doc = " structure to add Hash specific collections an create a complete data set."]
pub type fiftyoneDegreesDataSetHash = fiftyone_degrees_dataset_hash_t;
#[doc = " @cond FORWARD_DECLARATIONS"]
pub type fiftyoneDegreesResultHash = fiftyone_degrees_result_hash_t;
#[doc = " Singular User-Agent result returned by a Hash process method. This"]
#[doc = " extends the #fiftyoneDegreesResultUserAgent structure by adding some Hash"]
#[doc = " specific metrics."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_result_hash_t {
    #[doc = "< Base User-Agent result"]
    pub b: fiftyoneDegreesResultUserAgent,
    #[doc = "< Array of profile offsets where the index is"]
    #[doc = "the component index"]
    pub profileOffsets: *mut u32,
    #[doc = "< Array of boolean flags indicating whether"]
    #[doc = "the result profile offset at the same index is"]
    #[doc = "one which has been overridden"]
    pub profileIsOverriden: *mut bool,
    #[doc = "< The method used to provide"]
    #[doc = "the match result"]
    pub method: fiftyoneDegreesHashMatchMethod,
    #[doc = "< Number of iterations required to get the device"]
    #[doc = "offset"]
    pub iterations: i32,
    #[doc = "< The total difference in hash code values between"]
    #[doc = "the matched substring and the actual substring"]
    pub difference: i32,
    #[doc = "< The maximum drift for a matched substring from the"]
    #[doc = "character position where it was expected to be found"]
    pub drift: i32,
    #[doc = "< The number of hashes matched in the User-Agent"]
    pub matchedNodes: i32,
    #[doc = "< The graph trace constructed"]
    #[doc = "during processing if the option was"]
    #[doc = "enabled (and the executable was"]
    #[doc = "compiled in debug mode). This can be"]
    #[doc = "printed using the"]
    #[doc = "fiftyoneDegreesGraphTraceGet method"]
    pub trace: *mut fiftyoneDegreesGraphTraceNode,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_result_hash_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_result_hash_t>(),
        88usize,
        concat!("Size of: ", stringify!(fiftyone_degrees_result_hash_t))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_result_hash_t>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyone_degrees_result_hash_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_result_hash_t>())).b as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_result_hash_t),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_result_hash_t>())).profileOffsets as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_result_hash_t),
            "::",
            stringify!(profileOffsets)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_result_hash_t>())).profileIsOverriden
                as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_result_hash_t),
            "::",
            stringify!(profileIsOverriden)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_result_hash_t>())).method as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_result_hash_t),
            "::",
            stringify!(method)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_result_hash_t>())).iterations as *const _
                as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_result_hash_t),
            "::",
            stringify!(iterations)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_result_hash_t>())).difference as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_result_hash_t),
            "::",
            stringify!(difference)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_result_hash_t>())).drift as *const _ as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_result_hash_t),
            "::",
            stringify!(drift)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_result_hash_t>())).matchedNodes as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_result_hash_t),
            "::",
            stringify!(matchedNodes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_result_hash_t>())).trace as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_result_hash_t),
            "::",
            stringify!(trace)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyone_degrees_array_fiftyoneDegreesResultHash_t {
    pub count: u32,
    pub capacity: u32,
    pub items: *mut fiftyoneDegreesResultHash,
    pub b: fiftyoneDegreesResultsDeviceDetection,
    pub propertyItem: fiftyoneDegreesCollectionItem,
    pub values: fiftyoneDegreesList,
    pub pseudoEvidence: *mut fiftyoneDegreesEvidenceKeyValuePairArray,
}
#[test]
fn bindgen_test_layout_fiftyone_degrees_array_fiftyoneDegreesResultHash_t() {
    assert_eq!(
        ::std::mem::size_of::<fiftyone_degrees_array_fiftyoneDegreesResultHash_t>(),
        88usize,
        concat!(
            "Size of: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesResultHash_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyone_degrees_array_fiftyoneDegreesResultHash_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesResultHash_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesResultHash_t>())).count
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesResultHash_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesResultHash_t>())).capacity
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesResultHash_t),
            "::",
            stringify!(capacity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesResultHash_t>())).items
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesResultHash_t),
            "::",
            stringify!(items)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesResultHash_t>())).b
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesResultHash_t),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesResultHash_t>()))
                .propertyItem as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesResultHash_t),
            "::",
            stringify!(propertyItem)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesResultHash_t>())).values
                as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesResultHash_t),
            "::",
            stringify!(values)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyone_degrees_array_fiftyoneDegreesResultHash_t>()))
                .pseudoEvidence as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyone_degrees_array_fiftyoneDegreesResultHash_t),
            "::",
            stringify!(pseudoEvidence)
        )
    );
}
pub type fiftyoneDegreesResultHashArray = fiftyone_degrees_array_fiftyoneDegreesResultHash_t;
#[doc = " Array of Hash results used to easily access and track the size of the"]
#[doc = " array."]
pub type fiftyoneDegreesResultsHash = fiftyoneDegreesResultHashArray;
extern "C" {
    pub static mut fiftyoneDegreesHashInMemoryConfig: fiftyoneDegreesConfigHash;
}
extern "C" {
    pub static mut fiftyoneDegreesHashHighPerformanceConfig: fiftyoneDegreesConfigHash;
}
extern "C" {
    pub static mut fiftyoneDegreesHashLowMemoryConfig: fiftyoneDegreesConfigHash;
}
extern "C" {
    pub static mut fiftyoneDegreesHashBalancedConfig: fiftyoneDegreesConfigHash;
}
extern "C" {
    pub static mut fiftyoneDegreesHashBalancedTempConfig: fiftyoneDegreesConfigHash;
}
extern "C" {
    pub static mut fiftyoneDegreesHashDefaultConfig: fiftyoneDegreesConfigHash;
}
extern "C" {
    pub static mut fiftyoneDegreesHashSingleLoadedConfig: fiftyoneDegreesConfigHash;
}
extern "C" {
    #[doc = " Gets the total size in bytes which will be allocated when intialising a"]
    #[doc = " Hash resource and associated manager with the same parameters. If any of"]
    #[doc = " the configuration options prevent the memory from being constant (i.e. more"]
    #[doc = " memory may be allocated at process time) then zero is returned."]
    #[doc = " @param config configuration for the operation of the data set, or NULL if"]
    #[doc = " default detection configuration is required"]
    #[doc = " @param properties the properties that will be consumed from the data set, or"]
    #[doc = " NULL if all available properties in the Hash data file should be available"]
    #[doc = " for consumption"]
    #[doc = " @param fileName the full path to a file with read permission that contains"]
    #[doc = " the Hash data set"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the total number of bytes needed to initialise a Hash resource"]
    #[doc = " and associated manager with the configuration provided or zero"]
    pub fn fiftyoneDegreesHashSizeManagerFromFile(
        config: *mut fiftyoneDegreesConfigHash,
        properties: *mut fiftyoneDegreesPropertiesRequired,
        fileName: *const ::std::os::raw::c_char,
        exception: *mut fiftyoneDegreesException,
    ) -> size_t;
}
extern "C" {
    #[doc = " Initialises the resource manager with a Hash data set resource populated"]
    #[doc = " from the Hash data file referred to by fileName. Configures the data set"]
    #[doc = " to operate using the configuration set in detection, collection and"]
    #[doc = " properties."]
    #[doc = " @param manager the resource manager to manager the share data set resource"]
    #[doc = " @param config configuration for the operation of the data set, or NULL if"]
    #[doc = " default detection configuration is required"]
    #[doc = " @param properties the properties that will be consumed from the data set, or"]
    #[doc = " NULL if all available properties in the Hash data file should be available"]
    #[doc = " for consumption"]
    #[doc = " @param fileName the full path to a file with read permission that contains"]
    #[doc = " the Hash data set"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the status associated with the data set resource assign to the"]
    #[doc = " resource manager. Any value other than #FIFTYONE_DEGREES_STATUS_SUCCESS"]
    #[doc = " means the data set was not created and the resource manager can not be used."]
    pub fn fiftyoneDegreesHashInitManagerFromFile(
        manager: *mut fiftyoneDegreesResourceManager,
        config: *mut fiftyoneDegreesConfigHash,
        properties: *mut fiftyoneDegreesPropertiesRequired,
        fileName: *const ::std::os::raw::c_char,
        exception: *mut fiftyoneDegreesException,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Gets the total size in bytes which will be allocated when intialising a"]
    #[doc = " Hash resource and associated manager with the same parameters. If any of"]
    #[doc = " the configuration options prevent the memory from being constant (i.e. more"]
    #[doc = " memory may be allocated at process time) then zero is returned."]
    #[doc = " @param config configuration for the operation of the data set, or NULL if"]
    #[doc = " default detection configuration is required"]
    #[doc = " @param properties the properties that will be consumed from the data set, or"]
    #[doc = " NULL if all available properties in the Hash data file should be available"]
    #[doc = " for consumption"]
    #[doc = " @param memory pointer to continuous memory containing the Hash data set"]
    #[doc = " @param size the number of bytes that make up the Hash data set"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the total number of bytes needed to initialise a Hash resource"]
    #[doc = " and associated manager with the configuration provided or zero"]
    pub fn fiftyoneDegreesHashSizeManagerFromMemory(
        config: *mut fiftyoneDegreesConfigHash,
        properties: *mut fiftyoneDegreesPropertiesRequired,
        memory: *mut ::std::os::raw::c_void,
        size: ::std::os::raw::c_long,
        exception: *mut fiftyoneDegreesException,
    ) -> size_t;
}
extern "C" {
    #[doc = " Initialises the resource manager with a Hash data set resource populated"]
    #[doc = " from the Hash data set pointed to by the memory parameter. Configures the"]
    #[doc = " data set to operate using the configuration set in detection and properties."]
    #[doc = " @param manager the resource manager to manager the share data set resource"]
    #[doc = " @param config configuration for the operation of the data set, or NULL if"]
    #[doc = " default detection configuration is required"]
    #[doc = " @param properties the properties that will be consumed from the data set, or"]
    #[doc = " NULL if all available properties in the Hash data file should be available"]
    #[doc = " for consumption"]
    #[doc = " @param memory pointer to continuous memory containing the Hash data set"]
    #[doc = " @param size the number of bytes that make up the Hash data set"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the status associated with the data set resource assign to the"]
    #[doc = " resource manager. Any value other than #FIFTYONE_DEGREES_STATUS_SUCCESS"]
    #[doc = " means the data set was not created and the resource manager can not be used."]
    pub fn fiftyoneDegreesHashInitManagerFromMemory(
        manager: *mut fiftyoneDegreesResourceManager,
        config: *mut fiftyoneDegreesConfigHash,
        properties: *mut fiftyoneDegreesPropertiesRequired,
        memory: *mut ::std::os::raw::c_void,
        size: ::std::os::raw::c_long,
        exception: *mut fiftyoneDegreesException,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Processes the evidence value pairs in the evidence collection and"]
    #[doc = " populates the result in the results structure."]
    #[doc = " The 'query' and 'cookie' evidence key prefixes are used to get values which"]
    #[doc = " dynamically override values returned from device detection. 'query' prefixes"]
    #[doc = " are also used in preference to 'header' for HTTP header values that are"]
    #[doc = " provided by the application rather than the calling device."]
    #[doc = " @param results preallocated results structure to populate containing a"]
    #[doc = "                pointer to an initialised resource manager"]
    #[doc = " @param evidence to process containing parsed or unparsed values"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    pub fn fiftyoneDegreesResultsHashFromEvidence(
        results: *mut fiftyoneDegreesResultsHash,
        evidence: *mut fiftyoneDegreesEvidenceKeyValuePairArray,
        exception: *mut fiftyoneDegreesException,
    );
}
extern "C" {
    #[doc = " Process a single User-Agent and populate the device offsets in the results"]
    #[doc = " structure."]
    #[doc = " @param results preallocated results structure to populate"]
    #[doc = " @param userAgent string to process"]
    #[doc = " @param userAgentLength of the User-Agent string"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    pub fn fiftyoneDegreesResultsHashFromUserAgent(
        results: *mut fiftyoneDegreesResultsHash,
        userAgent: *const ::std::os::raw::c_char,
        userAgentLength: size_t,
        exception: *mut fiftyoneDegreesException,
    );
}
extern "C" {
    #[doc = " Process a single Device Id and populate the device offsets in the results"]
    #[doc = " structure."]
    #[doc = " @param results preallocated results structure to populate"]
    #[doc = " @param deviceId string to process"]
    #[doc = " @param deviceIdLength of the deviceId string"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    pub fn fiftyoneDegreesResultsHashFromDeviceId(
        results: *mut fiftyoneDegreesResultsHash,
        deviceId: *const ::std::os::raw::c_char,
        deviceIdLength: size_t,
        exception: *mut fiftyoneDegreesException,
    );
}
extern "C" {
    #[doc = " Allocates a results structure containing a reference to the Hash data set"]
    #[doc = " managed by the resource manager provided. The referenced data set will be"]
    #[doc = " kept active until the results structure is freed. The number of results"]
    #[doc = " allocated might be bigger to hold additional values returned from internal"]
    #[doc = " process. e.g. Client Hints support."]
    #[doc = " @param manager pointer to the resource manager which manages a Hash data"]
    #[doc = " set"]
    #[doc = " @param userAgentCapacity number of User-Agents to be able to handle"]
    #[doc = " @param overridesCapacity number of properties that can be overridden,"]
    #[doc = " 0 to disable overrides"]
    #[doc = " @return newly created results structure"]
    pub fn fiftyoneDegreesResultsHashCreate(
        manager: *mut fiftyoneDegreesResourceManager,
        userAgentCapacity: u32,
        overridesCapacity: u32,
    ) -> *mut fiftyoneDegreesResultsHash;
}
extern "C" {
    #[doc = " Frees the results structure created by the"]
    #[doc = " #fiftyoneDegreesResultsHashCreate method. When freeing, the reference to"]
    #[doc = " the Hash data set resource is released."]
    #[doc = " @param results pointer to the results structure to release"]
    pub fn fiftyoneDegreesResultsHashFree(results: *mut fiftyoneDegreesResultsHash);
}
extern "C" {
    #[doc = " Gets whether or not the results provided contain valid values for the"]
    #[doc = " property index provided."]
    #[doc = " @param results pointer to the results to check"]
    #[doc = " @param requiredPropertyIndex index in the required properties of the"]
    #[doc = " property to check for values of"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return true if there are valid values in the results for the property index"]
    #[doc = " provided"]
    pub fn fiftyoneDegreesResultsHashGetHasValues(
        results: *mut fiftyoneDegreesResultsHash,
        requiredPropertyIndex: ::std::os::raw::c_int,
        exception: *mut fiftyoneDegreesException,
    ) -> bool;
}
extern "C" {
    #[doc = " Gets the reason why a results does not contain valid values for a given"]
    #[doc = " property."]
    #[doc = " @param results pointer to the results to check"]
    #[doc = " @param requiredPropertyIndex index in the required properties of the"]
    #[doc = " property to check for values of"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return enum indicating why a valid value cannot be returned by the results"]
    pub fn fiftyoneDegreesResultsHashGetNoValueReason(
        results: *mut fiftyoneDegreesResultsHash,
        requiredPropertyIndex: ::std::os::raw::c_int,
        exception: *mut fiftyoneDegreesException,
    ) -> fiftyoneDegreesResultsNoValueReason;
}
extern "C" {
    #[doc = " Gets a fuller description of the reason why a value is missing."]
    #[doc = " @param reason enum of the reason for the missing value"]
    #[doc = " @return full description for the reason"]
    pub fn fiftyoneDegreesResultsHashGetNoValueReasonMessage(
        reason: fiftyoneDegreesResultsNoValueReason,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Populates the list of values in the results instance with value structure"]
    #[doc = " instances associated with the required property index. When the results"]
    #[doc = " are released then the value items will be released. There is no need for"]
    #[doc = " the caller to release the collection item returned. The"]
    #[doc = " fiftyoneDegreesResultsHashGetValueString method should be used to get"]
    #[doc = " the string representation of the value."]
    #[doc = " @param results pointer to the results structure to release"]
    #[doc = " @param requiredPropertyIndex"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return a pointer to the first value item"]
    pub fn fiftyoneDegreesResultsHashGetValues(
        results: *mut fiftyoneDegreesResultsHash,
        requiredPropertyIndex: ::std::os::raw::c_int,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut fiftyoneDegreesCollectionItem;
}
extern "C" {
    #[doc = " Sets the buffer the values associated in the results for the property name."]
    #[doc = " @param results pointer to the results structure to release"]
    #[doc = " @param propertyName name of the property to be used with the values"]
    #[doc = " @param buffer character buffer allocated by the caller"]
    #[doc = " @param bufferLength of the character buffer"]
    #[doc = " @param separator string to be used to separate multiple values if available"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the number of characters available for values. May be larger than"]
    #[doc = " bufferLength if the buffer is not long enough to return the result."]
    pub fn fiftyoneDegreesResultsHashGetValuesString(
        results: *mut fiftyoneDegreesResultsHash,
        propertyName: *const ::std::os::raw::c_char,
        buffer: *mut ::std::os::raw::c_char,
        bufferLength: size_t,
        separator: *const ::std::os::raw::c_char,
        exception: *mut fiftyoneDegreesException,
    ) -> size_t;
}
extern "C" {
    #[doc = " Sets the buffer the values associated in the results for the property name."]
    #[doc = " @param results pointer to the results structure to release"]
    #[doc = " @param requiredPropertyIndex required property index of for the values"]
    #[doc = " @param buffer character buffer allocated by the caller"]
    #[doc = " @param bufferLength of the character buffer"]
    #[doc = " @param separator string to be used to separate multiple values if available"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the number of characters available for values. May be larger than"]
    #[doc = " bufferLength if the buffer is not long enough to return the result."]
    pub fn fiftyoneDegreesResultsHashGetValuesStringByRequiredPropertyIndex(
        results: *mut fiftyoneDegreesResultsHash,
        requiredPropertyIndex: ::std::os::raw::c_int,
        buffer: *mut ::std::os::raw::c_char,
        bufferLength: size_t,
        separator: *const ::std::os::raw::c_char,
        exception: *mut fiftyoneDegreesException,
    ) -> size_t;
}
extern "C" {
    #[doc = " Reload the data set being used by the resource manager using the data file"]
    #[doc = " location which was used when the manager was created. When initialising the"]
    #[doc = " data, the configuration that manager was first created with is used."]
    #[doc = ""]
    #[doc = " If the new data file is successfully initialised, the current data set is"]
    #[doc = " replaced The old data will remain in memory until the last"]
    #[doc = " #fiftyoneDegreesResultsHash which contain a reference to it are released."]
    #[doc = ""]
    #[doc = " This method is defined by the #FIFTYONE_DEGREES_DATASET_RELOAD macro."]
    #[doc = " @param manager pointer to the resource manager to reload the data set for"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the status associated with the data set reload. Any value other than"]
    #[doc = " #FIFTYONE_DEGREES_STATUS_SUCCESS means the data set was not reloaded"]
    #[doc = " correctly"]
    pub fn fiftyoneDegreesHashReloadManagerFromOriginalFile(
        manager: *mut fiftyoneDegreesResourceManager,
        exception: *mut fiftyoneDegreesException,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Reload the data set being used by the resource manager using the data file"]
    #[doc = " location specified. When initialising the data, the configuration that"]
    #[doc = " manager was first created with is used."]
    #[doc = ""]
    #[doc = " If the new data file is successfully initialised, the current data set is"]
    #[doc = " replaced The old data will remain in memory until the last"]
    #[doc = " #fiftyoneDegreesResultsHash which contain a reference to it are released."]
    #[doc = ""]
    #[doc = " This method is defined by the #FIFTYONE_DEGREES_DATASET_RELOAD macro."]
    #[doc = " @param manager pointer to the resource manager to reload the data set for"]
    #[doc = " @param fileName path to the new data file"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the status associated with the data set reload. Any value other than"]
    #[doc = " #FIFTYONE_DEGREES_STATUS_SUCCESS means the data set was not reloaded"]
    #[doc = " correctly"]
    pub fn fiftyoneDegreesHashReloadManagerFromFile(
        manager: *mut fiftyoneDegreesResourceManager,
        fileName: *const ::std::os::raw::c_char,
        exception: *mut fiftyoneDegreesException,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Reload the data set being used by the resource manager using a data file"]
    #[doc = " loaded into contiguous memory. When initialising the data, the configuration"]
    #[doc = " that manager was first created with is used."]
    #[doc = ""]
    #[doc = " If the data passed in is successfully initialised, the current data set is"]
    #[doc = " replaced The old data will remain in memory until the last"]
    #[doc = " #fiftyoneDegreesResultsHash which contain a reference to it are released."]
    #[doc = ""]
    #[doc = " This method is defined by the #FIFTYONE_DEGREES_DATASET_RELOAD macro."]
    #[doc = " @param manager pointer to the resource manager to reload the data set for"]
    #[doc = " @param source pointer to the memory location where the new data file is"]
    #[doc = "               stored"]
    #[doc = " @param length of the data in memory"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h."]
    #[doc = " @return the status associated with the data set reload. Any value other than"]
    #[doc = " #FIFTYONE_DEGREES_STATUS_SUCCESS means the data set was not reloaded"]
    #[doc = " correctly"]
    pub fn fiftyoneDegreesHashReloadManagerFromMemory(
        manager: *mut fiftyoneDegreesResourceManager,
        source: *mut ::std::os::raw::c_void,
        length: ::std::os::raw::c_long,
        exception: *mut fiftyoneDegreesException,
    ) -> fiftyoneDegreesStatusCode;
}
extern "C" {
    #[doc = " Gets a safe reference to the Hash data set from the resource manager."]
    #[doc = " Fetching through this method ensures that the data set it not freed or moved"]
    #[doc = " during the time it is in use."]
    #[doc = " The data set returned by this method should be released with the"]
    #[doc = " #fiftyoneDegreesDataSetHashRelease method."]
    #[doc = " @param manager the resource manager containing a hash data set initialised"]
    #[doc = " by one of the Hash data set init methods"]
    #[doc = " @return a fixed pointer to the data set in manager"]
    pub fn fiftyoneDegreesDataSetHashGet(
        manager: *mut fiftyoneDegreesResourceManager,
    ) -> *mut fiftyoneDegreesDataSetHash;
}
extern "C" {
    #[doc = " Release the reference to a data set returned by the"]
    #[doc = " #fiftyoneDegreesDataSetHashGet method. Doing so tell the resource manager"]
    #[doc = " linked to the data set that it is no longer being used."]
    #[doc = " @param dataSet pointer to the data set to release"]
    pub fn fiftyoneDegreesDataSetHashRelease(dataSet: *mut fiftyoneDegreesDataSetHash);
}
extern "C" {
    #[doc = " Iterates over the profiles in the data set calling the callback method for"]
    #[doc = " any profiles that contain the property and value provided."]
    #[doc = " @param manager the resource manager containing a hash data set initialised"]
    #[doc = " by one of the Hash data set init methods"]
    #[doc = " @param propertyName name of the property which the value relates to"]
    #[doc = " @param valueName name of the property value which the profiles must contain"]
    #[doc = " @param state pointer passed to the callback method"]
    #[doc = " @param callback method called when a matching profile is found"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    #[doc = " @return the number of matching profiles iterated over"]
    pub fn fiftyoneDegreesHashIterateProfilesForPropertyAndValue(
        manager: *mut fiftyoneDegreesResourceManager,
        propertyName: *const ::std::os::raw::c_char,
        valueName: *const ::std::os::raw::c_char,
        state: *mut ::std::os::raw::c_void,
        callback: fiftyoneDegreesProfileIterateMethod,
        exception: *mut fiftyoneDegreesException,
    ) -> u32;
}
extern "C" {
    #[doc = " Get the device id string from the single result provided. This contains"]
    #[doc = " profile ids for all components, concatenated with the separator character"]
    #[doc = " '-'."]
    #[doc = " @param dataSet pointer to the data set used to get the result"]
    #[doc = " @param result pointer to the result to get the device id of"]
    #[doc = " @param destination pointer to the memory to write the characters to"]
    #[doc = " @param size amount of memory allocated to destination"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    #[doc = " @return the destination pointer"]
    pub fn fiftyoneDegreesHashGetDeviceIdFromResult(
        dataSet: *mut fiftyoneDegreesDataSetHash,
        result: *mut fiftyoneDegreesResultHash,
        destination: *mut ::std::os::raw::c_char,
        size: size_t,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get the device id string from the results provided. This contains profile"]
    #[doc = " ids for all components, concatenated with the separator character '-'."]
    #[doc = " @param results pointer to the results to get the device id of"]
    #[doc = " @param destination pointer to the memory to write the characters to"]
    #[doc = " @param size amount of memory allocated to destination"]
    #[doc = " @param exception pointer to an exception data structure to be used if an"]
    #[doc = " exception occurs. See exceptions.h"]
    #[doc = " @return the destination pointer"]
    pub fn fiftyoneDegreesHashGetDeviceIdFromResults(
        results: *mut fiftyoneDegreesResultsHash,
        destination: *mut ::std::os::raw::c_char,
        size: size_t,
        exception: *mut fiftyoneDegreesException,
    ) -> *mut ::std::os::raw::c_char;
}
pub type DataSetHash = fiftyoneDegreesDataSetHash;
pub type ResultHash = fiftyoneDegreesResultHash;
pub type ResultsHash = fiftyoneDegreesResultsHash;
pub type ConfigHash = fiftyoneDegreesConfigHash;
pub type DataSetHashHeader = fiftyoneDegreesDataSetHashHeader;
pub type ResultHashArray = fiftyoneDegreesResultHashArray;
pub type HashRootNodes = fiftyoneDegreesHashRootNodes;
pub type GraphNode = fiftyoneDegreesGraphNode;
pub type GraphNodeHash = fiftyoneDegreesGraphNodeHash;
pub type GraphTraceNode = fiftyoneDegreesGraphTraceNode;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyoneDegreesManagerInit {
    pub status: fiftyoneDegreesStatusCode,
    pub manager: fiftyoneDegreesResourceManager,
    pub dataset: *mut fiftyoneDegreesDataSetBase,
}
#[test]
fn bindgen_test_layout_fiftyoneDegreesManagerInit() {
    assert_eq!(
        ::std::mem::size_of::<fiftyoneDegreesManagerInit>(),
        24usize,
        concat!("Size of: ", stringify!(fiftyoneDegreesManagerInit))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyoneDegreesManagerInit>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyoneDegreesManagerInit))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegreesManagerInit>())).status as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegreesManagerInit),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegreesManagerInit>())).manager as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegreesManagerInit),
            "::",
            stringify!(manager)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegreesManagerInit>())).dataset as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegreesManagerInit),
            "::",
            stringify!(dataset)
        )
    );
}
extern "C" {
    pub fn fiftyoneDegreesManagerInitFile(
        properties: *const ::std::os::raw::c_char,
        fileName: *const ::std::os::raw::c_char,
    ) -> fiftyoneDegreesManagerInit;
}
extern "C" {
    pub fn initToDataset(
        init: *const fiftyoneDegreesManagerInit,
    ) -> *mut fiftyoneDegreesDataSetBase;
}
extern "C" {
    pub fn mapPropertyToIndex(
        init: *const fiftyoneDegreesManagerInit,
        property: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fiftyoneDegreesManagerResults {
    pub results: *mut fiftyoneDegreesResultsHash,
}
#[test]
fn bindgen_test_layout_fiftyoneDegreesManagerResults() {
    assert_eq!(
        ::std::mem::size_of::<fiftyoneDegreesManagerResults>(),
        8usize,
        concat!("Size of: ", stringify!(fiftyoneDegreesManagerResults))
    );
    assert_eq!(
        ::std::mem::align_of::<fiftyoneDegreesManagerResults>(),
        8usize,
        concat!("Alignment of ", stringify!(fiftyoneDegreesManagerResults))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<fiftyoneDegreesManagerResults>())).results as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fiftyoneDegreesManagerResults),
            "::",
            stringify!(results)
        )
    );
}
extern "C" {
    pub fn freeResults(results: fiftyoneDegreesManagerResults);
}
extern "C" {
    pub fn freeInit(init: fiftyoneDegreesManagerInit);
}
extern "C" {
    pub fn initToResults(
        init: *const fiftyoneDegreesManagerInit,
        userAgent: *const ::std::os::raw::c_char,
    ) -> fiftyoneDegreesManagerResults;
}
extern "C" {
    pub fn getResultsValue(
        results: *const fiftyoneDegreesManagerResults,
        requiredPropertyIndex: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout___va_list_tag() {
    assert_eq!(
        ::std::mem::size_of::<__va_list_tag>(),
        24usize,
        concat!("Size of: ", stringify!(__va_list_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<__va_list_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(__va_list_tag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).gp_offset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(gp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).fp_offset as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(fp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).overflow_arg_area as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(overflow_arg_area)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).reg_save_area as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(reg_save_area)
        )
    );
}
