use std::fmt::{Display, Formatter, Result};
use std::path::Path;

#[derive(Debug, PartialEq, PartialOrd, Ord, Eq)]
pub enum ScanError<'a> {
	/// Something went wrong while trying to read the given file.
	File(&'a Path),
	/// Failed to determine the mimetype of the given file.
	Mime(&'a Path),
}

impl<'a> Display for ScanError<'a> {
	fn fmt(&self, f: &mut Formatter<'_>) -> Result {
		write!(
			f,
			"Couldn't {} file: {}",
			match self {
				Self::File(_) => "read",
				Self::Mime(_) => "determine mime type of",
			},
			match self {
				Self::File(f) | Self::Mime(f) => f.to_string_lossy(),
			}
		)
	}
}
