use std::path::Path;

use mime_guess::Mime;

use crate::inspectors::mime_extension_lookup;
use crate::string_type::String;

/// Information about a scanned file.
#[derive(Ord, PartialOrd, Eq, PartialEq)]
pub struct Findings<'a> {
	/// The location of the scanned file.
	pub file: &'a Path,
	/// Whether or not the file's extension is valid for its mimetype.
	pub valid: bool,
	/// The file's mimetype.
	pub mime: Mime,
}

impl<'a> Findings<'a> {
	pub fn recommended_extension(&self) -> Option<String> {
		mime_extension_lookup(self.mime.clone()).map(|extensions| extensions[0].clone())
	}
}
