fif
===
[![Version](https://img.shields.io/crates/v/fif.svg?logo=rust&style=flat-square)
](https://crates.io/crates/fif)
[![Minimum Supported Rust Version](https://img.shields.io/badge/msrv-1.43.0-orange?logo=rust&style=flat-square)
](https://crates.io/crates/fif)
[![License](https://img.shields.io/crates/l/fif.svg?style=flat-square)
](https://gitlab.com/Lynnesbian/fif/-/blob/master/LICENSE)
[![Drone build status](https://img.shields.io/drone/build/lynnesbian/fif?logo=drone&server=https%3A%2F%2Fdrone.bune.city&style=flat-square)
](https://drone.bune.city/lynnesbian/fif)
[![GitLab build status](https://img.shields.io/gitlab/pipeline/Lynnesbian/fif/master?logo=gitlab&style=flat-square)
](https://gitlab.com/Lynnesbian/fif/-/pipelines/latest)
[![Unsafe forbidden](https://img.shields.io/badge/unsafe-forbidden-success.svg?style=flat-square)
](https://github.com/rust-secure-code/safety-dance/)

A command-line tool for detecting and optionally correcting files with incorrect extensions.

fif recursively scans the given directory and outputs a shell script to fix the name of any files with incorrect
extensions. By default, fif will scan all non-hidden files in the given directory, and will ignore symlinks.

As fif prints a shell script to stdout rather than acting on the files directly, you may wish to redirect its output to
a file, e.g. `fif ~/Documents > output.sh`. You can also pipe the output directly into your shell, e.g.
`fif ~/Documents | bash`, although this is not recommended - you should look over fif's output and verify for yourself
that it's not doing anything that will give you a headache before running it.

## Installation
### Cargo
```bash
cargo install --locked fif
```

To update, simply re-run this command, or use a tool like
[cargo-update](https://github.com/nabijaczleweli/cargo-update).

#### Other backends
`fif` supports using [`infer`](https://crates.io/crates/infer) or [`xdg-mime`](https://crates.io/crates/xdg-mime) as its
backend for looking up file types. By default, xdg-mime will be used on
[*nix systems](https://en.wikipedia.org/wiki/Unix-like) (Linux, macOS, *BSD, etc.), and infer on all other systems.

`xdg-mime` should work on any *nix system with [libmagic/file(1)](https://www.darwinsys.com/file/) installed, although
I've only tested it on Linux and FreeBSD. `infer` should work on any system.

You can override the default backend for your system at compile time like so:

```bash
# xdg-mime
cargo install fif --features=xdg-mime-backend
# infer
cargo install fif --features=infer-backend
```

Of the supported backends, `xdg-mime` by far supports the most file types, as it uses the excellent [Shared MIME
Info](https://gitlab.freedesktop.org/xdg/shared-mime-info/) database, whereas `infer` uses its own baked-in database.
However, `infer` is also faster to load, if only by a few dozen milliseconds, and has no external dependencies.

#### Multithreading
It is also possible to disable multithreading by installing without default features:
```bash
cargo install fif --no-default-features
```

## Usage
See `fif --help` for more.

### The basics
The simplest way to use fif looks like this:

```bash
fif ~/Downloads
```

This command will scan all non-hidden files in your `~/Downloads` directory.

You can also manually specify a set of extensions to use:

```bash
fif -e jpeg,jpg,zip,docx ~/Documents
```

Or a set of extensions - for example, to scan files with image extensions (jpg, png, gif, bmp...):

```bash
fif -E images ~/Pictures
```

### Output
By default, fif will output a bash script (or PowerShell script on Windows) that can be used to fix all the files it
found with incorrect file extensions.

You might find it useful to output this script to a file (rather than to stdout):

```bash
fif -E images ~/Pictures > output.sh
```

You can also manually specify an output format to use:

```bash
fif -O powershell ~/Documents > output.ps1
```

### Logging
By default, fif will log any warnings and/or errors encountered during execution. This can be changed with the `-v`
flag:
```bash
# also log info
fif -v ~/Downloads
# ...and debug
fif -vv ~/Downloads
# ...and trace
fif -vvv ~/Downloads
```
The verbosity of the logging can be
modified by the `RUST_LOG` to one of: `trace`, `debug`, `info`, `warn`, `error`.

For example:

```bash
RUST_LOG=debug fif ~/Downloads
```

The five logging levels are used as follows:
| Level | Description | Example |
|-|-|-|
| error | Errors that cause fif to stop running | fif was unable to open the provided directory |
| warn | Warnings that don't cause fif to stop running | fif was unable to determine the mime type of a given file |
| info | Information pertaining to fif's status | The provided directory was scanned without issue, and no files are in need of renaming |
| debug | Debug information - usually not important to end users | The list of extensions fif will consider |
| trace | Trace info - usually not important to end users | "Found 15 items to check", "Scan successful", etc. |
