pub fn fibonacci(number: usize) -> usize {
    fn fib_memo(n: usize, memo: &mut [Option<usize>]) -> usize {
        memo[n].unwrap_or_else(|| {
            let result = {
                if n > 1 {
                    fib_memo(n - 1, memo) + fib_memo(n - 2, memo)
                } else {
                    1
                }
            };
            memo[n] = Some(result);
            result
        })
    }

    fib_memo(number, &mut vec![None; number + 1])
}

pub fn fibonacci_sequence(times: usize) -> Vec<usize> {
    let mut sequence = vec![];

    for i in 0..times {
        sequence.push(fibonacci(i))
    }

    sequence
}
