//! Autogenerated: 'src/ExtractionOCaml/unsaturated_solinas' --lang Rust --inline p521 64 9 '2^521 - 1' carry_mul carry_square carry add sub opp selectznz to_bytes from_bytes relax
//! curve description: p521
//! machine_wordsize = 64 (from "64")
//! requested operations: carry_mul, carry_square, carry, add, sub, opp, selectznz, to_bytes, from_bytes, relax
//! n = 9 (from "9")
//! s-c = 2^521 - [(1, 1)] (from "2^521 - 1")
//! tight_bounds_multiplier = 1 (from "")
//!
//! Computed values:
//!   carry_chain = [0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1]
//!   eval z = z[0] + (z[1] << 58) + (z[2] << 116) + (z[3] << 174) + (z[4] << 232) + (z[5] << 0x122) + (z[6] << 0x15c) + (z[7] << 0x196) + (z[8] << 0x1d0)
//!   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178) + (z[48] << 0x180) + (z[49] << 0x188) + (z[50] << 0x190) + (z[51] << 0x198) + (z[52] << 0x1a0) + (z[53] << 0x1a8) + (z[54] << 0x1b0) + (z[55] << 0x1b8) + (z[56] << 0x1c0) + (z[57] << 0x1c8) + (z[58] << 0x1d0) + (z[59] << 0x1d8) + (z[60] << 0x1e0) + (z[61] << 0x1e8) + (z[62] << 0x1f0) + (z[63] << 0x1f8) + (z[64] << 2^9) + (z[65] << 0x208)
//!   balance = [0x7fffffffffffffe, 0x7fffffffffffffe, 0x7fffffffffffffe, 0x7fffffffffffffe, 0x7fffffffffffffe, 0x7fffffffffffffe, 0x7fffffffffffffe, 0x7fffffffffffffe, 0x3fffffffffffffe]

#![allow(unused_parens)]
#[allow(non_camel_case_types)]

pub type fiat_p521_u1 = u8;
pub type fiat_p521_i1 = i8;
pub type fiat_p521_u2 = u8;
pub type fiat_p521_i2 = i8;

/* The type fiat_p521_loose_field_element is a field element with loose bounds. */
/* Bounds: [[0x0 ~> 0xc00000000000000], [0x0 ~> 0xc00000000000000], [0x0 ~> 0xc00000000000000], [0x0 ~> 0xc00000000000000], [0x0 ~> 0xc00000000000000], [0x0 ~> 0xc00000000000000], [0x0 ~> 0xc00000000000000], [0x0 ~> 0xc00000000000000], [0x0 ~> 0x600000000000000]] */
pub type fiat_p521_loose_field_element = [u64; 9];

/* The type fiat_p521_tight_field_element is a field element with tight bounds. */
/* Bounds: [[0x0 ~> 0x400000000000000], [0x0 ~> 0x400000000000000], [0x0 ~> 0x400000000000000], [0x0 ~> 0x400000000000000], [0x0 ~> 0x400000000000000], [0x0 ~> 0x400000000000000], [0x0 ~> 0x400000000000000], [0x0 ~> 0x400000000000000], [0x0 ~> 0x200000000000000]] */
pub type fiat_p521_tight_field_element = [u64; 9];


/// The function fiat_p521_addcarryx_u58 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^58
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^58⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0x3ffffffffffffff]
///   arg3: [0x0 ~> 0x3ffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0x3ffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p521_addcarryx_u58(out1: &mut u64, out2: &mut fiat_p521_u1, arg1: fiat_p521_u1, arg2: u64, arg3: u64) -> () {
  let x1: u64 = (((arg1 as u64) + arg2) + arg3);
  let x2: u64 = (x1 & 0x3ffffffffffffff);
  let x3: fiat_p521_u1 = ((x1 >> 58) as fiat_p521_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_p521_subborrowx_u58 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^58
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^58⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0x3ffffffffffffff]
///   arg3: [0x0 ~> 0x3ffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0x3ffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p521_subborrowx_u58(out1: &mut u64, out2: &mut fiat_p521_u1, arg1: fiat_p521_u1, arg2: u64, arg3: u64) -> () {
  let x1: i64 = ((((((arg2 as i128) - (arg1 as i128)) as i64) as i128) - (arg3 as i128)) as i64);
  let x2: fiat_p521_i1 = ((x1 >> 58) as fiat_p521_i1);
  let x3: u64 = (((x1 as i128) & (0x3ffffffffffffff as i128)) as u64);
  *out1 = x3;
  *out2 = (((0x0 as fiat_p521_i2) - (x2 as fiat_p521_i2)) as fiat_p521_u1);
}

/// The function fiat_p521_addcarryx_u57 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^57
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^57⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0x1ffffffffffffff]
///   arg3: [0x0 ~> 0x1ffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0x1ffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p521_addcarryx_u57(out1: &mut u64, out2: &mut fiat_p521_u1, arg1: fiat_p521_u1, arg2: u64, arg3: u64) -> () {
  let x1: u64 = (((arg1 as u64) + arg2) + arg3);
  let x2: u64 = (x1 & 0x1ffffffffffffff);
  let x3: fiat_p521_u1 = ((x1 >> 57) as fiat_p521_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_p521_subborrowx_u57 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^57
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^57⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0x1ffffffffffffff]
///   arg3: [0x0 ~> 0x1ffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0x1ffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p521_subborrowx_u57(out1: &mut u64, out2: &mut fiat_p521_u1, arg1: fiat_p521_u1, arg2: u64, arg3: u64) -> () {
  let x1: i64 = ((((((arg2 as i128) - (arg1 as i128)) as i64) as i128) - (arg3 as i128)) as i64);
  let x2: fiat_p521_i1 = ((x1 >> 57) as fiat_p521_i1);
  let x3: u64 = (((x1 as i128) & (0x1ffffffffffffff as i128)) as u64);
  *out1 = x3;
  *out2 = (((0x0 as fiat_p521_i2) - (x2 as fiat_p521_i2)) as fiat_p521_u1);
}

/// The function fiat_p521_cmovznz_u64 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub fn fiat_p521_cmovznz_u64(out1: &mut u64, arg1: fiat_p521_u1, arg2: u64, arg3: u64) -> () {
  let x1: fiat_p521_u1 = (!(!arg1));
  let x2: u64 = ((((((0x0 as fiat_p521_i2) - (x1 as fiat_p521_i2)) as fiat_p521_i1) as i128) & (0xffffffffffffffff as i128)) as u64);
  let x3: u64 = ((x2 & arg3) | ((!x2) & arg2));
  *out1 = x3;
}

/// The function fiat_p521_carry_mul multiplies two field elements and reduces the result.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 * eval arg2) mod m
///
#[inline]
pub fn fiat_p521_carry_mul(out1: &mut fiat_p521_tight_field_element, arg1: &fiat_p521_loose_field_element, arg2: &fiat_p521_loose_field_element) -> () {
  let x1: u128 = (((arg1[8]) as u128) * (((arg2[8]) * 0x2) as u128));
  let x2: u128 = (((arg1[8]) as u128) * (((arg2[7]) * 0x2) as u128));
  let x3: u128 = (((arg1[8]) as u128) * (((arg2[6]) * 0x2) as u128));
  let x4: u128 = (((arg1[8]) as u128) * (((arg2[5]) * 0x2) as u128));
  let x5: u128 = (((arg1[8]) as u128) * (((arg2[4]) * 0x2) as u128));
  let x6: u128 = (((arg1[8]) as u128) * (((arg2[3]) * 0x2) as u128));
  let x7: u128 = (((arg1[8]) as u128) * (((arg2[2]) * 0x2) as u128));
  let x8: u128 = (((arg1[8]) as u128) * (((arg2[1]) * 0x2) as u128));
  let x9: u128 = (((arg1[7]) as u128) * (((arg2[8]) * 0x2) as u128));
  let x10: u128 = (((arg1[7]) as u128) * (((arg2[7]) * 0x2) as u128));
  let x11: u128 = (((arg1[7]) as u128) * (((arg2[6]) * 0x2) as u128));
  let x12: u128 = (((arg1[7]) as u128) * (((arg2[5]) * 0x2) as u128));
  let x13: u128 = (((arg1[7]) as u128) * (((arg2[4]) * 0x2) as u128));
  let x14: u128 = (((arg1[7]) as u128) * (((arg2[3]) * 0x2) as u128));
  let x15: u128 = (((arg1[7]) as u128) * (((arg2[2]) * 0x2) as u128));
  let x16: u128 = (((arg1[6]) as u128) * (((arg2[8]) * 0x2) as u128));
  let x17: u128 = (((arg1[6]) as u128) * (((arg2[7]) * 0x2) as u128));
  let x18: u128 = (((arg1[6]) as u128) * (((arg2[6]) * 0x2) as u128));
  let x19: u128 = (((arg1[6]) as u128) * (((arg2[5]) * 0x2) as u128));
  let x20: u128 = (((arg1[6]) as u128) * (((arg2[4]) * 0x2) as u128));
  let x21: u128 = (((arg1[6]) as u128) * (((arg2[3]) * 0x2) as u128));
  let x22: u128 = (((arg1[5]) as u128) * (((arg2[8]) * 0x2) as u128));
  let x23: u128 = (((arg1[5]) as u128) * (((arg2[7]) * 0x2) as u128));
  let x24: u128 = (((arg1[5]) as u128) * (((arg2[6]) * 0x2) as u128));
  let x25: u128 = (((arg1[5]) as u128) * (((arg2[5]) * 0x2) as u128));
  let x26: u128 = (((arg1[5]) as u128) * (((arg2[4]) * 0x2) as u128));
  let x27: u128 = (((arg1[4]) as u128) * (((arg2[8]) * 0x2) as u128));
  let x28: u128 = (((arg1[4]) as u128) * (((arg2[7]) * 0x2) as u128));
  let x29: u128 = (((arg1[4]) as u128) * (((arg2[6]) * 0x2) as u128));
  let x30: u128 = (((arg1[4]) as u128) * (((arg2[5]) * 0x2) as u128));
  let x31: u128 = (((arg1[3]) as u128) * (((arg2[8]) * 0x2) as u128));
  let x32: u128 = (((arg1[3]) as u128) * (((arg2[7]) * 0x2) as u128));
  let x33: u128 = (((arg1[3]) as u128) * (((arg2[6]) * 0x2) as u128));
  let x34: u128 = (((arg1[2]) as u128) * (((arg2[8]) * 0x2) as u128));
  let x35: u128 = (((arg1[2]) as u128) * (((arg2[7]) * 0x2) as u128));
  let x36: u128 = (((arg1[1]) as u128) * (((arg2[8]) * 0x2) as u128));
  let x37: u128 = (((arg1[8]) as u128) * ((arg2[0]) as u128));
  let x38: u128 = (((arg1[7]) as u128) * ((arg2[1]) as u128));
  let x39: u128 = (((arg1[7]) as u128) * ((arg2[0]) as u128));
  let x40: u128 = (((arg1[6]) as u128) * ((arg2[2]) as u128));
  let x41: u128 = (((arg1[6]) as u128) * ((arg2[1]) as u128));
  let x42: u128 = (((arg1[6]) as u128) * ((arg2[0]) as u128));
  let x43: u128 = (((arg1[5]) as u128) * ((arg2[3]) as u128));
  let x44: u128 = (((arg1[5]) as u128) * ((arg2[2]) as u128));
  let x45: u128 = (((arg1[5]) as u128) * ((arg2[1]) as u128));
  let x46: u128 = (((arg1[5]) as u128) * ((arg2[0]) as u128));
  let x47: u128 = (((arg1[4]) as u128) * ((arg2[4]) as u128));
  let x48: u128 = (((arg1[4]) as u128) * ((arg2[3]) as u128));
  let x49: u128 = (((arg1[4]) as u128) * ((arg2[2]) as u128));
  let x50: u128 = (((arg1[4]) as u128) * ((arg2[1]) as u128));
  let x51: u128 = (((arg1[4]) as u128) * ((arg2[0]) as u128));
  let x52: u128 = (((arg1[3]) as u128) * ((arg2[5]) as u128));
  let x53: u128 = (((arg1[3]) as u128) * ((arg2[4]) as u128));
  let x54: u128 = (((arg1[3]) as u128) * ((arg2[3]) as u128));
  let x55: u128 = (((arg1[3]) as u128) * ((arg2[2]) as u128));
  let x56: u128 = (((arg1[3]) as u128) * ((arg2[1]) as u128));
  let x57: u128 = (((arg1[3]) as u128) * ((arg2[0]) as u128));
  let x58: u128 = (((arg1[2]) as u128) * ((arg2[6]) as u128));
  let x59: u128 = (((arg1[2]) as u128) * ((arg2[5]) as u128));
  let x60: u128 = (((arg1[2]) as u128) * ((arg2[4]) as u128));
  let x61: u128 = (((arg1[2]) as u128) * ((arg2[3]) as u128));
  let x62: u128 = (((arg1[2]) as u128) * ((arg2[2]) as u128));
  let x63: u128 = (((arg1[2]) as u128) * ((arg2[1]) as u128));
  let x64: u128 = (((arg1[2]) as u128) * ((arg2[0]) as u128));
  let x65: u128 = (((arg1[1]) as u128) * ((arg2[7]) as u128));
  let x66: u128 = (((arg1[1]) as u128) * ((arg2[6]) as u128));
  let x67: u128 = (((arg1[1]) as u128) * ((arg2[5]) as u128));
  let x68: u128 = (((arg1[1]) as u128) * ((arg2[4]) as u128));
  let x69: u128 = (((arg1[1]) as u128) * ((arg2[3]) as u128));
  let x70: u128 = (((arg1[1]) as u128) * ((arg2[2]) as u128));
  let x71: u128 = (((arg1[1]) as u128) * ((arg2[1]) as u128));
  let x72: u128 = (((arg1[1]) as u128) * ((arg2[0]) as u128));
  let x73: u128 = (((arg1[0]) as u128) * ((arg2[8]) as u128));
  let x74: u128 = (((arg1[0]) as u128) * ((arg2[7]) as u128));
  let x75: u128 = (((arg1[0]) as u128) * ((arg2[6]) as u128));
  let x76: u128 = (((arg1[0]) as u128) * ((arg2[5]) as u128));
  let x77: u128 = (((arg1[0]) as u128) * ((arg2[4]) as u128));
  let x78: u128 = (((arg1[0]) as u128) * ((arg2[3]) as u128));
  let x79: u128 = (((arg1[0]) as u128) * ((arg2[2]) as u128));
  let x80: u128 = (((arg1[0]) as u128) * ((arg2[1]) as u128));
  let x81: u128 = (((arg1[0]) as u128) * ((arg2[0]) as u128));
  let x82: u128 = (x81 + (x36 + (x35 + (x33 + (x30 + (x26 + (x21 + (x15 + x8))))))));
  let x83: u128 = (x82 >> 58);
  let x84: u64 = ((x82 & (0x3ffffffffffffff as u128)) as u64);
  let x85: u128 = (x73 + (x65 + (x58 + (x52 + (x47 + (x43 + (x40 + (x38 + x37))))))));
  let x86: u128 = (x74 + (x66 + (x59 + (x53 + (x48 + (x44 + (x41 + (x39 + x1))))))));
  let x87: u128 = (x75 + (x67 + (x60 + (x54 + (x49 + (x45 + (x42 + (x9 + x2))))))));
  let x88: u128 = (x76 + (x68 + (x61 + (x55 + (x50 + (x46 + (x16 + (x10 + x3))))))));
  let x89: u128 = (x77 + (x69 + (x62 + (x56 + (x51 + (x22 + (x17 + (x11 + x4))))))));
  let x90: u128 = (x78 + (x70 + (x63 + (x57 + (x27 + (x23 + (x18 + (x12 + x5))))))));
  let x91: u128 = (x79 + (x71 + (x64 + (x31 + (x28 + (x24 + (x19 + (x13 + x6))))))));
  let x92: u128 = (x80 + (x72 + (x34 + (x32 + (x29 + (x25 + (x20 + (x14 + x7))))))));
  let x93: u128 = (x83 + x92);
  let x94: u128 = (x93 >> 58);
  let x95: u64 = ((x93 & (0x3ffffffffffffff as u128)) as u64);
  let x96: u128 = (x94 + x91);
  let x97: u128 = (x96 >> 58);
  let x98: u64 = ((x96 & (0x3ffffffffffffff as u128)) as u64);
  let x99: u128 = (x97 + x90);
  let x100: u128 = (x99 >> 58);
  let x101: u64 = ((x99 & (0x3ffffffffffffff as u128)) as u64);
  let x102: u128 = (x100 + x89);
  let x103: u128 = (x102 >> 58);
  let x104: u64 = ((x102 & (0x3ffffffffffffff as u128)) as u64);
  let x105: u128 = (x103 + x88);
  let x106: u128 = (x105 >> 58);
  let x107: u64 = ((x105 & (0x3ffffffffffffff as u128)) as u64);
  let x108: u128 = (x106 + x87);
  let x109: u128 = (x108 >> 58);
  let x110: u64 = ((x108 & (0x3ffffffffffffff as u128)) as u64);
  let x111: u128 = (x109 + x86);
  let x112: u128 = (x111 >> 58);
  let x113: u64 = ((x111 & (0x3ffffffffffffff as u128)) as u64);
  let x114: u128 = (x112 + x85);
  let x115: u128 = (x114 >> 57);
  let x116: u64 = ((x114 & (0x1ffffffffffffff as u128)) as u64);
  let x117: u128 = ((x84 as u128) + x115);
  let x118: u64 = ((x117 >> 58) as u64);
  let x119: u64 = ((x117 & (0x3ffffffffffffff as u128)) as u64);
  let x120: u64 = (x118 + x95);
  let x121: fiat_p521_u1 = ((x120 >> 58) as fiat_p521_u1);
  let x122: u64 = (x120 & 0x3ffffffffffffff);
  let x123: u64 = ((x121 as u64) + x98);
  out1[0] = x119;
  out1[1] = x122;
  out1[2] = x123;
  out1[3] = x101;
  out1[4] = x104;
  out1[5] = x107;
  out1[6] = x110;
  out1[7] = x113;
  out1[8] = x116;
}

/// The function fiat_p521_carry_square squares a field element and reduces the result.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 * eval arg1) mod m
///
#[inline]
pub fn fiat_p521_carry_square(out1: &mut fiat_p521_tight_field_element, arg1: &fiat_p521_loose_field_element) -> () {
  let x1: u64 = (arg1[8]);
  let x2: u64 = (x1 * 0x2);
  let x3: u64 = ((arg1[8]) * 0x2);
  let x4: u64 = (arg1[7]);
  let x5: u64 = (x4 * 0x2);
  let x6: u64 = ((arg1[7]) * 0x2);
  let x7: u64 = (arg1[6]);
  let x8: u64 = (x7 * 0x2);
  let x9: u64 = ((arg1[6]) * 0x2);
  let x10: u64 = (arg1[5]);
  let x11: u64 = (x10 * 0x2);
  let x12: u64 = ((arg1[5]) * 0x2);
  let x13: u64 = ((arg1[4]) * 0x2);
  let x14: u64 = ((arg1[3]) * 0x2);
  let x15: u64 = ((arg1[2]) * 0x2);
  let x16: u64 = ((arg1[1]) * 0x2);
  let x17: u128 = (((arg1[8]) as u128) * ((x1 * 0x2) as u128));
  let x18: u128 = (((arg1[7]) as u128) * ((x2 * 0x2) as u128));
  let x19: u128 = (((arg1[7]) as u128) * ((x4 * 0x2) as u128));
  let x20: u128 = (((arg1[6]) as u128) * ((x2 * 0x2) as u128));
  let x21: u128 = (((arg1[6]) as u128) * ((x5 * 0x2) as u128));
  let x22: u128 = (((arg1[6]) as u128) * ((x7 * 0x2) as u128));
  let x23: u128 = (((arg1[5]) as u128) * ((x2 * 0x2) as u128));
  let x24: u128 = (((arg1[5]) as u128) * ((x5 * 0x2) as u128));
  let x25: u128 = (((arg1[5]) as u128) * ((x8 * 0x2) as u128));
  let x26: u128 = (((arg1[5]) as u128) * ((x10 * 0x2) as u128));
  let x27: u128 = (((arg1[4]) as u128) * ((x2 * 0x2) as u128));
  let x28: u128 = (((arg1[4]) as u128) * ((x5 * 0x2) as u128));
  let x29: u128 = (((arg1[4]) as u128) * ((x8 * 0x2) as u128));
  let x30: u128 = (((arg1[4]) as u128) * ((x11 * 0x2) as u128));
  let x31: u128 = (((arg1[4]) as u128) * ((arg1[4]) as u128));
  let x32: u128 = (((arg1[3]) as u128) * ((x2 * 0x2) as u128));
  let x33: u128 = (((arg1[3]) as u128) * ((x5 * 0x2) as u128));
  let x34: u128 = (((arg1[3]) as u128) * ((x8 * 0x2) as u128));
  let x35: u128 = (((arg1[3]) as u128) * (x12 as u128));
  let x36: u128 = (((arg1[3]) as u128) * (x13 as u128));
  let x37: u128 = (((arg1[3]) as u128) * ((arg1[3]) as u128));
  let x38: u128 = (((arg1[2]) as u128) * ((x2 * 0x2) as u128));
  let x39: u128 = (((arg1[2]) as u128) * ((x5 * 0x2) as u128));
  let x40: u128 = (((arg1[2]) as u128) * (x9 as u128));
  let x41: u128 = (((arg1[2]) as u128) * (x12 as u128));
  let x42: u128 = (((arg1[2]) as u128) * (x13 as u128));
  let x43: u128 = (((arg1[2]) as u128) * (x14 as u128));
  let x44: u128 = (((arg1[2]) as u128) * ((arg1[2]) as u128));
  let x45: u128 = (((arg1[1]) as u128) * ((x2 * 0x2) as u128));
  let x46: u128 = (((arg1[1]) as u128) * (x6 as u128));
  let x47: u128 = (((arg1[1]) as u128) * (x9 as u128));
  let x48: u128 = (((arg1[1]) as u128) * (x12 as u128));
  let x49: u128 = (((arg1[1]) as u128) * (x13 as u128));
  let x50: u128 = (((arg1[1]) as u128) * (x14 as u128));
  let x51: u128 = (((arg1[1]) as u128) * (x15 as u128));
  let x52: u128 = (((arg1[1]) as u128) * ((arg1[1]) as u128));
  let x53: u128 = (((arg1[0]) as u128) * (x3 as u128));
  let x54: u128 = (((arg1[0]) as u128) * (x6 as u128));
  let x55: u128 = (((arg1[0]) as u128) * (x9 as u128));
  let x56: u128 = (((arg1[0]) as u128) * (x12 as u128));
  let x57: u128 = (((arg1[0]) as u128) * (x13 as u128));
  let x58: u128 = (((arg1[0]) as u128) * (x14 as u128));
  let x59: u128 = (((arg1[0]) as u128) * (x15 as u128));
  let x60: u128 = (((arg1[0]) as u128) * (x16 as u128));
  let x61: u128 = (((arg1[0]) as u128) * ((arg1[0]) as u128));
  let x62: u128 = (x61 + (x45 + (x39 + (x34 + x30))));
  let x63: u128 = (x62 >> 58);
  let x64: u64 = ((x62 & (0x3ffffffffffffff as u128)) as u64);
  let x65: u128 = (x53 + (x46 + (x40 + (x35 + x31))));
  let x66: u128 = (x54 + (x47 + (x41 + (x36 + x17))));
  let x67: u128 = (x55 + (x48 + (x42 + (x37 + x18))));
  let x68: u128 = (x56 + (x49 + (x43 + (x20 + x19))));
  let x69: u128 = (x57 + (x50 + (x44 + (x23 + x21))));
  let x70: u128 = (x58 + (x51 + (x27 + (x24 + x22))));
  let x71: u128 = (x59 + (x52 + (x32 + (x28 + x25))));
  let x72: u128 = (x60 + (x38 + (x33 + (x29 + x26))));
  let x73: u128 = (x63 + x72);
  let x74: u128 = (x73 >> 58);
  let x75: u64 = ((x73 & (0x3ffffffffffffff as u128)) as u64);
  let x76: u128 = (x74 + x71);
  let x77: u128 = (x76 >> 58);
  let x78: u64 = ((x76 & (0x3ffffffffffffff as u128)) as u64);
  let x79: u128 = (x77 + x70);
  let x80: u128 = (x79 >> 58);
  let x81: u64 = ((x79 & (0x3ffffffffffffff as u128)) as u64);
  let x82: u128 = (x80 + x69);
  let x83: u128 = (x82 >> 58);
  let x84: u64 = ((x82 & (0x3ffffffffffffff as u128)) as u64);
  let x85: u128 = (x83 + x68);
  let x86: u128 = (x85 >> 58);
  let x87: u64 = ((x85 & (0x3ffffffffffffff as u128)) as u64);
  let x88: u128 = (x86 + x67);
  let x89: u128 = (x88 >> 58);
  let x90: u64 = ((x88 & (0x3ffffffffffffff as u128)) as u64);
  let x91: u128 = (x89 + x66);
  let x92: u128 = (x91 >> 58);
  let x93: u64 = ((x91 & (0x3ffffffffffffff as u128)) as u64);
  let x94: u128 = (x92 + x65);
  let x95: u128 = (x94 >> 57);
  let x96: u64 = ((x94 & (0x1ffffffffffffff as u128)) as u64);
  let x97: u128 = ((x64 as u128) + x95);
  let x98: u64 = ((x97 >> 58) as u64);
  let x99: u64 = ((x97 & (0x3ffffffffffffff as u128)) as u64);
  let x100: u64 = (x98 + x75);
  let x101: fiat_p521_u1 = ((x100 >> 58) as fiat_p521_u1);
  let x102: u64 = (x100 & 0x3ffffffffffffff);
  let x103: u64 = ((x101 as u64) + x78);
  out1[0] = x99;
  out1[1] = x102;
  out1[2] = x103;
  out1[3] = x81;
  out1[4] = x84;
  out1[5] = x87;
  out1[6] = x90;
  out1[7] = x93;
  out1[8] = x96;
}

/// The function fiat_p521_carry reduces a field element.
///
/// Postconditions:
///   eval out1 mod m = eval arg1 mod m
///
#[inline]
pub fn fiat_p521_carry(out1: &mut fiat_p521_tight_field_element, arg1: &fiat_p521_loose_field_element) -> () {
  let x1: u64 = (arg1[0]);
  let x2: u64 = ((x1 >> 58) + (arg1[1]));
  let x3: u64 = ((x2 >> 58) + (arg1[2]));
  let x4: u64 = ((x3 >> 58) + (arg1[3]));
  let x5: u64 = ((x4 >> 58) + (arg1[4]));
  let x6: u64 = ((x5 >> 58) + (arg1[5]));
  let x7: u64 = ((x6 >> 58) + (arg1[6]));
  let x8: u64 = ((x7 >> 58) + (arg1[7]));
  let x9: u64 = ((x8 >> 58) + (arg1[8]));
  let x10: u64 = ((x1 & 0x3ffffffffffffff) + (x9 >> 57));
  let x11: u64 = ((((x10 >> 58) as fiat_p521_u1) as u64) + (x2 & 0x3ffffffffffffff));
  let x12: u64 = (x10 & 0x3ffffffffffffff);
  let x13: u64 = (x11 & 0x3ffffffffffffff);
  let x14: u64 = ((((x11 >> 58) as fiat_p521_u1) as u64) + (x3 & 0x3ffffffffffffff));
  let x15: u64 = (x4 & 0x3ffffffffffffff);
  let x16: u64 = (x5 & 0x3ffffffffffffff);
  let x17: u64 = (x6 & 0x3ffffffffffffff);
  let x18: u64 = (x7 & 0x3ffffffffffffff);
  let x19: u64 = (x8 & 0x3ffffffffffffff);
  let x20: u64 = (x9 & 0x1ffffffffffffff);
  out1[0] = x12;
  out1[1] = x13;
  out1[2] = x14;
  out1[3] = x15;
  out1[4] = x16;
  out1[5] = x17;
  out1[6] = x18;
  out1[7] = x19;
  out1[8] = x20;
}

/// The function fiat_p521_add adds two field elements.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 + eval arg2) mod m
///
#[inline]
pub fn fiat_p521_add(out1: &mut fiat_p521_loose_field_element, arg1: &fiat_p521_tight_field_element, arg2: &fiat_p521_tight_field_element) -> () {
  let x1: u64 = ((arg1[0]) + (arg2[0]));
  let x2: u64 = ((arg1[1]) + (arg2[1]));
  let x3: u64 = ((arg1[2]) + (arg2[2]));
  let x4: u64 = ((arg1[3]) + (arg2[3]));
  let x5: u64 = ((arg1[4]) + (arg2[4]));
  let x6: u64 = ((arg1[5]) + (arg2[5]));
  let x7: u64 = ((arg1[6]) + (arg2[6]));
  let x8: u64 = ((arg1[7]) + (arg2[7]));
  let x9: u64 = ((arg1[8]) + (arg2[8]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
}

/// The function fiat_p521_sub subtracts two field elements.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 - eval arg2) mod m
///
#[inline]
pub fn fiat_p521_sub(out1: &mut fiat_p521_loose_field_element, arg1: &fiat_p521_tight_field_element, arg2: &fiat_p521_tight_field_element) -> () {
  let x1: u64 = ((0x7fffffffffffffe + (arg1[0])) - (arg2[0]));
  let x2: u64 = ((0x7fffffffffffffe + (arg1[1])) - (arg2[1]));
  let x3: u64 = ((0x7fffffffffffffe + (arg1[2])) - (arg2[2]));
  let x4: u64 = ((0x7fffffffffffffe + (arg1[3])) - (arg2[3]));
  let x5: u64 = ((0x7fffffffffffffe + (arg1[4])) - (arg2[4]));
  let x6: u64 = ((0x7fffffffffffffe + (arg1[5])) - (arg2[5]));
  let x7: u64 = ((0x7fffffffffffffe + (arg1[6])) - (arg2[6]));
  let x8: u64 = ((0x7fffffffffffffe + (arg1[7])) - (arg2[7]));
  let x9: u64 = ((0x3fffffffffffffe + (arg1[8])) - (arg2[8]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
}

/// The function fiat_p521_opp negates a field element.
///
/// Postconditions:
///   eval out1 mod m = -eval arg1 mod m
///
#[inline]
pub fn fiat_p521_opp(out1: &mut fiat_p521_loose_field_element, arg1: &fiat_p521_tight_field_element) -> () {
  let x1: u64 = (0x7fffffffffffffe - (arg1[0]));
  let x2: u64 = (0x7fffffffffffffe - (arg1[1]));
  let x3: u64 = (0x7fffffffffffffe - (arg1[2]));
  let x4: u64 = (0x7fffffffffffffe - (arg1[3]));
  let x5: u64 = (0x7fffffffffffffe - (arg1[4]));
  let x6: u64 = (0x7fffffffffffffe - (arg1[5]));
  let x7: u64 = (0x7fffffffffffffe - (arg1[6]));
  let x8: u64 = (0x7fffffffffffffe - (arg1[7]));
  let x9: u64 = (0x3fffffffffffffe - (arg1[8]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
}

/// The function fiat_p521_selectznz is a multi-limb conditional select.
///
/// Postconditions:
///   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub fn fiat_p521_selectznz(out1: &mut [u64; 9], arg1: fiat_p521_u1, arg2: &[u64; 9], arg3: &[u64; 9]) -> () {
  let mut x1: u64 = 0;
  fiat_p521_cmovznz_u64(&mut x1, arg1, (arg2[0]), (arg3[0]));
  let mut x2: u64 = 0;
  fiat_p521_cmovznz_u64(&mut x2, arg1, (arg2[1]), (arg3[1]));
  let mut x3: u64 = 0;
  fiat_p521_cmovznz_u64(&mut x3, arg1, (arg2[2]), (arg3[2]));
  let mut x4: u64 = 0;
  fiat_p521_cmovznz_u64(&mut x4, arg1, (arg2[3]), (arg3[3]));
  let mut x5: u64 = 0;
  fiat_p521_cmovznz_u64(&mut x5, arg1, (arg2[4]), (arg3[4]));
  let mut x6: u64 = 0;
  fiat_p521_cmovznz_u64(&mut x6, arg1, (arg2[5]), (arg3[5]));
  let mut x7: u64 = 0;
  fiat_p521_cmovznz_u64(&mut x7, arg1, (arg2[6]), (arg3[6]));
  let mut x8: u64 = 0;
  fiat_p521_cmovznz_u64(&mut x8, arg1, (arg2[7]), (arg3[7]));
  let mut x9: u64 = 0;
  fiat_p521_cmovznz_u64(&mut x9, arg1, (arg2[8]), (arg3[8]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
}

/// The function fiat_p521_to_bytes serializes a field element to bytes in little-endian order.
///
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..65]
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1]]
#[inline]
pub fn fiat_p521_to_bytes(out1: &mut [u8; 66], arg1: &fiat_p521_tight_field_element) -> () {
  let mut x1: u64 = 0;
  let mut x2: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u58(&mut x1, &mut x2, 0x0, (arg1[0]), 0x3ffffffffffffff);
  let mut x3: u64 = 0;
  let mut x4: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u58(&mut x3, &mut x4, x2, (arg1[1]), 0x3ffffffffffffff);
  let mut x5: u64 = 0;
  let mut x6: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u58(&mut x5, &mut x6, x4, (arg1[2]), 0x3ffffffffffffff);
  let mut x7: u64 = 0;
  let mut x8: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u58(&mut x7, &mut x8, x6, (arg1[3]), 0x3ffffffffffffff);
  let mut x9: u64 = 0;
  let mut x10: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u58(&mut x9, &mut x10, x8, (arg1[4]), 0x3ffffffffffffff);
  let mut x11: u64 = 0;
  let mut x12: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u58(&mut x11, &mut x12, x10, (arg1[5]), 0x3ffffffffffffff);
  let mut x13: u64 = 0;
  let mut x14: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u58(&mut x13, &mut x14, x12, (arg1[6]), 0x3ffffffffffffff);
  let mut x15: u64 = 0;
  let mut x16: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u58(&mut x15, &mut x16, x14, (arg1[7]), 0x3ffffffffffffff);
  let mut x17: u64 = 0;
  let mut x18: fiat_p521_u1 = 0;
  fiat_p521_subborrowx_u57(&mut x17, &mut x18, x16, (arg1[8]), 0x1ffffffffffffff);
  let mut x19: u64 = 0;
  fiat_p521_cmovznz_u64(&mut x19, x18, (0x0 as u64), 0xffffffffffffffff);
  let mut x20: u64 = 0;
  let mut x21: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u58(&mut x20, &mut x21, 0x0, x1, (x19 & 0x3ffffffffffffff));
  let mut x22: u64 = 0;
  let mut x23: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u58(&mut x22, &mut x23, x21, x3, (x19 & 0x3ffffffffffffff));
  let mut x24: u64 = 0;
  let mut x25: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u58(&mut x24, &mut x25, x23, x5, (x19 & 0x3ffffffffffffff));
  let mut x26: u64 = 0;
  let mut x27: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u58(&mut x26, &mut x27, x25, x7, (x19 & 0x3ffffffffffffff));
  let mut x28: u64 = 0;
  let mut x29: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u58(&mut x28, &mut x29, x27, x9, (x19 & 0x3ffffffffffffff));
  let mut x30: u64 = 0;
  let mut x31: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u58(&mut x30, &mut x31, x29, x11, (x19 & 0x3ffffffffffffff));
  let mut x32: u64 = 0;
  let mut x33: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u58(&mut x32, &mut x33, x31, x13, (x19 & 0x3ffffffffffffff));
  let mut x34: u64 = 0;
  let mut x35: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u58(&mut x34, &mut x35, x33, x15, (x19 & 0x3ffffffffffffff));
  let mut x36: u64 = 0;
  let mut x37: fiat_p521_u1 = 0;
  fiat_p521_addcarryx_u57(&mut x36, &mut x37, x35, x17, (x19 & 0x1ffffffffffffff));
  let x38: u64 = (x34 << 6);
  let x39: u64 = (x32 << 4);
  let x40: u64 = (x30 << 2);
  let x41: u64 = (x26 << 6);
  let x42: u64 = (x24 << 4);
  let x43: u64 = (x22 << 2);
  let x44: u8 = ((x20 & (0xff as u64)) as u8);
  let x45: u64 = (x20 >> 8);
  let x46: u8 = ((x45 & (0xff as u64)) as u8);
  let x47: u64 = (x45 >> 8);
  let x48: u8 = ((x47 & (0xff as u64)) as u8);
  let x49: u64 = (x47 >> 8);
  let x50: u8 = ((x49 & (0xff as u64)) as u8);
  let x51: u64 = (x49 >> 8);
  let x52: u8 = ((x51 & (0xff as u64)) as u8);
  let x53: u64 = (x51 >> 8);
  let x54: u8 = ((x53 & (0xff as u64)) as u8);
  let x55: u64 = (x53 >> 8);
  let x56: u8 = ((x55 & (0xff as u64)) as u8);
  let x57: u8 = ((x55 >> 8) as u8);
  let x58: u64 = (x43 + (x57 as u64));
  let x59: u8 = ((x58 & (0xff as u64)) as u8);
  let x60: u64 = (x58 >> 8);
  let x61: u8 = ((x60 & (0xff as u64)) as u8);
  let x62: u64 = (x60 >> 8);
  let x63: u8 = ((x62 & (0xff as u64)) as u8);
  let x64: u64 = (x62 >> 8);
  let x65: u8 = ((x64 & (0xff as u64)) as u8);
  let x66: u64 = (x64 >> 8);
  let x67: u8 = ((x66 & (0xff as u64)) as u8);
  let x68: u64 = (x66 >> 8);
  let x69: u8 = ((x68 & (0xff as u64)) as u8);
  let x70: u64 = (x68 >> 8);
  let x71: u8 = ((x70 & (0xff as u64)) as u8);
  let x72: u8 = ((x70 >> 8) as u8);
  let x73: u64 = (x42 + (x72 as u64));
  let x74: u8 = ((x73 & (0xff as u64)) as u8);
  let x75: u64 = (x73 >> 8);
  let x76: u8 = ((x75 & (0xff as u64)) as u8);
  let x77: u64 = (x75 >> 8);
  let x78: u8 = ((x77 & (0xff as u64)) as u8);
  let x79: u64 = (x77 >> 8);
  let x80: u8 = ((x79 & (0xff as u64)) as u8);
  let x81: u64 = (x79 >> 8);
  let x82: u8 = ((x81 & (0xff as u64)) as u8);
  let x83: u64 = (x81 >> 8);
  let x84: u8 = ((x83 & (0xff as u64)) as u8);
  let x85: u64 = (x83 >> 8);
  let x86: u8 = ((x85 & (0xff as u64)) as u8);
  let x87: u8 = ((x85 >> 8) as u8);
  let x88: u64 = (x41 + (x87 as u64));
  let x89: u8 = ((x88 & (0xff as u64)) as u8);
  let x90: u64 = (x88 >> 8);
  let x91: u8 = ((x90 & (0xff as u64)) as u8);
  let x92: u64 = (x90 >> 8);
  let x93: u8 = ((x92 & (0xff as u64)) as u8);
  let x94: u64 = (x92 >> 8);
  let x95: u8 = ((x94 & (0xff as u64)) as u8);
  let x96: u64 = (x94 >> 8);
  let x97: u8 = ((x96 & (0xff as u64)) as u8);
  let x98: u64 = (x96 >> 8);
  let x99: u8 = ((x98 & (0xff as u64)) as u8);
  let x100: u64 = (x98 >> 8);
  let x101: u8 = ((x100 & (0xff as u64)) as u8);
  let x102: u8 = ((x100 >> 8) as u8);
  let x103: u8 = ((x28 & (0xff as u64)) as u8);
  let x104: u64 = (x28 >> 8);
  let x105: u8 = ((x104 & (0xff as u64)) as u8);
  let x106: u64 = (x104 >> 8);
  let x107: u8 = ((x106 & (0xff as u64)) as u8);
  let x108: u64 = (x106 >> 8);
  let x109: u8 = ((x108 & (0xff as u64)) as u8);
  let x110: u64 = (x108 >> 8);
  let x111: u8 = ((x110 & (0xff as u64)) as u8);
  let x112: u64 = (x110 >> 8);
  let x113: u8 = ((x112 & (0xff as u64)) as u8);
  let x114: u64 = (x112 >> 8);
  let x115: u8 = ((x114 & (0xff as u64)) as u8);
  let x116: u8 = ((x114 >> 8) as u8);
  let x117: u64 = (x40 + (x116 as u64));
  let x118: u8 = ((x117 & (0xff as u64)) as u8);
  let x119: u64 = (x117 >> 8);
  let x120: u8 = ((x119 & (0xff as u64)) as u8);
  let x121: u64 = (x119 >> 8);
  let x122: u8 = ((x121 & (0xff as u64)) as u8);
  let x123: u64 = (x121 >> 8);
  let x124: u8 = ((x123 & (0xff as u64)) as u8);
  let x125: u64 = (x123 >> 8);
  let x126: u8 = ((x125 & (0xff as u64)) as u8);
  let x127: u64 = (x125 >> 8);
  let x128: u8 = ((x127 & (0xff as u64)) as u8);
  let x129: u64 = (x127 >> 8);
  let x130: u8 = ((x129 & (0xff as u64)) as u8);
  let x131: u8 = ((x129 >> 8) as u8);
  let x132: u64 = (x39 + (x131 as u64));
  let x133: u8 = ((x132 & (0xff as u64)) as u8);
  let x134: u64 = (x132 >> 8);
  let x135: u8 = ((x134 & (0xff as u64)) as u8);
  let x136: u64 = (x134 >> 8);
  let x137: u8 = ((x136 & (0xff as u64)) as u8);
  let x138: u64 = (x136 >> 8);
  let x139: u8 = ((x138 & (0xff as u64)) as u8);
  let x140: u64 = (x138 >> 8);
  let x141: u8 = ((x140 & (0xff as u64)) as u8);
  let x142: u64 = (x140 >> 8);
  let x143: u8 = ((x142 & (0xff as u64)) as u8);
  let x144: u64 = (x142 >> 8);
  let x145: u8 = ((x144 & (0xff as u64)) as u8);
  let x146: u8 = ((x144 >> 8) as u8);
  let x147: u64 = (x38 + (x146 as u64));
  let x148: u8 = ((x147 & (0xff as u64)) as u8);
  let x149: u64 = (x147 >> 8);
  let x150: u8 = ((x149 & (0xff as u64)) as u8);
  let x151: u64 = (x149 >> 8);
  let x152: u8 = ((x151 & (0xff as u64)) as u8);
  let x153: u64 = (x151 >> 8);
  let x154: u8 = ((x153 & (0xff as u64)) as u8);
  let x155: u64 = (x153 >> 8);
  let x156: u8 = ((x155 & (0xff as u64)) as u8);
  let x157: u64 = (x155 >> 8);
  let x158: u8 = ((x157 & (0xff as u64)) as u8);
  let x159: u64 = (x157 >> 8);
  let x160: u8 = ((x159 & (0xff as u64)) as u8);
  let x161: u8 = ((x159 >> 8) as u8);
  let x162: u8 = ((x36 & (0xff as u64)) as u8);
  let x163: u64 = (x36 >> 8);
  let x164: u8 = ((x163 & (0xff as u64)) as u8);
  let x165: u64 = (x163 >> 8);
  let x166: u8 = ((x165 & (0xff as u64)) as u8);
  let x167: u64 = (x165 >> 8);
  let x168: u8 = ((x167 & (0xff as u64)) as u8);
  let x169: u64 = (x167 >> 8);
  let x170: u8 = ((x169 & (0xff as u64)) as u8);
  let x171: u64 = (x169 >> 8);
  let x172: u8 = ((x171 & (0xff as u64)) as u8);
  let x173: u64 = (x171 >> 8);
  let x174: u8 = ((x173 & (0xff as u64)) as u8);
  let x175: fiat_p521_u1 = ((x173 >> 8) as fiat_p521_u1);
  out1[0] = x44;
  out1[1] = x46;
  out1[2] = x48;
  out1[3] = x50;
  out1[4] = x52;
  out1[5] = x54;
  out1[6] = x56;
  out1[7] = x59;
  out1[8] = x61;
  out1[9] = x63;
  out1[10] = x65;
  out1[11] = x67;
  out1[12] = x69;
  out1[13] = x71;
  out1[14] = x74;
  out1[15] = x76;
  out1[16] = x78;
  out1[17] = x80;
  out1[18] = x82;
  out1[19] = x84;
  out1[20] = x86;
  out1[21] = x89;
  out1[22] = x91;
  out1[23] = x93;
  out1[24] = x95;
  out1[25] = x97;
  out1[26] = x99;
  out1[27] = x101;
  out1[28] = x102;
  out1[29] = x103;
  out1[30] = x105;
  out1[31] = x107;
  out1[32] = x109;
  out1[33] = x111;
  out1[34] = x113;
  out1[35] = x115;
  out1[36] = x118;
  out1[37] = x120;
  out1[38] = x122;
  out1[39] = x124;
  out1[40] = x126;
  out1[41] = x128;
  out1[42] = x130;
  out1[43] = x133;
  out1[44] = x135;
  out1[45] = x137;
  out1[46] = x139;
  out1[47] = x141;
  out1[48] = x143;
  out1[49] = x145;
  out1[50] = x148;
  out1[51] = x150;
  out1[52] = x152;
  out1[53] = x154;
  out1[54] = x156;
  out1[55] = x158;
  out1[56] = x160;
  out1[57] = x161;
  out1[58] = x162;
  out1[59] = x164;
  out1[60] = x166;
  out1[61] = x168;
  out1[62] = x170;
  out1[63] = x172;
  out1[64] = x174;
  out1[65] = (x175 as u8);
}

/// The function fiat_p521_from_bytes deserializes a field element from bytes in little-endian order.
///
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1]]
#[inline]
pub fn fiat_p521_from_bytes(out1: &mut fiat_p521_tight_field_element, arg1: &[u8; 66]) -> () {
  let x1: u64 = ((((arg1[65]) as fiat_p521_u1) as u64) << 56);
  let x2: u64 = (((arg1[64]) as u64) << 48);
  let x3: u64 = (((arg1[63]) as u64) << 40);
  let x4: u64 = (((arg1[62]) as u64) << 32);
  let x5: u64 = (((arg1[61]) as u64) << 24);
  let x6: u64 = (((arg1[60]) as u64) << 16);
  let x7: u64 = (((arg1[59]) as u64) << 8);
  let x8: u8 = (arg1[58]);
  let x9: u64 = (((arg1[57]) as u64) << 50);
  let x10: u64 = (((arg1[56]) as u64) << 42);
  let x11: u64 = (((arg1[55]) as u64) << 34);
  let x12: u64 = (((arg1[54]) as u64) << 26);
  let x13: u64 = (((arg1[53]) as u64) << 18);
  let x14: u64 = (((arg1[52]) as u64) << 10);
  let x15: u64 = (((arg1[51]) as u64) << 2);
  let x16: u64 = (((arg1[50]) as u64) << 52);
  let x17: u64 = (((arg1[49]) as u64) << 44);
  let x18: u64 = (((arg1[48]) as u64) << 36);
  let x19: u64 = (((arg1[47]) as u64) << 28);
  let x20: u64 = (((arg1[46]) as u64) << 20);
  let x21: u64 = (((arg1[45]) as u64) << 12);
  let x22: u64 = (((arg1[44]) as u64) << 4);
  let x23: u64 = (((arg1[43]) as u64) << 54);
  let x24: u64 = (((arg1[42]) as u64) << 46);
  let x25: u64 = (((arg1[41]) as u64) << 38);
  let x26: u64 = (((arg1[40]) as u64) << 30);
  let x27: u64 = (((arg1[39]) as u64) << 22);
  let x28: u64 = (((arg1[38]) as u64) << 14);
  let x29: u64 = (((arg1[37]) as u64) << 6);
  let x30: u64 = (((arg1[36]) as u64) << 56);
  let x31: u64 = (((arg1[35]) as u64) << 48);
  let x32: u64 = (((arg1[34]) as u64) << 40);
  let x33: u64 = (((arg1[33]) as u64) << 32);
  let x34: u64 = (((arg1[32]) as u64) << 24);
  let x35: u64 = (((arg1[31]) as u64) << 16);
  let x36: u64 = (((arg1[30]) as u64) << 8);
  let x37: u8 = (arg1[29]);
  let x38: u64 = (((arg1[28]) as u64) << 50);
  let x39: u64 = (((arg1[27]) as u64) << 42);
  let x40: u64 = (((arg1[26]) as u64) << 34);
  let x41: u64 = (((arg1[25]) as u64) << 26);
  let x42: u64 = (((arg1[24]) as u64) << 18);
  let x43: u64 = (((arg1[23]) as u64) << 10);
  let x44: u64 = (((arg1[22]) as u64) << 2);
  let x45: u64 = (((arg1[21]) as u64) << 52);
  let x46: u64 = (((arg1[20]) as u64) << 44);
  let x47: u64 = (((arg1[19]) as u64) << 36);
  let x48: u64 = (((arg1[18]) as u64) << 28);
  let x49: u64 = (((arg1[17]) as u64) << 20);
  let x50: u64 = (((arg1[16]) as u64) << 12);
  let x51: u64 = (((arg1[15]) as u64) << 4);
  let x52: u64 = (((arg1[14]) as u64) << 54);
  let x53: u64 = (((arg1[13]) as u64) << 46);
  let x54: u64 = (((arg1[12]) as u64) << 38);
  let x55: u64 = (((arg1[11]) as u64) << 30);
  let x56: u64 = (((arg1[10]) as u64) << 22);
  let x57: u64 = (((arg1[9]) as u64) << 14);
  let x58: u64 = (((arg1[8]) as u64) << 6);
  let x59: u64 = (((arg1[7]) as u64) << 56);
  let x60: u64 = (((arg1[6]) as u64) << 48);
  let x61: u64 = (((arg1[5]) as u64) << 40);
  let x62: u64 = (((arg1[4]) as u64) << 32);
  let x63: u64 = (((arg1[3]) as u64) << 24);
  let x64: u64 = (((arg1[2]) as u64) << 16);
  let x65: u64 = (((arg1[1]) as u64) << 8);
  let x66: u8 = (arg1[0]);
  let x67: u64 = (x65 + (x66 as u64));
  let x68: u64 = (x64 + x67);
  let x69: u64 = (x63 + x68);
  let x70: u64 = (x62 + x69);
  let x71: u64 = (x61 + x70);
  let x72: u64 = (x60 + x71);
  let x73: u64 = (x59 + x72);
  let x74: u64 = (x73 & 0x3ffffffffffffff);
  let x75: u8 = ((x73 >> 58) as u8);
  let x76: u64 = (x58 + (x75 as u64));
  let x77: u64 = (x57 + x76);
  let x78: u64 = (x56 + x77);
  let x79: u64 = (x55 + x78);
  let x80: u64 = (x54 + x79);
  let x81: u64 = (x53 + x80);
  let x82: u64 = (x52 + x81);
  let x83: u64 = (x82 & 0x3ffffffffffffff);
  let x84: u8 = ((x82 >> 58) as u8);
  let x85: u64 = (x51 + (x84 as u64));
  let x86: u64 = (x50 + x85);
  let x87: u64 = (x49 + x86);
  let x88: u64 = (x48 + x87);
  let x89: u64 = (x47 + x88);
  let x90: u64 = (x46 + x89);
  let x91: u64 = (x45 + x90);
  let x92: u64 = (x91 & 0x3ffffffffffffff);
  let x93: u8 = ((x91 >> 58) as u8);
  let x94: u64 = (x44 + (x93 as u64));
  let x95: u64 = (x43 + x94);
  let x96: u64 = (x42 + x95);
  let x97: u64 = (x41 + x96);
  let x98: u64 = (x40 + x97);
  let x99: u64 = (x39 + x98);
  let x100: u64 = (x38 + x99);
  let x101: u64 = (x36 + (x37 as u64));
  let x102: u64 = (x35 + x101);
  let x103: u64 = (x34 + x102);
  let x104: u64 = (x33 + x103);
  let x105: u64 = (x32 + x104);
  let x106: u64 = (x31 + x105);
  let x107: u64 = (x30 + x106);
  let x108: u64 = (x107 & 0x3ffffffffffffff);
  let x109: u8 = ((x107 >> 58) as u8);
  let x110: u64 = (x29 + (x109 as u64));
  let x111: u64 = (x28 + x110);
  let x112: u64 = (x27 + x111);
  let x113: u64 = (x26 + x112);
  let x114: u64 = (x25 + x113);
  let x115: u64 = (x24 + x114);
  let x116: u64 = (x23 + x115);
  let x117: u64 = (x116 & 0x3ffffffffffffff);
  let x118: u8 = ((x116 >> 58) as u8);
  let x119: u64 = (x22 + (x118 as u64));
  let x120: u64 = (x21 + x119);
  let x121: u64 = (x20 + x120);
  let x122: u64 = (x19 + x121);
  let x123: u64 = (x18 + x122);
  let x124: u64 = (x17 + x123);
  let x125: u64 = (x16 + x124);
  let x126: u64 = (x125 & 0x3ffffffffffffff);
  let x127: u8 = ((x125 >> 58) as u8);
  let x128: u64 = (x15 + (x127 as u64));
  let x129: u64 = (x14 + x128);
  let x130: u64 = (x13 + x129);
  let x131: u64 = (x12 + x130);
  let x132: u64 = (x11 + x131);
  let x133: u64 = (x10 + x132);
  let x134: u64 = (x9 + x133);
  let x135: u64 = (x7 + (x8 as u64));
  let x136: u64 = (x6 + x135);
  let x137: u64 = (x5 + x136);
  let x138: u64 = (x4 + x137);
  let x139: u64 = (x3 + x138);
  let x140: u64 = (x2 + x139);
  let x141: u64 = (x1 + x140);
  out1[0] = x74;
  out1[1] = x83;
  out1[2] = x92;
  out1[3] = x100;
  out1[4] = x108;
  out1[5] = x117;
  out1[6] = x126;
  out1[7] = x134;
  out1[8] = x141;
}

/// The function fiat_p521_relax is the identity function converting from tight field elements to loose field elements.
///
/// Postconditions:
///   out1 = arg1
///
#[inline]
pub fn fiat_p521_relax(out1: &mut fiat_p521_loose_field_element, arg1: &fiat_p521_tight_field_element) -> () {
  let x1: u64 = (arg1[0]);
  let x2: u64 = (arg1[1]);
  let x3: u64 = (arg1[2]);
  let x4: u64 = (arg1[3]);
  let x5: u64 = (arg1[4]);
  let x6: u64 = (arg1[5]);
  let x7: u64 = (arg1[6]);
  let x8: u64 = (arg1[7]);
  let x9: u64 = (arg1[8]);
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
}
