//! Autogenerated: 'src/ExtractionOCaml/unsaturated_solinas' --lang Rust --inline p448 64 8 '2^448 - 2^224 - 1' carry_mul carry_square carry add sub opp selectznz to_bytes from_bytes relax
//! curve description: p448
//! machine_wordsize = 64 (from "64")
//! requested operations: carry_mul, carry_square, carry, add, sub, opp, selectznz, to_bytes, from_bytes, relax
//! n = 8 (from "8")
//! s-c = 2^448 - [(2^224, 1), (1, 1)] (from "2^448 - 2^224 - 1")
//! tight_bounds_multiplier = 1 (from "")
//!
//! Computed values:
//!   carry_chain = [3, 7, 4, 0, 5, 1, 6, 2, 7, 3, 4, 0]
//!   eval z = z[0] + (z[1] << 56) + (z[2] << 112) + (z[3] << 168) + (z[4] << 224) + (z[5] << 0x118) + (z[6] << 0x150) + (z[7] << 0x188)
//!   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178) + (z[48] << 0x180) + (z[49] << 0x188) + (z[50] << 0x190) + (z[51] << 0x198) + (z[52] << 0x1a0) + (z[53] << 0x1a8) + (z[54] << 0x1b0) + (z[55] << 0x1b8)
//!   balance = [0x1fffffffffffffe, 0x1fffffffffffffe, 0x1fffffffffffffe, 0x1fffffffffffffe, 0x1fffffffffffffc, 0x1fffffffffffffe, 0x1fffffffffffffe, 0x1fffffffffffffe]

#![allow(unused_parens)]
#[allow(non_camel_case_types)]

pub type fiat_p448_u1 = u8;
pub type fiat_p448_i1 = i8;
pub type fiat_p448_u2 = u8;
pub type fiat_p448_i2 = i8;

/* The type fiat_p448_loose_field_element is a field element with loose bounds. */
/* Bounds: [[0x0 ~> 0x300000000000000], [0x0 ~> 0x300000000000000], [0x0 ~> 0x300000000000000], [0x0 ~> 0x300000000000000], [0x0 ~> 0x300000000000000], [0x0 ~> 0x300000000000000], [0x0 ~> 0x300000000000000], [0x0 ~> 0x300000000000000]] */
pub type fiat_p448_loose_field_element = [u64; 8];

/* The type fiat_p448_tight_field_element is a field element with tight bounds. */
/* Bounds: [[0x0 ~> 0x100000000000000], [0x0 ~> 0x100000000000000], [0x0 ~> 0x100000000000000], [0x0 ~> 0x100000000000000], [0x0 ~> 0x100000000000000], [0x0 ~> 0x100000000000000], [0x0 ~> 0x100000000000000], [0x0 ~> 0x100000000000000]] */
pub type fiat_p448_tight_field_element = [u64; 8];


/// The function fiat_p448_addcarryx_u56 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^56
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^56⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p448_addcarryx_u56(out1: &mut u64, out2: &mut fiat_p448_u1, arg1: fiat_p448_u1, arg2: u64, arg3: u64) -> () {
  let x1: u64 = (((arg1 as u64) + arg2) + arg3);
  let x2: u64 = (x1 & 0xffffffffffffff);
  let x3: fiat_p448_u1 = ((x1 >> 56) as fiat_p448_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_p448_subborrowx_u56 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^56
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^56⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p448_subborrowx_u56(out1: &mut u64, out2: &mut fiat_p448_u1, arg1: fiat_p448_u1, arg2: u64, arg3: u64) -> () {
  let x1: i64 = ((((((arg2 as i128) - (arg1 as i128)) as i64) as i128) - (arg3 as i128)) as i64);
  let x2: fiat_p448_i1 = ((x1 >> 56) as fiat_p448_i1);
  let x3: u64 = (((x1 as i128) & (0xffffffffffffff as i128)) as u64);
  *out1 = x3;
  *out2 = (((0x0 as fiat_p448_i2) - (x2 as fiat_p448_i2)) as fiat_p448_u1);
}

/// The function fiat_p448_cmovznz_u64 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub fn fiat_p448_cmovznz_u64(out1: &mut u64, arg1: fiat_p448_u1, arg2: u64, arg3: u64) -> () {
  let x1: fiat_p448_u1 = (!(!arg1));
  let x2: u64 = ((((((0x0 as fiat_p448_i2) - (x1 as fiat_p448_i2)) as fiat_p448_i1) as i128) & (0xffffffffffffffff as i128)) as u64);
  let x3: u64 = ((x2 & arg3) | ((!x2) & arg2));
  *out1 = x3;
}

/// The function fiat_p448_carry_mul multiplies two field elements and reduces the result.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 * eval arg2) mod m
///
#[inline]
pub fn fiat_p448_carry_mul(out1: &mut fiat_p448_tight_field_element, arg1: &fiat_p448_loose_field_element, arg2: &fiat_p448_loose_field_element) -> () {
  let x1: u128 = (((arg1[7]) as u128) * ((arg2[7]) as u128));
  let x2: u128 = (((arg1[7]) as u128) * ((arg2[6]) as u128));
  let x3: u128 = (((arg1[7]) as u128) * ((arg2[5]) as u128));
  let x4: u128 = (((arg1[6]) as u128) * ((arg2[7]) as u128));
  let x5: u128 = (((arg1[6]) as u128) * ((arg2[6]) as u128));
  let x6: u128 = (((arg1[5]) as u128) * ((arg2[7]) as u128));
  let x7: u128 = (((arg1[7]) as u128) * ((arg2[7]) as u128));
  let x8: u128 = (((arg1[7]) as u128) * ((arg2[6]) as u128));
  let x9: u128 = (((arg1[7]) as u128) * ((arg2[5]) as u128));
  let x10: u128 = (((arg1[6]) as u128) * ((arg2[7]) as u128));
  let x11: u128 = (((arg1[6]) as u128) * ((arg2[6]) as u128));
  let x12: u128 = (((arg1[5]) as u128) * ((arg2[7]) as u128));
  let x13: u128 = (((arg1[7]) as u128) * ((arg2[7]) as u128));
  let x14: u128 = (((arg1[7]) as u128) * ((arg2[6]) as u128));
  let x15: u128 = (((arg1[7]) as u128) * ((arg2[5]) as u128));
  let x16: u128 = (((arg1[7]) as u128) * ((arg2[4]) as u128));
  let x17: u128 = (((arg1[7]) as u128) * ((arg2[3]) as u128));
  let x18: u128 = (((arg1[7]) as u128) * ((arg2[2]) as u128));
  let x19: u128 = (((arg1[7]) as u128) * ((arg2[1]) as u128));
  let x20: u128 = (((arg1[6]) as u128) * ((arg2[7]) as u128));
  let x21: u128 = (((arg1[6]) as u128) * ((arg2[6]) as u128));
  let x22: u128 = (((arg1[6]) as u128) * ((arg2[5]) as u128));
  let x23: u128 = (((arg1[6]) as u128) * ((arg2[4]) as u128));
  let x24: u128 = (((arg1[6]) as u128) * ((arg2[3]) as u128));
  let x25: u128 = (((arg1[6]) as u128) * ((arg2[2]) as u128));
  let x26: u128 = (((arg1[5]) as u128) * ((arg2[7]) as u128));
  let x27: u128 = (((arg1[5]) as u128) * ((arg2[6]) as u128));
  let x28: u128 = (((arg1[5]) as u128) * ((arg2[5]) as u128));
  let x29: u128 = (((arg1[5]) as u128) * ((arg2[4]) as u128));
  let x30: u128 = (((arg1[5]) as u128) * ((arg2[3]) as u128));
  let x31: u128 = (((arg1[4]) as u128) * ((arg2[7]) as u128));
  let x32: u128 = (((arg1[4]) as u128) * ((arg2[6]) as u128));
  let x33: u128 = (((arg1[4]) as u128) * ((arg2[5]) as u128));
  let x34: u128 = (((arg1[4]) as u128) * ((arg2[4]) as u128));
  let x35: u128 = (((arg1[3]) as u128) * ((arg2[7]) as u128));
  let x36: u128 = (((arg1[3]) as u128) * ((arg2[6]) as u128));
  let x37: u128 = (((arg1[3]) as u128) * ((arg2[5]) as u128));
  let x38: u128 = (((arg1[2]) as u128) * ((arg2[7]) as u128));
  let x39: u128 = (((arg1[2]) as u128) * ((arg2[6]) as u128));
  let x40: u128 = (((arg1[1]) as u128) * ((arg2[7]) as u128));
  let x41: u128 = (((arg1[7]) as u128) * ((arg2[4]) as u128));
  let x42: u128 = (((arg1[7]) as u128) * ((arg2[3]) as u128));
  let x43: u128 = (((arg1[7]) as u128) * ((arg2[2]) as u128));
  let x44: u128 = (((arg1[7]) as u128) * ((arg2[1]) as u128));
  let x45: u128 = (((arg1[6]) as u128) * ((arg2[5]) as u128));
  let x46: u128 = (((arg1[6]) as u128) * ((arg2[4]) as u128));
  let x47: u128 = (((arg1[6]) as u128) * ((arg2[3]) as u128));
  let x48: u128 = (((arg1[6]) as u128) * ((arg2[2]) as u128));
  let x49: u128 = (((arg1[5]) as u128) * ((arg2[6]) as u128));
  let x50: u128 = (((arg1[5]) as u128) * ((arg2[5]) as u128));
  let x51: u128 = (((arg1[5]) as u128) * ((arg2[4]) as u128));
  let x52: u128 = (((arg1[5]) as u128) * ((arg2[3]) as u128));
  let x53: u128 = (((arg1[4]) as u128) * ((arg2[7]) as u128));
  let x54: u128 = (((arg1[4]) as u128) * ((arg2[6]) as u128));
  let x55: u128 = (((arg1[4]) as u128) * ((arg2[5]) as u128));
  let x56: u128 = (((arg1[4]) as u128) * ((arg2[4]) as u128));
  let x57: u128 = (((arg1[3]) as u128) * ((arg2[7]) as u128));
  let x58: u128 = (((arg1[3]) as u128) * ((arg2[6]) as u128));
  let x59: u128 = (((arg1[3]) as u128) * ((arg2[5]) as u128));
  let x60: u128 = (((arg1[2]) as u128) * ((arg2[7]) as u128));
  let x61: u128 = (((arg1[2]) as u128) * ((arg2[6]) as u128));
  let x62: u128 = (((arg1[1]) as u128) * ((arg2[7]) as u128));
  let x63: u128 = (((arg1[7]) as u128) * ((arg2[0]) as u128));
  let x64: u128 = (((arg1[6]) as u128) * ((arg2[1]) as u128));
  let x65: u128 = (((arg1[6]) as u128) * ((arg2[0]) as u128));
  let x66: u128 = (((arg1[5]) as u128) * ((arg2[2]) as u128));
  let x67: u128 = (((arg1[5]) as u128) * ((arg2[1]) as u128));
  let x68: u128 = (((arg1[5]) as u128) * ((arg2[0]) as u128));
  let x69: u128 = (((arg1[4]) as u128) * ((arg2[3]) as u128));
  let x70: u128 = (((arg1[4]) as u128) * ((arg2[2]) as u128));
  let x71: u128 = (((arg1[4]) as u128) * ((arg2[1]) as u128));
  let x72: u128 = (((arg1[4]) as u128) * ((arg2[0]) as u128));
  let x73: u128 = (((arg1[3]) as u128) * ((arg2[4]) as u128));
  let x74: u128 = (((arg1[3]) as u128) * ((arg2[3]) as u128));
  let x75: u128 = (((arg1[3]) as u128) * ((arg2[2]) as u128));
  let x76: u128 = (((arg1[3]) as u128) * ((arg2[1]) as u128));
  let x77: u128 = (((arg1[3]) as u128) * ((arg2[0]) as u128));
  let x78: u128 = (((arg1[2]) as u128) * ((arg2[5]) as u128));
  let x79: u128 = (((arg1[2]) as u128) * ((arg2[4]) as u128));
  let x80: u128 = (((arg1[2]) as u128) * ((arg2[3]) as u128));
  let x81: u128 = (((arg1[2]) as u128) * ((arg2[2]) as u128));
  let x82: u128 = (((arg1[2]) as u128) * ((arg2[1]) as u128));
  let x83: u128 = (((arg1[2]) as u128) * ((arg2[0]) as u128));
  let x84: u128 = (((arg1[1]) as u128) * ((arg2[6]) as u128));
  let x85: u128 = (((arg1[1]) as u128) * ((arg2[5]) as u128));
  let x86: u128 = (((arg1[1]) as u128) * ((arg2[4]) as u128));
  let x87: u128 = (((arg1[1]) as u128) * ((arg2[3]) as u128));
  let x88: u128 = (((arg1[1]) as u128) * ((arg2[2]) as u128));
  let x89: u128 = (((arg1[1]) as u128) * ((arg2[1]) as u128));
  let x90: u128 = (((arg1[1]) as u128) * ((arg2[0]) as u128));
  let x91: u128 = (((arg1[0]) as u128) * ((arg2[7]) as u128));
  let x92: u128 = (((arg1[0]) as u128) * ((arg2[6]) as u128));
  let x93: u128 = (((arg1[0]) as u128) * ((arg2[5]) as u128));
  let x94: u128 = (((arg1[0]) as u128) * ((arg2[4]) as u128));
  let x95: u128 = (((arg1[0]) as u128) * ((arg2[3]) as u128));
  let x96: u128 = (((arg1[0]) as u128) * ((arg2[2]) as u128));
  let x97: u128 = (((arg1[0]) as u128) * ((arg2[1]) as u128));
  let x98: u128 = (((arg1[0]) as u128) * ((arg2[0]) as u128));
  let x99: u128 = (x95 + (x88 + (x82 + (x77 + (x31 + (x27 + (x22 + x16)))))));
  let x100: u64 = ((x99 >> 56) as u64);
  let x101: u64 = ((x99 & (0xffffffffffffff as u128)) as u64);
  let x102: u128 = (x91 + (x84 + (x78 + (x73 + (x69 + (x66 + (x64 + (x63 + (x53 + (x49 + (x45 + x41)))))))))));
  let x103: u128 = (x92 + (x85 + (x79 + (x74 + (x70 + (x67 + (x65 + (x57 + (x54 + (x50 + (x46 + (x42 + (x13 + x7)))))))))))));
  let x104: u128 = (x93 + (x86 + (x80 + (x75 + (x71 + (x68 + (x60 + (x58 + (x55 + (x51 + (x47 + (x43 + (x20 + (x14 + (x10 + x8)))))))))))))));
  let x105: u128 = (x94 + (x87 + (x81 + (x76 + (x72 + (x62 + (x61 + (x59 + (x56 + (x52 + (x48 + (x44 + (x26 + (x21 + (x15 + (x12 + (x11 + x9)))))))))))))))));
  let x106: u128 = (x96 + (x89 + (x83 + (x35 + (x32 + (x28 + (x23 + (x17 + x1))))))));
  let x107: u128 = (x97 + (x90 + (x38 + (x36 + (x33 + (x29 + (x24 + (x18 + (x4 + x2)))))))));
  let x108: u128 = (x98 + (x40 + (x39 + (x37 + (x34 + (x30 + (x25 + (x19 + (x6 + (x5 + x3))))))))));
  let x109: u128 = ((x100 as u128) + x105);
  let x110: u64 = ((x102 >> 56) as u64);
  let x111: u64 = ((x102 & (0xffffffffffffff as u128)) as u64);
  let x112: u128 = (x109 + (x110 as u128));
  let x113: u64 = ((x112 >> 56) as u64);
  let x114: u64 = ((x112 & (0xffffffffffffff as u128)) as u64);
  let x115: u128 = (x108 + (x110 as u128));
  let x116: u128 = ((x113 as u128) + x104);
  let x117: u64 = ((x115 >> 56) as u64);
  let x118: u64 = ((x115 & (0xffffffffffffff as u128)) as u64);
  let x119: u128 = ((x117 as u128) + x107);
  let x120: u64 = ((x116 >> 56) as u64);
  let x121: u64 = ((x116 & (0xffffffffffffff as u128)) as u64);
  let x122: u128 = ((x120 as u128) + x103);
  let x123: u64 = ((x119 >> 56) as u64);
  let x124: u64 = ((x119 & (0xffffffffffffff as u128)) as u64);
  let x125: u128 = ((x123 as u128) + x106);
  let x126: u64 = ((x122 >> 56) as u64);
  let x127: u64 = ((x122 & (0xffffffffffffff as u128)) as u64);
  let x128: u64 = (x126 + x111);
  let x129: u64 = ((x125 >> 56) as u64);
  let x130: u64 = ((x125 & (0xffffffffffffff as u128)) as u64);
  let x131: u64 = (x129 + x101);
  let x132: u64 = (x128 >> 56);
  let x133: u64 = (x128 & 0xffffffffffffff);
  let x134: u64 = (x131 >> 56);
  let x135: u64 = (x131 & 0xffffffffffffff);
  let x136: u64 = (x114 + x132);
  let x137: u64 = (x118 + x132);
  let x138: u64 = (x134 + x136);
  let x139: fiat_p448_u1 = ((x138 >> 56) as fiat_p448_u1);
  let x140: u64 = (x138 & 0xffffffffffffff);
  let x141: u64 = ((x139 as u64) + x121);
  let x142: fiat_p448_u1 = ((x137 >> 56) as fiat_p448_u1);
  let x143: u64 = (x137 & 0xffffffffffffff);
  let x144: u64 = ((x142 as u64) + x124);
  out1[0] = x143;
  out1[1] = x144;
  out1[2] = x130;
  out1[3] = x135;
  out1[4] = x140;
  out1[5] = x141;
  out1[6] = x127;
  out1[7] = x133;
}

/// The function fiat_p448_carry_square squares a field element and reduces the result.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 * eval arg1) mod m
///
#[inline]
pub fn fiat_p448_carry_square(out1: &mut fiat_p448_tight_field_element, arg1: &fiat_p448_loose_field_element) -> () {
  let x1: u64 = (arg1[7]);
  let x2: u64 = (arg1[7]);
  let x3: u64 = (x1 * 0x2);
  let x4: u64 = (x2 * 0x2);
  let x5: u64 = ((arg1[7]) * 0x2);
  let x6: u64 = (arg1[6]);
  let x7: u64 = (arg1[6]);
  let x8: u64 = (x6 * 0x2);
  let x9: u64 = (x7 * 0x2);
  let x10: u64 = ((arg1[6]) * 0x2);
  let x11: u64 = (arg1[5]);
  let x12: u64 = (arg1[5]);
  let x13: u64 = (x11 * 0x2);
  let x14: u64 = (x12 * 0x2);
  let x15: u64 = ((arg1[5]) * 0x2);
  let x16: u64 = (arg1[4]);
  let x17: u64 = (arg1[4]);
  let x18: u64 = ((arg1[4]) * 0x2);
  let x19: u64 = ((arg1[3]) * 0x2);
  let x20: u64 = ((arg1[2]) * 0x2);
  let x21: u64 = ((arg1[1]) * 0x2);
  let x22: u128 = (((arg1[7]) as u128) * (x1 as u128));
  let x23: u128 = (((arg1[6]) as u128) * (x3 as u128));
  let x24: u128 = (((arg1[6]) as u128) * (x6 as u128));
  let x25: u128 = (((arg1[5]) as u128) * (x3 as u128));
  let x26: u128 = (((arg1[7]) as u128) * (x1 as u128));
  let x27: u128 = (((arg1[6]) as u128) * (x3 as u128));
  let x28: u128 = (((arg1[6]) as u128) * (x6 as u128));
  let x29: u128 = (((arg1[5]) as u128) * (x3 as u128));
  let x30: u128 = (((arg1[7]) as u128) * (x2 as u128));
  let x31: u128 = (((arg1[6]) as u128) * (x4 as u128));
  let x32: u128 = (((arg1[6]) as u128) * (x7 as u128));
  let x33: u128 = (((arg1[5]) as u128) * (x4 as u128));
  let x34: u128 = (((arg1[5]) as u128) * (x9 as u128));
  let x35: u128 = (((arg1[5]) as u128) * (x8 as u128));
  let x36: u128 = (((arg1[5]) as u128) * (x12 as u128));
  let x37: u128 = (((arg1[5]) as u128) * (x11 as u128));
  let x38: u128 = (((arg1[4]) as u128) * (x4 as u128));
  let x39: u128 = (((arg1[4]) as u128) * (x3 as u128));
  let x40: u128 = (((arg1[4]) as u128) * (x9 as u128));
  let x41: u128 = (((arg1[4]) as u128) * (x8 as u128));
  let x42: u128 = (((arg1[4]) as u128) * (x14 as u128));
  let x43: u128 = (((arg1[4]) as u128) * (x13 as u128));
  let x44: u128 = (((arg1[4]) as u128) * (x17 as u128));
  let x45: u128 = (((arg1[4]) as u128) * (x16 as u128));
  let x46: u128 = (((arg1[3]) as u128) * (x4 as u128));
  let x47: u128 = (((arg1[3]) as u128) * (x3 as u128));
  let x48: u128 = (((arg1[3]) as u128) * (x9 as u128));
  let x49: u128 = (((arg1[3]) as u128) * (x8 as u128));
  let x50: u128 = (((arg1[3]) as u128) * (x14 as u128));
  let x51: u128 = (((arg1[3]) as u128) * (x13 as u128));
  let x52: u128 = (((arg1[3]) as u128) * (x18 as u128));
  let x53: u128 = (((arg1[3]) as u128) * ((arg1[3]) as u128));
  let x54: u128 = (((arg1[2]) as u128) * (x4 as u128));
  let x55: u128 = (((arg1[2]) as u128) * (x3 as u128));
  let x56: u128 = (((arg1[2]) as u128) * (x9 as u128));
  let x57: u128 = (((arg1[2]) as u128) * (x8 as u128));
  let x58: u128 = (((arg1[2]) as u128) * (x15 as u128));
  let x59: u128 = (((arg1[2]) as u128) * (x18 as u128));
  let x60: u128 = (((arg1[2]) as u128) * (x19 as u128));
  let x61: u128 = (((arg1[2]) as u128) * ((arg1[2]) as u128));
  let x62: u128 = (((arg1[1]) as u128) * (x4 as u128));
  let x63: u128 = (((arg1[1]) as u128) * (x3 as u128));
  let x64: u128 = (((arg1[1]) as u128) * (x10 as u128));
  let x65: u128 = (((arg1[1]) as u128) * (x15 as u128));
  let x66: u128 = (((arg1[1]) as u128) * (x18 as u128));
  let x67: u128 = (((arg1[1]) as u128) * (x19 as u128));
  let x68: u128 = (((arg1[1]) as u128) * (x20 as u128));
  let x69: u128 = (((arg1[1]) as u128) * ((arg1[1]) as u128));
  let x70: u128 = (((arg1[0]) as u128) * (x5 as u128));
  let x71: u128 = (((arg1[0]) as u128) * (x10 as u128));
  let x72: u128 = (((arg1[0]) as u128) * (x15 as u128));
  let x73: u128 = (((arg1[0]) as u128) * (x18 as u128));
  let x74: u128 = (((arg1[0]) as u128) * (x19 as u128));
  let x75: u128 = (((arg1[0]) as u128) * (x20 as u128));
  let x76: u128 = (((arg1[0]) as u128) * (x21 as u128));
  let x77: u128 = (((arg1[0]) as u128) * ((arg1[0]) as u128));
  let x78: u128 = (x74 + (x68 + (x38 + x34)));
  let x79: u64 = ((x78 >> 56) as u64);
  let x80: u64 = ((x78 & (0xffffffffffffff as u128)) as u64);
  let x81: u128 = (x70 + (x64 + (x58 + (x52 + (x39 + x35)))));
  let x82: u128 = (x71 + (x65 + (x59 + (x53 + (x47 + (x41 + (x37 + (x30 + x26))))))));
  let x83: u128 = (x72 + (x66 + (x60 + (x55 + (x49 + (x43 + (x31 + x27)))))));
  let x84: u128 = (x73 + (x67 + (x63 + (x61 + (x57 + (x51 + (x45 + (x33 + (x32 + (x29 + x28))))))))));
  let x85: u128 = (x75 + (x69 + (x46 + (x40 + (x36 + x22)))));
  let x86: u128 = (x76 + (x54 + (x48 + (x42 + x23))));
  let x87: u128 = (x77 + (x62 + (x56 + (x50 + (x44 + (x25 + x24))))));
  let x88: u128 = ((x79 as u128) + x84);
  let x89: u64 = ((x81 >> 56) as u64);
  let x90: u64 = ((x81 & (0xffffffffffffff as u128)) as u64);
  let x91: u128 = (x88 + (x89 as u128));
  let x92: u64 = ((x91 >> 56) as u64);
  let x93: u64 = ((x91 & (0xffffffffffffff as u128)) as u64);
  let x94: u128 = (x87 + (x89 as u128));
  let x95: u128 = ((x92 as u128) + x83);
  let x96: u64 = ((x94 >> 56) as u64);
  let x97: u64 = ((x94 & (0xffffffffffffff as u128)) as u64);
  let x98: u128 = ((x96 as u128) + x86);
  let x99: u64 = ((x95 >> 56) as u64);
  let x100: u64 = ((x95 & (0xffffffffffffff as u128)) as u64);
  let x101: u128 = ((x99 as u128) + x82);
  let x102: u64 = ((x98 >> 56) as u64);
  let x103: u64 = ((x98 & (0xffffffffffffff as u128)) as u64);
  let x104: u128 = ((x102 as u128) + x85);
  let x105: u64 = ((x101 >> 56) as u64);
  let x106: u64 = ((x101 & (0xffffffffffffff as u128)) as u64);
  let x107: u64 = (x105 + x90);
  let x108: u64 = ((x104 >> 56) as u64);
  let x109: u64 = ((x104 & (0xffffffffffffff as u128)) as u64);
  let x110: u64 = (x108 + x80);
  let x111: u64 = (x107 >> 56);
  let x112: u64 = (x107 & 0xffffffffffffff);
  let x113: u64 = (x110 >> 56);
  let x114: u64 = (x110 & 0xffffffffffffff);
  let x115: u64 = (x93 + x111);
  let x116: u64 = (x97 + x111);
  let x117: u64 = (x113 + x115);
  let x118: fiat_p448_u1 = ((x117 >> 56) as fiat_p448_u1);
  let x119: u64 = (x117 & 0xffffffffffffff);
  let x120: u64 = ((x118 as u64) + x100);
  let x121: fiat_p448_u1 = ((x116 >> 56) as fiat_p448_u1);
  let x122: u64 = (x116 & 0xffffffffffffff);
  let x123: u64 = ((x121 as u64) + x103);
  out1[0] = x122;
  out1[1] = x123;
  out1[2] = x109;
  out1[3] = x114;
  out1[4] = x119;
  out1[5] = x120;
  out1[6] = x106;
  out1[7] = x112;
}

/// The function fiat_p448_carry reduces a field element.
///
/// Postconditions:
///   eval out1 mod m = eval arg1 mod m
///
#[inline]
pub fn fiat_p448_carry(out1: &mut fiat_p448_tight_field_element, arg1: &fiat_p448_loose_field_element) -> () {
  let x1: u64 = (arg1[3]);
  let x2: u64 = (arg1[7]);
  let x3: u64 = (x2 >> 56);
  let x4: u64 = (((x1 >> 56) + (arg1[4])) + x3);
  let x5: u64 = ((arg1[0]) + x3);
  let x6: u64 = ((x4 >> 56) + (arg1[5]));
  let x7: u64 = ((x5 >> 56) + (arg1[1]));
  let x8: u64 = ((x6 >> 56) + (arg1[6]));
  let x9: u64 = ((x7 >> 56) + (arg1[2]));
  let x10: u64 = ((x8 >> 56) + (x2 & 0xffffffffffffff));
  let x11: u64 = ((x9 >> 56) + (x1 & 0xffffffffffffff));
  let x12: fiat_p448_u1 = ((x10 >> 56) as fiat_p448_u1);
  let x13: u64 = ((x5 & 0xffffffffffffff) + (x12 as u64));
  let x14: u64 = ((((x11 >> 56) as fiat_p448_u1) as u64) + ((x4 & 0xffffffffffffff) + (x12 as u64)));
  let x15: u64 = (x13 & 0xffffffffffffff);
  let x16: u64 = ((((x13 >> 56) as fiat_p448_u1) as u64) + (x7 & 0xffffffffffffff));
  let x17: u64 = (x9 & 0xffffffffffffff);
  let x18: u64 = (x11 & 0xffffffffffffff);
  let x19: u64 = (x14 & 0xffffffffffffff);
  let x20: u64 = ((((x14 >> 56) as fiat_p448_u1) as u64) + (x6 & 0xffffffffffffff));
  let x21: u64 = (x8 & 0xffffffffffffff);
  let x22: u64 = (x10 & 0xffffffffffffff);
  out1[0] = x15;
  out1[1] = x16;
  out1[2] = x17;
  out1[3] = x18;
  out1[4] = x19;
  out1[5] = x20;
  out1[6] = x21;
  out1[7] = x22;
}

/// The function fiat_p448_add adds two field elements.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 + eval arg2) mod m
///
#[inline]
pub fn fiat_p448_add(out1: &mut fiat_p448_loose_field_element, arg1: &fiat_p448_tight_field_element, arg2: &fiat_p448_tight_field_element) -> () {
  let x1: u64 = ((arg1[0]) + (arg2[0]));
  let x2: u64 = ((arg1[1]) + (arg2[1]));
  let x3: u64 = ((arg1[2]) + (arg2[2]));
  let x4: u64 = ((arg1[3]) + (arg2[3]));
  let x5: u64 = ((arg1[4]) + (arg2[4]));
  let x6: u64 = ((arg1[5]) + (arg2[5]));
  let x7: u64 = ((arg1[6]) + (arg2[6]));
  let x8: u64 = ((arg1[7]) + (arg2[7]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
}

/// The function fiat_p448_sub subtracts two field elements.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 - eval arg2) mod m
///
#[inline]
pub fn fiat_p448_sub(out1: &mut fiat_p448_loose_field_element, arg1: &fiat_p448_tight_field_element, arg2: &fiat_p448_tight_field_element) -> () {
  let x1: u64 = ((0x1fffffffffffffe + (arg1[0])) - (arg2[0]));
  let x2: u64 = ((0x1fffffffffffffe + (arg1[1])) - (arg2[1]));
  let x3: u64 = ((0x1fffffffffffffe + (arg1[2])) - (arg2[2]));
  let x4: u64 = ((0x1fffffffffffffe + (arg1[3])) - (arg2[3]));
  let x5: u64 = ((0x1fffffffffffffc + (arg1[4])) - (arg2[4]));
  let x6: u64 = ((0x1fffffffffffffe + (arg1[5])) - (arg2[5]));
  let x7: u64 = ((0x1fffffffffffffe + (arg1[6])) - (arg2[6]));
  let x8: u64 = ((0x1fffffffffffffe + (arg1[7])) - (arg2[7]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
}

/// The function fiat_p448_opp negates a field element.
///
/// Postconditions:
///   eval out1 mod m = -eval arg1 mod m
///
#[inline]
pub fn fiat_p448_opp(out1: &mut fiat_p448_loose_field_element, arg1: &fiat_p448_tight_field_element) -> () {
  let x1: u64 = (0x1fffffffffffffe - (arg1[0]));
  let x2: u64 = (0x1fffffffffffffe - (arg1[1]));
  let x3: u64 = (0x1fffffffffffffe - (arg1[2]));
  let x4: u64 = (0x1fffffffffffffe - (arg1[3]));
  let x5: u64 = (0x1fffffffffffffc - (arg1[4]));
  let x6: u64 = (0x1fffffffffffffe - (arg1[5]));
  let x7: u64 = (0x1fffffffffffffe - (arg1[6]));
  let x8: u64 = (0x1fffffffffffffe - (arg1[7]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
}

/// The function fiat_p448_selectznz is a multi-limb conditional select.
///
/// Postconditions:
///   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub fn fiat_p448_selectznz(out1: &mut [u64; 8], arg1: fiat_p448_u1, arg2: &[u64; 8], arg3: &[u64; 8]) -> () {
  let mut x1: u64 = 0;
  fiat_p448_cmovznz_u64(&mut x1, arg1, (arg2[0]), (arg3[0]));
  let mut x2: u64 = 0;
  fiat_p448_cmovznz_u64(&mut x2, arg1, (arg2[1]), (arg3[1]));
  let mut x3: u64 = 0;
  fiat_p448_cmovznz_u64(&mut x3, arg1, (arg2[2]), (arg3[2]));
  let mut x4: u64 = 0;
  fiat_p448_cmovznz_u64(&mut x4, arg1, (arg2[3]), (arg3[3]));
  let mut x5: u64 = 0;
  fiat_p448_cmovznz_u64(&mut x5, arg1, (arg2[4]), (arg3[4]));
  let mut x6: u64 = 0;
  fiat_p448_cmovznz_u64(&mut x6, arg1, (arg2[5]), (arg3[5]));
  let mut x7: u64 = 0;
  fiat_p448_cmovznz_u64(&mut x7, arg1, (arg2[6]), (arg3[6]));
  let mut x8: u64 = 0;
  fiat_p448_cmovznz_u64(&mut x8, arg1, (arg2[7]), (arg3[7]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
}

/// The function fiat_p448_to_bytes serializes a field element to bytes in little-endian order.
///
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..55]
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
#[inline]
pub fn fiat_p448_to_bytes(out1: &mut [u8; 56], arg1: &fiat_p448_tight_field_element) -> () {
  let mut x1: u64 = 0;
  let mut x2: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u56(&mut x1, &mut x2, 0x0, (arg1[0]), 0xffffffffffffff);
  let mut x3: u64 = 0;
  let mut x4: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u56(&mut x3, &mut x4, x2, (arg1[1]), 0xffffffffffffff);
  let mut x5: u64 = 0;
  let mut x6: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u56(&mut x5, &mut x6, x4, (arg1[2]), 0xffffffffffffff);
  let mut x7: u64 = 0;
  let mut x8: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u56(&mut x7, &mut x8, x6, (arg1[3]), 0xffffffffffffff);
  let mut x9: u64 = 0;
  let mut x10: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u56(&mut x9, &mut x10, x8, (arg1[4]), 0xfffffffffffffe);
  let mut x11: u64 = 0;
  let mut x12: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u56(&mut x11, &mut x12, x10, (arg1[5]), 0xffffffffffffff);
  let mut x13: u64 = 0;
  let mut x14: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u56(&mut x13, &mut x14, x12, (arg1[6]), 0xffffffffffffff);
  let mut x15: u64 = 0;
  let mut x16: fiat_p448_u1 = 0;
  fiat_p448_subborrowx_u56(&mut x15, &mut x16, x14, (arg1[7]), 0xffffffffffffff);
  let mut x17: u64 = 0;
  fiat_p448_cmovznz_u64(&mut x17, x16, (0x0 as u64), 0xffffffffffffffff);
  let mut x18: u64 = 0;
  let mut x19: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u56(&mut x18, &mut x19, 0x0, x1, (x17 & 0xffffffffffffff));
  let mut x20: u64 = 0;
  let mut x21: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u56(&mut x20, &mut x21, x19, x3, (x17 & 0xffffffffffffff));
  let mut x22: u64 = 0;
  let mut x23: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u56(&mut x22, &mut x23, x21, x5, (x17 & 0xffffffffffffff));
  let mut x24: u64 = 0;
  let mut x25: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u56(&mut x24, &mut x25, x23, x7, (x17 & 0xffffffffffffff));
  let mut x26: u64 = 0;
  let mut x27: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u56(&mut x26, &mut x27, x25, x9, (x17 & 0xfffffffffffffe));
  let mut x28: u64 = 0;
  let mut x29: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u56(&mut x28, &mut x29, x27, x11, (x17 & 0xffffffffffffff));
  let mut x30: u64 = 0;
  let mut x31: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u56(&mut x30, &mut x31, x29, x13, (x17 & 0xffffffffffffff));
  let mut x32: u64 = 0;
  let mut x33: fiat_p448_u1 = 0;
  fiat_p448_addcarryx_u56(&mut x32, &mut x33, x31, x15, (x17 & 0xffffffffffffff));
  let x34: u8 = ((x18 & (0xff as u64)) as u8);
  let x35: u64 = (x18 >> 8);
  let x36: u8 = ((x35 & (0xff as u64)) as u8);
  let x37: u64 = (x35 >> 8);
  let x38: u8 = ((x37 & (0xff as u64)) as u8);
  let x39: u64 = (x37 >> 8);
  let x40: u8 = ((x39 & (0xff as u64)) as u8);
  let x41: u64 = (x39 >> 8);
  let x42: u8 = ((x41 & (0xff as u64)) as u8);
  let x43: u64 = (x41 >> 8);
  let x44: u8 = ((x43 & (0xff as u64)) as u8);
  let x45: u8 = ((x43 >> 8) as u8);
  let x46: u8 = ((x20 & (0xff as u64)) as u8);
  let x47: u64 = (x20 >> 8);
  let x48: u8 = ((x47 & (0xff as u64)) as u8);
  let x49: u64 = (x47 >> 8);
  let x50: u8 = ((x49 & (0xff as u64)) as u8);
  let x51: u64 = (x49 >> 8);
  let x52: u8 = ((x51 & (0xff as u64)) as u8);
  let x53: u64 = (x51 >> 8);
  let x54: u8 = ((x53 & (0xff as u64)) as u8);
  let x55: u64 = (x53 >> 8);
  let x56: u8 = ((x55 & (0xff as u64)) as u8);
  let x57: u8 = ((x55 >> 8) as u8);
  let x58: u8 = ((x22 & (0xff as u64)) as u8);
  let x59: u64 = (x22 >> 8);
  let x60: u8 = ((x59 & (0xff as u64)) as u8);
  let x61: u64 = (x59 >> 8);
  let x62: u8 = ((x61 & (0xff as u64)) as u8);
  let x63: u64 = (x61 >> 8);
  let x64: u8 = ((x63 & (0xff as u64)) as u8);
  let x65: u64 = (x63 >> 8);
  let x66: u8 = ((x65 & (0xff as u64)) as u8);
  let x67: u64 = (x65 >> 8);
  let x68: u8 = ((x67 & (0xff as u64)) as u8);
  let x69: u8 = ((x67 >> 8) as u8);
  let x70: u8 = ((x24 & (0xff as u64)) as u8);
  let x71: u64 = (x24 >> 8);
  let x72: u8 = ((x71 & (0xff as u64)) as u8);
  let x73: u64 = (x71 >> 8);
  let x74: u8 = ((x73 & (0xff as u64)) as u8);
  let x75: u64 = (x73 >> 8);
  let x76: u8 = ((x75 & (0xff as u64)) as u8);
  let x77: u64 = (x75 >> 8);
  let x78: u8 = ((x77 & (0xff as u64)) as u8);
  let x79: u64 = (x77 >> 8);
  let x80: u8 = ((x79 & (0xff as u64)) as u8);
  let x81: u8 = ((x79 >> 8) as u8);
  let x82: u8 = ((x26 & (0xff as u64)) as u8);
  let x83: u64 = (x26 >> 8);
  let x84: u8 = ((x83 & (0xff as u64)) as u8);
  let x85: u64 = (x83 >> 8);
  let x86: u8 = ((x85 & (0xff as u64)) as u8);
  let x87: u64 = (x85 >> 8);
  let x88: u8 = ((x87 & (0xff as u64)) as u8);
  let x89: u64 = (x87 >> 8);
  let x90: u8 = ((x89 & (0xff as u64)) as u8);
  let x91: u64 = (x89 >> 8);
  let x92: u8 = ((x91 & (0xff as u64)) as u8);
  let x93: u8 = ((x91 >> 8) as u8);
  let x94: u8 = ((x28 & (0xff as u64)) as u8);
  let x95: u64 = (x28 >> 8);
  let x96: u8 = ((x95 & (0xff as u64)) as u8);
  let x97: u64 = (x95 >> 8);
  let x98: u8 = ((x97 & (0xff as u64)) as u8);
  let x99: u64 = (x97 >> 8);
  let x100: u8 = ((x99 & (0xff as u64)) as u8);
  let x101: u64 = (x99 >> 8);
  let x102: u8 = ((x101 & (0xff as u64)) as u8);
  let x103: u64 = (x101 >> 8);
  let x104: u8 = ((x103 & (0xff as u64)) as u8);
  let x105: u8 = ((x103 >> 8) as u8);
  let x106: u8 = ((x30 & (0xff as u64)) as u8);
  let x107: u64 = (x30 >> 8);
  let x108: u8 = ((x107 & (0xff as u64)) as u8);
  let x109: u64 = (x107 >> 8);
  let x110: u8 = ((x109 & (0xff as u64)) as u8);
  let x111: u64 = (x109 >> 8);
  let x112: u8 = ((x111 & (0xff as u64)) as u8);
  let x113: u64 = (x111 >> 8);
  let x114: u8 = ((x113 & (0xff as u64)) as u8);
  let x115: u64 = (x113 >> 8);
  let x116: u8 = ((x115 & (0xff as u64)) as u8);
  let x117: u8 = ((x115 >> 8) as u8);
  let x118: u8 = ((x32 & (0xff as u64)) as u8);
  let x119: u64 = (x32 >> 8);
  let x120: u8 = ((x119 & (0xff as u64)) as u8);
  let x121: u64 = (x119 >> 8);
  let x122: u8 = ((x121 & (0xff as u64)) as u8);
  let x123: u64 = (x121 >> 8);
  let x124: u8 = ((x123 & (0xff as u64)) as u8);
  let x125: u64 = (x123 >> 8);
  let x126: u8 = ((x125 & (0xff as u64)) as u8);
  let x127: u64 = (x125 >> 8);
  let x128: u8 = ((x127 & (0xff as u64)) as u8);
  let x129: u8 = ((x127 >> 8) as u8);
  out1[0] = x34;
  out1[1] = x36;
  out1[2] = x38;
  out1[3] = x40;
  out1[4] = x42;
  out1[5] = x44;
  out1[6] = x45;
  out1[7] = x46;
  out1[8] = x48;
  out1[9] = x50;
  out1[10] = x52;
  out1[11] = x54;
  out1[12] = x56;
  out1[13] = x57;
  out1[14] = x58;
  out1[15] = x60;
  out1[16] = x62;
  out1[17] = x64;
  out1[18] = x66;
  out1[19] = x68;
  out1[20] = x69;
  out1[21] = x70;
  out1[22] = x72;
  out1[23] = x74;
  out1[24] = x76;
  out1[25] = x78;
  out1[26] = x80;
  out1[27] = x81;
  out1[28] = x82;
  out1[29] = x84;
  out1[30] = x86;
  out1[31] = x88;
  out1[32] = x90;
  out1[33] = x92;
  out1[34] = x93;
  out1[35] = x94;
  out1[36] = x96;
  out1[37] = x98;
  out1[38] = x100;
  out1[39] = x102;
  out1[40] = x104;
  out1[41] = x105;
  out1[42] = x106;
  out1[43] = x108;
  out1[44] = x110;
  out1[45] = x112;
  out1[46] = x114;
  out1[47] = x116;
  out1[48] = x117;
  out1[49] = x118;
  out1[50] = x120;
  out1[51] = x122;
  out1[52] = x124;
  out1[53] = x126;
  out1[54] = x128;
  out1[55] = x129;
}

/// The function fiat_p448_from_bytes deserializes a field element from bytes in little-endian order.
///
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
#[inline]
pub fn fiat_p448_from_bytes(out1: &mut fiat_p448_tight_field_element, arg1: &[u8; 56]) -> () {
  let x1: u64 = (((arg1[55]) as u64) << 48);
  let x2: u64 = (((arg1[54]) as u64) << 40);
  let x3: u64 = (((arg1[53]) as u64) << 32);
  let x4: u64 = (((arg1[52]) as u64) << 24);
  let x5: u64 = (((arg1[51]) as u64) << 16);
  let x6: u64 = (((arg1[50]) as u64) << 8);
  let x7: u8 = (arg1[49]);
  let x8: u64 = (((arg1[48]) as u64) << 48);
  let x9: u64 = (((arg1[47]) as u64) << 40);
  let x10: u64 = (((arg1[46]) as u64) << 32);
  let x11: u64 = (((arg1[45]) as u64) << 24);
  let x12: u64 = (((arg1[44]) as u64) << 16);
  let x13: u64 = (((arg1[43]) as u64) << 8);
  let x14: u8 = (arg1[42]);
  let x15: u64 = (((arg1[41]) as u64) << 48);
  let x16: u64 = (((arg1[40]) as u64) << 40);
  let x17: u64 = (((arg1[39]) as u64) << 32);
  let x18: u64 = (((arg1[38]) as u64) << 24);
  let x19: u64 = (((arg1[37]) as u64) << 16);
  let x20: u64 = (((arg1[36]) as u64) << 8);
  let x21: u8 = (arg1[35]);
  let x22: u64 = (((arg1[34]) as u64) << 48);
  let x23: u64 = (((arg1[33]) as u64) << 40);
  let x24: u64 = (((arg1[32]) as u64) << 32);
  let x25: u64 = (((arg1[31]) as u64) << 24);
  let x26: u64 = (((arg1[30]) as u64) << 16);
  let x27: u64 = (((arg1[29]) as u64) << 8);
  let x28: u8 = (arg1[28]);
  let x29: u64 = (((arg1[27]) as u64) << 48);
  let x30: u64 = (((arg1[26]) as u64) << 40);
  let x31: u64 = (((arg1[25]) as u64) << 32);
  let x32: u64 = (((arg1[24]) as u64) << 24);
  let x33: u64 = (((arg1[23]) as u64) << 16);
  let x34: u64 = (((arg1[22]) as u64) << 8);
  let x35: u8 = (arg1[21]);
  let x36: u64 = (((arg1[20]) as u64) << 48);
  let x37: u64 = (((arg1[19]) as u64) << 40);
  let x38: u64 = (((arg1[18]) as u64) << 32);
  let x39: u64 = (((arg1[17]) as u64) << 24);
  let x40: u64 = (((arg1[16]) as u64) << 16);
  let x41: u64 = (((arg1[15]) as u64) << 8);
  let x42: u8 = (arg1[14]);
  let x43: u64 = (((arg1[13]) as u64) << 48);
  let x44: u64 = (((arg1[12]) as u64) << 40);
  let x45: u64 = (((arg1[11]) as u64) << 32);
  let x46: u64 = (((arg1[10]) as u64) << 24);
  let x47: u64 = (((arg1[9]) as u64) << 16);
  let x48: u64 = (((arg1[8]) as u64) << 8);
  let x49: u8 = (arg1[7]);
  let x50: u64 = (((arg1[6]) as u64) << 48);
  let x51: u64 = (((arg1[5]) as u64) << 40);
  let x52: u64 = (((arg1[4]) as u64) << 32);
  let x53: u64 = (((arg1[3]) as u64) << 24);
  let x54: u64 = (((arg1[2]) as u64) << 16);
  let x55: u64 = (((arg1[1]) as u64) << 8);
  let x56: u8 = (arg1[0]);
  let x57: u64 = (x55 + (x56 as u64));
  let x58: u64 = (x54 + x57);
  let x59: u64 = (x53 + x58);
  let x60: u64 = (x52 + x59);
  let x61: u64 = (x51 + x60);
  let x62: u64 = (x50 + x61);
  let x63: u64 = (x48 + (x49 as u64));
  let x64: u64 = (x47 + x63);
  let x65: u64 = (x46 + x64);
  let x66: u64 = (x45 + x65);
  let x67: u64 = (x44 + x66);
  let x68: u64 = (x43 + x67);
  let x69: u64 = (x41 + (x42 as u64));
  let x70: u64 = (x40 + x69);
  let x71: u64 = (x39 + x70);
  let x72: u64 = (x38 + x71);
  let x73: u64 = (x37 + x72);
  let x74: u64 = (x36 + x73);
  let x75: u64 = (x34 + (x35 as u64));
  let x76: u64 = (x33 + x75);
  let x77: u64 = (x32 + x76);
  let x78: u64 = (x31 + x77);
  let x79: u64 = (x30 + x78);
  let x80: u64 = (x29 + x79);
  let x81: u64 = (x27 + (x28 as u64));
  let x82: u64 = (x26 + x81);
  let x83: u64 = (x25 + x82);
  let x84: u64 = (x24 + x83);
  let x85: u64 = (x23 + x84);
  let x86: u64 = (x22 + x85);
  let x87: u64 = (x20 + (x21 as u64));
  let x88: u64 = (x19 + x87);
  let x89: u64 = (x18 + x88);
  let x90: u64 = (x17 + x89);
  let x91: u64 = (x16 + x90);
  let x92: u64 = (x15 + x91);
  let x93: u64 = (x13 + (x14 as u64));
  let x94: u64 = (x12 + x93);
  let x95: u64 = (x11 + x94);
  let x96: u64 = (x10 + x95);
  let x97: u64 = (x9 + x96);
  let x98: u64 = (x8 + x97);
  let x99: u64 = (x6 + (x7 as u64));
  let x100: u64 = (x5 + x99);
  let x101: u64 = (x4 + x100);
  let x102: u64 = (x3 + x101);
  let x103: u64 = (x2 + x102);
  let x104: u64 = (x1 + x103);
  out1[0] = x62;
  out1[1] = x68;
  out1[2] = x74;
  out1[3] = x80;
  out1[4] = x86;
  out1[5] = x92;
  out1[6] = x98;
  out1[7] = x104;
}

/// The function fiat_p448_relax is the identity function converting from tight field elements to loose field elements.
///
/// Postconditions:
///   out1 = arg1
///
#[inline]
pub fn fiat_p448_relax(out1: &mut fiat_p448_loose_field_element, arg1: &fiat_p448_tight_field_element) -> () {
  let x1: u64 = (arg1[0]);
  let x2: u64 = (arg1[1]);
  let x3: u64 = (arg1[2]);
  let x4: u64 = (arg1[3]);
  let x5: u64 = (arg1[4]);
  let x6: u64 = (arg1[5]);
  let x7: u64 = (arg1[6]);
  let x8: u64 = (arg1[7]);
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
}
