//! Autogenerated: 'src/ExtractionOCaml/unsaturated_solinas' --lang Rust --inline 25519 32 '(auto)' '2^255 - 19' carry_mul carry_square carry add sub opp selectznz to_bytes from_bytes relax carry_scmul121666
//! curve description: 25519
//! machine_wordsize = 32 (from "32")
//! requested operations: carry_mul, carry_square, carry, add, sub, opp, selectznz, to_bytes, from_bytes, relax, carry_scmul121666
//! n = 10 (from "(auto)")
//! s-c = 2^255 - [(1, 19)] (from "2^255 - 19")
//! tight_bounds_multiplier = 1 (from "")
//!
//! Computed values:
//!   carry_chain = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1]
//!   eval z = z[0] + (z[1] << 26) + (z[2] << 51) + (z[3] << 77) + (z[4] << 102) + (z[5] << 128) + (z[6] << 153) + (z[7] << 179) + (z[8] << 204) + (z[9] << 230)
//!   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248)
//!   balance = [0x7ffffda, 0x3fffffe, 0x7fffffe, 0x3fffffe, 0x7fffffe, 0x3fffffe, 0x7fffffe, 0x3fffffe, 0x7fffffe, 0x3fffffe]

#![allow(unused_parens)]
#[allow(non_camel_case_types)]

pub type fiat_25519_u1 = u8;
pub type fiat_25519_i1 = i8;
pub type fiat_25519_u2 = u8;
pub type fiat_25519_i2 = i8;

/* The type fiat_25519_loose_field_element is a field element with loose bounds. */
/* Bounds: [[0x0 ~> 0xc000000], [0x0 ~> 0x6000000], [0x0 ~> 0xc000000], [0x0 ~> 0x6000000], [0x0 ~> 0xc000000], [0x0 ~> 0x6000000], [0x0 ~> 0xc000000], [0x0 ~> 0x6000000], [0x0 ~> 0xc000000], [0x0 ~> 0x6000000]] */
pub type fiat_25519_loose_field_element = [u32; 10];

/* The type fiat_25519_tight_field_element is a field element with tight bounds. */
/* Bounds: [[0x0 ~> 0x4000000], [0x0 ~> 0x2000000], [0x0 ~> 0x4000000], [0x0 ~> 0x2000000], [0x0 ~> 0x4000000], [0x0 ~> 0x2000000], [0x0 ~> 0x4000000], [0x0 ~> 0x2000000], [0x0 ~> 0x4000000], [0x0 ~> 0x2000000]] */
pub type fiat_25519_tight_field_element = [u32; 10];


/// The function fiat_25519_addcarryx_u26 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^26
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^26⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0x3ffffff]
///   arg3: [0x0 ~> 0x3ffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0x3ffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_25519_addcarryx_u26(out1: &mut u32, out2: &mut fiat_25519_u1, arg1: fiat_25519_u1, arg2: u32, arg3: u32) -> () {
  let x1: u32 = (((arg1 as u32) + arg2) + arg3);
  let x2: u32 = (x1 & 0x3ffffff);
  let x3: fiat_25519_u1 = ((x1 >> 26) as fiat_25519_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_25519_subborrowx_u26 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^26
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^26⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0x3ffffff]
///   arg3: [0x0 ~> 0x3ffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0x3ffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_25519_subborrowx_u26(out1: &mut u32, out2: &mut fiat_25519_u1, arg1: fiat_25519_u1, arg2: u32, arg3: u32) -> () {
  let x1: i32 = ((((((arg2 as i64) - (arg1 as i64)) as i32) as i64) - (arg3 as i64)) as i32);
  let x2: fiat_25519_i1 = ((x1 >> 26) as fiat_25519_i1);
  let x3: u32 = (((x1 as i64) & (0x3ffffff as i64)) as u32);
  *out1 = x3;
  *out2 = (((0x0 as fiat_25519_i2) - (x2 as fiat_25519_i2)) as fiat_25519_u1);
}

/// The function fiat_25519_addcarryx_u25 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^25
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^25⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0x1ffffff]
///   arg3: [0x0 ~> 0x1ffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0x1ffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_25519_addcarryx_u25(out1: &mut u32, out2: &mut fiat_25519_u1, arg1: fiat_25519_u1, arg2: u32, arg3: u32) -> () {
  let x1: u32 = (((arg1 as u32) + arg2) + arg3);
  let x2: u32 = (x1 & 0x1ffffff);
  let x3: fiat_25519_u1 = ((x1 >> 25) as fiat_25519_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_25519_subborrowx_u25 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^25
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^25⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0x1ffffff]
///   arg3: [0x0 ~> 0x1ffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0x1ffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_25519_subborrowx_u25(out1: &mut u32, out2: &mut fiat_25519_u1, arg1: fiat_25519_u1, arg2: u32, arg3: u32) -> () {
  let x1: i32 = ((((((arg2 as i64) - (arg1 as i64)) as i32) as i64) - (arg3 as i64)) as i32);
  let x2: fiat_25519_i1 = ((x1 >> 25) as fiat_25519_i1);
  let x3: u32 = (((x1 as i64) & (0x1ffffff as i64)) as u32);
  *out1 = x3;
  *out2 = (((0x0 as fiat_25519_i2) - (x2 as fiat_25519_i2)) as fiat_25519_u1);
}

/// The function fiat_25519_cmovznz_u32 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_25519_cmovznz_u32(out1: &mut u32, arg1: fiat_25519_u1, arg2: u32, arg3: u32) -> () {
  let x1: fiat_25519_u1 = (!(!arg1));
  let x2: u32 = ((((((0x0 as fiat_25519_i2) - (x1 as fiat_25519_i2)) as fiat_25519_i1) as i64) & (0xffffffff as i64)) as u32);
  let x3: u32 = ((x2 & arg3) | ((!x2) & arg2));
  *out1 = x3;
}

/// The function fiat_25519_carry_mul multiplies two field elements and reduces the result.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 * eval arg2) mod m
///
#[inline]
pub fn fiat_25519_carry_mul(out1: &mut fiat_25519_tight_field_element, arg1: &fiat_25519_loose_field_element, arg2: &fiat_25519_loose_field_element) -> () {
  let x1: u64 = (((arg1[9]) as u64) * (((arg2[9]) * 0x26) as u64));
  let x2: u64 = (((arg1[9]) as u64) * (((arg2[8]) * 0x13) as u64));
  let x3: u64 = (((arg1[9]) as u64) * (((arg2[7]) * 0x26) as u64));
  let x4: u64 = (((arg1[9]) as u64) * (((arg2[6]) * 0x13) as u64));
  let x5: u64 = (((arg1[9]) as u64) * (((arg2[5]) * 0x26) as u64));
  let x6: u64 = (((arg1[9]) as u64) * (((arg2[4]) * 0x13) as u64));
  let x7: u64 = (((arg1[9]) as u64) * (((arg2[3]) * 0x26) as u64));
  let x8: u64 = (((arg1[9]) as u64) * (((arg2[2]) * 0x13) as u64));
  let x9: u64 = (((arg1[9]) as u64) * (((arg2[1]) * 0x26) as u64));
  let x10: u64 = (((arg1[8]) as u64) * (((arg2[9]) * 0x13) as u64));
  let x11: u64 = (((arg1[8]) as u64) * (((arg2[8]) * 0x13) as u64));
  let x12: u64 = (((arg1[8]) as u64) * (((arg2[7]) * 0x13) as u64));
  let x13: u64 = (((arg1[8]) as u64) * (((arg2[6]) * 0x13) as u64));
  let x14: u64 = (((arg1[8]) as u64) * (((arg2[5]) * 0x13) as u64));
  let x15: u64 = (((arg1[8]) as u64) * (((arg2[4]) * 0x13) as u64));
  let x16: u64 = (((arg1[8]) as u64) * (((arg2[3]) * 0x13) as u64));
  let x17: u64 = (((arg1[8]) as u64) * (((arg2[2]) * 0x13) as u64));
  let x18: u64 = (((arg1[7]) as u64) * (((arg2[9]) * 0x26) as u64));
  let x19: u64 = (((arg1[7]) as u64) * (((arg2[8]) * 0x13) as u64));
  let x20: u64 = (((arg1[7]) as u64) * (((arg2[7]) * 0x26) as u64));
  let x21: u64 = (((arg1[7]) as u64) * (((arg2[6]) * 0x13) as u64));
  let x22: u64 = (((arg1[7]) as u64) * (((arg2[5]) * 0x26) as u64));
  let x23: u64 = (((arg1[7]) as u64) * (((arg2[4]) * 0x13) as u64));
  let x24: u64 = (((arg1[7]) as u64) * (((arg2[3]) * 0x26) as u64));
  let x25: u64 = (((arg1[6]) as u64) * (((arg2[9]) * 0x13) as u64));
  let x26: u64 = (((arg1[6]) as u64) * (((arg2[8]) * 0x13) as u64));
  let x27: u64 = (((arg1[6]) as u64) * (((arg2[7]) * 0x13) as u64));
  let x28: u64 = (((arg1[6]) as u64) * (((arg2[6]) * 0x13) as u64));
  let x29: u64 = (((arg1[6]) as u64) * (((arg2[5]) * 0x13) as u64));
  let x30: u64 = (((arg1[6]) as u64) * (((arg2[4]) * 0x13) as u64));
  let x31: u64 = (((arg1[5]) as u64) * (((arg2[9]) * 0x26) as u64));
  let x32: u64 = (((arg1[5]) as u64) * (((arg2[8]) * 0x13) as u64));
  let x33: u64 = (((arg1[5]) as u64) * (((arg2[7]) * 0x26) as u64));
  let x34: u64 = (((arg1[5]) as u64) * (((arg2[6]) * 0x13) as u64));
  let x35: u64 = (((arg1[5]) as u64) * (((arg2[5]) * 0x26) as u64));
  let x36: u64 = (((arg1[4]) as u64) * (((arg2[9]) * 0x13) as u64));
  let x37: u64 = (((arg1[4]) as u64) * (((arg2[8]) * 0x13) as u64));
  let x38: u64 = (((arg1[4]) as u64) * (((arg2[7]) * 0x13) as u64));
  let x39: u64 = (((arg1[4]) as u64) * (((arg2[6]) * 0x13) as u64));
  let x40: u64 = (((arg1[3]) as u64) * (((arg2[9]) * 0x26) as u64));
  let x41: u64 = (((arg1[3]) as u64) * (((arg2[8]) * 0x13) as u64));
  let x42: u64 = (((arg1[3]) as u64) * (((arg2[7]) * 0x26) as u64));
  let x43: u64 = (((arg1[2]) as u64) * (((arg2[9]) * 0x13) as u64));
  let x44: u64 = (((arg1[2]) as u64) * (((arg2[8]) * 0x13) as u64));
  let x45: u64 = (((arg1[1]) as u64) * (((arg2[9]) * 0x26) as u64));
  let x46: u64 = (((arg1[9]) as u64) * ((arg2[0]) as u64));
  let x47: u64 = (((arg1[8]) as u64) * ((arg2[1]) as u64));
  let x48: u64 = (((arg1[8]) as u64) * ((arg2[0]) as u64));
  let x49: u64 = (((arg1[7]) as u64) * ((arg2[2]) as u64));
  let x50: u64 = (((arg1[7]) as u64) * (((arg2[1]) * 0x2) as u64));
  let x51: u64 = (((arg1[7]) as u64) * ((arg2[0]) as u64));
  let x52: u64 = (((arg1[6]) as u64) * ((arg2[3]) as u64));
  let x53: u64 = (((arg1[6]) as u64) * ((arg2[2]) as u64));
  let x54: u64 = (((arg1[6]) as u64) * ((arg2[1]) as u64));
  let x55: u64 = (((arg1[6]) as u64) * ((arg2[0]) as u64));
  let x56: u64 = (((arg1[5]) as u64) * ((arg2[4]) as u64));
  let x57: u64 = (((arg1[5]) as u64) * (((arg2[3]) * 0x2) as u64));
  let x58: u64 = (((arg1[5]) as u64) * ((arg2[2]) as u64));
  let x59: u64 = (((arg1[5]) as u64) * (((arg2[1]) * 0x2) as u64));
  let x60: u64 = (((arg1[5]) as u64) * ((arg2[0]) as u64));
  let x61: u64 = (((arg1[4]) as u64) * ((arg2[5]) as u64));
  let x62: u64 = (((arg1[4]) as u64) * ((arg2[4]) as u64));
  let x63: u64 = (((arg1[4]) as u64) * ((arg2[3]) as u64));
  let x64: u64 = (((arg1[4]) as u64) * ((arg2[2]) as u64));
  let x65: u64 = (((arg1[4]) as u64) * ((arg2[1]) as u64));
  let x66: u64 = (((arg1[4]) as u64) * ((arg2[0]) as u64));
  let x67: u64 = (((arg1[3]) as u64) * ((arg2[6]) as u64));
  let x68: u64 = (((arg1[3]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x69: u64 = (((arg1[3]) as u64) * ((arg2[4]) as u64));
  let x70: u64 = (((arg1[3]) as u64) * (((arg2[3]) * 0x2) as u64));
  let x71: u64 = (((arg1[3]) as u64) * ((arg2[2]) as u64));
  let x72: u64 = (((arg1[3]) as u64) * (((arg2[1]) * 0x2) as u64));
  let x73: u64 = (((arg1[3]) as u64) * ((arg2[0]) as u64));
  let x74: u64 = (((arg1[2]) as u64) * ((arg2[7]) as u64));
  let x75: u64 = (((arg1[2]) as u64) * ((arg2[6]) as u64));
  let x76: u64 = (((arg1[2]) as u64) * ((arg2[5]) as u64));
  let x77: u64 = (((arg1[2]) as u64) * ((arg2[4]) as u64));
  let x78: u64 = (((arg1[2]) as u64) * ((arg2[3]) as u64));
  let x79: u64 = (((arg1[2]) as u64) * ((arg2[2]) as u64));
  let x80: u64 = (((arg1[2]) as u64) * ((arg2[1]) as u64));
  let x81: u64 = (((arg1[2]) as u64) * ((arg2[0]) as u64));
  let x82: u64 = (((arg1[1]) as u64) * ((arg2[8]) as u64));
  let x83: u64 = (((arg1[1]) as u64) * (((arg2[7]) * 0x2) as u64));
  let x84: u64 = (((arg1[1]) as u64) * ((arg2[6]) as u64));
  let x85: u64 = (((arg1[1]) as u64) * (((arg2[5]) * 0x2) as u64));
  let x86: u64 = (((arg1[1]) as u64) * ((arg2[4]) as u64));
  let x87: u64 = (((arg1[1]) as u64) * (((arg2[3]) * 0x2) as u64));
  let x88: u64 = (((arg1[1]) as u64) * ((arg2[2]) as u64));
  let x89: u64 = (((arg1[1]) as u64) * (((arg2[1]) * 0x2) as u64));
  let x90: u64 = (((arg1[1]) as u64) * ((arg2[0]) as u64));
  let x91: u64 = (((arg1[0]) as u64) * ((arg2[9]) as u64));
  let x92: u64 = (((arg1[0]) as u64) * ((arg2[8]) as u64));
  let x93: u64 = (((arg1[0]) as u64) * ((arg2[7]) as u64));
  let x94: u64 = (((arg1[0]) as u64) * ((arg2[6]) as u64));
  let x95: u64 = (((arg1[0]) as u64) * ((arg2[5]) as u64));
  let x96: u64 = (((arg1[0]) as u64) * ((arg2[4]) as u64));
  let x97: u64 = (((arg1[0]) as u64) * ((arg2[3]) as u64));
  let x98: u64 = (((arg1[0]) as u64) * ((arg2[2]) as u64));
  let x99: u64 = (((arg1[0]) as u64) * ((arg2[1]) as u64));
  let x100: u64 = (((arg1[0]) as u64) * ((arg2[0]) as u64));
  let x101: u64 = (x100 + (x45 + (x44 + (x42 + (x39 + (x35 + (x30 + (x24 + (x17 + x9)))))))));
  let x102: u64 = (x101 >> 26);
  let x103: u32 = ((x101 & (0x3ffffff as u64)) as u32);
  let x104: u64 = (x91 + (x82 + (x74 + (x67 + (x61 + (x56 + (x52 + (x49 + (x47 + x46)))))))));
  let x105: u64 = (x92 + (x83 + (x75 + (x68 + (x62 + (x57 + (x53 + (x50 + (x48 + x1)))))))));
  let x106: u64 = (x93 + (x84 + (x76 + (x69 + (x63 + (x58 + (x54 + (x51 + (x10 + x2)))))))));
  let x107: u64 = (x94 + (x85 + (x77 + (x70 + (x64 + (x59 + (x55 + (x18 + (x11 + x3)))))))));
  let x108: u64 = (x95 + (x86 + (x78 + (x71 + (x65 + (x60 + (x25 + (x19 + (x12 + x4)))))))));
  let x109: u64 = (x96 + (x87 + (x79 + (x72 + (x66 + (x31 + (x26 + (x20 + (x13 + x5)))))))));
  let x110: u64 = (x97 + (x88 + (x80 + (x73 + (x36 + (x32 + (x27 + (x21 + (x14 + x6)))))))));
  let x111: u64 = (x98 + (x89 + (x81 + (x40 + (x37 + (x33 + (x28 + (x22 + (x15 + x7)))))))));
  let x112: u64 = (x99 + (x90 + (x43 + (x41 + (x38 + (x34 + (x29 + (x23 + (x16 + x8)))))))));
  let x113: u64 = (x102 + x112);
  let x114: u64 = (x113 >> 25);
  let x115: u32 = ((x113 & (0x1ffffff as u64)) as u32);
  let x116: u64 = (x114 + x111);
  let x117: u64 = (x116 >> 26);
  let x118: u32 = ((x116 & (0x3ffffff as u64)) as u32);
  let x119: u64 = (x117 + x110);
  let x120: u64 = (x119 >> 25);
  let x121: u32 = ((x119 & (0x1ffffff as u64)) as u32);
  let x122: u64 = (x120 + x109);
  let x123: u64 = (x122 >> 26);
  let x124: u32 = ((x122 & (0x3ffffff as u64)) as u32);
  let x125: u64 = (x123 + x108);
  let x126: u64 = (x125 >> 25);
  let x127: u32 = ((x125 & (0x1ffffff as u64)) as u32);
  let x128: u64 = (x126 + x107);
  let x129: u64 = (x128 >> 26);
  let x130: u32 = ((x128 & (0x3ffffff as u64)) as u32);
  let x131: u64 = (x129 + x106);
  let x132: u64 = (x131 >> 25);
  let x133: u32 = ((x131 & (0x1ffffff as u64)) as u32);
  let x134: u64 = (x132 + x105);
  let x135: u64 = (x134 >> 26);
  let x136: u32 = ((x134 & (0x3ffffff as u64)) as u32);
  let x137: u64 = (x135 + x104);
  let x138: u64 = (x137 >> 25);
  let x139: u32 = ((x137 & (0x1ffffff as u64)) as u32);
  let x140: u64 = (x138 * (0x13 as u64));
  let x141: u64 = ((x103 as u64) + x140);
  let x142: u32 = ((x141 >> 26) as u32);
  let x143: u32 = ((x141 & (0x3ffffff as u64)) as u32);
  let x144: u32 = (x142 + x115);
  let x145: fiat_25519_u1 = ((x144 >> 25) as fiat_25519_u1);
  let x146: u32 = (x144 & 0x1ffffff);
  let x147: u32 = ((x145 as u32) + x118);
  out1[0] = x143;
  out1[1] = x146;
  out1[2] = x147;
  out1[3] = x121;
  out1[4] = x124;
  out1[5] = x127;
  out1[6] = x130;
  out1[7] = x133;
  out1[8] = x136;
  out1[9] = x139;
}

/// The function fiat_25519_carry_square squares a field element and reduces the result.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 * eval arg1) mod m
///
#[inline]
pub fn fiat_25519_carry_square(out1: &mut fiat_25519_tight_field_element, arg1: &fiat_25519_loose_field_element) -> () {
  let x1: u32 = ((arg1[9]) * 0x13);
  let x2: u32 = (x1 * 0x2);
  let x3: u32 = ((arg1[9]) * 0x2);
  let x4: u32 = ((arg1[8]) * 0x13);
  let x5: u64 = ((x4 as u64) * (0x2 as u64));
  let x6: u32 = ((arg1[8]) * 0x2);
  let x7: u32 = ((arg1[7]) * 0x13);
  let x8: u32 = (x7 * 0x2);
  let x9: u32 = ((arg1[7]) * 0x2);
  let x10: u32 = ((arg1[6]) * 0x13);
  let x11: u64 = ((x10 as u64) * (0x2 as u64));
  let x12: u32 = ((arg1[6]) * 0x2);
  let x13: u32 = ((arg1[5]) * 0x13);
  let x14: u32 = ((arg1[5]) * 0x2);
  let x15: u32 = ((arg1[4]) * 0x2);
  let x16: u32 = ((arg1[3]) * 0x2);
  let x17: u32 = ((arg1[2]) * 0x2);
  let x18: u32 = ((arg1[1]) * 0x2);
  let x19: u64 = (((arg1[9]) as u64) * ((x1 * 0x2) as u64));
  let x20: u64 = (((arg1[8]) as u64) * (x2 as u64));
  let x21: u64 = (((arg1[8]) as u64) * (x4 as u64));
  let x22: u64 = (((arg1[7]) as u64) * ((x2 as u64) * (0x2 as u64)));
  let x23: u64 = (((arg1[7]) as u64) * x5);
  let x24: u64 = (((arg1[7]) as u64) * ((x7 * 0x2) as u64));
  let x25: u64 = (((arg1[6]) as u64) * (x2 as u64));
  let x26: u64 = (((arg1[6]) as u64) * x5);
  let x27: u64 = (((arg1[6]) as u64) * (x8 as u64));
  let x28: u64 = (((arg1[6]) as u64) * (x10 as u64));
  let x29: u64 = (((arg1[5]) as u64) * ((x2 as u64) * (0x2 as u64)));
  let x30: u64 = (((arg1[5]) as u64) * x5);
  let x31: u64 = (((arg1[5]) as u64) * ((x8 as u64) * (0x2 as u64)));
  let x32: u64 = (((arg1[5]) as u64) * x11);
  let x33: u64 = (((arg1[5]) as u64) * ((x13 * 0x2) as u64));
  let x34: u64 = (((arg1[4]) as u64) * (x2 as u64));
  let x35: u64 = (((arg1[4]) as u64) * x5);
  let x36: u64 = (((arg1[4]) as u64) * (x8 as u64));
  let x37: u64 = (((arg1[4]) as u64) * x11);
  let x38: u64 = (((arg1[4]) as u64) * (x14 as u64));
  let x39: u64 = (((arg1[4]) as u64) * ((arg1[4]) as u64));
  let x40: u64 = (((arg1[3]) as u64) * ((x2 as u64) * (0x2 as u64)));
  let x41: u64 = (((arg1[3]) as u64) * x5);
  let x42: u64 = (((arg1[3]) as u64) * ((x8 as u64) * (0x2 as u64)));
  let x43: u64 = (((arg1[3]) as u64) * (x12 as u64));
  let x44: u64 = (((arg1[3]) as u64) * ((x14 * 0x2) as u64));
  let x45: u64 = (((arg1[3]) as u64) * (x15 as u64));
  let x46: u64 = (((arg1[3]) as u64) * (((arg1[3]) * 0x2) as u64));
  let x47: u64 = (((arg1[2]) as u64) * (x2 as u64));
  let x48: u64 = (((arg1[2]) as u64) * x5);
  let x49: u64 = (((arg1[2]) as u64) * (x9 as u64));
  let x50: u64 = (((arg1[2]) as u64) * (x12 as u64));
  let x51: u64 = (((arg1[2]) as u64) * (x14 as u64));
  let x52: u64 = (((arg1[2]) as u64) * (x15 as u64));
  let x53: u64 = (((arg1[2]) as u64) * (x16 as u64));
  let x54: u64 = (((arg1[2]) as u64) * ((arg1[2]) as u64));
  let x55: u64 = (((arg1[1]) as u64) * ((x2 as u64) * (0x2 as u64)));
  let x56: u64 = (((arg1[1]) as u64) * (x6 as u64));
  let x57: u64 = (((arg1[1]) as u64) * ((x9 * 0x2) as u64));
  let x58: u64 = (((arg1[1]) as u64) * (x12 as u64));
  let x59: u64 = (((arg1[1]) as u64) * ((x14 * 0x2) as u64));
  let x60: u64 = (((arg1[1]) as u64) * (x15 as u64));
  let x61: u64 = (((arg1[1]) as u64) * ((x16 * 0x2) as u64));
  let x62: u64 = (((arg1[1]) as u64) * (x17 as u64));
  let x63: u64 = (((arg1[1]) as u64) * (((arg1[1]) * 0x2) as u64));
  let x64: u64 = (((arg1[0]) as u64) * (x3 as u64));
  let x65: u64 = (((arg1[0]) as u64) * (x6 as u64));
  let x66: u64 = (((arg1[0]) as u64) * (x9 as u64));
  let x67: u64 = (((arg1[0]) as u64) * (x12 as u64));
  let x68: u64 = (((arg1[0]) as u64) * (x14 as u64));
  let x69: u64 = (((arg1[0]) as u64) * (x15 as u64));
  let x70: u64 = (((arg1[0]) as u64) * (x16 as u64));
  let x71: u64 = (((arg1[0]) as u64) * (x17 as u64));
  let x72: u64 = (((arg1[0]) as u64) * (x18 as u64));
  let x73: u64 = (((arg1[0]) as u64) * ((arg1[0]) as u64));
  let x74: u64 = (x73 + (x55 + (x48 + (x42 + (x37 + x33)))));
  let x75: u64 = (x74 >> 26);
  let x76: u32 = ((x74 & (0x3ffffff as u64)) as u32);
  let x77: u64 = (x64 + (x56 + (x49 + (x43 + x38))));
  let x78: u64 = (x65 + (x57 + (x50 + (x44 + (x39 + x19)))));
  let x79: u64 = (x66 + (x58 + (x51 + (x45 + x20))));
  let x80: u64 = (x67 + (x59 + (x52 + (x46 + (x22 + x21)))));
  let x81: u64 = (x68 + (x60 + (x53 + (x25 + x23))));
  let x82: u64 = (x69 + (x61 + (x54 + (x29 + (x26 + x24)))));
  let x83: u64 = (x70 + (x62 + (x34 + (x30 + x27))));
  let x84: u64 = (x71 + (x63 + (x40 + (x35 + (x31 + x28)))));
  let x85: u64 = (x72 + (x47 + (x41 + (x36 + x32))));
  let x86: u64 = (x75 + x85);
  let x87: u64 = (x86 >> 25);
  let x88: u32 = ((x86 & (0x1ffffff as u64)) as u32);
  let x89: u64 = (x87 + x84);
  let x90: u64 = (x89 >> 26);
  let x91: u32 = ((x89 & (0x3ffffff as u64)) as u32);
  let x92: u64 = (x90 + x83);
  let x93: u64 = (x92 >> 25);
  let x94: u32 = ((x92 & (0x1ffffff as u64)) as u32);
  let x95: u64 = (x93 + x82);
  let x96: u64 = (x95 >> 26);
  let x97: u32 = ((x95 & (0x3ffffff as u64)) as u32);
  let x98: u64 = (x96 + x81);
  let x99: u64 = (x98 >> 25);
  let x100: u32 = ((x98 & (0x1ffffff as u64)) as u32);
  let x101: u64 = (x99 + x80);
  let x102: u64 = (x101 >> 26);
  let x103: u32 = ((x101 & (0x3ffffff as u64)) as u32);
  let x104: u64 = (x102 + x79);
  let x105: u64 = (x104 >> 25);
  let x106: u32 = ((x104 & (0x1ffffff as u64)) as u32);
  let x107: u64 = (x105 + x78);
  let x108: u64 = (x107 >> 26);
  let x109: u32 = ((x107 & (0x3ffffff as u64)) as u32);
  let x110: u64 = (x108 + x77);
  let x111: u64 = (x110 >> 25);
  let x112: u32 = ((x110 & (0x1ffffff as u64)) as u32);
  let x113: u64 = (x111 * (0x13 as u64));
  let x114: u64 = ((x76 as u64) + x113);
  let x115: u32 = ((x114 >> 26) as u32);
  let x116: u32 = ((x114 & (0x3ffffff as u64)) as u32);
  let x117: u32 = (x115 + x88);
  let x118: fiat_25519_u1 = ((x117 >> 25) as fiat_25519_u1);
  let x119: u32 = (x117 & 0x1ffffff);
  let x120: u32 = ((x118 as u32) + x91);
  out1[0] = x116;
  out1[1] = x119;
  out1[2] = x120;
  out1[3] = x94;
  out1[4] = x97;
  out1[5] = x100;
  out1[6] = x103;
  out1[7] = x106;
  out1[8] = x109;
  out1[9] = x112;
}

/// The function fiat_25519_carry reduces a field element.
///
/// Postconditions:
///   eval out1 mod m = eval arg1 mod m
///
#[inline]
pub fn fiat_25519_carry(out1: &mut fiat_25519_tight_field_element, arg1: &fiat_25519_loose_field_element) -> () {
  let x1: u32 = (arg1[0]);
  let x2: u32 = ((x1 >> 26) + (arg1[1]));
  let x3: u32 = ((x2 >> 25) + (arg1[2]));
  let x4: u32 = ((x3 >> 26) + (arg1[3]));
  let x5: u32 = ((x4 >> 25) + (arg1[4]));
  let x6: u32 = ((x5 >> 26) + (arg1[5]));
  let x7: u32 = ((x6 >> 25) + (arg1[6]));
  let x8: u32 = ((x7 >> 26) + (arg1[7]));
  let x9: u32 = ((x8 >> 25) + (arg1[8]));
  let x10: u32 = ((x9 >> 26) + (arg1[9]));
  let x11: u32 = ((x1 & 0x3ffffff) + ((x10 >> 25) * 0x13));
  let x12: u32 = ((((x11 >> 26) as fiat_25519_u1) as u32) + (x2 & 0x1ffffff));
  let x13: u32 = (x11 & 0x3ffffff);
  let x14: u32 = (x12 & 0x1ffffff);
  let x15: u32 = ((((x12 >> 25) as fiat_25519_u1) as u32) + (x3 & 0x3ffffff));
  let x16: u32 = (x4 & 0x1ffffff);
  let x17: u32 = (x5 & 0x3ffffff);
  let x18: u32 = (x6 & 0x1ffffff);
  let x19: u32 = (x7 & 0x3ffffff);
  let x20: u32 = (x8 & 0x1ffffff);
  let x21: u32 = (x9 & 0x3ffffff);
  let x22: u32 = (x10 & 0x1ffffff);
  out1[0] = x13;
  out1[1] = x14;
  out1[2] = x15;
  out1[3] = x16;
  out1[4] = x17;
  out1[5] = x18;
  out1[6] = x19;
  out1[7] = x20;
  out1[8] = x21;
  out1[9] = x22;
}

/// The function fiat_25519_add adds two field elements.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 + eval arg2) mod m
///
#[inline]
pub fn fiat_25519_add(out1: &mut fiat_25519_loose_field_element, arg1: &fiat_25519_tight_field_element, arg2: &fiat_25519_tight_field_element) -> () {
  let x1: u32 = ((arg1[0]) + (arg2[0]));
  let x2: u32 = ((arg1[1]) + (arg2[1]));
  let x3: u32 = ((arg1[2]) + (arg2[2]));
  let x4: u32 = ((arg1[3]) + (arg2[3]));
  let x5: u32 = ((arg1[4]) + (arg2[4]));
  let x6: u32 = ((arg1[5]) + (arg2[5]));
  let x7: u32 = ((arg1[6]) + (arg2[6]));
  let x8: u32 = ((arg1[7]) + (arg2[7]));
  let x9: u32 = ((arg1[8]) + (arg2[8]));
  let x10: u32 = ((arg1[9]) + (arg2[9]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
}

/// The function fiat_25519_sub subtracts two field elements.
///
/// Postconditions:
///   eval out1 mod m = (eval arg1 - eval arg2) mod m
///
#[inline]
pub fn fiat_25519_sub(out1: &mut fiat_25519_loose_field_element, arg1: &fiat_25519_tight_field_element, arg2: &fiat_25519_tight_field_element) -> () {
  let x1: u32 = ((0x7ffffda + (arg1[0])) - (arg2[0]));
  let x2: u32 = ((0x3fffffe + (arg1[1])) - (arg2[1]));
  let x3: u32 = ((0x7fffffe + (arg1[2])) - (arg2[2]));
  let x4: u32 = ((0x3fffffe + (arg1[3])) - (arg2[3]));
  let x5: u32 = ((0x7fffffe + (arg1[4])) - (arg2[4]));
  let x6: u32 = ((0x3fffffe + (arg1[5])) - (arg2[5]));
  let x7: u32 = ((0x7fffffe + (arg1[6])) - (arg2[6]));
  let x8: u32 = ((0x3fffffe + (arg1[7])) - (arg2[7]));
  let x9: u32 = ((0x7fffffe + (arg1[8])) - (arg2[8]));
  let x10: u32 = ((0x3fffffe + (arg1[9])) - (arg2[9]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
}

/// The function fiat_25519_opp negates a field element.
///
/// Postconditions:
///   eval out1 mod m = -eval arg1 mod m
///
#[inline]
pub fn fiat_25519_opp(out1: &mut fiat_25519_loose_field_element, arg1: &fiat_25519_tight_field_element) -> () {
  let x1: u32 = (0x7ffffda - (arg1[0]));
  let x2: u32 = (0x3fffffe - (arg1[1]));
  let x3: u32 = (0x7fffffe - (arg1[2]));
  let x4: u32 = (0x3fffffe - (arg1[3]));
  let x5: u32 = (0x7fffffe - (arg1[4]));
  let x6: u32 = (0x3fffffe - (arg1[5]));
  let x7: u32 = (0x7fffffe - (arg1[6]));
  let x8: u32 = (0x3fffffe - (arg1[7]));
  let x9: u32 = (0x7fffffe - (arg1[8]));
  let x10: u32 = (0x3fffffe - (arg1[9]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
}

/// The function fiat_25519_selectznz is a multi-limb conditional select.
///
/// Postconditions:
///   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_25519_selectznz(out1: &mut [u32; 10], arg1: fiat_25519_u1, arg2: &[u32; 10], arg3: &[u32; 10]) -> () {
  let mut x1: u32 = 0;
  fiat_25519_cmovznz_u32(&mut x1, arg1, (arg2[0]), (arg3[0]));
  let mut x2: u32 = 0;
  fiat_25519_cmovznz_u32(&mut x2, arg1, (arg2[1]), (arg3[1]));
  let mut x3: u32 = 0;
  fiat_25519_cmovznz_u32(&mut x3, arg1, (arg2[2]), (arg3[2]));
  let mut x4: u32 = 0;
  fiat_25519_cmovznz_u32(&mut x4, arg1, (arg2[3]), (arg3[3]));
  let mut x5: u32 = 0;
  fiat_25519_cmovznz_u32(&mut x5, arg1, (arg2[4]), (arg3[4]));
  let mut x6: u32 = 0;
  fiat_25519_cmovznz_u32(&mut x6, arg1, (arg2[5]), (arg3[5]));
  let mut x7: u32 = 0;
  fiat_25519_cmovznz_u32(&mut x7, arg1, (arg2[6]), (arg3[6]));
  let mut x8: u32 = 0;
  fiat_25519_cmovznz_u32(&mut x8, arg1, (arg2[7]), (arg3[7]));
  let mut x9: u32 = 0;
  fiat_25519_cmovznz_u32(&mut x9, arg1, (arg2[8]), (arg3[8]));
  let mut x10: u32 = 0;
  fiat_25519_cmovznz_u32(&mut x10, arg1, (arg2[9]), (arg3[9]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
}

/// The function fiat_25519_to_bytes serializes a field element to bytes in little-endian order.
///
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x7f]]
#[inline]
pub fn fiat_25519_to_bytes(out1: &mut [u8; 32], arg1: &fiat_25519_tight_field_element) -> () {
  let mut x1: u32 = 0;
  let mut x2: fiat_25519_u1 = 0;
  fiat_25519_subborrowx_u26(&mut x1, &mut x2, 0x0, (arg1[0]), 0x3ffffed);
  let mut x3: u32 = 0;
  let mut x4: fiat_25519_u1 = 0;
  fiat_25519_subborrowx_u25(&mut x3, &mut x4, x2, (arg1[1]), 0x1ffffff);
  let mut x5: u32 = 0;
  let mut x6: fiat_25519_u1 = 0;
  fiat_25519_subborrowx_u26(&mut x5, &mut x6, x4, (arg1[2]), 0x3ffffff);
  let mut x7: u32 = 0;
  let mut x8: fiat_25519_u1 = 0;
  fiat_25519_subborrowx_u25(&mut x7, &mut x8, x6, (arg1[3]), 0x1ffffff);
  let mut x9: u32 = 0;
  let mut x10: fiat_25519_u1 = 0;
  fiat_25519_subborrowx_u26(&mut x9, &mut x10, x8, (arg1[4]), 0x3ffffff);
  let mut x11: u32 = 0;
  let mut x12: fiat_25519_u1 = 0;
  fiat_25519_subborrowx_u25(&mut x11, &mut x12, x10, (arg1[5]), 0x1ffffff);
  let mut x13: u32 = 0;
  let mut x14: fiat_25519_u1 = 0;
  fiat_25519_subborrowx_u26(&mut x13, &mut x14, x12, (arg1[6]), 0x3ffffff);
  let mut x15: u32 = 0;
  let mut x16: fiat_25519_u1 = 0;
  fiat_25519_subborrowx_u25(&mut x15, &mut x16, x14, (arg1[7]), 0x1ffffff);
  let mut x17: u32 = 0;
  let mut x18: fiat_25519_u1 = 0;
  fiat_25519_subborrowx_u26(&mut x17, &mut x18, x16, (arg1[8]), 0x3ffffff);
  let mut x19: u32 = 0;
  let mut x20: fiat_25519_u1 = 0;
  fiat_25519_subborrowx_u25(&mut x19, &mut x20, x18, (arg1[9]), 0x1ffffff);
  let mut x21: u32 = 0;
  fiat_25519_cmovznz_u32(&mut x21, x20, (0x0 as u32), 0xffffffff);
  let mut x22: u32 = 0;
  let mut x23: fiat_25519_u1 = 0;
  fiat_25519_addcarryx_u26(&mut x22, &mut x23, 0x0, x1, (x21 & 0x3ffffed));
  let mut x24: u32 = 0;
  let mut x25: fiat_25519_u1 = 0;
  fiat_25519_addcarryx_u25(&mut x24, &mut x25, x23, x3, (x21 & 0x1ffffff));
  let mut x26: u32 = 0;
  let mut x27: fiat_25519_u1 = 0;
  fiat_25519_addcarryx_u26(&mut x26, &mut x27, x25, x5, (x21 & 0x3ffffff));
  let mut x28: u32 = 0;
  let mut x29: fiat_25519_u1 = 0;
  fiat_25519_addcarryx_u25(&mut x28, &mut x29, x27, x7, (x21 & 0x1ffffff));
  let mut x30: u32 = 0;
  let mut x31: fiat_25519_u1 = 0;
  fiat_25519_addcarryx_u26(&mut x30, &mut x31, x29, x9, (x21 & 0x3ffffff));
  let mut x32: u32 = 0;
  let mut x33: fiat_25519_u1 = 0;
  fiat_25519_addcarryx_u25(&mut x32, &mut x33, x31, x11, (x21 & 0x1ffffff));
  let mut x34: u32 = 0;
  let mut x35: fiat_25519_u1 = 0;
  fiat_25519_addcarryx_u26(&mut x34, &mut x35, x33, x13, (x21 & 0x3ffffff));
  let mut x36: u32 = 0;
  let mut x37: fiat_25519_u1 = 0;
  fiat_25519_addcarryx_u25(&mut x36, &mut x37, x35, x15, (x21 & 0x1ffffff));
  let mut x38: u32 = 0;
  let mut x39: fiat_25519_u1 = 0;
  fiat_25519_addcarryx_u26(&mut x38, &mut x39, x37, x17, (x21 & 0x3ffffff));
  let mut x40: u32 = 0;
  let mut x41: fiat_25519_u1 = 0;
  fiat_25519_addcarryx_u25(&mut x40, &mut x41, x39, x19, (x21 & 0x1ffffff));
  let x42: u32 = (x40 << 6);
  let x43: u32 = (x38 << 4);
  let x44: u32 = (x36 << 3);
  let x45: u32 = (x34 * (0x2 as u32));
  let x46: u32 = (x30 << 6);
  let x47: u32 = (x28 << 5);
  let x48: u32 = (x26 << 3);
  let x49: u32 = (x24 << 2);
  let x50: u8 = ((x22 & (0xff as u32)) as u8);
  let x51: u32 = (x22 >> 8);
  let x52: u8 = ((x51 & (0xff as u32)) as u8);
  let x53: u32 = (x51 >> 8);
  let x54: u8 = ((x53 & (0xff as u32)) as u8);
  let x55: u8 = ((x53 >> 8) as u8);
  let x56: u32 = (x49 + (x55 as u32));
  let x57: u8 = ((x56 & (0xff as u32)) as u8);
  let x58: u32 = (x56 >> 8);
  let x59: u8 = ((x58 & (0xff as u32)) as u8);
  let x60: u32 = (x58 >> 8);
  let x61: u8 = ((x60 & (0xff as u32)) as u8);
  let x62: u8 = ((x60 >> 8) as u8);
  let x63: u32 = (x48 + (x62 as u32));
  let x64: u8 = ((x63 & (0xff as u32)) as u8);
  let x65: u32 = (x63 >> 8);
  let x66: u8 = ((x65 & (0xff as u32)) as u8);
  let x67: u32 = (x65 >> 8);
  let x68: u8 = ((x67 & (0xff as u32)) as u8);
  let x69: u8 = ((x67 >> 8) as u8);
  let x70: u32 = (x47 + (x69 as u32));
  let x71: u8 = ((x70 & (0xff as u32)) as u8);
  let x72: u32 = (x70 >> 8);
  let x73: u8 = ((x72 & (0xff as u32)) as u8);
  let x74: u32 = (x72 >> 8);
  let x75: u8 = ((x74 & (0xff as u32)) as u8);
  let x76: u8 = ((x74 >> 8) as u8);
  let x77: u32 = (x46 + (x76 as u32));
  let x78: u8 = ((x77 & (0xff as u32)) as u8);
  let x79: u32 = (x77 >> 8);
  let x80: u8 = ((x79 & (0xff as u32)) as u8);
  let x81: u32 = (x79 >> 8);
  let x82: u8 = ((x81 & (0xff as u32)) as u8);
  let x83: u8 = ((x81 >> 8) as u8);
  let x84: u8 = ((x32 & (0xff as u32)) as u8);
  let x85: u32 = (x32 >> 8);
  let x86: u8 = ((x85 & (0xff as u32)) as u8);
  let x87: u32 = (x85 >> 8);
  let x88: u8 = ((x87 & (0xff as u32)) as u8);
  let x89: fiat_25519_u1 = ((x87 >> 8) as fiat_25519_u1);
  let x90: u32 = (x45 + (x89 as u32));
  let x91: u8 = ((x90 & (0xff as u32)) as u8);
  let x92: u32 = (x90 >> 8);
  let x93: u8 = ((x92 & (0xff as u32)) as u8);
  let x94: u32 = (x92 >> 8);
  let x95: u8 = ((x94 & (0xff as u32)) as u8);
  let x96: u8 = ((x94 >> 8) as u8);
  let x97: u32 = (x44 + (x96 as u32));
  let x98: u8 = ((x97 & (0xff as u32)) as u8);
  let x99: u32 = (x97 >> 8);
  let x100: u8 = ((x99 & (0xff as u32)) as u8);
  let x101: u32 = (x99 >> 8);
  let x102: u8 = ((x101 & (0xff as u32)) as u8);
  let x103: u8 = ((x101 >> 8) as u8);
  let x104: u32 = (x43 + (x103 as u32));
  let x105: u8 = ((x104 & (0xff as u32)) as u8);
  let x106: u32 = (x104 >> 8);
  let x107: u8 = ((x106 & (0xff as u32)) as u8);
  let x108: u32 = (x106 >> 8);
  let x109: u8 = ((x108 & (0xff as u32)) as u8);
  let x110: u8 = ((x108 >> 8) as u8);
  let x111: u32 = (x42 + (x110 as u32));
  let x112: u8 = ((x111 & (0xff as u32)) as u8);
  let x113: u32 = (x111 >> 8);
  let x114: u8 = ((x113 & (0xff as u32)) as u8);
  let x115: u32 = (x113 >> 8);
  let x116: u8 = ((x115 & (0xff as u32)) as u8);
  let x117: u8 = ((x115 >> 8) as u8);
  out1[0] = x50;
  out1[1] = x52;
  out1[2] = x54;
  out1[3] = x57;
  out1[4] = x59;
  out1[5] = x61;
  out1[6] = x64;
  out1[7] = x66;
  out1[8] = x68;
  out1[9] = x71;
  out1[10] = x73;
  out1[11] = x75;
  out1[12] = x78;
  out1[13] = x80;
  out1[14] = x82;
  out1[15] = x83;
  out1[16] = x84;
  out1[17] = x86;
  out1[18] = x88;
  out1[19] = x91;
  out1[20] = x93;
  out1[21] = x95;
  out1[22] = x98;
  out1[23] = x100;
  out1[24] = x102;
  out1[25] = x105;
  out1[26] = x107;
  out1[27] = x109;
  out1[28] = x112;
  out1[29] = x114;
  out1[30] = x116;
  out1[31] = x117;
}

/// The function fiat_25519_from_bytes deserializes a field element from bytes in little-endian order.
///
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x7f]]
#[inline]
pub fn fiat_25519_from_bytes(out1: &mut fiat_25519_tight_field_element, arg1: &[u8; 32]) -> () {
  let x1: u32 = (((arg1[31]) as u32) << 18);
  let x2: u32 = (((arg1[30]) as u32) << 10);
  let x3: u32 = (((arg1[29]) as u32) << 2);
  let x4: u32 = (((arg1[28]) as u32) << 20);
  let x5: u32 = (((arg1[27]) as u32) << 12);
  let x6: u32 = (((arg1[26]) as u32) << 4);
  let x7: u32 = (((arg1[25]) as u32) << 21);
  let x8: u32 = (((arg1[24]) as u32) << 13);
  let x9: u32 = (((arg1[23]) as u32) << 5);
  let x10: u32 = (((arg1[22]) as u32) << 23);
  let x11: u32 = (((arg1[21]) as u32) << 15);
  let x12: u32 = (((arg1[20]) as u32) << 7);
  let x13: u32 = (((arg1[19]) as u32) << 24);
  let x14: u32 = (((arg1[18]) as u32) << 16);
  let x15: u32 = (((arg1[17]) as u32) << 8);
  let x16: u8 = (arg1[16]);
  let x17: u32 = (((arg1[15]) as u32) << 18);
  let x18: u32 = (((arg1[14]) as u32) << 10);
  let x19: u32 = (((arg1[13]) as u32) << 2);
  let x20: u32 = (((arg1[12]) as u32) << 19);
  let x21: u32 = (((arg1[11]) as u32) << 11);
  let x22: u32 = (((arg1[10]) as u32) << 3);
  let x23: u32 = (((arg1[9]) as u32) << 21);
  let x24: u32 = (((arg1[8]) as u32) << 13);
  let x25: u32 = (((arg1[7]) as u32) << 5);
  let x26: u32 = (((arg1[6]) as u32) << 22);
  let x27: u32 = (((arg1[5]) as u32) << 14);
  let x28: u32 = (((arg1[4]) as u32) << 6);
  let x29: u32 = (((arg1[3]) as u32) << 24);
  let x30: u32 = (((arg1[2]) as u32) << 16);
  let x31: u32 = (((arg1[1]) as u32) << 8);
  let x32: u8 = (arg1[0]);
  let x33: u32 = (x31 + (x32 as u32));
  let x34: u32 = (x30 + x33);
  let x35: u32 = (x29 + x34);
  let x36: u32 = (x35 & 0x3ffffff);
  let x37: u8 = ((x35 >> 26) as u8);
  let x38: u32 = (x28 + (x37 as u32));
  let x39: u32 = (x27 + x38);
  let x40: u32 = (x26 + x39);
  let x41: u32 = (x40 & 0x1ffffff);
  let x42: u8 = ((x40 >> 25) as u8);
  let x43: u32 = (x25 + (x42 as u32));
  let x44: u32 = (x24 + x43);
  let x45: u32 = (x23 + x44);
  let x46: u32 = (x45 & 0x3ffffff);
  let x47: u8 = ((x45 >> 26) as u8);
  let x48: u32 = (x22 + (x47 as u32));
  let x49: u32 = (x21 + x48);
  let x50: u32 = (x20 + x49);
  let x51: u32 = (x50 & 0x1ffffff);
  let x52: u8 = ((x50 >> 25) as u8);
  let x53: u32 = (x19 + (x52 as u32));
  let x54: u32 = (x18 + x53);
  let x55: u32 = (x17 + x54);
  let x56: u32 = (x15 + (x16 as u32));
  let x57: u32 = (x14 + x56);
  let x58: u32 = (x13 + x57);
  let x59: u32 = (x58 & 0x1ffffff);
  let x60: u8 = ((x58 >> 25) as u8);
  let x61: u32 = (x12 + (x60 as u32));
  let x62: u32 = (x11 + x61);
  let x63: u32 = (x10 + x62);
  let x64: u32 = (x63 & 0x3ffffff);
  let x65: u8 = ((x63 >> 26) as u8);
  let x66: u32 = (x9 + (x65 as u32));
  let x67: u32 = (x8 + x66);
  let x68: u32 = (x7 + x67);
  let x69: u32 = (x68 & 0x1ffffff);
  let x70: u8 = ((x68 >> 25) as u8);
  let x71: u32 = (x6 + (x70 as u32));
  let x72: u32 = (x5 + x71);
  let x73: u32 = (x4 + x72);
  let x74: u32 = (x73 & 0x3ffffff);
  let x75: u8 = ((x73 >> 26) as u8);
  let x76: u32 = (x3 + (x75 as u32));
  let x77: u32 = (x2 + x76);
  let x78: u32 = (x1 + x77);
  out1[0] = x36;
  out1[1] = x41;
  out1[2] = x46;
  out1[3] = x51;
  out1[4] = x55;
  out1[5] = x59;
  out1[6] = x64;
  out1[7] = x69;
  out1[8] = x74;
  out1[9] = x78;
}

/// The function fiat_25519_relax is the identity function converting from tight field elements to loose field elements.
///
/// Postconditions:
///   out1 = arg1
///
#[inline]
pub fn fiat_25519_relax(out1: &mut fiat_25519_loose_field_element, arg1: &fiat_25519_tight_field_element) -> () {
  let x1: u32 = (arg1[0]);
  let x2: u32 = (arg1[1]);
  let x3: u32 = (arg1[2]);
  let x4: u32 = (arg1[3]);
  let x5: u32 = (arg1[4]);
  let x6: u32 = (arg1[5]);
  let x7: u32 = (arg1[6]);
  let x8: u32 = (arg1[7]);
  let x9: u32 = (arg1[8]);
  let x10: u32 = (arg1[9]);
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
}

/// The function fiat_25519_carry_scmul_121666 multiplies a field element by 121666 and reduces the result.
///
/// Postconditions:
///   eval out1 mod m = (121666 * eval arg1) mod m
///
#[inline]
pub fn fiat_25519_carry_scmul_121666(out1: &mut fiat_25519_tight_field_element, arg1: &fiat_25519_loose_field_element) -> () {
  let x1: u64 = ((0x1db42 as u64) * ((arg1[9]) as u64));
  let x2: u64 = ((0x1db42 as u64) * ((arg1[8]) as u64));
  let x3: u64 = ((0x1db42 as u64) * ((arg1[7]) as u64));
  let x4: u64 = ((0x1db42 as u64) * ((arg1[6]) as u64));
  let x5: u64 = ((0x1db42 as u64) * ((arg1[5]) as u64));
  let x6: u64 = ((0x1db42 as u64) * ((arg1[4]) as u64));
  let x7: u64 = ((0x1db42 as u64) * ((arg1[3]) as u64));
  let x8: u64 = ((0x1db42 as u64) * ((arg1[2]) as u64));
  let x9: u64 = ((0x1db42 as u64) * ((arg1[1]) as u64));
  let x10: u64 = ((0x1db42 as u64) * ((arg1[0]) as u64));
  let x11: u32 = ((x10 >> 26) as u32);
  let x12: u32 = ((x10 & (0x3ffffff as u64)) as u32);
  let x13: u64 = ((x11 as u64) + x9);
  let x14: u32 = ((x13 >> 25) as u32);
  let x15: u32 = ((x13 & (0x1ffffff as u64)) as u32);
  let x16: u64 = ((x14 as u64) + x8);
  let x17: u32 = ((x16 >> 26) as u32);
  let x18: u32 = ((x16 & (0x3ffffff as u64)) as u32);
  let x19: u64 = ((x17 as u64) + x7);
  let x20: u32 = ((x19 >> 25) as u32);
  let x21: u32 = ((x19 & (0x1ffffff as u64)) as u32);
  let x22: u64 = ((x20 as u64) + x6);
  let x23: u32 = ((x22 >> 26) as u32);
  let x24: u32 = ((x22 & (0x3ffffff as u64)) as u32);
  let x25: u64 = ((x23 as u64) + x5);
  let x26: u32 = ((x25 >> 25) as u32);
  let x27: u32 = ((x25 & (0x1ffffff as u64)) as u32);
  let x28: u64 = ((x26 as u64) + x4);
  let x29: u32 = ((x28 >> 26) as u32);
  let x30: u32 = ((x28 & (0x3ffffff as u64)) as u32);
  let x31: u64 = ((x29 as u64) + x3);
  let x32: u32 = ((x31 >> 25) as u32);
  let x33: u32 = ((x31 & (0x1ffffff as u64)) as u32);
  let x34: u64 = ((x32 as u64) + x2);
  let x35: u32 = ((x34 >> 26) as u32);
  let x36: u32 = ((x34 & (0x3ffffff as u64)) as u32);
  let x37: u64 = ((x35 as u64) + x1);
  let x38: u32 = ((x37 >> 25) as u32);
  let x39: u32 = ((x37 & (0x1ffffff as u64)) as u32);
  let x40: u32 = (x38 * 0x13);
  let x41: u32 = (x12 + x40);
  let x42: fiat_25519_u1 = ((x41 >> 26) as fiat_25519_u1);
  let x43: u32 = (x41 & 0x3ffffff);
  let x44: u32 = ((x42 as u32) + x15);
  let x45: fiat_25519_u1 = ((x44 >> 25) as fiat_25519_u1);
  let x46: u32 = (x44 & 0x1ffffff);
  let x47: u32 = ((x45 as u32) + x18);
  out1[0] = x43;
  out1[1] = x46;
  out1[2] = x47;
  out1[3] = x21;
  out1[4] = x24;
  out1[5] = x27;
  out1[6] = x30;
  out1[7] = x33;
  out1[8] = x36;
  out1[9] = x39;
}
