//! Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Rust p256 32 '2^256 - 2^224 + 2^192 + 2^96 - 1' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp
//! curve description: p256
//! machine_wordsize = 32 (from "32")
//! requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp
//! m = 0xffffffff00000001000000000000000000000000ffffffffffffffffffffffff (from "2^256 - 2^224 + 2^192 + 2^96 - 1")
//!
//! NOTE: In addition to the bounds specified above each function, all
//!   functions synthesized for this Montgomery arithmetic require the
//!   input to be strictly less than the prime modulus (m), and also
//!   require the input to be in the unique saturated representation.
//!   All functions also ensure that these two properties are true of
//!   return values.
//!
//! Computed values:
//! eval z = z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224)
//! bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248)

#![allow(unused_parens)]
#[allow(non_camel_case_types)]

pub type fiat_p256_u1 = u8;
pub type fiat_p256_i1 = i8;
pub type fiat_p256_u2 = u8;
pub type fiat_p256_i2 = i8;


/// The function fiat_p256_addcarryx_u32 is an addition with carry.
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^32
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p256_addcarryx_u32(out1: &mut u32, out2: &mut fiat_p256_u1, arg1: fiat_p256_u1, arg2: u32, arg3: u32) -> () {
  let x1: u64 = (((arg1 as u64) + (arg2 as u64)) + (arg3 as u64));
  let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
  let x3: fiat_p256_u1 = ((x1 >> 32) as fiat_p256_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_p256_subborrowx_u32 is a subtraction with borrow.
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^32
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p256_subborrowx_u32(out1: &mut u32, out2: &mut fiat_p256_u1, arg1: fiat_p256_u1, arg2: u32, arg3: u32) -> () {
  let x1: i64 = (((arg2 as i64) - (arg1 as i64)) - (arg3 as i64));
  let x2: fiat_p256_i1 = ((x1 >> 32) as fiat_p256_i1);
  let x3: u32 = ((x1 & (0xffffffff as i64)) as u32);
  *out1 = x3;
  *out2 = (((0x0 as fiat_p256_i2) - (x2 as fiat_p256_i2)) as fiat_p256_u1);
}

/// The function fiat_p256_mulx_u32 is a multiplication, returning the full double-width result.
/// Postconditions:
///   out1 = (arg1 * arg2) mod 2^32
///   out2 = ⌊arg1 * arg2 / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffff]
///   arg2: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_p256_mulx_u32(out1: &mut u32, out2: &mut u32, arg1: u32, arg2: u32) -> () {
  let x1: u64 = ((arg1 as u64) * (arg2 as u64));
  let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
  let x3: u32 = ((x1 >> 32) as u32);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_p256_cmovznz_u32 is a single-word conditional move.
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_p256_cmovznz_u32(out1: &mut u32, arg1: fiat_p256_u1, arg2: u32, arg3: u32) -> () {
  let x1: fiat_p256_u1 = (!(!arg1));
  let x2: u32 = ((((((0x0 as fiat_p256_i2) - (x1 as fiat_p256_i2)) as fiat_p256_i1) as i64) & (0xffffffff as i64)) as u32);
  let x3: u32 = ((x2 & arg3) | ((!x2) & arg2));
  *out1 = x3;
}

/// The function fiat_p256_mul multiplies two field elements in the Montgomery domain.
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p256_mul(out1: &mut [u32; 8], arg1: &[u32; 8], arg2: &[u32; 8]) -> () {
  let x1: u32 = (arg1[1]);
  let x2: u32 = (arg1[2]);
  let x3: u32 = (arg1[3]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[5]);
  let x6: u32 = (arg1[6]);
  let x7: u32 = (arg1[7]);
  let x8: u32 = (arg1[0]);
  let mut x9: u32 = 0;
  let mut x10: u32 = 0;
  fiat_p256_mulx_u32(&mut x9, &mut x10, x8, (arg2[7]));
  let mut x11: u32 = 0;
  let mut x12: u32 = 0;
  fiat_p256_mulx_u32(&mut x11, &mut x12, x8, (arg2[6]));
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_p256_mulx_u32(&mut x13, &mut x14, x8, (arg2[5]));
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_p256_mulx_u32(&mut x15, &mut x16, x8, (arg2[4]));
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_p256_mulx_u32(&mut x17, &mut x18, x8, (arg2[3]));
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_p256_mulx_u32(&mut x19, &mut x20, x8, (arg2[2]));
  let mut x21: u32 = 0;
  let mut x22: u32 = 0;
  fiat_p256_mulx_u32(&mut x21, &mut x22, x8, (arg2[1]));
  let mut x23: u32 = 0;
  let mut x24: u32 = 0;
  fiat_p256_mulx_u32(&mut x23, &mut x24, x8, (arg2[0]));
  let mut x25: u32 = 0;
  let mut x26: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x25, &mut x26, 0x0, x24, x21);
  let mut x27: u32 = 0;
  let mut x28: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x27, &mut x28, x26, x22, x19);
  let mut x29: u32 = 0;
  let mut x30: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x29, &mut x30, x28, x20, x17);
  let mut x31: u32 = 0;
  let mut x32: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x31, &mut x32, x30, x18, x15);
  let mut x33: u32 = 0;
  let mut x34: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x33, &mut x34, x32, x16, x13);
  let mut x35: u32 = 0;
  let mut x36: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x35, &mut x36, x34, x14, x11);
  let mut x37: u32 = 0;
  let mut x38: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x37, &mut x38, x36, x12, x9);
  let x39: u32 = ((x38 as u32) + x10);
  let mut x40: u32 = 0;
  let mut x41: u32 = 0;
  fiat_p256_mulx_u32(&mut x40, &mut x41, x23, 0xffffffff);
  let mut x42: u32 = 0;
  let mut x43: u32 = 0;
  fiat_p256_mulx_u32(&mut x42, &mut x43, x23, 0xffffffff);
  let mut x44: u32 = 0;
  let mut x45: u32 = 0;
  fiat_p256_mulx_u32(&mut x44, &mut x45, x23, 0xffffffff);
  let mut x46: u32 = 0;
  let mut x47: u32 = 0;
  fiat_p256_mulx_u32(&mut x46, &mut x47, x23, 0xffffffff);
  let mut x48: u32 = 0;
  let mut x49: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x48, &mut x49, 0x0, x47, x44);
  let mut x50: u32 = 0;
  let mut x51: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x50, &mut x51, x49, x45, x42);
  let x52: u32 = ((x51 as u32) + x43);
  let mut x53: u32 = 0;
  let mut x54: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x53, &mut x54, 0x0, x23, x46);
  let mut x55: u32 = 0;
  let mut x56: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x55, &mut x56, x54, x25, x48);
  let mut x57: u32 = 0;
  let mut x58: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x57, &mut x58, x56, x27, x50);
  let mut x59: u32 = 0;
  let mut x60: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x59, &mut x60, x58, x29, x52);
  let mut x61: u32 = 0;
  let mut x62: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x61, &mut x62, x60, x31, (0x0 as u32));
  let mut x63: u32 = 0;
  let mut x64: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x63, &mut x64, x62, x33, (0x0 as u32));
  let mut x65: u32 = 0;
  let mut x66: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x65, &mut x66, x64, x35, x23);
  let mut x67: u32 = 0;
  let mut x68: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x67, &mut x68, x66, x37, x40);
  let mut x69: u32 = 0;
  let mut x70: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x69, &mut x70, x68, x39, x41);
  let mut x71: u32 = 0;
  let mut x72: u32 = 0;
  fiat_p256_mulx_u32(&mut x71, &mut x72, x1, (arg2[7]));
  let mut x73: u32 = 0;
  let mut x74: u32 = 0;
  fiat_p256_mulx_u32(&mut x73, &mut x74, x1, (arg2[6]));
  let mut x75: u32 = 0;
  let mut x76: u32 = 0;
  fiat_p256_mulx_u32(&mut x75, &mut x76, x1, (arg2[5]));
  let mut x77: u32 = 0;
  let mut x78: u32 = 0;
  fiat_p256_mulx_u32(&mut x77, &mut x78, x1, (arg2[4]));
  let mut x79: u32 = 0;
  let mut x80: u32 = 0;
  fiat_p256_mulx_u32(&mut x79, &mut x80, x1, (arg2[3]));
  let mut x81: u32 = 0;
  let mut x82: u32 = 0;
  fiat_p256_mulx_u32(&mut x81, &mut x82, x1, (arg2[2]));
  let mut x83: u32 = 0;
  let mut x84: u32 = 0;
  fiat_p256_mulx_u32(&mut x83, &mut x84, x1, (arg2[1]));
  let mut x85: u32 = 0;
  let mut x86: u32 = 0;
  fiat_p256_mulx_u32(&mut x85, &mut x86, x1, (arg2[0]));
  let mut x87: u32 = 0;
  let mut x88: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x87, &mut x88, 0x0, x86, x83);
  let mut x89: u32 = 0;
  let mut x90: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x89, &mut x90, x88, x84, x81);
  let mut x91: u32 = 0;
  let mut x92: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x91, &mut x92, x90, x82, x79);
  let mut x93: u32 = 0;
  let mut x94: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x93, &mut x94, x92, x80, x77);
  let mut x95: u32 = 0;
  let mut x96: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x95, &mut x96, x94, x78, x75);
  let mut x97: u32 = 0;
  let mut x98: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x97, &mut x98, x96, x76, x73);
  let mut x99: u32 = 0;
  let mut x100: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x99, &mut x100, x98, x74, x71);
  let x101: u32 = ((x100 as u32) + x72);
  let mut x102: u32 = 0;
  let mut x103: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x102, &mut x103, 0x0, x55, x85);
  let mut x104: u32 = 0;
  let mut x105: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x104, &mut x105, x103, x57, x87);
  let mut x106: u32 = 0;
  let mut x107: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x106, &mut x107, x105, x59, x89);
  let mut x108: u32 = 0;
  let mut x109: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x108, &mut x109, x107, x61, x91);
  let mut x110: u32 = 0;
  let mut x111: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x110, &mut x111, x109, x63, x93);
  let mut x112: u32 = 0;
  let mut x113: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x112, &mut x113, x111, x65, x95);
  let mut x114: u32 = 0;
  let mut x115: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x114, &mut x115, x113, x67, x97);
  let mut x116: u32 = 0;
  let mut x117: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x116, &mut x117, x115, x69, x99);
  let mut x118: u32 = 0;
  let mut x119: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x118, &mut x119, x117, (x70 as u32), x101);
  let mut x120: u32 = 0;
  let mut x121: u32 = 0;
  fiat_p256_mulx_u32(&mut x120, &mut x121, x102, 0xffffffff);
  let mut x122: u32 = 0;
  let mut x123: u32 = 0;
  fiat_p256_mulx_u32(&mut x122, &mut x123, x102, 0xffffffff);
  let mut x124: u32 = 0;
  let mut x125: u32 = 0;
  fiat_p256_mulx_u32(&mut x124, &mut x125, x102, 0xffffffff);
  let mut x126: u32 = 0;
  let mut x127: u32 = 0;
  fiat_p256_mulx_u32(&mut x126, &mut x127, x102, 0xffffffff);
  let mut x128: u32 = 0;
  let mut x129: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x128, &mut x129, 0x0, x127, x124);
  let mut x130: u32 = 0;
  let mut x131: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x130, &mut x131, x129, x125, x122);
  let x132: u32 = ((x131 as u32) + x123);
  let mut x133: u32 = 0;
  let mut x134: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x133, &mut x134, 0x0, x102, x126);
  let mut x135: u32 = 0;
  let mut x136: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x135, &mut x136, x134, x104, x128);
  let mut x137: u32 = 0;
  let mut x138: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x137, &mut x138, x136, x106, x130);
  let mut x139: u32 = 0;
  let mut x140: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x139, &mut x140, x138, x108, x132);
  let mut x141: u32 = 0;
  let mut x142: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x141, &mut x142, x140, x110, (0x0 as u32));
  let mut x143: u32 = 0;
  let mut x144: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x143, &mut x144, x142, x112, (0x0 as u32));
  let mut x145: u32 = 0;
  let mut x146: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x145, &mut x146, x144, x114, x102);
  let mut x147: u32 = 0;
  let mut x148: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x147, &mut x148, x146, x116, x120);
  let mut x149: u32 = 0;
  let mut x150: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x149, &mut x150, x148, x118, x121);
  let x151: u32 = ((x150 as u32) + (x119 as u32));
  let mut x152: u32 = 0;
  let mut x153: u32 = 0;
  fiat_p256_mulx_u32(&mut x152, &mut x153, x2, (arg2[7]));
  let mut x154: u32 = 0;
  let mut x155: u32 = 0;
  fiat_p256_mulx_u32(&mut x154, &mut x155, x2, (arg2[6]));
  let mut x156: u32 = 0;
  let mut x157: u32 = 0;
  fiat_p256_mulx_u32(&mut x156, &mut x157, x2, (arg2[5]));
  let mut x158: u32 = 0;
  let mut x159: u32 = 0;
  fiat_p256_mulx_u32(&mut x158, &mut x159, x2, (arg2[4]));
  let mut x160: u32 = 0;
  let mut x161: u32 = 0;
  fiat_p256_mulx_u32(&mut x160, &mut x161, x2, (arg2[3]));
  let mut x162: u32 = 0;
  let mut x163: u32 = 0;
  fiat_p256_mulx_u32(&mut x162, &mut x163, x2, (arg2[2]));
  let mut x164: u32 = 0;
  let mut x165: u32 = 0;
  fiat_p256_mulx_u32(&mut x164, &mut x165, x2, (arg2[1]));
  let mut x166: u32 = 0;
  let mut x167: u32 = 0;
  fiat_p256_mulx_u32(&mut x166, &mut x167, x2, (arg2[0]));
  let mut x168: u32 = 0;
  let mut x169: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x168, &mut x169, 0x0, x167, x164);
  let mut x170: u32 = 0;
  let mut x171: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x170, &mut x171, x169, x165, x162);
  let mut x172: u32 = 0;
  let mut x173: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x172, &mut x173, x171, x163, x160);
  let mut x174: u32 = 0;
  let mut x175: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x174, &mut x175, x173, x161, x158);
  let mut x176: u32 = 0;
  let mut x177: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x176, &mut x177, x175, x159, x156);
  let mut x178: u32 = 0;
  let mut x179: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x178, &mut x179, x177, x157, x154);
  let mut x180: u32 = 0;
  let mut x181: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x180, &mut x181, x179, x155, x152);
  let x182: u32 = ((x181 as u32) + x153);
  let mut x183: u32 = 0;
  let mut x184: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x183, &mut x184, 0x0, x135, x166);
  let mut x185: u32 = 0;
  let mut x186: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x185, &mut x186, x184, x137, x168);
  let mut x187: u32 = 0;
  let mut x188: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x187, &mut x188, x186, x139, x170);
  let mut x189: u32 = 0;
  let mut x190: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x189, &mut x190, x188, x141, x172);
  let mut x191: u32 = 0;
  let mut x192: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x191, &mut x192, x190, x143, x174);
  let mut x193: u32 = 0;
  let mut x194: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x193, &mut x194, x192, x145, x176);
  let mut x195: u32 = 0;
  let mut x196: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x195, &mut x196, x194, x147, x178);
  let mut x197: u32 = 0;
  let mut x198: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x197, &mut x198, x196, x149, x180);
  let mut x199: u32 = 0;
  let mut x200: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x199, &mut x200, x198, x151, x182);
  let mut x201: u32 = 0;
  let mut x202: u32 = 0;
  fiat_p256_mulx_u32(&mut x201, &mut x202, x183, 0xffffffff);
  let mut x203: u32 = 0;
  let mut x204: u32 = 0;
  fiat_p256_mulx_u32(&mut x203, &mut x204, x183, 0xffffffff);
  let mut x205: u32 = 0;
  let mut x206: u32 = 0;
  fiat_p256_mulx_u32(&mut x205, &mut x206, x183, 0xffffffff);
  let mut x207: u32 = 0;
  let mut x208: u32 = 0;
  fiat_p256_mulx_u32(&mut x207, &mut x208, x183, 0xffffffff);
  let mut x209: u32 = 0;
  let mut x210: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x209, &mut x210, 0x0, x208, x205);
  let mut x211: u32 = 0;
  let mut x212: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x211, &mut x212, x210, x206, x203);
  let x213: u32 = ((x212 as u32) + x204);
  let mut x214: u32 = 0;
  let mut x215: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x214, &mut x215, 0x0, x183, x207);
  let mut x216: u32 = 0;
  let mut x217: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x216, &mut x217, x215, x185, x209);
  let mut x218: u32 = 0;
  let mut x219: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x218, &mut x219, x217, x187, x211);
  let mut x220: u32 = 0;
  let mut x221: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x220, &mut x221, x219, x189, x213);
  let mut x222: u32 = 0;
  let mut x223: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x222, &mut x223, x221, x191, (0x0 as u32));
  let mut x224: u32 = 0;
  let mut x225: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x224, &mut x225, x223, x193, (0x0 as u32));
  let mut x226: u32 = 0;
  let mut x227: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x226, &mut x227, x225, x195, x183);
  let mut x228: u32 = 0;
  let mut x229: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x228, &mut x229, x227, x197, x201);
  let mut x230: u32 = 0;
  let mut x231: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x230, &mut x231, x229, x199, x202);
  let x232: u32 = ((x231 as u32) + (x200 as u32));
  let mut x233: u32 = 0;
  let mut x234: u32 = 0;
  fiat_p256_mulx_u32(&mut x233, &mut x234, x3, (arg2[7]));
  let mut x235: u32 = 0;
  let mut x236: u32 = 0;
  fiat_p256_mulx_u32(&mut x235, &mut x236, x3, (arg2[6]));
  let mut x237: u32 = 0;
  let mut x238: u32 = 0;
  fiat_p256_mulx_u32(&mut x237, &mut x238, x3, (arg2[5]));
  let mut x239: u32 = 0;
  let mut x240: u32 = 0;
  fiat_p256_mulx_u32(&mut x239, &mut x240, x3, (arg2[4]));
  let mut x241: u32 = 0;
  let mut x242: u32 = 0;
  fiat_p256_mulx_u32(&mut x241, &mut x242, x3, (arg2[3]));
  let mut x243: u32 = 0;
  let mut x244: u32 = 0;
  fiat_p256_mulx_u32(&mut x243, &mut x244, x3, (arg2[2]));
  let mut x245: u32 = 0;
  let mut x246: u32 = 0;
  fiat_p256_mulx_u32(&mut x245, &mut x246, x3, (arg2[1]));
  let mut x247: u32 = 0;
  let mut x248: u32 = 0;
  fiat_p256_mulx_u32(&mut x247, &mut x248, x3, (arg2[0]));
  let mut x249: u32 = 0;
  let mut x250: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x249, &mut x250, 0x0, x248, x245);
  let mut x251: u32 = 0;
  let mut x252: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x251, &mut x252, x250, x246, x243);
  let mut x253: u32 = 0;
  let mut x254: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x253, &mut x254, x252, x244, x241);
  let mut x255: u32 = 0;
  let mut x256: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x255, &mut x256, x254, x242, x239);
  let mut x257: u32 = 0;
  let mut x258: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x257, &mut x258, x256, x240, x237);
  let mut x259: u32 = 0;
  let mut x260: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x259, &mut x260, x258, x238, x235);
  let mut x261: u32 = 0;
  let mut x262: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x261, &mut x262, x260, x236, x233);
  let x263: u32 = ((x262 as u32) + x234);
  let mut x264: u32 = 0;
  let mut x265: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x264, &mut x265, 0x0, x216, x247);
  let mut x266: u32 = 0;
  let mut x267: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x266, &mut x267, x265, x218, x249);
  let mut x268: u32 = 0;
  let mut x269: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x268, &mut x269, x267, x220, x251);
  let mut x270: u32 = 0;
  let mut x271: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x270, &mut x271, x269, x222, x253);
  let mut x272: u32 = 0;
  let mut x273: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x272, &mut x273, x271, x224, x255);
  let mut x274: u32 = 0;
  let mut x275: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x274, &mut x275, x273, x226, x257);
  let mut x276: u32 = 0;
  let mut x277: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x276, &mut x277, x275, x228, x259);
  let mut x278: u32 = 0;
  let mut x279: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x278, &mut x279, x277, x230, x261);
  let mut x280: u32 = 0;
  let mut x281: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x280, &mut x281, x279, x232, x263);
  let mut x282: u32 = 0;
  let mut x283: u32 = 0;
  fiat_p256_mulx_u32(&mut x282, &mut x283, x264, 0xffffffff);
  let mut x284: u32 = 0;
  let mut x285: u32 = 0;
  fiat_p256_mulx_u32(&mut x284, &mut x285, x264, 0xffffffff);
  let mut x286: u32 = 0;
  let mut x287: u32 = 0;
  fiat_p256_mulx_u32(&mut x286, &mut x287, x264, 0xffffffff);
  let mut x288: u32 = 0;
  let mut x289: u32 = 0;
  fiat_p256_mulx_u32(&mut x288, &mut x289, x264, 0xffffffff);
  let mut x290: u32 = 0;
  let mut x291: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x290, &mut x291, 0x0, x289, x286);
  let mut x292: u32 = 0;
  let mut x293: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x292, &mut x293, x291, x287, x284);
  let x294: u32 = ((x293 as u32) + x285);
  let mut x295: u32 = 0;
  let mut x296: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x295, &mut x296, 0x0, x264, x288);
  let mut x297: u32 = 0;
  let mut x298: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x297, &mut x298, x296, x266, x290);
  let mut x299: u32 = 0;
  let mut x300: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x299, &mut x300, x298, x268, x292);
  let mut x301: u32 = 0;
  let mut x302: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x301, &mut x302, x300, x270, x294);
  let mut x303: u32 = 0;
  let mut x304: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x303, &mut x304, x302, x272, (0x0 as u32));
  let mut x305: u32 = 0;
  let mut x306: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x305, &mut x306, x304, x274, (0x0 as u32));
  let mut x307: u32 = 0;
  let mut x308: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x307, &mut x308, x306, x276, x264);
  let mut x309: u32 = 0;
  let mut x310: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x309, &mut x310, x308, x278, x282);
  let mut x311: u32 = 0;
  let mut x312: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x311, &mut x312, x310, x280, x283);
  let x313: u32 = ((x312 as u32) + (x281 as u32));
  let mut x314: u32 = 0;
  let mut x315: u32 = 0;
  fiat_p256_mulx_u32(&mut x314, &mut x315, x4, (arg2[7]));
  let mut x316: u32 = 0;
  let mut x317: u32 = 0;
  fiat_p256_mulx_u32(&mut x316, &mut x317, x4, (arg2[6]));
  let mut x318: u32 = 0;
  let mut x319: u32 = 0;
  fiat_p256_mulx_u32(&mut x318, &mut x319, x4, (arg2[5]));
  let mut x320: u32 = 0;
  let mut x321: u32 = 0;
  fiat_p256_mulx_u32(&mut x320, &mut x321, x4, (arg2[4]));
  let mut x322: u32 = 0;
  let mut x323: u32 = 0;
  fiat_p256_mulx_u32(&mut x322, &mut x323, x4, (arg2[3]));
  let mut x324: u32 = 0;
  let mut x325: u32 = 0;
  fiat_p256_mulx_u32(&mut x324, &mut x325, x4, (arg2[2]));
  let mut x326: u32 = 0;
  let mut x327: u32 = 0;
  fiat_p256_mulx_u32(&mut x326, &mut x327, x4, (arg2[1]));
  let mut x328: u32 = 0;
  let mut x329: u32 = 0;
  fiat_p256_mulx_u32(&mut x328, &mut x329, x4, (arg2[0]));
  let mut x330: u32 = 0;
  let mut x331: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x330, &mut x331, 0x0, x329, x326);
  let mut x332: u32 = 0;
  let mut x333: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x332, &mut x333, x331, x327, x324);
  let mut x334: u32 = 0;
  let mut x335: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x334, &mut x335, x333, x325, x322);
  let mut x336: u32 = 0;
  let mut x337: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x336, &mut x337, x335, x323, x320);
  let mut x338: u32 = 0;
  let mut x339: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x338, &mut x339, x337, x321, x318);
  let mut x340: u32 = 0;
  let mut x341: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x340, &mut x341, x339, x319, x316);
  let mut x342: u32 = 0;
  let mut x343: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x342, &mut x343, x341, x317, x314);
  let x344: u32 = ((x343 as u32) + x315);
  let mut x345: u32 = 0;
  let mut x346: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x345, &mut x346, 0x0, x297, x328);
  let mut x347: u32 = 0;
  let mut x348: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x347, &mut x348, x346, x299, x330);
  let mut x349: u32 = 0;
  let mut x350: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x349, &mut x350, x348, x301, x332);
  let mut x351: u32 = 0;
  let mut x352: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x351, &mut x352, x350, x303, x334);
  let mut x353: u32 = 0;
  let mut x354: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x353, &mut x354, x352, x305, x336);
  let mut x355: u32 = 0;
  let mut x356: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x355, &mut x356, x354, x307, x338);
  let mut x357: u32 = 0;
  let mut x358: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x357, &mut x358, x356, x309, x340);
  let mut x359: u32 = 0;
  let mut x360: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x359, &mut x360, x358, x311, x342);
  let mut x361: u32 = 0;
  let mut x362: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x361, &mut x362, x360, x313, x344);
  let mut x363: u32 = 0;
  let mut x364: u32 = 0;
  fiat_p256_mulx_u32(&mut x363, &mut x364, x345, 0xffffffff);
  let mut x365: u32 = 0;
  let mut x366: u32 = 0;
  fiat_p256_mulx_u32(&mut x365, &mut x366, x345, 0xffffffff);
  let mut x367: u32 = 0;
  let mut x368: u32 = 0;
  fiat_p256_mulx_u32(&mut x367, &mut x368, x345, 0xffffffff);
  let mut x369: u32 = 0;
  let mut x370: u32 = 0;
  fiat_p256_mulx_u32(&mut x369, &mut x370, x345, 0xffffffff);
  let mut x371: u32 = 0;
  let mut x372: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x371, &mut x372, 0x0, x370, x367);
  let mut x373: u32 = 0;
  let mut x374: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x373, &mut x374, x372, x368, x365);
  let x375: u32 = ((x374 as u32) + x366);
  let mut x376: u32 = 0;
  let mut x377: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x376, &mut x377, 0x0, x345, x369);
  let mut x378: u32 = 0;
  let mut x379: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x378, &mut x379, x377, x347, x371);
  let mut x380: u32 = 0;
  let mut x381: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x380, &mut x381, x379, x349, x373);
  let mut x382: u32 = 0;
  let mut x383: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x382, &mut x383, x381, x351, x375);
  let mut x384: u32 = 0;
  let mut x385: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x384, &mut x385, x383, x353, (0x0 as u32));
  let mut x386: u32 = 0;
  let mut x387: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x386, &mut x387, x385, x355, (0x0 as u32));
  let mut x388: u32 = 0;
  let mut x389: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x388, &mut x389, x387, x357, x345);
  let mut x390: u32 = 0;
  let mut x391: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x390, &mut x391, x389, x359, x363);
  let mut x392: u32 = 0;
  let mut x393: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x392, &mut x393, x391, x361, x364);
  let x394: u32 = ((x393 as u32) + (x362 as u32));
  let mut x395: u32 = 0;
  let mut x396: u32 = 0;
  fiat_p256_mulx_u32(&mut x395, &mut x396, x5, (arg2[7]));
  let mut x397: u32 = 0;
  let mut x398: u32 = 0;
  fiat_p256_mulx_u32(&mut x397, &mut x398, x5, (arg2[6]));
  let mut x399: u32 = 0;
  let mut x400: u32 = 0;
  fiat_p256_mulx_u32(&mut x399, &mut x400, x5, (arg2[5]));
  let mut x401: u32 = 0;
  let mut x402: u32 = 0;
  fiat_p256_mulx_u32(&mut x401, &mut x402, x5, (arg2[4]));
  let mut x403: u32 = 0;
  let mut x404: u32 = 0;
  fiat_p256_mulx_u32(&mut x403, &mut x404, x5, (arg2[3]));
  let mut x405: u32 = 0;
  let mut x406: u32 = 0;
  fiat_p256_mulx_u32(&mut x405, &mut x406, x5, (arg2[2]));
  let mut x407: u32 = 0;
  let mut x408: u32 = 0;
  fiat_p256_mulx_u32(&mut x407, &mut x408, x5, (arg2[1]));
  let mut x409: u32 = 0;
  let mut x410: u32 = 0;
  fiat_p256_mulx_u32(&mut x409, &mut x410, x5, (arg2[0]));
  let mut x411: u32 = 0;
  let mut x412: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x411, &mut x412, 0x0, x410, x407);
  let mut x413: u32 = 0;
  let mut x414: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x413, &mut x414, x412, x408, x405);
  let mut x415: u32 = 0;
  let mut x416: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x415, &mut x416, x414, x406, x403);
  let mut x417: u32 = 0;
  let mut x418: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x417, &mut x418, x416, x404, x401);
  let mut x419: u32 = 0;
  let mut x420: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x419, &mut x420, x418, x402, x399);
  let mut x421: u32 = 0;
  let mut x422: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x421, &mut x422, x420, x400, x397);
  let mut x423: u32 = 0;
  let mut x424: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x423, &mut x424, x422, x398, x395);
  let x425: u32 = ((x424 as u32) + x396);
  let mut x426: u32 = 0;
  let mut x427: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x426, &mut x427, 0x0, x378, x409);
  let mut x428: u32 = 0;
  let mut x429: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x428, &mut x429, x427, x380, x411);
  let mut x430: u32 = 0;
  let mut x431: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x430, &mut x431, x429, x382, x413);
  let mut x432: u32 = 0;
  let mut x433: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x432, &mut x433, x431, x384, x415);
  let mut x434: u32 = 0;
  let mut x435: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x434, &mut x435, x433, x386, x417);
  let mut x436: u32 = 0;
  let mut x437: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x436, &mut x437, x435, x388, x419);
  let mut x438: u32 = 0;
  let mut x439: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x438, &mut x439, x437, x390, x421);
  let mut x440: u32 = 0;
  let mut x441: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x440, &mut x441, x439, x392, x423);
  let mut x442: u32 = 0;
  let mut x443: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x442, &mut x443, x441, x394, x425);
  let mut x444: u32 = 0;
  let mut x445: u32 = 0;
  fiat_p256_mulx_u32(&mut x444, &mut x445, x426, 0xffffffff);
  let mut x446: u32 = 0;
  let mut x447: u32 = 0;
  fiat_p256_mulx_u32(&mut x446, &mut x447, x426, 0xffffffff);
  let mut x448: u32 = 0;
  let mut x449: u32 = 0;
  fiat_p256_mulx_u32(&mut x448, &mut x449, x426, 0xffffffff);
  let mut x450: u32 = 0;
  let mut x451: u32 = 0;
  fiat_p256_mulx_u32(&mut x450, &mut x451, x426, 0xffffffff);
  let mut x452: u32 = 0;
  let mut x453: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x452, &mut x453, 0x0, x451, x448);
  let mut x454: u32 = 0;
  let mut x455: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x454, &mut x455, x453, x449, x446);
  let x456: u32 = ((x455 as u32) + x447);
  let mut x457: u32 = 0;
  let mut x458: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x457, &mut x458, 0x0, x426, x450);
  let mut x459: u32 = 0;
  let mut x460: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x459, &mut x460, x458, x428, x452);
  let mut x461: u32 = 0;
  let mut x462: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x461, &mut x462, x460, x430, x454);
  let mut x463: u32 = 0;
  let mut x464: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x463, &mut x464, x462, x432, x456);
  let mut x465: u32 = 0;
  let mut x466: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x465, &mut x466, x464, x434, (0x0 as u32));
  let mut x467: u32 = 0;
  let mut x468: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x467, &mut x468, x466, x436, (0x0 as u32));
  let mut x469: u32 = 0;
  let mut x470: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x469, &mut x470, x468, x438, x426);
  let mut x471: u32 = 0;
  let mut x472: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x471, &mut x472, x470, x440, x444);
  let mut x473: u32 = 0;
  let mut x474: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x473, &mut x474, x472, x442, x445);
  let x475: u32 = ((x474 as u32) + (x443 as u32));
  let mut x476: u32 = 0;
  let mut x477: u32 = 0;
  fiat_p256_mulx_u32(&mut x476, &mut x477, x6, (arg2[7]));
  let mut x478: u32 = 0;
  let mut x479: u32 = 0;
  fiat_p256_mulx_u32(&mut x478, &mut x479, x6, (arg2[6]));
  let mut x480: u32 = 0;
  let mut x481: u32 = 0;
  fiat_p256_mulx_u32(&mut x480, &mut x481, x6, (arg2[5]));
  let mut x482: u32 = 0;
  let mut x483: u32 = 0;
  fiat_p256_mulx_u32(&mut x482, &mut x483, x6, (arg2[4]));
  let mut x484: u32 = 0;
  let mut x485: u32 = 0;
  fiat_p256_mulx_u32(&mut x484, &mut x485, x6, (arg2[3]));
  let mut x486: u32 = 0;
  let mut x487: u32 = 0;
  fiat_p256_mulx_u32(&mut x486, &mut x487, x6, (arg2[2]));
  let mut x488: u32 = 0;
  let mut x489: u32 = 0;
  fiat_p256_mulx_u32(&mut x488, &mut x489, x6, (arg2[1]));
  let mut x490: u32 = 0;
  let mut x491: u32 = 0;
  fiat_p256_mulx_u32(&mut x490, &mut x491, x6, (arg2[0]));
  let mut x492: u32 = 0;
  let mut x493: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x492, &mut x493, 0x0, x491, x488);
  let mut x494: u32 = 0;
  let mut x495: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x494, &mut x495, x493, x489, x486);
  let mut x496: u32 = 0;
  let mut x497: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x496, &mut x497, x495, x487, x484);
  let mut x498: u32 = 0;
  let mut x499: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x498, &mut x499, x497, x485, x482);
  let mut x500: u32 = 0;
  let mut x501: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x500, &mut x501, x499, x483, x480);
  let mut x502: u32 = 0;
  let mut x503: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x502, &mut x503, x501, x481, x478);
  let mut x504: u32 = 0;
  let mut x505: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x504, &mut x505, x503, x479, x476);
  let x506: u32 = ((x505 as u32) + x477);
  let mut x507: u32 = 0;
  let mut x508: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x507, &mut x508, 0x0, x459, x490);
  let mut x509: u32 = 0;
  let mut x510: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x509, &mut x510, x508, x461, x492);
  let mut x511: u32 = 0;
  let mut x512: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x511, &mut x512, x510, x463, x494);
  let mut x513: u32 = 0;
  let mut x514: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x513, &mut x514, x512, x465, x496);
  let mut x515: u32 = 0;
  let mut x516: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x515, &mut x516, x514, x467, x498);
  let mut x517: u32 = 0;
  let mut x518: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x517, &mut x518, x516, x469, x500);
  let mut x519: u32 = 0;
  let mut x520: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x519, &mut x520, x518, x471, x502);
  let mut x521: u32 = 0;
  let mut x522: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x521, &mut x522, x520, x473, x504);
  let mut x523: u32 = 0;
  let mut x524: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x523, &mut x524, x522, x475, x506);
  let mut x525: u32 = 0;
  let mut x526: u32 = 0;
  fiat_p256_mulx_u32(&mut x525, &mut x526, x507, 0xffffffff);
  let mut x527: u32 = 0;
  let mut x528: u32 = 0;
  fiat_p256_mulx_u32(&mut x527, &mut x528, x507, 0xffffffff);
  let mut x529: u32 = 0;
  let mut x530: u32 = 0;
  fiat_p256_mulx_u32(&mut x529, &mut x530, x507, 0xffffffff);
  let mut x531: u32 = 0;
  let mut x532: u32 = 0;
  fiat_p256_mulx_u32(&mut x531, &mut x532, x507, 0xffffffff);
  let mut x533: u32 = 0;
  let mut x534: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x533, &mut x534, 0x0, x532, x529);
  let mut x535: u32 = 0;
  let mut x536: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x535, &mut x536, x534, x530, x527);
  let x537: u32 = ((x536 as u32) + x528);
  let mut x538: u32 = 0;
  let mut x539: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x538, &mut x539, 0x0, x507, x531);
  let mut x540: u32 = 0;
  let mut x541: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x540, &mut x541, x539, x509, x533);
  let mut x542: u32 = 0;
  let mut x543: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x542, &mut x543, x541, x511, x535);
  let mut x544: u32 = 0;
  let mut x545: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x544, &mut x545, x543, x513, x537);
  let mut x546: u32 = 0;
  let mut x547: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x546, &mut x547, x545, x515, (0x0 as u32));
  let mut x548: u32 = 0;
  let mut x549: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x548, &mut x549, x547, x517, (0x0 as u32));
  let mut x550: u32 = 0;
  let mut x551: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x550, &mut x551, x549, x519, x507);
  let mut x552: u32 = 0;
  let mut x553: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x552, &mut x553, x551, x521, x525);
  let mut x554: u32 = 0;
  let mut x555: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x554, &mut x555, x553, x523, x526);
  let x556: u32 = ((x555 as u32) + (x524 as u32));
  let mut x557: u32 = 0;
  let mut x558: u32 = 0;
  fiat_p256_mulx_u32(&mut x557, &mut x558, x7, (arg2[7]));
  let mut x559: u32 = 0;
  let mut x560: u32 = 0;
  fiat_p256_mulx_u32(&mut x559, &mut x560, x7, (arg2[6]));
  let mut x561: u32 = 0;
  let mut x562: u32 = 0;
  fiat_p256_mulx_u32(&mut x561, &mut x562, x7, (arg2[5]));
  let mut x563: u32 = 0;
  let mut x564: u32 = 0;
  fiat_p256_mulx_u32(&mut x563, &mut x564, x7, (arg2[4]));
  let mut x565: u32 = 0;
  let mut x566: u32 = 0;
  fiat_p256_mulx_u32(&mut x565, &mut x566, x7, (arg2[3]));
  let mut x567: u32 = 0;
  let mut x568: u32 = 0;
  fiat_p256_mulx_u32(&mut x567, &mut x568, x7, (arg2[2]));
  let mut x569: u32 = 0;
  let mut x570: u32 = 0;
  fiat_p256_mulx_u32(&mut x569, &mut x570, x7, (arg2[1]));
  let mut x571: u32 = 0;
  let mut x572: u32 = 0;
  fiat_p256_mulx_u32(&mut x571, &mut x572, x7, (arg2[0]));
  let mut x573: u32 = 0;
  let mut x574: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x573, &mut x574, 0x0, x572, x569);
  let mut x575: u32 = 0;
  let mut x576: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x575, &mut x576, x574, x570, x567);
  let mut x577: u32 = 0;
  let mut x578: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x577, &mut x578, x576, x568, x565);
  let mut x579: u32 = 0;
  let mut x580: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x579, &mut x580, x578, x566, x563);
  let mut x581: u32 = 0;
  let mut x582: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x581, &mut x582, x580, x564, x561);
  let mut x583: u32 = 0;
  let mut x584: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x583, &mut x584, x582, x562, x559);
  let mut x585: u32 = 0;
  let mut x586: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x585, &mut x586, x584, x560, x557);
  let x587: u32 = ((x586 as u32) + x558);
  let mut x588: u32 = 0;
  let mut x589: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x588, &mut x589, 0x0, x540, x571);
  let mut x590: u32 = 0;
  let mut x591: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x590, &mut x591, x589, x542, x573);
  let mut x592: u32 = 0;
  let mut x593: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x592, &mut x593, x591, x544, x575);
  let mut x594: u32 = 0;
  let mut x595: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x594, &mut x595, x593, x546, x577);
  let mut x596: u32 = 0;
  let mut x597: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x596, &mut x597, x595, x548, x579);
  let mut x598: u32 = 0;
  let mut x599: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x598, &mut x599, x597, x550, x581);
  let mut x600: u32 = 0;
  let mut x601: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x600, &mut x601, x599, x552, x583);
  let mut x602: u32 = 0;
  let mut x603: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x602, &mut x603, x601, x554, x585);
  let mut x604: u32 = 0;
  let mut x605: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x604, &mut x605, x603, x556, x587);
  let mut x606: u32 = 0;
  let mut x607: u32 = 0;
  fiat_p256_mulx_u32(&mut x606, &mut x607, x588, 0xffffffff);
  let mut x608: u32 = 0;
  let mut x609: u32 = 0;
  fiat_p256_mulx_u32(&mut x608, &mut x609, x588, 0xffffffff);
  let mut x610: u32 = 0;
  let mut x611: u32 = 0;
  fiat_p256_mulx_u32(&mut x610, &mut x611, x588, 0xffffffff);
  let mut x612: u32 = 0;
  let mut x613: u32 = 0;
  fiat_p256_mulx_u32(&mut x612, &mut x613, x588, 0xffffffff);
  let mut x614: u32 = 0;
  let mut x615: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x614, &mut x615, 0x0, x613, x610);
  let mut x616: u32 = 0;
  let mut x617: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x616, &mut x617, x615, x611, x608);
  let x618: u32 = ((x617 as u32) + x609);
  let mut x619: u32 = 0;
  let mut x620: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x619, &mut x620, 0x0, x588, x612);
  let mut x621: u32 = 0;
  let mut x622: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x621, &mut x622, x620, x590, x614);
  let mut x623: u32 = 0;
  let mut x624: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x623, &mut x624, x622, x592, x616);
  let mut x625: u32 = 0;
  let mut x626: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x625, &mut x626, x624, x594, x618);
  let mut x627: u32 = 0;
  let mut x628: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x627, &mut x628, x626, x596, (0x0 as u32));
  let mut x629: u32 = 0;
  let mut x630: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x629, &mut x630, x628, x598, (0x0 as u32));
  let mut x631: u32 = 0;
  let mut x632: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x631, &mut x632, x630, x600, x588);
  let mut x633: u32 = 0;
  let mut x634: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x633, &mut x634, x632, x602, x606);
  let mut x635: u32 = 0;
  let mut x636: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x635, &mut x636, x634, x604, x607);
  let x637: u32 = ((x636 as u32) + (x605 as u32));
  let mut x638: u32 = 0;
  let mut x639: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x638, &mut x639, 0x0, x621, 0xffffffff);
  let mut x640: u32 = 0;
  let mut x641: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x640, &mut x641, x639, x623, 0xffffffff);
  let mut x642: u32 = 0;
  let mut x643: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x642, &mut x643, x641, x625, 0xffffffff);
  let mut x644: u32 = 0;
  let mut x645: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x644, &mut x645, x643, x627, (0x0 as u32));
  let mut x646: u32 = 0;
  let mut x647: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x646, &mut x647, x645, x629, (0x0 as u32));
  let mut x648: u32 = 0;
  let mut x649: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x648, &mut x649, x647, x631, (0x0 as u32));
  let mut x650: u32 = 0;
  let mut x651: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x650, &mut x651, x649, x633, (0x1 as u32));
  let mut x652: u32 = 0;
  let mut x653: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x652, &mut x653, x651, x635, 0xffffffff);
  let mut x654: u32 = 0;
  let mut x655: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x654, &mut x655, x653, x637, (0x0 as u32));
  let mut x656: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x656, x655, x638, x621);
  let mut x657: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x657, x655, x640, x623);
  let mut x658: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x658, x655, x642, x625);
  let mut x659: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x659, x655, x644, x627);
  let mut x660: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x660, x655, x646, x629);
  let mut x661: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x661, x655, x648, x631);
  let mut x662: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x662, x655, x650, x633);
  let mut x663: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x663, x655, x652, x635);
  out1[0] = x656;
  out1[1] = x657;
  out1[2] = x658;
  out1[3] = x659;
  out1[4] = x660;
  out1[5] = x661;
  out1[6] = x662;
  out1[7] = x663;
}

/// The function fiat_p256_square squares a field element in the Montgomery domain.
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p256_square(out1: &mut [u32; 8], arg1: &[u32; 8]) -> () {
  let x1: u32 = (arg1[1]);
  let x2: u32 = (arg1[2]);
  let x3: u32 = (arg1[3]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[5]);
  let x6: u32 = (arg1[6]);
  let x7: u32 = (arg1[7]);
  let x8: u32 = (arg1[0]);
  let mut x9: u32 = 0;
  let mut x10: u32 = 0;
  fiat_p256_mulx_u32(&mut x9, &mut x10, x8, (arg1[7]));
  let mut x11: u32 = 0;
  let mut x12: u32 = 0;
  fiat_p256_mulx_u32(&mut x11, &mut x12, x8, (arg1[6]));
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_p256_mulx_u32(&mut x13, &mut x14, x8, (arg1[5]));
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_p256_mulx_u32(&mut x15, &mut x16, x8, (arg1[4]));
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_p256_mulx_u32(&mut x17, &mut x18, x8, (arg1[3]));
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_p256_mulx_u32(&mut x19, &mut x20, x8, (arg1[2]));
  let mut x21: u32 = 0;
  let mut x22: u32 = 0;
  fiat_p256_mulx_u32(&mut x21, &mut x22, x8, (arg1[1]));
  let mut x23: u32 = 0;
  let mut x24: u32 = 0;
  fiat_p256_mulx_u32(&mut x23, &mut x24, x8, (arg1[0]));
  let mut x25: u32 = 0;
  let mut x26: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x25, &mut x26, 0x0, x24, x21);
  let mut x27: u32 = 0;
  let mut x28: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x27, &mut x28, x26, x22, x19);
  let mut x29: u32 = 0;
  let mut x30: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x29, &mut x30, x28, x20, x17);
  let mut x31: u32 = 0;
  let mut x32: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x31, &mut x32, x30, x18, x15);
  let mut x33: u32 = 0;
  let mut x34: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x33, &mut x34, x32, x16, x13);
  let mut x35: u32 = 0;
  let mut x36: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x35, &mut x36, x34, x14, x11);
  let mut x37: u32 = 0;
  let mut x38: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x37, &mut x38, x36, x12, x9);
  let x39: u32 = ((x38 as u32) + x10);
  let mut x40: u32 = 0;
  let mut x41: u32 = 0;
  fiat_p256_mulx_u32(&mut x40, &mut x41, x23, 0xffffffff);
  let mut x42: u32 = 0;
  let mut x43: u32 = 0;
  fiat_p256_mulx_u32(&mut x42, &mut x43, x23, 0xffffffff);
  let mut x44: u32 = 0;
  let mut x45: u32 = 0;
  fiat_p256_mulx_u32(&mut x44, &mut x45, x23, 0xffffffff);
  let mut x46: u32 = 0;
  let mut x47: u32 = 0;
  fiat_p256_mulx_u32(&mut x46, &mut x47, x23, 0xffffffff);
  let mut x48: u32 = 0;
  let mut x49: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x48, &mut x49, 0x0, x47, x44);
  let mut x50: u32 = 0;
  let mut x51: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x50, &mut x51, x49, x45, x42);
  let x52: u32 = ((x51 as u32) + x43);
  let mut x53: u32 = 0;
  let mut x54: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x53, &mut x54, 0x0, x23, x46);
  let mut x55: u32 = 0;
  let mut x56: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x55, &mut x56, x54, x25, x48);
  let mut x57: u32 = 0;
  let mut x58: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x57, &mut x58, x56, x27, x50);
  let mut x59: u32 = 0;
  let mut x60: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x59, &mut x60, x58, x29, x52);
  let mut x61: u32 = 0;
  let mut x62: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x61, &mut x62, x60, x31, (0x0 as u32));
  let mut x63: u32 = 0;
  let mut x64: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x63, &mut x64, x62, x33, (0x0 as u32));
  let mut x65: u32 = 0;
  let mut x66: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x65, &mut x66, x64, x35, x23);
  let mut x67: u32 = 0;
  let mut x68: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x67, &mut x68, x66, x37, x40);
  let mut x69: u32 = 0;
  let mut x70: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x69, &mut x70, x68, x39, x41);
  let mut x71: u32 = 0;
  let mut x72: u32 = 0;
  fiat_p256_mulx_u32(&mut x71, &mut x72, x1, (arg1[7]));
  let mut x73: u32 = 0;
  let mut x74: u32 = 0;
  fiat_p256_mulx_u32(&mut x73, &mut x74, x1, (arg1[6]));
  let mut x75: u32 = 0;
  let mut x76: u32 = 0;
  fiat_p256_mulx_u32(&mut x75, &mut x76, x1, (arg1[5]));
  let mut x77: u32 = 0;
  let mut x78: u32 = 0;
  fiat_p256_mulx_u32(&mut x77, &mut x78, x1, (arg1[4]));
  let mut x79: u32 = 0;
  let mut x80: u32 = 0;
  fiat_p256_mulx_u32(&mut x79, &mut x80, x1, (arg1[3]));
  let mut x81: u32 = 0;
  let mut x82: u32 = 0;
  fiat_p256_mulx_u32(&mut x81, &mut x82, x1, (arg1[2]));
  let mut x83: u32 = 0;
  let mut x84: u32 = 0;
  fiat_p256_mulx_u32(&mut x83, &mut x84, x1, (arg1[1]));
  let mut x85: u32 = 0;
  let mut x86: u32 = 0;
  fiat_p256_mulx_u32(&mut x85, &mut x86, x1, (arg1[0]));
  let mut x87: u32 = 0;
  let mut x88: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x87, &mut x88, 0x0, x86, x83);
  let mut x89: u32 = 0;
  let mut x90: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x89, &mut x90, x88, x84, x81);
  let mut x91: u32 = 0;
  let mut x92: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x91, &mut x92, x90, x82, x79);
  let mut x93: u32 = 0;
  let mut x94: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x93, &mut x94, x92, x80, x77);
  let mut x95: u32 = 0;
  let mut x96: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x95, &mut x96, x94, x78, x75);
  let mut x97: u32 = 0;
  let mut x98: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x97, &mut x98, x96, x76, x73);
  let mut x99: u32 = 0;
  let mut x100: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x99, &mut x100, x98, x74, x71);
  let x101: u32 = ((x100 as u32) + x72);
  let mut x102: u32 = 0;
  let mut x103: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x102, &mut x103, 0x0, x55, x85);
  let mut x104: u32 = 0;
  let mut x105: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x104, &mut x105, x103, x57, x87);
  let mut x106: u32 = 0;
  let mut x107: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x106, &mut x107, x105, x59, x89);
  let mut x108: u32 = 0;
  let mut x109: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x108, &mut x109, x107, x61, x91);
  let mut x110: u32 = 0;
  let mut x111: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x110, &mut x111, x109, x63, x93);
  let mut x112: u32 = 0;
  let mut x113: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x112, &mut x113, x111, x65, x95);
  let mut x114: u32 = 0;
  let mut x115: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x114, &mut x115, x113, x67, x97);
  let mut x116: u32 = 0;
  let mut x117: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x116, &mut x117, x115, x69, x99);
  let mut x118: u32 = 0;
  let mut x119: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x118, &mut x119, x117, (x70 as u32), x101);
  let mut x120: u32 = 0;
  let mut x121: u32 = 0;
  fiat_p256_mulx_u32(&mut x120, &mut x121, x102, 0xffffffff);
  let mut x122: u32 = 0;
  let mut x123: u32 = 0;
  fiat_p256_mulx_u32(&mut x122, &mut x123, x102, 0xffffffff);
  let mut x124: u32 = 0;
  let mut x125: u32 = 0;
  fiat_p256_mulx_u32(&mut x124, &mut x125, x102, 0xffffffff);
  let mut x126: u32 = 0;
  let mut x127: u32 = 0;
  fiat_p256_mulx_u32(&mut x126, &mut x127, x102, 0xffffffff);
  let mut x128: u32 = 0;
  let mut x129: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x128, &mut x129, 0x0, x127, x124);
  let mut x130: u32 = 0;
  let mut x131: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x130, &mut x131, x129, x125, x122);
  let x132: u32 = ((x131 as u32) + x123);
  let mut x133: u32 = 0;
  let mut x134: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x133, &mut x134, 0x0, x102, x126);
  let mut x135: u32 = 0;
  let mut x136: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x135, &mut x136, x134, x104, x128);
  let mut x137: u32 = 0;
  let mut x138: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x137, &mut x138, x136, x106, x130);
  let mut x139: u32 = 0;
  let mut x140: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x139, &mut x140, x138, x108, x132);
  let mut x141: u32 = 0;
  let mut x142: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x141, &mut x142, x140, x110, (0x0 as u32));
  let mut x143: u32 = 0;
  let mut x144: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x143, &mut x144, x142, x112, (0x0 as u32));
  let mut x145: u32 = 0;
  let mut x146: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x145, &mut x146, x144, x114, x102);
  let mut x147: u32 = 0;
  let mut x148: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x147, &mut x148, x146, x116, x120);
  let mut x149: u32 = 0;
  let mut x150: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x149, &mut x150, x148, x118, x121);
  let x151: u32 = ((x150 as u32) + (x119 as u32));
  let mut x152: u32 = 0;
  let mut x153: u32 = 0;
  fiat_p256_mulx_u32(&mut x152, &mut x153, x2, (arg1[7]));
  let mut x154: u32 = 0;
  let mut x155: u32 = 0;
  fiat_p256_mulx_u32(&mut x154, &mut x155, x2, (arg1[6]));
  let mut x156: u32 = 0;
  let mut x157: u32 = 0;
  fiat_p256_mulx_u32(&mut x156, &mut x157, x2, (arg1[5]));
  let mut x158: u32 = 0;
  let mut x159: u32 = 0;
  fiat_p256_mulx_u32(&mut x158, &mut x159, x2, (arg1[4]));
  let mut x160: u32 = 0;
  let mut x161: u32 = 0;
  fiat_p256_mulx_u32(&mut x160, &mut x161, x2, (arg1[3]));
  let mut x162: u32 = 0;
  let mut x163: u32 = 0;
  fiat_p256_mulx_u32(&mut x162, &mut x163, x2, (arg1[2]));
  let mut x164: u32 = 0;
  let mut x165: u32 = 0;
  fiat_p256_mulx_u32(&mut x164, &mut x165, x2, (arg1[1]));
  let mut x166: u32 = 0;
  let mut x167: u32 = 0;
  fiat_p256_mulx_u32(&mut x166, &mut x167, x2, (arg1[0]));
  let mut x168: u32 = 0;
  let mut x169: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x168, &mut x169, 0x0, x167, x164);
  let mut x170: u32 = 0;
  let mut x171: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x170, &mut x171, x169, x165, x162);
  let mut x172: u32 = 0;
  let mut x173: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x172, &mut x173, x171, x163, x160);
  let mut x174: u32 = 0;
  let mut x175: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x174, &mut x175, x173, x161, x158);
  let mut x176: u32 = 0;
  let mut x177: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x176, &mut x177, x175, x159, x156);
  let mut x178: u32 = 0;
  let mut x179: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x178, &mut x179, x177, x157, x154);
  let mut x180: u32 = 0;
  let mut x181: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x180, &mut x181, x179, x155, x152);
  let x182: u32 = ((x181 as u32) + x153);
  let mut x183: u32 = 0;
  let mut x184: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x183, &mut x184, 0x0, x135, x166);
  let mut x185: u32 = 0;
  let mut x186: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x185, &mut x186, x184, x137, x168);
  let mut x187: u32 = 0;
  let mut x188: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x187, &mut x188, x186, x139, x170);
  let mut x189: u32 = 0;
  let mut x190: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x189, &mut x190, x188, x141, x172);
  let mut x191: u32 = 0;
  let mut x192: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x191, &mut x192, x190, x143, x174);
  let mut x193: u32 = 0;
  let mut x194: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x193, &mut x194, x192, x145, x176);
  let mut x195: u32 = 0;
  let mut x196: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x195, &mut x196, x194, x147, x178);
  let mut x197: u32 = 0;
  let mut x198: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x197, &mut x198, x196, x149, x180);
  let mut x199: u32 = 0;
  let mut x200: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x199, &mut x200, x198, x151, x182);
  let mut x201: u32 = 0;
  let mut x202: u32 = 0;
  fiat_p256_mulx_u32(&mut x201, &mut x202, x183, 0xffffffff);
  let mut x203: u32 = 0;
  let mut x204: u32 = 0;
  fiat_p256_mulx_u32(&mut x203, &mut x204, x183, 0xffffffff);
  let mut x205: u32 = 0;
  let mut x206: u32 = 0;
  fiat_p256_mulx_u32(&mut x205, &mut x206, x183, 0xffffffff);
  let mut x207: u32 = 0;
  let mut x208: u32 = 0;
  fiat_p256_mulx_u32(&mut x207, &mut x208, x183, 0xffffffff);
  let mut x209: u32 = 0;
  let mut x210: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x209, &mut x210, 0x0, x208, x205);
  let mut x211: u32 = 0;
  let mut x212: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x211, &mut x212, x210, x206, x203);
  let x213: u32 = ((x212 as u32) + x204);
  let mut x214: u32 = 0;
  let mut x215: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x214, &mut x215, 0x0, x183, x207);
  let mut x216: u32 = 0;
  let mut x217: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x216, &mut x217, x215, x185, x209);
  let mut x218: u32 = 0;
  let mut x219: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x218, &mut x219, x217, x187, x211);
  let mut x220: u32 = 0;
  let mut x221: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x220, &mut x221, x219, x189, x213);
  let mut x222: u32 = 0;
  let mut x223: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x222, &mut x223, x221, x191, (0x0 as u32));
  let mut x224: u32 = 0;
  let mut x225: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x224, &mut x225, x223, x193, (0x0 as u32));
  let mut x226: u32 = 0;
  let mut x227: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x226, &mut x227, x225, x195, x183);
  let mut x228: u32 = 0;
  let mut x229: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x228, &mut x229, x227, x197, x201);
  let mut x230: u32 = 0;
  let mut x231: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x230, &mut x231, x229, x199, x202);
  let x232: u32 = ((x231 as u32) + (x200 as u32));
  let mut x233: u32 = 0;
  let mut x234: u32 = 0;
  fiat_p256_mulx_u32(&mut x233, &mut x234, x3, (arg1[7]));
  let mut x235: u32 = 0;
  let mut x236: u32 = 0;
  fiat_p256_mulx_u32(&mut x235, &mut x236, x3, (arg1[6]));
  let mut x237: u32 = 0;
  let mut x238: u32 = 0;
  fiat_p256_mulx_u32(&mut x237, &mut x238, x3, (arg1[5]));
  let mut x239: u32 = 0;
  let mut x240: u32 = 0;
  fiat_p256_mulx_u32(&mut x239, &mut x240, x3, (arg1[4]));
  let mut x241: u32 = 0;
  let mut x242: u32 = 0;
  fiat_p256_mulx_u32(&mut x241, &mut x242, x3, (arg1[3]));
  let mut x243: u32 = 0;
  let mut x244: u32 = 0;
  fiat_p256_mulx_u32(&mut x243, &mut x244, x3, (arg1[2]));
  let mut x245: u32 = 0;
  let mut x246: u32 = 0;
  fiat_p256_mulx_u32(&mut x245, &mut x246, x3, (arg1[1]));
  let mut x247: u32 = 0;
  let mut x248: u32 = 0;
  fiat_p256_mulx_u32(&mut x247, &mut x248, x3, (arg1[0]));
  let mut x249: u32 = 0;
  let mut x250: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x249, &mut x250, 0x0, x248, x245);
  let mut x251: u32 = 0;
  let mut x252: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x251, &mut x252, x250, x246, x243);
  let mut x253: u32 = 0;
  let mut x254: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x253, &mut x254, x252, x244, x241);
  let mut x255: u32 = 0;
  let mut x256: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x255, &mut x256, x254, x242, x239);
  let mut x257: u32 = 0;
  let mut x258: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x257, &mut x258, x256, x240, x237);
  let mut x259: u32 = 0;
  let mut x260: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x259, &mut x260, x258, x238, x235);
  let mut x261: u32 = 0;
  let mut x262: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x261, &mut x262, x260, x236, x233);
  let x263: u32 = ((x262 as u32) + x234);
  let mut x264: u32 = 0;
  let mut x265: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x264, &mut x265, 0x0, x216, x247);
  let mut x266: u32 = 0;
  let mut x267: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x266, &mut x267, x265, x218, x249);
  let mut x268: u32 = 0;
  let mut x269: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x268, &mut x269, x267, x220, x251);
  let mut x270: u32 = 0;
  let mut x271: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x270, &mut x271, x269, x222, x253);
  let mut x272: u32 = 0;
  let mut x273: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x272, &mut x273, x271, x224, x255);
  let mut x274: u32 = 0;
  let mut x275: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x274, &mut x275, x273, x226, x257);
  let mut x276: u32 = 0;
  let mut x277: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x276, &mut x277, x275, x228, x259);
  let mut x278: u32 = 0;
  let mut x279: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x278, &mut x279, x277, x230, x261);
  let mut x280: u32 = 0;
  let mut x281: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x280, &mut x281, x279, x232, x263);
  let mut x282: u32 = 0;
  let mut x283: u32 = 0;
  fiat_p256_mulx_u32(&mut x282, &mut x283, x264, 0xffffffff);
  let mut x284: u32 = 0;
  let mut x285: u32 = 0;
  fiat_p256_mulx_u32(&mut x284, &mut x285, x264, 0xffffffff);
  let mut x286: u32 = 0;
  let mut x287: u32 = 0;
  fiat_p256_mulx_u32(&mut x286, &mut x287, x264, 0xffffffff);
  let mut x288: u32 = 0;
  let mut x289: u32 = 0;
  fiat_p256_mulx_u32(&mut x288, &mut x289, x264, 0xffffffff);
  let mut x290: u32 = 0;
  let mut x291: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x290, &mut x291, 0x0, x289, x286);
  let mut x292: u32 = 0;
  let mut x293: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x292, &mut x293, x291, x287, x284);
  let x294: u32 = ((x293 as u32) + x285);
  let mut x295: u32 = 0;
  let mut x296: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x295, &mut x296, 0x0, x264, x288);
  let mut x297: u32 = 0;
  let mut x298: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x297, &mut x298, x296, x266, x290);
  let mut x299: u32 = 0;
  let mut x300: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x299, &mut x300, x298, x268, x292);
  let mut x301: u32 = 0;
  let mut x302: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x301, &mut x302, x300, x270, x294);
  let mut x303: u32 = 0;
  let mut x304: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x303, &mut x304, x302, x272, (0x0 as u32));
  let mut x305: u32 = 0;
  let mut x306: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x305, &mut x306, x304, x274, (0x0 as u32));
  let mut x307: u32 = 0;
  let mut x308: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x307, &mut x308, x306, x276, x264);
  let mut x309: u32 = 0;
  let mut x310: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x309, &mut x310, x308, x278, x282);
  let mut x311: u32 = 0;
  let mut x312: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x311, &mut x312, x310, x280, x283);
  let x313: u32 = ((x312 as u32) + (x281 as u32));
  let mut x314: u32 = 0;
  let mut x315: u32 = 0;
  fiat_p256_mulx_u32(&mut x314, &mut x315, x4, (arg1[7]));
  let mut x316: u32 = 0;
  let mut x317: u32 = 0;
  fiat_p256_mulx_u32(&mut x316, &mut x317, x4, (arg1[6]));
  let mut x318: u32 = 0;
  let mut x319: u32 = 0;
  fiat_p256_mulx_u32(&mut x318, &mut x319, x4, (arg1[5]));
  let mut x320: u32 = 0;
  let mut x321: u32 = 0;
  fiat_p256_mulx_u32(&mut x320, &mut x321, x4, (arg1[4]));
  let mut x322: u32 = 0;
  let mut x323: u32 = 0;
  fiat_p256_mulx_u32(&mut x322, &mut x323, x4, (arg1[3]));
  let mut x324: u32 = 0;
  let mut x325: u32 = 0;
  fiat_p256_mulx_u32(&mut x324, &mut x325, x4, (arg1[2]));
  let mut x326: u32 = 0;
  let mut x327: u32 = 0;
  fiat_p256_mulx_u32(&mut x326, &mut x327, x4, (arg1[1]));
  let mut x328: u32 = 0;
  let mut x329: u32 = 0;
  fiat_p256_mulx_u32(&mut x328, &mut x329, x4, (arg1[0]));
  let mut x330: u32 = 0;
  let mut x331: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x330, &mut x331, 0x0, x329, x326);
  let mut x332: u32 = 0;
  let mut x333: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x332, &mut x333, x331, x327, x324);
  let mut x334: u32 = 0;
  let mut x335: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x334, &mut x335, x333, x325, x322);
  let mut x336: u32 = 0;
  let mut x337: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x336, &mut x337, x335, x323, x320);
  let mut x338: u32 = 0;
  let mut x339: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x338, &mut x339, x337, x321, x318);
  let mut x340: u32 = 0;
  let mut x341: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x340, &mut x341, x339, x319, x316);
  let mut x342: u32 = 0;
  let mut x343: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x342, &mut x343, x341, x317, x314);
  let x344: u32 = ((x343 as u32) + x315);
  let mut x345: u32 = 0;
  let mut x346: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x345, &mut x346, 0x0, x297, x328);
  let mut x347: u32 = 0;
  let mut x348: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x347, &mut x348, x346, x299, x330);
  let mut x349: u32 = 0;
  let mut x350: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x349, &mut x350, x348, x301, x332);
  let mut x351: u32 = 0;
  let mut x352: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x351, &mut x352, x350, x303, x334);
  let mut x353: u32 = 0;
  let mut x354: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x353, &mut x354, x352, x305, x336);
  let mut x355: u32 = 0;
  let mut x356: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x355, &mut x356, x354, x307, x338);
  let mut x357: u32 = 0;
  let mut x358: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x357, &mut x358, x356, x309, x340);
  let mut x359: u32 = 0;
  let mut x360: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x359, &mut x360, x358, x311, x342);
  let mut x361: u32 = 0;
  let mut x362: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x361, &mut x362, x360, x313, x344);
  let mut x363: u32 = 0;
  let mut x364: u32 = 0;
  fiat_p256_mulx_u32(&mut x363, &mut x364, x345, 0xffffffff);
  let mut x365: u32 = 0;
  let mut x366: u32 = 0;
  fiat_p256_mulx_u32(&mut x365, &mut x366, x345, 0xffffffff);
  let mut x367: u32 = 0;
  let mut x368: u32 = 0;
  fiat_p256_mulx_u32(&mut x367, &mut x368, x345, 0xffffffff);
  let mut x369: u32 = 0;
  let mut x370: u32 = 0;
  fiat_p256_mulx_u32(&mut x369, &mut x370, x345, 0xffffffff);
  let mut x371: u32 = 0;
  let mut x372: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x371, &mut x372, 0x0, x370, x367);
  let mut x373: u32 = 0;
  let mut x374: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x373, &mut x374, x372, x368, x365);
  let x375: u32 = ((x374 as u32) + x366);
  let mut x376: u32 = 0;
  let mut x377: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x376, &mut x377, 0x0, x345, x369);
  let mut x378: u32 = 0;
  let mut x379: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x378, &mut x379, x377, x347, x371);
  let mut x380: u32 = 0;
  let mut x381: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x380, &mut x381, x379, x349, x373);
  let mut x382: u32 = 0;
  let mut x383: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x382, &mut x383, x381, x351, x375);
  let mut x384: u32 = 0;
  let mut x385: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x384, &mut x385, x383, x353, (0x0 as u32));
  let mut x386: u32 = 0;
  let mut x387: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x386, &mut x387, x385, x355, (0x0 as u32));
  let mut x388: u32 = 0;
  let mut x389: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x388, &mut x389, x387, x357, x345);
  let mut x390: u32 = 0;
  let mut x391: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x390, &mut x391, x389, x359, x363);
  let mut x392: u32 = 0;
  let mut x393: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x392, &mut x393, x391, x361, x364);
  let x394: u32 = ((x393 as u32) + (x362 as u32));
  let mut x395: u32 = 0;
  let mut x396: u32 = 0;
  fiat_p256_mulx_u32(&mut x395, &mut x396, x5, (arg1[7]));
  let mut x397: u32 = 0;
  let mut x398: u32 = 0;
  fiat_p256_mulx_u32(&mut x397, &mut x398, x5, (arg1[6]));
  let mut x399: u32 = 0;
  let mut x400: u32 = 0;
  fiat_p256_mulx_u32(&mut x399, &mut x400, x5, (arg1[5]));
  let mut x401: u32 = 0;
  let mut x402: u32 = 0;
  fiat_p256_mulx_u32(&mut x401, &mut x402, x5, (arg1[4]));
  let mut x403: u32 = 0;
  let mut x404: u32 = 0;
  fiat_p256_mulx_u32(&mut x403, &mut x404, x5, (arg1[3]));
  let mut x405: u32 = 0;
  let mut x406: u32 = 0;
  fiat_p256_mulx_u32(&mut x405, &mut x406, x5, (arg1[2]));
  let mut x407: u32 = 0;
  let mut x408: u32 = 0;
  fiat_p256_mulx_u32(&mut x407, &mut x408, x5, (arg1[1]));
  let mut x409: u32 = 0;
  let mut x410: u32 = 0;
  fiat_p256_mulx_u32(&mut x409, &mut x410, x5, (arg1[0]));
  let mut x411: u32 = 0;
  let mut x412: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x411, &mut x412, 0x0, x410, x407);
  let mut x413: u32 = 0;
  let mut x414: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x413, &mut x414, x412, x408, x405);
  let mut x415: u32 = 0;
  let mut x416: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x415, &mut x416, x414, x406, x403);
  let mut x417: u32 = 0;
  let mut x418: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x417, &mut x418, x416, x404, x401);
  let mut x419: u32 = 0;
  let mut x420: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x419, &mut x420, x418, x402, x399);
  let mut x421: u32 = 0;
  let mut x422: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x421, &mut x422, x420, x400, x397);
  let mut x423: u32 = 0;
  let mut x424: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x423, &mut x424, x422, x398, x395);
  let x425: u32 = ((x424 as u32) + x396);
  let mut x426: u32 = 0;
  let mut x427: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x426, &mut x427, 0x0, x378, x409);
  let mut x428: u32 = 0;
  let mut x429: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x428, &mut x429, x427, x380, x411);
  let mut x430: u32 = 0;
  let mut x431: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x430, &mut x431, x429, x382, x413);
  let mut x432: u32 = 0;
  let mut x433: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x432, &mut x433, x431, x384, x415);
  let mut x434: u32 = 0;
  let mut x435: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x434, &mut x435, x433, x386, x417);
  let mut x436: u32 = 0;
  let mut x437: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x436, &mut x437, x435, x388, x419);
  let mut x438: u32 = 0;
  let mut x439: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x438, &mut x439, x437, x390, x421);
  let mut x440: u32 = 0;
  let mut x441: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x440, &mut x441, x439, x392, x423);
  let mut x442: u32 = 0;
  let mut x443: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x442, &mut x443, x441, x394, x425);
  let mut x444: u32 = 0;
  let mut x445: u32 = 0;
  fiat_p256_mulx_u32(&mut x444, &mut x445, x426, 0xffffffff);
  let mut x446: u32 = 0;
  let mut x447: u32 = 0;
  fiat_p256_mulx_u32(&mut x446, &mut x447, x426, 0xffffffff);
  let mut x448: u32 = 0;
  let mut x449: u32 = 0;
  fiat_p256_mulx_u32(&mut x448, &mut x449, x426, 0xffffffff);
  let mut x450: u32 = 0;
  let mut x451: u32 = 0;
  fiat_p256_mulx_u32(&mut x450, &mut x451, x426, 0xffffffff);
  let mut x452: u32 = 0;
  let mut x453: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x452, &mut x453, 0x0, x451, x448);
  let mut x454: u32 = 0;
  let mut x455: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x454, &mut x455, x453, x449, x446);
  let x456: u32 = ((x455 as u32) + x447);
  let mut x457: u32 = 0;
  let mut x458: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x457, &mut x458, 0x0, x426, x450);
  let mut x459: u32 = 0;
  let mut x460: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x459, &mut x460, x458, x428, x452);
  let mut x461: u32 = 0;
  let mut x462: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x461, &mut x462, x460, x430, x454);
  let mut x463: u32 = 0;
  let mut x464: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x463, &mut x464, x462, x432, x456);
  let mut x465: u32 = 0;
  let mut x466: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x465, &mut x466, x464, x434, (0x0 as u32));
  let mut x467: u32 = 0;
  let mut x468: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x467, &mut x468, x466, x436, (0x0 as u32));
  let mut x469: u32 = 0;
  let mut x470: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x469, &mut x470, x468, x438, x426);
  let mut x471: u32 = 0;
  let mut x472: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x471, &mut x472, x470, x440, x444);
  let mut x473: u32 = 0;
  let mut x474: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x473, &mut x474, x472, x442, x445);
  let x475: u32 = ((x474 as u32) + (x443 as u32));
  let mut x476: u32 = 0;
  let mut x477: u32 = 0;
  fiat_p256_mulx_u32(&mut x476, &mut x477, x6, (arg1[7]));
  let mut x478: u32 = 0;
  let mut x479: u32 = 0;
  fiat_p256_mulx_u32(&mut x478, &mut x479, x6, (arg1[6]));
  let mut x480: u32 = 0;
  let mut x481: u32 = 0;
  fiat_p256_mulx_u32(&mut x480, &mut x481, x6, (arg1[5]));
  let mut x482: u32 = 0;
  let mut x483: u32 = 0;
  fiat_p256_mulx_u32(&mut x482, &mut x483, x6, (arg1[4]));
  let mut x484: u32 = 0;
  let mut x485: u32 = 0;
  fiat_p256_mulx_u32(&mut x484, &mut x485, x6, (arg1[3]));
  let mut x486: u32 = 0;
  let mut x487: u32 = 0;
  fiat_p256_mulx_u32(&mut x486, &mut x487, x6, (arg1[2]));
  let mut x488: u32 = 0;
  let mut x489: u32 = 0;
  fiat_p256_mulx_u32(&mut x488, &mut x489, x6, (arg1[1]));
  let mut x490: u32 = 0;
  let mut x491: u32 = 0;
  fiat_p256_mulx_u32(&mut x490, &mut x491, x6, (arg1[0]));
  let mut x492: u32 = 0;
  let mut x493: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x492, &mut x493, 0x0, x491, x488);
  let mut x494: u32 = 0;
  let mut x495: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x494, &mut x495, x493, x489, x486);
  let mut x496: u32 = 0;
  let mut x497: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x496, &mut x497, x495, x487, x484);
  let mut x498: u32 = 0;
  let mut x499: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x498, &mut x499, x497, x485, x482);
  let mut x500: u32 = 0;
  let mut x501: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x500, &mut x501, x499, x483, x480);
  let mut x502: u32 = 0;
  let mut x503: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x502, &mut x503, x501, x481, x478);
  let mut x504: u32 = 0;
  let mut x505: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x504, &mut x505, x503, x479, x476);
  let x506: u32 = ((x505 as u32) + x477);
  let mut x507: u32 = 0;
  let mut x508: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x507, &mut x508, 0x0, x459, x490);
  let mut x509: u32 = 0;
  let mut x510: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x509, &mut x510, x508, x461, x492);
  let mut x511: u32 = 0;
  let mut x512: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x511, &mut x512, x510, x463, x494);
  let mut x513: u32 = 0;
  let mut x514: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x513, &mut x514, x512, x465, x496);
  let mut x515: u32 = 0;
  let mut x516: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x515, &mut x516, x514, x467, x498);
  let mut x517: u32 = 0;
  let mut x518: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x517, &mut x518, x516, x469, x500);
  let mut x519: u32 = 0;
  let mut x520: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x519, &mut x520, x518, x471, x502);
  let mut x521: u32 = 0;
  let mut x522: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x521, &mut x522, x520, x473, x504);
  let mut x523: u32 = 0;
  let mut x524: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x523, &mut x524, x522, x475, x506);
  let mut x525: u32 = 0;
  let mut x526: u32 = 0;
  fiat_p256_mulx_u32(&mut x525, &mut x526, x507, 0xffffffff);
  let mut x527: u32 = 0;
  let mut x528: u32 = 0;
  fiat_p256_mulx_u32(&mut x527, &mut x528, x507, 0xffffffff);
  let mut x529: u32 = 0;
  let mut x530: u32 = 0;
  fiat_p256_mulx_u32(&mut x529, &mut x530, x507, 0xffffffff);
  let mut x531: u32 = 0;
  let mut x532: u32 = 0;
  fiat_p256_mulx_u32(&mut x531, &mut x532, x507, 0xffffffff);
  let mut x533: u32 = 0;
  let mut x534: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x533, &mut x534, 0x0, x532, x529);
  let mut x535: u32 = 0;
  let mut x536: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x535, &mut x536, x534, x530, x527);
  let x537: u32 = ((x536 as u32) + x528);
  let mut x538: u32 = 0;
  let mut x539: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x538, &mut x539, 0x0, x507, x531);
  let mut x540: u32 = 0;
  let mut x541: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x540, &mut x541, x539, x509, x533);
  let mut x542: u32 = 0;
  let mut x543: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x542, &mut x543, x541, x511, x535);
  let mut x544: u32 = 0;
  let mut x545: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x544, &mut x545, x543, x513, x537);
  let mut x546: u32 = 0;
  let mut x547: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x546, &mut x547, x545, x515, (0x0 as u32));
  let mut x548: u32 = 0;
  let mut x549: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x548, &mut x549, x547, x517, (0x0 as u32));
  let mut x550: u32 = 0;
  let mut x551: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x550, &mut x551, x549, x519, x507);
  let mut x552: u32 = 0;
  let mut x553: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x552, &mut x553, x551, x521, x525);
  let mut x554: u32 = 0;
  let mut x555: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x554, &mut x555, x553, x523, x526);
  let x556: u32 = ((x555 as u32) + (x524 as u32));
  let mut x557: u32 = 0;
  let mut x558: u32 = 0;
  fiat_p256_mulx_u32(&mut x557, &mut x558, x7, (arg1[7]));
  let mut x559: u32 = 0;
  let mut x560: u32 = 0;
  fiat_p256_mulx_u32(&mut x559, &mut x560, x7, (arg1[6]));
  let mut x561: u32 = 0;
  let mut x562: u32 = 0;
  fiat_p256_mulx_u32(&mut x561, &mut x562, x7, (arg1[5]));
  let mut x563: u32 = 0;
  let mut x564: u32 = 0;
  fiat_p256_mulx_u32(&mut x563, &mut x564, x7, (arg1[4]));
  let mut x565: u32 = 0;
  let mut x566: u32 = 0;
  fiat_p256_mulx_u32(&mut x565, &mut x566, x7, (arg1[3]));
  let mut x567: u32 = 0;
  let mut x568: u32 = 0;
  fiat_p256_mulx_u32(&mut x567, &mut x568, x7, (arg1[2]));
  let mut x569: u32 = 0;
  let mut x570: u32 = 0;
  fiat_p256_mulx_u32(&mut x569, &mut x570, x7, (arg1[1]));
  let mut x571: u32 = 0;
  let mut x572: u32 = 0;
  fiat_p256_mulx_u32(&mut x571, &mut x572, x7, (arg1[0]));
  let mut x573: u32 = 0;
  let mut x574: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x573, &mut x574, 0x0, x572, x569);
  let mut x575: u32 = 0;
  let mut x576: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x575, &mut x576, x574, x570, x567);
  let mut x577: u32 = 0;
  let mut x578: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x577, &mut x578, x576, x568, x565);
  let mut x579: u32 = 0;
  let mut x580: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x579, &mut x580, x578, x566, x563);
  let mut x581: u32 = 0;
  let mut x582: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x581, &mut x582, x580, x564, x561);
  let mut x583: u32 = 0;
  let mut x584: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x583, &mut x584, x582, x562, x559);
  let mut x585: u32 = 0;
  let mut x586: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x585, &mut x586, x584, x560, x557);
  let x587: u32 = ((x586 as u32) + x558);
  let mut x588: u32 = 0;
  let mut x589: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x588, &mut x589, 0x0, x540, x571);
  let mut x590: u32 = 0;
  let mut x591: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x590, &mut x591, x589, x542, x573);
  let mut x592: u32 = 0;
  let mut x593: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x592, &mut x593, x591, x544, x575);
  let mut x594: u32 = 0;
  let mut x595: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x594, &mut x595, x593, x546, x577);
  let mut x596: u32 = 0;
  let mut x597: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x596, &mut x597, x595, x548, x579);
  let mut x598: u32 = 0;
  let mut x599: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x598, &mut x599, x597, x550, x581);
  let mut x600: u32 = 0;
  let mut x601: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x600, &mut x601, x599, x552, x583);
  let mut x602: u32 = 0;
  let mut x603: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x602, &mut x603, x601, x554, x585);
  let mut x604: u32 = 0;
  let mut x605: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x604, &mut x605, x603, x556, x587);
  let mut x606: u32 = 0;
  let mut x607: u32 = 0;
  fiat_p256_mulx_u32(&mut x606, &mut x607, x588, 0xffffffff);
  let mut x608: u32 = 0;
  let mut x609: u32 = 0;
  fiat_p256_mulx_u32(&mut x608, &mut x609, x588, 0xffffffff);
  let mut x610: u32 = 0;
  let mut x611: u32 = 0;
  fiat_p256_mulx_u32(&mut x610, &mut x611, x588, 0xffffffff);
  let mut x612: u32 = 0;
  let mut x613: u32 = 0;
  fiat_p256_mulx_u32(&mut x612, &mut x613, x588, 0xffffffff);
  let mut x614: u32 = 0;
  let mut x615: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x614, &mut x615, 0x0, x613, x610);
  let mut x616: u32 = 0;
  let mut x617: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x616, &mut x617, x615, x611, x608);
  let x618: u32 = ((x617 as u32) + x609);
  let mut x619: u32 = 0;
  let mut x620: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x619, &mut x620, 0x0, x588, x612);
  let mut x621: u32 = 0;
  let mut x622: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x621, &mut x622, x620, x590, x614);
  let mut x623: u32 = 0;
  let mut x624: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x623, &mut x624, x622, x592, x616);
  let mut x625: u32 = 0;
  let mut x626: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x625, &mut x626, x624, x594, x618);
  let mut x627: u32 = 0;
  let mut x628: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x627, &mut x628, x626, x596, (0x0 as u32));
  let mut x629: u32 = 0;
  let mut x630: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x629, &mut x630, x628, x598, (0x0 as u32));
  let mut x631: u32 = 0;
  let mut x632: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x631, &mut x632, x630, x600, x588);
  let mut x633: u32 = 0;
  let mut x634: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x633, &mut x634, x632, x602, x606);
  let mut x635: u32 = 0;
  let mut x636: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x635, &mut x636, x634, x604, x607);
  let x637: u32 = ((x636 as u32) + (x605 as u32));
  let mut x638: u32 = 0;
  let mut x639: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x638, &mut x639, 0x0, x621, 0xffffffff);
  let mut x640: u32 = 0;
  let mut x641: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x640, &mut x641, x639, x623, 0xffffffff);
  let mut x642: u32 = 0;
  let mut x643: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x642, &mut x643, x641, x625, 0xffffffff);
  let mut x644: u32 = 0;
  let mut x645: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x644, &mut x645, x643, x627, (0x0 as u32));
  let mut x646: u32 = 0;
  let mut x647: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x646, &mut x647, x645, x629, (0x0 as u32));
  let mut x648: u32 = 0;
  let mut x649: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x648, &mut x649, x647, x631, (0x0 as u32));
  let mut x650: u32 = 0;
  let mut x651: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x650, &mut x651, x649, x633, (0x1 as u32));
  let mut x652: u32 = 0;
  let mut x653: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x652, &mut x653, x651, x635, 0xffffffff);
  let mut x654: u32 = 0;
  let mut x655: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x654, &mut x655, x653, x637, (0x0 as u32));
  let mut x656: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x656, x655, x638, x621);
  let mut x657: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x657, x655, x640, x623);
  let mut x658: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x658, x655, x642, x625);
  let mut x659: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x659, x655, x644, x627);
  let mut x660: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x660, x655, x646, x629);
  let mut x661: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x661, x655, x648, x631);
  let mut x662: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x662, x655, x650, x633);
  let mut x663: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x663, x655, x652, x635);
  out1[0] = x656;
  out1[1] = x657;
  out1[2] = x658;
  out1[3] = x659;
  out1[4] = x660;
  out1[5] = x661;
  out1[6] = x662;
  out1[7] = x663;
}

/// The function fiat_p256_add adds two field elements in the Montgomery domain.
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p256_add(out1: &mut [u32; 8], arg1: &[u32; 8], arg2: &[u32; 8]) -> () {
  let mut x1: u32 = 0;
  let mut x2: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x1, &mut x2, 0x0, (arg1[0]), (arg2[0]));
  let mut x3: u32 = 0;
  let mut x4: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x3, &mut x4, x2, (arg1[1]), (arg2[1]));
  let mut x5: u32 = 0;
  let mut x6: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x5, &mut x6, x4, (arg1[2]), (arg2[2]));
  let mut x7: u32 = 0;
  let mut x8: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x7, &mut x8, x6, (arg1[3]), (arg2[3]));
  let mut x9: u32 = 0;
  let mut x10: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x9, &mut x10, x8, (arg1[4]), (arg2[4]));
  let mut x11: u32 = 0;
  let mut x12: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x11, &mut x12, x10, (arg1[5]), (arg2[5]));
  let mut x13: u32 = 0;
  let mut x14: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x13, &mut x14, x12, (arg1[6]), (arg2[6]));
  let mut x15: u32 = 0;
  let mut x16: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x15, &mut x16, x14, (arg1[7]), (arg2[7]));
  let mut x17: u32 = 0;
  let mut x18: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x17, &mut x18, 0x0, x1, 0xffffffff);
  let mut x19: u32 = 0;
  let mut x20: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x19, &mut x20, x18, x3, 0xffffffff);
  let mut x21: u32 = 0;
  let mut x22: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x21, &mut x22, x20, x5, 0xffffffff);
  let mut x23: u32 = 0;
  let mut x24: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x23, &mut x24, x22, x7, (0x0 as u32));
  let mut x25: u32 = 0;
  let mut x26: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x25, &mut x26, x24, x9, (0x0 as u32));
  let mut x27: u32 = 0;
  let mut x28: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x27, &mut x28, x26, x11, (0x0 as u32));
  let mut x29: u32 = 0;
  let mut x30: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x29, &mut x30, x28, x13, (0x1 as u32));
  let mut x31: u32 = 0;
  let mut x32: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x31, &mut x32, x30, x15, 0xffffffff);
  let mut x33: u32 = 0;
  let mut x34: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x33, &mut x34, x32, (x16 as u32), (0x0 as u32));
  let mut x35: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x35, x34, x17, x1);
  let mut x36: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x36, x34, x19, x3);
  let mut x37: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x37, x34, x21, x5);
  let mut x38: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x38, x34, x23, x7);
  let mut x39: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x39, x34, x25, x9);
  let mut x40: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x40, x34, x27, x11);
  let mut x41: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x41, x34, x29, x13);
  let mut x42: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x42, x34, x31, x15);
  out1[0] = x35;
  out1[1] = x36;
  out1[2] = x37;
  out1[3] = x38;
  out1[4] = x39;
  out1[5] = x40;
  out1[6] = x41;
  out1[7] = x42;
}

/// The function fiat_p256_sub subtracts two field elements in the Montgomery domain.
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p256_sub(out1: &mut [u32; 8], arg1: &[u32; 8], arg2: &[u32; 8]) -> () {
  let mut x1: u32 = 0;
  let mut x2: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x1, &mut x2, 0x0, (arg1[0]), (arg2[0]));
  let mut x3: u32 = 0;
  let mut x4: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x3, &mut x4, x2, (arg1[1]), (arg2[1]));
  let mut x5: u32 = 0;
  let mut x6: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x5, &mut x6, x4, (arg1[2]), (arg2[2]));
  let mut x7: u32 = 0;
  let mut x8: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x7, &mut x8, x6, (arg1[3]), (arg2[3]));
  let mut x9: u32 = 0;
  let mut x10: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x9, &mut x10, x8, (arg1[4]), (arg2[4]));
  let mut x11: u32 = 0;
  let mut x12: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x11, &mut x12, x10, (arg1[5]), (arg2[5]));
  let mut x13: u32 = 0;
  let mut x14: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x13, &mut x14, x12, (arg1[6]), (arg2[6]));
  let mut x15: u32 = 0;
  let mut x16: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x15, &mut x16, x14, (arg1[7]), (arg2[7]));
  let mut x17: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x17, x16, (0x0 as u32), 0xffffffff);
  let mut x18: u32 = 0;
  let mut x19: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x18, &mut x19, 0x0, x1, x17);
  let mut x20: u32 = 0;
  let mut x21: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x20, &mut x21, x19, x3, x17);
  let mut x22: u32 = 0;
  let mut x23: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x22, &mut x23, x21, x5, x17);
  let mut x24: u32 = 0;
  let mut x25: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x24, &mut x25, x23, x7, (0x0 as u32));
  let mut x26: u32 = 0;
  let mut x27: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x26, &mut x27, x25, x9, (0x0 as u32));
  let mut x28: u32 = 0;
  let mut x29: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x28, &mut x29, x27, x11, (0x0 as u32));
  let mut x30: u32 = 0;
  let mut x31: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x30, &mut x31, x29, x13, (((x17 & (0x1 as u32)) as fiat_p256_u1) as u32));
  let mut x32: u32 = 0;
  let mut x33: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x32, &mut x33, x31, x15, x17);
  out1[0] = x18;
  out1[1] = x20;
  out1[2] = x22;
  out1[3] = x24;
  out1[4] = x26;
  out1[5] = x28;
  out1[6] = x30;
  out1[7] = x32;
}

/// The function fiat_p256_opp negates a field element in the Montgomery domain.
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p256_opp(out1: &mut [u32; 8], arg1: &[u32; 8]) -> () {
  let mut x1: u32 = 0;
  let mut x2: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x1, &mut x2, 0x0, (0x0 as u32), (arg1[0]));
  let mut x3: u32 = 0;
  let mut x4: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x3, &mut x4, x2, (0x0 as u32), (arg1[1]));
  let mut x5: u32 = 0;
  let mut x6: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x5, &mut x6, x4, (0x0 as u32), (arg1[2]));
  let mut x7: u32 = 0;
  let mut x8: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x7, &mut x8, x6, (0x0 as u32), (arg1[3]));
  let mut x9: u32 = 0;
  let mut x10: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x9, &mut x10, x8, (0x0 as u32), (arg1[4]));
  let mut x11: u32 = 0;
  let mut x12: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x11, &mut x12, x10, (0x0 as u32), (arg1[5]));
  let mut x13: u32 = 0;
  let mut x14: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x13, &mut x14, x12, (0x0 as u32), (arg1[6]));
  let mut x15: u32 = 0;
  let mut x16: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x15, &mut x16, x14, (0x0 as u32), (arg1[7]));
  let mut x17: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x17, x16, (0x0 as u32), 0xffffffff);
  let mut x18: u32 = 0;
  let mut x19: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x18, &mut x19, 0x0, x1, x17);
  let mut x20: u32 = 0;
  let mut x21: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x20, &mut x21, x19, x3, x17);
  let mut x22: u32 = 0;
  let mut x23: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x22, &mut x23, x21, x5, x17);
  let mut x24: u32 = 0;
  let mut x25: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x24, &mut x25, x23, x7, (0x0 as u32));
  let mut x26: u32 = 0;
  let mut x27: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x26, &mut x27, x25, x9, (0x0 as u32));
  let mut x28: u32 = 0;
  let mut x29: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x28, &mut x29, x27, x11, (0x0 as u32));
  let mut x30: u32 = 0;
  let mut x31: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x30, &mut x31, x29, x13, (((x17 & (0x1 as u32)) as fiat_p256_u1) as u32));
  let mut x32: u32 = 0;
  let mut x33: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x32, &mut x33, x31, x15, x17);
  out1[0] = x18;
  out1[1] = x20;
  out1[2] = x22;
  out1[3] = x24;
  out1[4] = x26;
  out1[5] = x28;
  out1[6] = x30;
  out1[7] = x32;
}

/// The function fiat_p256_from_montgomery translates a field element out of the Montgomery domain.
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^8) mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p256_from_montgomery(out1: &mut [u32; 8], arg1: &[u32; 8]) -> () {
  let x1: u32 = (arg1[0]);
  let mut x2: u32 = 0;
  let mut x3: u32 = 0;
  fiat_p256_mulx_u32(&mut x2, &mut x3, x1, 0xffffffff);
  let mut x4: u32 = 0;
  let mut x5: u32 = 0;
  fiat_p256_mulx_u32(&mut x4, &mut x5, x1, 0xffffffff);
  let mut x6: u32 = 0;
  let mut x7: u32 = 0;
  fiat_p256_mulx_u32(&mut x6, &mut x7, x1, 0xffffffff);
  let mut x8: u32 = 0;
  let mut x9: u32 = 0;
  fiat_p256_mulx_u32(&mut x8, &mut x9, x1, 0xffffffff);
  let mut x10: u32 = 0;
  let mut x11: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x10, &mut x11, 0x0, x9, x6);
  let mut x12: u32 = 0;
  let mut x13: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x12, &mut x13, x11, x7, x4);
  let mut x14: u32 = 0;
  let mut x15: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x14, &mut x15, 0x0, x1, x8);
  let mut x16: u32 = 0;
  let mut x17: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x16, &mut x17, x15, (0x0 as u32), x10);
  let mut x18: u32 = 0;
  let mut x19: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x18, &mut x19, x17, (0x0 as u32), x12);
  let mut x20: u32 = 0;
  let mut x21: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x20, &mut x21, x19, (0x0 as u32), ((x13 as u32) + x5));
  let mut x22: u32 = 0;
  let mut x23: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x22, &mut x23, 0x0, x16, (arg1[1]));
  let mut x24: u32 = 0;
  let mut x25: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x24, &mut x25, x23, x18, (0x0 as u32));
  let mut x26: u32 = 0;
  let mut x27: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x26, &mut x27, x25, x20, (0x0 as u32));
  let mut x28: u32 = 0;
  let mut x29: u32 = 0;
  fiat_p256_mulx_u32(&mut x28, &mut x29, x22, 0xffffffff);
  let mut x30: u32 = 0;
  let mut x31: u32 = 0;
  fiat_p256_mulx_u32(&mut x30, &mut x31, x22, 0xffffffff);
  let mut x32: u32 = 0;
  let mut x33: u32 = 0;
  fiat_p256_mulx_u32(&mut x32, &mut x33, x22, 0xffffffff);
  let mut x34: u32 = 0;
  let mut x35: u32 = 0;
  fiat_p256_mulx_u32(&mut x34, &mut x35, x22, 0xffffffff);
  let mut x36: u32 = 0;
  let mut x37: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x36, &mut x37, 0x0, x35, x32);
  let mut x38: u32 = 0;
  let mut x39: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x38, &mut x39, x37, x33, x30);
  let mut x40: u32 = 0;
  let mut x41: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x40, &mut x41, 0x0, x22, x34);
  let mut x42: u32 = 0;
  let mut x43: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x42, &mut x43, x41, x24, x36);
  let mut x44: u32 = 0;
  let mut x45: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x44, &mut x45, x43, x26, x38);
  let mut x46: u32 = 0;
  let mut x47: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x46, &mut x47, x45, ((x27 as u32) + (x21 as u32)), ((x39 as u32) + x31));
  let mut x48: u32 = 0;
  let mut x49: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x48, &mut x49, 0x0, x2, x22);
  let mut x50: u32 = 0;
  let mut x51: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x50, &mut x51, x49, x3, x28);
  let mut x52: u32 = 0;
  let mut x53: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x52, &mut x53, 0x0, x42, (arg1[2]));
  let mut x54: u32 = 0;
  let mut x55: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x54, &mut x55, x53, x44, (0x0 as u32));
  let mut x56: u32 = 0;
  let mut x57: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x56, &mut x57, x55, x46, (0x0 as u32));
  let mut x58: u32 = 0;
  let mut x59: u32 = 0;
  fiat_p256_mulx_u32(&mut x58, &mut x59, x52, 0xffffffff);
  let mut x60: u32 = 0;
  let mut x61: u32 = 0;
  fiat_p256_mulx_u32(&mut x60, &mut x61, x52, 0xffffffff);
  let mut x62: u32 = 0;
  let mut x63: u32 = 0;
  fiat_p256_mulx_u32(&mut x62, &mut x63, x52, 0xffffffff);
  let mut x64: u32 = 0;
  let mut x65: u32 = 0;
  fiat_p256_mulx_u32(&mut x64, &mut x65, x52, 0xffffffff);
  let mut x66: u32 = 0;
  let mut x67: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x66, &mut x67, 0x0, x65, x62);
  let mut x68: u32 = 0;
  let mut x69: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x68, &mut x69, x67, x63, x60);
  let mut x70: u32 = 0;
  let mut x71: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x70, &mut x71, 0x0, x52, x64);
  let mut x72: u32 = 0;
  let mut x73: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x72, &mut x73, x71, x54, x66);
  let mut x74: u32 = 0;
  let mut x75: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x74, &mut x75, x73, x56, x68);
  let mut x76: u32 = 0;
  let mut x77: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x76, &mut x77, x75, ((x57 as u32) + (x47 as u32)), ((x69 as u32) + x61));
  let mut x78: u32 = 0;
  let mut x79: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x78, &mut x79, x77, x1, (0x0 as u32));
  let mut x80: u32 = 0;
  let mut x81: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x80, &mut x81, x79, x48, (0x0 as u32));
  let mut x82: u32 = 0;
  let mut x83: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x82, &mut x83, x81, x50, x52);
  let mut x84: u32 = 0;
  let mut x85: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x84, &mut x85, x83, ((x51 as u32) + x29), x58);
  let mut x86: u32 = 0;
  let mut x87: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x86, &mut x87, 0x0, x72, (arg1[3]));
  let mut x88: u32 = 0;
  let mut x89: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x88, &mut x89, x87, x74, (0x0 as u32));
  let mut x90: u32 = 0;
  let mut x91: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x90, &mut x91, x89, x76, (0x0 as u32));
  let mut x92: u32 = 0;
  let mut x93: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x92, &mut x93, x91, x78, (0x0 as u32));
  let mut x94: u32 = 0;
  let mut x95: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x94, &mut x95, x93, x80, (0x0 as u32));
  let mut x96: u32 = 0;
  let mut x97: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x96, &mut x97, x95, x82, (0x0 as u32));
  let mut x98: u32 = 0;
  let mut x99: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x98, &mut x99, x97, x84, (0x0 as u32));
  let mut x100: u32 = 0;
  let mut x101: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x100, &mut x101, x99, ((x85 as u32) + x59), (0x0 as u32));
  let mut x102: u32 = 0;
  let mut x103: u32 = 0;
  fiat_p256_mulx_u32(&mut x102, &mut x103, x86, 0xffffffff);
  let mut x104: u32 = 0;
  let mut x105: u32 = 0;
  fiat_p256_mulx_u32(&mut x104, &mut x105, x86, 0xffffffff);
  let mut x106: u32 = 0;
  let mut x107: u32 = 0;
  fiat_p256_mulx_u32(&mut x106, &mut x107, x86, 0xffffffff);
  let mut x108: u32 = 0;
  let mut x109: u32 = 0;
  fiat_p256_mulx_u32(&mut x108, &mut x109, x86, 0xffffffff);
  let mut x110: u32 = 0;
  let mut x111: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x110, &mut x111, 0x0, x109, x106);
  let mut x112: u32 = 0;
  let mut x113: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x112, &mut x113, x111, x107, x104);
  let mut x114: u32 = 0;
  let mut x115: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x114, &mut x115, 0x0, x86, x108);
  let mut x116: u32 = 0;
  let mut x117: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x116, &mut x117, x115, x88, x110);
  let mut x118: u32 = 0;
  let mut x119: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x118, &mut x119, x117, x90, x112);
  let mut x120: u32 = 0;
  let mut x121: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x120, &mut x121, x119, x92, ((x113 as u32) + x105));
  let mut x122: u32 = 0;
  let mut x123: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x122, &mut x123, x121, x94, (0x0 as u32));
  let mut x124: u32 = 0;
  let mut x125: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x124, &mut x125, x123, x96, (0x0 as u32));
  let mut x126: u32 = 0;
  let mut x127: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x126, &mut x127, x125, x98, x86);
  let mut x128: u32 = 0;
  let mut x129: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x128, &mut x129, x127, x100, x102);
  let mut x130: u32 = 0;
  let mut x131: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x130, &mut x131, x129, (x101 as u32), x103);
  let mut x132: u32 = 0;
  let mut x133: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x132, &mut x133, 0x0, x116, (arg1[4]));
  let mut x134: u32 = 0;
  let mut x135: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x134, &mut x135, x133, x118, (0x0 as u32));
  let mut x136: u32 = 0;
  let mut x137: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x136, &mut x137, x135, x120, (0x0 as u32));
  let mut x138: u32 = 0;
  let mut x139: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x138, &mut x139, x137, x122, (0x0 as u32));
  let mut x140: u32 = 0;
  let mut x141: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x140, &mut x141, x139, x124, (0x0 as u32));
  let mut x142: u32 = 0;
  let mut x143: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x142, &mut x143, x141, x126, (0x0 as u32));
  let mut x144: u32 = 0;
  let mut x145: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x144, &mut x145, x143, x128, (0x0 as u32));
  let mut x146: u32 = 0;
  let mut x147: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x146, &mut x147, x145, x130, (0x0 as u32));
  let mut x148: u32 = 0;
  let mut x149: u32 = 0;
  fiat_p256_mulx_u32(&mut x148, &mut x149, x132, 0xffffffff);
  let mut x150: u32 = 0;
  let mut x151: u32 = 0;
  fiat_p256_mulx_u32(&mut x150, &mut x151, x132, 0xffffffff);
  let mut x152: u32 = 0;
  let mut x153: u32 = 0;
  fiat_p256_mulx_u32(&mut x152, &mut x153, x132, 0xffffffff);
  let mut x154: u32 = 0;
  let mut x155: u32 = 0;
  fiat_p256_mulx_u32(&mut x154, &mut x155, x132, 0xffffffff);
  let mut x156: u32 = 0;
  let mut x157: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x156, &mut x157, 0x0, x155, x152);
  let mut x158: u32 = 0;
  let mut x159: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x158, &mut x159, x157, x153, x150);
  let mut x160: u32 = 0;
  let mut x161: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x160, &mut x161, 0x0, x132, x154);
  let mut x162: u32 = 0;
  let mut x163: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x162, &mut x163, x161, x134, x156);
  let mut x164: u32 = 0;
  let mut x165: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x164, &mut x165, x163, x136, x158);
  let mut x166: u32 = 0;
  let mut x167: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x166, &mut x167, x165, x138, ((x159 as u32) + x151));
  let mut x168: u32 = 0;
  let mut x169: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x168, &mut x169, x167, x140, (0x0 as u32));
  let mut x170: u32 = 0;
  let mut x171: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x170, &mut x171, x169, x142, (0x0 as u32));
  let mut x172: u32 = 0;
  let mut x173: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x172, &mut x173, x171, x144, x132);
  let mut x174: u32 = 0;
  let mut x175: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x174, &mut x175, x173, x146, x148);
  let mut x176: u32 = 0;
  let mut x177: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x176, &mut x177, x175, ((x147 as u32) + (x131 as u32)), x149);
  let mut x178: u32 = 0;
  let mut x179: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x178, &mut x179, 0x0, x162, (arg1[5]));
  let mut x180: u32 = 0;
  let mut x181: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x180, &mut x181, x179, x164, (0x0 as u32));
  let mut x182: u32 = 0;
  let mut x183: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x182, &mut x183, x181, x166, (0x0 as u32));
  let mut x184: u32 = 0;
  let mut x185: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x184, &mut x185, x183, x168, (0x0 as u32));
  let mut x186: u32 = 0;
  let mut x187: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x186, &mut x187, x185, x170, (0x0 as u32));
  let mut x188: u32 = 0;
  let mut x189: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x188, &mut x189, x187, x172, (0x0 as u32));
  let mut x190: u32 = 0;
  let mut x191: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x190, &mut x191, x189, x174, (0x0 as u32));
  let mut x192: u32 = 0;
  let mut x193: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x192, &mut x193, x191, x176, (0x0 as u32));
  let mut x194: u32 = 0;
  let mut x195: u32 = 0;
  fiat_p256_mulx_u32(&mut x194, &mut x195, x178, 0xffffffff);
  let mut x196: u32 = 0;
  let mut x197: u32 = 0;
  fiat_p256_mulx_u32(&mut x196, &mut x197, x178, 0xffffffff);
  let mut x198: u32 = 0;
  let mut x199: u32 = 0;
  fiat_p256_mulx_u32(&mut x198, &mut x199, x178, 0xffffffff);
  let mut x200: u32 = 0;
  let mut x201: u32 = 0;
  fiat_p256_mulx_u32(&mut x200, &mut x201, x178, 0xffffffff);
  let mut x202: u32 = 0;
  let mut x203: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x202, &mut x203, 0x0, x201, x198);
  let mut x204: u32 = 0;
  let mut x205: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x204, &mut x205, x203, x199, x196);
  let mut x206: u32 = 0;
  let mut x207: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x206, &mut x207, 0x0, x178, x200);
  let mut x208: u32 = 0;
  let mut x209: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x208, &mut x209, x207, x180, x202);
  let mut x210: u32 = 0;
  let mut x211: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x210, &mut x211, x209, x182, x204);
  let mut x212: u32 = 0;
  let mut x213: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x212, &mut x213, x211, x184, ((x205 as u32) + x197));
  let mut x214: u32 = 0;
  let mut x215: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x214, &mut x215, x213, x186, (0x0 as u32));
  let mut x216: u32 = 0;
  let mut x217: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x216, &mut x217, x215, x188, (0x0 as u32));
  let mut x218: u32 = 0;
  let mut x219: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x218, &mut x219, x217, x190, x178);
  let mut x220: u32 = 0;
  let mut x221: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x220, &mut x221, x219, x192, x194);
  let mut x222: u32 = 0;
  let mut x223: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x222, &mut x223, x221, ((x193 as u32) + (x177 as u32)), x195);
  let mut x224: u32 = 0;
  let mut x225: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x224, &mut x225, 0x0, x208, (arg1[6]));
  let mut x226: u32 = 0;
  let mut x227: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x226, &mut x227, x225, x210, (0x0 as u32));
  let mut x228: u32 = 0;
  let mut x229: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x228, &mut x229, x227, x212, (0x0 as u32));
  let mut x230: u32 = 0;
  let mut x231: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x230, &mut x231, x229, x214, (0x0 as u32));
  let mut x232: u32 = 0;
  let mut x233: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x232, &mut x233, x231, x216, (0x0 as u32));
  let mut x234: u32 = 0;
  let mut x235: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x234, &mut x235, x233, x218, (0x0 as u32));
  let mut x236: u32 = 0;
  let mut x237: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x236, &mut x237, x235, x220, (0x0 as u32));
  let mut x238: u32 = 0;
  let mut x239: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x238, &mut x239, x237, x222, (0x0 as u32));
  let mut x240: u32 = 0;
  let mut x241: u32 = 0;
  fiat_p256_mulx_u32(&mut x240, &mut x241, x224, 0xffffffff);
  let mut x242: u32 = 0;
  let mut x243: u32 = 0;
  fiat_p256_mulx_u32(&mut x242, &mut x243, x224, 0xffffffff);
  let mut x244: u32 = 0;
  let mut x245: u32 = 0;
  fiat_p256_mulx_u32(&mut x244, &mut x245, x224, 0xffffffff);
  let mut x246: u32 = 0;
  let mut x247: u32 = 0;
  fiat_p256_mulx_u32(&mut x246, &mut x247, x224, 0xffffffff);
  let mut x248: u32 = 0;
  let mut x249: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x248, &mut x249, 0x0, x247, x244);
  let mut x250: u32 = 0;
  let mut x251: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x250, &mut x251, x249, x245, x242);
  let mut x252: u32 = 0;
  let mut x253: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x252, &mut x253, 0x0, x224, x246);
  let mut x254: u32 = 0;
  let mut x255: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x254, &mut x255, x253, x226, x248);
  let mut x256: u32 = 0;
  let mut x257: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x256, &mut x257, x255, x228, x250);
  let mut x258: u32 = 0;
  let mut x259: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x258, &mut x259, x257, x230, ((x251 as u32) + x243));
  let mut x260: u32 = 0;
  let mut x261: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x260, &mut x261, x259, x232, (0x0 as u32));
  let mut x262: u32 = 0;
  let mut x263: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x262, &mut x263, x261, x234, (0x0 as u32));
  let mut x264: u32 = 0;
  let mut x265: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x264, &mut x265, x263, x236, x224);
  let mut x266: u32 = 0;
  let mut x267: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x266, &mut x267, x265, x238, x240);
  let mut x268: u32 = 0;
  let mut x269: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x268, &mut x269, x267, ((x239 as u32) + (x223 as u32)), x241);
  let mut x270: u32 = 0;
  let mut x271: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x270, &mut x271, 0x0, x254, (arg1[7]));
  let mut x272: u32 = 0;
  let mut x273: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x272, &mut x273, x271, x256, (0x0 as u32));
  let mut x274: u32 = 0;
  let mut x275: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x274, &mut x275, x273, x258, (0x0 as u32));
  let mut x276: u32 = 0;
  let mut x277: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x276, &mut x277, x275, x260, (0x0 as u32));
  let mut x278: u32 = 0;
  let mut x279: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x278, &mut x279, x277, x262, (0x0 as u32));
  let mut x280: u32 = 0;
  let mut x281: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x280, &mut x281, x279, x264, (0x0 as u32));
  let mut x282: u32 = 0;
  let mut x283: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x282, &mut x283, x281, x266, (0x0 as u32));
  let mut x284: u32 = 0;
  let mut x285: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x284, &mut x285, x283, x268, (0x0 as u32));
  let mut x286: u32 = 0;
  let mut x287: u32 = 0;
  fiat_p256_mulx_u32(&mut x286, &mut x287, x270, 0xffffffff);
  let mut x288: u32 = 0;
  let mut x289: u32 = 0;
  fiat_p256_mulx_u32(&mut x288, &mut x289, x270, 0xffffffff);
  let mut x290: u32 = 0;
  let mut x291: u32 = 0;
  fiat_p256_mulx_u32(&mut x290, &mut x291, x270, 0xffffffff);
  let mut x292: u32 = 0;
  let mut x293: u32 = 0;
  fiat_p256_mulx_u32(&mut x292, &mut x293, x270, 0xffffffff);
  let mut x294: u32 = 0;
  let mut x295: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x294, &mut x295, 0x0, x293, x290);
  let mut x296: u32 = 0;
  let mut x297: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x296, &mut x297, x295, x291, x288);
  let mut x298: u32 = 0;
  let mut x299: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x298, &mut x299, 0x0, x270, x292);
  let mut x300: u32 = 0;
  let mut x301: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x300, &mut x301, x299, x272, x294);
  let mut x302: u32 = 0;
  let mut x303: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x302, &mut x303, x301, x274, x296);
  let mut x304: u32 = 0;
  let mut x305: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x304, &mut x305, x303, x276, ((x297 as u32) + x289));
  let mut x306: u32 = 0;
  let mut x307: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x306, &mut x307, x305, x278, (0x0 as u32));
  let mut x308: u32 = 0;
  let mut x309: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x308, &mut x309, x307, x280, (0x0 as u32));
  let mut x310: u32 = 0;
  let mut x311: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x310, &mut x311, x309, x282, x270);
  let mut x312: u32 = 0;
  let mut x313: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x312, &mut x313, x311, x284, x286);
  let mut x314: u32 = 0;
  let mut x315: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x314, &mut x315, x313, ((x285 as u32) + (x269 as u32)), x287);
  let mut x316: u32 = 0;
  let mut x317: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x316, &mut x317, 0x0, x300, 0xffffffff);
  let mut x318: u32 = 0;
  let mut x319: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x318, &mut x319, x317, x302, 0xffffffff);
  let mut x320: u32 = 0;
  let mut x321: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x320, &mut x321, x319, x304, 0xffffffff);
  let mut x322: u32 = 0;
  let mut x323: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x322, &mut x323, x321, x306, (0x0 as u32));
  let mut x324: u32 = 0;
  let mut x325: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x324, &mut x325, x323, x308, (0x0 as u32));
  let mut x326: u32 = 0;
  let mut x327: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x326, &mut x327, x325, x310, (0x0 as u32));
  let mut x328: u32 = 0;
  let mut x329: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x328, &mut x329, x327, x312, (0x1 as u32));
  let mut x330: u32 = 0;
  let mut x331: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x330, &mut x331, x329, x314, 0xffffffff);
  let mut x332: u32 = 0;
  let mut x333: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x332, &mut x333, x331, (x315 as u32), (0x0 as u32));
  let mut x334: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x334, x333, x316, x300);
  let mut x335: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x335, x333, x318, x302);
  let mut x336: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x336, x333, x320, x304);
  let mut x337: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x337, x333, x322, x306);
  let mut x338: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x338, x333, x324, x308);
  let mut x339: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x339, x333, x326, x310);
  let mut x340: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x340, x333, x328, x312);
  let mut x341: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x341, x333, x330, x314);
  out1[0] = x334;
  out1[1] = x335;
  out1[2] = x336;
  out1[3] = x337;
  out1[4] = x338;
  out1[5] = x339;
  out1[6] = x340;
  out1[7] = x341;
}

/// The function fiat_p256_to_montgomery translates a field element into the Montgomery domain.
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = eval arg1 mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p256_to_montgomery(out1: &mut [u32; 8], arg1: &[u32; 8]) -> () {
  let x1: u32 = (arg1[1]);
  let x2: u32 = (arg1[2]);
  let x3: u32 = (arg1[3]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[5]);
  let x6: u32 = (arg1[6]);
  let x7: u32 = (arg1[7]);
  let x8: u32 = (arg1[0]);
  let mut x9: u32 = 0;
  let mut x10: u32 = 0;
  fiat_p256_mulx_u32(&mut x9, &mut x10, x8, 0x4);
  let mut x11: u32 = 0;
  let mut x12: u32 = 0;
  fiat_p256_mulx_u32(&mut x11, &mut x12, x8, 0xfffffffd);
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_p256_mulx_u32(&mut x13, &mut x14, x8, 0xffffffff);
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_p256_mulx_u32(&mut x15, &mut x16, x8, 0xfffffffe);
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_p256_mulx_u32(&mut x17, &mut x18, x8, 0xfffffffb);
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_p256_mulx_u32(&mut x19, &mut x20, x8, 0xffffffff);
  let mut x21: u32 = 0;
  let mut x22: u32 = 0;
  fiat_p256_mulx_u32(&mut x21, &mut x22, x8, 0x3);
  let mut x23: u32 = 0;
  let mut x24: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x23, &mut x24, 0x0, x20, x17);
  let mut x25: u32 = 0;
  let mut x26: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x25, &mut x26, x24, x18, x15);
  let mut x27: u32 = 0;
  let mut x28: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x27, &mut x28, x26, x16, x13);
  let mut x29: u32 = 0;
  let mut x30: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x29, &mut x30, x28, x14, x11);
  let mut x31: u32 = 0;
  let mut x32: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x31, &mut x32, x30, x12, x9);
  let mut x33: u32 = 0;
  let mut x34: u32 = 0;
  fiat_p256_mulx_u32(&mut x33, &mut x34, x21, 0xffffffff);
  let mut x35: u32 = 0;
  let mut x36: u32 = 0;
  fiat_p256_mulx_u32(&mut x35, &mut x36, x21, 0xffffffff);
  let mut x37: u32 = 0;
  let mut x38: u32 = 0;
  fiat_p256_mulx_u32(&mut x37, &mut x38, x21, 0xffffffff);
  let mut x39: u32 = 0;
  let mut x40: u32 = 0;
  fiat_p256_mulx_u32(&mut x39, &mut x40, x21, 0xffffffff);
  let mut x41: u32 = 0;
  let mut x42: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x41, &mut x42, 0x0, x40, x37);
  let mut x43: u32 = 0;
  let mut x44: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x43, &mut x44, x42, x38, x35);
  let mut x45: u32 = 0;
  let mut x46: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x45, &mut x46, 0x0, x21, x39);
  let mut x47: u32 = 0;
  let mut x48: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x47, &mut x48, x46, x22, x41);
  let mut x49: u32 = 0;
  let mut x50: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x49, &mut x50, x48, x19, x43);
  let mut x51: u32 = 0;
  let mut x52: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x51, &mut x52, x50, x23, ((x44 as u32) + x36));
  let mut x53: u32 = 0;
  let mut x54: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x53, &mut x54, x52, x25, (0x0 as u32));
  let mut x55: u32 = 0;
  let mut x56: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x55, &mut x56, x54, x27, (0x0 as u32));
  let mut x57: u32 = 0;
  let mut x58: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x57, &mut x58, x56, x29, x21);
  let mut x59: u32 = 0;
  let mut x60: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x59, &mut x60, x58, x31, x33);
  let mut x61: u32 = 0;
  let mut x62: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x61, &mut x62, x60, ((x32 as u32) + x10), x34);
  let mut x63: u32 = 0;
  let mut x64: u32 = 0;
  fiat_p256_mulx_u32(&mut x63, &mut x64, x1, 0x4);
  let mut x65: u32 = 0;
  let mut x66: u32 = 0;
  fiat_p256_mulx_u32(&mut x65, &mut x66, x1, 0xfffffffd);
  let mut x67: u32 = 0;
  let mut x68: u32 = 0;
  fiat_p256_mulx_u32(&mut x67, &mut x68, x1, 0xffffffff);
  let mut x69: u32 = 0;
  let mut x70: u32 = 0;
  fiat_p256_mulx_u32(&mut x69, &mut x70, x1, 0xfffffffe);
  let mut x71: u32 = 0;
  let mut x72: u32 = 0;
  fiat_p256_mulx_u32(&mut x71, &mut x72, x1, 0xfffffffb);
  let mut x73: u32 = 0;
  let mut x74: u32 = 0;
  fiat_p256_mulx_u32(&mut x73, &mut x74, x1, 0xffffffff);
  let mut x75: u32 = 0;
  let mut x76: u32 = 0;
  fiat_p256_mulx_u32(&mut x75, &mut x76, x1, 0x3);
  let mut x77: u32 = 0;
  let mut x78: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x77, &mut x78, 0x0, x74, x71);
  let mut x79: u32 = 0;
  let mut x80: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x79, &mut x80, x78, x72, x69);
  let mut x81: u32 = 0;
  let mut x82: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x81, &mut x82, x80, x70, x67);
  let mut x83: u32 = 0;
  let mut x84: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x83, &mut x84, x82, x68, x65);
  let mut x85: u32 = 0;
  let mut x86: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x85, &mut x86, x84, x66, x63);
  let mut x87: u32 = 0;
  let mut x88: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x87, &mut x88, 0x0, x47, x75);
  let mut x89: u32 = 0;
  let mut x90: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x89, &mut x90, x88, x49, x76);
  let mut x91: u32 = 0;
  let mut x92: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x91, &mut x92, x90, x51, x73);
  let mut x93: u32 = 0;
  let mut x94: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x93, &mut x94, x92, x53, x77);
  let mut x95: u32 = 0;
  let mut x96: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x95, &mut x96, x94, x55, x79);
  let mut x97: u32 = 0;
  let mut x98: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x97, &mut x98, x96, x57, x81);
  let mut x99: u32 = 0;
  let mut x100: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x99, &mut x100, x98, x59, x83);
  let mut x101: u32 = 0;
  let mut x102: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x101, &mut x102, x100, x61, x85);
  let mut x103: u32 = 0;
  let mut x104: u32 = 0;
  fiat_p256_mulx_u32(&mut x103, &mut x104, x87, 0xffffffff);
  let mut x105: u32 = 0;
  let mut x106: u32 = 0;
  fiat_p256_mulx_u32(&mut x105, &mut x106, x87, 0xffffffff);
  let mut x107: u32 = 0;
  let mut x108: u32 = 0;
  fiat_p256_mulx_u32(&mut x107, &mut x108, x87, 0xffffffff);
  let mut x109: u32 = 0;
  let mut x110: u32 = 0;
  fiat_p256_mulx_u32(&mut x109, &mut x110, x87, 0xffffffff);
  let mut x111: u32 = 0;
  let mut x112: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x111, &mut x112, 0x0, x110, x107);
  let mut x113: u32 = 0;
  let mut x114: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x113, &mut x114, x112, x108, x105);
  let mut x115: u32 = 0;
  let mut x116: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x115, &mut x116, 0x0, x87, x109);
  let mut x117: u32 = 0;
  let mut x118: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x117, &mut x118, x116, x89, x111);
  let mut x119: u32 = 0;
  let mut x120: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x119, &mut x120, x118, x91, x113);
  let mut x121: u32 = 0;
  let mut x122: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x121, &mut x122, x120, x93, ((x114 as u32) + x106));
  let mut x123: u32 = 0;
  let mut x124: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x123, &mut x124, x122, x95, (0x0 as u32));
  let mut x125: u32 = 0;
  let mut x126: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x125, &mut x126, x124, x97, (0x0 as u32));
  let mut x127: u32 = 0;
  let mut x128: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x127, &mut x128, x126, x99, x87);
  let mut x129: u32 = 0;
  let mut x130: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x129, &mut x130, x128, x101, x103);
  let mut x131: u32 = 0;
  let mut x132: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x131, &mut x132, x130, (((x102 as u32) + (x62 as u32)) + ((x86 as u32) + x64)), x104);
  let mut x133: u32 = 0;
  let mut x134: u32 = 0;
  fiat_p256_mulx_u32(&mut x133, &mut x134, x2, 0x4);
  let mut x135: u32 = 0;
  let mut x136: u32 = 0;
  fiat_p256_mulx_u32(&mut x135, &mut x136, x2, 0xfffffffd);
  let mut x137: u32 = 0;
  let mut x138: u32 = 0;
  fiat_p256_mulx_u32(&mut x137, &mut x138, x2, 0xffffffff);
  let mut x139: u32 = 0;
  let mut x140: u32 = 0;
  fiat_p256_mulx_u32(&mut x139, &mut x140, x2, 0xfffffffe);
  let mut x141: u32 = 0;
  let mut x142: u32 = 0;
  fiat_p256_mulx_u32(&mut x141, &mut x142, x2, 0xfffffffb);
  let mut x143: u32 = 0;
  let mut x144: u32 = 0;
  fiat_p256_mulx_u32(&mut x143, &mut x144, x2, 0xffffffff);
  let mut x145: u32 = 0;
  let mut x146: u32 = 0;
  fiat_p256_mulx_u32(&mut x145, &mut x146, x2, 0x3);
  let mut x147: u32 = 0;
  let mut x148: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x147, &mut x148, 0x0, x144, x141);
  let mut x149: u32 = 0;
  let mut x150: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x149, &mut x150, x148, x142, x139);
  let mut x151: u32 = 0;
  let mut x152: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x151, &mut x152, x150, x140, x137);
  let mut x153: u32 = 0;
  let mut x154: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x153, &mut x154, x152, x138, x135);
  let mut x155: u32 = 0;
  let mut x156: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x155, &mut x156, x154, x136, x133);
  let mut x157: u32 = 0;
  let mut x158: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x157, &mut x158, 0x0, x117, x145);
  let mut x159: u32 = 0;
  let mut x160: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x159, &mut x160, x158, x119, x146);
  let mut x161: u32 = 0;
  let mut x162: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x161, &mut x162, x160, x121, x143);
  let mut x163: u32 = 0;
  let mut x164: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x163, &mut x164, x162, x123, x147);
  let mut x165: u32 = 0;
  let mut x166: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x165, &mut x166, x164, x125, x149);
  let mut x167: u32 = 0;
  let mut x168: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x167, &mut x168, x166, x127, x151);
  let mut x169: u32 = 0;
  let mut x170: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x169, &mut x170, x168, x129, x153);
  let mut x171: u32 = 0;
  let mut x172: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x171, &mut x172, x170, x131, x155);
  let mut x173: u32 = 0;
  let mut x174: u32 = 0;
  fiat_p256_mulx_u32(&mut x173, &mut x174, x157, 0xffffffff);
  let mut x175: u32 = 0;
  let mut x176: u32 = 0;
  fiat_p256_mulx_u32(&mut x175, &mut x176, x157, 0xffffffff);
  let mut x177: u32 = 0;
  let mut x178: u32 = 0;
  fiat_p256_mulx_u32(&mut x177, &mut x178, x157, 0xffffffff);
  let mut x179: u32 = 0;
  let mut x180: u32 = 0;
  fiat_p256_mulx_u32(&mut x179, &mut x180, x157, 0xffffffff);
  let mut x181: u32 = 0;
  let mut x182: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x181, &mut x182, 0x0, x180, x177);
  let mut x183: u32 = 0;
  let mut x184: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x183, &mut x184, x182, x178, x175);
  let mut x185: u32 = 0;
  let mut x186: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x185, &mut x186, 0x0, x157, x179);
  let mut x187: u32 = 0;
  let mut x188: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x187, &mut x188, x186, x159, x181);
  let mut x189: u32 = 0;
  let mut x190: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x189, &mut x190, x188, x161, x183);
  let mut x191: u32 = 0;
  let mut x192: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x191, &mut x192, x190, x163, ((x184 as u32) + x176));
  let mut x193: u32 = 0;
  let mut x194: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x193, &mut x194, x192, x165, (0x0 as u32));
  let mut x195: u32 = 0;
  let mut x196: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x195, &mut x196, x194, x167, (0x0 as u32));
  let mut x197: u32 = 0;
  let mut x198: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x197, &mut x198, x196, x169, x157);
  let mut x199: u32 = 0;
  let mut x200: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x199, &mut x200, x198, x171, x173);
  let mut x201: u32 = 0;
  let mut x202: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x201, &mut x202, x200, (((x172 as u32) + (x132 as u32)) + ((x156 as u32) + x134)), x174);
  let mut x203: u32 = 0;
  let mut x204: u32 = 0;
  fiat_p256_mulx_u32(&mut x203, &mut x204, x3, 0x4);
  let mut x205: u32 = 0;
  let mut x206: u32 = 0;
  fiat_p256_mulx_u32(&mut x205, &mut x206, x3, 0xfffffffd);
  let mut x207: u32 = 0;
  let mut x208: u32 = 0;
  fiat_p256_mulx_u32(&mut x207, &mut x208, x3, 0xffffffff);
  let mut x209: u32 = 0;
  let mut x210: u32 = 0;
  fiat_p256_mulx_u32(&mut x209, &mut x210, x3, 0xfffffffe);
  let mut x211: u32 = 0;
  let mut x212: u32 = 0;
  fiat_p256_mulx_u32(&mut x211, &mut x212, x3, 0xfffffffb);
  let mut x213: u32 = 0;
  let mut x214: u32 = 0;
  fiat_p256_mulx_u32(&mut x213, &mut x214, x3, 0xffffffff);
  let mut x215: u32 = 0;
  let mut x216: u32 = 0;
  fiat_p256_mulx_u32(&mut x215, &mut x216, x3, 0x3);
  let mut x217: u32 = 0;
  let mut x218: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x217, &mut x218, 0x0, x214, x211);
  let mut x219: u32 = 0;
  let mut x220: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x219, &mut x220, x218, x212, x209);
  let mut x221: u32 = 0;
  let mut x222: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x221, &mut x222, x220, x210, x207);
  let mut x223: u32 = 0;
  let mut x224: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x223, &mut x224, x222, x208, x205);
  let mut x225: u32 = 0;
  let mut x226: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x225, &mut x226, x224, x206, x203);
  let mut x227: u32 = 0;
  let mut x228: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x227, &mut x228, 0x0, x187, x215);
  let mut x229: u32 = 0;
  let mut x230: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x229, &mut x230, x228, x189, x216);
  let mut x231: u32 = 0;
  let mut x232: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x231, &mut x232, x230, x191, x213);
  let mut x233: u32 = 0;
  let mut x234: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x233, &mut x234, x232, x193, x217);
  let mut x235: u32 = 0;
  let mut x236: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x235, &mut x236, x234, x195, x219);
  let mut x237: u32 = 0;
  let mut x238: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x237, &mut x238, x236, x197, x221);
  let mut x239: u32 = 0;
  let mut x240: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x239, &mut x240, x238, x199, x223);
  let mut x241: u32 = 0;
  let mut x242: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x241, &mut x242, x240, x201, x225);
  let mut x243: u32 = 0;
  let mut x244: u32 = 0;
  fiat_p256_mulx_u32(&mut x243, &mut x244, x227, 0xffffffff);
  let mut x245: u32 = 0;
  let mut x246: u32 = 0;
  fiat_p256_mulx_u32(&mut x245, &mut x246, x227, 0xffffffff);
  let mut x247: u32 = 0;
  let mut x248: u32 = 0;
  fiat_p256_mulx_u32(&mut x247, &mut x248, x227, 0xffffffff);
  let mut x249: u32 = 0;
  let mut x250: u32 = 0;
  fiat_p256_mulx_u32(&mut x249, &mut x250, x227, 0xffffffff);
  let mut x251: u32 = 0;
  let mut x252: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x251, &mut x252, 0x0, x250, x247);
  let mut x253: u32 = 0;
  let mut x254: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x253, &mut x254, x252, x248, x245);
  let mut x255: u32 = 0;
  let mut x256: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x255, &mut x256, 0x0, x227, x249);
  let mut x257: u32 = 0;
  let mut x258: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x257, &mut x258, x256, x229, x251);
  let mut x259: u32 = 0;
  let mut x260: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x259, &mut x260, x258, x231, x253);
  let mut x261: u32 = 0;
  let mut x262: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x261, &mut x262, x260, x233, ((x254 as u32) + x246));
  let mut x263: u32 = 0;
  let mut x264: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x263, &mut x264, x262, x235, (0x0 as u32));
  let mut x265: u32 = 0;
  let mut x266: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x265, &mut x266, x264, x237, (0x0 as u32));
  let mut x267: u32 = 0;
  let mut x268: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x267, &mut x268, x266, x239, x227);
  let mut x269: u32 = 0;
  let mut x270: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x269, &mut x270, x268, x241, x243);
  let mut x271: u32 = 0;
  let mut x272: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x271, &mut x272, x270, (((x242 as u32) + (x202 as u32)) + ((x226 as u32) + x204)), x244);
  let mut x273: u32 = 0;
  let mut x274: u32 = 0;
  fiat_p256_mulx_u32(&mut x273, &mut x274, x4, 0x4);
  let mut x275: u32 = 0;
  let mut x276: u32 = 0;
  fiat_p256_mulx_u32(&mut x275, &mut x276, x4, 0xfffffffd);
  let mut x277: u32 = 0;
  let mut x278: u32 = 0;
  fiat_p256_mulx_u32(&mut x277, &mut x278, x4, 0xffffffff);
  let mut x279: u32 = 0;
  let mut x280: u32 = 0;
  fiat_p256_mulx_u32(&mut x279, &mut x280, x4, 0xfffffffe);
  let mut x281: u32 = 0;
  let mut x282: u32 = 0;
  fiat_p256_mulx_u32(&mut x281, &mut x282, x4, 0xfffffffb);
  let mut x283: u32 = 0;
  let mut x284: u32 = 0;
  fiat_p256_mulx_u32(&mut x283, &mut x284, x4, 0xffffffff);
  let mut x285: u32 = 0;
  let mut x286: u32 = 0;
  fiat_p256_mulx_u32(&mut x285, &mut x286, x4, 0x3);
  let mut x287: u32 = 0;
  let mut x288: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x287, &mut x288, 0x0, x284, x281);
  let mut x289: u32 = 0;
  let mut x290: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x289, &mut x290, x288, x282, x279);
  let mut x291: u32 = 0;
  let mut x292: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x291, &mut x292, x290, x280, x277);
  let mut x293: u32 = 0;
  let mut x294: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x293, &mut x294, x292, x278, x275);
  let mut x295: u32 = 0;
  let mut x296: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x295, &mut x296, x294, x276, x273);
  let mut x297: u32 = 0;
  let mut x298: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x297, &mut x298, 0x0, x257, x285);
  let mut x299: u32 = 0;
  let mut x300: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x299, &mut x300, x298, x259, x286);
  let mut x301: u32 = 0;
  let mut x302: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x301, &mut x302, x300, x261, x283);
  let mut x303: u32 = 0;
  let mut x304: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x303, &mut x304, x302, x263, x287);
  let mut x305: u32 = 0;
  let mut x306: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x305, &mut x306, x304, x265, x289);
  let mut x307: u32 = 0;
  let mut x308: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x307, &mut x308, x306, x267, x291);
  let mut x309: u32 = 0;
  let mut x310: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x309, &mut x310, x308, x269, x293);
  let mut x311: u32 = 0;
  let mut x312: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x311, &mut x312, x310, x271, x295);
  let mut x313: u32 = 0;
  let mut x314: u32 = 0;
  fiat_p256_mulx_u32(&mut x313, &mut x314, x297, 0xffffffff);
  let mut x315: u32 = 0;
  let mut x316: u32 = 0;
  fiat_p256_mulx_u32(&mut x315, &mut x316, x297, 0xffffffff);
  let mut x317: u32 = 0;
  let mut x318: u32 = 0;
  fiat_p256_mulx_u32(&mut x317, &mut x318, x297, 0xffffffff);
  let mut x319: u32 = 0;
  let mut x320: u32 = 0;
  fiat_p256_mulx_u32(&mut x319, &mut x320, x297, 0xffffffff);
  let mut x321: u32 = 0;
  let mut x322: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x321, &mut x322, 0x0, x320, x317);
  let mut x323: u32 = 0;
  let mut x324: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x323, &mut x324, x322, x318, x315);
  let mut x325: u32 = 0;
  let mut x326: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x325, &mut x326, 0x0, x297, x319);
  let mut x327: u32 = 0;
  let mut x328: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x327, &mut x328, x326, x299, x321);
  let mut x329: u32 = 0;
  let mut x330: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x329, &mut x330, x328, x301, x323);
  let mut x331: u32 = 0;
  let mut x332: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x331, &mut x332, x330, x303, ((x324 as u32) + x316));
  let mut x333: u32 = 0;
  let mut x334: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x333, &mut x334, x332, x305, (0x0 as u32));
  let mut x335: u32 = 0;
  let mut x336: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x335, &mut x336, x334, x307, (0x0 as u32));
  let mut x337: u32 = 0;
  let mut x338: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x337, &mut x338, x336, x309, x297);
  let mut x339: u32 = 0;
  let mut x340: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x339, &mut x340, x338, x311, x313);
  let mut x341: u32 = 0;
  let mut x342: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x341, &mut x342, x340, (((x312 as u32) + (x272 as u32)) + ((x296 as u32) + x274)), x314);
  let mut x343: u32 = 0;
  let mut x344: u32 = 0;
  fiat_p256_mulx_u32(&mut x343, &mut x344, x5, 0x4);
  let mut x345: u32 = 0;
  let mut x346: u32 = 0;
  fiat_p256_mulx_u32(&mut x345, &mut x346, x5, 0xfffffffd);
  let mut x347: u32 = 0;
  let mut x348: u32 = 0;
  fiat_p256_mulx_u32(&mut x347, &mut x348, x5, 0xffffffff);
  let mut x349: u32 = 0;
  let mut x350: u32 = 0;
  fiat_p256_mulx_u32(&mut x349, &mut x350, x5, 0xfffffffe);
  let mut x351: u32 = 0;
  let mut x352: u32 = 0;
  fiat_p256_mulx_u32(&mut x351, &mut x352, x5, 0xfffffffb);
  let mut x353: u32 = 0;
  let mut x354: u32 = 0;
  fiat_p256_mulx_u32(&mut x353, &mut x354, x5, 0xffffffff);
  let mut x355: u32 = 0;
  let mut x356: u32 = 0;
  fiat_p256_mulx_u32(&mut x355, &mut x356, x5, 0x3);
  let mut x357: u32 = 0;
  let mut x358: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x357, &mut x358, 0x0, x354, x351);
  let mut x359: u32 = 0;
  let mut x360: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x359, &mut x360, x358, x352, x349);
  let mut x361: u32 = 0;
  let mut x362: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x361, &mut x362, x360, x350, x347);
  let mut x363: u32 = 0;
  let mut x364: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x363, &mut x364, x362, x348, x345);
  let mut x365: u32 = 0;
  let mut x366: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x365, &mut x366, x364, x346, x343);
  let mut x367: u32 = 0;
  let mut x368: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x367, &mut x368, 0x0, x327, x355);
  let mut x369: u32 = 0;
  let mut x370: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x369, &mut x370, x368, x329, x356);
  let mut x371: u32 = 0;
  let mut x372: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x371, &mut x372, x370, x331, x353);
  let mut x373: u32 = 0;
  let mut x374: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x373, &mut x374, x372, x333, x357);
  let mut x375: u32 = 0;
  let mut x376: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x375, &mut x376, x374, x335, x359);
  let mut x377: u32 = 0;
  let mut x378: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x377, &mut x378, x376, x337, x361);
  let mut x379: u32 = 0;
  let mut x380: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x379, &mut x380, x378, x339, x363);
  let mut x381: u32 = 0;
  let mut x382: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x381, &mut x382, x380, x341, x365);
  let mut x383: u32 = 0;
  let mut x384: u32 = 0;
  fiat_p256_mulx_u32(&mut x383, &mut x384, x367, 0xffffffff);
  let mut x385: u32 = 0;
  let mut x386: u32 = 0;
  fiat_p256_mulx_u32(&mut x385, &mut x386, x367, 0xffffffff);
  let mut x387: u32 = 0;
  let mut x388: u32 = 0;
  fiat_p256_mulx_u32(&mut x387, &mut x388, x367, 0xffffffff);
  let mut x389: u32 = 0;
  let mut x390: u32 = 0;
  fiat_p256_mulx_u32(&mut x389, &mut x390, x367, 0xffffffff);
  let mut x391: u32 = 0;
  let mut x392: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x391, &mut x392, 0x0, x390, x387);
  let mut x393: u32 = 0;
  let mut x394: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x393, &mut x394, x392, x388, x385);
  let mut x395: u32 = 0;
  let mut x396: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x395, &mut x396, 0x0, x367, x389);
  let mut x397: u32 = 0;
  let mut x398: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x397, &mut x398, x396, x369, x391);
  let mut x399: u32 = 0;
  let mut x400: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x399, &mut x400, x398, x371, x393);
  let mut x401: u32 = 0;
  let mut x402: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x401, &mut x402, x400, x373, ((x394 as u32) + x386));
  let mut x403: u32 = 0;
  let mut x404: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x403, &mut x404, x402, x375, (0x0 as u32));
  let mut x405: u32 = 0;
  let mut x406: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x405, &mut x406, x404, x377, (0x0 as u32));
  let mut x407: u32 = 0;
  let mut x408: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x407, &mut x408, x406, x379, x367);
  let mut x409: u32 = 0;
  let mut x410: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x409, &mut x410, x408, x381, x383);
  let mut x411: u32 = 0;
  let mut x412: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x411, &mut x412, x410, (((x382 as u32) + (x342 as u32)) + ((x366 as u32) + x344)), x384);
  let mut x413: u32 = 0;
  let mut x414: u32 = 0;
  fiat_p256_mulx_u32(&mut x413, &mut x414, x6, 0x4);
  let mut x415: u32 = 0;
  let mut x416: u32 = 0;
  fiat_p256_mulx_u32(&mut x415, &mut x416, x6, 0xfffffffd);
  let mut x417: u32 = 0;
  let mut x418: u32 = 0;
  fiat_p256_mulx_u32(&mut x417, &mut x418, x6, 0xffffffff);
  let mut x419: u32 = 0;
  let mut x420: u32 = 0;
  fiat_p256_mulx_u32(&mut x419, &mut x420, x6, 0xfffffffe);
  let mut x421: u32 = 0;
  let mut x422: u32 = 0;
  fiat_p256_mulx_u32(&mut x421, &mut x422, x6, 0xfffffffb);
  let mut x423: u32 = 0;
  let mut x424: u32 = 0;
  fiat_p256_mulx_u32(&mut x423, &mut x424, x6, 0xffffffff);
  let mut x425: u32 = 0;
  let mut x426: u32 = 0;
  fiat_p256_mulx_u32(&mut x425, &mut x426, x6, 0x3);
  let mut x427: u32 = 0;
  let mut x428: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x427, &mut x428, 0x0, x424, x421);
  let mut x429: u32 = 0;
  let mut x430: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x429, &mut x430, x428, x422, x419);
  let mut x431: u32 = 0;
  let mut x432: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x431, &mut x432, x430, x420, x417);
  let mut x433: u32 = 0;
  let mut x434: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x433, &mut x434, x432, x418, x415);
  let mut x435: u32 = 0;
  let mut x436: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x435, &mut x436, x434, x416, x413);
  let mut x437: u32 = 0;
  let mut x438: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x437, &mut x438, 0x0, x397, x425);
  let mut x439: u32 = 0;
  let mut x440: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x439, &mut x440, x438, x399, x426);
  let mut x441: u32 = 0;
  let mut x442: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x441, &mut x442, x440, x401, x423);
  let mut x443: u32 = 0;
  let mut x444: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x443, &mut x444, x442, x403, x427);
  let mut x445: u32 = 0;
  let mut x446: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x445, &mut x446, x444, x405, x429);
  let mut x447: u32 = 0;
  let mut x448: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x447, &mut x448, x446, x407, x431);
  let mut x449: u32 = 0;
  let mut x450: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x449, &mut x450, x448, x409, x433);
  let mut x451: u32 = 0;
  let mut x452: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x451, &mut x452, x450, x411, x435);
  let mut x453: u32 = 0;
  let mut x454: u32 = 0;
  fiat_p256_mulx_u32(&mut x453, &mut x454, x437, 0xffffffff);
  let mut x455: u32 = 0;
  let mut x456: u32 = 0;
  fiat_p256_mulx_u32(&mut x455, &mut x456, x437, 0xffffffff);
  let mut x457: u32 = 0;
  let mut x458: u32 = 0;
  fiat_p256_mulx_u32(&mut x457, &mut x458, x437, 0xffffffff);
  let mut x459: u32 = 0;
  let mut x460: u32 = 0;
  fiat_p256_mulx_u32(&mut x459, &mut x460, x437, 0xffffffff);
  let mut x461: u32 = 0;
  let mut x462: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x461, &mut x462, 0x0, x460, x457);
  let mut x463: u32 = 0;
  let mut x464: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x463, &mut x464, x462, x458, x455);
  let mut x465: u32 = 0;
  let mut x466: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x465, &mut x466, 0x0, x437, x459);
  let mut x467: u32 = 0;
  let mut x468: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x467, &mut x468, x466, x439, x461);
  let mut x469: u32 = 0;
  let mut x470: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x469, &mut x470, x468, x441, x463);
  let mut x471: u32 = 0;
  let mut x472: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x471, &mut x472, x470, x443, ((x464 as u32) + x456));
  let mut x473: u32 = 0;
  let mut x474: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x473, &mut x474, x472, x445, (0x0 as u32));
  let mut x475: u32 = 0;
  let mut x476: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x475, &mut x476, x474, x447, (0x0 as u32));
  let mut x477: u32 = 0;
  let mut x478: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x477, &mut x478, x476, x449, x437);
  let mut x479: u32 = 0;
  let mut x480: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x479, &mut x480, x478, x451, x453);
  let mut x481: u32 = 0;
  let mut x482: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x481, &mut x482, x480, (((x452 as u32) + (x412 as u32)) + ((x436 as u32) + x414)), x454);
  let mut x483: u32 = 0;
  let mut x484: u32 = 0;
  fiat_p256_mulx_u32(&mut x483, &mut x484, x7, 0x4);
  let mut x485: u32 = 0;
  let mut x486: u32 = 0;
  fiat_p256_mulx_u32(&mut x485, &mut x486, x7, 0xfffffffd);
  let mut x487: u32 = 0;
  let mut x488: u32 = 0;
  fiat_p256_mulx_u32(&mut x487, &mut x488, x7, 0xffffffff);
  let mut x489: u32 = 0;
  let mut x490: u32 = 0;
  fiat_p256_mulx_u32(&mut x489, &mut x490, x7, 0xfffffffe);
  let mut x491: u32 = 0;
  let mut x492: u32 = 0;
  fiat_p256_mulx_u32(&mut x491, &mut x492, x7, 0xfffffffb);
  let mut x493: u32 = 0;
  let mut x494: u32 = 0;
  fiat_p256_mulx_u32(&mut x493, &mut x494, x7, 0xffffffff);
  let mut x495: u32 = 0;
  let mut x496: u32 = 0;
  fiat_p256_mulx_u32(&mut x495, &mut x496, x7, 0x3);
  let mut x497: u32 = 0;
  let mut x498: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x497, &mut x498, 0x0, x494, x491);
  let mut x499: u32 = 0;
  let mut x500: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x499, &mut x500, x498, x492, x489);
  let mut x501: u32 = 0;
  let mut x502: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x501, &mut x502, x500, x490, x487);
  let mut x503: u32 = 0;
  let mut x504: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x503, &mut x504, x502, x488, x485);
  let mut x505: u32 = 0;
  let mut x506: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x505, &mut x506, x504, x486, x483);
  let mut x507: u32 = 0;
  let mut x508: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x507, &mut x508, 0x0, x467, x495);
  let mut x509: u32 = 0;
  let mut x510: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x509, &mut x510, x508, x469, x496);
  let mut x511: u32 = 0;
  let mut x512: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x511, &mut x512, x510, x471, x493);
  let mut x513: u32 = 0;
  let mut x514: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x513, &mut x514, x512, x473, x497);
  let mut x515: u32 = 0;
  let mut x516: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x515, &mut x516, x514, x475, x499);
  let mut x517: u32 = 0;
  let mut x518: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x517, &mut x518, x516, x477, x501);
  let mut x519: u32 = 0;
  let mut x520: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x519, &mut x520, x518, x479, x503);
  let mut x521: u32 = 0;
  let mut x522: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x521, &mut x522, x520, x481, x505);
  let mut x523: u32 = 0;
  let mut x524: u32 = 0;
  fiat_p256_mulx_u32(&mut x523, &mut x524, x507, 0xffffffff);
  let mut x525: u32 = 0;
  let mut x526: u32 = 0;
  fiat_p256_mulx_u32(&mut x525, &mut x526, x507, 0xffffffff);
  let mut x527: u32 = 0;
  let mut x528: u32 = 0;
  fiat_p256_mulx_u32(&mut x527, &mut x528, x507, 0xffffffff);
  let mut x529: u32 = 0;
  let mut x530: u32 = 0;
  fiat_p256_mulx_u32(&mut x529, &mut x530, x507, 0xffffffff);
  let mut x531: u32 = 0;
  let mut x532: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x531, &mut x532, 0x0, x530, x527);
  let mut x533: u32 = 0;
  let mut x534: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x533, &mut x534, x532, x528, x525);
  let mut x535: u32 = 0;
  let mut x536: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x535, &mut x536, 0x0, x507, x529);
  let mut x537: u32 = 0;
  let mut x538: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x537, &mut x538, x536, x509, x531);
  let mut x539: u32 = 0;
  let mut x540: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x539, &mut x540, x538, x511, x533);
  let mut x541: u32 = 0;
  let mut x542: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x541, &mut x542, x540, x513, ((x534 as u32) + x526));
  let mut x543: u32 = 0;
  let mut x544: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x543, &mut x544, x542, x515, (0x0 as u32));
  let mut x545: u32 = 0;
  let mut x546: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x545, &mut x546, x544, x517, (0x0 as u32));
  let mut x547: u32 = 0;
  let mut x548: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x547, &mut x548, x546, x519, x507);
  let mut x549: u32 = 0;
  let mut x550: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x549, &mut x550, x548, x521, x523);
  let mut x551: u32 = 0;
  let mut x552: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x551, &mut x552, x550, (((x522 as u32) + (x482 as u32)) + ((x506 as u32) + x484)), x524);
  let mut x553: u32 = 0;
  let mut x554: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x553, &mut x554, 0x0, x537, 0xffffffff);
  let mut x555: u32 = 0;
  let mut x556: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x555, &mut x556, x554, x539, 0xffffffff);
  let mut x557: u32 = 0;
  let mut x558: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x557, &mut x558, x556, x541, 0xffffffff);
  let mut x559: u32 = 0;
  let mut x560: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x559, &mut x560, x558, x543, (0x0 as u32));
  let mut x561: u32 = 0;
  let mut x562: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x561, &mut x562, x560, x545, (0x0 as u32));
  let mut x563: u32 = 0;
  let mut x564: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x563, &mut x564, x562, x547, (0x0 as u32));
  let mut x565: u32 = 0;
  let mut x566: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x565, &mut x566, x564, x549, (0x1 as u32));
  let mut x567: u32 = 0;
  let mut x568: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x567, &mut x568, x566, x551, 0xffffffff);
  let mut x569: u32 = 0;
  let mut x570: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x569, &mut x570, x568, (x552 as u32), (0x0 as u32));
  let mut x571: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x571, x570, x553, x537);
  let mut x572: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x572, x570, x555, x539);
  let mut x573: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x573, x570, x557, x541);
  let mut x574: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x574, x570, x559, x543);
  let mut x575: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x575, x570, x561, x545);
  let mut x576: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x576, x570, x563, x547);
  let mut x577: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x577, x570, x565, x549);
  let mut x578: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x578, x570, x567, x551);
  out1[0] = x571;
  out1[1] = x572;
  out1[2] = x573;
  out1[3] = x574;
  out1[4] = x575;
  out1[5] = x576;
  out1[6] = x577;
  out1[7] = x578;
}

/// The function fiat_p256_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
#[inline]
pub fn fiat_p256_nonzero(out1: &mut u32, arg1: &[u32; 8]) -> () {
  let x1: u32 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | ((arg1[3]) | ((arg1[4]) | ((arg1[5]) | ((arg1[6]) | (arg1[7]))))))));
  *out1 = x1;
}

/// The function fiat_p256_selectznz is a multi-limb conditional select.
/// Postconditions:
///   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p256_selectznz(out1: &mut [u32; 8], arg1: fiat_p256_u1, arg2: &[u32; 8], arg3: &[u32; 8]) -> () {
  let mut x1: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x1, arg1, (arg2[0]), (arg3[0]));
  let mut x2: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x2, arg1, (arg2[1]), (arg3[1]));
  let mut x3: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x3, arg1, (arg2[2]), (arg3[2]));
  let mut x4: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x4, arg1, (arg2[3]), (arg3[3]));
  let mut x5: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x5, arg1, (arg2[4]), (arg3[4]));
  let mut x6: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x6, arg1, (arg2[5]), (arg3[5]));
  let mut x7: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x7, arg1, (arg2[6]), (arg3[6]));
  let mut x8: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x8, arg1, (arg2[7]), (arg3[7]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
}

/// The function fiat_p256_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
#[inline]
pub fn fiat_p256_to_bytes(out1: &mut [u8; 32], arg1: &[u32; 8]) -> () {
  let x1: u32 = (arg1[7]);
  let x2: u32 = (arg1[6]);
  let x3: u32 = (arg1[5]);
  let x4: u32 = (arg1[4]);
  let x5: u32 = (arg1[3]);
  let x6: u32 = (arg1[2]);
  let x7: u32 = (arg1[1]);
  let x8: u32 = (arg1[0]);
  let x9: u8 = ((x8 & (0xff as u32)) as u8);
  let x10: u32 = (x8 >> 8);
  let x11: u8 = ((x10 & (0xff as u32)) as u8);
  let x12: u32 = (x10 >> 8);
  let x13: u8 = ((x12 & (0xff as u32)) as u8);
  let x14: u8 = ((x12 >> 8) as u8);
  let x15: u8 = ((x7 & (0xff as u32)) as u8);
  let x16: u32 = (x7 >> 8);
  let x17: u8 = ((x16 & (0xff as u32)) as u8);
  let x18: u32 = (x16 >> 8);
  let x19: u8 = ((x18 & (0xff as u32)) as u8);
  let x20: u8 = ((x18 >> 8) as u8);
  let x21: u8 = ((x6 & (0xff as u32)) as u8);
  let x22: u32 = (x6 >> 8);
  let x23: u8 = ((x22 & (0xff as u32)) as u8);
  let x24: u32 = (x22 >> 8);
  let x25: u8 = ((x24 & (0xff as u32)) as u8);
  let x26: u8 = ((x24 >> 8) as u8);
  let x27: u8 = ((x5 & (0xff as u32)) as u8);
  let x28: u32 = (x5 >> 8);
  let x29: u8 = ((x28 & (0xff as u32)) as u8);
  let x30: u32 = (x28 >> 8);
  let x31: u8 = ((x30 & (0xff as u32)) as u8);
  let x32: u8 = ((x30 >> 8) as u8);
  let x33: u8 = ((x4 & (0xff as u32)) as u8);
  let x34: u32 = (x4 >> 8);
  let x35: u8 = ((x34 & (0xff as u32)) as u8);
  let x36: u32 = (x34 >> 8);
  let x37: u8 = ((x36 & (0xff as u32)) as u8);
  let x38: u8 = ((x36 >> 8) as u8);
  let x39: u8 = ((x3 & (0xff as u32)) as u8);
  let x40: u32 = (x3 >> 8);
  let x41: u8 = ((x40 & (0xff as u32)) as u8);
  let x42: u32 = (x40 >> 8);
  let x43: u8 = ((x42 & (0xff as u32)) as u8);
  let x44: u8 = ((x42 >> 8) as u8);
  let x45: u8 = ((x2 & (0xff as u32)) as u8);
  let x46: u32 = (x2 >> 8);
  let x47: u8 = ((x46 & (0xff as u32)) as u8);
  let x48: u32 = (x46 >> 8);
  let x49: u8 = ((x48 & (0xff as u32)) as u8);
  let x50: u8 = ((x48 >> 8) as u8);
  let x51: u8 = ((x1 & (0xff as u32)) as u8);
  let x52: u32 = (x1 >> 8);
  let x53: u8 = ((x52 & (0xff as u32)) as u8);
  let x54: u32 = (x52 >> 8);
  let x55: u8 = ((x54 & (0xff as u32)) as u8);
  let x56: u8 = ((x54 >> 8) as u8);
  out1[0] = x9;
  out1[1] = x11;
  out1[2] = x13;
  out1[3] = x14;
  out1[4] = x15;
  out1[5] = x17;
  out1[6] = x19;
  out1[7] = x20;
  out1[8] = x21;
  out1[9] = x23;
  out1[10] = x25;
  out1[11] = x26;
  out1[12] = x27;
  out1[13] = x29;
  out1[14] = x31;
  out1[15] = x32;
  out1[16] = x33;
  out1[17] = x35;
  out1[18] = x37;
  out1[19] = x38;
  out1[20] = x39;
  out1[21] = x41;
  out1[22] = x43;
  out1[23] = x44;
  out1[24] = x45;
  out1[25] = x47;
  out1[26] = x49;
  out1[27] = x50;
  out1[28] = x51;
  out1[29] = x53;
  out1[30] = x55;
  out1[31] = x56;
}

/// The function fiat_p256_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
/// Preconditions:
///   0 ≤ bytes_eval arg1 < m
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p256_from_bytes(out1: &mut [u32; 8], arg1: &[u8; 32]) -> () {
  let x1: u32 = (((arg1[31]) as u32) << 24);
  let x2: u32 = (((arg1[30]) as u32) << 16);
  let x3: u32 = (((arg1[29]) as u32) << 8);
  let x4: u8 = (arg1[28]);
  let x5: u32 = (((arg1[27]) as u32) << 24);
  let x6: u32 = (((arg1[26]) as u32) << 16);
  let x7: u32 = (((arg1[25]) as u32) << 8);
  let x8: u8 = (arg1[24]);
  let x9: u32 = (((arg1[23]) as u32) << 24);
  let x10: u32 = (((arg1[22]) as u32) << 16);
  let x11: u32 = (((arg1[21]) as u32) << 8);
  let x12: u8 = (arg1[20]);
  let x13: u32 = (((arg1[19]) as u32) << 24);
  let x14: u32 = (((arg1[18]) as u32) << 16);
  let x15: u32 = (((arg1[17]) as u32) << 8);
  let x16: u8 = (arg1[16]);
  let x17: u32 = (((arg1[15]) as u32) << 24);
  let x18: u32 = (((arg1[14]) as u32) << 16);
  let x19: u32 = (((arg1[13]) as u32) << 8);
  let x20: u8 = (arg1[12]);
  let x21: u32 = (((arg1[11]) as u32) << 24);
  let x22: u32 = (((arg1[10]) as u32) << 16);
  let x23: u32 = (((arg1[9]) as u32) << 8);
  let x24: u8 = (arg1[8]);
  let x25: u32 = (((arg1[7]) as u32) << 24);
  let x26: u32 = (((arg1[6]) as u32) << 16);
  let x27: u32 = (((arg1[5]) as u32) << 8);
  let x28: u8 = (arg1[4]);
  let x29: u32 = (((arg1[3]) as u32) << 24);
  let x30: u32 = (((arg1[2]) as u32) << 16);
  let x31: u32 = (((arg1[1]) as u32) << 8);
  let x32: u8 = (arg1[0]);
  let x33: u32 = (x31 + (x32 as u32));
  let x34: u32 = (x30 + x33);
  let x35: u32 = (x29 + x34);
  let x36: u32 = (x27 + (x28 as u32));
  let x37: u32 = (x26 + x36);
  let x38: u32 = (x25 + x37);
  let x39: u32 = (x23 + (x24 as u32));
  let x40: u32 = (x22 + x39);
  let x41: u32 = (x21 + x40);
  let x42: u32 = (x19 + (x20 as u32));
  let x43: u32 = (x18 + x42);
  let x44: u32 = (x17 + x43);
  let x45: u32 = (x15 + (x16 as u32));
  let x46: u32 = (x14 + x45);
  let x47: u32 = (x13 + x46);
  let x48: u32 = (x11 + (x12 as u32));
  let x49: u32 = (x10 + x48);
  let x50: u32 = (x9 + x49);
  let x51: u32 = (x7 + (x8 as u32));
  let x52: u32 = (x6 + x51);
  let x53: u32 = (x5 + x52);
  let x54: u32 = (x3 + (x4 as u32));
  let x55: u32 = (x2 + x54);
  let x56: u32 = (x1 + x55);
  out1[0] = x35;
  out1[1] = x38;
  out1[2] = x41;
  out1[3] = x44;
  out1[4] = x47;
  out1[5] = x50;
  out1[6] = x53;
  out1[7] = x56;
}

/// The function fiat_p256_set_one returns the field element one in the Montgomery domain.
/// Postconditions:
///   eval (from_montgomery out1) mod m = 1 mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p256_set_one(out1: &mut [u32; 8]) -> () {
  out1[0] = (0x1 as u32);
  out1[1] = (0x0 as u32);
  out1[2] = (0x0 as u32);
  out1[3] = 0xffffffff;
  out1[4] = 0xffffffff;
  out1[5] = 0xffffffff;
  out1[6] = 0xfffffffe;
  out1[7] = (0x0 as u32);
}

/// The function fiat_p256_msat returns the saturated representation of the prime modulus.
/// Postconditions:
///   twos_complement_eval out1 = m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p256_msat(out1: &mut [u32; 9]) -> () {
  out1[0] = 0xffffffff;
  out1[1] = 0xffffffff;
  out1[2] = 0xffffffff;
  out1[3] = (0x0 as u32);
  out1[4] = (0x0 as u32);
  out1[5] = (0x0 as u32);
  out1[6] = (0x1 as u32);
  out1[7] = 0xffffffff;
  out1[8] = (0x0 as u32);
}

/// The function fiat_p256_divstep computes a divstep.
/// Preconditions:
///   0 ≤ eval arg4 < m
///   0 ≤ eval arg5 < m
/// Postconditions:
///   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
///   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
///   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
///   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
///   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
///   0 ≤ eval out5 < m
///   0 ≤ eval out5 < m
///   0 ≤ eval out2 < m
///   0 ≤ eval out3 < m
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffff]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p256_divstep(out1: &mut u32, out2: &mut [u32; 9], out3: &mut [u32; 9], out4: &mut [u32; 8], out5: &mut [u32; 8], arg1: u32, arg2: &[u32; 9], arg3: &[u32; 9], arg4: &[u32; 8], arg5: &[u32; 8]) -> () {
  let mut x1: u32 = 0;
  let mut x2: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x1, &mut x2, 0x0, (!arg1), (0x1 as u32));
  let x3: fiat_p256_u1 = (((x1 >> 31) as fiat_p256_u1) & (((arg3[0]) & (0x1 as u32)) as fiat_p256_u1));
  let mut x4: u32 = 0;
  let mut x5: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x4, &mut x5, 0x0, (!arg1), (0x1 as u32));
  let mut x6: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x6, x3, arg1, x4);
  let mut x7: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x7, x3, (arg2[0]), (arg3[0]));
  let mut x8: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x8, x3, (arg2[1]), (arg3[1]));
  let mut x9: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x9, x3, (arg2[2]), (arg3[2]));
  let mut x10: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x10, x3, (arg2[3]), (arg3[3]));
  let mut x11: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x11, x3, (arg2[4]), (arg3[4]));
  let mut x12: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x12, x3, (arg2[5]), (arg3[5]));
  let mut x13: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x13, x3, (arg2[6]), (arg3[6]));
  let mut x14: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x14, x3, (arg2[7]), (arg3[7]));
  let mut x15: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x15, x3, (arg2[8]), (arg3[8]));
  let mut x16: u32 = 0;
  let mut x17: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x16, &mut x17, 0x0, (0x1 as u32), (!(arg2[0])));
  let mut x18: u32 = 0;
  let mut x19: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x18, &mut x19, x17, (0x0 as u32), (!(arg2[1])));
  let mut x20: u32 = 0;
  let mut x21: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x20, &mut x21, x19, (0x0 as u32), (!(arg2[2])));
  let mut x22: u32 = 0;
  let mut x23: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x22, &mut x23, x21, (0x0 as u32), (!(arg2[3])));
  let mut x24: u32 = 0;
  let mut x25: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x24, &mut x25, x23, (0x0 as u32), (!(arg2[4])));
  let mut x26: u32 = 0;
  let mut x27: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x26, &mut x27, x25, (0x0 as u32), (!(arg2[5])));
  let mut x28: u32 = 0;
  let mut x29: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x28, &mut x29, x27, (0x0 as u32), (!(arg2[6])));
  let mut x30: u32 = 0;
  let mut x31: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x30, &mut x31, x29, (0x0 as u32), (!(arg2[7])));
  let mut x32: u32 = 0;
  let mut x33: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x32, &mut x33, x31, (0x0 as u32), (!(arg2[8])));
  let mut x34: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x34, x3, (arg3[0]), x16);
  let mut x35: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x35, x3, (arg3[1]), x18);
  let mut x36: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x36, x3, (arg3[2]), x20);
  let mut x37: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x37, x3, (arg3[3]), x22);
  let mut x38: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x38, x3, (arg3[4]), x24);
  let mut x39: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x39, x3, (arg3[5]), x26);
  let mut x40: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x40, x3, (arg3[6]), x28);
  let mut x41: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x41, x3, (arg3[7]), x30);
  let mut x42: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x42, x3, (arg3[8]), x32);
  let mut x43: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x43, x3, (arg4[0]), (arg5[0]));
  let mut x44: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x44, x3, (arg4[1]), (arg5[1]));
  let mut x45: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x45, x3, (arg4[2]), (arg5[2]));
  let mut x46: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x46, x3, (arg4[3]), (arg5[3]));
  let mut x47: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x47, x3, (arg4[4]), (arg5[4]));
  let mut x48: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x48, x3, (arg4[5]), (arg5[5]));
  let mut x49: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x49, x3, (arg4[6]), (arg5[6]));
  let mut x50: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x50, x3, (arg4[7]), (arg5[7]));
  let mut x51: u32 = 0;
  let mut x52: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x51, &mut x52, 0x0, x43, x43);
  let mut x53: u32 = 0;
  let mut x54: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x53, &mut x54, x52, x44, x44);
  let mut x55: u32 = 0;
  let mut x56: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x55, &mut x56, x54, x45, x45);
  let mut x57: u32 = 0;
  let mut x58: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x57, &mut x58, x56, x46, x46);
  let mut x59: u32 = 0;
  let mut x60: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x59, &mut x60, x58, x47, x47);
  let mut x61: u32 = 0;
  let mut x62: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x61, &mut x62, x60, x48, x48);
  let mut x63: u32 = 0;
  let mut x64: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x63, &mut x64, x62, x49, x49);
  let mut x65: u32 = 0;
  let mut x66: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x65, &mut x66, x64, x50, x50);
  let mut x67: u32 = 0;
  let mut x68: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x67, &mut x68, 0x0, x51, 0xffffffff);
  let mut x69: u32 = 0;
  let mut x70: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x69, &mut x70, x68, x53, 0xffffffff);
  let mut x71: u32 = 0;
  let mut x72: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x71, &mut x72, x70, x55, 0xffffffff);
  let mut x73: u32 = 0;
  let mut x74: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x73, &mut x74, x72, x57, (0x0 as u32));
  let mut x75: u32 = 0;
  let mut x76: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x75, &mut x76, x74, x59, (0x0 as u32));
  let mut x77: u32 = 0;
  let mut x78: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x77, &mut x78, x76, x61, (0x0 as u32));
  let mut x79: u32 = 0;
  let mut x80: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x79, &mut x80, x78, x63, (0x1 as u32));
  let mut x81: u32 = 0;
  let mut x82: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x81, &mut x82, x80, x65, 0xffffffff);
  let mut x83: u32 = 0;
  let mut x84: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x83, &mut x84, x82, (x66 as u32), (0x0 as u32));
  let x85: u32 = (arg4[7]);
  let x86: u32 = (arg4[6]);
  let x87: u32 = (arg4[5]);
  let x88: u32 = (arg4[4]);
  let x89: u32 = (arg4[3]);
  let x90: u32 = (arg4[2]);
  let x91: u32 = (arg4[1]);
  let x92: u32 = (arg4[0]);
  let mut x93: u32 = 0;
  let mut x94: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x93, &mut x94, 0x0, (0x0 as u32), x92);
  let mut x95: u32 = 0;
  let mut x96: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x95, &mut x96, x94, (0x0 as u32), x91);
  let mut x97: u32 = 0;
  let mut x98: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x97, &mut x98, x96, (0x0 as u32), x90);
  let mut x99: u32 = 0;
  let mut x100: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x99, &mut x100, x98, (0x0 as u32), x89);
  let mut x101: u32 = 0;
  let mut x102: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x101, &mut x102, x100, (0x0 as u32), x88);
  let mut x103: u32 = 0;
  let mut x104: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x103, &mut x104, x102, (0x0 as u32), x87);
  let mut x105: u32 = 0;
  let mut x106: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x105, &mut x106, x104, (0x0 as u32), x86);
  let mut x107: u32 = 0;
  let mut x108: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x107, &mut x108, x106, (0x0 as u32), x85);
  let mut x109: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x109, x108, (0x0 as u32), 0xffffffff);
  let mut x110: u32 = 0;
  let mut x111: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x110, &mut x111, 0x0, x93, x109);
  let mut x112: u32 = 0;
  let mut x113: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x112, &mut x113, x111, x95, x109);
  let mut x114: u32 = 0;
  let mut x115: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x114, &mut x115, x113, x97, x109);
  let mut x116: u32 = 0;
  let mut x117: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x116, &mut x117, x115, x99, (0x0 as u32));
  let mut x118: u32 = 0;
  let mut x119: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x118, &mut x119, x117, x101, (0x0 as u32));
  let mut x120: u32 = 0;
  let mut x121: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x120, &mut x121, x119, x103, (0x0 as u32));
  let mut x122: u32 = 0;
  let mut x123: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x122, &mut x123, x121, x105, (((x109 & (0x1 as u32)) as fiat_p256_u1) as u32));
  let mut x124: u32 = 0;
  let mut x125: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x124, &mut x125, x123, x107, x109);
  let mut x126: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x126, x3, (arg5[0]), x110);
  let mut x127: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x127, x3, (arg5[1]), x112);
  let mut x128: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x128, x3, (arg5[2]), x114);
  let mut x129: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x129, x3, (arg5[3]), x116);
  let mut x130: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x130, x3, (arg5[4]), x118);
  let mut x131: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x131, x3, (arg5[5]), x120);
  let mut x132: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x132, x3, (arg5[6]), x122);
  let mut x133: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x133, x3, (arg5[7]), x124);
  let x134: fiat_p256_u1 = ((x34 & (0x1 as u32)) as fiat_p256_u1);
  let mut x135: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x135, x134, (0x0 as u32), x7);
  let mut x136: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x136, x134, (0x0 as u32), x8);
  let mut x137: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x137, x134, (0x0 as u32), x9);
  let mut x138: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x138, x134, (0x0 as u32), x10);
  let mut x139: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x139, x134, (0x0 as u32), x11);
  let mut x140: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x140, x134, (0x0 as u32), x12);
  let mut x141: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x141, x134, (0x0 as u32), x13);
  let mut x142: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x142, x134, (0x0 as u32), x14);
  let mut x143: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x143, x134, (0x0 as u32), x15);
  let mut x144: u32 = 0;
  let mut x145: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x144, &mut x145, 0x0, x34, x135);
  let mut x146: u32 = 0;
  let mut x147: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x146, &mut x147, x145, x35, x136);
  let mut x148: u32 = 0;
  let mut x149: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x148, &mut x149, x147, x36, x137);
  let mut x150: u32 = 0;
  let mut x151: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x150, &mut x151, x149, x37, x138);
  let mut x152: u32 = 0;
  let mut x153: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x152, &mut x153, x151, x38, x139);
  let mut x154: u32 = 0;
  let mut x155: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x154, &mut x155, x153, x39, x140);
  let mut x156: u32 = 0;
  let mut x157: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x156, &mut x157, x155, x40, x141);
  let mut x158: u32 = 0;
  let mut x159: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x158, &mut x159, x157, x41, x142);
  let mut x160: u32 = 0;
  let mut x161: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x160, &mut x161, x159, x42, x143);
  let mut x162: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x162, x134, (0x0 as u32), x43);
  let mut x163: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x163, x134, (0x0 as u32), x44);
  let mut x164: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x164, x134, (0x0 as u32), x45);
  let mut x165: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x165, x134, (0x0 as u32), x46);
  let mut x166: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x166, x134, (0x0 as u32), x47);
  let mut x167: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x167, x134, (0x0 as u32), x48);
  let mut x168: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x168, x134, (0x0 as u32), x49);
  let mut x169: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x169, x134, (0x0 as u32), x50);
  let mut x170: u32 = 0;
  let mut x171: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x170, &mut x171, 0x0, x126, x162);
  let mut x172: u32 = 0;
  let mut x173: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x172, &mut x173, x171, x127, x163);
  let mut x174: u32 = 0;
  let mut x175: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x174, &mut x175, x173, x128, x164);
  let mut x176: u32 = 0;
  let mut x177: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x176, &mut x177, x175, x129, x165);
  let mut x178: u32 = 0;
  let mut x179: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x178, &mut x179, x177, x130, x166);
  let mut x180: u32 = 0;
  let mut x181: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x180, &mut x181, x179, x131, x167);
  let mut x182: u32 = 0;
  let mut x183: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x182, &mut x183, x181, x132, x168);
  let mut x184: u32 = 0;
  let mut x185: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x184, &mut x185, x183, x133, x169);
  let mut x186: u32 = 0;
  let mut x187: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x186, &mut x187, 0x0, x170, 0xffffffff);
  let mut x188: u32 = 0;
  let mut x189: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x188, &mut x189, x187, x172, 0xffffffff);
  let mut x190: u32 = 0;
  let mut x191: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x190, &mut x191, x189, x174, 0xffffffff);
  let mut x192: u32 = 0;
  let mut x193: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x192, &mut x193, x191, x176, (0x0 as u32));
  let mut x194: u32 = 0;
  let mut x195: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x194, &mut x195, x193, x178, (0x0 as u32));
  let mut x196: u32 = 0;
  let mut x197: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x196, &mut x197, x195, x180, (0x0 as u32));
  let mut x198: u32 = 0;
  let mut x199: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x198, &mut x199, x197, x182, (0x1 as u32));
  let mut x200: u32 = 0;
  let mut x201: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x200, &mut x201, x199, x184, 0xffffffff);
  let mut x202: u32 = 0;
  let mut x203: fiat_p256_u1 = 0;
  fiat_p256_subborrowx_u32(&mut x202, &mut x203, x201, (x185 as u32), (0x0 as u32));
  let mut x204: u32 = 0;
  let mut x205: fiat_p256_u1 = 0;
  fiat_p256_addcarryx_u32(&mut x204, &mut x205, 0x0, x6, (0x1 as u32));
  let x206: u32 = ((x144 >> 1) | ((x146 << 31) & 0xffffffff));
  let x207: u32 = ((x146 >> 1) | ((x148 << 31) & 0xffffffff));
  let x208: u32 = ((x148 >> 1) | ((x150 << 31) & 0xffffffff));
  let x209: u32 = ((x150 >> 1) | ((x152 << 31) & 0xffffffff));
  let x210: u32 = ((x152 >> 1) | ((x154 << 31) & 0xffffffff));
  let x211: u32 = ((x154 >> 1) | ((x156 << 31) & 0xffffffff));
  let x212: u32 = ((x156 >> 1) | ((x158 << 31) & 0xffffffff));
  let x213: u32 = ((x158 >> 1) | ((x160 << 31) & 0xffffffff));
  let x214: u32 = ((x160 & 0x80000000) | (x160 >> 1));
  let mut x215: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x215, x84, x67, x51);
  let mut x216: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x216, x84, x69, x53);
  let mut x217: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x217, x84, x71, x55);
  let mut x218: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x218, x84, x73, x57);
  let mut x219: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x219, x84, x75, x59);
  let mut x220: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x220, x84, x77, x61);
  let mut x221: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x221, x84, x79, x63);
  let mut x222: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x222, x84, x81, x65);
  let mut x223: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x223, x203, x186, x170);
  let mut x224: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x224, x203, x188, x172);
  let mut x225: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x225, x203, x190, x174);
  let mut x226: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x226, x203, x192, x176);
  let mut x227: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x227, x203, x194, x178);
  let mut x228: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x228, x203, x196, x180);
  let mut x229: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x229, x203, x198, x182);
  let mut x230: u32 = 0;
  fiat_p256_cmovznz_u32(&mut x230, x203, x200, x184);
  *out1 = x204;
  out2[0] = x7;
  out2[1] = x8;
  out2[2] = x9;
  out2[3] = x10;
  out2[4] = x11;
  out2[5] = x12;
  out2[6] = x13;
  out2[7] = x14;
  out2[8] = x15;
  out3[0] = x206;
  out3[1] = x207;
  out3[2] = x208;
  out3[3] = x209;
  out3[4] = x210;
  out3[5] = x211;
  out3[6] = x212;
  out3[7] = x213;
  out3[8] = x214;
  out4[0] = x215;
  out4[1] = x216;
  out4[2] = x217;
  out4[3] = x218;
  out4[4] = x219;
  out4[5] = x220;
  out4[6] = x221;
  out4[7] = x222;
  out5[0] = x223;
  out5[1] = x224;
  out5[2] = x225;
  out5[3] = x226;
  out5[4] = x227;
  out5[5] = x228;
  out5[6] = x229;
  out5[7] = x230;
}

/// The function fiat_p256_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
/// Postconditions:
///   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if (log2 m) + 1 < 46 then ⌊(49 * ((log2 m) + 1) + 80) / 17⌋ else ⌊(49 * ((log2 m) + 1) + 57) / 17⌋)
///   0 ≤ eval out1 < m
///
/// Input Bounds:
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub fn fiat_p256_divstep_precomp(out1: &mut [u32; 8]) -> () {
  out1[0] = 0xb8000000;
  out1[1] = 0x67ffffff;
  out1[2] = 0x38000000;
  out1[3] = 0xc0000000;
  out1[4] = 0x7fffffff;
  out1[5] = 0xd8000000;
  out1[6] = 0xffffffff;
  out1[7] = 0x2fffffff;
}

