use crate::Skills;

pub struct RecipeLevel {
    pub class_job_level: u8,
    pub stars: u8,
    pub suggested_craftsmanship: u16,
    pub suggested_control: u16,
    pub difficulty: u16,
    pub quality: u32,
    pub progress_divider: u8,
    pub quality_divider: u8,
    pub progress_modifier: u8,
    pub quality_modifier: u8,
    pub durability: u16,
    pub conditions_flag: u16,
}

pub fn recipe_level_table(rlv: i32) -> RecipeLevel {
    let a = match rlv {
        1 => (1, 0, 22, 11, 19, 100, 50, 30, 100, 100, 60, 15),
        2 => (2, 0, 22, 11, 20, 110, 50, 30, 100, 100, 60, 15),
        3 => (3, 0, 22, 11, 20, 120, 50, 30, 100, 100, 60, 15),
        4 => (4, 0, 22, 11, 21, 130, 50, 30, 100, 100, 60, 15),
        5 => (5, 0, 50, 25, 33, 150, 50, 30, 100, 100, 60, 15),
        6 => (6, 0, 50, 25, 36, 170, 50, 30, 100, 100, 60, 15),
        7 => (7, 0, 50, 25, 37, 190, 50, 30, 100, 100, 60, 15),
        8 => (8, 0, 59, 29, 41, 210, 50, 30, 100, 100, 60, 15),
        9 => (9, 0, 59, 29, 42, 230, 50, 30, 100, 100, 60, 15),
        10 => (10, 0, 59, 29, 45, 250, 50, 30, 100, 100, 60, 15),
        11 => (11, 0, 67, 33, 48, 270, 50, 30, 100, 100, 60, 15),
        12 => (12, 0, 67, 33, 53, 290, 50, 30, 100, 100, 60, 15),
        13 => (13, 0, 67, 33, 54, 310, 50, 30, 100, 100, 60, 15),
        14 => (14, 0, 67, 33, 54, 330, 50, 30, 100, 100, 60, 15),
        15 => (15, 0, 67, 33, 55, 360, 50, 30, 100, 100, 70, 15),
        16 => (16, 0, 78, 39, 63, 390, 50, 30, 100, 100, 70, 15),
        17 => (17, 0, 78, 39, 66, 420, 50, 30, 100, 100, 70, 15),
        18 => (18, 0, 78, 39, 67, 450, 50, 30, 100, 100, 70, 15),
        19 => (19, 0, 82, 41, 68, 480, 50, 30, 100, 100, 70, 15),
        20 => (20, 0, 94, 47, 74, 510, 50, 30, 100, 100, 70, 15),
        21 => (21, 0, 94, 47, 75, 540, 50, 30, 100, 100, 70, 15),
        22 => (22, 0, 94, 47, 75, 570, 50, 30, 100, 100, 70, 15),
        23 => (23, 0, 99, 49, 79, 600, 50, 30, 100, 100, 70, 15),
        24 => (24, 0, 99, 49, 85, 630, 50, 30, 100, 100, 70, 15),
        25 => (25, 0, 99, 49, 89, 660, 50, 30, 100, 100, 70, 15),
        26 => (26, 0, 99, 49, 90, 690, 50, 30, 100, 100, 70, 15),
        27 => (27, 0, 99, 49, 91, 720, 50, 30, 100, 100, 70, 15),
        28 => (28, 0, 106, 53, 100, 760, 50, 30, 100, 100, 70, 15),
        29 => (29, 0, 106, 53, 101, 800, 50, 30, 100, 100, 70, 15),
        30 => (30, 0, 106, 53, 102, 850, 50, 30, 100, 100, 70, 15),
        31 => (31, 0, 121, 60, 106, 900, 50, 30, 100, 100, 80, 15),
        32 => (32, 0, 121, 60, 110, 950, 50, 30, 100, 100, 80, 15),
        33 => (33, 0, 121, 60, 111, 1000, 50, 30, 100, 100, 80, 15),
        34 => (34, 0, 129, 64, 115, 1050, 50, 30, 100, 100, 80, 15),
        35 => (35, 0, 129, 64, 123, 1110, 50, 30, 100, 100, 80, 15),
        36 => (36, 0, 129, 64, 124, 1160, 50, 30, 100, 100, 80, 15),
        37 => (37, 0, 129, 64, 128, 1220, 50, 30, 100, 100, 80, 15),
        38 => (38, 0, 129, 64, 129, 1280, 50, 30, 100, 100, 80, 15),
        39 => (39, 0, 136, 68, 137, 1340, 50, 30, 100, 100, 80, 15),
        40 => (40, 0, 136, 68, 138, 1400, 50, 30, 100, 100, 80, 15),
        41 => (41, 0, 136, 68, 143, 1460, 50, 30, 100, 100, 80, 15),
        42 => (42, 0, 150, 75, 144, 1520, 50, 30, 100, 100, 80, 15),
        43 => (43, 0, 150, 75, 155, 1580, 50, 30, 100, 100, 80, 15),
        44 => (44, 0, 150, 75, 156, 1640, 50, 30, 100, 100, 80, 15),
        45 => (45, 0, 150, 75, 158, 1700, 50, 30, 100, 100, 80, 15),
        46 => (46, 0, 150, 75, 159, 1760, 50, 30, 100, 100, 80, 15),
        47 => (47, 0, 161, 80, 167, 1820, 50, 30, 100, 100, 80, 15),
        48 => (48, 0, 161, 80, 172, 1880, 50, 30, 100, 100, 80, 15),
        49 => (49, 0, 161, 80, 174, 1940, 50, 30, 100, 100, 80, 15),
        50 => (50, 0, 176, 88, 180, 2000, 50, 30, 100, 100, 80, 15),
        51 => (50, 0, 281, 281, 185, 2040, 50, 30, 100, 100, 80, 15),
        52 => (50, 0, 291, 291, 190, 2080, 50, 30, 100, 100, 80, 15),
        53 => (50, 0, 302, 302, 195, 2120, 50, 30, 100, 100, 80, 15),
        54 => (50, 0, 314, 314, 200, 2160, 50, 30, 100, 100, 80, 15),
        55 => (50, 1, 325, 325, 210, 2200, 50, 30, 100, 100, 80, 15),
        56 => (50, 1, 325, 325, 212, 2220, 50, 30, 100, 100, 80, 15),
        57 => (50, 1, 325, 325, 214, 2240, 50, 30, 100, 100, 80, 15),
        58 => (50, 1, 325, 325, 216, 2260, 50, 30, 100, 100, 80, 15),
        59 => (50, 1, 325, 325, 218, 2280, 50, 30, 100, 100, 80, 15),
        60 => (50, 1, 325, 325, 220, 2300, 50, 30, 100, 100, 80, 15),
        61 => (50, 1, 325, 325, 223, 2320, 50, 30, 100, 100, 80, 15),
        62 => (50, 1, 325, 325, 226, 2340, 50, 30, 100, 100, 80, 15),
        63 => (50, 1, 325, 325, 229, 2360, 50, 30, 100, 100, 80, 15),
        64 => (50, 1, 325, 325, 232, 2380, 50, 30, 100, 100, 80, 15),
        65 => (50, 1, 325, 325, 235, 2400, 50, 30, 100, 100, 80, 15),
        66 => (50, 1, 325, 325, 238, 2420, 50, 30, 100, 100, 80, 15),
        67 => (50, 1, 325, 325, 241, 2440, 50, 30, 100, 100, 80, 15),
        68 => (50, 1, 325, 325, 244, 2460, 50, 30, 100, 100, 80, 15),
        69 => (50, 1, 325, 325, 247, 2480, 50, 30, 100, 100, 80, 15),
        70 => (50, 2, 325, 325, 250, 2500, 50, 30, 80, 70, 80, 15),
        71 => (50, 2, 329, 328, 258, 2512, 50, 30, 80, 70, 80, 15),
        72 => (50, 2, 332, 330, 266, 2524, 50, 30, 80, 70, 80, 15),
        73 => (50, 2, 335, 333, 274, 2536, 50, 30, 80, 70, 80, 15),
        74 => (50, 2, 339, 335, 282, 2548, 50, 30, 80, 70, 80, 15),
        75 => (50, 2, 342, 338, 290, 2560, 50, 30, 80, 70, 80, 15),
        76 => (50, 2, 345, 340, 298, 2572, 50, 30, 80, 70, 80, 15),
        77 => (50, 2, 349, 343, 306, 2584, 50, 30, 80, 70, 80, 15),
        78 => (50, 2, 352, 345, 314, 2596, 50, 30, 80, 70, 80, 15),
        79 => (50, 2, 355, 348, 322, 2608, 50, 30, 80, 70, 80, 15),
        80 => (50, 2, 358, 350, 330, 2620, 50, 30, 80, 70, 80, 15),
        81 => (50, 2, 362, 352, 339, 2633, 50, 30, 80, 70, 80, 15),
        82 => (50, 2, 365, 355, 348, 2646, 50, 30, 80, 70, 80, 15),
        83 => (50, 2, 368, 357, 357, 2659, 50, 30, 80, 70, 80, 15),
        84 => (50, 2, 372, 360, 366, 2672, 50, 30, 80, 70, 80, 15),
        85 => (50, 2, 375, 362, 375, 2685, 50, 30, 80, 70, 80, 15),
        86 => (50, 2, 378, 365, 384, 2698, 50, 30, 80, 70, 80, 15),
        87 => (50, 2, 382, 367, 393, 2711, 50, 30, 80, 70, 80, 15),
        88 => (50, 2, 385, 370, 402, 2724, 50, 30, 80, 70, 80, 15),
        89 => (50, 2, 388, 372, 411, 2737, 50, 30, 80, 70, 80, 15),
        90 => (50, 3, 391, 374, 420, 2750, 50, 30, 80, 70, 80, 15),
        91 => (50, 3, 394, 376, 423, 2757, 50, 30, 80, 70, 80, 15),
        92 => (50, 3, 397, 378, 426, 2764, 50, 30, 80, 70, 80, 15),
        93 => (50, 3, 400, 379, 429, 2771, 50, 30, 80, 70, 80, 15),
        94 => (50, 3, 403, 381, 432, 2778, 50, 30, 80, 70, 80, 15),
        95 => (50, 3, 406, 383, 435, 2785, 50, 30, 80, 70, 80, 15),
        96 => (50, 3, 409, 384, 438, 2792, 50, 30, 80, 70, 80, 15),
        97 => (50, 3, 412, 386, 441, 2799, 50, 30, 80, 70, 80, 15),
        98 => (50, 3, 415, 388, 444, 2806, 50, 30, 80, 70, 80, 15),
        99 => (50, 3, 418, 389, 447, 2813, 50, 30, 80, 70, 80, 15),
        100 => (50, 3, 421, 391, 450, 2820, 50, 30, 80, 70, 80, 15),
        101 => (50, 3, 424, 393, 453, 2828, 50, 30, 80, 70, 80, 15),
        102 => (50, 3, 427, 394, 456, 2836, 50, 30, 80, 70, 80, 15),
        103 => (50, 3, 430, 396, 459, 2844, 50, 30, 80, 70, 80, 15),
        104 => (50, 3, 433, 398, 462, 2852, 50, 30, 80, 70, 80, 15),
        105 => (50, 3, 436, 399, 465, 2860, 50, 30, 80, 70, 80, 15),
        106 => (50, 3, 439, 401, 468, 2868, 50, 30, 80, 70, 80, 15),
        107 => (50, 3, 442, 403, 471, 2876, 50, 30, 80, 70, 80, 15),
        108 => (50, 3, 445, 404, 474, 2884, 50, 30, 80, 70, 80, 15),
        109 => (50, 3, 448, 406, 477, 2892, 50, 30, 80, 70, 80, 15),
        110 => (50, 4, 451, 407, 480, 2900, 50, 30, 80, 70, 80, 15),
        111 => (50, 4, 455, 411, 480, 2900, 50, 30, 80, 70, 80, 15),
        112 => (50, 4, 458, 415, 480, 2900, 50, 30, 80, 70, 80, 15),
        113 => (50, 4, 462, 418, 480, 2900, 50, 30, 80, 70, 80, 15),
        114 => (50, 4, 465, 422, 480, 2900, 50, 30, 80, 70, 80, 15),
        115 => (51, 0, 468, 426, 220, 2070, 61, 39, 100, 100, 80, 15),
        116 => (51, 0, 472, 429, 224, 2077, 61, 39, 100, 100, 80, 15),
        117 => (51, 0, 475, 433, 228, 2084, 61, 39, 100, 100, 80, 15),
        118 => (51, 0, 479, 437, 232, 2091, 61, 39, 100, 100, 80, 15),
        119 => (51, 0, 482, 440, 236, 2098, 61, 39, 100, 100, 80, 15),
        120 => (51, 0, 485, 444, 240, 2105, 61, 39, 100, 100, 80, 15),
        121 => (51, 0, 489, 448, 244, 2112, 61, 39, 100, 100, 80, 15),
        122 => (51, 0, 492, 451, 248, 2119, 61, 39, 100, 100, 80, 15),
        123 => (51, 0, 495, 455, 252, 2126, 61, 39, 100, 100, 80, 15),
        124 => (51, 0, 499, 458, 256, 2133, 61, 39, 100, 100, 80, 15),
        125 => (52, 0, 502, 462, 260, 2140, 62, 43, 100, 100, 80, 15),
        126 => (52, 0, 506, 466, 268, 2154, 62, 43, 100, 100, 80, 15),
        127 => (52, 0, 509, 469, 276, 2168, 62, 43, 100, 100, 80, 15),
        128 => (52, 0, 512, 473, 284, 2182, 62, 43, 100, 100, 80, 15),
        129 => (52, 0, 516, 477, 292, 2196, 62, 43, 100, 100, 80, 15),
        130 => (53, 0, 519, 480, 300, 2210, 63, 43, 100, 100, 80, 15),
        131 => (53, 0, 522, 484, 313, 2233, 63, 43, 100, 100, 80, 15),
        132 => (53, 0, 526, 488, 326, 2256, 63, 43, 100, 100, 80, 15),
        133 => (54, 0, 529, 491, 340, 2280, 64, 44, 100, 100, 80, 15),
        134 => (54, 0, 533, 495, 353, 2303, 64, 44, 100, 100, 80, 15),
        135 => (54, 0, 536, 498, 366, 2326, 64, 44, 100, 100, 80, 15),
        136 => (55, 0, 539, 502, 380, 2350, 65, 45, 100, 100, 70, 15),
        137 => (55, 0, 543, 506, 393, 2373, 65, 45, 100, 100, 70, 15),
        138 => (55, 0, 546, 509, 406, 2396, 65, 45, 100, 100, 70, 15),
        139 => (56, 0, 550, 513, 420, 2420, 66, 46, 100, 100, 70, 15),
        140 => (56, 0, 553, 517, 433, 2443, 66, 46, 100, 100, 70, 15),
        141 => (56, 0, 556, 520, 446, 2466, 66, 46, 100, 100, 70, 15),
        142 => (57, 0, 560, 524, 460, 2490, 67, 47, 100, 100, 70, 15),
        143 => (57, 0, 563, 528, 473, 2513, 67, 47, 100, 100, 70, 15),
        144 => (57, 0, 566, 531, 486, 2536, 67, 47, 100, 100, 70, 15),
        145 => (58, 0, 570, 535, 500, 2560, 68, 48, 100, 100, 70, 15),
        146 => (58, 0, 573, 539, 513, 2583, 68, 48, 100, 100, 70, 15),
        147 => (58, 0, 577, 542, 526, 2606, 68, 48, 100, 100, 70, 15),
        148 => (59, 0, 580, 546, 540, 2630, 69, 49, 100, 100, 70, 15),
        149 => (59, 0, 583, 549, 560, 2665, 69, 49, 100, 100, 70, 15),
        150 => (60, 0, 587, 553, 580, 2700, 70, 50, 100, 100, 70, 15),
        151 => (60, 0, 590, 557, 588, 2710, 70, 50, 100, 100, 70, 15),
        152 => (60, 0, 593, 560, 596, 2720, 70, 50, 100, 100, 70, 15),
        153 => (60, 0, 597, 564, 604, 2730, 70, 50, 100, 100, 70, 15),
        154 => (60, 0, 600, 568, 612, 2740, 70, 50, 100, 100, 70, 15),
        155 => (60, 0, 604, 571, 620, 2750, 70, 50, 100, 100, 70, 15),
        156 => (60, 0, 607, 575, 628, 2760, 70, 50, 100, 100, 70, 15),
        157 => (60, 0, 610, 579, 636, 2770, 70, 50, 100, 100, 70, 15),
        158 => (60, 0, 614, 582, 644, 2780, 70, 50, 100, 100, 70, 15),
        159 => (60, 0, 617, 586, 652, 2790, 70, 50, 100, 100, 70, 15),
        160 => (60, 1, 620, 589, 660, 2800, 70, 50, 100, 100, 70, 15),
        161 => (60, 1, 625, 595, 664, 2805, 70, 50, 100, 100, 70, 15),
        162 => (60, 1, 630, 600, 668, 2810, 70, 50, 100, 100, 70, 15),
        163 => (60, 1, 635, 605, 672, 2815, 70, 50, 100, 100, 70, 15),
        164 => (60, 1, 640, 611, 676, 2820, 70, 50, 100, 100, 70, 15),
        165 => (60, 1, 645, 616, 680, 2825, 70, 50, 100, 100, 70, 15),
        166 => (60, 1, 650, 621, 684, 2830, 70, 50, 100, 100, 70, 15),
        167 => (60, 1, 655, 627, 688, 2835, 70, 50, 100, 100, 70, 15),
        168 => (60, 1, 660, 632, 692, 2840, 70, 50, 100, 100, 70, 15),
        169 => (60, 1, 665, 637, 696, 2845, 70, 50, 100, 100, 70, 15),
        170 => (60, 1, 669, 642, 700, 2850, 70, 50, 100, 100, 70, 15),
        171 => (60, 1, 674, 648, 704, 2855, 70, 50, 100, 100, 70, 15),
        172 => (60, 1, 679, 653, 708, 2860, 70, 50, 100, 100, 70, 15),
        173 => (60, 1, 684, 658, 712, 2865, 70, 50, 100, 100, 70, 15),
        174 => (60, 1, 689, 664, 716, 2870, 70, 50, 100, 100, 70, 15),
        175 => (60, 1, 694, 669, 720, 2875, 70, 50, 100, 100, 70, 15),
        176 => (60, 1, 699, 674, 724, 2880, 70, 50, 100, 100, 70, 15),
        177 => (60, 1, 704, 680, 728, 2885, 70, 50, 100, 100, 70, 15),
        178 => (60, 1, 709, 685, 732, 2890, 70, 50, 100, 100, 70, 15),
        179 => (60, 1, 714, 690, 736, 2895, 70, 50, 100, 100, 70, 15),
        180 => (60, 2, 718, 695, 740, 2900, 70, 50, 80, 70, 70, 15),
        181 => (60, 2, 723, 700, 744, 2913, 70, 50, 80, 70, 70, 15),
        182 => (60, 2, 727, 704, 748, 2926, 70, 50, 80, 70, 70, 15),
        183 => (60, 2, 732, 708, 752, 2939, 70, 50, 80, 70, 70, 15),
        184 => (60, 2, 736, 712, 756, 2952, 70, 50, 80, 70, 70, 15),
        185 => (60, 2, 740, 716, 760, 2965, 70, 50, 80, 70, 70, 15),
        186 => (60, 2, 745, 720, 764, 2978, 70, 50, 80, 70, 70, 15),
        187 => (60, 2, 749, 725, 768, 2991, 70, 50, 80, 70, 70, 15),
        188 => (60, 2, 754, 729, 772, 3004, 70, 50, 80, 70, 70, 15),
        189 => (60, 2, 758, 733, 776, 3017, 70, 50, 80, 70, 70, 15),
        190 => (60, 2, 762, 737, 780, 3030, 70, 50, 80, 70, 70, 15),
        191 => (60, 2, 767, 741, 785, 3043, 70, 50, 80, 70, 70, 15),
        192 => (60, 2, 771, 745, 790, 3056, 70, 50, 80, 70, 70, 15),
        193 => (60, 2, 776, 750, 795, 3069, 70, 50, 80, 70, 70, 15),
        194 => (60, 2, 780, 754, 800, 3082, 70, 50, 80, 70, 70, 15),
        195 => (60, 2, 784, 758, 805, 3095, 70, 50, 80, 70, 70, 15),
        196 => (60, 2, 789, 762, 810, 3108, 70, 50, 80, 70, 70, 15),
        197 => (60, 2, 793, 766, 815, 3121, 70, 50, 80, 70, 70, 15),
        198 => (60, 2, 798, 770, 820, 3134, 70, 50, 80, 70, 70, 15),
        199 => (60, 2, 802, 775, 825, 3147, 70, 50, 80, 70, 70, 15),
        200 => (60, 2, 806, 779, 830, 3160, 70, 50, 80, 70, 70, 15),
        201 => (60, 2, 811, 783, 835, 3174, 70, 50, 80, 70, 70, 15),
        202 => (60, 2, 815, 787, 840, 3188, 70, 50, 80, 70, 70, 15),
        203 => (60, 2, 820, 791, 845, 3202, 70, 50, 80, 70, 70, 15),
        204 => (60, 2, 824, 795, 850, 3216, 70, 50, 80, 70, 70, 15),
        205 => (60, 2, 828, 800, 855, 3230, 70, 50, 80, 70, 70, 15),
        206 => (60, 2, 833, 804, 860, 3244, 70, 50, 80, 70, 70, 15),
        207 => (60, 2, 837, 808, 865, 3258, 70, 50, 80, 70, 70, 15),
        208 => (60, 2, 842, 812, 870, 3272, 70, 50, 80, 70, 70, 15),
        209 => (60, 2, 846, 816, 875, 3286, 70, 50, 80, 70, 70, 15),
        210 => (60, 3, 850, 820, 880, 3300, 70, 50, 80, 70, 70, 15),
        211 => (60, 3, 852, 822, 882, 3309, 70, 50, 80, 70, 70, 15),
        212 => (60, 3, 854, 823, 884, 3318, 70, 50, 80, 70, 70, 15),
        213 => (60, 3, 856, 825, 886, 3327, 70, 50, 80, 70, 70, 15),
        214 => (60, 3, 858, 826, 888, 3336, 70, 50, 80, 70, 70, 15),
        215 => (60, 3, 860, 828, 890, 3345, 70, 50, 80, 70, 70, 15),
        216 => (60, 3, 862, 829, 892, 3354, 70, 50, 80, 70, 70, 15),
        217 => (60, 3, 864, 831, 894, 3363, 70, 50, 80, 70, 70, 15),
        218 => (60, 3, 866, 832, 896, 3372, 70, 50, 80, 70, 70, 15),
        219 => (60, 3, 868, 834, 898, 3381, 70, 50, 80, 70, 70, 15),
        220 => (60, 3, 870, 835, 900, 3390, 70, 50, 80, 70, 70, 15),
        221 => (60, 3, 875, 839, 903, 3403, 70, 50, 80, 70, 70, 15),
        222 => (60, 3, 879, 843, 906, 3416, 70, 50, 80, 70, 70, 15),
        223 => (60, 3, 883, 847, 909, 3429, 70, 50, 80, 70, 70, 15),
        224 => (60, 3, 887, 851, 912, 3442, 70, 50, 80, 70, 70, 15),
        225 => (60, 3, 891, 855, 915, 3455, 70, 50, 80, 70, 70, 15),
        226 => (60, 3, 895, 859, 918, 3468, 70, 50, 80, 70, 70, 15),
        227 => (60, 3, 900, 863, 921, 3481, 70, 50, 80, 70, 70, 15),
        228 => (60, 3, 904, 867, 924, 3494, 70, 50, 80, 70, 70, 15),
        229 => (60, 3, 908, 871, 927, 3507, 70, 50, 80, 70, 70, 15),
        230 => (60, 3, 912, 875, 930, 3520, 70, 50, 80, 70, 70, 15),
        231 => (60, 3, 916, 879, 933, 3534, 70, 50, 80, 70, 70, 15),
        232 => (60, 3, 920, 883, 936, 3548, 70, 50, 80, 70, 70, 15),
        233 => (60, 3, 925, 887, 939, 3562, 70, 50, 80, 70, 70, 15),
        234 => (60, 3, 929, 891, 942, 3576, 70, 50, 80, 70, 70, 15),
        235 => (60, 3, 933, 895, 945, 3590, 70, 50, 80, 70, 70, 15),
        236 => (60, 3, 937, 899, 948, 3604, 70, 50, 80, 70, 70, 15),
        237 => (60, 3, 941, 903, 951, 3618, 70, 50, 80, 70, 70, 15),
        238 => (60, 3, 945, 907, 954, 3632, 70, 50, 80, 70, 70, 15),
        239 => (60, 3, 950, 911, 957, 3646, 70, 50, 80, 70, 70, 15),
        240 => (60, 3, 954, 915, 960, 3660, 70, 50, 80, 70, 70, 15),
        241 => (60, 3, 958, 919, 964, 3674, 70, 50, 80, 70, 70, 15),
        242 => (60, 3, 962, 923, 968, 3688, 70, 50, 80, 70, 70, 15),
        243 => (60, 3, 966, 927, 972, 3702, 70, 50, 80, 70, 70, 15),
        244 => (60, 3, 970, 931, 976, 3716, 70, 50, 80, 70, 70, 15),
        245 => (60, 3, 975, 935, 980, 3730, 70, 50, 80, 70, 70, 15),
        246 => (60, 3, 979, 939, 984, 3744, 70, 50, 80, 70, 70, 15),
        247 => (60, 3, 983, 943, 988, 3758, 70, 50, 80, 70, 70, 15),
        248 => (60, 3, 987, 947, 992, 3772, 70, 50, 80, 70, 70, 15),
        249 => (60, 3, 991, 951, 996, 3786, 70, 50, 80, 70, 70, 15),
        250 => (60, 4, 995, 955, 1000, 3800, 70, 50, 80, 70, 70, 15),
        251 => (60, 4, 998, 958, 1000, 3800, 70, 50, 80, 70, 80, 15),
        252 => (60, 4, 1000, 960, 1000, 3800, 70, 50, 80, 70, 80, 15),
        253 => (60, 4, 1002, 963, 1000, 3800, 70, 50, 80, 70, 80, 15),
        254 => (60, 4, 1004, 965, 1000, 3800, 70, 50, 80, 70, 80, 15),
        255 => (61, 0, 1006, 968, 630, 2790, 81, 58, 100, 100, 80, 15),
        256 => (61, 0, 1008, 970, 635, 2799, 81, 58, 100, 100, 80, 15),
        257 => (61, 0, 1010, 973, 640, 2808, 81, 58, 100, 100, 80, 15),
        258 => (61, 0, 1012, 975, 645, 2817, 81, 58, 100, 100, 80, 15),
        259 => (61, 0, 1014, 978, 650, 2826, 81, 58, 100, 100, 80, 15),
        260 => (61, 0, 1016, 980, 655, 2835, 81, 58, 100, 100, 80, 15),
        261 => (61, 0, 1019, 983, 660, 2844, 81, 58, 100, 100, 80, 15),
        262 => (61, 0, 1021, 985, 665, 2853, 81, 58, 100, 100, 80, 15),
        263 => (61, 0, 1023, 988, 670, 2862, 81, 58, 100, 100, 80, 15),
        264 => (61, 0, 1025, 990, 675, 2871, 81, 58, 100, 100, 80, 15),
        265 => (62, 0, 1027, 993, 680, 2880, 82, 61, 100, 100, 80, 15),
        266 => (62, 0, 1029, 995, 690, 2898, 82, 61, 100, 100, 80, 15),
        267 => (62, 0, 1031, 998, 700, 2916, 82, 61, 100, 100, 80, 15),
        268 => (62, 0, 1033, 1000, 710, 2934, 82, 61, 100, 100, 80, 15),
        269 => (62, 0, 1035, 1003, 720, 2952, 82, 61, 100, 100, 80, 15),
        270 => (63, 0, 1037, 1005, 730, 2970, 83, 64, 100, 100, 80, 15),
        271 => (63, 0, 1040, 1008, 746, 3000, 83, 64, 100, 100, 80, 15),
        272 => (63, 0, 1042, 1010, 763, 3030, 83, 64, 100, 100, 80, 15),
        273 => (64, 0, 1044, 1013, 780, 3060, 84, 65, 100, 100, 80, 15),
        274 => (64, 0, 1046, 1015, 796, 3090, 84, 65, 100, 100, 80, 15),
        275 => (64, 0, 1048, 1018, 813, 3120, 84, 65, 100, 100, 80, 15),
        276 => (65, 0, 1050, 1020, 830, 3150, 85, 66, 100, 100, 80, 15),
        277 => (65, 0, 1052, 1023, 846, 3180, 85, 66, 100, 100, 80, 15),
        278 => (65, 0, 1054, 1025, 863, 3210, 85, 66, 100, 100, 80, 15),
        279 => (66, 0, 1056, 1028, 880, 3240, 86, 66, 100, 100, 80, 15),
        280 => (66, 0, 1058, 1030, 896, 3270, 86, 66, 100, 100, 80, 15),
        281 => (66, 0, 1061, 1033, 913, 3300, 86, 66, 100, 100, 80, 15),
        282 => (67, 0, 1063, 1035, 930, 3330, 87, 68, 100, 100, 80, 15),
        283 => (67, 0, 1065, 1038, 946, 3360, 87, 68, 100, 100, 80, 15),
        284 => (67, 0, 1067, 1040, 963, 3390, 87, 68, 100, 100, 80, 15),
        285 => (68, 0, 1069, 1043, 980, 3420, 88, 68, 100, 100, 80, 15),
        286 => (68, 0, 1071, 1045, 996, 3450, 88, 68, 100, 100, 80, 15),
        287 => (68, 0, 1073, 1048, 1013, 3480, 88, 68, 100, 100, 80, 15),
        288 => (69, 0, 1075, 1050, 1030, 3510, 89, 68, 100, 100, 80, 15),
        289 => (69, 0, 1077, 1053, 1055, 3555, 89, 68, 100, 100, 80, 15),
        290 => (70, 0, 1079, 1055, 1080, 3600, 90, 70, 100, 100, 80, 15),
        291 => (70, 0, 1082, 1058, 1086, 3660, 90, 70, 100, 100, 80, 15),
        292 => (70, 0, 1084, 1060, 1092, 3720, 90, 70, 100, 100, 80, 15),
        293 => (70, 0, 1086, 1063, 1098, 3780, 90, 70, 100, 100, 80, 15),
        294 => (70, 0, 1088, 1065, 1104, 3840, 90, 70, 100, 100, 80, 15),
        295 => (70, 0, 1090, 1068, 1110, 3900, 90, 70, 100, 100, 80, 15),
        296 => (70, 0, 1092, 1070, 1116, 3960, 90, 70, 100, 100, 80, 15),
        297 => (70, 0, 1094, 1073, 1122, 4020, 90, 70, 100, 100, 80, 15),
        298 => (70, 0, 1096, 1075, 1128, 4080, 90, 70, 100, 100, 80, 15),
        299 => (70, 0, 1098, 1078, 1134, 4140, 90, 70, 100, 100, 80, 15),
        300 => (70, 1, 1100, 1080, 1140, 4200, 90, 70, 100, 100, 70, 15),
        301 => (70, 1, 1111, 1087, 1143, 4230, 90, 70, 100, 100, 70, 15),
        302 => (70, 1, 1122, 1094, 1146, 4260, 90, 70, 100, 100, 70, 15),
        303 => (70, 1, 1133, 1101, 1149, 4290, 90, 70, 100, 100, 70, 15),
        304 => (70, 1, 1144, 1108, 1152, 4320, 90, 70, 100, 100, 70, 15),
        305 => (70, 1, 1155, 1115, 1155, 4350, 90, 70, 100, 100, 70, 15),
        306 => (70, 1, 1166, 1122, 1158, 4380, 90, 70, 100, 100, 70, 15),
        307 => (70, 1, 1177, 1129, 1161, 4410, 90, 70, 100, 100, 70, 15),
        308 => (70, 1, 1188, 1136, 1164, 4440, 90, 70, 100, 100, 70, 15),
        309 => (70, 1, 1199, 1143, 1167, 4470, 90, 70, 100, 100, 70, 15),
        310 => (70, 1, 1210, 1150, 1170, 4500, 90, 70, 100, 100, 70, 15),
        311 => (70, 1, 1221, 1157, 1173, 4530, 90, 70, 100, 100, 70, 15),
        312 => (70, 1, 1232, 1164, 1176, 4560, 90, 70, 100, 100, 70, 15),
        313 => (70, 1, 1243, 1171, 1179, 4590, 90, 70, 100, 100, 70, 15),
        314 => (70, 1, 1254, 1178, 1182, 4620, 90, 70, 100, 100, 70, 15),
        315 => (70, 1, 1265, 1185, 1185, 4650, 90, 70, 100, 100, 70, 15),
        316 => (70, 1, 1276, 1192, 1188, 4680, 90, 70, 100, 100, 70, 15),
        317 => (70, 1, 1287, 1199, 1191, 4710, 90, 70, 100, 100, 70, 15),
        318 => (70, 1, 1298, 1206, 1194, 4740, 90, 70, 100, 100, 70, 15),
        319 => (70, 1, 1309, 1213, 1197, 4770, 90, 70, 100, 100, 70, 15),
        320 => (70, 2, 1320, 1220, 1200, 4800, 90, 70, 80, 70, 70, 15),
        321 => (70, 2, 1326, 1224, 1205, 4813, 90, 70, 80, 70, 70, 15),
        322 => (70, 2, 1332, 1229, 1210, 4826, 90, 70, 80, 70, 70, 15),
        323 => (70, 2, 1338, 1233, 1215, 4839, 90, 70, 80, 70, 70, 15),
        324 => (70, 2, 1344, 1237, 1220, 4852, 90, 70, 80, 70, 70, 15),
        325 => (70, 2, 1350, 1242, 1225, 4865, 90, 70, 80, 70, 70, 15),
        326 => (70, 2, 1356, 1246, 1230, 4878, 90, 70, 80, 70, 70, 15),
        327 => (70, 2, 1362, 1250, 1235, 4891, 90, 70, 80, 70, 70, 15),
        328 => (70, 2, 1368, 1255, 1240, 4904, 90, 70, 80, 70, 70, 15),
        329 => (70, 2, 1374, 1259, 1245, 4917, 90, 70, 80, 70, 70, 15),
        330 => (70, 2, 1380, 1263, 1250, 4930, 90, 70, 80, 70, 70, 15),
        331 => (70, 2, 1386, 1268, 1255, 4943, 90, 70, 80, 70, 70, 15),
        332 => (70, 2, 1392, 1272, 1260, 4956, 90, 70, 80, 70, 70, 15),
        333 => (70, 2, 1398, 1276, 1265, 4969, 90, 70, 80, 70, 70, 15),
        334 => (70, 2, 1404, 1281, 1270, 4982, 90, 70, 80, 70, 70, 15),
        335 => (70, 2, 1410, 1285, 1275, 4995, 90, 70, 80, 70, 70, 15),
        336 => (70, 2, 1416, 1289, 1280, 5008, 90, 70, 80, 70, 70, 15),
        337 => (70, 2, 1422, 1294, 1285, 5021, 90, 70, 80, 70, 70, 15),
        338 => (70, 2, 1428, 1298, 1290, 5034, 90, 70, 80, 70, 70, 15),
        339 => (70, 2, 1434, 1302, 1295, 5047, 90, 70, 80, 70, 70, 15),
        340 => (70, 2, 1440, 1307, 1300, 5060, 90, 70, 80, 70, 70, 15),
        341 => (70, 2, 1446, 1311, 1305, 5074, 90, 70, 80, 70, 70, 15),
        342 => (70, 2, 1452, 1315, 1310, 5088, 90, 70, 80, 70, 70, 15),
        343 => (70, 2, 1458, 1320, 1315, 5102, 90, 70, 80, 70, 70, 15),
        344 => (70, 2, 1464, 1324, 1320, 5116, 90, 70, 80, 70, 70, 15),
        345 => (70, 2, 1470, 1328, 1325, 5130, 90, 70, 80, 70, 70, 15),
        346 => (70, 2, 1476, 1333, 1330, 5144, 90, 70, 80, 70, 70, 15),
        347 => (70, 2, 1482, 1337, 1335, 5158, 90, 70, 80, 70, 70, 15),
        348 => (70, 2, 1488, 1341, 1340, 5172, 90, 70, 80, 70, 70, 15),
        349 => (70, 2, 1494, 1346, 1345, 5186, 90, 70, 80, 70, 70, 15),
        350 => (70, 3, 1500, 1350, 1350, 5200, 90, 70, 80, 70, 70, 15),
        351 => (70, 3, 1505, 1358, 1355, 5230, 90, 70, 80, 70, 70, 15),
        352 => (70, 3, 1510, 1366, 1360, 5260, 90, 70, 80, 70, 70, 15),
        353 => (70, 3, 1515, 1374, 1365, 5290, 90, 70, 80, 70, 70, 15),
        354 => (70, 3, 1520, 1383, 1370, 5320, 90, 70, 80, 70, 70, 15),
        355 => (70, 3, 1525, 1391, 1375, 5350, 90, 70, 80, 70, 70, 15),
        356 => (70, 3, 1530, 1399, 1380, 5380, 90, 70, 80, 70, 70, 15),
        357 => (70, 3, 1535, 1408, 1385, 5410, 90, 70, 80, 70, 70, 15),
        358 => (70, 3, 1540, 1416, 1390, 5440, 90, 70, 80, 70, 70, 15),
        359 => (70, 3, 1545, 1424, 1395, 5470, 90, 70, 80, 70, 70, 15),
        360 => (70, 3, 1550, 1433, 1400, 5500, 90, 70, 80, 70, 70, 15),
        361 => (70, 3, 1555, 1441, 1405, 5530, 90, 70, 80, 70, 70, 15),
        362 => (70, 3, 1560, 1449, 1410, 5560, 90, 70, 80, 70, 70, 15),
        363 => (70, 3, 1565, 1458, 1415, 5590, 90, 70, 80, 70, 70, 15),
        364 => (70, 3, 1570, 1466, 1420, 5620, 90, 70, 80, 70, 70, 15),
        365 => (70, 3, 1575, 1474, 1425, 5650, 90, 70, 80, 70, 70, 15),
        366 => (70, 3, 1580, 1483, 1430, 5680, 90, 70, 80, 70, 70, 15),
        367 => (70, 3, 1585, 1491, 1435, 5710, 90, 70, 80, 70, 70, 15),
        368 => (70, 3, 1590, 1499, 1440, 5740, 90, 70, 80, 70, 70, 15),
        369 => (70, 3, 1595, 1508, 1445, 5770, 90, 70, 80, 70, 70, 15),
        370 => (70, 3, 1600, 1516, 1450, 5800, 90, 70, 80, 70, 70, 15),
        371 => (70, 3, 1605, 1524, 1455, 5830, 90, 70, 80, 70, 70, 15),
        372 => (70, 3, 1610, 1533, 1460, 5860, 90, 70, 80, 70, 70, 15),
        373 => (70, 3, 1615, 1541, 1465, 5890, 90, 70, 80, 70, 70, 15),
        374 => (70, 3, 1620, 1549, 1470, 5920, 90, 70, 80, 70, 70, 15),
        375 => (70, 3, 1625, 1558, 1475, 5950, 90, 70, 80, 70, 70, 15),
        376 => (70, 3, 1630, 1566, 1480, 5980, 90, 70, 80, 70, 70, 15),
        377 => (70, 3, 1635, 1574, 1485, 6010, 90, 70, 80, 70, 70, 15),
        378 => (70, 3, 1640, 1583, 1490, 6040, 90, 70, 80, 70, 70, 15),
        379 => (70, 3, 1645, 1592, 1495, 6070, 90, 70, 80, 70, 70, 15),
        380 => (70, 4, 1650, 1600, 1500, 6100, 90, 70, 80, 70, 70, 15),
        381 => (71, 0, 1320, 1220, 1150, 3700, 101, 81, 100, 100, 80, 15),
        382 => (71, 0, 1320, 1220, 1155, 3707, 101, 81, 100, 100, 80, 15),
        383 => (71, 0, 1320, 1220, 1160, 3714, 101, 81, 100, 100, 80, 15),
        384 => (71, 0, 1320, 1220, 1165, 3721, 101, 81, 100, 100, 80, 15),
        385 => (71, 0, 1320, 1220, 1170, 3728, 101, 81, 100, 100, 80, 15),
        386 => (71, 0, 1320, 1220, 1175, 3735, 101, 81, 100, 100, 80, 15),
        387 => (71, 0, 1320, 1220, 1180, 3742, 101, 81, 100, 100, 80, 15),
        388 => (71, 0, 1320, 1220, 1185, 3749, 101, 81, 100, 100, 80, 15),
        389 => (71, 0, 1320, 1220, 1190, 3756, 101, 81, 100, 100, 80, 15),
        390 => (71, 0, 1320, 1220, 1195, 3763, 101, 81, 100, 100, 80, 15),
        391 => (71, 0, 1334, 1233, 1200, 3770, 101, 81, 100, 100, 80, 15),
        392 => (71, 0, 1347, 1246, 1205, 3777, 101, 81, 100, 100, 80, 15),
        393 => (71, 0, 1361, 1258, 1210, 3784, 101, 81, 100, 100, 80, 15),
        394 => (71, 0, 1375, 1271, 1215, 3792, 101, 81, 100, 100, 80, 15),
        395 => (72, 0, 1388, 1284, 1220, 3800, 102, 82, 100, 100, 80, 15),
        396 => (72, 0, 1402, 1297, 1234, 3820, 102, 82, 100, 100, 80, 15),
        397 => (72, 0, 1416, 1310, 1248, 3840, 102, 82, 100, 100, 80, 15),
        398 => (72, 0, 1429, 1323, 1262, 3860, 102, 82, 100, 100, 80, 15),
        399 => (72, 0, 1443, 1335, 1276, 3880, 102, 82, 100, 100, 80, 15),
        400 => (73, 0, 1457, 1348, 1290, 3900, 103, 83, 100, 100, 80, 15),
        401 => (73, 0, 1470, 1361, 1313, 3933, 103, 83, 100, 100, 80, 15),
        402 => (73, 0, 1484, 1374, 1336, 3966, 103, 83, 100, 100, 80, 15),
        403 => (74, 0, 1498, 1387, 1360, 4000, 104, 84, 100, 100, 80, 15),
        404 => (74, 0, 1511, 1400, 1383, 4033, 104, 84, 100, 100, 80, 15),
        405 => (74, 0, 1525, 1412, 1406, 4066, 104, 84, 100, 100, 80, 15),
        406 => (75, 0, 1539, 1425, 1430, 4100, 105, 85, 100, 100, 80, 15),
        407 => (75, 0, 1552, 1438, 1453, 4133, 105, 85, 100, 100, 80, 15),
        408 => (75, 0, 1566, 1451, 1476, 4166, 105, 85, 100, 100, 80, 15),
        409 => (76, 0, 1580, 1464, 1500, 4200, 106, 86, 100, 100, 80, 15),
        410 => (76, 0, 1593, 1477, 1523, 4233, 106, 86, 100, 100, 80, 15),
        411 => (76, 0, 1607, 1489, 1546, 4266, 106, 86, 100, 100, 80, 15),
        412 => (77, 0, 1621, 1502, 1570, 4300, 107, 87, 100, 100, 80, 15),
        413 => (77, 0, 1634, 1515, 1593, 4333, 107, 87, 100, 100, 80, 15),
        414 => (77, 0, 1648, 1528, 1616, 4366, 107, 87, 100, 100, 80, 15),
        415 => (78, 0, 1662, 1541, 1640, 4400, 108, 88, 100, 100, 80, 15),
        416 => (78, 0, 1675, 1554, 1663, 4433, 108, 88, 100, 100, 80, 15),
        417 => (78, 0, 1689, 1566, 1686, 4466, 108, 88, 100, 100, 80, 15),
        418 => (79, 0, 1702, 1579, 1710, 4500, 109, 89, 100, 100, 80, 15),
        419 => (79, 0, 1716, 1592, 1715, 4508, 109, 89, 100, 100, 80, 15),
        420 => (79, 0, 1730, 1605, 1720, 4516, 109, 89, 100, 100, 80, 15),
        421 => (79, 0, 1743, 1618, 1726, 4524, 109, 89, 100, 100, 80, 15),
        422 => (79, 0, 1757, 1631, 1732, 4532, 109, 89, 100, 100, 80, 15),
        423 => (79, 0, 1771, 1643, 1738, 4540, 109, 89, 100, 100, 80, 15),
        424 => (79, 0, 1784, 1656, 1744, 4548, 109, 89, 100, 100, 80, 15),
        425 => (79, 0, 1798, 1669, 1750, 4556, 109, 89, 100, 100, 80, 15),
        426 => (79, 0, 1812, 1682, 1756, 4564, 109, 89, 100, 100, 80, 15),
        427 => (79, 0, 1825, 1695, 1762, 4573, 109, 89, 100, 100, 80, 15),
        428 => (79, 0, 1839, 1708, 1768, 4582, 109, 89, 100, 100, 80, 15),
        429 => (79, 0, 1853, 1720, 1774, 4591, 109, 89, 100, 100, 80, 15),
        430 => (80, 0, 1866, 1733, 1780, 4600, 110, 90, 100, 100, 80, 15),
        431 => (80, 0, 1880, 1746, 1792, 4614, 110, 90, 100, 100, 70, 15),
        432 => (80, 0, 1894, 1759, 1804, 4628, 110, 90, 100, 100, 70, 15),
        433 => (80, 0, 1907, 1772, 1816, 4642, 110, 90, 100, 100, 70, 15),
        434 => (80, 0, 1921, 1785, 1828, 4656, 110, 90, 100, 100, 70, 15),
        435 => (80, 0, 1935, 1797, 1840, 4670, 110, 90, 100, 100, 70, 15),
        436 => (80, 0, 1948, 1810, 1852, 4684, 110, 90, 100, 100, 70, 15),
        437 => (80, 0, 1962, 1823, 1864, 4698, 110, 90, 100, 100, 70, 15),
        438 => (80, 0, 1976, 1836, 1876, 4712, 110, 90, 100, 100, 70, 15),
        439 => (80, 0, 1989, 1849, 1888, 4726, 110, 90, 100, 100, 70, 15),
        440 => (80, 1, 2000, 1860, 1900, 6000, 110, 90, 100, 100, 70, 15),
        441 => (80, 1, 2017, 1874, 1915, 6190, 110, 90, 100, 100, 70, 15),
        442 => (80, 1, 2030, 1887, 1930, 6380, 110, 90, 100, 100, 70, 15),
        443 => (80, 1, 2044, 1900, 1945, 6570, 110, 90, 100, 100, 70, 15),
        444 => (80, 1, 2058, 1913, 1960, 6760, 110, 90, 100, 100, 70, 15),
        445 => (80, 1, 2071, 1926, 1975, 6950, 110, 90, 100, 100, 70, 15),
        446 => (80, 1, 2085, 1938, 1990, 7140, 110, 90, 100, 100, 70, 15),
        447 => (80, 1, 2099, 1951, 2005, 7330, 110, 90, 100, 100, 70, 15),
        448 => (80, 1, 2112, 1964, 2020, 7520, 110, 90, 100, 100, 70, 15),
        449 => (80, 1, 2126, 1977, 2035, 7710, 110, 90, 100, 100, 70, 15),
        450 => (80, 2, 2140, 1990, 2050, 7900, 110, 90, 80, 70, 70, 15),
        451 => (80, 2, 2151, 1996, 2075, 7920, 110, 90, 80, 70, 70, 15),
        452 => (80, 2, 2162, 2002, 2100, 7940, 110, 90, 80, 70, 70, 15),
        453 => (80, 2, 2173, 2008, 2125, 7960, 110, 90, 80, 70, 70, 15),
        454 => (80, 2, 2184, 2014, 2150, 7980, 110, 90, 80, 70, 70, 15),
        455 => (80, 2, 2195, 2020, 2175, 8000, 110, 90, 80, 70, 70, 15),
        456 => (80, 2, 2206, 2027, 2200, 8020, 110, 90, 80, 70, 70, 15),
        457 => (80, 2, 2217, 2034, 2225, 8040, 110, 90, 80, 70, 70, 15),
        458 => (80, 2, 2228, 2041, 2250, 8060, 110, 90, 80, 70, 70, 15),
        459 => (80, 2, 2239, 2048, 2275, 8080, 110, 90, 80, 70, 70, 15),
        460 => (80, 2, 2250, 2055, 2300, 8100, 110, 90, 80, 70, 70, 15),
        461 => (80, 2, 2261, 2062, 2325, 8120, 110, 90, 80, 70, 70, 15),
        462 => (80, 2, 2272, 2069, 2350, 8140, 110, 90, 80, 70, 70, 15),
        463 => (80, 2, 2283, 2076, 2375, 8160, 110, 90, 80, 70, 70, 15),
        464 => (80, 2, 2294, 2083, 2400, 8180, 110, 90, 80, 70, 70, 15),
        465 => (80, 2, 2305, 2090, 2425, 8200, 110, 90, 80, 70, 70, 15),
        466 => (80, 2, 2316, 2097, 2450, 8220, 110, 90, 80, 70, 70, 15),
        467 => (80, 2, 2327, 2104, 2475, 8240, 110, 90, 80, 70, 70, 15),
        468 => (80, 2, 2338, 2111, 2500, 8260, 110, 90, 80, 70, 70, 15),
        469 => (80, 2, 2349, 2118, 2525, 8280, 110, 90, 80, 70, 70, 15),
        470 => (80, 2, 2360, 2125, 2550, 8300, 110, 90, 80, 70, 70, 15),
        471 => (80, 2, 2372, 2132, 2575, 8320, 140, 90, 100, 100, 70, 15),
        472 => (80, 2, 2384, 2139, 2600, 8340, 110, 90, 80, 70, 70, 15),
        473 => (80, 2, 2396, 2146, 2625, 8360, 110, 90, 80, 70, 70, 15),
        474 => (80, 2, 2408, 2153, 2650, 8380, 110, 90, 80, 70, 70, 15),
        475 => (80, 2, 2420, 2160, 2675, 8400, 110, 90, 80, 70, 70, 15),
        476 => (80, 2, 2432, 2167, 2700, 8420, 110, 90, 80, 70, 70, 15),
        477 => (80, 2, 2444, 2174, 2725, 8440, 110, 90, 80, 70, 70, 15),
        478 => (80, 2, 2456, 2181, 2750, 8460, 110, 90, 80, 70, 70, 15),
        479 => (80, 2, 2468, 2188, 2775, 8480, 110, 90, 80, 70, 70, 15),
        480 => (80, 3, 2480, 2195, 2800, 8500, 110, 90, 80, 70, 70, 15),
        481 => (80, 3, 2484, 2206, 3856, 12323, 140, 130, 100, 100, 70, 115),
        482 => (80, 3, 2488, 2217, 2852, 8566, 110, 90, 80, 70, 70, 15),
        483 => (80, 3, 2492, 2228, 2878, 8599, 110, 90, 80, 70, 70, 15),
        484 => (80, 3, 2496, 2239, 2904, 8632, 110, 90, 80, 70, 70, 15),
        485 => (80, 3, 2500, 2250, 2930, 8665, 110, 90, 80, 70, 70, 15),
        486 => (80, 3, 2504, 2261, 2956, 8698, 110, 90, 80, 70, 70, 15),
        487 => (80, 3, 2508, 2272, 2982, 8731, 110, 90, 80, 70, 70, 15),
        488 => (80, 3, 2512, 2283, 3008, 8764, 110, 90, 80, 70, 70, 15),
        489 => (80, 3, 2516, 2294, 3034, 8797, 110, 90, 80, 70, 70, 15),
        490 => (80, 3, 2520, 2305, 3060, 8830, 110, 90, 80, 70, 70, 15),
        491 => (80, 3, 2525, 2316, 3087, 8863, 110, 90, 80, 70, 70, 15),
        492 => (80, 3, 2530, 2327, 3114, 8896, 110, 90, 80, 70, 70, 15),
        493 => (80, 3, 2535, 2338, 3141, 8929, 110, 90, 80, 70, 70, 15),
        494 => (80, 3, 2540, 2349, 3168, 8962, 110, 90, 80, 70, 70, 15),
        495 => (80, 3, 2545, 2360, 3195, 8995, 110, 90, 80, 70, 70, 15),
        496 => (80, 3, 2550, 2372, 3222, 9028, 110, 90, 80, 70, 70, 15),
        497 => (80, 3, 2555, 2384, 3249, 9061, 110, 90, 80, 70, 70, 15),
        498 => (80, 3, 2560, 2396, 3276, 9094, 110, 90, 80, 70, 70, 15),
        499 => (80, 3, 2565, 2408, 3303, 9127, 110, 90, 80, 70, 70, 15),
        500 => (80, 3, 2570, 2420, 3330, 9160, 110, 90, 80, 70, 70, 15),
        501 => (80, 3, 2575, 2432, 3357, 9194, 110, 90, 80, 70, 70, 15),
        502 => (80, 3, 2580, 2444, 3384, 9228, 110, 90, 80, 70, 70, 15),
        503 => (80, 3, 2585, 2456, 3411, 9262, 110, 90, 80, 70, 70, 15),
        504 => (80, 3, 2590, 2468, 3438, 9296, 110, 90, 80, 70, 70, 15),
        505 => (80, 3, 2595, 2480, 3465, 9330, 110, 90, 80, 70, 70, 15),
        506 => (80, 3, 2600, 2492, 3492, 9364, 110, 90, 80, 70, 70, 15),
        507 => (80, 3, 2605, 2504, 3519, 9398, 110, 90, 80, 70, 70, 15),
        508 => (80, 3, 2610, 2516, 3546, 9432, 110, 90, 80, 70, 70, 15),
        509 => (80, 3, 2615, 2528, 3573, 9466, 110, 90, 80, 70, 70, 15),
        510 => (80, 4, 2620, 2540, 3600, 9500, 110, 90, 80, 70, 70, 15),
        511 => (80, 4, 2620, 2540, 4672, 15656, 140, 130, 100, 100, 70, 115),
        512 => (80, 4, 2620, 2540, 4220, 14618, 140, 130, 100, 100, 70, 115),
        513 => (80, 4, 2620, 2540, 5059, 15474, 140, 130, 100, 100, 70, 483),
        514 => (80, 4, 2620, 2540, 5077, 14321, 140, 130, 100, 100, 70, 115),
        515 => (80, 4, 2620, 2540, 5095, 14854, 140, 130, 100, 100, 70, 483),
        516 => (80, 5, 2620, 2540, 5470, 16156, 140, 130, 100, 100, 70, 499),
        517 => (81, 0, 2234, 2136, 2000, 5200, 121, 105, 100, 100, 80, 15),
        518 => (81, 0, 2234, 2136, 2100, 5300, 121, 105, 100, 100, 80, 15),
        519 => (81, 0, 2234, 2136, 2200, 5500, 121, 105, 100, 100, 80, 15),
        520 => (82, 0, 2336, 2238, 2300, 5700, 122, 106, 100, 100, 80, 15),
        521 => (82, 0, 2336, 2238, 2350, 5800, 122, 106, 100, 100, 80, 15),
        522 => (82, 0, 2336, 2238, 2400, 5900, 122, 106, 100, 100, 80, 15),
        523 => (82, 0, 2336, 2238, 2450, 6000, 122, 106, 100, 100, 80, 15),
        524 => (82, 0, 2336, 2238, 2500, 6100, 122, 106, 100, 100, 80, 15),
        525 => (83, 0, 2438, 2340, 2600, 6200, 123, 107, 100, 100, 80, 15),
        526 => (83, 0, 2438, 2340, 2660, 6280, 123, 107, 100, 100, 80, 15),
        527 => (83, 0, 2438, 2340, 2720, 6360, 123, 107, 100, 100, 80, 15),
        528 => (83, 0, 2438, 2340, 2780, 6440, 123, 107, 100, 100, 80, 15),
        529 => (83, 0, 2438, 2340, 2840, 6520, 123, 107, 100, 100, 80, 15),
        530 => (84, 0, 2507, 2388, 2900, 6600, 124, 108, 100, 100, 80, 15),
        531 => (84, 0, 2507, 2388, 2920, 6620, 124, 108, 100, 100, 80, 15),
        532 => (84, 0, 2507, 2388, 2940, 6640, 124, 108, 100, 100, 80, 15),
        533 => (84, 0, 2507, 2388, 2960, 6660, 124, 108, 100, 100, 80, 15),
        534 => (84, 0, 2507, 2388, 2980, 6680, 124, 108, 100, 100, 80, 15),
        535 => (85, 0, 2549, 2418, 3000, 6700, 125, 109, 100, 100, 80, 15),
        536 => (85, 0, 2549, 2418, 3020, 6720, 125, 109, 100, 100, 80, 15),
        537 => (85, 0, 2549, 2418, 3040, 6740, 125, 109, 100, 100, 80, 15),
        538 => (85, 0, 2549, 2418, 3060, 6760, 125, 109, 100, 100, 80, 15),
        539 => (85, 0, 2549, 2418, 3080, 6780, 125, 109, 100, 100, 80, 15),
        540 => (86, 0, 2590, 2451, 3100, 6800, 126, 110, 100, 100, 80, 15),
        541 => (86, 0, 2590, 2451, 3120, 6820, 126, 110, 100, 100, 80, 15),
        542 => (86, 0, 2590, 2451, 3140, 6840, 126, 110, 100, 100, 80, 15),
        543 => (86, 0, 2590, 2451, 3160, 6860, 126, 110, 100, 100, 80, 15),
        544 => (86, 0, 2590, 2451, 3180, 6880, 126, 110, 100, 100, 80, 15),
        545 => (87, 0, 2626, 2482, 3200, 6900, 127, 111, 100, 100, 80, 15),
        546 => (87, 0, 2626, 2482, 3220, 6920, 127, 111, 100, 100, 80, 15),
        547 => (87, 0, 2626, 2482, 3240, 6940, 127, 111, 100, 100, 80, 15),
        548 => (87, 0, 2626, 2482, 3260, 6960, 127, 111, 100, 100, 80, 15),
        549 => (87, 0, 2626, 2482, 3280, 6980, 127, 111, 100, 100, 80, 15),
        550 => (88, 0, 2686, 2535, 3300, 7000, 128, 112, 100, 100, 80, 15),
        551 => (88, 0, 2686, 2535, 3320, 7020, 128, 112, 100, 100, 80, 15),
        552 => (88, 0, 2686, 2535, 3340, 7040, 128, 112, 100, 100, 80, 15),
        553 => (88, 0, 2686, 2535, 3360, 7060, 128, 112, 100, 100, 80, 15),
        554 => (88, 0, 2686, 2535, 3380, 7080, 128, 112, 100, 100, 80, 15),
        555 => (89, 0, 2748, 2589, 3400, 7100, 129, 113, 100, 100, 80, 15),
        556 => (89, 0, 2748, 2589, 3420, 7120, 129, 113, 100, 100, 80, 15),
        557 => (89, 0, 2748, 2589, 3440, 7140, 129, 113, 100, 100, 80, 15),
        558 => (89, 0, 2748, 2589, 3460, 7160, 129, 113, 100, 100, 80, 15),
        559 => (89, 0, 2748, 2589, 3480, 7180, 129, 113, 100, 100, 80, 15),
        560 => (90, 0, 2805, 2635, 3500, 7200, 130, 115, 90, 80, 80, 15),
        561 => (90, 0, 2805, 2635, 3520, 7220, 130, 115, 90, 80, 80, 15),
        562 => (90, 0, 2805, 2635, 3540, 7240, 130, 115, 90, 80, 80, 15),
        563 => (90, 0, 2805, 2635, 3560, 7260, 130, 115, 90, 80, 80, 15),
        564 => (90, 0, 2805, 2635, 3580, 7280, 130, 115, 90, 80, 80, 15),
        565 => (90, 0, 2805, 2635, 3600, 7300, 130, 115, 90, 80, 80, 15),
        566 => (90, 0, 2805, 2635, 3620, 7320, 130, 115, 90, 80, 80, 15),
        567 => (90, 0, 2805, 2635, 3640, 7340, 130, 115, 90, 80, 80, 15),
        568 => (90, 0, 2805, 2635, 3660, 7360, 130, 115, 90, 80, 80, 15),
        569 => (90, 0, 2805, 2635, 3680, 7380, 130, 115, 90, 80, 80, 15),
        570 => (90, 1, 2924, 2703, 3700, 7400, 130, 115, 90, 80, 80, 15),
        571 => (90, 1, 2924, 2703, 3720, 7440, 130, 115, 90, 80, 80, 15),
        572 => (90, 1, 2924, 2703, 3740, 7480, 130, 115, 90, 80, 80, 15),
        573 => (90, 1, 2924, 2703, 3760, 7520, 130, 115, 90, 80, 80, 15),
        574 => (90, 1, 2924, 2703, 3780, 7560, 130, 115, 90, 80, 80, 15),
        575 => (90, 1, 2924, 2703, 3800, 7600, 130, 115, 90, 80, 80, 15),
        576 => (90, 1, 2924, 2703, 3820, 7640, 130, 115, 90, 80, 80, 15),
        577 => (90, 1, 2924, 2703, 3840, 7680, 130, 115, 90, 80, 80, 15),
        578 => (90, 1, 2924, 2703, 3860, 7720, 130, 115, 90, 80, 80, 15),
        579 => (90, 1, 2924, 2703, 3880, 7760, 130, 115, 90, 80, 80, 15),
        580 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        581 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        582 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        583 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        584 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        585 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        586 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        587 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        588 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        589 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        590 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        591 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        592 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        593 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        594 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        595 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        596 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        597 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        598 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        599 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        600 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        601 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        602 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        603 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        604 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        605 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        606 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        607 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        608 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        609 => (90, 2, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        610 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        611 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        612 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        613 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        614 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        615 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        616 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        617 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        618 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        619 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        620 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        621 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        622 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        623 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        624 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        625 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        626 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        627 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        628 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        629 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        630 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        631 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        632 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        633 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        634 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        635 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        636 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        637 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        638 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        639 => (90, 3, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        640 => (90, 4, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        641 => (90, 4, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        642 => (90, 4, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        643 => (90, 4, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        644 => (90, 4, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        645 => (90, 4, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        646 => (90, 4, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        647 => (90, 4, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        648 => (90, 4, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        649 => (90, 4, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        650 => (90, 4, 2924, 2703, 3900, 7800, 130, 115, 80, 70, 70, 15),
        _ => (0, 0, 10000, 10000, 100, 100, 50, 30, 100, 100, 100, 15),
    };
    RecipeLevel {
        class_job_level: a.0,
        stars: a.1,
        suggested_craftsmanship: a.2,
        suggested_control: a.3,
        difficulty: a.4,
        quality: a.5,
        progress_divider: a.6,
        quality_divider: a.7,
        progress_modifier: a.8,
        quality_modifier: a.9,
        durability: a.10,
        conditions_flag: a.11,
    }
}

pub fn level_table(level: u8) -> i32 {
    match level {
        x if x <= 50 => x as i32,
        51 => 120,
        52 => 125,
        53 => 130,
        54 => 133,
        55 => 136,
        56 => 139,
        57 => 142,
        58 => 145,
        59 => 148,
        60 => 150,
        61 => 260,
        62 => 265,
        63 => 270,
        64 => 273,
        65 => 276,
        66 => 279,
        67 => 282,
        68 => 285,
        69 => 288,
        70 => 290,
        71 => 390,
        72 => 395,
        73 => 400,
        74 => 403,
        75 => 406,
        76 => 409,
        77 => 412,
        78 => 415,
        79 => 418,
        80 => 420,
        81 => 517,
        82 => 520,
        83 => 525,
        84 => 530,
        85 => 535,
        86 => 540,
        87 => 545,
        88 => 550,
        89 => 555,
        90 => 560,
        x => unreachable!("Player level cannot be {}", x),
    }
}

pub fn action_table(id: i32) -> Option<Skills> {
    Some(match id {
        // 244 | 245 | 246 | 247 | 248 | 249 | 250 | 251 => , //  稳手
        // 252 | 253 | 254 | 255 | 256 | 257 | 258 | 259 => , //  内静
        260 | 261 | 262 | 263 | 264 | 265 | 266 | 267 => Skills::GreatStrides, //  阔步
        // 276 => , //  松弛
        // 277 | 4623 | 4624 | 4625 | 4626 | 4627 | 4628 | 4629 | 4630 => , //  新颖
        278 | 4574 | 4575 | 4576 | 4577 | 4578 | 4579 | 4580 | 4581 => Skills::Manipulation, //  掌握
        279 | 4631 | 4632 | 4633 | 4634 | 4635 | 4636 | 4637 | 4638 => Skills::WasteNot, //  俭约
        // 281 | 4607 | 4608 | 4609 | 4610 | 4611 | 4612 | 4613 | 4614 => , //  稳手II
        // 283 => , //  新颖II
        284 | 19004 | 19005 | 19006 | 19007 | 19008 | 19009 | 19010 | 19011 => Skills::Innovation, //  改革
        // 285 => , //  俭约II
        // 286 => , //  安逸
        // 287 => , //  回收
        // 4560 | 4561 | 4562 | 4563 | 4564 | 4565 | 4566 | 4567 => , //  收藏品制作
        // 4568 => , //  风之美名
        // 4570 => , //  冰之美名
        // 4571 => , //  土之美名
        // 4572 => , //  雷之美名
        // 4569 => , //  火之美名
        // 4573 => , //  水之美名
        // 4597 | 4598 | 4599 | 4600 | 4601 | 4602 | 4603 | 4604 => , //  再利用
        // 4615 | 4616 | 4617 | 4618 | 4619 | 4620 | 4621 | 4622 => , //  元素之美名
        4639 | 4640 | 4641 | 4642 | 4643 | 4644 | 19002 | 19003 => Skills::WasteNotII, //  长期俭约
        19012 | 19013 | 19014 | 19015 | 19016 | 19017 | 19018 | 19019 => Skills::FinalAppraisal, //  最终确认
        19297 | 19298 | 19299 | 19300 | 19301 | 19302 | 19303 | 19304 => Skills::Veneration, //  崇敬
        100001 | 100015 | 100030 | 100045 | 100060 | 100075 | 100090 | 100105 => {
            Skills::BasicSynthesis
        } //  制作
        100002 | 100016 | 100031 | 100046 | 100061 | 100076 | 100091 | 100106 => Skills::BasicTouch, //  加工
        100003 | 100017 | 100032 | 100047 | 100062 | 100077 | 100092 | 100107 => {
            Skills::MastersMend
        } //  精修
        100004 | 100018 | 100034 | 100048 | 100064 | 100078 | 100093 | 100109 => {
            Skills::StandardTouch
        } //  中级加工
        // 100005 | 100019 | 100035 | 100049 | 100065 | 100079 | 100094 | 100110 => , //  精修II
        // 100006 => , //  风之印记
        // 100007 | 100021 | 100037 | 100051 | 100067 | 100080 | 100096 | 100111 => , //  中级制作
        // 100008 | 100022 | 100038 | 100052 | 100068 | 100081 | 100097 | 100112 | // 上级加工（旧）
        100411 | 100412 | 100413 | 100414 | 100415 | 100416 | 100417 | 100418 => {
            Skills::AdvancedTouch
        } //  上级加工
        100009 | 100339 | 100340 | 100341 | 100342 | 100343 | 100344 | 100345 | 100346 => {
            Skills::ByregotsBlessing
        } //  比尔格的祝福
        100010 | 100023 | 100040 | 100053 | 100070 | 100082 | 100099 | 100113 => Skills::Observe, //  观察
        // 100020 => , //  火之印记
        100033 | 100363 | 100364 | 100365 | 100366 | 100367 | 100368 | 100369 | 100370 => {
            Skills::RapidSynthesis
        } //  高速制作
        // 100036 => , //  冰之印记
        // 100039 => , //  渐进
        // 100050 => , //  土之印记
        100063 | 100203 | 100204 | 100205 | 100206 | 100207 | 100208 | 100209 | 100210 => {
            Skills::CarefulSynthesis
        } //  模范制作
        // 100066 => , //  雷之印记
        // 100069 => , //  模范制作II
        // 100083 => , //  坚实制作
        // 100095 => , //  水之印记
        100098 | 100371 | 100372 | 100373 | 100374 | 100375 | 100376 | 100377 | 100378 => {
            Skills::TricksOfTheTrade
        } //  秘诀
        100108 | 100355 | 100356 | 100357 | 100358 | 100359 | 100360 | 100361 | 100362 => {
            Skills::HastyTouch
        } //  仓促
        // 100120 | 100121 | 100122 | 100123 | 100124 | 100125 | 100126 | 100127 => , //  比尔格的技巧
        100128 | 100129 | 100130 | 100131 | 100132 | 100133 | 100134 | 100135 => {
            Skills::PreciseTouch
        } //  集中加工
        100136 | 100379 | 100380 | 100381 | 100382 | 100383 | 100384 | 100385 | 100386 => {
            Skills::MuscleMemory
        } //  坚信
        // 100137 | 100138 | 100139 | 100140 | 100141 | 100142 | 100143 | 100144 => , //  革新
        // 100145 | 100146 | 100147 | 100148 | 100149 | 100150 | 100151 | 100152 => , //  比尔格的奇迹
        // 100153 | 100154 | 100155 | 100156 | 100157 | 100158 | 100159 | 100160 => , //  妮美雅的纺车
        // 100161 | 100162 | 100163 | 100164 | 100165 | 100166 | 100167 | 100168 => , //  匠心独具
        // 100169 | 100170 | 100171 | 100172 | 100173 | 100174 | 100175 | 100176 => , //  称心
        // 100177 => , //  收尾
        // 100178 => , //  坚实的心得
        // 100179 => , //  刻木匠之魂
        // 100180 => , //  锻铁匠之魂
        // 100181 => , //  铸甲匠之魂
        // 100182 => , //  雕金匠之魂
        // 100183 => , //  制革匠之魂
        // 100184 => , //  裁衣匠之魂
        // 100185 => , //  炼金术士之魂
        // 100186 => , //  烹调师之魂
        // 100187 | 100188 | 100189 | 100190 | 100191 | 100192 | 100193 | 100194 => , //  工作小调
        // 100195 | 100196 | 100197 | 100198 | 100199 | 100200 | 100201 | 100202 => , //  仓促II
        // 100211 | 100212 | 100213 | 100214 | 100215 | 100216 | 100217 | 100218 => , //  高速制作II
        // 100219 | 100220 | 100221 | 100222 | 100223 | 100224 | 100225 | 100226 => , //  专心加工
        100227 | 100228 | 100229 | 100230 | 100231 | 100232 | 100233 | 100234 => {
            Skills::PrudentTouch
        } //  俭约加工
        100235 | 100236 | 100237 | 100238 | 100239 | 100240 | 100241 | 100242 => {
            Skills::FocusedSynthesis
        } //  注视制作
        100243 | 100244 | 100245 | 100246 | 100247 | 100248 | 100249 | 100250 => {
            Skills::FocusedTouch
        } //  注视加工
        // 100251 | 100252 | 100253 | 100254 | 100255 | 100256 | 100257 | 100258 => , //  起始准备
        // 100259 | 100260 | 100261 | 100262 | 100263 | 100264 | 100265 | 100266 => , //  专精绝技：巩固
        // 100267 | 100268 | 100269 | 100270 | 100271 | 100272 | 100273 | 100274 => , //  专精绝技：安稳
        // 100275 | 100276 | 100277 | 100278 | 100279 | 100280 | 100281 | 100282 => , //  专精绝技：闲静
        100283 | 100284 | 100285 | 100286 | 100287 | 100288 | 100289 | 100290 => Skills::TrainedEye, //  工匠的神速技巧
        // 100291 | 100292 | 100293 | 100294 | 100295 | 100296 | 100297 | 100298 => , //  工匠的苦行
        100299 | 100300 | 100301 | 100302 | 100303 | 100304 | 100305 | 100306 => {
            Skills::PreparatoryTouch
        } //  坯料加工
        // 100307 | 100308 | 100309 | 100310 | 100311 | 100312 | 100313 | 100314 => , //  高速制作III
        100315 | 100316 | 100317 | 100318 | 100319 | 100320 | 100321 | 100322 => {
            Skills::IntensiveSynthesis
        } //  集中制作
        100323 | 100324 | 100325 | 100326 | 100327 | 100328 | 100329 | 100330 => {
            Skills::DelicateSynthesis
        } //  精密制作
        // 100331 | 100332 | 100333 | 100334 | 100335 | 100336 | 100337 | 100338 => , //  元素之印记
        100387 | 100388 | 100389 | 100390 | 100391 | 100392 | 100393 | 100394 => Skills::Reflect, //  闲静
        100395 | 100396 | 100397 | 100398 | 100399 | 100400 | 100401 | 100402 => {
            Skills::CarefulObservation
        } //  设计变动
        100403 | 100404 | 100405 | 100406 | 100407 | 100408 | 100409 | 100410 => Skills::Groundwork, //  坯料制作
        100419 | 100420 | 100421 | 100422 | 100423 | 100424 | 100425 | 100426 => {
            Skills::HeartAndSoul
        } //  专心致志
        100427 | 100428 | 100429 | 100430 | 100431 | 100432 | 100433 | 100434 => {
            Skills::PrudentSynthesis
        } //  俭约制作
        100435 | 100436 | 100437 | 100438 | 100439 | 100440 | 100441 | 100442 => {
            Skills::TrainedFinesse
        } //  工匠的神技
        _ => return None,
    })
}

pub fn high_quality_table(percent: u32) -> Option<i32> {
    match percent {
        0 => Some(1),
        5 => Some(2),
        9 => Some(3),
        13 => Some(4),
        17 => Some(5),
        21 => Some(6),
        25 => Some(7),
        29 => Some(8),
        32 => Some(9),
        35 => Some(10),
        38 => Some(11),
        41 => Some(12),
        44 => Some(13),
        47 => Some(14),
        50 => Some(15),
        53 => Some(16),
        55 => Some(17),
        58 => Some(18),
        61 => Some(19),
        63 => Some(20),
        65 => Some(21),
        66 => Some(22),
        67 => Some(23),
        68 => Some(24),
        69 => Some(26),
        70 => Some(28),
        71 => Some(31),
        72 => Some(34),
        73 => Some(38),
        74 => Some(42),
        75 => Some(47),
        76 => Some(52),
        77 => Some(58),
        78 => Some(64),
        79 => Some(68),
        80 => Some(71),
        81 => Some(74),
        82 => Some(76),
        83 => Some(78),
        84 => Some(80),
        85 => Some(81),
        86 => Some(82),
        87 => Some(83),
        88 => Some(84),
        89 => Some(85),
        90 => Some(86),
        91 => Some(87),
        92 => Some(88),
        93 => Some(89),
        94 => Some(90),
        95 => Some(91),
        96 => Some(92),
        97 => Some(94),
        98 => Some(96),
        99 => Some(98),
        100 => Some(100),
        _ => None,
    }
}
