# Changelog

<a name="x.y.z-dev" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version x.y.z-dev

### Changed
- ⬆️  Bump libc from 0.2.119 to 0.2.121
- ⬆️  Bump actions/cache from 2 to 3
- ⬆️  Bump actions/checkout from 2.4.0 to 3

### Fixed
- 🐛  preserve the original source definition when test-samples

### Miscellaneous
- pencil  update README
- 🚧  (cargo-release) start next development iteration 2.5.1-dev

<a name="2.5.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.5.0

### Changed
- ⬆️  upgrade  cargo.lock
- 💄  show &quot;blank&quot;  for diff on `test-samples`
- 💄  accept more syntax for boolean variable from cli
- 💄  allow to use label or value of item of `select_in_values` as `default_value`
- 💄  use color to prompt
- ⬆️  Bump git2 from 0.13 to 0.14

### Removed
- 🔥  clean up makefile

### Fixed
- 🐛  for `ignores` value, ignore some blank caractere that could be introduced by yaml or handlebars syntax

### Miscellaneous
- 🚀  (cargo-release) version 2.5.0
- poop  add workaround for a bug in git2 0.14
- 🔊  add logs debug
- 🚧  (cargo-release) start next development iteration 2.4.5-dev

<a name="2.4.4" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.4.4

### Removed
- 🔥  remove task for github-upload and snapcraft push

### Miscellaneous
- 🚀  (cargo-release) version 2.4.4

<a name="2.4.4-dev" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.4.4-dev

<a name="2.4.3" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.4.3

### Changed
- ⬆️  Bump libc from 0.2.112 to 0.2.119
- ⬆️  Bump pretty_assertions from 1.0.0 to 1.1.0
- ⬆️  Bump clap from 3.1.1 to 3.1.2
- ⬆️  Bump tracing-subscriber from 0.3.5 to 0.3.9
- ⬆️  Bump tracing from 0.1.29 to 0.1.31
- ⬆️  Bump assert_cmd from 2.0.2 to 2.0.4
- ⬆️  Bump dialoguer from 0.9.0 to 0.10.0
- ⬆️  Bump serde from 1.0.133 to 1.0.136

### Miscellaneous
- 🚀  (cargo-release) version 2.4.3
- 🚧  try to build cross-platform from ci/cd  (#491)

<a name="2.4.2" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.4.2

### Added
- ✅  cargo update
- 👷  add cache into workflows

### Changed
- ⬆️  Bump self_update from 0.27.0 to 0.28.0
- ⬆️  Bump predicates from 2.1.0 to 2.1.1
- ⬆️  Bump handlebars from 4.2.0 to 4.2.1
- ⬆️  Bump serde_json from 1.0.74 to 1.0.79
- ⬆️  Bump clap from 3.0.5 to 3.1.1
- ⬆️  switch structopt + clap v2 to clap v3
- ⬆️  bumps dialoguer from 0.8.0 to 0.9.0
- 🚨  apply clippy suggestion
- ⬆️  swith to rust edition 2021
- ⬆️  upgrade tracing-subscriber
- ⬆️  Bump assert_cmd from 2.0.1 to 2.0.2
- ⬆️  Bump libc from 0.2.107 to 0.2.109
- ⬆️  Bump handlebars from 4.1.4 to 4.1.6
- ⬆️  Bump clap from 2.33.3 to 2.34.0
- ⬆️  Bump tracing from 0.1.28 to 0.1.29
- ⬆️  Bump structopt from 0.3.23 to 0.3.25
- ⬆️  Bump actions/checkout from 2.3.5 to 2.4.0
- ⬆️  Bump libc from 0.2.106 to 0.2.107
- ⬆️  Bump handlebars from 4.1.3 to 4.1.4
- ⬆️  Bump console from 0.14.1 to 0.15.0
- ⬆️  Bump serde_json from 1.0.68 to 1.0.69
- ⬆️  Bump schemars from 0.8.3 to 0.8.6
- ⬆️  Bump actions/checkout from 2.3.4 to 2.3.5
- ⬆️  Bump git2 from 0.13.22 to 0.13.23
- ⬆️  Bump pretty_assertions from 0.7.2 to 1.0.0
- ⬆️  Bump libc from 0.2.102 to 0.2.106
- ⬆️  bump directories, patch version and transitive dependencies
- ⬆️  Bump thiserror from 1.0.28 to 1.0.29
- ⬆️  Bump serde_yaml from 0.8.20 to 0.8.21
- ⬆️  Bump git2 from 0.13.21 to 0.13.22
- ⬆️  Bump handlebars from 4.1.2 to 4.1.3
- ⬆️  Bump run_script from 0.8.0 to 0.9.0
- ⬆️  update dependencies
- ⬆️  Bump predicates from 2.0.0 to 2.0.2
- ⬆️  Bump handlebars from 4.1.0 to 4.1.2
- ⬆️  Bump serde_json from 1.0.64 to 1.0.67
- ⬆️  Bump serde from 1.0.126 to 1.0.130
- ⬆️  Bump structopt from 0.3.22 to 0.3.23
- ⬆️  Bump assert_cmd from 1.0.7 to 2.0.0
- ⬆️  Bump predicates from 1.0.8 to 2.0.0

### Fixed
- 🐛  fix bugs and linting

### Miscellaneous
- 🚀  (cargo-release) version 2.4.2
- ⚗  try to build for mac m1 and linux-musl
- 🚧  (cargo-release) start next development iteration 2.4.2-dev

<a name="2.4.1" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.4.1

### Added
- ✅  update and fixe test
- ✨  allow to define select_in_values as an array of `{label, value}` + fix evaluation of select_in_values defined as a string

### Changed
- ⬆️  Bump globset from 0.4.6 to 0.4.7

### Miscellaneous
- 🚀  (cargo-release) version 2.4.1
- 🚧  (cargo-release) start next development iteration 2.4.1-dev
- 🚀  (cargo-release) version 2.4.0
- pencil  simplify installation from brew
- 🔊  enhance SerdeYamlError with context from tracing'Span

<a name="2.4.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.4.0

### Added
- ✅  update and fixe test
- ✨  allow to define select_in_values as an array of `{label, value}` + fix evaluation of select_in_values defined as a string

### Miscellaneous
- 🚀  (cargo-release) version 2.4.0
- pencil  simplify installation from brew
- 🔊  enhance SerdeYamlError with context from tracing'Span
- 🚧  (cargo-release) start next development iteration 2.3.1-dev

<a name="2.3.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.3.0

### Added
- ✅  improve git test to be less sensitive to local git configuration
- ✅  update test for handlebar

### Changed
- 🚨  apply clippy suggestion
- ⬆️  update cargo.lock
- ⬆️  upgrade to handlebars 4.0
- 🔧  define CODEOWNERS
- ⬆️  fix + cargo update
- ⬆️  Bump assert_cmd from 1.0.4 to 1.0.5
- ⬆️  Bump libc from 0.2.94 to 0.2.95
- ⬆️  Bump indicatif from 0.16.0 to 0.16.2
- ⬆️  Bump run_script from 0.7.0 to 0.8.0
- ⬆️  Bump thiserror from 1.0.24 to 1.0.25
- ⬆️  Bump serde from 1.0.125 to 1.0.126
- ⬆️  Bump assert_cmd from 1.0.3 to 1.0.4
- ⬆️  Bump self_update from 0.26.0 to 0.27.0
- ⬆️  Bump predicates from 1.0.7 to 1.0.8
- ⬆️  Bump openssl from 0.10.33 to 0.10.34
- ⬆️  Bump libc from 0.2.93 to 0.2.94
- ⬆️  Bump indicatif from 0.15.0 to 0.16.0
- ⬆️  Bump directories from 3.0.1 to 3.0.2
- ⬆️  Bump git2_credentials from 0.7.1 to 0.7.2
- ⬆️  Bump git2 from 0.13.17 to 0.13.18
- ⬆️  Bump regex from 1.4.5 to 1.4.6
- ⬆️  Bump libc from 0.2.92 to 0.2.93
- ⬆️  Bump schemars from 0.8.2 to 0.8.3
- ⬆️  Bump pretty_assertions from 0.7.1 to 0.7.2
- ⬆️  Bump serde from 1.0.124 to 1.0.125
- ⬆️  Bump walkdir from 2.3.1 to 2.3.2
- ⬆️  Bump schemars from 0.8.0 to 0.8.2
- ⬆️  Bump libc from 0.2.90 to 0.2.92
- ⬆️  Bump dialoguer from 0.7.1 to 0.8.0
- ⬆️  Bump libc from 0.2.88 to 0.2.90
- 🎨  reformat tutorial (remove EOL that can break display on some renderer)
- ⬆️  Bump openssl from 0.10.32 to 0.10.33
- ⬆️  Bump regex from 1.4.3 to 1.4.5
- ⬆️  Bump pretty_assertions from 0.6.1 to 0.7.1
- ⬆️  Bump console from 0.14.0 to 0.14.1
- ⬆️  Bump run_script from 0.6.4 to 0.7.0
- ⬆️  Bump self_update from 0.25.0 to 0.26.0
- ⬆️  Bump serde from 1.0.123 to 1.0.124
- ⬆️  Bump libc from 0.2.86 to 0.2.88
- ⬆️  Bump self_update from 0.24.0 to 0.25.0
- ⬆️  Bump serde_json from 1.0.62 to 1.0.64
- ⬆️  Bump run_script from 0.6.3 to 0.6.4
- ⬆️  Bump handlebars from 3.5.2 to 3.5.3
- ⬆️  Bump self_update from 0.23.0 to 0.24.0
- ⬆️  Bump thiserror from 1.0.23 to 1.0.24
- ⬆️  Bump serde_yaml from 0.8.16 to 0.8.17
- ⬆️  Bump libc from 0.2.85 to 0.2.86
- ⬆️  Bump slog-term from 2.7.0 to 2.8.0
- ⬆️  Bump slog-term from 2.6.0 to 2.7.0
- ⬆️  Bump serde_json from 1.0.61 to 1.0.62
- ⬆️  Bump libc from 0.2.84 to 0.2.85
- ⬆️  Bump assert_cmd from 1.0.2 to 1.0.3
- ⬆️  Bump serde_yaml from 0.8.15 to 0.8.16
- ⬆️  Bump libc from 0.2.82 to 0.2.84
- ⬆️  Bump predicates from 1.0.6 to 1.0.7
- ⬆️  Bump serde from 1.0.122 to 1.0.123
- ⬆️  Bump serde from 1.0.119 to 1.0.122
- ⬆️  Bump git2 from 0.13.15 to 0.13.17
- ⬆️  Bump serde from 1.0.118 to 1.0.119
- ⬆️  Bump tempfile from 3.1.0 to 3.2.0
- ⬆️  Bump serde_yaml from 0.8.14 to 0.8.15
- ⬆️  Bump libc from 0.2.81 to 0.2.82
- ⬆️  Bump regex from 1.4.2 to 1.4.3
- ⬆️  Bump self_update from 0.22.0 to 0.23.0
- ⬆️  Bump serde_json from 1.0.60 to 1.0.61
- ⬆️  Bump predicates from 1.0.5 to 1.0.6
- ⬆️  Bump git2_credentials from 0.7.0 to 0.7.1
- ⬆️  Bump handlebars from 3.5.1 to 3.5.2
- ⬆️  Bump git2 from 0.13.14 to 0.13.15
- ⬆️  Bump console from 0.13.0 to 0.14.0
- ⬆️  Bump thiserror from 1.0.22 to 1.0.23
- ⬆️  Bump git2 from 0.13.13 to 0.13.14
- ⬆️  Bump openssl from 0.10.31 to 0.10.32
- ⬆️  Bump git2 from 0.13.12 to 0.13.13

### Breaking changes
- 💥  replace slog by tracing

### Fixed
- 🏁  disable windows build (until fixe the issue with git clone on windows)
- 🐛  migration to tracing report log to stdout instead of stderr

### Miscellaneous
- 🚀  (cargo-release) version 2.3.0
- 🚧  (cargo-release) start next development iteration 2.2.2-dev

<a name="2.2.1" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.2.1

### Changed
- ⬆️  upgrade handlebars_misc_helpers to fix json-&gt;toml conversion
- 🚸  add more info when error on git
- ⬆️  cargo update

### Miscellaneous
- 🚀  (cargo-release) version 2.2.1
- 🚧  (cargo-release) start next development iteration 2.2.1-dev

<a name="2.2.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.2.0

### Changed
- 🚸  improve the display of differences when run `test-samples`
- 🎨  format code

### Fixed
- 🐛  wrong ifo in the error

### Miscellaneous
- 🚀  (cargo-release) version 2.2.0
- 🚧  (cargo-release) start next development iteration 2.1.4-dev

<a name="2.1.3" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.1.3

### Changed
- ⬆️  Bump structopt from 0.3.20 to 0.3.21
- ⬆️  Bump serde_json from 1.0.59 to 1.0.60
- ⬆️  Bump serde from 1.0.117 to 1.0.118
- ⬆️  Bump libc from 0.2.80 to 0.2.81
- ⬆️  Bump assert_cmd from 1.0.1 to 1.0.2
- ⬆️  Bump self_update from 0.20.0 to 0.22.0
- ⬆️  Bump slog from 2.5.2 to 2.7.0

### Fixed
- 🐛  do not failed to compare binary file during test-samples

### Miscellaneous
- 🚀  (cargo-release) version 2.1.3
- 💡  link the book as homepage
- 🚧  (cargo-release) start next development iteration 2.1.3-dev

<a name="2.1.2" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.1.2

### Added
- ✨  add preset variable &quot;ffizer_version&quot;

### Changed
- 👽  update config of cargo-release
- 🚨  remove useless `use`
- 🚸  context info on error when set variables

### Fixed
- 🐛  evaluation of `ignores`section during compositing phase of the template generate incorrect value.Handlebars expression (eq, ne,...) don't raise error when undefined variabled are used (also in strict mode)

### Miscellaneous
- 🚀  (cargo-release) version 2.1.2
- 🚧  (cargo-release) start next development iteration 2.1.2-dev

<a name="2.1.1" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.1.1

### Changed
- 🍱  introduce logo
- ⬆️  Bump actions/checkout from v2.3.3 to v2.3.4
- ⬆️  Bump thiserror from 1.0.21 to 1.0.22

### Miscellaneous
- 🚀  (cargo-release) version 2.1.1
- pencil  pre-publish update book, changelog
- 🚧  (cargo-release) start next development iteration 2.1.1-dev

<a name="2.1.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.1.0

### Added
- ✨  cli can show the json schema the of the `.ffizer.yaml`
- ✨  (cli) allow to specify value of variables from cli
- ✨  allow special suffix to located anywhere in the filename (no longer a suffix ;-) )
- ✨  allow to display a message
- ✅  update test to reflect change in gitignore.io

### Changed
- 🎨  remove some explicit clone
- ⬆️  upgrade git2_credentials &amp; handlebars_misc_helpers
- ♻️  change remote test to use `ffizer test-samples`
- ⬆️  Bump regex from 1.4.1 to 1.4.2
- ⬆️  Bump serde_yaml from 0.8.13 to 0.8.14
- ♻️  refactor test to use `test-samples`
- ⬆️  Bump libc from 0.2.79 to 0.2.80
- ⬆️  Bump actions/checkout from v1 to v2.3.3
- ⬆️  updates severals dependencies
- 🍱  regenerate doc

### Breaking changes
- 💥  error handling  switch from `snafu` to `thiserror`

### Removed
- 🔥  remove credits and bom generation

### Fixed
- 🐛  prevent githb-page to use jekill and failed
- 🐛  fix a bug on windows (due to UNC path conversion)
- 💚  move data from a test to the right place
- 🐛  replace the buggy code to &quot;git pull&quot; by the code example from git2.rs

### Miscellaneous
- 🚀  (cargo-release) version 2.1.0
- pencil  pre-publish update book, changelog
- pencil  update the documentation and rewrite the tutorial
- 🚧  support to include samples inside the template and to use them to test via `ffizer test-sample ...`
- pencil  pre-publish update book, changelog
- pencil  pre-publish update book, changelog
- pencil  add pages into book
- pencil  update link to templates and help instruction
- pencil  update doc (regenerate)
- pencil  publish the json-schema of .ffizer.yaml
- 🚧  (cargo-release) start next development iteration 2.0.1-dev

<a name="2.0.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.0.0

### Changed
- ⬆️  update handlebars from 3.3 to 3.4
- 👽  update configuration of release plugin
- 👽  upgrade from dependabot v1 to v2 (aka github)
- ⬆️  update directories from 2.0.2 to 3.0.1
- ⬆️  Bump libc from 0.2.74 to 0.2.76
- ⬆️  Bump git2 from 0.13.8 to 0.13.10
- ⬆️  Bump structopt from 0.3.16 to 0.3.17
- ⬆️  Bump serde from 1.0.114 to 1.0.115
- ⬆️  Bump structopt from 0.3.15 to 0.3.16
- ⬆️  Bump console from 0.11.3 to 0.12.0
- ⬆️  Bump libc from 0.2.73 to 0.2.74
- ⬆️  Bump self_update from 0.17.0 to 0.19.0
- ⬆️  Bump git2 from 0.13.6 to 0.13.8
- ⬆️  Bump libc from 0.2.72 to 0.2.73
- ⬆️  Bump predicates from 1.0.4 to 1.0.5
- ⬆️  Bump handlebars from 3.2.1 to 3.3.0
- ⬆️  Bump self_update from 0.16.0 to 0.17.0
- ⬆️  Bump libc from 0.2.71 to 0.2.72
- ⬆️  Bump winapi from 0.3.8 to 0.3.9
- ⬆️  Bump handlebars from 3.1.0 to 3.2.1
- ⬆️  Bump openssl from 0.10.29 to 0.10.30
- ⬆️  Bump serde from 1.0.112 to 1.0.114
- ⬆️  Bump structopt from 0.3.14 to 0.3.15
- ⬆️  Bump serde from 1.0.111 to 1.0.112
- ⬆️  Bump indicatif from 0.14.0 to 0.15.0
- ⬆️  Bump serde_yaml from 0.8.12 to 0.8.13

### Miscellaneous
- 🚀  (cargo-release) version 2.0.0

<a name="2.0.0-beta.3" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.0.0-beta.3

### Changed
- 👽  update call to dialoguer API
- ⬆️  Bump git2_credentials from 0.6.0 to 0.6.1
- 👽  Bump handlebars_misc_helper from 0.9.0 to 0.9.1 to be able to bump handlebars to 3.1.0
- ⬆️  Bump handlebars from 3.0.1 to 3.1.0
- 👽  reflect change in dialoguer api
- ⬆️  Bump dialoguer from 0.5.1 to 0.6.2
- 👽  the output of gitignore.io has changed
- 🏗  the evaluation of values in the configuration is on demand (previously on load + on demand)
- 🚚  move files under module `ui`
- ⬆️  Bump self_update from 0.15.0 to 0.16.0
- ⬆️  Bump serde from 1.0.110 to 1.0.111
- ⬆️  Bump slog-term from 2.5.0 to 2.6.0
- ⬆️  Bump regex from 1.3.7 to 1.3.9
- ⬆️  Bump libc from 0.2.70 to 0.2.71
- ⬆️  Bump git2 from 0.13.5 to 0.13.6
- ⬆️  Bump console from 0.11.2 to 0.11.3
- ⬆️  Bump self_update from 0.14.0 to 0.15.0
- ⬆️  Bump run_script from 0.6.2 to 0.6.3
- ⬆️  Bump libc from 0.2.69 to 0.2.70
- ⬆️  Bump snafu from 0.6.6 to 0.6.8
- ⬆️  Bump serde from 1.0.106 to 1.0.110
- ⬆️  Bump serde_yaml from 0.8.11 to 0.8.12
- ⬆️  Bump console from 0.11.1 to 0.11.2
- ⬆️  Bump console from 0.10.1 to 0.11.1
- ⬆️  Bump git2 from 0.13.4 to 0.13.5
- ⬆️  Bump dialoguer from 0.5.0 to 0.5.1
- ⬆️  Bump console from 0.10.0 to 0.10.1
- ⬆️  Bump git2 from 0.13.3 to 0.13.4
- ⬆️  Bump git2 from 0.13.2 to 0.13.3
- ⬆️  Bump structopt from 0.3.13 to 0.3.14
- ⬆️  Bump regex from 1.3.6 to 1.3.7
- ⬆️  Bump libc from 0.2.68 to 0.2.69
- 🚨  apply clippy suggestion
- ⬆️  upgrade dependencies
- ⬆️  Bump git2 from 0.13.0 to 0.13.2
- ⬆️  Bump structopt from 0.3.12 to 0.3.13
- ⬆️  Bump openssl from 0.10.28 to 0.10.29
- ⬆️  Bump serde from 1.0.105 to 1.0.106
- ⬆️  Bump snafu from 0.6.3 to 0.6.6
- ⬆️  Bump assert_cmd from 1.0.0 to 1.0.1
- ⬆️  Bump assert_cmd from 0.12.1 to 1.0.0
- ⬆️  Bump regex from 1.3.5 to 1.3.6
- ⬆️  Bump assert_cmd from 0.12.0 to 0.12.1
- ⬆️  Bump human-panic from 1.0.1 to 1.0.3
- ⬆️  Bump snafu from 0.6.2 to 0.6.3
- ⬆️  Bump serde from 1.0.104 to 1.0.105
- ⬆️  Bump structopt from 0.3.11 to 0.3.12
- ⬆️  Bump libc from 0.2.67 to 0.2.68

### Fixed
- 🐛  do not create folder in folder and crash on update

### Miscellaneous
- 🚀  (cargo-release) version 2.0.0-beta.3
- poop  workaround to not failed if `ignores` is a not-evaluable path
- 🚀  (cargo-release) version 2.0.0-beta.2
- 📦  disable snapcraft (temporary ?)

<a name="2.0.0-beta.2" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.0.0-beta.2

### Fixed
- 🐛  do not create folder in folder and crash on update

### Miscellaneous
- 🚀  (cargo-release) version 2.0.0-beta.2

<a name="2.0.0-beta.1" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 2.0.0-beta.1

### Added
- 🎉  prepare 2.0.0 release
- ✅  test e2e can now simulate run over an existing folder
- ✨  shell `scripts` can be run after apply of templates
- ✨  hbs template can be chained to transform content from existing file or from previous template layer

### Changed
- ⬆️  Bump globset from 0.4.4 to 0.4.5
- ⬆️  Bump predicates from 1.0.3 to 1.0.4
- ⬆️  Bump run_script from 0.6.1 to 0.6.2
- ⬆️  Bump git2 from 0.12 to 0.13
- ⬆️  Bump handlebars_misc_helpers from 0.8.0 to 0.9.0
- ⬆️  Bump regex from 1.3.4 to 1.3.5
- ⬆️  Bump console from 0.9.2 to 0.10.0
- ⬆️  Bump handlebars_misc_helpers from 0.7.0 to 0.8.0
- ♻️  change dir_diff into dir_diff_list
- 🚚  moving every content of it tests under a `tests/data`
- ⬆️  Bump predicates from 1.0.3 to 1.0.4
- ⬆️  Bump self_update from 0.13.0 to 0.14.0
- ⬆️  Bump structopt from 0.3.9 to 0.3.11
- ⬆️  upgrade transitive deps
- ⬆️  struct_opt from 0.3.8 to 0.3.9
- ♻️  extract code from mk_file_on_action (too big)
- ⬆️  Bump libc from 0.2.66 to 0.2.67
- ⬆️  Bump run_script from 0.6.1 to 0.6.2
- ⬆️  Bump self_update from 0.12.0 to 0.13.0
- 👽  enable self_update features required for extracting archives of releases
- ⬆️  Bump self_update from 0.11.1 to 0.12.0
- 🚚  rename `test_4` into `test_4_compose`
- ⚡️  avoid to render file name if no `{{`
- ♻️  prepare to support pipeline of template to render a file
- ♻️  use a struct TemplateLayer instead of a Tuple
- 🚚  rename Variable into VariableDef
- ⬆️  Bump git2_credentials from 0.4.0 to 0.5.0
- ⬆️  Bump run_script from 0.6.0 to 0.6.1
- ⬆️  Bump openssl from 0.10.27 to 0.10.28
- ⬆️  upgrade handlebars_misc_helpers to work with handlebars 3.0.1
- ⬆️  Bump handlebars from 2.0.4 to 3.0.1
- ⬆️  `cargo update`
- ⬆️  Bump indicatif from 0.13.0 to 0.14.0
- ⬆️  Bump regex from 1.3.3 to 1.3.4
- ⬆️  Bump slog-term from 2.4.2 to 2.5.0
- ⬆️  Bump self_update from 0.11.0 to 0.11.1
- ⬆️  Bump openssl from 0.10.26 to 0.10.27
- ⬆️  Bump self_update from 0.10.0 to 0.11.0
- ⬆️  Bump console from 0.9.1 to 0.9.2

### Removed
- 🔥  remove useless file

### Fixed
- 🏁  try to fix test_3
- 🏁  try to fix test_3 to show mutli-os cmd
- 🐧  fix e2e test3 for linux
- 🐛  test e2e ran twice, caused issue with override test
- 🐛  (scripts) render scripts before run
- 🏁  try to fix test on windows
- 💚  update remote_test (due to change in usage of assert_cmd)
- 🐛  fix syntax of Cargo.toml
- 🍎  try a new settings to generate macos binary compatible with pre-catalina version
- 🐛  (README) the script getLatest.sh only work with bash (not with POSIX shell like dash)
- 🏁  test on unix file permissions should not run on windows
- 🐛  copy file permissions from template into destination

### Miscellaneous
- 🚀  (cargo-release) version 2.0.0-beta.1
- pencil  (README) Alternatives sections moved to wiki
- 🔊  add log about the phase
- 🔀  Merge branch 'dependabot/cargo/handlebars-3.0.1'
- 🔀  Merge branch 'master' into dependabot/cargo/handlebars-3.0.1
- 🚧  add support for non-string value as variable
- ⚗  try a workaround to be able to build without a missing fix in jmespath (to work with the latest serde_json)
- 🚧  (cargo-release) start next development iteration 1.7.2-dev

<a name="1.7.1" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 1.7.1

### Changed
- ⬆️  upgrade self_update from 0.9.0 to 0.10.0
- ⬆️  Bump structopt from 0.3.7 to 0.3.8
- ⬆️  Bump run_script from 0.5.0 to 0.6.0
- ⬆️  Bump snafu from 0.6.1 to 0.6.2
- ⬆️  Bump self_update from 0.8.0 to 0.9.0
- ♻️  internally store values as serde_yaml::Value (previously was String)
- ⬆️  Bump walkdir from 2.2.9 to 2.3.1
- ⬆️  Bump regex from 1.3.1 to 1.3.3
- ⬆️  :lock: Bump http from 0.1.18 to 0.1.21
- ⬆️  Bump snafu from 0.6.0 to 0.6.1
- ⬆️  Bump handlebars from 2.0.2 to 2.0.4
- ⬆️  Bump run_script from 0.4.0 to 0.5.0

### Fixed
- 🐛  restore output of log on terminal

### Miscellaneous
- 🚀  (cargo-release) version 1.7.1
- 🚧  (cargo-release) start next development iteration 1.7.1-dev

<a name="1.7.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 1.7.0

### Added
- 👷  add config for dependabot

### Changed
- 🚨  apply clippy suggestion
- ⬆️  Bump git2 from 0.10. 2 to 0.11.0
- ⬆️  Bump handlebars_misc_helpers from 0.5.2 to 0.6.0
- ⬆️  Bump run_script from 0.3.2 to 0.4.0
- ⬆️  Bump structopt from 0.3.6 to 0.3.7
- ⬆️  Bump structopt from 0.3.5 to 0.3.6
- ⬆️  Bump serde from 1.0.103 to 1.0.104
- ⬆️  Bump assert_cmd from 0.11.1 to 0.12.0

### Miscellaneous
- 🚀  (cargo-release) version 1.7.0
- 💡  explain options of release profile
- 🔊  provide more info (path of template) when error during rendering of a template
- 🚧  (cargo-release) start next development iteration 1.6.4-dev

<a name="1.6.3" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 1.6.3

### Changed
- 🔧  (ci) refactor the build and options (on mac_os)
- ⬆️  Bump libc from 0.2.65 to 0.2.66
- ⬆️  Bump serde from 1.0.102 to 1.0.103
- ⬆️  Bump structopt from 0.3.4 to 0.3.5
- ⬆️  Bump openssl from 0.10.25 to 0.10.26

### Fixed
- 🐛  trim pattern to ignore from template's config

### Miscellaneous
- 🚀  (cargo-release) version 1.6.3
- 🚀  (cargo-release) version 1.6.2
- 🚀  (cargo-release) version 1.6.1
- 🚧  (cargo-release) start next development iteration 1.6.1-dev

<a name="1.6.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 1.6.0

### Added
- ✅  remove the doc test of tree because tree is not available publicly
- ✨  allow to use merge tool (as defined in git config) to merge updates
- ✨  support several rules for the update of existing files (ask, override, keep, current-as-local, update-as-remote, show-diff)
- 👷  try enable kcov+codecov  report on github-actions

### Changed
- ⬆️  Bump git2 from 0.10.1 to 0.10.2
- 💄  add description of update's option in selector
- 🚨  fix some code practice (thx clippy)
- ⬆️  Bump structopt from 0.3.3 to 0.3.4
- ⬆️  Bump self_update from 0.7.0 to 0.8.0
- ⬆️  Bump snafu from 0.5.0 to 0.6.0
- ⬆️  Bump indicatif from 0.12.0 to 0.13.0
- ⬆️  Bump dialoguer from 0.4.0 to 0.5.0
- ⬆️  Bump console from 0.9.0 to 0.9.1
- ⬆️  Bump slog-term from 2.4.1 to 2.4.2
- ⬆️  Bump serde from 1.0.101 to 1.0.102
- ⬆️  Bump libc from 0.2.64 to 0.2.65
- 🎨  reformat code
- 💄  display &quot;plan to execute&quot; with a tree and lines
- ⬆️  Bump libc from 0.2.62 to 0.2.64

### Removed
- 🔥  remove azure-pipelines definition (switch to github action)
- 🔥  (cli) remove useless conf

### Fixed
- 🐛  (snapcraft) fix the build of the snap on github-action/ubuntu
- 🍎  the cache and project dir should be under &quot;ffizer&quot;, not &quot;github&quot;
- ✏️  try to remove some markdown warning
- 🐛  use only 1 source file from template(s) per destination file
- 🐛  on error the exit status should be non-zero
- 🐛  fix url to retrieve the latest version

### Miscellaneous
- 🚀  (cargo-release) version 1.6.0
- ⚗  try a fix for the build of snap
- 📦  setup packaging via snapcraft
- ⚗  try to auto-detect proxy configuration for git call
- pencil  pre-publish update book, changelog, bom
- pencil  (README) update badge for CI
- 🚧  (cargo-release) start next development iteration 1.5.2-dev

<a name="1.5.1" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 1.5.1

### Changed
- 👽  cargo-release change the default value of tag-name to include a v :-(

### Fixed
- 🐛  (ci) missing GITHUB_REPOSITORY on azure-pipeline so the tarball was not build &amp; uploaded

### Miscellaneous
- 🚀  (cargo-release) version 1.5.1
- 🚧  (cargo-release) start next development iteration 1.5.1-dev

<a name="v1.5.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version v1.5.0

<a name="1.5.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 1.5.0

### Added
- ✅  skip the git test if git is not in the path
- 👷  init github-action

### Changed
- 🔧  (test) try to fix setup of git
- 🔧  enable feature &quot;cli&quot; by default to work friendly with `cargo install` and  `topgrade`
- ⬆️  update Cargo.lock
- ⬆️  Bump structopt from 0.3.2 to 0.3.3
- ⬆️  Bump hashbrown from 0.6.0 to 0.6.1
- ⬆️  Bump serde_yaml from 0.8.9 to 0.8.11
- ⬆️  Bump openssl from 0.10.24 to 0.10.25
- ⬆️  Bump handlebars_misc_helpers from 0.5.1 to 0.5.2
- ⬆️  Bump structopt from 0.3.1 to 0.3.2
- ⬆️  Bump serde from 1.0.100 to 1.0.101
- 🍱  add an asciicast + update book
- ⬆️  Bump git2 from 0.10.0 to 0.10.1
- ⬆️  Bump self_update from 0.6.0 to 0.7.0
- ⬆️  Bump console from 0.8.0 to 0.9.0
- ⬆️  Bump serde from 1.0.99 to 1.0.100
- ⬆️  Bump indicatif from 0.11.0 to 0.12.0
- ⬆️  (ci) upgrade to latest the vmImages used for build
- 🔧  (ci) disables the update check during startup of cargo make
- 🚨  remove 1 clone
- ⬆️  Bump structopt from 0.3.0 to 0.3.1
- ⬆️  Bump git2 from 0.9.2 to 0.10.0
- ⬆️  Bump handlebars_misc_helpers from 0.5.0 to 0.5.1
- ⬆️  Bump handlebars from 2.0.1 to 2.0.2
- 👽  restore the behavior of `--help`
- ⬆️  Bump regex from 1.3.0 to 1.3.1
- ⬆️  Bump regex from 1.2.1 to 1.3.0
- 📌  `cargo update`
- ⬆️  Bump winapi from 0.3.7 to 0.3.8
- ⬆️  Bump console from 0.7.7 to 0.8.0
- ⬆️  Bump structopt from 0.2.18 to 0.3.0
- ⬆️  Bump lazy_static from 1.3.0 to 1.4.0
- ⬆️  :lock: Bump spin from 0.5.0 to 0.5.2
- ⬆️  Bump snafu from 0.4.4 to 0.5.0
- ⬆️  Bump serde from 1.0.98 to 1.0.99

### Breaking changes
- 💥  prepare upgrade to structopt 0.3.0

### Removed
- ➖  remove direct dependency to hashbrown

### Fixed
- 💚  (ci) try to fix azure-pipelines by downgrade image vm + disable cache
- ✏️  fix typo in commit-message
- 🐛  (git) add missing call to disconnect after fetch
- 🐛  (git) fix the &quot;git pull&quot; to update previously cloned &amp; cached template
- ✏️  fix markdown typo
- 🐛  try fix the cargo home cache
- ✏️  (README) typo
- 🐛  move dependencies only for cli

### Miscellaneous
- 🚀  (cargo-release) version 1.5.0
- 🚧  add sub-command èinspectè to provide information about ffizer (cache, configuration)
- ⚗  (test) try to please the setup of azure/linux
- 🔊  (test)  add info when test git'script fail
- pencil  (README) move demo to the top
- ⚗  (ci) restore installation of rustup on every platform
- pencil  pre-publish update book, changelog, bom
- 📝  update screencast (3)
- 📝  update screencast (2)
- 📝  update screencast
- ⚗  (ci) fix rustup is not pre-installed on MacOs image
- ⚗  (ci) try a cross platform setup
- ⚗  (ci) experiment if rust is preinstalled and powershell on every platform
- ⚗  (ci) try setup windows
- ⚗  (ci) try bash sript on windows (like allowed from https://docs.microsoft.com/en-us/azure/devops/pipelines/scripts/cross-platform-scripting?view=azure-devops&amp;tabs=yaml#consider-bash-or-pwsh (3)
- ⚗  (ci) :alembic: (ci) try bash sript on windows (like allowed from https://docs.microsoft.com/en-us/azure/devops/pipelines/scripts/cross-platform-scripting?view=azure-devops&amp;tabs=yaml#consider-bash-or-pwsh (2)
- ⚗  (ci) try bash sript on windows (like allowed from https://docs.microsoft.com/en-us/azure/devops/pipelines/scripts/cross-platform-scripting?view=azure-devops&amp;tabs=yaml#consider-bash-or-pwsh
- ⚗  (ci) try conditional install of cargo-make (3)
- ⚗  (ci) try conditional install of cargo-make (2)
- ⚗  (ci) try conditional install of cargo-make
- ⚗  (ci) try setup cargo cache
- ⚗  (ci) try to fix path issue with cargo and cache
- typo  update label of Azure Task
- ⚗  try to enable cache for cargo on CI
- 🚧  (cargo-release) start next development iteration 1.4.1-dev

<a name="1.4.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 1.4.0

### Changed
- 🚸  display &quot;plan to execute&quot; in as a colorized table (more readable)
- 🔧  change the way to commit update of doc (env is set after dependencies task)

### Fixed
- 🐛  restore the behavior to use the remote_path ignoring subfolder when retrieve git repo

### Miscellaneous
- 🚀  (cargo-release) version 1.4.0
- 🔊  add more info on handlebars error
- 📝  pre-publish update book, changelog, bom
- 🔊  add log, refactor call, use log for Err in main
- 🚧  (cargo-release) start next development iteration 1.3.2-dev

<a name="1.3.1" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 1.3.1

### Changed
- ⬆️  Bump libc from 0.2.61 to 0.2.62

### Fixed
- 🐛  (README) fix instruction for installation via cargo.

### Miscellaneous
- 🚀  (cargo-release) version 1.3.1
- 📦  to generate archive without &quot;./&quot; as prefix (to workaround an issue in self_update)
- 🚧  (cargo-release) start next development iteration 1.3.1-dev

<a name="1.3.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 1.3.0

### Added
- ✨  add support of select (combobox) for variable's value
- ✨  (variables) allow variable to be hidden

### Changed
- ⬆️  Bump directories from 2.0.1 to 2.0.2
- 👽  update code to match change in self_update
- ⬆️  Bump self_update from 0.5.1 to 0.6.0
- ⬆️  Bump hashbrown from 0.5.0 to 0.6.0
- ⬆️  Bump libc from 0.2.60 to 0.2.61
- 🚨  (clippy) apply some suggestion
- ⬆️  Bump handlebars_misc_helpers from 0.3.0 to 0.5.0
- ⬆️  Bump snafu from 0.4.3 to 0.4.4
- ⬆️  Bump regex from 1.2.0 to 1.2.1
- ⬆️  Bump test-generator from 0.2.2 to 0.3.0
- ⬆️  Bump git2 from 0.9.1 to 0.9.2
- ⬆️  Bump slog from 2.5.1 to 2.5.2
- ⬆️  Bump regex from 1.1.9 to 1.2.0
- ⬆️  Bump openssl from 0.10.23 to 0.10.24

### Breaking changes
- 💥  change error handling, move from `failure` to  `std::error::Error` and `snafu`

### Fixed
- ✏️  README fix syntax to be readable by crates.io

### Miscellaneous
- 🚀  (cargo-release) version 1.3.0
- 📝  (book) update
- 📝  (CHANGELOG) update
- 📝  (README) rework the features section
- 📝  (crates) update categories
- 🚧  (cargo-release) start next development iteration 1.2.1-dev

<a name="1.2.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 1.2.0

### Added
- ✨  allow template content to be into a subfolder `template` #79
- ➕  use hashbrown (like handlebars) to replace std BTreeMap, HashMap, HashSet

### Changed
- ♻️  use handlebars helpers externalized into handlebars_misc_helpers
- ♻️  move handlebars/hbs into a module folder and split into submodules
- 🚨  remove unused code
- 🔧  limit dependencies only used by cli
- ⬆️  Bump libc from 0.2.59 to 0.2.60
- ⬆️  Bump serde from 1.0.94 to 1.0.97
- ⬆️  Bump handlebars from 2.0.0 to 2.0.1
- ⬆️  Bump slog from 2.4.1 to 2.5.1
- ⬆️  Bump slog-term from 2.4.0 to 2.4.1

### Fixed
- 🐛  adjust version of dependencies to existing value
- ✏️  fix typo in badge

### Miscellaneous
- 🚀  (cargo-release) version 1.2.0
- 📝  update book
- 📝  README update list of templates
- 🚧  (cargo-release) start next development iteration 1.1.1-dev

<a name="1.1.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 1.1.0

### Changed
- ⬆️  Bump git2 from 0.8.0 to 0.9.1 &amp; git2_credentials from 0.2.0 to 0.3.0
- ⬆️  Bump libc from 0.2.58 to 0.2.59
- ⬆️  :lock: Bump libflate from 0.1.21 to 0.1.25
- ⬆️  Bump regex from 1.1.8 to 1.1.9
- ⬆️  Bump regex from 1.1.7 to 1.1.8
- ⬆️  :lock: Bump smallvec from 0.6.9 to 0.6.10
- ⬆️  Bump handlebars from 2.0.0-beta.3 to 2.0.0
- ⬆️  Bump tempfile from 3.0.9 to 3.1.0
- ⬆️  Bump tempfile from 3.0.8 to 3.0.9
- ⬆️  Bump serde from 1.0.93 to 1.0.94
- ⬆️  Bump globset from 0.4.3 to 0.4.4
- ⬆️  Bump structopt from 0.2.17 to 0.2.18
- ⬆️  Bump handlebars from 2.0.0-beta.2 to 2.0.0-beta.3
- ⬆️  Bump serde from 1.0.92 to 1.0.93
- ⬆️  Bump console from 0.7.6 to 0.7.7
- ⬆️  Bump console from 0.7.5 to 0.7.6
- ⬆️  Bump regex from 1.1.6 to 1.1.7
- ⬆️  Bump walkdir from 2.2.7 to 2.2.8
- ⬆️  Bump reqwest from 0.9.17 to 0.9.18
- ⬆️  Bump serde from 1.0.91 to 1.0.92
- ⬆️  Bump structopt from 0.2.16 to 0.2.17
- ⬆️  Bump libc from 0.2.55 to 0.2.58
- ⬆️  Bump directories from 2.0.0 to 2.0.1
- ⬆️  Bump structopt from 0.2.15 to 0.2.16
- ⬆️  Bump directories from 1.0.2 to 2.0.0
- ⬆️  Bump tempfile from 3.0.7 to 3.0.8
- ⬆️  Bump openssl from 0.10.22 to 0.10.23
- ⬆️  Bump libc from 0.2.54 to 0.2.55
- ⬆️  Bump dialoguer from 0.3.0 to 0.4.0
- ⬆️  Bump reqwest from 0.9.16 to 0.9.17
- ⬆️  Bump openssl from 0.10.21 to 0.10.22

### Fixed
- 🐛  fix Cargo warning about exclude

### Miscellaneous
- 🚀  (cargo-release) version 1.1.0
- 🚧  (cargo-release) start next development iteration 1.0.1-dev

<a name="1.0.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 1.0.0

### Added
- ➕  use git2_credentials (extract of existing code)
- ✅  (ci) enable test_remote on ci build

### Changed
- ⬆️  Bump serde from 1.0.90 to 1.0.91
- ⬆️  Bump git2_credentials from 0.1.1 to 0.2.0
- ⬆️  Bump openssl from 0.10.20 to 0.10.21
- ⬆️  Bump reqwest from 0.9.15 to 0.9.16
- ⬆️  Bump serde_yaml from 0.8.8 to 0.8.9
- ⬆️  Bump libc from 0.2.53 to 0.2.54
- ⬆️  Bump libc from 0.2.51 to 0.2.53
- ⬆️  Bump regex from 1.1.5 to 1.1.6
- ⬆️  Bump globset from 0.4.2 to 0.4.3
- ⬆️  Bump reqwest from 0.9.14 to 0.9.15
- ⬆️  Bump reqwest from 0.9.13 to 0.9.14
- ⬆️  Bump handlebars from 2.0.0-beta.1 to 2.0.0-beta.2
- ⬆️  Bump serde from 1.0.89 to 1.0.90
- ⬆️  Bump reqwest from 0.9.12 to 0.9.13
- ⬆️  Bump regex from 1.1.2 to 1.1.5

### Miscellaneous
- 🚀  (cargo-release) version 1.0.0
- 🚧  (build) prepare 1.0.0
- 📝  (README) update build instruction
- 🚧  (cargo-release) start next development iteration 0.12.2-dev

<a name="0.12.1" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.12.1

### Changed
- ⬆️  Bump assert_cmd from 0.11.0 to 0.11.1

### Removed
- 🔇  remove xdb! call
- 🔥  (ci) remove travis configuration
- 🔇  (ci) remove verbose mode during github-upload-flow

### Fixed
- ✏️  fix typo in log
- 🐛  report error (instead of crash) when error during computation of rendered path
- 🐛  fix the folder use to clone when subfolder is defined (cause by refactor)

### Miscellaneous
- 🚀  (cargo-release) version 0.12.1
- 📝  (docs) add information about template_configuration
- 🚧  (cargo-release) start next development iteration 0.12.1-dev

<a name="0.12.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.12.0

### Changed
- ⬆️  Bump reqwest from 0.9.11 to 0.9.12

### Fixed
- 🐛  (git) fix authentication via ssh, https

### Miscellaneous
- 🚀  (cargo-release) version 0.12.0
- 📝  (CHANGELOG) update
- ⚗  (ci) update github-upload task to not failed on error during release creation
- 🚧  (cargo-release) start next development iteration 0.11.4-dev

<a name="0.11.3" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.11.3

### Fixed
- 🐛  (git) remove folder if error during git retieve

### Miscellaneous
- 🚀  (cargo-release) version 0.11.3
- ⚗  (ci) try fix for github-upload
- 📝  update changelog
- 🚧  (cargo-release) start next development iteration 0.11.3-dev

<a name="0.11.2" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.11.2

### Fixed
- 🐛  (ci) try to fix github-upload-flow

### Miscellaneous
- 🚀  (cargo-release) version 0.11.2
- 🚧  (cargo-release) start next development iteration 0.11.2-dev

<a name="0.11.1" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.11.1

### Added
- ✨  (hbs) add helper env_var
- ✨  default_value can be composed of previously defined value

### Changed
- ⬆️  (build) update cargo.lock
- 🔧  (ci) try to fix upload of asset on github (for windows, mac, linux)
- ⬆️  Bump handlebars from 1.1.0 to 2.0.0-beta.1
- ♻️  (git) try to git pull instead of rm + clone on already cached (cloned) template
- 🔧  (cargo) tried to decrease size of executable
- ⬆️  Bump structopt from 0.2.14 to 0.2.15

### Fixed
- 🐛  (test) fix test about env_var
- 🐛  path_helpers canonicalize existing path
- 🐛  (test) fix warning
- 🐛  try to static link openssl
- 🐛  fix the download of git repository

### Miscellaneous
- 🚀  (cargo-release) version 0.11.1
- 🚀  (cargo-release) version 0.11.0
- 📝  (ci) add info
- ⚗  (build) fix syntax error in Makefile.toml
- ⚗  (build) try to use github-release to upload dist
- 🚧  (cargo-release) start next development iteration 0.10.3-dev

<a name="0.10.2" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.10.2

### Changed
- ⬆️  Bump reqwest from 0.9.10 to 0.9.11

### Removed
- 🔥  (cirrus) remove upload script

### Miscellaneous
- 🚀  (cargo-release) version 0.10.2
- ⚗  (travis) try named cache to optimize
- 🚧  (cargo-release) start next development iteration 0.10.2-dev

<a name="0.10.1" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.10.1

### Added
- 👷  (azure) set up CI with Azure Pipelines

### Changed
- 🔧  (make) use profile and platform
- 🔧  (make) move upload to github as part of make
- 🔧  (azure) add deploy to github + fix variables
- 🔧  (cirrus) fix osx script
- 🔧  (cirrus) fix syntax
- 🔧  (publish) diseable changelog update during publication
- 🔧  (travis) try to workaround the timeout (on windows)
- 🔧  (cirrus) try a windows &amp; osx setup

### Removed
- 🔥  (cirrus) remove cirrus-ci configuration

### Fixed
- 🐛  (azure) profile injection cross platform
- 🐛  (azure) fix typo in profile injection
- 🐛  (azure) try to fix syntax
- 🐛  (make) fix typo in tasks.zip-release-binary-for-target
- 🐛  (make) fix syntax error into windows path
- 🐛  (windows) try to fix the packaging
- ✏️  (README) syntax error
- 🐛  (travis) always build the zip to not fail during release

### Miscellaneous
- 🚀  (cargo-release) version 0.10.1
- 🚧  (cirrus) disable codecov on cirrus
- 📦  (make) use &quot;cargo release&quot; for publish-flow
- 📝  add a CHANGELOG.md
- 📦  (cargo) update lock
- 🚧  (cargo-release) start next development iteration 0.10.1-dev

<a name="0.10.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.10.0

### Added
- 👷  (travis) increase cache timeout (try to fix for windows)
- 👷  (cirrus) try to setup codecov
- 👷  (cirrus) add missing install of cargo-make (2)
- 👷  (cirrus) add missing install of cargo-make
- 👷  (travis, cirrus, make) setup cargo-make
- 👷  (cirrus) trigger and enable release mode
- 👷  start experiment with cirrus-ci
- ✅  (e2e) add a basic test about import
- ✨  (imports) allow to use ffizer_src_uri and ffizer_src_rev into imports
- ✨  (fileext) remove extention .ffizer.raw (and keep it)
- 👷  (travis) try to re-enable the cache
- 👷  (travis) disable cargo install-update -a
- ✨  (imports) allow template to be composed by other template
- 👷  increase timeout when builing on travis

### Changed
- 🎨  use Upper Case for lazy static ref
- ⬆️  Bump serde from 1.0.88 to 1.0.89
- ⬆️  Bump regex from 1.1.0 to 1.1.2
- ⬆️  Bump lazy_static from 1.2.0 to 1.3.0
- 🎨  (tests) automate test from local directories
- ⬆️  Bump reqwest from 0.9.9 to 0.9.10
- ⬆️  Bump serde from 1.0.87 to 1.0.88
- ⬆️  Bump tempfile from 3.0.6 to 3.0.7
- 🎨  (render) introduce a TransformValues trait - use it to delegate its impl to each type
- ⬆️  Bump assert_cmd from 0.10.2 to 0.11.0
- ⬆️  Bump tempfile from 3.0.5 to 3.0.6
- ⬆️  Bump serde from 1.0.86 to 1.0.87
- 🎨  change the way to import serde &amp; serde_derive
- 📌  update locked dependencies
- 🎨  apply clippy suggestions
- 🎨  reformat
- 🎨  refactor source definition into SourceLoc (SourceLoc can be used from cli or cfg)
- 🎨  (cfg) remove crappy ignores_str, by using a PathPattern
- ⬆️  Bump reqwest from 0.9.8 to 0.9.9
- ⬆️  Bump serde_derive from 1.0.84 to 1.0.85
- ⬆️  Bump serde from 1.0.84 to 1.0.85
- ⬆️  Bump Inflector from 0.11.3 to 0.11.4
- ⬆️  Bump console from 0.7.3 to 0.7.5
- ⬆️  Bump console from 0.7.2 to 0.7.3
- ⬆️  Bump reqwest from 0.9.5 to 0.9.8
- ⬆️  Bump self_update from 0.5.0 to 0.5.1
- ⬆️  Bump failure from 0.1.4 to 0.1.5
- ⬆️  Bump serde_derive from 1.0.83 to 1.0.84
- ⬆️  Bump serde from 1.0.83 to 1.0.84
- 🎨  remove useless 'extern crate' with rust edition 2018
- 🎨  refactor cli opts and sub command
- ⬆️  Bump failure from 0.1.3 to 0.1.4
- ⬆️  Bump serde from 1.0.82 to 1.0.83
- ⬆️  Bump serde_derive from 1.0.82 to 1.0.83
- ⬆️  Bump indicatif from 0.10.3 to 0.11.0
- ⬆️  Bump console from 0.7.1 to 0.7.2

### Removed
- 🔇  (scripts) remove trace when run getLatest.sh

### Fixed
- 🐛  fix getLatest.sh for linux
- 🐛  remove .unwrap() inside main code
- 🐛  (e2e) ignore diff between \r\n and \n
- ✏️  (README) fix typo
- 🐛  (travis) fix syntax error

### Miscellaneous
- 🚀  (cargo-release) version 0.10.0
- 📦  set the right version (0.10.0 not yet release)
- 📝  (README) add codecov badge
- 📦  try cargo-release
- 📝  (README) update features checkbox
- 📦  prepare release
- 📦  (scripts) to download the latest binary
- 📦  repo for sample renamed
- 📝  (README) complete homebrew instruction
- 📦  (brew) move homebrew stuff to homebrew-ffizer repo
- 📦  transfert repo ownership from davidB to ffizer
- 📦  (homebrew) experiment to deploy a formulae
- 📝  (README) update link to book
- 🚀  deploying docs manually (no ci)
- 📝  (book) move part of content of README into book

<a name="0.9.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.9.0

### Changed
- 🎨  apply clippy suggestion
- ⬆️  Bump git2 from 0.7.5 to 0.8.0
- ⬆️  Bump serde_derive from 1.0.81 to 1.0.82
- ⬆️  Bump serde from 1.0.81 to 1.0.82
- ⬆️  Bump structopt from 0.2.13 to 0.2.14
- ⬆️  Bump serde_derive from 1.0.80 to 1.0.81
- ⬆️  Bump serde from 1.0.80 to 1.0.81

### Breaking changes
- 💥  cli change to support subcommand (apply &amp; upgrade)

<a name="0.8.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.8.0

### Changed
- ⬆️  move to rust edition 2018
- 🚸  (cli) use human_panic...

### Miscellaneous
- 📦  prepare release

<a name="0.7.1" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.7.1

### Changed
- ⬆️  Bump regex from 1.0.6 to 1.1.0
- ⬆️  Bump indicatif from 0.10.2 to 0.10.3
- ⬆️  Bump indicatif from 0.10.1 to 0.10.2
- ⬆️  Bump console from 0.7.0 to 0.7.1
- ⬆️  upgrade dependencies

### Miscellaneous
- 📦  prepare release
- 📝  (README) add a template to the list

<a name="0.7.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.7.0

### Added
- ✨  (cfg) can use handlebars into ignores'entry and default_value in ffizer.yaml
- 👷  (travis) try to fix random timeout on windows (6)
- 👷  (travis) try to fix random timeout on windows (5)
- 👷  (travis) try to fix random timeout on windows (4)
- 👷  (travis) try to fix random timeout on windows (3)
- 👷  (travis) try to fix random timeout on windows (2)
- 👷  (travis) try to fix random timeout on windows
- ✨  (render) add helper to transform path

### Changed
- 🎨  (e2e) compare content of file as string (vs vec[u8]) to ease debug
- 🎨  (e2e) capture stderr &amp; stdout
- ⬆️  Bump tempfile from 3.0.4 to 3.0.5
- ⬆️  Bump indicatif from 0.9.0 to 0.10.1

### Fixed
- ✏️  (README) fixing typo

### Miscellaneous
- 📦  prepare release
- 🚧  (cfg) allow to use handlebars and cli info into part of ffizer.yml
- 📝  (README) how to chain helpers
- 📝  (README) fix syntax
- 📦  (cargo) try to exclude tests

<a name="0.6.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.6.0

### Added
- ✨  (render) add helper to do http request and a preconfigured to request gitignore.io
- ✨  #6 (render) add helper to transform string

### Changed
- 🔧  (e2e) disable remote test by default

### Miscellaneous
- 📦  prepare release

<a name="0.5.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.5.0

### Changed
- 🚸  (cli) clean display to user (happy path only)
- ⬆️  Bump dialoguer from 0.2.0 to 0.3.0

### Miscellaneous
- 📝  (README) update doc (help, usage,...)

<a name="0.4.2" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.4.2

### Added
- ✨  (cli) add support of source subfolder

### Changed
- ⬆️  Bump assert_cmd from 0.10.1 to 0.10.2

### Miscellaneous
- 📦  (release) customize release profile
- 📝  (README) update features list (states &amp; planned)

<a name="0.4.1" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.4.1

### Added
- ✨  (cli) add --rev to specify the git revision

### Fixed
- 🐛  (git) do not remove existing cache before success clone

<a name="0.4.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.4.0

### Added
- 👷  (travis) remove build for i686
- 👷  (travis) try to fix compilation on i686
- ✨  (cli) add offline mode
- ✨  (source) accept remote git repository as source for template

### Changed
- 🎨  (git) comment unused code
- ♻️  move Uri into SourceUri
- 🎨  prepare for rust edition 2018
- 🎨  (e2e) test the executable via cli
- ⬆️  Bump dialoguer from 0.1.0 to 0.2.0

### Fixed
- 🐛  (windows) try to fix bug when git clone
- 🐛  detection of file to &quot;Ignores&quot; is done during the scan
- 🐛  fix a bug when compare 2 files (one with .ffizer.hbs and one without)
- 🐛  fix due to change in api of dialoguer
- 🐛  fix file order priority

### Miscellaneous
- 📦  prepare release
- 📦  (cargo) clean travis info
- 📄  (LICENSE) list dependencies and licenses in CREDITS
- 📦  (travis) store note for future check
- 📝  (README) remade the TOC
- 🚧  prepare to support several form of template uri

<a name="0.3.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.3.0

### Added
- ✨  (cli) add experimental flags to always accept default value for variables
- ✨  (cli) add flags to control confirmation (always, never, auto)
- ✨  (cfg) allow to ignore (glob) file and directy
- ✅  (e2e) add 2 tests to show every features (need some improvement)

### Changed
- ⬆️  Bump walkdir from 2.2.6 to 2.2.7
- ♻️  (cli) move Cmd into Ctx.cmd_opt: CmdOpt

### Fixed
- 🐛  fixe processing order of files
- 🐛  (render) use the rendered path for *.ffizer.hbs
- 🐛  (render) enable strict mode and log variables to help debug template
- ✏️  (README) fix title level
- 🐛  (travis) ‘cargo publish’ doesn’t work on windows

### Miscellaneous
- 📦  prepare release
- 📝  (README) add TOC

<a name="0.2.1" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.2.1

### Fixed
- 🐛  (cargo) expected at most 5 keywords per crate

### Miscellaneous
- 📦  prepare release
- 📝  (README) update badges
- 📝  (README) update install instruction
- 📦  (travis) generate archive without target path

<a name="0.2.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.2.0

### Added
- ✨  (render) file name and folder name could be rendered
- 👷  (appveyor) remove appveyor as CI
- 👷  (travis) try a workaround to deploy windows (2)

### Changed
- ♻️  (error) use failure to manage the error

### Fixed
- ✏️  (README) wrong project name, reformulate

### Miscellaneous
- 📦  prepare release
- 🚧  (render) basic implementation to support *.ffizer.hbs
- 🚧  read a configuration file (.ffizer.yaml) from the template folder

<a name="0.1.2" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.1.2

### Added
- 👷  (travis) try a workaround to deploy windows (3)
- 👷  (travis) try a workaround to deploy windows (2)

<a name="0.1.1" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.1.1

### Added
- 👷  (travis) try a workaround to deploy windows
- 👷  (travis) fix the api_key

<a name="0.1.0" data-comment="this line is used by gitmoji-changelog, don't remove it!"></a>
## Version 0.1.0

### Added
- 👷  (travis) try to add windows support
- ✨  (cli) ask confirmation before apply plan
- ✨  copy dir and files from template and base for next step (cause it’s not KISS).
- 👷  fix os specific setup
- ✅  initialize testing
- 👷  bootstrap conf for travis and appveyor
- ✨  (main) setup of log + cli arguments read
- 🎉  init

### Changed
- 💄  (cli) add a progress bar for the execution (experimental)
- 🚸  (cli) complete description
- 🎨  (main) main is a wrapper for the lib
- 🚚  rename project from fgen to ffizer fgen already exists

### Fixed
- 🐛  (README) fix appveyor badge
- 🐛  (cli) use flags instead of args, correct description

### Miscellaneous
- 📦  (cargo) prepare info for publishing
- 📝  (README) udapte
- 🚧  (cli) confirm plan before execute
- 🚧  ordering action by path
- 📝  (README) add badges for travis, status, license
- 📄  add license CC0-1.0
- 🚧  (copy mode) bootstrap the code for plan &amp; execute + scan src
- 📝  (README) add help of the cli, and sub-features
- 📝  (README) update alternatives list
- 📝  (README) fix format
- 📝  (README) ideas &quot;en vrac&quot;
- 📝  (README) add ideas, motivations, alternatives,...

_Generated by [gitmoji-changelog (rust version)](https://github.com/fabienjuif/gitmoji-changelog-rust)_