#[macro_export]
macro_rules! generic_err {
    ($val:expr) => {
        Err(cosmwasm_std::StdError::generic_err($val))
    };
}

#[macro_export]
macro_rules! not_implemented {
    () => {
        generic_err!("Not Implemented")
    };
}

#[macro_export]
macro_rules! addr {
    ($val:expr) => {
        cosmwasm_std::Addr::unchecked($val)
    };
}

#[macro_export]
macro_rules! cu128 {
    ($val:expr) => {
        cosmwasm_std::Uint128::from($val as u128)
    };
}

#[macro_export]
macro_rules! error_msg {
    ($result:expr) => {
        match $result.err().unwrap() {
            cosmwasm_std::StdError::GenericErr { msg, .. } => msg,
            _ => String::from("Non specified error type"),
        }
    };
}

#[macro_export]
macro_rules! resp_msg {
    ($result:expr) => {
        serde_json::to_string(&$result.unwrap()).unwrap()
    };
}

#[macro_export]
macro_rules! assert_call {
    ($call:expr) => {
        assert!($call.is_ok(), "{}", error_msg!($call));
    };
}

#[macro_export]
macro_rules! assert_call_fails {
    ($result:expr) => {
        assert!(
            $result.is_err(),
            "Call expected to fail, succeeded with {}",
            resp_msg!($result)
        );
    };
}
