use super::WebHook;
extern crate serde;
extern crate serde_json;

#[derive(Debug)]
pub struct WebHookSender<'a> {
    pub webhook_url: &'a str,
    pub options: WebHook,
}

impl<'a> WebHookSender<'a> {
    pub async fn send(&self) -> Result<(), reqwest::Error> {
        let options = &self.options;

        let _ = reqwest::Client::new()
            .post(self.webhook_url)
            .header("content-type", "application/json")
            .body(serde_json::to_string(&options).unwrap())
            .send()
            .await?;
        Ok(())
    }
}
