pub mod embed;
pub mod sender;

use embed::*;

use serde_derive::*;

#[derive(Serialize, Deserialize, Debug)]
pub struct WebHook {
    pub username: Option<String>,
    pub avatar_url: Option<String>,
    pub content: String,
    pub embeds: Option<Vec<WebHookEmbed>>,
}

impl WebHook {
    pub fn username(mut self, username: &str) -> WebHook {
        self.username = Some(username.to_string());
        self
    }

    pub fn avatar_url(mut self, avatar_url: &str) -> WebHook {
        self.avatar_url = Some(avatar_url.to_string());
        self
    }

    pub fn content(mut self, content: &str) -> WebHook {
        self.content = content.to_string();
        self
    }

    pub fn embed<T>(mut self, embed: T) -> WebHook
    where
        T: FnOnce(WebHookEmbed) -> WebHookEmbed,
    {
        self.embeds = Some(vec![embed(WebHookEmbed {
            title: None,
            description: None,
            color: None,
            footer: None,
            image: None,
            thumbnail: None,
            author: None,
            fields: None,
        })]);
        self
    }
}

pub mod webhook {
    use crate::sender::WebHookSender;

    use super::WebHook;

    pub fn new<'a, F>(webhook_url: &'a str, w: F) -> WebHookSender
    where
        F: FnOnce(WebHook) -> WebHook,
    {
        WebHookSender {
            webhook_url: webhook_url,
            options: w(WebHook {
                username: None,
                avatar_url: None,
                content: "** **".to_string(),
                embeds: None,
            }),
        }
    }
}
