# Ferris Hook

**Discord Webhook API**

# Usage

## Example

```sh
cargo run --example webhook
```

```rs
use ferrishook::*;

#[tokio::main]
async fn main() -> Result<(), Box<dyn std::error::Error>> {
    let secret = "webhook_key";
    webhook::new(secret, |x| {
        x.content("Hello, World!")
            .username("Rusty WebHook")
            .avatar_url("https://avatars.githubusercontent.com/u/74909209")
            .embed(|e| {
                e.title("Embed Title")
                    .description("Embed Description")
                    .thumbnail("https://avatars.githubusercontent.com/u/5430905")
                    .author(|a| {
                        a.name("Author Name")
                            .icon_url("https://avatars.githubusercontent.com/u/9919")
                    })
                    .color(15258703)
                    .image("https://i.imgur.com/nBeX2Y3.jpg")
                    .footer(|f| f.text("Footer").icon_url("https://i.imgur.com/vk1RYK4.png"))
                    .add_field("Field 1", "Value 1", false)
                    .add_field("Field 2", "Value 2", false)
            })
    })
    .send()
    .await?;

    Ok(())
}
```

---

**License - GPL-2.0**