// WARNING: THIS CODE IS AUTOGENERATED.
// DO NOT EDIT!!!

#![allow(clippy::too_many_arguments)]
use serde::Serialize;

use crate::error::Result;
use crate::types::File;
use crate::types::InputFile;
use crate::Bot;

impl Bot {
    /// Use this method to upload a .PNG file with a sticker for later use in createNewStickerSet and addStickerToSet methods (can be used multiple times). Returns the uploaded File on success.
    /// <https://core.telegram.org/bots/api#uploadstickerfile>
    pub fn upload_sticker_file(
        &self,
        user_id: i64,
        png_sticker: InputFile,
    ) -> UploadStickerFileBuilder {
        UploadStickerFileBuilder::new(self, user_id, png_sticker)
    }
}

#[derive(Serialize)]
pub struct UploadStickerFileBuilder<'a> {
    #[serde(skip)]
    bot: &'a Bot,
    /// User identifier of sticker file owner
    pub user_id: i64,
    /// PNG image with the sticker, must be up to 512 kilobytes in size, dimensions must not exceed 512px, and either width or height must be exactly 512px. More info on Sending Files: https://core.telegram.org/bots/api#sending-files
    pub png_sticker: InputFile,
}

impl<'a> UploadStickerFileBuilder<'a> {
    pub fn new(bot: &'a Bot, user_id: i64, png_sticker: InputFile) -> Self {
        Self {
            bot,
            user_id,
            png_sticker,
        }
    }

    pub fn user_id(mut self, user_id: i64) -> Self {
        self.user_id = user_id;
        self
    }

    pub fn png_sticker(mut self, png_sticker: InputFile) -> Self {
        self.png_sticker = png_sticker;
        self
    }

    pub async fn send(self) -> Result<File> {
        let form = serde_json::to_value(&self)?;
        self.bot.get::<File>("uploadStickerFile", Some(&form)).await
    }
}
