// WARNING: THIS CODE IS AUTOGENERATED.
// DO NOT EDIT!!!

#![allow(clippy::too_many_arguments)]
use serde::Serialize;

use crate::error::Result;
use crate::types::{BotCommand, BotCommandScope};
use crate::Bot;

impl Bot {
    /// Use this method to change the list of the bot's commands. See https://core.telegram.org/bots#commands for more details about bot commands. Returns True on success.
    /// <https://core.telegram.org/bots/api#setmycommands>
    pub fn set_my_commands(&self, commands: Vec<BotCommand>) -> SetMyCommandsBuilder {
        SetMyCommandsBuilder::new(self, commands)
    }
}

#[derive(Serialize)]
pub struct SetMyCommandsBuilder<'a> {
    #[serde(skip)]
    bot: &'a Bot,
    /// A JSON-serialized list of bot commands to be set as the list of the bot's commands. At most 100 commands can be specified.
    pub commands: Vec<BotCommand>,
    /// A JSON-serialized object, describing scope of users for which the commands are relevant. Defaults to BotCommandScopeDefault.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub scope: Option<BotCommandScope>,
    /// A two-letter ISO 639-1 language code. If empty, commands will be applied to all users from the given scope, for whose language there are no dedicated commands
    #[serde(skip_serializing_if = "Option::is_none")]
    pub language_code: Option<String>,
}

impl<'a> SetMyCommandsBuilder<'a> {
    pub fn new(bot: &'a Bot, commands: Vec<BotCommand>) -> Self {
        Self {
            bot,
            commands,
            scope: None,
            language_code: None,
        }
    }

    pub fn commands(mut self, commands: Vec<BotCommand>) -> Self {
        self.commands = commands;
        self
    }

    pub fn scope(mut self, scope: BotCommandScope) -> Self {
        self.scope = Some(scope);
        self
    }

    pub fn language_code(mut self, language_code: String) -> Self {
        self.language_code = Some(language_code);
        self
    }

    pub async fn send(self) -> Result<bool> {
        let form = serde_json::to_value(&self)?;
        self.bot.get::<bool>("setMyCommands", Some(&form)).await
    }
}
