// WARNING: THIS CODE IS AUTOGENERATED.
// DO NOT EDIT!!!

#![allow(clippy::too_many_arguments)]
use serde::Serialize;

use crate::error::Result;
use crate::types::ChatPermissions;
use crate::Bot;

impl Bot {
    /// Use this method to set default chat permissions for all members. The bot must be an administrator in the group or a supergroup for this to work and must have the can_restrict_members administrator rights. Returns True on success.
    /// <https://core.telegram.org/bots/api#setchatpermissions>
    pub fn set_chat_permissions(
        &self,
        chat_id: i64,
        permissions: ChatPermissions,
    ) -> SetChatPermissionsBuilder {
        SetChatPermissionsBuilder::new(self, chat_id, permissions)
    }
}

#[derive(Serialize)]
pub struct SetChatPermissionsBuilder<'a> {
    #[serde(skip)]
    bot: &'a Bot,
    /// Unique identifier for the target chat or username of the target supergroup (in the format @supergroupusername)
    pub chat_id: i64,
    /// A JSON-serialized object for new default chat permissions
    pub permissions: ChatPermissions,
}

impl<'a> SetChatPermissionsBuilder<'a> {
    pub fn new(bot: &'a Bot, chat_id: i64, permissions: ChatPermissions) -> Self {
        Self {
            bot,
            chat_id,
            permissions,
        }
    }

    pub fn chat_id(mut self, chat_id: i64) -> Self {
        self.chat_id = chat_id;
        self
    }

    pub fn permissions(mut self, permissions: ChatPermissions) -> Self {
        self.permissions = permissions;
        self
    }

    pub async fn send(self) -> Result<bool> {
        let form = serde_json::to_value(&self)?;
        self.bot
            .get::<bool>("setChatPermissions", Some(&form))
            .await
    }
}
