// WARNING: THIS CODE IS AUTOGENERATED.
// DO NOT EDIT!!!

#![allow(clippy::too_many_arguments)]
use serde::Serialize;

use crate::error::Result;
use crate::types::File;
use crate::Bot;

impl Bot {
    /// Use this method to get basic info about a file and prepare it for downloading. For the moment, bots can download files of up to 20MB in size. On success, a File object is returned. The file can then be downloaded via the link https://api.telegram.org/file/bot<token>/<file_path>, where <file_path> is taken from the response. It is guaranteed that the link will be valid for at least 1 hour. When the link expires, a new one can be requested by calling getFile again.
    /// Note: This function may not preserve the original file name and MIME type. You should save the file's MIME type and name (if available) when the File object is received.
    /// <https://core.telegram.org/bots/api#getfile>
    pub fn get_file(&self, file_id: String) -> GetFileBuilder {
        GetFileBuilder::new(self, file_id)
    }
}

#[derive(Serialize)]
pub struct GetFileBuilder<'a> {
    #[serde(skip)]
    bot: &'a Bot,
    /// File identifier to get info about
    pub file_id: String,
}

impl<'a> GetFileBuilder<'a> {
    pub fn new(bot: &'a Bot, file_id: String) -> Self {
        Self { bot, file_id }
    }

    pub fn file_id(mut self, file_id: String) -> Self {
        self.file_id = file_id;
        self
    }

    pub async fn send(self) -> Result<File> {
        let form = serde_json::to_value(&self)?;
        self.bot.get::<File>("getFile", Some(&form)).await
    }
}
