// WARNING: THIS CODE IS AUTOGENERATED.
// DO NOT EDIT!!!

#![allow(clippy::too_many_arguments)]
use serde::Serialize;

use crate::error::Result;
use crate::types::ChatMember;
use crate::Bot;

impl Bot {
    /// Use this method to get information about a member of a chat. Returns a ChatMember object on success.
    /// <https://core.telegram.org/bots/api#getchatmember>
    pub fn get_chat_member(&self, chat_id: i64, user_id: i64) -> GetChatMemberBuilder {
        GetChatMemberBuilder::new(self, chat_id, user_id)
    }
}

#[derive(Serialize)]
pub struct GetChatMemberBuilder<'a> {
    #[serde(skip)]
    bot: &'a Bot,
    /// Unique identifier for the target chat or username of the target supergroup or channel (in the format @channelusername)
    pub chat_id: i64,
    /// Unique identifier of the target user
    pub user_id: i64,
}

impl<'a> GetChatMemberBuilder<'a> {
    pub fn new(bot: &'a Bot, chat_id: i64, user_id: i64) -> Self {
        Self {
            bot,
            chat_id,
            user_id,
        }
    }

    pub fn chat_id(mut self, chat_id: i64) -> Self {
        self.chat_id = chat_id;
        self
    }

    pub fn user_id(mut self, user_id: i64) -> Self {
        self.user_id = user_id;
        self
    }

    pub async fn send(self) -> Result<ChatMember> {
        let form = serde_json::to_value(&self)?;
        self.bot
            .get::<ChatMember>("getChatMember", Some(&form))
            .await
    }
}
