// WARNING: THIS CODE IS AUTOGENERATED.
// DO NOT EDIT!!!

#![allow(clippy::too_many_arguments)]
use serde::Serialize;

use crate::error::Result;
use crate::types::Message;
use crate::Bot;

impl Bot {
    /// Use this method to forward messages of any kind. Service messages can't be forwarded. On success, the sent Message is returned.
    /// <https://core.telegram.org/bots/api#forwardmessage>
    pub fn forward_message(
        &self,
        chat_id: i64,
        from_chat_id: i64,
        message_id: i64,
    ) -> ForwardMessageBuilder {
        ForwardMessageBuilder::new(self, chat_id, from_chat_id, message_id)
    }
}

#[derive(Serialize)]
pub struct ForwardMessageBuilder<'a> {
    #[serde(skip)]
    bot: &'a Bot,
    /// Unique identifier for the target chat or username of the target channel (in the format @channelusername)
    pub chat_id: i64,
    /// Unique identifier for the chat where the original message was sent (or channel username in the format @channelusername)
    pub from_chat_id: i64,
    /// Sends the message silently. Users will receive a notification with no sound.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub disable_notification: Option<bool>,
    /// Protects the contents of the forwarded message from forwarding and saving
    #[serde(skip_serializing_if = "Option::is_none")]
    pub protect_content: Option<bool>,
    /// Message identifier in the chat specified in from_chat_id
    pub message_id: i64,
}

impl<'a> ForwardMessageBuilder<'a> {
    pub fn new(bot: &'a Bot, chat_id: i64, from_chat_id: i64, message_id: i64) -> Self {
        Self {
            bot,
            chat_id,
            from_chat_id,
            disable_notification: None,
            protect_content: None,
            message_id,
        }
    }

    pub fn chat_id(mut self, chat_id: i64) -> Self {
        self.chat_id = chat_id;
        self
    }

    pub fn from_chat_id(mut self, from_chat_id: i64) -> Self {
        self.from_chat_id = from_chat_id;
        self
    }

    pub fn disable_notification(mut self, disable_notification: bool) -> Self {
        self.disable_notification = Some(disable_notification);
        self
    }

    pub fn protect_content(mut self, protect_content: bool) -> Self {
        self.protect_content = Some(protect_content);
        self
    }

    pub fn message_id(mut self, message_id: i64) -> Self {
        self.message_id = message_id;
        self
    }

    pub async fn send(self) -> Result<Message> {
        let form = serde_json::to_value(&self)?;
        self.bot.get::<Message>("forwardMessage", Some(&form)).await
    }
}
