// WARNING: THIS CODE IS AUTOGENERATED.
// DO NOT EDIT!!!

#![allow(clippy::too_many_arguments)]
use serde::Serialize;

use crate::error::Result;
use crate::Bot;

impl Bot {
    /// Use this method to generate a new primary invite link for a chat; any previously generated primary link is revoked. The bot must be an administrator in the chat for this to work and must have the appropriate administrator rights. Returns the new invite link as String on success.
    /// <https://core.telegram.org/bots/api#exportchatinvitelink>
    pub fn export_chat_invite_link(&self, chat_id: i64) -> ExportChatInviteLinkBuilder {
        ExportChatInviteLinkBuilder::new(self, chat_id)
    }
}

#[derive(Serialize)]
pub struct ExportChatInviteLinkBuilder<'a> {
    #[serde(skip)]
    bot: &'a Bot,
    /// Unique identifier for the target chat or username of the target channel (in the format @channelusername)
    pub chat_id: i64,
}

impl<'a> ExportChatInviteLinkBuilder<'a> {
    pub fn new(bot: &'a Bot, chat_id: i64) -> Self {
        Self { bot, chat_id }
    }

    pub fn chat_id(mut self, chat_id: i64) -> Self {
        self.chat_id = chat_id;
        self
    }

    pub async fn send(self) -> Result<String> {
        let form = serde_json::to_value(&self)?;
        self.bot
            .get::<String>("exportChatInviteLink", Some(&form))
            .await
    }
}
