// WARNING: THIS CODE IS AUTOGENERATED.
// DO NOT EDIT!!!

#![allow(clippy::too_many_arguments)]
use serde::Serialize;

use crate::error::Result;
use crate::Bot;

impl Bot {
    /// Use this method to delete a message, including service messages, with the following limitations:- A message can only be deleted if it was sent less than 48 hours ago.- A dice message in a private chat can only be deleted if it was sent more than 24 hours ago.- Bots can delete outgoing messages in private chats, groups, and supergroups.- Bots can delete incoming messages in private chats.- Bots granted can_post_messages permissions can delete outgoing messages in channels.- If the bot is an administrator of a group, it can delete any message there.- If the bot has can_delete_messages permission in a supergroup or a channel, it can delete any message there.Returns True on success.
    /// <https://core.telegram.org/bots/api#deletemessage>
    pub fn delete_message(&self, chat_id: i64, message_id: i64) -> DeleteMessageBuilder {
        DeleteMessageBuilder::new(self, chat_id, message_id)
    }
}

#[derive(Serialize)]
pub struct DeleteMessageBuilder<'a> {
    #[serde(skip)]
    bot: &'a Bot,
    /// Unique identifier for the target chat or username of the target channel (in the format @channelusername)
    pub chat_id: i64,
    /// Identifier of the message to delete
    pub message_id: i64,
}

impl<'a> DeleteMessageBuilder<'a> {
    pub fn new(bot: &'a Bot, chat_id: i64, message_id: i64) -> Self {
        Self {
            bot,
            chat_id,
            message_id,
        }
    }

    pub fn chat_id(mut self, chat_id: i64) -> Self {
        self.chat_id = chat_id;
        self
    }

    pub fn message_id(mut self, message_id: i64) -> Self {
        self.message_id = message_id;
        self
    }

    pub async fn send(self) -> Result<bool> {
        let form = serde_json::to_value(&self)?;
        self.bot.get::<bool>("deleteMessage", Some(&form)).await
    }
}
