// WARNING: THIS CODE IS AUTOGENERATED.
// DO NOT EDIT!!!

#![allow(clippy::too_many_arguments)]
use serde::Serialize;

use crate::error::Result;
use crate::Bot;

impl Bot {
    /// Use this method to decline a chat join request. The bot must be an administrator in the chat for this to work and must have the can_invite_users administrator right. Returns True on success.
    /// <https://core.telegram.org/bots/api#declinechatjoinrequest>
    pub fn decline_chat_join_request(
        &self,
        chat_id: i64,
        user_id: i64,
    ) -> DeclineChatJoinRequestBuilder {
        DeclineChatJoinRequestBuilder::new(self, chat_id, user_id)
    }
}

#[derive(Serialize)]
pub struct DeclineChatJoinRequestBuilder<'a> {
    #[serde(skip)]
    bot: &'a Bot,
    /// Unique identifier for the target chat or username of the target channel (in the format @channelusername)
    pub chat_id: i64,
    /// Unique identifier of the target user
    pub user_id: i64,
}

impl<'a> DeclineChatJoinRequestBuilder<'a> {
    pub fn new(bot: &'a Bot, chat_id: i64, user_id: i64) -> Self {
        Self {
            bot,
            chat_id,
            user_id,
        }
    }

    pub fn chat_id(mut self, chat_id: i64) -> Self {
        self.chat_id = chat_id;
        self
    }

    pub fn user_id(mut self, user_id: i64) -> Self {
        self.user_id = user_id;
        self
    }

    pub async fn send(self) -> Result<bool> {
        let form = serde_json::to_value(&self)?;
        self.bot
            .get::<bool>("declineChatJoinRequest", Some(&form))
            .await
    }
}
