// WARNING: THIS CODE IS AUTOGENERATED.
// DO NOT EDIT!!!

#![allow(clippy::too_many_arguments)]
use serde::Serialize;

use crate::error::Result;
use crate::Bot;

impl Bot {
    /// Once the user has confirmed their payment and shipping details, the Bot API sends the final confirmation in the form of an Update with the field pre_checkout_query. Use this method to respond to such pre-checkout queries. On success, True is returned. Note: The Bot API must receive an answer within 10 seconds after the pre-checkout query was sent.
    /// <https://core.telegram.org/bots/api#answerprecheckoutquery>
    pub fn answer_pre_checkout_query(
        &self,
        pre_checkout_query_id: String,
        ok: bool,
    ) -> AnswerPreCheckoutQueryBuilder {
        AnswerPreCheckoutQueryBuilder::new(self, pre_checkout_query_id, ok)
    }
}

#[derive(Serialize)]
pub struct AnswerPreCheckoutQueryBuilder<'a> {
    #[serde(skip)]
    bot: &'a Bot,
    /// Unique identifier for the query to be answered
    pub pre_checkout_query_id: String,
    /// Specify True if everything is alright (goods are available, etc.) and the bot is ready to proceed with the order. Use False if there are any problems.
    pub ok: bool,
    /// Required if ok is False. Error message in human readable form that explains the reason for failure to proceed with the checkout (e.g. "Sorry, somebody just bought the last of our amazing black T-shirts while you were busy filling out your payment details. Please choose a different color or garment!"). Telegram will display this message to the user.
    #[serde(skip_serializing_if = "Option::is_none")]
    pub error_message: Option<String>,
}

impl<'a> AnswerPreCheckoutQueryBuilder<'a> {
    pub fn new(bot: &'a Bot, pre_checkout_query_id: String, ok: bool) -> Self {
        Self {
            bot,
            pre_checkout_query_id,
            ok,
            error_message: None,
        }
    }

    pub fn pre_checkout_query_id(mut self, pre_checkout_query_id: String) -> Self {
        self.pre_checkout_query_id = pre_checkout_query_id;
        self
    }

    pub fn ok(mut self, ok: bool) -> Self {
        self.ok = ok;
        self
    }

    pub fn error_message(mut self, error_message: String) -> Self {
        self.error_message = Some(error_message);
        self
    }

    pub async fn send(self) -> Result<bool> {
        let form = serde_json::to_value(&self)?;
        self.bot
            .get::<bool>("answerPreCheckoutQuery", Some(&form))
            .await
    }
}
