/// submodule to make the code more like java
pub mod conf {
    use serde::Deserialize;
    use std::fs::File;
    use std::io::{Error, Read};
    use toml;

    #[derive(Deserialize)]
    /// struct for representing a configuration for this bot
    pub struct Config {
        pub token: String,
        pub moderation: Option<bool>,
        pub leveling: Option<bool>,
        pub moderating: Option<ModerationSettings>,
    }

    #[derive(Deserialize)]
    /// struct for moderation settings
    pub struct ModerationSettings {
        pub enablebl: Option<bool>,
        pub blacklist: Option<Vec<String>>,
        pub modrole: u64,
    }

    /// Try to load a configuration file
    ///
    /// # Arguments
    ///
    /// * `path` - the path to the config file
    ///
    /// # Return
    ///
    /// returns a Result of `Config` and `std::io::Error`
    pub fn load_config(path: &str) -> Result<Config, Error> {
        let mut file: File = match File::open(path) {
            Ok(f) => f,
            Err(e) => {
                return Err(e);
            }
        };
        let mut contents: String = String::new();
        match file.read_to_string(&mut contents) {
            Ok(_n) => (),
            Err(e) => {
                return Err(e);
            }
        }
        let cfg: Config = toml::from_str(contents.as_str()).unwrap();
        Ok(cfg)
    }
}

/// some values for commands etc.
pub mod val {
    pub const VERSION: &str = "0.2.4";
}
