//! ferris bot is a discord bot written in rust.
//! this library contains some basic things for the bot like commands.
//! you should refer to this documentation if you want to extend the bot.
//! since the bot uses [serenity](https://crates.io/crates/serenity) you should also refer to
//! [its documentation](https://docs.rs/serenity).
//! 
//! # Examples
//!
//! loading a config file
//! ```rust
//! use ferris_bot::config::conf::load_config;
//! 
//! fn main() {
//!     let config = load_config("config.toml").unwrap();
//! }
//! ```

pub mod cmd;
pub mod config;

#[cfg(test)]
mod tests {
    use crate::config::conf::load_config;
    #[test]
    fn read_conf() {
        assert!(load_config("example_config.toml").is_ok());
    }
}
